// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon Elasticsearch Service.
//
// Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive
// key value pairs. An Elasticsearch domain may have up to 10 tags. See  Tagging
// Amazon Elasticsearch Service Domains for more information. (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelElasticsearchServiceSoftwareUpdate = "CancelElasticsearchServiceSoftwareUpdate"

// CancelElasticsearchServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the CancelElasticsearchServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelElasticsearchServiceSoftwareUpdate for more information on using the CancelElasticsearchServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelElasticsearchServiceSoftwareUpdateRequest method.
//    req, resp := client.CancelElasticsearchServiceSoftwareUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdateRequest(input *CancelElasticsearchServiceSoftwareUpdateInput) (req *request.Request, output *CancelElasticsearchServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opCancelElasticsearchServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/serviceSoftwareUpdate/cancel",
	}

	if input == nil {
		input = &CancelElasticsearchServiceSoftwareUpdateInput{}
	}

	output = &CancelElasticsearchServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelElasticsearchServiceSoftwareUpdate API operation for Amazon Elasticsearch Service.
//
// Cancels a scheduled service software update for an Amazon ES domain. You
// can only perform this operation before the AutomatedUpdateDate and when the
// UpdateStatus is in the PENDING_UPDATE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CancelElasticsearchServiceSoftwareUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdate(input *CancelElasticsearchServiceSoftwareUpdateInput) (*CancelElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelElasticsearchServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// CancelElasticsearchServiceSoftwareUpdateWithContext is the same as CancelElasticsearchServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See CancelElasticsearchServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CancelElasticsearchServiceSoftwareUpdateWithContext(ctx aws.Context, input *CancelElasticsearchServiceSoftwareUpdateInput, opts ...request.Option) (*CancelElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.CancelElasticsearchServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateElasticsearchDomain = "CreateElasticsearchDomain"

// CreateElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateElasticsearchDomain for more information on using the CreateElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateElasticsearchDomainRequest method.
//    req, resp := client.CreateElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) CreateElasticsearchDomainRequest(input *CreateElasticsearchDomainInput) (req *request.Request, output *CreateElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opCreateElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain",
	}

	if input == nil {
		input = &CreateElasticsearchDomainInput{}
	}

	output = &CreateElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Creates a new Elasticsearch domain. For more information, see Creating Elasticsearch
// Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
// in the Amazon Elasticsearch Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreateElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) CreateElasticsearchDomain(input *CreateElasticsearchDomainInput) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	return out, req.Send()
}

// CreateElasticsearchDomainWithContext is the same as CreateElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CreateElasticsearchDomainWithContext(ctx aws.Context, input *CreateElasticsearchDomainInput, opts ...request.Option) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteElasticsearchDomain = "DeleteElasticsearchDomain"

// DeleteElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteElasticsearchDomain for more information on using the DeleteElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteElasticsearchDomainRequest method.
//    req, resp := client.DeleteElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DeleteElasticsearchDomainRequest(input *DeleteElasticsearchDomainInput) (req *request.Request, output *DeleteElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteElasticsearchDomainInput{}
	}

	output = &DeleteElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Permanently deletes the specified Elasticsearch domain and all of its data.
// Once a domain is deleted, it cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DeleteElasticsearchDomain(input *DeleteElasticsearchDomainInput) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DeleteElasticsearchDomainWithContext is the same as DeleteElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteElasticsearchDomainWithContext(ctx aws.Context, input *DeleteElasticsearchDomainInput, opts ...request.Option) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteElasticsearchServiceRole = "DeleteElasticsearchServiceRole"

// DeleteElasticsearchServiceRoleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchServiceRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteElasticsearchServiceRole for more information on using the DeleteElasticsearchServiceRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteElasticsearchServiceRoleRequest method.
//    req, resp := client.DeleteElasticsearchServiceRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DeleteElasticsearchServiceRoleRequest(input *DeleteElasticsearchServiceRoleInput) (req *request.Request, output *DeleteElasticsearchServiceRoleOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchServiceRole,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/role",
	}

	if input == nil {
		input = &DeleteElasticsearchServiceRoleInput{}
	}

	output = &DeleteElasticsearchServiceRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteElasticsearchServiceRole API operation for Amazon Elasticsearch Service.
//
// Deletes the service-linked role that Elasticsearch Service uses to manage
// and maintain VPC domains. Role deletion will fail if any existing VPC domains
// use the role. You must delete any such Elasticsearch domains before deleting
// the role. See Deleting Elasticsearch Service Role (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr)
// in VPC Endpoints for Amazon Elasticsearch Service Domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchServiceRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DeleteElasticsearchServiceRole(input *DeleteElasticsearchServiceRoleInput) (*DeleteElasticsearchServiceRoleOutput, error) {
	req, out := c.DeleteElasticsearchServiceRoleRequest(input)
	return out, req.Send()
}

// DeleteElasticsearchServiceRoleWithContext is the same as DeleteElasticsearchServiceRole with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteElasticsearchServiceRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteElasticsearchServiceRoleWithContext(ctx aws.Context, input *DeleteElasticsearchServiceRoleInput, opts ...request.Option) (*DeleteElasticsearchServiceRoleOutput, error) {
	req, out := c.DeleteElasticsearchServiceRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomain = "DescribeElasticsearchDomain"

// DescribeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomain for more information on using the DescribeElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainRequest method.
//    req, resp := client.DescribeElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainRequest(input *DescribeElasticsearchDomainInput) (req *request.Request, output *DescribeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainInput{}
	}

	output = &DescribeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domain, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomain(input *DescribeElasticsearchDomainInput) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainWithContext is the same as DescribeElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainWithContext(ctx aws.Context, input *DescribeElasticsearchDomainInput, opts ...request.Option) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomainConfig = "DescribeElasticsearchDomainConfig"

// DescribeElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomainConfig for more information on using the DescribeElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainConfigRequest method.
//    req, resp := client.DescribeElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigRequest(input *DescribeElasticsearchDomainConfigInput) (req *request.Request, output *DescribeElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainConfigInput{}
	}

	output = &DescribeElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Provides cluster configuration information about the specified Elasticsearch
// domain, such as the state, creation date, update version, and update date
// for cluster options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomainConfig(input *DescribeElasticsearchDomainConfigInput) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainConfigWithContext is the same as DescribeElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigWithContext(ctx aws.Context, input *DescribeElasticsearchDomainConfigInput, opts ...request.Option) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomains = "DescribeElasticsearchDomains"

// DescribeElasticsearchDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomains for more information on using the DescribeElasticsearchDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainsRequest method.
//    req, resp := client.DescribeElasticsearchDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainsRequest(input *DescribeElasticsearchDomainsInput) (req *request.Request, output *DescribeElasticsearchDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain-info",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainsInput{}
	}

	output = &DescribeElasticsearchDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomains API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domains, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomains(input *DescribeElasticsearchDomainsInput) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainsWithContext is the same as DescribeElasticsearchDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainsWithContext(ctx aws.Context, input *DescribeElasticsearchDomainsInput, opts ...request.Option) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchInstanceTypeLimits = "DescribeElasticsearchInstanceTypeLimits"

// DescribeElasticsearchInstanceTypeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchInstanceTypeLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchInstanceTypeLimits for more information on using the DescribeElasticsearchInstanceTypeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchInstanceTypeLimitsRequest method.
//    req, resp := client.DescribeElasticsearchInstanceTypeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsRequest(input *DescribeElasticsearchInstanceTypeLimitsInput) (req *request.Request, output *DescribeElasticsearchInstanceTypeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchInstanceTypeLimits,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
	}

	if input == nil {
		input = &DescribeElasticsearchInstanceTypeLimitsInput{}
	}

	output = &DescribeElasticsearchInstanceTypeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchInstanceTypeLimits API operation for Amazon Elasticsearch Service.
//
// Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion.
// When modifying existing Domain, specify the DomainName to know what Limits
// are supported for modifying.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchInstanceTypeLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimits(input *DescribeElasticsearchInstanceTypeLimitsInput) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchInstanceTypeLimitsWithContext is the same as DescribeElasticsearchInstanceTypeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchInstanceTypeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsWithContext(ctx aws.Context, input *DescribeElasticsearchInstanceTypeLimitsInput, opts ...request.Option) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedElasticsearchInstanceOfferings = "DescribeReservedElasticsearchInstanceOfferings"

// DescribeReservedElasticsearchInstanceOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedElasticsearchInstanceOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedElasticsearchInstanceOfferings for more information on using the DescribeReservedElasticsearchInstanceOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedElasticsearchInstanceOfferingsRequest method.
//    req, resp := client.DescribeReservedElasticsearchInstanceOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsRequest(input *DescribeReservedElasticsearchInstanceOfferingsInput) (req *request.Request, output *DescribeReservedElasticsearchInstanceOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedElasticsearchInstanceOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/reservedInstanceOfferings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedElasticsearchInstanceOfferingsInput{}
	}

	output = &DescribeReservedElasticsearchInstanceOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedElasticsearchInstanceOfferings API operation for Amazon Elasticsearch Service.
//
// Lists available reserved Elasticsearch instance offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeReservedElasticsearchInstanceOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferings(input *DescribeReservedElasticsearchInstanceOfferingsInput) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstanceOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstanceOfferingsWithContext is the same as DescribeReservedElasticsearchInstanceOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedElasticsearchInstanceOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstanceOfferingsInput, opts ...request.Option) (*DescribeReservedElasticsearchInstanceOfferingsOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstanceOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstanceOfferingsPages iterates over the pages of a DescribeReservedElasticsearchInstanceOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedElasticsearchInstanceOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedElasticsearchInstanceOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedElasticsearchInstanceOfferingsPages(params,
//        func(page *DescribeReservedElasticsearchInstanceOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsPages(input *DescribeReservedElasticsearchInstanceOfferingsInput, fn func(*DescribeReservedElasticsearchInstanceOfferingsOutput, bool) bool) error {
	return c.DescribeReservedElasticsearchInstanceOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedElasticsearchInstanceOfferingsPagesWithContext same as DescribeReservedElasticsearchInstanceOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstanceOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstanceOfferingsInput, fn func(*DescribeReservedElasticsearchInstanceOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedElasticsearchInstanceOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedElasticsearchInstanceOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReservedElasticsearchInstanceOfferingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeReservedElasticsearchInstances = "DescribeReservedElasticsearchInstances"

// DescribeReservedElasticsearchInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedElasticsearchInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedElasticsearchInstances for more information on using the DescribeReservedElasticsearchInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedElasticsearchInstancesRequest method.
//    req, resp := client.DescribeReservedElasticsearchInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesRequest(input *DescribeReservedElasticsearchInstancesInput) (req *request.Request, output *DescribeReservedElasticsearchInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedElasticsearchInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/reservedInstances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedElasticsearchInstancesInput{}
	}

	output = &DescribeReservedElasticsearchInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedElasticsearchInstances API operation for Amazon Elasticsearch Service.
//
// Returns information about reserved Elasticsearch instances for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeReservedElasticsearchInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
func (c *ElasticsearchService) DescribeReservedElasticsearchInstances(input *DescribeReservedElasticsearchInstancesInput) (*DescribeReservedElasticsearchInstancesOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstancesWithContext is the same as DescribeReservedElasticsearchInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedElasticsearchInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstancesInput, opts ...request.Option) (*DescribeReservedElasticsearchInstancesOutput, error) {
	req, out := c.DescribeReservedElasticsearchInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedElasticsearchInstancesPages iterates over the pages of a DescribeReservedElasticsearchInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedElasticsearchInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedElasticsearchInstances operation.
//    pageNum := 0
//    err := client.DescribeReservedElasticsearchInstancesPages(params,
//        func(page *DescribeReservedElasticsearchInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesPages(input *DescribeReservedElasticsearchInstancesInput, fn func(*DescribeReservedElasticsearchInstancesOutput, bool) bool) error {
	return c.DescribeReservedElasticsearchInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedElasticsearchInstancesPagesWithContext same as DescribeReservedElasticsearchInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeReservedElasticsearchInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedElasticsearchInstancesInput, fn func(*DescribeReservedElasticsearchInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedElasticsearchInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedElasticsearchInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReservedElasticsearchInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetCompatibleElasticsearchVersions = "GetCompatibleElasticsearchVersions"

// GetCompatibleElasticsearchVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCompatibleElasticsearchVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCompatibleElasticsearchVersions for more information on using the GetCompatibleElasticsearchVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCompatibleElasticsearchVersionsRequest method.
//    req, resp := client.GetCompatibleElasticsearchVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) GetCompatibleElasticsearchVersionsRequest(input *GetCompatibleElasticsearchVersionsInput) (req *request.Request, output *GetCompatibleElasticsearchVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCompatibleElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/compatibleVersions",
	}

	if input == nil {
		input = &GetCompatibleElasticsearchVersionsInput{}
	}

	output = &GetCompatibleElasticsearchVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCompatibleElasticsearchVersions API operation for Amazon Elasticsearch Service.
//
// Returns a list of upgrade compatible Elastisearch versions. You can optionally
// pass a DomainName to get all upgrade compatible Elasticsearch versions for
// that specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetCompatibleElasticsearchVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) GetCompatibleElasticsearchVersions(input *GetCompatibleElasticsearchVersionsInput) (*GetCompatibleElasticsearchVersionsOutput, error) {
	req, out := c.GetCompatibleElasticsearchVersionsRequest(input)
	return out, req.Send()
}

// GetCompatibleElasticsearchVersionsWithContext is the same as GetCompatibleElasticsearchVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCompatibleElasticsearchVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetCompatibleElasticsearchVersionsWithContext(ctx aws.Context, input *GetCompatibleElasticsearchVersionsInput, opts ...request.Option) (*GetCompatibleElasticsearchVersionsOutput, error) {
	req, out := c.GetCompatibleElasticsearchVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUpgradeHistory = "GetUpgradeHistory"

// GetUpgradeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeHistory for more information on using the GetUpgradeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUpgradeHistoryRequest method.
//    req, resp := client.GetUpgradeHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) GetUpgradeHistoryRequest(input *GetUpgradeHistoryInput) (req *request.Request, output *GetUpgradeHistoryOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/upgradeDomain/{DomainName}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUpgradeHistoryInput{}
	}

	output = &GetUpgradeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeHistory API operation for Amazon Elasticsearch Service.
//
// Retrieves the complete history of the last 10 upgrades that were performed
// on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetUpgradeHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) GetUpgradeHistory(input *GetUpgradeHistoryInput) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	return out, req.Send()
}

// GetUpgradeHistoryWithContext is the same as GetUpgradeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeHistoryWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, opts ...request.Option) (*GetUpgradeHistoryOutput, error) {
	req, out := c.GetUpgradeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUpgradeHistoryPages iterates over the pages of a GetUpgradeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUpgradeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUpgradeHistory operation.
//    pageNum := 0
//    err := client.GetUpgradeHistoryPages(params,
//        func(page *GetUpgradeHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) GetUpgradeHistoryPages(input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool) error {
	return c.GetUpgradeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUpgradeHistoryPagesWithContext same as GetUpgradeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeHistoryPagesWithContext(ctx aws.Context, input *GetUpgradeHistoryInput, fn func(*GetUpgradeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUpgradeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUpgradeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetUpgradeHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetUpgradeStatus = "GetUpgradeStatus"

// GetUpgradeStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetUpgradeStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUpgradeStatus for more information on using the GetUpgradeStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUpgradeStatusRequest method.
//    req, resp := client.GetUpgradeStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) GetUpgradeStatusRequest(input *GetUpgradeStatusInput) (req *request.Request, output *GetUpgradeStatusOutput) {
	op := &request.Operation{
		Name:       opGetUpgradeStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/upgradeDomain/{DomainName}/status",
	}

	if input == nil {
		input = &GetUpgradeStatusInput{}
	}

	output = &GetUpgradeStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpgradeStatus API operation for Amazon Elasticsearch Service.
//
// Retrieves the latest status of the last upgrade or upgrade eligibility check
// that was performed on the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation GetUpgradeStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) GetUpgradeStatus(input *GetUpgradeStatusInput) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	return out, req.Send()
}

// GetUpgradeStatusWithContext is the same as GetUpgradeStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetUpgradeStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) GetUpgradeStatusWithContext(ctx aws.Context, input *GetUpgradeStatusInput, opts ...request.Option) (*GetUpgradeStatusOutput, error) {
	req, out := c.GetUpgradeStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainNames for more information on using the ListDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainNamesRequest method.
//    req, resp := client.ListDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon Elasticsearch Service.
//
// Returns the name of all Elasticsearch domains owned by the current user's
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	return out, req.Send()
}

// ListDomainNamesWithContext is the same as ListDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListDomainNamesWithContext(ctx aws.Context, input *ListDomainNamesInput, opts ...request.Option) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListElasticsearchInstanceTypes = "ListElasticsearchInstanceTypes"

// ListElasticsearchInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchInstanceTypes for more information on using the ListElasticsearchInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListElasticsearchInstanceTypesRequest method.
//    req, resp := client.ListElasticsearchInstanceTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListElasticsearchInstanceTypesRequest(input *ListElasticsearchInstanceTypesInput) (req *request.Request, output *ListElasticsearchInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchInstanceTypesInput{}
	}

	output = &ListElasticsearchInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchInstanceTypes API operation for Amazon Elasticsearch Service.
//
// List all Elasticsearch instance types that are supported for given ElasticsearchVersion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchInstanceTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListElasticsearchInstanceTypes(input *ListElasticsearchInstanceTypesInput) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesWithContext is the same as ListElasticsearchInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, opts ...request.Option) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesPages iterates over the pages of a ListElasticsearchInstanceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchInstanceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListElasticsearchInstanceTypes operation.
//    pageNum := 0
//    err := client.ListElasticsearchInstanceTypesPages(params,
//        func(page *ListElasticsearchInstanceTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPages(input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool) error {
	return c.ListElasticsearchInstanceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchInstanceTypesPagesWithContext same as ListElasticsearchInstanceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPagesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchInstanceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchInstanceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListElasticsearchInstanceTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListElasticsearchVersions = "ListElasticsearchVersions"

// ListElasticsearchVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchVersions for more information on using the ListElasticsearchVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListElasticsearchVersionsRequest method.
//    req, resp := client.ListElasticsearchVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListElasticsearchVersionsRequest(input *ListElasticsearchVersionsInput) (req *request.Request, output *ListElasticsearchVersionsOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchVersionsInput{}
	}

	output = &ListElasticsearchVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchVersions API operation for Amazon Elasticsearch Service.
//
// List all supported Elasticsearch versions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListElasticsearchVersions(input *ListElasticsearchVersionsInput) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	return out, req.Send()
}

// ListElasticsearchVersionsWithContext is the same as ListElasticsearchVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, opts ...request.Option) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchVersionsPages iterates over the pages of a ListElasticsearchVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListElasticsearchVersions operation.
//    pageNum := 0
//    err := client.ListElasticsearchVersionsPages(params,
//        func(page *ListElasticsearchVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) ListElasticsearchVersionsPages(input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool) error {
	return c.ListElasticsearchVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchVersionsPagesWithContext same as ListElasticsearchVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsPagesWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListElasticsearchVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon Elasticsearch Service.
//
// Returns all tags for the given Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedElasticsearchInstanceOffering = "PurchaseReservedElasticsearchInstanceOffering"

// PurchaseReservedElasticsearchInstanceOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedElasticsearchInstanceOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedElasticsearchInstanceOffering for more information on using the PurchaseReservedElasticsearchInstanceOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedElasticsearchInstanceOfferingRequest method.
//    req, resp := client.PurchaseReservedElasticsearchInstanceOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOfferingRequest(input *PurchaseReservedElasticsearchInstanceOfferingInput) (req *request.Request, output *PurchaseReservedElasticsearchInstanceOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedElasticsearchInstanceOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/purchaseReservedInstanceOffering",
	}

	if input == nil {
		input = &PurchaseReservedElasticsearchInstanceOfferingInput{}
	}

	output = &PurchaseReservedElasticsearchInstanceOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedElasticsearchInstanceOffering API operation for Amazon Elasticsearch Service.
//
// Allows you to purchase reserved Elasticsearch instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation PurchaseReservedElasticsearchInstanceOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOffering(input *PurchaseReservedElasticsearchInstanceOfferingInput) (*PurchaseReservedElasticsearchInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedElasticsearchInstanceOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedElasticsearchInstanceOfferingWithContext is the same as PurchaseReservedElasticsearchInstanceOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedElasticsearchInstanceOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) PurchaseReservedElasticsearchInstanceOfferingWithContext(ctx aws.Context, input *PurchaseReservedElasticsearchInstanceOfferingInput, opts ...request.Option) (*PurchaseReservedElasticsearchInstanceOfferingOutput, error) {
	req, out := c.PurchaseReservedElasticsearchInstanceOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon Elasticsearch Service.
//
// Removes the specified set of tags from the specified Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartElasticsearchServiceSoftwareUpdate = "StartElasticsearchServiceSoftwareUpdate"

// StartElasticsearchServiceSoftwareUpdateRequest generates a "aws/request.Request" representing the
// client's request for the StartElasticsearchServiceSoftwareUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartElasticsearchServiceSoftwareUpdate for more information on using the StartElasticsearchServiceSoftwareUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartElasticsearchServiceSoftwareUpdateRequest method.
//    req, resp := client.StartElasticsearchServiceSoftwareUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdateRequest(input *StartElasticsearchServiceSoftwareUpdateInput) (req *request.Request, output *StartElasticsearchServiceSoftwareUpdateOutput) {
	op := &request.Operation{
		Name:       opStartElasticsearchServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/serviceSoftwareUpdate/start",
	}

	if input == nil {
		input = &StartElasticsearchServiceSoftwareUpdateInput{}
	}

	output = &StartElasticsearchServiceSoftwareUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartElasticsearchServiceSoftwareUpdate API operation for Amazon Elasticsearch Service.
//
// Schedules a service software update for an Amazon ES domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation StartElasticsearchServiceSoftwareUpdate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdate(input *StartElasticsearchServiceSoftwareUpdateInput) (*StartElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.StartElasticsearchServiceSoftwareUpdateRequest(input)
	return out, req.Send()
}

// StartElasticsearchServiceSoftwareUpdateWithContext is the same as StartElasticsearchServiceSoftwareUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See StartElasticsearchServiceSoftwareUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) StartElasticsearchServiceSoftwareUpdateWithContext(ctx aws.Context, input *StartElasticsearchServiceSoftwareUpdateInput, opts ...request.Option) (*StartElasticsearchServiceSoftwareUpdateOutput, error) {
	req, out := c.StartElasticsearchServiceSoftwareUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateElasticsearchDomainConfig = "UpdateElasticsearchDomainConfig"

// UpdateElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateElasticsearchDomainConfig for more information on using the UpdateElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateElasticsearchDomainConfigRequest method.
//    req, resp := client.UpdateElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigRequest(input *UpdateElasticsearchDomainConfigInput) (req *request.Request, output *UpdateElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticsearchDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateElasticsearchDomainConfigInput{}
	}

	output = &UpdateElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Modifies the cluster configuration of the specified Elasticsearch domain,
// setting as setting the instance type and the number of instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpdateElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) UpdateElasticsearchDomainConfig(input *UpdateElasticsearchDomainConfigInput) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateElasticsearchDomainConfigWithContext is the same as UpdateElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigWithContext(ctx aws.Context, input *UpdateElasticsearchDomainConfigInput, opts ...request.Option) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpgradeElasticsearchDomain = "UpgradeElasticsearchDomain"

// UpgradeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpgradeElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpgradeElasticsearchDomain for more information on using the UpgradeElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpgradeElasticsearchDomainRequest method.
//    req, resp := client.UpgradeElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) UpgradeElasticsearchDomainRequest(input *UpgradeElasticsearchDomainInput) (req *request.Request, output *UpgradeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opUpgradeElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/upgradeDomain",
	}

	if input == nil {
		input = &UpgradeElasticsearchDomainInput{}
	}

	output = &UpgradeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpgradeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Allows you to either upgrade your domain or perform an Upgrade eligibility
// check to a compatible Elasticsearch version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpgradeElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) UpgradeElasticsearchDomain(input *UpgradeElasticsearchDomainInput) (*UpgradeElasticsearchDomainOutput, error) {
	req, out := c.UpgradeElasticsearchDomainRequest(input)
	return out, req.Send()
}

// UpgradeElasticsearchDomainWithContext is the same as UpgradeElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpgradeElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpgradeElasticsearchDomainWithContext(ctx aws.Context, input *UpgradeElasticsearchDomainInput, opts ...request.Option) (*UpgradeElasticsearchDomainOutput, error) {
	req, out := c.UpgradeElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the Elasticsearch domain. Access policies
	// may be resource-based, IP-based, or IAM-based. See  Configuring Access Policies
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddTags operation. Specify the tags that
// you want to attach to the Elasticsearch domain.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for which you want to add the tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// List of Tag that need to be added for the Elasticsearch domain.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// List of limits that are specific to a given InstanceType and for each of
// it's InstanceRole .
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	// Name of Additional Limit is specific to a given InstanceType and for each
	// of it's InstanceRole etc. Attributes and their details: MaximumNumberOfDataNodesSupported
	// This attribute will be present in Master node only to specify how much data
	// nodes upto which given ESPartitionInstanceTypecan support as master node. MaximumNumberOfDataNodesWithoutMasterNode
	// This attribute will be present in Data node only to specify how much data
	// nodes of given ESPartitionInstanceType
	LimitName *string `type:"string"`

	// Value for given AdditionalLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdditionalLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *AdditionalLimit) SetLimitName(v string) *AdditionalLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *AdditionalLimit) SetLimitValues(v []*string) *AdditionalLimit {
	s.LimitValues = v
	return s
}

// Status of the advanced options for the specified Elasticsearch domain. Currently,
// the following advanced options are available:
//
//    * Option to allow references to indices in an HTTP request body. Must
//    be false when configuring access to individual sub-resources. By default,
//    the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
//    for more information.
//    * Option to specify the percentage of heap space that is allocated to
//    field data. By default, this setting is unbounded.
// For more information, see Configuring Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters to the CancelElasticsearchServiceSoftwareUpdate
// operation. Specifies the name of the Elasticsearch domain that you wish to
// cancel a service software update on.
type CancelElasticsearchServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to stop the latest service software
	// update on.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelElasticsearchServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelElasticsearchServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelElasticsearchServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelElasticsearchServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CancelElasticsearchServiceSoftwareUpdateInput) SetDomainName(v string) *CancelElasticsearchServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a CancelElasticsearchServiceSoftwareUpdate operation. Contains
// the status of the update.
type CancelElasticsearchServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation
func (s CancelElasticsearchServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelElasticsearchServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *CancelElasticsearchServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *CancelElasticsearchServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// Options to specify the Cognito user and identity pools for Kibana authentication.
// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
type CognitoOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Cognito for Kibana authentication.
	Enabled *bool `type:"boolean"`

	// Specifies the Cognito identity pool ID for Kibana authentication.
	IdentityPoolId *string `min:"1" type:"string"`

	// Specifies the role ARN that provides Elasticsearch permissions for accessing
	// Cognito resources.
	RoleArn *string `min:"20" type:"string"`

	// Specifies the Cognito user pool ID for Kibana authentication.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CognitoOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CognitoOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoOptions"}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CognitoOptions) SetEnabled(v bool) *CognitoOptions {
	s.Enabled = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *CognitoOptions) SetIdentityPoolId(v string) *CognitoOptions {
	s.IdentityPoolId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CognitoOptions) SetRoleArn(v string) *CognitoOptions {
	s.RoleArn = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *CognitoOptions) SetUserPoolId(v string) *CognitoOptions {
	s.UserPoolId = &v
	return s
}

// Status of the Cognito options for the specified Elasticsearch domain.
type CognitoOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Cognito options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *CognitoOptions `type:"structure" required:"true"`

	// Specifies the status of the Cognito options for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s CognitoOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CognitoOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *CognitoOptionsStatus) SetOptions(v *CognitoOptions) *CognitoOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CognitoOptionsStatus) SetStatus(v *OptionStatus) *CognitoOptionsStatus {
	s.Status = v
	return s
}

// A map from an ElasticsearchVersion to a list of compatible ElasticsearchVersion
// s to which the domain can be upgraded.
type CompatibleVersionsMap struct {
	_ struct{} `type:"structure"`

	// The current version of Elasticsearch on which a domain is.
	SourceVersion *string `type:"string"`

	// List of supported elastic search versions.
	TargetVersions []*string `type:"list"`
}

// String returns the string representation
func (s CompatibleVersionsMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompatibleVersionsMap) GoString() string {
	return s.String()
}

// SetSourceVersion sets the SourceVersion field's value.
func (s *CompatibleVersionsMap) SetSourceVersion(v string) *CompatibleVersionsMap {
	s.SourceVersion = &v
	return s
}

// SetTargetVersions sets the TargetVersions field's value.
func (s *CompatibleVersionsMap) SetTargetVersions(v []*string) *CompatibleVersionsMap {
	s.TargetVersions = v
	return s
}

type CreateElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value
	// is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Options to specify the Cognito user and identity pools for Kibana authentication.
	// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The name of the Elasticsearch domain that you are creating. Domain names
	// are unique across the domains owned by an account within an AWS region. Domain
	// names must start with a letter or number and can contain the following characters:
	// a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Options to enable, disable and specify the type and size of EBS storage volumes.
	EBSOptions *EBSOptions `type:"structure"`

	// Configuration options for an Elasticsearch domain. Specifies the instance
	// type and number of instances in the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain eg.
	// "1.5" or "2.3". For more information, see Creating Elasticsearch Domains
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
	// in the Amazon Elasticsearch Service Developer Guide.
	ElasticsearchVersion *string `type:"string"`

	// Specifies the Encryption At Rest Options.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of Elasticsearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Options to specify the subnets and security groups for VPC endpoint. For
	// more information, see Creating a VPC (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
	// in VPC Endpoints for Amazon Elasticsearch Service Domains
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRestOptions != nil {
		if err := s.EncryptionAtRestOptions.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRestOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateElasticsearchDomainInput) SetAccessPolicies(v string) *CreateElasticsearchDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAdvancedOptions(v map[string]*string) *CreateElasticsearchDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *CreateElasticsearchDomainInput) SetCognitoOptions(v *CognitoOptions) *CreateElasticsearchDomainInput {
	s.CognitoOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateElasticsearchDomainInput) SetDomainName(v string) *CreateElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEBSOptions(v *EBSOptions) *CreateElasticsearchDomainInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *CreateElasticsearchDomainInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchVersion(v string) *CreateElasticsearchDomainInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *CreateElasticsearchDomainInput {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *CreateElasticsearchDomainInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *CreateElasticsearchDomainInput {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *CreateElasticsearchDomainInput) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *CreateElasticsearchDomainInput {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateElasticsearchDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateElasticsearchDomainInput {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *CreateElasticsearchDomainInput) SetVPCOptions(v *VPCOptions) *CreateElasticsearchDomainInput {
	s.VPCOptions = v
	return s
}

// The result of a CreateElasticsearchDomain operation. Contains the status
// of the newly created Elasticsearch domain.
type CreateElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created Elasticsearch domain.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *CreateElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DeleteElasticsearchDomain operation.
// Specifies the name of the Elasticsearch domain that you want to delete.
type DeleteElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain that you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteElasticsearchDomainInput) SetDomainName(v string) *DeleteElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DeleteElasticsearchDomain request. Contains the status of
// the pending deletion, or no status if the domain and all of its resources
// have been deleted.
type DeleteElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the Elasticsearch domain being deleted.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DeleteElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

type DeleteElasticsearchServiceRoleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchServiceRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchServiceRoleInput) GoString() string {
	return s.String()
}

type DeleteElasticsearchServiceRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchServiceRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchServiceRoleOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeElasticsearchDomainConfig operation.
// Specifies the domain name for which you want configuration information.
type DescribeElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domain that you want to get information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainConfigInput) SetDomainName(v string) *DescribeElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomainConfig request. Contains the configuration
// information of the requested domain.
type DescribeElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The configuration information of the domain requested in the DescribeElasticsearchDomainConfig
	// request.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *DescribeElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomain operation.
type DescribeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainInput) SetDomainName(v string) *DescribeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomain request. Contains the status
// of the domain specified in the request.
type DescribeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch domain.
	//
	// DomainStatus is a required field
	DomainStatus *ElasticsearchDomainStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DescribeElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomains operation.
// By default, the API returns the status of all Elasticsearch domains.
type DescribeElasticsearchDomainsInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeElasticsearchDomainsInput) SetDomainNames(v []*string) *DescribeElasticsearchDomainsInput {
	s.DomainNames = v
	return s
}

// The result of a DescribeElasticsearchDomains request. Contains the status
// of the specified domains or all domains owned by the account.
type DescribeElasticsearchDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeElasticsearchDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []*ElasticsearchDomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeElasticsearchDomainsOutput) SetDomainStatusList(v []*ElasticsearchDomainStatus) *DescribeElasticsearchDomainsOutput {
	s.DomainStatusList = v
	return s
}

// Container for the parameters to DescribeElasticsearchInstanceTypeLimits operation.
type DescribeElasticsearchInstanceTypeLimitsInput struct {
	_ struct{} `type:"structure"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for Elasticsearch Limits for
	// existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which Limits are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// The instance type for an Elasticsearch cluster for which Elasticsearch Limits
	// are needed.
	//
	// InstanceType is a required field
	InstanceType *string `location:"uri" locationName:"InstanceType" type:"string" required:"true" enum:"ESPartitionInstanceType"`
}

// String returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchInstanceTypeLimitsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}
	if s.ElasticsearchVersion != nil && len(*s.ElasticsearchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ElasticsearchVersion", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetDomainName(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetElasticsearchVersion(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetInstanceType(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.InstanceType = &v
	return s
}

// Container for the parameters received from DescribeElasticsearchInstanceTypeLimits
// operation.
type DescribeElasticsearchInstanceTypeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Map of Role of the Instance and Limits that are applicable. Role performed
	// by given Instance in Elasticsearch can be one of the following: Data: If
	// the given InstanceType is used as Data node
	// Master: If the given InstanceType is used as Master node
	LimitsByRole map[string]*Limits `type:"map"`
}

// String returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsOutput) GoString() string {
	return s.String()
}

// SetLimitsByRole sets the LimitsByRole field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsOutput) SetLimitsByRole(v map[string]*Limits) *DescribeElasticsearchInstanceTypeLimitsOutput {
	s.LimitsByRole = v
	return s
}

// Container for parameters to DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsInput struct {
	_ struct{} `type:"structure"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	ReservedElasticsearchInstanceOfferingId *string `location:"querystring" locationName:"offeringId" type:"string"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstanceOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedElasticsearchInstanceOfferingsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetMaxResults(v int64) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetNextToken(v string) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsInput) SetReservedElasticsearchInstanceOfferingId(v string) *DescribeReservedElasticsearchInstanceOfferingsInput {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// Container for results from DescribeReservedElasticsearchInstanceOfferings
type DescribeReservedElasticsearchInstanceOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved Elasticsearch instance offerings
	ReservedElasticsearchInstanceOfferings []*ReservedElasticsearchInstanceOffering `type:"list"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstanceOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedElasticsearchInstanceOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsOutput) SetNextToken(v string) *DescribeReservedElasticsearchInstanceOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceOfferings sets the ReservedElasticsearchInstanceOfferings field's value.
func (s *DescribeReservedElasticsearchInstanceOfferingsOutput) SetReservedElasticsearchInstanceOfferings(v []*ReservedElasticsearchInstanceOffering) *DescribeReservedElasticsearchInstanceOfferingsOutput {
	s.ReservedElasticsearchInstanceOfferings = v
	return s
}

// Container for parameters to DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesInput struct {
	_ struct{} `type:"structure"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The reserved instance identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reserved Elasticsearch instance
	// ID.
	ReservedElasticsearchInstanceId *string `location:"querystring" locationName:"reservationId" type:"string"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedElasticsearchInstancesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetMaxResults(v int64) *DescribeReservedElasticsearchInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetNextToken(v string) *DescribeReservedElasticsearchInstancesInput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *DescribeReservedElasticsearchInstancesInput) SetReservedElasticsearchInstanceId(v string) *DescribeReservedElasticsearchInstancesInput {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// Container for results from DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved Elasticsearch instances.
	ReservedElasticsearchInstances []*ReservedElasticsearchInstance `type:"list"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedElasticsearchInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReservedElasticsearchInstancesOutput) SetNextToken(v string) *DescribeReservedElasticsearchInstancesOutput {
	s.NextToken = &v
	return s
}

// SetReservedElasticsearchInstances sets the ReservedElasticsearchInstances field's value.
func (s *DescribeReservedElasticsearchInstancesOutput) SetReservedElasticsearchInstances(v []*ReservedElasticsearchInstance) *DescribeReservedElasticsearchInstancesOutput {
	s.ReservedElasticsearchInstances = v
	return s
}

type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the DomainName.
	DomainName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see  Configuring EBS-based Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// Specifies the volume type for EBS-based storage.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// Status of the EBS options for the specified Elasticsearch domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the EBS options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for the domain cluster, such as the type and
// number of instances.
type ElasticsearchClusterConfig struct {
	_ struct{} `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// About Dedicated Master Nodes (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an Elasticsearch cluster.
	InstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// A boolean value to indicate whether zone awareness is enabled. See About
	// Zone Awareness (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ElasticsearchClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfig) GoString() string {
	return s.String()
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterCount(v int64) *ElasticsearchClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterEnabled(v bool) *ElasticsearchClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterType(v string) *ElasticsearchClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ElasticsearchClusterConfig) SetInstanceCount(v int64) *ElasticsearchClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ElasticsearchClusterConfig) SetInstanceType(v string) *ElasticsearchClusterConfig {
	s.InstanceType = &v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ElasticsearchClusterConfig) SetZoneAwarenessEnabled(v bool) *ElasticsearchClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Specifies the configuration status for the specified Elasticsearch domain.
type ElasticsearchClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *ElasticsearchClusterConfig `type:"structure" required:"true"`

	// Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchClusterConfigStatus) SetOptions(v *ElasticsearchClusterConfig) *ElasticsearchClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchClusterConfigStatus) SetStatus(v *OptionStatus) *ElasticsearchClusterConfigStatus {
	s.Status = v
	return s
}

// The configuration of an Elasticsearch domain.
type ElasticsearchDomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Specifies the AdvancedOptions for the domain. See Configuring Advanced Options
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptionsStatus `type:"structure"`

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus `type:"structure"`

	// Specifies the EncryptionAtRestOptions for the Elasticsearch domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus `type:"structure"`

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus `type:"structure"`

	// Specifies the NodeToNodeEncryptionOptions for the Elasticsearch domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus `type:"structure"`

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfoStatus `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *ElasticsearchDomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *ElasticsearchDomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *ElasticsearchDomainConfig) SetCognitoOptions(v *CognitoOptionsStatus) *ElasticsearchDomainConfig {
	s.CognitoOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainConfig) SetEBSOptions(v *EBSOptionsStatus) *ElasticsearchDomainConfig {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfigStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchVersion(v *ElasticsearchVersionStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchVersion = v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *ElasticsearchDomainConfig) SetEncryptionAtRestOptions(v *EncryptionAtRestOptionsStatus) *ElasticsearchDomainConfig {
	s.EncryptionAtRestOptions = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *ElasticsearchDomainConfig) SetLogPublishingOptions(v *LogPublishingOptionsStatus) *ElasticsearchDomainConfig {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *ElasticsearchDomainConfig) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptionsStatus) *ElasticsearchDomainConfig {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *ElasticsearchDomainConfig {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *ElasticsearchDomainConfig) SetVPCOptions(v *VPCDerivedInfoStatus) *ElasticsearchDomainConfig {
	s.VPCOptions = v
	return s
}

// The current status of an Elasticsearch domain.
type ElasticsearchDomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of an Elasticsearch domain. See Identifiers
	// for IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]*string `type:"map"`

	// The CognitoOptions for the specified domain. For more information, see Amazon
	// Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The domain creation status. True if the creation of an Elasticsearch domain
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The unique identifier for the specified Elasticsearch domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain. See Configuring EBS-based Storage
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
	// for more information.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances in the domain cluster.
	//
	// ElasticsearchClusterConfig is a required field
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure" required:"true"`

	ElasticsearchVersion *string `type:"string"`

	// Specifies the status of the EncryptionAtRestOptions.
	EncryptionAtRestOptions *EncryptionAtRestOptions `type:"structure"`

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string `type:"string"`

	// Map containing the Elasticsearch domain endpoints used to submit index and
	// search requests. Example key, value: 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]*string `type:"map"`

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Specifies the status of the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions `type:"structure"`

	// The status of the Elasticsearch domain configuration. True if Amazon Elasticsearch
	// Service is processing configuration changes. False if the configuration is
	// active.
	Processing *bool `type:"boolean"`

	// The current status of the Elasticsearch domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// The status of an Elasticsearch domain version upgrade. True if Amazon Elasticsearch
	// Service is undergoing a version upgrade. False if the configuration is active.
	UpgradeProcessing *bool `type:"boolean"`

	// The VPCOptions for the specified domain. For more information, see VPC Endpoints
	// for Amazon Elasticsearch Service Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
	VPCOptions *VPCDerivedInfo `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ElasticsearchDomainStatus) SetARN(v string) *ElasticsearchDomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainStatus) SetAccessPolicies(v string) *ElasticsearchDomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainStatus) SetAdvancedOptions(v map[string]*string) *ElasticsearchDomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *ElasticsearchDomainStatus) SetCognitoOptions(v *CognitoOptions) *ElasticsearchDomainStatus {
	s.CognitoOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *ElasticsearchDomainStatus) SetCreated(v bool) *ElasticsearchDomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ElasticsearchDomainStatus) SetDeleted(v bool) *ElasticsearchDomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *ElasticsearchDomainStatus) SetDomainId(v string) *ElasticsearchDomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ElasticsearchDomainStatus) SetDomainName(v string) *ElasticsearchDomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainStatus) SetEBSOptions(v *EBSOptions) *ElasticsearchDomainStatus {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *ElasticsearchDomainStatus {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchVersion(v string) *ElasticsearchDomainStatus {
	s.ElasticsearchVersion = &v
	return s
}

// SetEncryptionAtRestOptions sets the EncryptionAtRestOptions field's value.
func (s *ElasticsearchDomainStatus) SetEncryptionAtRestOptions(v *EncryptionAtRestOptions) *ElasticsearchDomainStatus {
	s.EncryptionAtRestOptions = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchDomainStatus) SetEndpoint(v string) *ElasticsearchDomainStatus {
	s.Endpoint = &v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *ElasticsearchDomainStatus) SetEndpoints(v map[string]*string) *ElasticsearchDomainStatus {
	s.Endpoints = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *ElasticsearchDomainStatus) SetLogPublishingOptions(v map[string]*LogPublishingOption) *ElasticsearchDomainStatus {
	s.LogPublishingOptions = v
	return s
}

// SetNodeToNodeEncryptionOptions sets the NodeToNodeEncryptionOptions field's value.
func (s *ElasticsearchDomainStatus) SetNodeToNodeEncryptionOptions(v *NodeToNodeEncryptionOptions) *ElasticsearchDomainStatus {
	s.NodeToNodeEncryptionOptions = v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *ElasticsearchDomainStatus) SetProcessing(v bool) *ElasticsearchDomainStatus {
	s.Processing = &v
	return s
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *ElasticsearchDomainStatus) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *ElasticsearchDomainStatus {
	s.ServiceSoftwareOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainStatus) SetSnapshotOptions(v *SnapshotOptions) *ElasticsearchDomainStatus {
	s.SnapshotOptions = v
	return s
}

// SetUpgradeProcessing sets the UpgradeProcessing field's value.
func (s *ElasticsearchDomainStatus) SetUpgradeProcessing(v bool) *ElasticsearchDomainStatus {
	s.UpgradeProcessing = &v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *ElasticsearchDomainStatus) SetVPCOptions(v *VPCDerivedInfo) *ElasticsearchDomainStatus {
	s.VPCOptions = v
	return s
}

// Status of the Elasticsearch version options for the specified Elasticsearch
// domain.
type ElasticsearchVersionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchVersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchVersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchVersionStatus) SetOptions(v string) *ElasticsearchVersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchVersionStatus) SetStatus(v *OptionStatus) *ElasticsearchVersionStatus {
	s.Status = v
	return s
}

// Specifies the Encryption At Rest Options.
type EncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the option to enable Encryption At Rest.
	Enabled *bool `type:"boolean"`

	// Specifies the KMS Key ID for Encryption At Rest options.
	KmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionAtRestOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRestOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRestOptions"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *EncryptionAtRestOptions) SetEnabled(v bool) *EncryptionAtRestOptions {
	s.Enabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionAtRestOptions) SetKmsKeyId(v string) *EncryptionAtRestOptions {
	s.KmsKeyId = &v
	return s
}

// Status of the Encryption At Rest options for the specified Elasticsearch
// domain.
type EncryptionAtRestOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Encryption At Rest options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *EncryptionAtRestOptions `type:"structure" required:"true"`

	// Specifies the status of the Encryption At Rest options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EncryptionAtRestOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionAtRestOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EncryptionAtRestOptionsStatus) SetOptions(v *EncryptionAtRestOptions) *EncryptionAtRestOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EncryptionAtRestOptionsStatus) SetStatus(v *OptionStatus) *EncryptionAtRestOptionsStatus {
	s.Status = v
	return s
}

// Container for request parameters to GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`
}

// String returns the string representation
func (s GetCompatibleElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCompatibleElasticsearchVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompatibleElasticsearchVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCompatibleElasticsearchVersionsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetCompatibleElasticsearchVersionsInput) SetDomainName(v string) *GetCompatibleElasticsearchVersionsInput {
	s.DomainName = &v
	return s
}

// Container for response returned by GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of compatible Elasticsearch versions returned as part of the GetCompatibleElasticsearchVersions
	// operation.
	CompatibleElasticsearchVersions []*CompatibleVersionsMap `type:"list"`
}

// String returns the string representation
func (s GetCompatibleElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCompatibleElasticsearchVersionsOutput) GoString() string {
	return s.String()
}

// SetCompatibleElasticsearchVersions sets the CompatibleElasticsearchVersions field's value.
func (s *GetCompatibleElasticsearchVersionsOutput) SetCompatibleElasticsearchVersions(v []*CompatibleVersionsMap) *GetCompatibleElasticsearchVersionsOutput {
	s.CompatibleElasticsearchVersions = v
	return s
}

// Container for request parameters to GetUpgradeHistory operation.
type GetUpgradeHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Set this value to limit the number of results returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetUpgradeHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUpgradeHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeHistoryInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeHistoryInput) SetDomainName(v string) *GetUpgradeHistoryInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUpgradeHistoryInput) SetMaxResults(v int64) *GetUpgradeHistoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryInput) SetNextToken(v string) *GetUpgradeHistoryInput {
	s.NextToken = &v
	return s
}

// Container for response returned by GetUpgradeHistory operation.
type GetUpgradeHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token that needs to be supplied to the next call to get the next
	// page of results
	NextToken *string `type:"string"`

	// A list of UpgradeHistory objects corresponding to each Upgrade or Upgrade
	// Eligibility Check performed on a domain returned as part of GetUpgradeHistoryResponse
	// object.
	UpgradeHistories []*UpgradeHistory `type:"list"`
}

// String returns the string representation
func (s GetUpgradeHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUpgradeHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUpgradeHistoryOutput) SetNextToken(v string) *GetUpgradeHistoryOutput {
	s.NextToken = &v
	return s
}

// SetUpgradeHistories sets the UpgradeHistories field's value.
func (s *GetUpgradeHistoryOutput) SetUpgradeHistories(v []*UpgradeHistory) *GetUpgradeHistoryOutput {
	s.UpgradeHistories = v
	return s
}

// Container for request parameters to GetUpgradeStatus operation.
type GetUpgradeStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUpgradeStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUpgradeStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUpgradeStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUpgradeStatusInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetUpgradeStatusInput) SetDomainName(v string) *GetUpgradeStatusInput {
	s.DomainName = &v
	return s
}

// Container for response returned by GetUpgradeStatus operation.
type GetUpgradeStatusOutput struct {
	_ struct{} `type:"structure"`

	// One of 4 statuses that a step can go through returned as part of the GetUpgradeStatusResponse
	// object. The status can take one of the following values: In Progress
	// Succeeded
	// Succeeded with Issues
	// Failed
	StepStatus *string `type:"string" enum:"UpgradeStatus"`

	// A string that describes the update briefly
	UpgradeName *string `type:"string"`

	// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through: PreUpgradeCheck
	// Snapshot
	// Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`
}

// String returns the string representation
func (s GetUpgradeStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUpgradeStatusOutput) GoString() string {
	return s.String()
}

// SetStepStatus sets the StepStatus field's value.
func (s *GetUpgradeStatusOutput) SetStepStatus(v string) *GetUpgradeStatusOutput {
	s.StepStatus = &v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeName(v string) *GetUpgradeStatusOutput {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *GetUpgradeStatusOutput) SetUpgradeStep(v string) *GetUpgradeStatusOutput {
	s.UpgradeStep = &v
	return s
}

// InstanceCountLimits represents the limits on number of instances that be
// created in Amazon Elasticsearch for given InstanceType.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// Maximum number of Instances that can be instantiated for given InstanceType.
	MaximumInstanceCount *int64 `type:"integer"`

	// Minimum number of Instances that can be instantiated for given InstanceType.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCountLimits) GoString() string {
	return s.String()
}

// SetMaximumInstanceCount sets the MaximumInstanceCount field's value.
func (s *InstanceCountLimits) SetMaximumInstanceCount(v int64) *InstanceCountLimits {
	s.MaximumInstanceCount = &v
	return s
}

// SetMinimumInstanceCount sets the MinimumInstanceCount field's value.
func (s *InstanceCountLimits) SetMinimumInstanceCount(v int64) *InstanceCountLimits {
	s.MinimumInstanceCount = &v
	return s
}

// InstanceLimits represents the list of instance related attributes that are
// available for given InstanceType.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// InstanceCountLimits represents the limits on number of instances that be
	// created in Amazon Elasticsearch for given InstanceType.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceLimits) GoString() string {
	return s.String()
}

// SetInstanceCountLimits sets the InstanceCountLimits field's value.
func (s *InstanceLimits) SetInstanceCountLimits(v *InstanceCountLimits) *InstanceLimits {
	s.InstanceCountLimits = v
	return s
}

// Limits for given InstanceType and for each of it's role. Limits contains following StorageTypes,   InstanceLimitsand AdditionalLimits
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given InstanceType and for
	// each of it's InstanceRole .
	AdditionalLimits []*AdditionalLimit `type:"list"`

	// InstanceLimits represents the list of instance related attributes that are
	// available for given InstanceType.
	InstanceLimits *InstanceLimits `type:"structure"`

	// StorageType represents the list of storage related types and attributes that
	// are available for given InstanceType.
	StorageTypes []*StorageType `type:"list"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Limits) GoString() string {
	return s.String()
}

// SetAdditionalLimits sets the AdditionalLimits field's value.
func (s *Limits) SetAdditionalLimits(v []*AdditionalLimit) *Limits {
	s.AdditionalLimits = v
	return s
}

// SetInstanceLimits sets the InstanceLimits field's value.
func (s *Limits) SetInstanceLimits(v *InstanceLimits) *Limits {
	s.InstanceLimits = v
	return s
}

// SetStorageTypes sets the StorageTypes field's value.
func (s *Limits) SetStorageTypes(v []*StorageType) *Limits {
	s.StorageTypes = v
	return s
}

type ListDomainNamesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// The result of a ListDomainNames operation. Contains the names of all Elasticsearch
// domains owned by this account.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// List of Elasticsearch domain names.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for the parameters to the ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesInput struct {
	_ struct{} `type:"structure"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for list of available Elasticsearch
	// instance types when modifying existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which list of supported elasticsearch instance
	// types are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 30 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchInstanceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListElasticsearchInstanceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListElasticsearchInstanceTypesInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}
	if s.ElasticsearchVersion != nil && len(*s.ElasticsearchVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ElasticsearchVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListElasticsearchInstanceTypesInput) SetDomainName(v string) *ListElasticsearchInstanceTypesInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ListElasticsearchInstanceTypesInput) SetElasticsearchVersion(v string) *ListElasticsearchInstanceTypesInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchInstanceTypesInput) SetMaxResults(v int64) *ListElasticsearchInstanceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesInput) SetNextToken(v string) *ListElasticsearchInstanceTypesInput {
	s.NextToken = &v
	return s
}

// Container for the parameters returned by ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// List of instance types supported by Amazon Elasticsearch service for given
	// ElasticsearchVersion
	ElasticsearchInstanceTypes []*string `type:"list"`

	// In case if there are more results available NextToken would be present, make
	// further request to the same API with received NextToken to paginate remaining
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchInstanceTypesOutput) GoString() string {
	return s.String()
}

// SetElasticsearchInstanceTypes sets the ElasticsearchInstanceTypes field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetElasticsearchInstanceTypes(v []*string) *ListElasticsearchInstanceTypesOutput {
	s.ElasticsearchInstanceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetNextToken(v string) *ListElasticsearchInstanceTypesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListElasticsearchVersions operation.
//  Use MaxResults to control the maximum number of results to retrieve in a
// single call.
//
//  Use NextToken in response to retrieve more results. If the received response
// does not contain a NextToken, then there are no more results to retrieve.
type ListElasticsearchVersionsInput struct {
	_ struct{} `type:"structure"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 10 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchVersionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchVersionsInput) SetMaxResults(v int64) *ListElasticsearchVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsInput) SetNextToken(v string) *ListElasticsearchVersionsInput {
	s.NextToken = &v
	return s
}

// Container for the parameters for response received from ListElasticsearchVersions
// operation.
type ListElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// List of supported elastic search versions.
	ElasticsearchVersions []*string `type:"list"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchVersionsOutput) GoString() string {
	return s.String()
}

// SetElasticsearchVersions sets the ElasticsearchVersions field's value.
func (s *ListElasticsearchVersionsOutput) SetElasticsearchVersions(v []*string) *ListElasticsearchVersionsOutput {
	s.ElasticsearchVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsOutput) SetNextToken(v string) *ListElasticsearchVersionsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListTags operation. Specify the ARN for
// the Elasticsearch domain to which the tags are attached that you want to
// view are attached.
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for the Elasticsearch domain to which the tags are attached
	// that you want to view.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The result of a ListTags operation. Contains tags for all requested Elasticsearch
// domains.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of Tag for the requested Elasticsearch domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Log Publishing option that is set for given domain. Attributes and their details: CloudWatchLogsLogGroupArn: ARN of the Cloudwatch
// log group to which log needs to be published.
// Enabled: Whether the log publishing for given log type is enabled or not
type LogPublishingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the Cloudwatch log group to which log needs to be published.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies whether given log publishing option is enabled or not.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s LogPublishingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogPublishingOption) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *LogPublishingOption) SetCloudWatchLogsLogGroupArn(v string) *LogPublishingOption {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LogPublishingOption) SetEnabled(v bool) *LogPublishingOption {
	s.Enabled = &v
	return s
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {
	_ struct{} `type:"structure"`

	// The log publishing options configured for the Elasticsearch domain.
	Options map[string]*LogPublishingOption `type:"map"`

	// The status of the log publishing options for the Elasticsearch domain. See
	// OptionStatus for the status information that's included.
	Status *OptionStatus `type:"structure"`
}

// String returns the string representation
func (s LogPublishingOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogPublishingOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *LogPublishingOptionsStatus) SetOptions(v map[string]*LogPublishingOption) *LogPublishingOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LogPublishingOptionsStatus) SetStatus(v *OptionStatus) *LogPublishingOptionsStatus {
	s.Status = v
	return s
}

// Specifies the node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Specify true to enable node-to-node encryption.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s NodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeToNodeEncryptionOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *NodeToNodeEncryptionOptions) SetEnabled(v bool) *NodeToNodeEncryptionOptions {
	s.Enabled = &v
	return s
}

// Status of the node-to-node encryption options for the specified Elasticsearch
// domain.
type NodeToNodeEncryptionOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the node-to-node encryption options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options *NodeToNodeEncryptionOptions `type:"structure" required:"true"`

	// Specifies the status of the node-to-node encryption options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s NodeToNodeEncryptionOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeToNodeEncryptionOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetOptions(v *NodeToNodeEncryptionOptions) *NodeToNodeEncryptionOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *NodeToNodeEncryptionOptionsStatus) SetStatus(v *OptionStatus) *NodeToNodeEncryptionOptionsStatus {
	s.Status = v
	return s
}

// Provides the current status of the entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells the creation date for the entity.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" required:"true"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the Elasticsearch domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// Timestamp which tells the last updated time for the entity.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" required:"true"`

	// Specifies the latest version for the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Container for parameters to PurchaseReservedElasticsearchInstanceOffering
type PurchaseReservedElasticsearchInstanceOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of Elasticsearch instances to reserve.
	InstanceCount *int64 `min:"1" type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// ReservationName is a required field
	ReservationName *string `min:"5" type:"string" required:"true"`

	// The ID of the reserved Elasticsearch instance offering to purchase.
	//
	// ReservedElasticsearchInstanceOfferingId is a required field
	ReservedElasticsearchInstanceOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedElasticsearchInstanceOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedElasticsearchInstanceOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedElasticsearchInstanceOfferingInput"}
	if s.InstanceCount != nil && *s.InstanceCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("InstanceCount", 1))
	}
	if s.ReservationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationName"))
	}
	if s.ReservationName != nil && len(*s.ReservationName) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationName", 5))
	}
	if s.ReservedElasticsearchInstanceOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedElasticsearchInstanceOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetInstanceCount(v int64) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.InstanceCount = &v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetReservationName(v string) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingInput) SetReservedElasticsearchInstanceOfferingId(v string) *PurchaseReservedElasticsearchInstanceOfferingInput {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// Represents the output of a PurchaseReservedElasticsearchInstanceOffering
// operation.
type PurchaseReservedElasticsearchInstanceOfferingOutput struct {
	_ struct{} `type:"structure"`

	// The customer-specified identifier used to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// Details of the reserved Elasticsearch instance which was purchased.
	ReservedElasticsearchInstanceId *string `type:"string"`
}

// String returns the string representation
func (s PurchaseReservedElasticsearchInstanceOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedElasticsearchInstanceOfferingOutput) GoString() string {
	return s.String()
}

// SetReservationName sets the ReservationName field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingOutput) SetReservationName(v string) *PurchaseReservedElasticsearchInstanceOfferingOutput {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *PurchaseReservedElasticsearchInstanceOfferingOutput) SetReservedElasticsearchInstanceId(v string) *PurchaseReservedElasticsearchInstanceOfferingOutput {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// Contains the specific price and frequency of a recurring charges for a reserved
// Elasticsearch instance, or for a reserved Elasticsearch instance offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Container for the parameters to the RemoveTags operation. Specify the ARN
// for the Elasticsearch domain from which you want to remove the specified
// TagKey.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN for the Elasticsearch domain from which you want to delete
	// the specified tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// Specifies the TagKey list which you want to remove from the Elasticsearch
	// domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Details of a reserved Elasticsearch instance.
type ReservedElasticsearchInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the Elasticsearch instance is reserved.
	Duration *int64 `type:"integer"`

	// The number of Elasticsearch instances that have been reserved.
	ElasticsearchInstanceCount *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The upfront fixed charge you will paid to purchase the specific reserved
	// Elasticsearch instance offering.
	FixedPrice *float64 `type:"double"`

	// The payment option as defined in the reserved Elasticsearch instance offering.
	PaymentOption *string `type:"string" enum:"ReservedElasticsearchInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The customer-specified identifier to track this reservation.
	ReservationName *string `min:"5" type:"string"`

	// The unique identifier for the reservation.
	ReservedElasticsearchInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved Elasticsearch instance.
	State *string `type:"string"`

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedElasticsearchInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedElasticsearchInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedElasticsearchInstance) SetCurrencyCode(v string) *ReservedElasticsearchInstance {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedElasticsearchInstance) SetDuration(v int64) *ReservedElasticsearchInstance {
	s.Duration = &v
	return s
}

// SetElasticsearchInstanceCount sets the ElasticsearchInstanceCount field's value.
func (s *ReservedElasticsearchInstance) SetElasticsearchInstanceCount(v int64) *ReservedElasticsearchInstance {
	s.ElasticsearchInstanceCount = &v
	return s
}

// SetElasticsearchInstanceType sets the ElasticsearchInstanceType field's value.
func (s *ReservedElasticsearchInstance) SetElasticsearchInstanceType(v string) *ReservedElasticsearchInstance {
	s.ElasticsearchInstanceType = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedElasticsearchInstance) SetFixedPrice(v float64) *ReservedElasticsearchInstance {
	s.FixedPrice = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedElasticsearchInstance) SetPaymentOption(v string) *ReservedElasticsearchInstance {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedElasticsearchInstance) SetRecurringCharges(v []*RecurringCharge) *ReservedElasticsearchInstance {
	s.RecurringCharges = v
	return s
}

// SetReservationName sets the ReservationName field's value.
func (s *ReservedElasticsearchInstance) SetReservationName(v string) *ReservedElasticsearchInstance {
	s.ReservationName = &v
	return s
}

// SetReservedElasticsearchInstanceId sets the ReservedElasticsearchInstanceId field's value.
func (s *ReservedElasticsearchInstance) SetReservedElasticsearchInstanceId(v string) *ReservedElasticsearchInstance {
	s.ReservedElasticsearchInstanceId = &v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *ReservedElasticsearchInstance) SetReservedElasticsearchInstanceOfferingId(v string) *ReservedElasticsearchInstance {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedElasticsearchInstance) SetStartTime(v time.Time) *ReservedElasticsearchInstance {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedElasticsearchInstance) SetState(v string) *ReservedElasticsearchInstance {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedElasticsearchInstance) SetUsagePrice(v float64) *ReservedElasticsearchInstance {
	s.UsagePrice = &v
	return s
}

// Details of a reserved Elasticsearch instance offering.
type ReservedElasticsearchInstanceOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved Elasticsearch instance offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the Elasticsearch
	// instance.
	Duration *int64 `type:"integer"`

	// The Elasticsearch instance type offered by the reserved instance offering.
	ElasticsearchInstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch
	// instance offering.
	FixedPrice *float64 `type:"double"`

	// Payment option for the reserved Elasticsearch instance offering
	PaymentOption *string `type:"string" enum:"ReservedElasticsearchInstancePaymentOption"`

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []*RecurringCharge `type:"list"`

	// The Elasticsearch reserved instance offering identifier.
	ReservedElasticsearchInstanceOfferingId *string `type:"string"`

	// The rate you are charged for each hour the domain that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedElasticsearchInstanceOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedElasticsearchInstanceOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedElasticsearchInstanceOffering) SetCurrencyCode(v string) *ReservedElasticsearchInstanceOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedElasticsearchInstanceOffering) SetDuration(v int64) *ReservedElasticsearchInstanceOffering {
	s.Duration = &v
	return s
}

// SetElasticsearchInstanceType sets the ElasticsearchInstanceType field's value.
func (s *ReservedElasticsearchInstanceOffering) SetElasticsearchInstanceType(v string) *ReservedElasticsearchInstanceOffering {
	s.ElasticsearchInstanceType = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedElasticsearchInstanceOffering) SetFixedPrice(v float64) *ReservedElasticsearchInstanceOffering {
	s.FixedPrice = &v
	return s
}

// SetPaymentOption sets the PaymentOption field's value.
func (s *ReservedElasticsearchInstanceOffering) SetPaymentOption(v string) *ReservedElasticsearchInstanceOffering {
	s.PaymentOption = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedElasticsearchInstanceOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedElasticsearchInstanceOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedElasticsearchInstanceOfferingId sets the ReservedElasticsearchInstanceOfferingId field's value.
func (s *ReservedElasticsearchInstanceOffering) SetReservedElasticsearchInstanceOfferingId(v string) *ReservedElasticsearchInstanceOffering {
	s.ReservedElasticsearchInstanceOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedElasticsearchInstanceOffering) SetUsagePrice(v float64) *ReservedElasticsearchInstanceOffering {
	s.UsagePrice = &v
	return s
}

// The current options of an Elasticsearch domain service software options.
type ServiceSoftwareOptions struct {
	_ struct{} `type:"structure"`

	// Timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time `type:"timestamp"`

	// True if you are able to cancel your service software version update. False
	// if you are not able to cancel your service software version.
	Cancellable *bool `type:"boolean"`

	// The current service software version that is present on the domain.
	CurrentVersion *string `type:"string"`

	// The description of the UpdateStatus.
	Description *string `type:"string"`

	// The new service software version if one is available.
	NewVersion *string `type:"string"`

	// True if you are able to update you service software version. False if you
	// are not able to update your service software version.
	UpdateAvailable *bool `type:"boolean"`

	// The status of your service software update. This field can take the following
	// values: ELIGIBLE, PENDING_UPDATE, IN_PROGRESS, COMPLETED, and NOT_ELIGIBLE.
	UpdateStatus *string `type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation
func (s ServiceSoftwareOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSoftwareOptions) GoString() string {
	return s.String()
}

// SetAutomatedUpdateDate sets the AutomatedUpdateDate field's value.
func (s *ServiceSoftwareOptions) SetAutomatedUpdateDate(v time.Time) *ServiceSoftwareOptions {
	s.AutomatedUpdateDate = &v
	return s
}

// SetCancellable sets the Cancellable field's value.
func (s *ServiceSoftwareOptions) SetCancellable(v bool) *ServiceSoftwareOptions {
	s.Cancellable = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ServiceSoftwareOptions) SetCurrentVersion(v string) *ServiceSoftwareOptions {
	s.CurrentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSoftwareOptions) SetDescription(v string) *ServiceSoftwareOptions {
	s.Description = &v
	return s
}

// SetNewVersion sets the NewVersion field's value.
func (s *ServiceSoftwareOptions) SetNewVersion(v string) *ServiceSoftwareOptions {
	s.NewVersion = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *ServiceSoftwareOptions) SetUpdateAvailable(v bool) *ServiceSoftwareOptions {
	s.UpdateAvailable = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *ServiceSoftwareOptions) SetUpdateStatus(v string) *ServiceSoftwareOptions {
	s.UpdateStatus = &v
	return s
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// Specifies the status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// Container for the parameters to the StartElasticsearchServiceSoftwareUpdate
// operation. Specifies the name of the Elasticsearch domain that you wish to
// schedule a service software update on.
type StartElasticsearchServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to update to the latest service software.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartElasticsearchServiceSoftwareUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartElasticsearchServiceSoftwareUpdateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *StartElasticsearchServiceSoftwareUpdateInput) SetDomainName(v string) *StartElasticsearchServiceSoftwareUpdateInput {
	s.DomainName = &v
	return s
}

// The result of a StartElasticsearchServiceSoftwareUpdate operation. Contains
// the status of the update.
type StartElasticsearchServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateOutput) GoString() string {
	return s.String()
}

// SetServiceSoftwareOptions sets the ServiceSoftwareOptions field's value.
func (s *StartElasticsearchServiceSoftwareUpdateOutput) SetServiceSoftwareOptions(v *ServiceSoftwareOptions) *StartElasticsearchServiceSoftwareUpdateOutput {
	s.ServiceSoftwareOptions = v
	return s
}

// StorageTypes represents the list of storage related types and their attributes
// that are available for given InstanceType.
type StorageType struct {
	_ struct{} `type:"structure"`

	// SubType of the given storage type. List of available sub-storage options:
	// For "instance" storageType we wont have any storageSubType, in case of "ebs"
	// storageType we will have following valid storageSubTypes standard
	// gp2
	// io1
	//  Refer VolumeType for more information regarding above EBS storage options.
	StorageSubTypeName *string `type:"string"`

	// List of limits that are applicable for given storage type.
	StorageTypeLimits []*StorageTypeLimit `type:"list"`

	// Type of the storage. List of available storage options: instance
	//  Inbuilt storage available for the given Instance ebs
	//  Elastic block storage that would be attached to the given Instance
	StorageTypeName *string `type:"string"`
}

// String returns the string representation
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageType) GoString() string {
	return s.String()
}

// SetStorageSubTypeName sets the StorageSubTypeName field's value.
func (s *StorageType) SetStorageSubTypeName(v string) *StorageType {
	s.StorageSubTypeName = &v
	return s
}

// SetStorageTypeLimits sets the StorageTypeLimits field's value.
func (s *StorageType) SetStorageTypeLimits(v []*StorageTypeLimit) *StorageType {
	s.StorageTypeLimits = v
	return s
}

// SetStorageTypeName sets the StorageTypeName field's value.
func (s *StorageType) SetStorageTypeName(v string) *StorageType {
	s.StorageTypeName = &v
	return s
}

// Limits that are applicable for given storage type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for given storage type. If StorageType
	// is ebs, following storage options are applicable MinimumVolumeSize
	//  Minimum amount of volume size that is applicable for given storage type.It
	// can be empty if it is not applicable. MaximumVolumeSize
	//  Maximum amount of volume size that is applicable for given storage type.It
	// can be empty if it is not applicable. MaximumIops
	//  Maximum amount of Iops that is applicable for given storage type.It can
	// be empty if it is not applicable. MinimumIops
	//  Minimum amount of Iops that is applicable for given storage type.It can
	// be empty if it is not applicable.
	LimitName *string `type:"string"`

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageTypeLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *StorageTypeLimit) SetLimitName(v string) *StorageTypeLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *StorageTypeLimit) SetLimitValues(v []*string) *StorageTypeLimit {
	s.LimitValues = v
	return s
}

// Specifies a key value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the TagKey, the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specifies the TagValue, the value assigned to the corresponding tag key.
	// Tag values can be null and do not have to be unique in a tag set. For example,
	// you can have a key value pair in a tag set of project : Trinity and cost-center
	// : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateElasticsearchDomain operation.
// Specifies the type and number of instances in the domain cluster.
type UpdateElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources.
	// By default, the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// Options to specify the Cognito user and identity pools for Kibana authentication.
	// For more information, see Amazon Cognito Authentication for Kibana (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html).
	CognitoOptions *CognitoOptions `type:"structure"`

	// The name of the Elasticsearch domain that you are updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Specify the type and size of the EBS volume that you want to use.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances to instantiate for the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// Map of LogType and LogPublishingOption, each containing options to publish
	// a given type of Elasticsearch log.
	LogPublishingOptions map[string]*LogPublishingOption `type:"map"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`

	// Options to specify the subnets and security groups for VPC endpoint. For
	// more information, see Creating a VPC (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-creating-vpc)
	// in VPC Endpoints for Amazon Elasticsearch Service Domains
	VPCOptions *VPCOptions `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.CognitoOptions != nil {
		if err := s.CognitoOptions.Validate(); err != nil {
			invalidParams.AddNested("CognitoOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAccessPolicies(v string) *UpdateElasticsearchDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateElasticsearchDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetCognitoOptions sets the CognitoOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetCognitoOptions(v *CognitoOptions) *UpdateElasticsearchDomainConfigInput {
	s.CognitoOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDomainName(v string) *UpdateElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateElasticsearchDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *UpdateElasticsearchDomainConfigInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetLogPublishingOptions sets the LogPublishingOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetLogPublishingOptions(v map[string]*LogPublishingOption) *UpdateElasticsearchDomainConfigInput {
	s.LogPublishingOptions = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateElasticsearchDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// SetVPCOptions sets the VPCOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetVPCOptions(v *VPCOptions) *UpdateElasticsearchDomainConfigInput {
	s.VPCOptions = v
	return s
}

// The result of an UpdateElasticsearchDomain request. Contains the status of
// the Elasticsearch domain being updated.
type UpdateElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated Elasticsearch domain.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *UpdateElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for request parameters to UpgradeElasticsearchDomain operation.
type UpgradeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// This flag, when set to True, indicates that an Upgrade Eligibility Check
	// needs to be performed. This will not actually perform the Upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of Elasticsearch that you intend to upgrade the domain to.
	//
	// TargetVersion is a required field
	TargetVersion *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpgradeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpgradeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpgradeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.TargetVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeElasticsearchDomainInput) SetDomainName(v string) *UpgradeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeElasticsearchDomainInput) SetPerformCheckOnly(v bool) *UpgradeElasticsearchDomainInput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeElasticsearchDomainInput) SetTargetVersion(v string) *UpgradeElasticsearchDomainInput {
	s.TargetVersion = &v
	return s
}

// Container for response returned by UpgradeElasticsearchDomain operation.
type UpgradeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	DomainName *string `min:"3" type:"string"`

	// This flag, when set to True, indicates that an Upgrade Eligibility Check
	// needs to be performed. This will not actually perform the Upgrade.
	PerformCheckOnly *bool `type:"boolean"`

	// The version of Elasticsearch that you intend to upgrade the domain to.
	TargetVersion *string `type:"string"`
}

// String returns the string representation
func (s UpgradeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *UpgradeElasticsearchDomainOutput) SetDomainName(v string) *UpgradeElasticsearchDomainOutput {
	s.DomainName = &v
	return s
}

// SetPerformCheckOnly sets the PerformCheckOnly field's value.
func (s *UpgradeElasticsearchDomainOutput) SetPerformCheckOnly(v bool) *UpgradeElasticsearchDomainOutput {
	s.PerformCheckOnly = &v
	return s
}

// SetTargetVersion sets the TargetVersion field's value.
func (s *UpgradeElasticsearchDomainOutput) SetTargetVersion(v string) *UpgradeElasticsearchDomainOutput {
	s.TargetVersion = &v
	return s
}

// History of the last 10 Upgrades and Upgrade Eligibility Checks.
type UpgradeHistory struct {
	_ struct{} `type:"structure"`

	// UTC Timestamp at which the Upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time `type:"timestamp"`

	// A list of UpgradeStepItem s representing information about each step performed
	// as pard of a specific Upgrade or Upgrade Eligibility Check.
	StepsList []*UpgradeStepItem `type:"list"`

	// A string that describes the update briefly
	UpgradeName *string `type:"string"`

	// The overall status of the update. The status can take one of the following
	// values: In Progress
	// Succeeded
	// Succeeded with Issues
	// Failed
	UpgradeStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation
func (s UpgradeHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeHistory) GoString() string {
	return s.String()
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *UpgradeHistory) SetStartTimestamp(v time.Time) *UpgradeHistory {
	s.StartTimestamp = &v
	return s
}

// SetStepsList sets the StepsList field's value.
func (s *UpgradeHistory) SetStepsList(v []*UpgradeStepItem) *UpgradeHistory {
	s.StepsList = v
	return s
}

// SetUpgradeName sets the UpgradeName field's value.
func (s *UpgradeHistory) SetUpgradeName(v string) *UpgradeHistory {
	s.UpgradeName = &v
	return s
}

// SetUpgradeStatus sets the UpgradeStatus field's value.
func (s *UpgradeHistory) SetUpgradeStatus(v string) *UpgradeHistory {
	s.UpgradeStatus = &v
	return s
}

// Represents a single step of the Upgrade or Upgrade Eligibility Check workflow.
type UpgradeStepItem struct {
	_ struct{} `type:"structure"`

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []*string `type:"list"`

	// The Floating point value representing progress percentage of a particular
	// step.
	ProgressPercent *float64 `type:"double"`

	// Represents one of 3 steps that an Upgrade or Upgrade Eligibility Check does
	// through: PreUpgradeCheck
	// Snapshot
	// Upgrade
	UpgradeStep *string `type:"string" enum:"UpgradeStep"`

	// The status of a particular step during an upgrade. The status can take one
	// of the following values: In Progress
	// Succeeded
	// Succeeded with Issues
	// Failed
	UpgradeStepStatus *string `type:"string" enum:"UpgradeStatus"`
}

// String returns the string representation
func (s UpgradeStepItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeStepItem) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *UpgradeStepItem) SetIssues(v []*string) *UpgradeStepItem {
	s.Issues = v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *UpgradeStepItem) SetProgressPercent(v float64) *UpgradeStepItem {
	s.ProgressPercent = &v
	return s
}

// SetUpgradeStep sets the UpgradeStep field's value.
func (s *UpgradeStepItem) SetUpgradeStep(v string) *UpgradeStepItem {
	s.UpgradeStep = &v
	return s
}

// SetUpgradeStepStatus sets the UpgradeStepStatus field's value.
func (s *UpgradeStepItem) SetUpgradeStepStatus(v string) *UpgradeStepItem {
	s.UpgradeStepStatus = &v
	return s
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see  VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCDerivedInfo struct {
	_ struct{} `type:"structure"`

	// The availability zones for the Elasticsearch domain. Exists only if the domain
	// was created with VPCOptions.
	AvailabilityZones []*string `type:"list"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []*string `type:"list"`

	// The VPC Id for the Elasticsearch domain. Exists only if the domain was created
	// with VPCOptions.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s VPCDerivedInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCDerivedInfo) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *VPCDerivedInfo) SetAvailabilityZones(v []*string) *VPCDerivedInfo {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCDerivedInfo) SetSecurityGroupIds(v []*string) *VPCDerivedInfo {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCDerivedInfo) SetSubnetIds(v []*string) *VPCDerivedInfo {
	s.SubnetIds = v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *VPCDerivedInfo) SetVPCId(v string) *VPCDerivedInfo {
	s.VPCId = &v
	return s
}

// Status of the VPC options for the specified Elasticsearch domain.
type VPCDerivedInfoStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the VPC options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *VPCDerivedInfo `type:"structure" required:"true"`

	// Specifies the status of the VPC options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s VPCDerivedInfoStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCDerivedInfoStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *VPCDerivedInfoStatus) SetOptions(v *VPCDerivedInfo) *VPCDerivedInfoStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VPCDerivedInfoStatus) SetStatus(v *OptionStatus) *VPCDerivedInfoStatus {
	s.Status = v
	return s
}

// Options to specify the subnets and security groups for VPC endpoint. For
// more information, see  VPC Endpoints for Amazon Elasticsearch Service Domains
// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html).
type VPCOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the security groups for VPC endpoint.
	SecurityGroupIds []*string `type:"list"`

	// Specifies the subnets for VPC endpoint.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VPCOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCOptions) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VPCOptions) SetSecurityGroupIds(v []*string) *VPCOptions {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VPCOptions) SetSubnetIds(v []*string) *VPCOptions {
	s.SubnetIds = v
	return s
}

const (
	// DeploymentStatusPendingUpdate is a DeploymentStatus enum value
	DeploymentStatusPendingUpdate = "PENDING_UPDATE"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusCompleted is a DeploymentStatus enum value
	DeploymentStatusCompleted = "COMPLETED"

	// DeploymentStatusNotEligible is a DeploymentStatus enum value
	DeploymentStatusNotEligible = "NOT_ELIGIBLE"

	// DeploymentStatusEligible is a DeploymentStatus enum value
	DeploymentStatusEligible = "ELIGIBLE"
)

const (
	// ESPartitionInstanceTypeM3MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3MediumElasticsearch = "m3.medium.elasticsearch"

	// ESPartitionInstanceTypeM3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3LargeElasticsearch = "m3.large.elasticsearch"

	// ESPartitionInstanceTypeM3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3XlargeElasticsearch = "m3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM32xlargeElasticsearch = "m3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4LargeElasticsearch = "m4.large.elasticsearch"

	// ESPartitionInstanceTypeM4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4XlargeElasticsearch = "m4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM42xlargeElasticsearch = "m4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM44xlargeElasticsearch = "m4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeM410xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM410xlargeElasticsearch = "m4.10xlarge.elasticsearch"

	// ESPartitionInstanceTypeT2MicroElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MicroElasticsearch = "t2.micro.elasticsearch"

	// ESPartitionInstanceTypeT2SmallElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2SmallElasticsearch = "t2.small.elasticsearch"

	// ESPartitionInstanceTypeT2MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MediumElasticsearch = "t2.medium.elasticsearch"

	// ESPartitionInstanceTypeR3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3LargeElasticsearch = "r3.large.elasticsearch"

	// ESPartitionInstanceTypeR3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3XlargeElasticsearch = "r3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR32xlargeElasticsearch = "r3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR34xlargeElasticsearch = "r3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR38xlargeElasticsearch = "r3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI2XlargeElasticsearch = "i2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI22xlargeElasticsearch = "i2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD2XlargeElasticsearch = "d2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeD22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD22xlargeElasticsearch = "d2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD24xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD24xlargeElasticsearch = "d2.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeD28xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD28xlargeElasticsearch = "d2.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeC4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4LargeElasticsearch = "c4.large.elasticsearch"

	// ESPartitionInstanceTypeC4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4XlargeElasticsearch = "c4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeC42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC42xlargeElasticsearch = "c4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeC44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC44xlargeElasticsearch = "c4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeC48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC48xlargeElasticsearch = "c4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4LargeElasticsearch = "r4.large.elasticsearch"

	// ESPartitionInstanceTypeR4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4XlargeElasticsearch = "r4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR42xlargeElasticsearch = "r4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR44xlargeElasticsearch = "r4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR48xlargeElasticsearch = "r4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR416xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR416xlargeElasticsearch = "r4.16xlarge.elasticsearch"

	// ESPartitionInstanceTypeI3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI3LargeElasticsearch = "i3.large.elasticsearch"

	// ESPartitionInstanceTypeI3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI3XlargeElasticsearch = "i3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI32xlargeElasticsearch = "i3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeI34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI34xlargeElasticsearch = "i3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeI38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI38xlargeElasticsearch = "i3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI316xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI316xlargeElasticsearch = "i3.16xlarge.elasticsearch"
)

// Type of Log File, it can be one of the following: INDEX_SLOW_LOGS: Index
// slow logs contain insert requests that took more time than configured index
// query log threshold to execute.
// SEARCH_SLOW_LOGS: Search slow logs contain search queries that took more
// time than configured search query log threshold to execute.
// ES_APPLICATION_LOGS: Elasticsearch application logs contain information about
// errors and warnings raised during the operation of the service and can be
// useful for troubleshooting.
const (
	// LogTypeIndexSlowLogs is a LogType enum value
	LogTypeIndexSlowLogs = "INDEX_SLOW_LOGS"

	// LogTypeSearchSlowLogs is a LogType enum value
	LogTypeSearchSlowLogs = "SEARCH_SLOW_LOGS"

	// LogTypeEsApplicationLogs is a LogType enum value
	LogTypeEsApplicationLogs = "ES_APPLICATION_LOGS"
)

// The state of a requested change. One of the following:
//
//    * Processing: The request change is still in-process.
//    * Active: The request change is processed and deployed to the Elasticsearch
//    domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

const (
	// ReservedElasticsearchInstancePaymentOptionAllUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionAllUpfront = "ALL_UPFRONT"

	// ReservedElasticsearchInstancePaymentOptionPartialUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionPartialUpfront = "PARTIAL_UPFRONT"

	// ReservedElasticsearchInstancePaymentOptionNoUpfront is a ReservedElasticsearchInstancePaymentOption enum value
	ReservedElasticsearchInstancePaymentOptionNoUpfront = "NO_UPFRONT"
)

const (
	// UpgradeStatusInProgress is a UpgradeStatus enum value
	UpgradeStatusInProgress = "IN_PROGRESS"

	// UpgradeStatusSucceeded is a UpgradeStatus enum value
	UpgradeStatusSucceeded = "SUCCEEDED"

	// UpgradeStatusSucceededWithIssues is a UpgradeStatus enum value
	UpgradeStatusSucceededWithIssues = "SUCCEEDED_WITH_ISSUES"

	// UpgradeStatusFailed is a UpgradeStatus enum value
	UpgradeStatusFailed = "FAILED"
)

const (
	// UpgradeStepPreUpgradeCheck is a UpgradeStep enum value
	UpgradeStepPreUpgradeCheck = "PRE_UPGRADE_CHECK"

	// UpgradeStepSnapshot is a UpgradeStep enum value
	UpgradeStepSnapshot = "SNAPSHOT"

	// UpgradeStepUpgrade is a UpgradeStep enum value
	UpgradeStepUpgrade = "UPGRADE"
)

// The type of EBS volume, standard, gp2, or io1. See Configuring EBS-based
// Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)for
// more information.
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"
)
