// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideoarchivedmedia

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opGetHLSStreamingSessionURL = "GetHLSStreamingSessionURL"

// GetHLSStreamingSessionURLRequest generates a "aws/request.Request" representing the
// client's request for the GetHLSStreamingSessionURL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHLSStreamingSessionURL for more information on using the GetHLSStreamingSessionURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHLSStreamingSessionURLRequest method.
//    req, resp := client.GetHLSStreamingSessionURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/GetHLSStreamingSessionURL
func (c *KinesisVideoArchivedMedia) GetHLSStreamingSessionURLRequest(input *GetHLSStreamingSessionURLInput) (req *request.Request, output *GetHLSStreamingSessionURLOutput) {
	op := &request.Operation{
		Name:       opGetHLSStreamingSessionURL,
		HTTPMethod: "POST",
		HTTPPath:   "/getHLSStreamingSessionURL",
	}

	if input == nil {
		input = &GetHLSStreamingSessionURLInput{}
	}

	output = &GetHLSStreamingSessionURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHLSStreamingSessionURL API operation for Amazon Kinesis Video Streams Archived Media.
//
// Retrieves an HTTP Live Streaming (HLS) URL for the stream. You can then open
// the URL in a browser or media player to view the stream contents.
//
// You must specify either the StreamName or the StreamARN.
//
// An Amazon Kinesis video stream has the following requirements for providing
// data through HLS:
//
//    * The media type must be video/h264.
//
//    * Data retention must be greater than 0.
//
//    * The fragments must contain codec private data in the AVC (Advanced Video
//    Coding) for H.264 format (MPEG-4 specification ISO/IEC 14496-15 (https://www.iso.org/standard/55980.html)).
//    For information about adapting stream data to a given format, see NAL
//    Adaptation Flags (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/latest/dg/producer-reference-nal.html).
//
// Kinesis Video Streams HLS sessions contain fragments in the fragmented MPEG-4
// form (also called fMP4 or CMAF), rather than the MPEG-2 form (also called
// TS chunks, which the HLS specification also supports). For more information
// about HLS fragment types, see the HLS specification (https://tools.ietf.org/html/draft-pantos-http-live-streaming-23).
//
// The following procedure shows how to use HLS with Kinesis Video Streams:
//
// Get an endpoint using GetDataEndpoint (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_GetDataEndpoint.html),
// specifying GET_HLS_STREAMING_SESSION_URL for the APIName parameter.
//
// Retrieve the HLS URL using GetHLSStreamingSessionURL. Kinesis Video Streams
// creates an HLS streaming session to be used for accessing content in a stream
// using the HLS protocol. GetHLSStreamingSessionURL returns an authenticated
// URL (that includes an encrypted session token) for the session's HLS master
// playlist (the root resource needed for streaming with HLS).
//
// Don't share or store this token where an unauthorized entity could access
// it. The token provides access to the content of the stream. Safeguard the
// token with the same measures that you would use with your AWS credentials.
//
// The media that is made available through the playlist consists only of the
// requested stream, time range, and format. No other media data (such as frames
// outside the requested window or alternate bit rates) is made available.
//
// Provide the URL (containing the encrypted session token) for the HLS master
// playlist to a media player that supports the HLS protocol. Kinesis Video
// Streams makes the HLS media playlist, initialization fragment, and media
// fragments available through the master playlist URL. The initialization fragment
// contains the codec private data for the stream, and other data needed to
// set up the video decoder and renderer. The media fragments contain H.264-encoded
// video frames and time stamps.
//
// The media player receives the authenticated URL and requests stream metadata
// and media data normally. When the media player requests data, it calls the
// following actions:
//
// GetHLSMasterPlaylist: Retrieves an HLS master playlist, which contains a
// URL for the GetHLSMediaPlaylist action, and additional metadata for the media
// player, including estimated bit rate and resolution.
//
// GetHLSMediaPlaylist: Retrieves an HLS media playlist, which contains a URL
// to access the MP4 initialization fragment with the GetMP4InitFragment action,
// and URLs to access the MP4 media fragments with the GetMP4MediaFragment actions.
// The HLS media playlist also contains metadata about the stream that the player
// needs to play it, such as whether the PlaybackMode is LIVE or ON_DEMAND.
// The HLS media playlist is typically static for sessions with a PlaybackType
// of ON_DEMAND. The HLS media playlist is continually updated with new fragments
// for sessions with a PlaybackType of LIVE.
//
// GetMP4InitFragment: Retrieves the MP4 initialization fragment. The media
// player typically loads the initialization fragment before loading any media
// fragments. This fragment contains the "fytp" and "moov" MP4 atoms, and the
// child atoms that are needed to initialize the media player decoder.
//
// The initialization fragment does not correspond to a fragment in a Kinesis
// video stream. It contains only the codec private data for the stream, which
// the media player needs to decode video frames.
//
// GetMP4MediaFragment: Retrieves MP4 media fragments. These fragments contain
// the "moof" and "mdat" MP4 atoms and their child atoms, containing the encoded
// fragment's video frames and their time stamps.
//
// After the first media fragment is made available in a streaming session,
// any fragments that don't contain the same codec private data are excluded
// in the HLS media playlist. Therefore, the codec private data does not change
// between fragments in a session.
//
// Data retrieved with this action is billable. See Pricing (aws.amazon.comkinesis/video-streams/pricing/)
// for details.
//
// The following restrictions apply to HLS sessions:
//
// A streaming session URL should not be shared between players. The service
// might throttle a session if multiple media players are sharing it. For connection
// limits, see Kinesis Video Streams Limits (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/limits.html).
//
// A Kinesis video stream can have a maximum of five active HLS streaming sessions.
// If a new session is created when the maximum number of sessions is already
// active, the oldest (earliest created) session is closed. The number of active
// GetMedia connections on a Kinesis video stream does not count against this
// limit, and the number of active HLS sessions does not count against the active
// GetMedia connection limit.
//
// You can monitor the amount of data that the media player consumes by monitoring
// the GetMP4MediaFragment.OutgoingBytes Amazon CloudWatch metric. For information
// about using CloudWatch to monitor Kinesis Video Streams, see Monitoring Kinesis
// Video Streams (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/monitoring.html).
// For pricing information, see Amazon Kinesis Video Streams Pricing (https://aws.amazon.com/kinesis/video-streams/pricing/)
// and AWS Pricing (https://aws.amazon.com/pricing/). Charges for both HLS sessions
// and outgoing AWS data apply.
//
// For more information about HLS, see HTTP Live Streaming (https://developer.apple.com/streaming/)
// on the Apple Developer site (https://developer.apple.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams Archived Media's
// API operation GetHLSStreamingSessionURL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   GetMedia throws this error when Kinesis Video Streams can't find the stream
//   that you specified.
//
//   GetHLSStreamingSessionURL throws this error if a session with a PlaybackMode
//   of ON_DEMAND is requested for a stream that has no fragments within the requested
//   time range, or if a session with a PlaybackMode of LIVE is requested for
//   a stream that has no fragments within the last 30 seconds.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Status Code: 403, The caller is not authorized to perform an operation on
//   the given stream, or the token has expired.
//
//   * ErrCodeUnsupportedStreamMediaTypeException "UnsupportedStreamMediaTypeException"
//   An HLS streaming session was requested for a stream with a media type that
//   is not video/h264.
//
//   * ErrCodeNoDataRetentionException "NoDataRetentionException"
//   A PlaybackMode of ON_DEMAND was requested for a stream that does not retain
//   data (that is, has a DataRetentionInHours of 0).
//
//   * ErrCodeMissingCodecPrivateDataException "MissingCodecPrivateDataException"
//   No Codec Private Data was found in the video stream.
//
//   * ErrCodeInvalidCodecPrivateDataException "InvalidCodecPrivateDataException"
//   The Codec Private Data in the video stream is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/GetHLSStreamingSessionURL
func (c *KinesisVideoArchivedMedia) GetHLSStreamingSessionURL(input *GetHLSStreamingSessionURLInput) (*GetHLSStreamingSessionURLOutput, error) {
	req, out := c.GetHLSStreamingSessionURLRequest(input)
	return out, req.Send()
}

// GetHLSStreamingSessionURLWithContext is the same as GetHLSStreamingSessionURL with the addition of
// the ability to pass a context and additional request options.
//
// See GetHLSStreamingSessionURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideoArchivedMedia) GetHLSStreamingSessionURLWithContext(ctx aws.Context, input *GetHLSStreamingSessionURLInput, opts ...request.Option) (*GetHLSStreamingSessionURLOutput, error) {
	req, out := c.GetHLSStreamingSessionURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMediaForFragmentList = "GetMediaForFragmentList"

// GetMediaForFragmentListRequest generates a "aws/request.Request" representing the
// client's request for the GetMediaForFragmentList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMediaForFragmentList for more information on using the GetMediaForFragmentList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMediaForFragmentListRequest method.
//    req, resp := client.GetMediaForFragmentListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/GetMediaForFragmentList
func (c *KinesisVideoArchivedMedia) GetMediaForFragmentListRequest(input *GetMediaForFragmentListInput) (req *request.Request, output *GetMediaForFragmentListOutput) {
	op := &request.Operation{
		Name:       opGetMediaForFragmentList,
		HTTPMethod: "POST",
		HTTPPath:   "/getMediaForFragmentList",
	}

	if input == nil {
		input = &GetMediaForFragmentListInput{}
	}

	output = &GetMediaForFragmentListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMediaForFragmentList API operation for Amazon Kinesis Video Streams Archived Media.
//
// Gets media for a list of fragments (specified by fragment number) from the
// archived data in an Amazon Kinesis video stream.
//
// The following limits apply when using the GetMediaForFragmentList API:
//
//    * A client can call GetMediaForFragmentList up to five times per second
//    per stream.
//
//    * Kinesis Video Streams sends media data at a rate of up to 25 megabytes
//    per second (or 200 megabits per second) during a GetMediaForFragmentList
//    session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams Archived Media's
// API operation GetMediaForFragmentList for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   GetMedia throws this error when Kinesis Video Streams can't find the stream
//   that you specified.
//
//   GetHLSStreamingSessionURL throws this error if a session with a PlaybackMode
//   of ON_DEMAND is requested for a stream that has no fragments within the requested
//   time range, or if a session with a PlaybackMode of LIVE is requested for
//   a stream that has no fragments within the last 30 seconds.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Status Code: 403, The caller is not authorized to perform an operation on
//   the given stream, or the token has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/GetMediaForFragmentList
func (c *KinesisVideoArchivedMedia) GetMediaForFragmentList(input *GetMediaForFragmentListInput) (*GetMediaForFragmentListOutput, error) {
	req, out := c.GetMediaForFragmentListRequest(input)
	return out, req.Send()
}

// GetMediaForFragmentListWithContext is the same as GetMediaForFragmentList with the addition of
// the ability to pass a context and additional request options.
//
// See GetMediaForFragmentList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideoArchivedMedia) GetMediaForFragmentListWithContext(ctx aws.Context, input *GetMediaForFragmentListInput, opts ...request.Option) (*GetMediaForFragmentListOutput, error) {
	req, out := c.GetMediaForFragmentListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFragments = "ListFragments"

// ListFragmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListFragments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFragments for more information on using the ListFragments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFragmentsRequest method.
//    req, resp := client.ListFragmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/ListFragments
func (c *KinesisVideoArchivedMedia) ListFragmentsRequest(input *ListFragmentsInput) (req *request.Request, output *ListFragmentsOutput) {
	op := &request.Operation{
		Name:       opListFragments,
		HTTPMethod: "POST",
		HTTPPath:   "/listFragments",
	}

	if input == nil {
		input = &ListFragmentsInput{}
	}

	output = &ListFragmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFragments API operation for Amazon Kinesis Video Streams Archived Media.
//
// Returns a list of Fragment objects from the specified stream and start location
// within the archived data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams Archived Media's
// API operation ListFragments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   GetMedia throws this error when Kinesis Video Streams can't find the stream
//   that you specified.
//
//   GetHLSStreamingSessionURL throws this error if a session with a PlaybackMode
//   of ON_DEMAND is requested for a stream that has no fragments within the requested
//   time range, or if a session with a PlaybackMode of LIVE is requested for
//   a stream that has no fragments within the last 30 seconds.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   A specified parameter exceeds its restrictions, is not supported, or can't
//   be used.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   Status Code: 403, The caller is not authorized to perform an operation on
//   the given stream, or the token has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/ListFragments
func (c *KinesisVideoArchivedMedia) ListFragments(input *ListFragmentsInput) (*ListFragmentsOutput, error) {
	req, out := c.ListFragmentsRequest(input)
	return out, req.Send()
}

// ListFragmentsWithContext is the same as ListFragments with the addition of
// the ability to pass a context and additional request options.
//
// See ListFragments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideoArchivedMedia) ListFragmentsWithContext(ctx aws.Context, input *ListFragmentsInput, opts ...request.Option) (*ListFragmentsOutput, error) {
	req, out := c.ListFragmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents a segment of video or other time-delimited data.
type Fragment struct {
	_ struct{} `type:"structure"`

	// The playback duration or other time value associated with the fragment.
	FragmentLengthInMilliseconds *int64 `type:"long"`

	// The index value of the fragment.
	FragmentNumber *string `min:"1" type:"string"`

	// The total fragment size, including information about the fragment and contained
	// media data.
	FragmentSizeInBytes *int64 `type:"long"`

	// The time stamp from the producer corresponding to the fragment.
	ProducerTimestamp *time.Time `type:"timestamp"`

	// The time stamp from the AWS server corresponding to the fragment.
	ServerTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Fragment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fragment) GoString() string {
	return s.String()
}

// SetFragmentLengthInMilliseconds sets the FragmentLengthInMilliseconds field's value.
func (s *Fragment) SetFragmentLengthInMilliseconds(v int64) *Fragment {
	s.FragmentLengthInMilliseconds = &v
	return s
}

// SetFragmentNumber sets the FragmentNumber field's value.
func (s *Fragment) SetFragmentNumber(v string) *Fragment {
	s.FragmentNumber = &v
	return s
}

// SetFragmentSizeInBytes sets the FragmentSizeInBytes field's value.
func (s *Fragment) SetFragmentSizeInBytes(v int64) *Fragment {
	s.FragmentSizeInBytes = &v
	return s
}

// SetProducerTimestamp sets the ProducerTimestamp field's value.
func (s *Fragment) SetProducerTimestamp(v time.Time) *Fragment {
	s.ProducerTimestamp = &v
	return s
}

// SetServerTimestamp sets the ServerTimestamp field's value.
func (s *Fragment) SetServerTimestamp(v time.Time) *Fragment {
	s.ServerTimestamp = &v
	return s
}

// Describes the time stamp range and time stamp origin of a range of fragments.
type FragmentSelector struct {
	_ struct{} `type:"structure"`

	// The origin of the time stamps to use (Server or Producer).
	//
	// FragmentSelectorType is a required field
	FragmentSelectorType *string `type:"string" required:"true" enum:"FragmentSelectorType"`

	// The range of time stamps to return.
	//
	// TimestampRange is a required field
	TimestampRange *TimestampRange `type:"structure" required:"true"`
}

// String returns the string representation
func (s FragmentSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FragmentSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FragmentSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FragmentSelector"}
	if s.FragmentSelectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("FragmentSelectorType"))
	}
	if s.TimestampRange == nil {
		invalidParams.Add(request.NewErrParamRequired("TimestampRange"))
	}
	if s.TimestampRange != nil {
		if err := s.TimestampRange.Validate(); err != nil {
			invalidParams.AddNested("TimestampRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFragmentSelectorType sets the FragmentSelectorType field's value.
func (s *FragmentSelector) SetFragmentSelectorType(v string) *FragmentSelector {
	s.FragmentSelectorType = &v
	return s
}

// SetTimestampRange sets the TimestampRange field's value.
func (s *FragmentSelector) SetTimestampRange(v *TimestampRange) *FragmentSelector {
	s.TimestampRange = v
	return s
}

type GetHLSStreamingSessionURLInput struct {
	_ struct{} `type:"structure"`

	// Specifies when flags marking discontinuities between fragments will be added
	// to the media playlists. The default is ALWAYS when HLSFragmentSelector is
	// SERVER_TIMESTAMP, and NEVER when it is PRODUCER_TIMESTAMP.
	//
	// Media players typically build a timeline of media content to play, based
	// on the time stamps of each fragment. This means that if there is any overlap
	// between fragments (as is typical if HLSFragmentSelector is SERVER_TIMESTAMP),
	// the media player timeline has small gaps between fragments in some places,
	// and overwrites frames in other places. When there are discontinuity flags
	// between fragments, the media player is expected to reset the timeline, resulting
	// in the fragment being played immediately after the previous fragment. We
	// recommend that you always have discontinuity flags between fragments if the
	// fragment time stamps are not accurate or if fragments might be missing. You
	// should not place discontinuity flags between fragments for the player timeline
	// to accurately map to the producer time stamps.
	DiscontinuityMode *string `type:"string" enum:"DiscontinuityMode"`

	// The time in seconds until the requested session expires. This value can be
	// between 300 (5 minutes) and 43200 (12 hours).
	//
	// When a session expires, no new calls to GetHLSMasterPlaylist, GetHLSMediaPlaylist,
	// GetMP4InitFragment, or GetMP4MediaFragment can be made for that session.
	//
	// The default is 300 (5 minutes).
	Expires *int64 `min:"300" type:"integer"`

	// The time range of the requested fragment, and the source of the time stamps.
	//
	// This parameter is required if PlaybackMode is ON_DEMAND. This parameter is
	// optional if PlaybackMode is LIVE. If PlaybackMode is LIVE, the FragmentSelectorType
	// can be set, but the TimestampRange should not be set. If PlaybackMode is
	// ON_DEMAND, both FragmentSelectorType and TimestampRange must be set.
	HLSFragmentSelector *HLSFragmentSelector `type:"structure"`

	// The maximum number of fragments that are returned in the HLS media playlists.
	//
	// When the PlaybackMode is LIVE, the most recent fragments are returned up
	// to this value. When the PlaybackMode is ON_DEMAND, the oldest fragments are
	// returned, up to this maximum number.
	//
	// When there are a higher number of fragments available in a live HLS media
	// playlist, video players often buffer content before starting playback. Increasing
	// the buffer size increases the playback latency, but it decreases the likelihood
	// that rebuffering will occur during playback. We recommend that a live HLS
	// media playlist have a minimum of 3 fragments and a maximum of 10 fragments.
	//
	// The default is 5 fragments if PlaybackMode is LIVE, and 1,000 if PlaybackMode
	// is ON_DEMAND.
	//
	// The maximum value of 1,000 fragments corresponds to more than 16 minutes
	// of video on streams with 1-second fragments, and more than 2 1/2 hours of
	// video on streams with 10-second fragments.
	MaxMediaPlaylistFragmentResults *int64 `min:"1" type:"long"`

	// Whether to retrieve live or archived, on-demand data.
	//
	// Features of the two types of session include the following:
	//
	//    * LIVE: For sessions of this type, the HLS media playlist is continually
	//    updated with the latest fragments as they become available. We recommend
	//    that the media player retrieve a new playlist on a one-second interval.
	//    When this type of session is played in a media player, the user interface
	//    typically displays a "live" notification, with no scrubber control for
	//    choosing the position in the playback window to display.
	//
	// In LIVE mode, the newest available fragments are included in an HLS media
	//    playlist, even if there is a gap between fragments (that is, if a fragment
	//    is missing). A gap like this might cause a media player to halt or cause
	//    a jump in playback. In this mode, fragments are not added to the HLS media
	//    playlist if they are older than the newest fragment in the playlist. If
	//    the missing fragment becomes available after a subsequent fragment is
	//    added to the playlist, the older fragment is not added, and the gap is
	//    not filled.
	//
	//    * ON_DEMAND: For sessions of this type, the HLS media playlist contains
	//    all the fragments for the session, up to the number that is specified
	//    in MaxMediaPlaylistFragmentResults. The playlist must be retrieved only
	//    once for each session. When this type of session is played in a media
	//    player, the user interface typically displays a scrubber control for choosing
	//    the position in the playback window to display.
	//
	// In both playback modes, if FragmentSelectorType is PRODUCER_TIMESTAMP, and
	// if there are multiple fragments with the same start time stamp, the fragment
	// that has the larger fragment number (that is, the newer fragment) is included
	// in the HLS media playlist. The other fragments are not included. Fragments
	// that have different time stamps but have overlapping durations are still
	// included in the HLS media playlist. This can lead to unexpected behavior
	// in the media player.
	//
	// The default is LIVE.
	PlaybackMode *string `type:"string" enum:"PlaybackMode"`

	// The Amazon Resource Name (ARN) of the stream for which to retrieve the HLS
	// master playlist URL.
	//
	// You must specify either the StreamName or the StreamARN.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream for which to retrieve the HLS master playlist URL.
	//
	// You must specify either the StreamName or the StreamARN.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetHLSStreamingSessionURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHLSStreamingSessionURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHLSStreamingSessionURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHLSStreamingSessionURLInput"}
	if s.Expires != nil && *s.Expires < 300 {
		invalidParams.Add(request.NewErrParamMinValue("Expires", 300))
	}
	if s.MaxMediaPlaylistFragmentResults != nil && *s.MaxMediaPlaylistFragmentResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxMediaPlaylistFragmentResults", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscontinuityMode sets the DiscontinuityMode field's value.
func (s *GetHLSStreamingSessionURLInput) SetDiscontinuityMode(v string) *GetHLSStreamingSessionURLInput {
	s.DiscontinuityMode = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *GetHLSStreamingSessionURLInput) SetExpires(v int64) *GetHLSStreamingSessionURLInput {
	s.Expires = &v
	return s
}

// SetHLSFragmentSelector sets the HLSFragmentSelector field's value.
func (s *GetHLSStreamingSessionURLInput) SetHLSFragmentSelector(v *HLSFragmentSelector) *GetHLSStreamingSessionURLInput {
	s.HLSFragmentSelector = v
	return s
}

// SetMaxMediaPlaylistFragmentResults sets the MaxMediaPlaylistFragmentResults field's value.
func (s *GetHLSStreamingSessionURLInput) SetMaxMediaPlaylistFragmentResults(v int64) *GetHLSStreamingSessionURLInput {
	s.MaxMediaPlaylistFragmentResults = &v
	return s
}

// SetPlaybackMode sets the PlaybackMode field's value.
func (s *GetHLSStreamingSessionURLInput) SetPlaybackMode(v string) *GetHLSStreamingSessionURLInput {
	s.PlaybackMode = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *GetHLSStreamingSessionURLInput) SetStreamARN(v string) *GetHLSStreamingSessionURLInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetHLSStreamingSessionURLInput) SetStreamName(v string) *GetHLSStreamingSessionURLInput {
	s.StreamName = &v
	return s
}

type GetHLSStreamingSessionURLOutput struct {
	_ struct{} `type:"structure"`

	// The URL (containing the session token) that a media player can use to retrieve
	// the HLS master playlist.
	HLSStreamingSessionURL *string `type:"string"`
}

// String returns the string representation
func (s GetHLSStreamingSessionURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHLSStreamingSessionURLOutput) GoString() string {
	return s.String()
}

// SetHLSStreamingSessionURL sets the HLSStreamingSessionURL field's value.
func (s *GetHLSStreamingSessionURLOutput) SetHLSStreamingSessionURL(v string) *GetHLSStreamingSessionURLOutput {
	s.HLSStreamingSessionURL = &v
	return s
}

type GetMediaForFragmentListInput struct {
	_ struct{} `type:"structure"`

	// A list of the numbers of fragments for which to retrieve media. You retrieve
	// these values with ListFragments.
	//
	// Fragments is a required field
	Fragments []*string `min:"1" type:"list" required:"true"`

	// The name of the stream from which to retrieve fragment media.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMediaForFragmentListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMediaForFragmentListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMediaForFragmentListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMediaForFragmentListInput"}
	if s.Fragments == nil {
		invalidParams.Add(request.NewErrParamRequired("Fragments"))
	}
	if s.Fragments != nil && len(s.Fragments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fragments", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFragments sets the Fragments field's value.
func (s *GetMediaForFragmentListInput) SetFragments(v []*string) *GetMediaForFragmentListInput {
	s.Fragments = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetMediaForFragmentListInput) SetStreamName(v string) *GetMediaForFragmentListInput {
	s.StreamName = &v
	return s
}

type GetMediaForFragmentListOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The content type of the requested media.
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string"`

	// The payload that Kinesis Video Streams returns is a sequence of chunks from
	// the specified stream. For information about the chunks, see PutMedia (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_PutMedia.html).
	// The chunks that Kinesis Video Streams returns in the GetMediaForFragmentList
	// call also include the following additional Matroska (MKV) tags:
	//
	//    * AWS_KINESISVIDEO_FRAGMENT_NUMBER - Fragment number returned in the chunk.
	//
	//    * AWS_KINESISVIDEO_SERVER_SIDE_TIMESTAMP - Server-side time stamp of the
	//    fragment.
	//
	//    * AWS_KINESISVIDEO_PRODUCER_SIDE_TIMESTAMP - Producer-side time stamp
	//    of the fragment.
	//
	// The following tags will be included if an exception occurs:
	//
	//    * AWS_KINESISVIDEO_FRAGMENT_NUMBER - The number of the fragment that threw
	//    the exception
	//
	//    * AWS_KINESISVIDEO_EXCEPTION_ERROR_CODE - The integer code of the exception
	//
	//    * AWS_KINESISVIDEO_EXCEPTION_MESSAGE - A text description of the exception
	Payload io.ReadCloser `type:"blob"`
}

// String returns the string representation
func (s GetMediaForFragmentListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMediaForFragmentListOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetMediaForFragmentListOutput) SetContentType(v string) *GetMediaForFragmentListOutput {
	s.ContentType = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *GetMediaForFragmentListOutput) SetPayload(v io.ReadCloser) *GetMediaForFragmentListOutput {
	s.Payload = v
	return s
}

// Contains the range of time stamps for the requested media, and the source
// of the time stamps.
type HLSFragmentSelector struct {
	_ struct{} `type:"structure"`

	// The source of the time stamps for the requested media.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetHLSStreamingSessionURLInput$PlaybackMode
	// is ON_DEMAND, the first fragment ingested with a producer time stamp within
	// the specified FragmentSelector$TimestampRange is included in the media playlist.
	// In addition, the fragments with producer time stamps within the TimestampRange
	// ingested immediately following the first fragment (up to the GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults
	// value) are included.
	//
	// Fragments that have duplicate producer time stamps are deduplicated. This
	// means that if producers are producing a stream of fragments with producer
	// time stamps that are approximately equal to the true clock time, the HLS
	// media playlists will contain all of the fragments within the requested time
	// stamp range. If some fragments are ingested within the same time range and
	// very different points in time, only the oldest ingested collection of fragments
	// are returned.
	//
	// When FragmentSelectorType is set to PRODUCER_TIMESTAMP and GetHLSStreamingSessionURLInput$PlaybackMode
	// is LIVE, the producer time stamps are used in the MP4 fragments and for deduplication.
	// But the most recently ingested fragments based on server time stamps are
	// included in the HLS media playlist. This means that even if fragments ingested
	// in the past have producer time stamps with values now, they are not included
	// in the HLS media playlist.
	//
	// The default is SERVER_TIMESTAMP.
	FragmentSelectorType *string `type:"string" enum:"HLSFragmentSelectorType"`

	// The start and end of the time stamp range for the requested media.
	//
	// This value should not be present if PlaybackType is LIVE.
	TimestampRange *HLSTimestampRange `type:"structure"`
}

// String returns the string representation
func (s HLSFragmentSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HLSFragmentSelector) GoString() string {
	return s.String()
}

// SetFragmentSelectorType sets the FragmentSelectorType field's value.
func (s *HLSFragmentSelector) SetFragmentSelectorType(v string) *HLSFragmentSelector {
	s.FragmentSelectorType = &v
	return s
}

// SetTimestampRange sets the TimestampRange field's value.
func (s *HLSFragmentSelector) SetTimestampRange(v *HLSTimestampRange) *HLSFragmentSelector {
	s.TimestampRange = v
	return s
}

// The start and end of the time stamp range for the requested media.
//
// This value should not be present if PlaybackType is LIVE.
//
// The values in the HLSTimestampRange are inclusive. Fragments that begin before
// the start time but continue past it, or fragments that begin before the end
// time but continue past it, are included in the session.
type HLSTimestampRange struct {
	_ struct{} `type:"structure"`

	// The end of the time stamp range for the requested media. This value must
	// be within 3 hours of the specified StartTimestamp, and it must be later than
	// the StartTimestamp value.
	//
	// If FragmentSelectorType for the request is SERVER_TIMESTAMP, this value must
	// be in the past.
	//
	// If the HLSTimestampRange value is specified, the EndTimestamp value is required.
	//
	// This value is inclusive. The EndTimestamp is compared to the (starting) time
	// stamp of the fragment. Fragments that start before the EndTimestamp value
	// and continue past it are included in the session.
	EndTimestamp *time.Time `type:"timestamp"`

	// The start of the time stamp range for the requested media.
	//
	// If the HLSTimestampRange value is specified, the StartTimestamp value is
	// required.
	//
	// This value is inclusive. Fragments that start before the StartTimestamp and
	// continue past it are included in the session. If FragmentSelectorType is
	// SERVER_TIMESTAMP, the StartTimestamp must be later than the stream head.
	StartTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s HLSTimestampRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HLSTimestampRange) GoString() string {
	return s.String()
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *HLSTimestampRange) SetEndTimestamp(v time.Time) *HLSTimestampRange {
	s.EndTimestamp = &v
	return s
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *HLSTimestampRange) SetStartTimestamp(v time.Time) *HLSTimestampRange {
	s.StartTimestamp = &v
	return s
}

type ListFragmentsInput struct {
	_ struct{} `type:"structure"`

	// Describes the time stamp range and time stamp origin for the range of fragments
	// to return.
	FragmentSelector *FragmentSelector `type:"structure"`

	// The total number of fragments to return. If the total number of fragments
	// available is more than the value specified in max-results, then a ListFragmentsOutput$NextToken
	// is provided in the output that you can use to resume pagination.
	MaxResults *int64 `min:"1" type:"long"`

	// A token to specify where to start paginating. This is the ListFragmentsOutput$NextToken
	// from a previously truncated response.
	NextToken *string `min:"1" type:"string"`

	// The name of the stream from which to retrieve a fragment list.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListFragmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFragmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFragmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFragmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.FragmentSelector != nil {
		if err := s.FragmentSelector.Validate(); err != nil {
			invalidParams.AddNested("FragmentSelector", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFragmentSelector sets the FragmentSelector field's value.
func (s *ListFragmentsInput) SetFragmentSelector(v *FragmentSelector) *ListFragmentsInput {
	s.FragmentSelector = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFragmentsInput) SetMaxResults(v int64) *ListFragmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFragmentsInput) SetNextToken(v string) *ListFragmentsInput {
	s.NextToken = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *ListFragmentsInput) SetStreamName(v string) *ListFragmentsInput {
	s.StreamName = &v
	return s
}

type ListFragmentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of fragment numbers that correspond to the time stamp range provided.
	Fragments []*Fragment `type:"list"`

	// If the returned list is truncated, the operation returns this token to use
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFragmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFragmentsOutput) GoString() string {
	return s.String()
}

// SetFragments sets the Fragments field's value.
func (s *ListFragmentsOutput) SetFragments(v []*Fragment) *ListFragmentsOutput {
	s.Fragments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFragmentsOutput) SetNextToken(v string) *ListFragmentsOutput {
	s.NextToken = &v
	return s
}

// The range of time stamps for which to return fragments.
type TimestampRange struct {
	_ struct{} `type:"structure"`

	// The ending time stamp in the range of time stamps for which to return fragments.
	//
	// EndTimestamp is a required field
	EndTimestamp *time.Time `type:"timestamp" required:"true"`

	// The starting time stamp in the range of time stamps for which to return fragments.
	//
	// StartTimestamp is a required field
	StartTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimestampRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimestampRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimestampRange"}
	if s.EndTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimestamp"))
	}
	if s.StartTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimestamp sets the EndTimestamp field's value.
func (s *TimestampRange) SetEndTimestamp(v time.Time) *TimestampRange {
	s.EndTimestamp = &v
	return s
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *TimestampRange) SetStartTimestamp(v time.Time) *TimestampRange {
	s.StartTimestamp = &v
	return s
}

const (
	// DiscontinuityModeAlways is a DiscontinuityMode enum value
	DiscontinuityModeAlways = "ALWAYS"

	// DiscontinuityModeNever is a DiscontinuityMode enum value
	DiscontinuityModeNever = "NEVER"
)

const (
	// FragmentSelectorTypeProducerTimestamp is a FragmentSelectorType enum value
	FragmentSelectorTypeProducerTimestamp = "PRODUCER_TIMESTAMP"

	// FragmentSelectorTypeServerTimestamp is a FragmentSelectorType enum value
	FragmentSelectorTypeServerTimestamp = "SERVER_TIMESTAMP"
)

const (
	// HLSFragmentSelectorTypeProducerTimestamp is a HLSFragmentSelectorType enum value
	HLSFragmentSelectorTypeProducerTimestamp = "PRODUCER_TIMESTAMP"

	// HLSFragmentSelectorTypeServerTimestamp is a HLSFragmentSelectorType enum value
	HLSFragmentSelectorTypeServerTimestamp = "SERVER_TIMESTAMP"
)

const (
	// PlaybackModeLive is a PlaybackMode enum value
	PlaybackModeLive = "LIVE"

	// PlaybackModeOnDemand is a PlaybackMode enum value
	PlaybackModeOnDemand = "ON_DEMAND"
)
