
# Template SAN NetApp AFF A700 by HTTP

## Overview

For Zabbix version: 5.0 and higher  
The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.



This template was tested on:

- NetApp AFF A700, version 9.7

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/5.0/manual/config/templates_out_of_the_box/http) for basic instructions.

1\. Create a host for AFF A700 with cluster management IP as the Zabbix agent interface.

2\. Link the template to the host.

3\. Customize macro values if needed.



## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$HTTP.AGENT.TIMEOUT} |<p>The HTTP agent timeout to wait for a response from AFF700.</p> |`3s` |
|{$PASSWORD} |<p>AFF700 user password.</p> |`` |
|{$URL} |<p>AFF700 cluster URL address.</p> |`` |
|{$USERNAME} |<p>AFF700 user name.</p> |`` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Nodes discovery |<p>-</p> |HTTP_AGENT |netapp.nodes.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Ethernet ports discovery |<p>-</p> |HTTP_AGENT |netapp.ports.ether.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|FC ports discovery |<p>-</p> |HTTP_AGENT |netapp.ports.fc.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Disks discovery |<p>-</p> |HTTP_AGENT |netapp.disks.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Chassis discovery |<p>-</p> |HTTP_AGENT |netapp.chassis.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|FRUs discovery |<p>-</p> |DEPENDENT |netapp.frus.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|SVMs discovery |<p>-</p> |HTTP_AGENT |netapp.svms.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|LUNs discovery |<p>-</p> |HTTP_AGENT |netapp.luns.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Volumes discovery |<p>-</p> |HTTP_AGENT |netapp.volumes.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|General |Cluster software version |<p>This returns the cluster version information. When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.</p> |DEPENDENT |netapp.cluster.version<p>**Preprocessing**:</p><p>- JSONPATH: `$.version.full`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |Cluster name |<p>The name of the cluster.</p> |DEPENDENT |netapp.cluster.name<p>**Preprocessing**:</p><p>- JSONPATH: `$.name`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |Cluster location |<p>The location of the cluster.</p> |DEPENDENT |netapp.cluster.location<p>**Preprocessing**:</p><p>- JSONPATH: `$.location`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |Cluster status |<p>The status of the cluster: ok, error, partial_no_data, partial_no_response, partial_other_error, negative_delta, backfilled_data, inconsistent_delta_time, inconsistent_old_data.</p> |DEPENDENT |netapp.cluster.status<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.status`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |Cluster throughput, other rate |<p>Throughput bytes observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.cluster.statistics.throughput.other.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.throughput_raw.other`</p><p>- CHANGE_PER_SECOND |
|General |Cluster throughput, read rate |<p>Throughput bytes observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.throughput.read.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.throughput_raw.read`</p><p>- CHANGE_PER_SECOND |
|General |Cluster throughput, write rate |<p>Throughput bytes observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.throughput.write.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.throughput_raw.write`</p><p>- CHANGE_PER_SECOND |
|General |Cluster throughput, total rate |<p>Throughput bytes observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.throughput.total.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.throughput_raw.total`</p><p>- CHANGE_PER_SECOND |
|General |Cluster IOPS, other rate |<p>The number of I/O operations observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.cluster.statistics.iops.other.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.other`</p><p>- CHANGE_PER_SECOND |
|General |Cluster IOPS, read rate |<p>The number of I/O operations observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops.read.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.read`</p><p>- CHANGE_PER_SECOND |
|General |Cluster IOPS, write rate |<p>The number of I/O operations observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops.write.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.write`</p><p>- CHANGE_PER_SECOND |
|General |Cluster IOPS, total rate |<p>The number of I/O operations observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops.total.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.total`</p><p>- CHANGE_PER_SECOND |
|General |Cluster latency, other |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |CALCULATED |netapp.cluster.statistics.latency.other<p>**Expression**:</p>`(last(netapp.cluster.statistics.latency_raw.other) - prev(netapp.cluster.statistics.latency_raw.other)) / (last(netapp.cluster.statistics.iops_raw.other) - prev(netapp.cluster.statistics.iops_raw.other) + (last(netapp.cluster.statistics.iops_raw.other) - prev(netapp.cluster.statistics.iops_raw.other) = 0) ) * 0.001 ` |
|General |Cluster latency, read |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for read I/O operations.</p> |CALCULATED |netapp.cluster.statistics.latency.read<p>**Expression**:</p>`(last(netapp.cluster.statistics.latency_raw.read) - prev(netapp.cluster.statistics.latency_raw.read)) / ( last(netapp.cluster.statistics.iops_raw.read) - prev(netapp.cluster.statistics.iops_raw.read) + (last(netapp.cluster.statistics.iops_raw.read) - prev(netapp.cluster.statistics.iops_raw.read) = 0) ) * 0.001 ` |
|General |Cluster latency, write |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for write I/O operations.</p> |CALCULATED |netapp.cluster.statistics.latency.write<p>**Expression**:</p>`(last(netapp.cluster.statistics.latency_raw.write) - prev(netapp.cluster.statistics.latency_raw.write)) / ( last(netapp.cluster.statistics.iops_raw.write) - prev(netapp.cluster.statistics.iops_raw.write) + (last(netapp.cluster.statistics.iops_raw.write) - prev(netapp.cluster.statistics.iops_raw.write) = 0) ) * 0.001 ` |
|General |Cluster latency, total |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |CALCULATED |netapp.cluster.statistics.latency.total<p>**Expression**:</p>`(last(netapp.cluster.statistics.latency_raw.total) - prev(netapp.cluster.statistics.latency_raw.total)) / ( last(netapp.cluster.statistics.iops_raw.total) - prev(netapp.cluster.statistics.iops_raw.total) + (last(netapp.cluster.statistics.iops_raw.total) - prev(netapp.cluster.statistics.iops_raw.total) = 0) ) * 0.001 ` |
|General |{#NODENAME}: Software version |<p>This returns the cluster version information. When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.</p> |DEPENDENT |netapp.node.version[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].version.full.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#NODENAME}: Location |<p>The location of the node.</p> |DEPENDENT |netapp.nodes.location[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].location.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#NODENAME}: State |<p>State of the node:</p><p>up - Node is up and operational.</p><p>booting - Node is booting up.</p><p>down - Node has stopped or is dumping core.</p><p>taken_over - Node has been taken over by its HA partner and is not yet waiting for giveback.</p><p>waiting_for_giveback - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.</p><p>degraded - Node has one or more critical services offline.</p><p>unknown - Node or its HA partner cannot be contacted and there is no information on the node's state.</p> |DEPENDENT |netapp.nodes.state[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#NODENAME}: Membership |<p>Possible values:</p><p>  available - If a node is available, this means it is detected on the internal cluster network and can be added to the cluster. Nodes that have a membership of “available” are not returned when a GET request is called when the cluster exists. A query on the “membership” property for available must be provided to scan for nodes on the cluster network. Nodes that have a membership of “available” are returned automatically before a cluster is created.</p><p>  joining - Joining nodes are in the process of being added to the cluster. The node may be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.</p><p>  member - Nodes that are members have successfully joined the cluster.</p> |DEPENDENT |netapp.nodes.membership[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].membership.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#NODENAME}: Uptime |<p>The total time, in seconds, that the node has been up.</p> |DEPENDENT |netapp.nodes.uptime[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].uptime.first()`</p> |
|General |{#NODENAME}: Controller over temperature |<p>Specifies whether the hardware is currently operating outside of its recommended temperature range. The hardware shuts down if the temperature exceeds critical thresholds. Possible values: over, normal</p> |DEPENDENT |netapp.nodes.controller.over_temperature[{#NODENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#NODENAME}')].controller.over_temperature.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#ETHPORTNAME}: State |<p>The operational state of the port. Possible values: up, down.</p> |DEPENDENT |netapp.port.eth.state[{#NODENAME},{#ETHPORTNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#ETHPORTNAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#FCPORTNAME}: Description |<p>A description of the FC port.</p> |DEPENDENT |netapp.port.fc.description[{#NODENAME},{#FCPORTNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#FCPORTNAME}')].description.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#FCPORTNAME}: State |<p>The operational state of the FC port. Possible values:</p><p>startup - The port is booting up.</p><p>link_not_connected - The port has finished initialization, but a link with the fabric is not established.</p><p>online - The port is initialized and a link with the fabric has been established.</p><p>link_disconnected - The link was present at one point on this port but is currently not established.</p><p>offlined_by_user - The port is administratively disabled.</p><p>offlined_by_system - The port is set to offline by the system. This happens when the port encounters too many errors.</p><p>node_offline - The state information for the port cannot be retrieved. The node is offline or inaccessible.</p> |DEPENDENT |netapp.port.fc.state[{#NODENAME},{#FCPORTNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#FCPORTNAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#DISKNAME}: State |<p>The state of the disk. Possible values: broken, copy, maintenance, partner, pending, present, reconstructing, removed, spare, unfail, zeroing</p> |DEPENDENT |netapp.disk.state[{#NODENAME},{#DISKNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#DISKNAME}'&&@.node.name=='{#NODENAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#ID}: State |<p>The chassis state: ok, error.</p> |DEPENDENT |netapp.chassis.state[{#ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.id=='{#ID}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#FRUID}: State |<p>The FRU state: ok, error.</p> |DEPENDENT |netapp.chassis.fru.state[{#CHASSISID},{#FRUID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$[?(@.id=='{#FRUID}'&&@.chassisId=='{#CHASSISID}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#SVMNAME}: State |<p>SVM state: starting, running, stopping, stopped, deleting.</p> |DEPENDENT |netapp.svm.state[{#SVMNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#SVMNAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#SVMNAME}: Comment |<p>The comment for the SVM.</p> |DEPENDENT |netapp.svm.comment[{#SVMNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#SVMNAME}')].comment.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#LUNNAME}: State |<p>The state of the LUN. Normal states for a LUN are online and offline. Other states indicate errors. Possible values: foreign_lun_error, nvfail, offline, online, space_error.</p> |DEPENDENT |netapp.lun.status.state[{#SVMNAME},{#LUNNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.svm.name=='{#SVMNAME}'&&@.name=='{#LUNNAME}')].status.state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#LUNNAME}: Container state |<p>The state of the volume and aggregate that contain the LUN: online, aggregate_offline, volume_offline. LUNs are only available when their containers are available.</p> |DEPENDENT |netapp.lun.status.container_state[{#SVMNAME},{#LUNNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.svm.name=='{#SVMNAME}'&&@.name=='{#LUNNAME}')].status.container_state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#LUNNAME}: Space size |<p>The total provisioned size of the LUN.</p> |DEPENDENT |netapp.lun.space.size[{#SVMNAME},{#LUNNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.svm.name=='{#SVMNAME}'&&@.name=='{#LUNNAME}')].space.size.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#LUNNAME}: Space used |<p>The amount of space consumed by the main data stream of the LUN.</p> |DEPENDENT |netapp.lun.space.used[{#SVMNAME},{#LUNNAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.svm.name=='{#SVMNAME}'&&@.name=='{#LUNNAME}')].space.used.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Comment |<p>A comment for the volume.</p> |DEPENDENT |netapp.volume.comment[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].comment.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: State |<p>Volume state. A volume can only be brought online if it is offline. Taking a volume offline removes its junction path. The 'mixed' state applies to FlexGroup volumes only and cannot be specified as a target state. An 'error' state implies that the volume is not in a state to serve data.</p> |DEPENDENT |netapp.volume.state[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].state.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Type |<p>Type of the volume.</p><p>rw - read-write volume.</p><p>dp - data-protection volume.</p><p>ls - load-sharing dp volume.</p> |DEPENDENT |netapp.volume.type[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].type.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: SVM name |<p>The volume belongs this SVM.</p> |DEPENDENT |netapp.volume.svm_name[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].svm.name.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Space size |<p>Total provisioned size. The default size is equal to the minimum size of 20MB, in bytes.</p> |DEPENDENT |netapp.volume.space_size[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].space.size.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Available size |<p>The available space, in bytes.</p> |DEPENDENT |netapp.volume.space_available[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].space.available.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Used size |<p>The virtual space used (includes volume reserves) before storage efficiency, in bytes.</p> |DEPENDENT |netapp.volume.space_used[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].space.used.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|General |{#VOLUMENAME}: Volume throughput, other rate |<p>Throughput bytes observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.volume.statistics.throughput.other.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.throughput_raw.other.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume throughput, read rate |<p>Throughput bytes observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.volume.statistics.throughput.read.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.throughput_raw.read.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume throughput, write rate |<p>Throughput bytes observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.volume.statistics.throughput.write.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.throughput_raw.write.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume throughput, total rate |<p>Throughput bytes observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.volume.statistics.throughput.total.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.throughput_raw.total.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume IOPS, other rate |<p>The number of I/O operations observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.volume.statistics.iops.other.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.other.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume IOPS, read rate |<p>The number of I/O operations observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops.read.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.read.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume IOPS, write rate |<p>The number of I/O operations observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops.write.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.write.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume IOPS, total rate |<p>The number of I/O operations observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops.total.rate[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.total.first()`</p><p>- CHANGE_PER_SECOND |
|General |{#VOLUMENAME}: Volume latency, other |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |CALCULATED |netapp.volume.statistics.latency.other[{#VOLUMENAME}]<p>**Expression**:</p>`(last(netapp.volume.statistics.latency_raw.other[{#VOLUMENAME}]) - prev(netapp.volume.statistics.latency_raw.other[{#VOLUMENAME}])) / ( last(netapp.volume.statistics.iops_raw.other[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.other[{#VOLUMENAME}]) + (last(netapp.volume.statistics.iops_raw.other[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.other[{#VOLUMENAME}]) = 0) ) * 0.001 ` |
|General |{#VOLUMENAME}: Volume latency, read |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for read I/O operations.</p> |CALCULATED |netapp.volume.statistics.latency.read[{#VOLUMENAME}]<p>**Expression**:</p>`(last(netapp.volume.statistics.latency_raw.read[{#VOLUMENAME}]) - prev(netapp.volume.statistics.latency_raw.read[{#VOLUMENAME}])) / ( last(netapp.volume.statistics.iops_raw.read[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.read[{#VOLUMENAME}]) + (last(netapp.volume.statistics.iops_raw.read[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.read[{#VOLUMENAME}]) = 0)) * 0.001 ` |
|General |{#VOLUMENAME}: Volume latency, write |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric for write I/O operations.</p> |CALCULATED |netapp.volume.statistics.latency.write[{#VOLUMENAME}]<p>**Expression**:</p>`(last(netapp.volume.statistics.latency_raw.write[{#VOLUMENAME}]) - prev(netapp.volume.statistics.latency_raw.write[{#VOLUMENAME}])) / ( last(netapp.volume.statistics.iops_raw.write[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.write[{#VOLUMENAME}]) + (last(netapp.volume.statistics.iops_raw.write[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.write[{#VOLUMENAME}]) = 0) ) * 0.001 ` |
|General |{#VOLUMENAME}: Volume latency, total |<p>The average latency per I/O operation in milliseconds observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |CALCULATED |netapp.volume.statistics.latency.total[{#VOLUMENAME}]<p>**Expression**:</p>`(last(netapp.volume.statistics.latency_raw.total[{#VOLUMENAME}]) - prev(netapp.volume.statistics.latency_raw.total[{#VOLUMENAME}])) / ( last(netapp.volume.statistics.iops_raw.total[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.total[{#VOLUMENAME}]) + (last(netapp.volume.statistics.iops_raw.total[{#VOLUMENAME}]) - prev(netapp.volume.statistics.iops_raw.total[{#VOLUMENAME}]) = 0) ) * 0.001 ` |
|Zabbix_raw_items |Get cluster |<p>-</p> |HTTP_AGENT |netapp.cluster.get |
|Zabbix_raw_items |Get nodes |<p>-</p> |HTTP_AGENT |netapp.nodes.get |
|Zabbix_raw_items |Get disks |<p>-</p> |HTTP_AGENT |netapp.disks.get |
|Zabbix_raw_items |Get volumes |<p>-</p> |HTTP_AGENT |netapp.volumes.get |
|Zabbix_raw_items |Get ethernet ports |<p>-</p> |HTTP_AGENT |netapp.ports.eth.get |
|Zabbix_raw_items |Get FC ports |<p>-</p> |HTTP_AGENT |netapp.ports.fc.get |
|Zabbix_raw_items |Get SVMs |<p>-</p> |HTTP_AGENT |netapp.svms.get |
|Zabbix_raw_items |Get LUNs |<p>-</p> |HTTP_AGENT |netapp.luns.get |
|Zabbix_raw_items |Get chassis |<p>-</p> |HTTP_AGENT |netapp.chassis.get |
|Zabbix_raw_items |Get FRUs |<p>-</p> |HTTP_AGENT |netapp.frus.get<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Zabbix_raw_items |Cluster latency raw, other |<p>The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.cluster.statistics.latency_raw.other<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.latency_raw.other`</p> |
|Zabbix_raw_items |Cluster latency raw, read |<p>The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.latency_raw.read<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.latency_raw.read`</p> |
|Zabbix_raw_items |Cluster latency raw, write |<p>The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.latency_raw.write<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.latency_raw.write`</p> |
|Zabbix_raw_items |Cluster latency raw, total |<p>The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.latency_raw.total<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.latency_raw.total`</p> |
|Zabbix_raw_items |Cluster IOPS raw, other |<p>The number of I/O operations observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.cluster.statistics.iops_raw.other<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.other`</p> |
|Zabbix_raw_items |Cluster IOPS raw, read |<p>The number of I/O operations observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops_raw.read<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.read`</p> |
|Zabbix_raw_items |Cluster IOPS raw, write |<p>The number of I/O operations observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops_raw.write<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.write`</p> |
|Zabbix_raw_items |Cluster IOPS raw, total |<p>The number of I/O operations observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.cluster.statistics.iops_raw.total<p>**Preprocessing**:</p><p>- JSONPATH: `$.statistics.iops_raw.total`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume latency raw, other |<p>The raw latency in microseconds observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.volume.statistics.latency_raw.other[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.latency_raw.other.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume latency raw, read |<p>The raw latency in microseconds observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.volume.statistics.latency_raw.read[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.latency_raw.read.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume latency raw, write |<p>The raw latency in microseconds observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.volume.statistics.latency_raw.write[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.latency_raw.write.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume latency raw, total |<p>The raw latency in microseconds observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.volume.statistics.latency_raw.total[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.latency_raw.total.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume IOPS raw, other |<p>The number of I/O operations observed at the storage object. Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.</p> |DEPENDENT |netapp.volume.statistics.iops_raw.other[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.other.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume IOPS raw, read |<p>The number of I/O operations observed at the storage object. Performance metric for read I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops_raw.read[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.read.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume IOPS raw, write |<p>The number of I/O operations observed at the storage object. Performance metric for write I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops_raw.write[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.write.first()`</p> |
|Zabbix_raw_items |{#VOLUMENAME}: Volume IOPS raw, total |<p>The number of I/O operations observed at the storage object. Performance metric aggregated over all types of I/O operations.</p> |DEPENDENT |netapp.volume.statistics.iops_raw.total[{#VOLUMENAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.records[?(@.name=='{#VOLUMENAME}')].statistics.iops_raw.total.first()`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Version has changed (new version: {ITEM.VALUE}) |<p>__RESOURCE__ version has changed. Ack to close.</p> |`{TEMPLATE_NAME:netapp.cluster.version.diff()}=1 and {TEMPLATE_NAME:netapp.cluster.version.strlen()}>0` |INFO |<p>Manual close: YES</p> |
|Cluster status is abnormal |<p>Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, “ok” on success, or “error” on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". “Inconsistent_ delta_time” is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. “Negative_delta” is returned when an expected monotonically increasing value has decreased in value. “Inconsistent_old_data” is returned when one or more nodes do not have the latest data.</p> |`({TEMPLATE_NAME:netapp.cluster.status.last()}<>"ok")` |AVERAGE | |
|{#NODENAME}: Version has changed (new version: {ITEM.VALUE}) |<p>{#NODENAME} version has changed. Ack to close.</p> |`{TEMPLATE_NAME:netapp.node.version[{#NODENAME}].diff()}=1 and {TEMPLATE_NAME:netapp.node.version[{#NODENAME}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|{#NODENAME}: Node state is abnormal |<p>The state of the node is different from up:</p><p>booting - Node is booting up.</p><p>down - Node has stopped or is dumping core.</p><p>taken_over - Node has been taken over by its HA partner and is not yet waiting for giveback.</p><p>waiting_for_giveback - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.</p><p>degraded - Node has one or more critical services offline.</p><p>unknown - Node or its HA partner cannot be contacted and there is no information on the node's state.</p> |`({TEMPLATE_NAME:netapp.nodes.state[{#NODENAME}].last()}<>"up")` |AVERAGE | |
|{#NODENAME}: Node has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:netapp.nodes.uptime[{#NODENAME}].last()}<10m` |INFO |<p>Manual close: YES</p> |
|{#NODENAME}: Node has over temperature |<p>The hardware shuts down if the temperature exceeds critical thresholds(item's value is "over").</p> |`({TEMPLATE_NAME:netapp.nodes.controller.over_temperature[{#NODENAME}].last()}<>"normal")` |AVERAGE | |
|{#ETHPORTNAME}: Ethernet port of the Node "{#NODENAME}" is down |<p>Something is wrong with the ethernet port.</p> |`({TEMPLATE_NAME:netapp.port.eth.state[{#NODENAME},{#ETHPORTNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.port.eth.state[{#NODENAME},{#ETHPORTNAME}].last()}="down")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.port.eth.state[{#NODENAME},{#ETHPORTNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.port.eth.state[{#NODENAME},{#ETHPORTNAME}].last()}="up")` |AVERAGE |<p>Manual close: YES</p> |
|{#FCPORTNAME}: FC port of the Node "{#NODENAME}" has state different from "online" |<p>Something is wrong with the FC port.</p> |`({TEMPLATE_NAME:netapp.port.fc.state[{#NODENAME},{#FCPORTNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.port.fc.state[{#NODENAME},{#FCPORTNAME}].last()}<>"online")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.port.fc.state[{#NODENAME},{#FCPORTNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.port.fc.state[{#NODENAME},{#FCPORTNAME}].last()}="online")` |AVERAGE |<p>Manual close: YES</p> |
|{#DISKNAME}: Disk of the Node "{#NODENAME}" has state different from "present" |<p>Something is wrong with the disk.</p> |`({TEMPLATE_NAME:netapp.disk.state[{#NODENAME},{#DISKNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.disk.state[{#NODENAME},{#DISKNAME}].last()}<>"present")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.disk.state[{#NODENAME},{#DISKNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.disk.state[{#NODENAME},{#DISKNAME}].last()}="present")` |AVERAGE |<p>Manual close: YES</p> |
|{#ID}: Chassis has something errors |<p>Something is wrong with the chassis.</p> |`({TEMPLATE_NAME:netapp.chassis.state[{#ID}].diff()}=1 and {TEMPLATE_NAME:netapp.chassis.state[{#ID}].last()}="error")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.chassis.state[{#ID}].diff()}=1 and {TEMPLATE_NAME:netapp.chassis.state[{#ID}].last()}="ok")` |AVERAGE |<p>Manual close: YES</p> |
|{#FRUID}: FRU of the chassis "{#ID}" state is error |<p>Something is wrong with the FRU.</p> |`({TEMPLATE_NAME:netapp.chassis.fru.state[{#CHASSISID},{#FRUID}].diff()}=1 and {TEMPLATE_NAME:netapp.chassis.fru.state[{#CHASSISID},{#FRUID}].last()}="error")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.chassis.fru.state[{#CHASSISID},{#FRUID}].diff()}=1 and {TEMPLATE_NAME:netapp.chassis.fru.state[{#CHASSISID},{#FRUID}].last()}="ok")` |AVERAGE |<p>Manual close: YES</p> |
|{#SVMNAME}: SVM state is abnormal |<p>Something is wrong with the SVM.</p> |`({TEMPLATE_NAME:netapp.svm.state[{#SVMNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.svm.state[{#SVMNAME}].last()}<>"running")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.svm.state[{#SVMNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.svm.state[{#SVMNAME}].last()}="running")` |AVERAGE |<p>Manual close: YES</p> |
|{#LUNNAME}: LUN of the SVM "{#SVMNAME}" has abnormal state |<p>Normal states for a LUN are online and offline. Other states indicate errors.</p> |`({TEMPLATE_NAME:netapp.lun.status.state[{#SVMNAME},{#LUNNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.lun.status.state[{#SVMNAME},{#LUNNAME}].last()}<>"online")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.lun.status.state[{#SVMNAME},{#LUNNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.lun.status.state[{#SVMNAME},{#LUNNAME}].last()}="online")` |AVERAGE |<p>Manual close: YES</p> |
|{#LUNNAME}: LUN of the SVM "{#SVMNAME}" has abnormal container state |<p>LUNs are only available when their containers are available.</p> |`({TEMPLATE_NAME:netapp.lun.status.container_state[{#SVMNAME},{#LUNNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.lun.status.container_state[{#SVMNAME},{#LUNNAME}].last()}<>"online")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.lun.status.container_state[{#SVMNAME},{#LUNNAME}].diff()}=1 and {TEMPLATE_NAME:netapp.lun.status.container_state[{#SVMNAME},{#LUNNAME}].last()}="online")` |AVERAGE |<p>Manual close: YES</p> |
|{#VOLUMENAME}: Volume state is abnormal |<p>A volume can only be brought online if it is offline. Taking a volume offline removes its junction path. The 'mixed' state applies to FlexGroup volumes only and cannot be specified as a target state. An 'error' state implies that the volume is not in a state to serve data.</p> |`({TEMPLATE_NAME:netapp.volume.state[{#VOLUMENAME}].diff()}=1 and {TEMPLATE_NAME:netapp.volume.state[{#VOLUMENAME}].last()}<>"online")`<p>Recovery expression:</p>`({TEMPLATE_NAME:netapp.volume.state[{#VOLUMENAME}].diff()}=1 and {TEMPLATE_NAME:netapp.volume.state[{#VOLUMENAME}].last()}="online")` |AVERAGE |<p>Manual close: YES</p> |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide a feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/).

