+++
title = "Transient"
weight = 12
+++


# Interlayer transients

The interlayer transient describes the in-depth material profile of
laterally averaged roughness.

It must be specified through one of

```python
ba.ErfTransient()
ba.TanhTransient()
```

This defines the type of height distribution, while the root-meas-square
value $\sigma$ is taken from [interface autocorrelation model](../interface)

### Erf transient

```python
ba.ErfTransient()
```

Corresponds to roughness with Gaussian height statistics.

The profile function:

$$
\dfrac{1}{2}\Big[1+erf\Big( \dfrac{x}{\sqrt{2}\sigma}\Big)\Big]
$$

### Tanh transient

```python
ba.TanhTransient()
```

Corresponds to roughness with non-Gaussian height statistics, with longer tails.

The profile function:

$$
\dfrac{1}{2}\Big[1+tanh\Big( \dfrac{\pi x}{2\sqrt{3}\sigma}\Big)\Big]
$$

## Example: specular reflectivity

This example demonstrates how to apply different transients
in a specular reflectivity calculation. 

However, now the computation is performed twice with the standard $tanh$ interface profile
and $erf$ (Névot-Croce) model that arises from a Gaussian distribution of the
deviation from the mean-surface position.

{{< figscg src="/img/auto/specular/RoughnessModel.png" width="650px">}}

In both cases, the root-mean-square deviation from the mean surface position is chosen
to be $\sigma = 1$ nm.

{{< show-ex file="specular/RoughnessModel.py" >}}
