<a href="https://picturepan2.github.io/spectre">
  <img src="https://picturepan2.github.io/spectre/img/spectre-logo.svg" width="72" height="72">
</a>

## Spectre.css

[![Reviewed by Hound](https://img.shields.io/badge/Reviewed_by-Hound-8E64B0.svg)](https://houndci.com)

Spectre.css is a lightweight, responsive and modern CSS framework.

- Lightweight (~10KB gzipped) starting point for your projects
- Flexbox-based, responsive and mobile-friendly layout
- Elegantly designed and developed elements and components

Spectre is a side project based on years of CSS development work on a large web service project. Spectre only includes modern base styles, responsive layout system, CSS components and utilities, and it can be modified for your project with Sass/Scss compiler.

Spectre.css is completely free to use. If you enjoy it, please consider [donating via Paypal](https://www.paypal.me/picturepan2) or [via Patreon](https://www.patreon.com/spectrecss) for the further development. ♥ 


## Getting started

There are 5 ways to get started with Spectre CSS framework in your projects. You can either manually install or use NPM, Yarn and Bower.

### Install manually
Download the compiled and minified [Spectre CSS files](https://github.com/picturepan2/spectre/tree/master/docs/dist). And include `spectre.css` located in `/docs/dist` in your website or Web app &lt;head&gt; part.

`<link rel="stylesheet" href="spectre.min.css">`

### Install from CDN
Alternatively, you can use the [unpkg](https://unpkg.com/) or [cdnjs](https://cdnjs.com/libraries/spectre.css) CDN to load compiled Spectre.css.

`<link rel="stylesheet" href="https://unpkg.com/spectre.css/dist/spectre.min.css">`

### Install with NPM
`$ npm install spectre.css --save`

### Install with Yarn
`$ yarn add spectre.css`

### Install with Bower
`$ bower install spectre.css --save`

## Compiling custom version

You can compile your custom version of Spectre.css. Read [the documentation](https://picturepan2.github.io/spectre/getting-started/custom.html).

## Documentation and examples

### Elements

- [Typography](https://picturepan2.github.io/spectre/elements/typography.html)
- [Tables](https://picturepan2.github.io/spectre/elements/tables.html)
- [Buttons](https://picturepan2.github.io/spectre/elements/buttons.html)
- [Forms](https://picturepan2.github.io/spectre/elements/forms.html)
- [Icons.css](https://picturepan2.github.io/icons.css) - CSS ONLY
- [Labels](https://picturepan2.github.io/spectre/elements/labels.html)
- [Code](https://picturepan2.github.io/spectre/elements/code.html)
- [Media](https://picturepan2.github.io/spectre/elements/media.html)

### Layout
- [Flexbox grid](https://picturepan2.github.io/spectre/layout/grid.html) 
- [Responsive](https://picturepan2.github.io/spectre/layout/responsive.html)
- [Hero](https://picturepan2.github.io/spectre/layout/hero.html)
- [Navbar](https://picturepan2.github.io/spectre/layout/navbar.html)

### Components
- [Accordions](https://picturepan2.github.io/spectre/components/accordions.html)
- [Avatars](https://picturepan2.github.io/spectre/components/avatars.html)
- [Badges](https://picturepan2.github.io/spectre/components/badges.html)
- [Breadcrumbs](https://picturepan2.github.io/spectre/components/breadcrumbs.html)
- [Bars](https://picturepan2.github.io/spectre/components/bars.html)
- [Cards](https://picturepan2.github.io/spectre/components/cards.html)
- [Chips](https://picturepan2.github.io/spectre/components/chips.html)
- [Empty states](https://picturepan2.github.io/spectre/components/empty.html)
- [Menu](https://picturepan2.github.io/spectre/components/menu.html)
- [Nav](https://picturepan2.github.io/spectre/components/nav.html)
- [Modals](https://picturepan2.github.io/spectre/components/modals.html)
- [Pagination](https://picturepan2.github.io/spectre/components/pagination.html)
- [Panels](https://picturepan2.github.io/spectre/components/panels.html)
- [Popovers](https://picturepan2.github.io/spectre/components/popovers.html)
- [Steps](https://picturepan2.github.io/spectre/components/steps.html)
- [Tabs](https://picturepan2.github.io/spectre/components/tabs.html)
- [Tiles](https://picturepan2.github.io/spectre/components/tiles.html)
- [Toasts](https://picturepan2.github.io/spectre/components/toasts.html)
- [Tooltips](https://picturepan2.github.io/spectre/components/tooltips.html)

### Utilities

- [Utilities](https://picturepan2.github.io/spectre/utilities.html) - colors, display, divider, loading, position, shapes and text utilities

### Experimentals
- [360-Degree Viewer](https://picturepan2.github.io/spectre/experimentals/viewer-360.html) - CSS ONLY
- [Autocomplete](https://picturepan2.github.io/spectre/experimentals/autocomplete.html)
- [Calendars](https://picturepan2.github.io/spectre/experimentals/calendars.html)
- [Carousels](https://picturepan2.github.io/spectre/experimentals/carousels.html) - CSS ONLY
- [Comparison Sliders](https://picturepan2.github.io/spectre/experimentals/comparison.html) - CSS ONLY
- [Filters](https://picturepan2.github.io/spectre/experimentals/filters.html) - CSS ONLY
- [Meters](https://picturepan2.github.io/spectre/experimentals/meters.html)
- [Off-canvas](https://picturepan2.github.io/spectre/experimentals/off-canvas.html) - CSS ONLY
- [Parallax](https://picturepan2.github.io/spectre/experimentals/parallax.html) - CSS ONLY
- [Progress](https://picturepan2.github.io/spectre/experimentals/progress.html)
- [Sliders](https://picturepan2.github.io/spectre/experimentals/sliders.html)
- [Timelines](https://picturepan2.github.io/spectre/experimentals/timelines.html)

## Browser support
Spectre uses [Autoprefixer](https://github.com/postcss/autoprefixer) to make most styles compatible with earlier browsers and [Normalize.css](https://necolas.github.io/normalize.css/) for CSS resets. Spectre is designed for modern browsers. For best compatibility, these browsers are recommended:

- Chrome (LAST 4)
- Microsoft Edge (LAST 4)
- Firefox (EXTENDED SUPPORT RELEASE)
- Safari (LAST 4)
- Opera (LAST 4)
- Internet Explorer 10+

Spectre supports Internet Explorer 10+, but some HTML5 and CSS3 features are not perfectly supported by Internet Explorer.

Designed and built with ♥ by [Yan Zhu](https://twitter.com/picturepan2). Feel free to submit a pull request. Help is always appreciated.
