#
# @file    TestKineticLaw_newSetters.py
# @brief   KineticLaw unit tests for new set function API
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestKineticLaw_newSetters.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestKineticLaw_newSetters(unittest.TestCase):

  global kl
  kl = None

  def setUp(self):
    self.kl = libsbml.KineticLaw(2,4)
    if (self.kl == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_addParameter1(self):
    self.kl = libsbml.KineticLaw(2,2)
    p = libsbml.Parameter(2,2)
    i = self.kl.addParameter(p)
    self.assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT )
    p.setId( "p")
    i = self.kl.addParameter(p)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue( self.kl.getNumParameters() == 1 )
    _dummyList = [ p ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_addParameter2(self):
    self.kl = libsbml.KineticLaw(2,2)
    p = libsbml.Parameter(2,1)
    p.setId( "p")
    i = self.kl.addParameter(p)
    self.assertTrue( i == libsbml.LIBSBML_VERSION_MISMATCH )
    self.assertTrue( self.kl.getNumParameters() == 0 )
    _dummyList = [ p ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_addParameter3(self):
    self.kl = libsbml.KineticLaw(2,2)
    p = libsbml.Parameter(1,2)
    p.setId( "p")
    i = self.kl.addParameter(p)
    self.assertTrue( i == libsbml.LIBSBML_LEVEL_MISMATCH )
    self.assertTrue( self.kl.getNumParameters() == 0 )
    _dummyList = [ p ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_addParameter4(self):
    self.kl = libsbml.KineticLaw(2,2)
    p = None
    i = self.kl.addParameter(p)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_FAILED )
    self.assertTrue( self.kl.getNumParameters() == 0 )
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_createParameter(self):
    self.kl = libsbml.KineticLaw(2,2)
    p = self.kl.createParameter()
    self.assertTrue( self.kl.getNumParameters() == 1 )
    self.assertTrue( (p).getLevel() == 2 )
    self.assertTrue( (p).getVersion() == 2 )
    _dummyList = [ self.kl ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setFormula1(self):
    formula =  "k1*X0";
    i = self.kl.setFormula(formula)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertTrue(( formula == self.kl.getFormula() ))
    self.assertEqual( True, self.kl.isSetFormula() )
    pass  

  def test_KineticLaw_setFormula2(self):
    i = self.kl.setFormula("")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, self.kl.isSetFormula() )
    pass  

  def test_KineticLaw_setFormula3(self):
    formula =  "k1 X0";
    i = self.kl.setFormula(formula)
    self.assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT )
    self.assertEqual( False, self.kl.isSetFormula() )
    pass  

  def test_KineticLaw_setMath1(self):
    math = libsbml.ASTNode(libsbml.AST_TIMES)
    a = libsbml.ASTNode()
    b = libsbml.ASTNode()
    a.setName( "a")
    b.setName( "b")
    math.addChild(a)
    math.addChild(b)
    i = self.kl.setMath(math)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, self.kl.isSetMath() )
    math1 = self.kl.getMath()
    self.assertTrue( math1 != None )
    formula = libsbml.formulaToString(math1)
    self.assertTrue( formula != None )
    self.assertTrue((  "a * b" == formula ))
    _dummyList = [ math ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setMath2(self):
    math = libsbml.ASTNode(libsbml.AST_DIVIDE)
    a = libsbml.ASTNode()
    a.setName( "a")
    math.addChild(a)
    i = self.kl.setMath(math)
    self.assertTrue( i == libsbml.LIBSBML_INVALID_OBJECT )
    self.assertEqual( False, self.kl.isSetMath() )
    _dummyList = [ math ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setMath3(self):
    i = self.kl.setMath(None)
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, self.kl.isSetMath() )
    pass  

  def test_KineticLaw_setSubstanceUnits1(self):
    i = self.kl.setSubstanceUnits( "mole")
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertEqual( False, self.kl.isSetSubstanceUnits() )
    i = self.kl.unsetSubstanceUnits()
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertEqual( False, self.kl.isSetSubstanceUnits() )
    pass  

  def test_KineticLaw_setSubstanceUnits2(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setSubstanceUnits( "mole")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, kl1.isSetSubstanceUnits() )
    i = kl1.unsetSubstanceUnits()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetSubstanceUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setSubstanceUnits3(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setSubstanceUnits( "1second")
    self.assertTrue( i == libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE )
    self.assertEqual( False, kl1.isSetSubstanceUnits() )
    i = kl1.unsetSubstanceUnits()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetSubstanceUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setSubstanceUnits4(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setSubstanceUnits("")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetSubstanceUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setTimeUnits1(self):
    i = self.kl.setTimeUnits( "second")
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertEqual( False, self.kl.isSetTimeUnits() )
    i = self.kl.unsetTimeUnits()
    self.assertTrue( i == libsbml.LIBSBML_UNEXPECTED_ATTRIBUTE )
    self.assertEqual( False, self.kl.isSetTimeUnits() )
    pass  

  def test_KineticLaw_setTimeUnits2(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setTimeUnits( "second")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( True, kl1.isSetTimeUnits() )
    i = kl1.unsetTimeUnits()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetTimeUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setTimeUnits3(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setTimeUnits( "1second")
    self.assertTrue( i == libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE )
    self.assertEqual( False, kl1.isSetTimeUnits() )
    i = kl1.unsetTimeUnits()
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetTimeUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_KineticLaw_setTimeUnits4(self):
    kl1 = libsbml.KineticLaw(1,2)
    i = kl1.setTimeUnits("")
    self.assertTrue( i == libsbml.LIBSBML_OPERATION_SUCCESS )
    self.assertEqual( False, kl1.isSetTimeUnits() )
    _dummyList = [ kl1 ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestKineticLaw_newSetters))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
