% vcflib(1) vcflib | vcflib (index)
% Erik Garrison and vcflib contributors

# NAME

**vcflib** index

# DESCRIPTION

vcflib contains tools and libraries for dealing with the Variant Call
Format (VCF) which is a flat-file, tab-delimited textual format
intended to describe reference-indexed variations between
individuals.

VCF provides a common interchange format for the description of
variation in individuals and populations of samples, and has become
the defacto standard reporting format for a wide array of genomic
variant detectors.

vcflib provides methods to manipulate and interpret sequence variation
as it can be described by VCF. It is both:

* an API for parsing and operating on records of genomic variation as it can be described by the VCF format,
* and a collection of command-line utilities for executing complex manipulations on VCF files.

The API itself provides a quick and extremely permissive method to
read and write VCF files. Extensions and applications of the library
provided in the included utilities (*.cpp) comprise the vast bulk of
the library's utility for most users.

<!--
  Created with ./scripts/bin2md.rb --index
-->


## filter

| filter command | description |
| :-------------- | :---------- |

## metrics

| metrics command | description |
| :-------------- | :---------- |

## phenotype

| phenotype command | description |
| :-------------- | :---------- |

## genotype

| genotype command | description |
| :-------------- | :---------- |

## transformation

| transformation command | description |
| :-------------- | :---------- |

## statistics

| statistics command | description |
| :-------------- | :---------- |

# SOURCE CODE

See the source code repository at https://github.com/vcflib/vcflib

# LICENSE

Copyright 2011-2022 (C) Erik Garrison and vcflib contributors. MIT licensed.

