% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macros.R
\name{.check_valid_util}
\alias{.check_valid_util}
\title{Checks for valid members of subdirectory}
\usage{
.check_valid_util(util, utils = NULL, path = NULL)
}
\arguments{
\item{util}{name of target located in path}

\item{utils}{name of supported targets in path}

\item{path}{path to directory}
}
\value{
safe path to util, or error if util does not exist
}
\description{
Not meant to be called directly
}
\examples{
if (.Platform$OS.type == "unix") {
# this will return /full/path/to/bin
# or return an error for all values of util that are not "ls" and "pwd"
# or error if "ls" does not exist in "/bin"
.check_valid_util("ls", utils = c("ls", "pwd"), "/bin")

\dontrun{
# This will throw error
.check_valid_util("badUtil", utils = c("ls", "pwd"), "/bin")
}
}
}
