% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{use_package}
\alias{use_package}
\alias{use_dev_package}
\title{Depend on another package}
\usage{
use_package(package, type = "Imports", min_version = NULL)

use_dev_package(package, type = "Imports", remote = NULL)
}
\arguments{
\item{package}{Name of package to depend on.}

\item{type}{Type of dependency: must be one of "Imports", "Depends",
"Suggests", "Enhances", or "LinkingTo" (or unique abbreviation). Matching
is case insensitive.}

\item{min_version}{Optionally, supply a minimum version for the package.
Set to \code{TRUE} to use the currently installed version.}

\item{remote}{By default, an \code{OWNER/REPO} GitHub remote is inserted.
Optionally, you can supply a character string to specify the remote, e.g.
\code{"gitlab::jimhester/covr"}, using any syntax supported by the \href{https://remotes.r-lib.org/articles/dependencies.html#other-sources}{remotes package}.}
}
\description{
\code{use_package()} adds a CRAN package dependency to \code{DESCRIPTION} and offers a
little advice about how to best use it. \code{use_dev_package()} adds a
dependency on an in-development package, adding the dev repo to \code{Remotes} so
it will be automatically installed from the correct location.
}
\examples{
\dontrun{
use_package("ggplot2")
use_package("dplyr", "suggests")
use_dev_package("glue")
}
}
\seealso{
The \href{https://r-pkgs.org/description.html#dependencies}{dependencies section} of \href{https://r-pkgs.org}{R Packages}.
}
