% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.R
\name{rotcumvar}
\alias{rotcumvar}
\title{Rotated Cumulative Variance}
\usage{
rotcumvar(x)
}
\arguments{
\item{x}{vector of coefficients to be cumulatively summed (missing values
excluded)}
}
\value{
Vector of coefficients that are the sumulative sum of squared input
coefficients.
}
\description{
Provides the normalized cumulative sums of squares from a sequence of
coefficients with the diagonal line removed.
}
\details{
The rotated cumulative variance, when plotted, provides a qualitative way to
study the time dependence of the variance of a series.  If the variance is
stationary over time, then only small deviations from zero should be
present.  If on the other hand the variance is non-stationary, then large
departures may exist.  Formal hypothesis testing may be performed based on
boundary crossings of Brownian bridge processes.
}
\references{
Gencay, R., F. Selcuk and B. Whitcher (2001) \emph{An
Introduction to Wavelets and Other Filtering Methods in Finance and
Economics}, Academic Press.

Percival, D. B. and A. T. Walden (2000) \emph{Wavelet Methods for Time
Series Analysis}, Cambridge University Press.
}
\author{
B. Whitcher
}
\keyword{ts}
