% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{wk_flatten}
\alias{wk_flatten}
\alias{wk_flatten_filter}
\title{Extract simple geometries}
\usage{
wk_flatten(handleable, ..., max_depth = 1)

wk_flatten_filter(handler, max_depth = 1L, add_details = FALSE)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{max_depth}{The maximum (outer) depth to remove.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}

\item{add_details}{Use \code{TRUE} to add a "wk_details" attribute, which
contains columns \code{feature_id}, \code{part_id}, and \code{ring_id}.}
}
\value{
\code{handleable} transformed such that collections have been
expanded and only simple geometries (point, linestring, polygon)
remain.
}
\description{
Extract simple geometries
}
\examples{
wk_flatten(wkt("MULTIPOINT (1 1, 2 2, 3 3)"))
wk_flatten(
  wkt("GEOMETRYCOLLECTION (GEOMETRYCOLLECTION (GEOMETRYCOLLECTION (POINT (0 1))))"),
  max_depth = 2
)

}
