RabbitMQ `3.10.10` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires Erlang 24.2 and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Bug Fixes

  * Partially reverts an unsafe inter-node communication [optimization](https://github.com/rabbitmq/rabbitmq-server/pull/3865) that could affect
    classic mirrored queue operation ordering.

    Kudos to @bording for providing an automated way to reproduce the issue.

    GitHub issue: [#6115](https://github.com/rabbitmq/rabbitmq-server/issues/6115)

  * Classic mirrored queue leader replica issued to much credit to follower replicas,
    resulting in an uneven load and memory footprint between them.

    GitHub issue: [#6110](https://github.com/rabbitmq/rabbitmq-server/pull/6110)

  * Intra-cluster communication link metric collector could run into an exception when
    peer connection has just been re-established, e.g. after a peer node restart.

    GitHub issue: [#6127](https://github.com/rabbitmq/rabbitmq-server/pull/6127)

### MQTT Plugin

#### Bug Fixes

  * When a node was [put into maintenance mode](https://www.rabbitmq.com/upgrade.html#maintenance-mode), it closed all MQTT client connections
    cluster-wide instead of just local client connections.

    GitHub issue: [#6108](https://github.com/rabbitmq/rabbitmq-server/pull/6108)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.10.tar.xz`
instead of the source tarball produced by GitHub.
