#! /bin/bash

# Test update of a record.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g').db

DB_DIR=db
DB_FILE=${DB_DIR}/test3.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}

cp ${DB_FILE} ${TMP_DB_FILE}

unset $(printenv | awk -F= '!/^PATH=/&&!/PERL5LIB/&&/=/{print $1}' | grep -v '()')

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography/7"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export QUERY_STRING="test=one"
export CONTENT_LENGTH=1024
export CONTENT_TYPE="application/x-www-form-urlencoded"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

${INPUT_SCRIPT} <<EOF |
column%3Abibliography%3A0.id=7&column%3Abibliography%3A0.authors=Saulius+Gra%C5%BEulis&column%3Abibliography%3A0.title=UTF-8+test+%C5%BE%C5%BE&column%3Abibliography%3A0.year=2018&Update=Update
EOF
sed "s/${TMP_TEST_DB}/database/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
