require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_REISER_FS_SB)) {
    eval 'sub _LINUX_REISER_FS_SB () {1;}' unless defined(&_LINUX_REISER_FS_SB);
    eval 'sub REISERFS_VERSION_2 () {2;}' unless defined(&REISERFS_VERSION_2);
    eval 'sub UNSET_HASH () {0;}' unless defined(&UNSET_HASH);
    eval 'sub TEA_HASH () {1;}' unless defined(&TEA_HASH);
    eval 'sub YURA_HASH () {2;}' unless defined(&YURA_HASH);
    eval 'sub R5_HASH () {3;}' unless defined(&R5_HASH);
    eval 'sub DEFAULT_HASH () { &R5_HASH;}' unless defined(&DEFAULT_HASH);
    eval 'sub SB_SIZE () {($sizeof{\'struct reiserfs_super_block\'});}' unless defined(&SB_SIZE);
    eval 'sub sb_block_count {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_block_count)));
    }' unless defined(&sb_block_count);
    eval 'sub set_sb_block_count {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_block_count =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_block_count);
    eval 'sub sb_free_blocks {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_free_blocks)));
    }' unless defined(&sb_free_blocks);
    eval 'sub set_sb_free_blocks {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_free_blocks =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_free_blocks);
    eval 'sub sb_root_block {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_root_block)));
    }' unless defined(&sb_root_block);
    eval 'sub set_sb_root_block {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_root_block =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_root_block);
    eval 'sub sb_journal_block {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_block)));
    }' unless defined(&sb_journal_block);
    eval 'sub set_sb_journal_block {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_block =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_journal_block);
    eval 'sub sb_journal_dev {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_dev)));
    }' unless defined(&sb_journal_dev);
    eval 'sub set_sb_journal_dev {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_dev =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_journal_dev);
    eval 'sub sb_orig_journal_size {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_orig_journal_size)));
    }' unless defined(&sb_orig_journal_size);
    eval 'sub set_sb_orig_journal_size {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_orig_journal_size =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_orig_journal_size);
    eval 'sub sb_journal_trans_max {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_trans_max)));
    }' unless defined(&sb_journal_trans_max);
    eval 'sub set_journal_trans_max {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_trans_max =  &cpu_to_le32($v)));
    }' unless defined(&set_journal_trans_max);
    eval 'sub sb_journal_block_count {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &journal_block_count)));
    }' unless defined(&sb_journal_block_count);
    eval 'sub sb_set_journal_block_count {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_block_count =  &cpu_to_le32($v)));
    }' unless defined(&sb_set_journal_block_count);
    eval 'sub sb_journal_max_batch {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_max_batch)));
    }' unless defined(&sb_journal_max_batch);
    eval 'sub set_sb_journal_max_batch {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_max_batch =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_journal_max_batch);
    eval 'sub sb_jourmal_max_commit_age {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_max_commit_age)));
    }' unless defined(&sb_jourmal_max_commit_age);
    eval 'sub set_sb_journal_max_commit_age {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_max_commit_age =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_journal_max_commit_age);
    eval 'sub sb_jourmal_max_trans_age {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_journal_max_trans_age)));
    }' unless defined(&sb_jourmal_max_trans_age);
    eval 'sub set_sb_journal_max_trans_age {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_journal_max_trans_age =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_journal_max_trans_age);
    eval 'sub sb_blocksize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_blocksize)));
    }' unless defined(&sb_blocksize);
    eval 'sub set_sb_blocksize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_blocksize =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_blocksize);
    eval 'sub sb_oid_maxsize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_oid_maxsize)));
    }' unless defined(&sb_oid_maxsize);
    eval 'sub set_sb_oid_maxsize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_oid_maxsize =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_maxsize);
    eval 'sub sb_oid_cursize {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_oid_cursize)));
    }' unless defined(&sb_oid_cursize);
    eval 'sub set_sb_oid_cursize {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_oid_cursize =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_oid_cursize);
    eval 'sub sb_state {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_state)));
    }' unless defined(&sb_state);
    eval 'sub set_sb_state {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_state =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_state);
    eval 'sub sb_hash_function_code {
        my($sbp) = @_;
	    eval q(( &le32_to_cpu(($sbp)-> &s_hash_function_code)));
    }' unless defined(&sb_hash_function_code);
    eval 'sub set_sb_hash_function_code {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_hash_function_code =  &cpu_to_le32($v)));
    }' unless defined(&set_sb_hash_function_code);
    eval 'sub sb_tree_height {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_tree_height)));
    }' unless defined(&sb_tree_height);
    eval 'sub set_sb_tree_height {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_tree_height =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_tree_height);
    eval 'sub sb_bmap_nr {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_bmap_nr)));
    }' unless defined(&sb_bmap_nr);
    eval 'sub set_sb_bmap_nr {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_bmap_nr =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_bmap_nr);
    eval 'sub sb_version {
        my($sbp) = @_;
	    eval q(( &le16_to_cpu(($sbp)-> &s_version)));
    }' unless defined(&sb_version);
    eval 'sub set_sb_version {
        my($sbp,$v) = @_;
	    eval q((($sbp)-> &s_version =  &cpu_to_le16($v)));
    }' unless defined(&set_sb_version);
    eval 'sub SB_SIZE_V1 () {($sizeof{\'struct reiserfs_super_block_v1\'});}' unless defined(&SB_SIZE_V1);
    eval 'sub JOURNAL_BLOCK_SIZE () {4096;}' unless defined(&JOURNAL_BLOCK_SIZE);
    eval 'sub JOURNAL_MAX_CNODE () {1500;}' unless defined(&JOURNAL_MAX_CNODE);
    eval 'sub JOURNAL_TRANS_MAX () {1024;}' unless defined(&JOURNAL_TRANS_MAX);
    eval 'sub JOURNAL_HASH_SIZE () {8192;}' unless defined(&JOURNAL_HASH_SIZE);
    eval 'sub JOURNAL_NUM_BITMAPS () {5;}' unless defined(&JOURNAL_NUM_BITMAPS);
    eval 'sub JOURNAL_LIST_COUNT () {64;}' unless defined(&JOURNAL_LIST_COUNT);
    eval 'sub BH_JDirty () {16;}' unless defined(&BH_JDirty);
    eval 'sub BH_JDirty_wait () {18;}' unless defined(&BH_JDirty_wait);
    eval 'sub BH_JNew () {19;}' unless defined(&BH_JNew);
    eval 'sub BH_JPrepared () {20;}' unless defined(&BH_JPrepared);
    eval 'sub BH_JRestore_dirty () {22;}' unless defined(&BH_JRestore_dirty);
    eval 'sub JOURNAL_DESC_MAGIC () {"ReIsErLB";}' unless defined(&JOURNAL_DESC_MAGIC);
    eval 'sub NOTAIL () {0;}' unless defined(&NOTAIL);
    eval 'sub REPLAYONLY () {3;}' unless defined(&REPLAYONLY);
    eval 'sub REISERFS_NOLOG () {4;}' unless defined(&REISERFS_NOLOG);
    eval 'sub REISERFS_CONVERT () {5;}' unless defined(&REISERFS_CONVERT);
    eval 'sub FORCE_TEA_HASH () {6;}' unless defined(&FORCE_TEA_HASH);
    eval 'sub FORCE_RUPASOV_HASH () {7;}' unless defined(&FORCE_RUPASOV_HASH);
    eval 'sub FORCE_R5_HASH () {8;}' unless defined(&FORCE_R5_HASH);
    eval 'sub FORCE_HASH_DETECT () {9;}' unless defined(&FORCE_HASH_DETECT);
    eval 'sub REISERFS_NO_BORDER () {11;}' unless defined(&REISERFS_NO_BORDER);
    eval 'sub REISERFS_NO_UNHASHED_RELOCATION () {12;}' unless defined(&REISERFS_NO_UNHASHED_RELOCATION);
    eval 'sub REISERFS_HASHED_RELOCATION () {13;}' unless defined(&REISERFS_HASHED_RELOCATION);
    eval 'sub REISERFS_TEST4 () {14;}' unless defined(&REISERFS_TEST4);
    eval 'sub REISERFS_TEST1 () {11;}' unless defined(&REISERFS_TEST1);
    eval 'sub REISERFS_TEST2 () {12;}' unless defined(&REISERFS_TEST2);
    eval 'sub REISERFS_TEST3 () {13;}' unless defined(&REISERFS_TEST3);
    eval 'sub REISERFS_TEST4 () {14;}' unless defined(&REISERFS_TEST4);
    eval 'sub reiserfs_r5_hash {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_R5_HASH)));
    }' unless defined(&reiserfs_r5_hash);
    eval 'sub reiserfs_rupasov_hash {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_RUPASOV_HASH)));
    }' unless defined(&reiserfs_rupasov_hash);
    eval 'sub reiserfs_tea_hash {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_TEA_HASH)));
    }' unless defined(&reiserfs_tea_hash);
    eval 'sub reiserfs_hash_detect {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &FORCE_HASH_DETECT)));
    }' unless defined(&reiserfs_hash_detect);
    eval 'sub reiserfs_no_border {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NO_BORDER)));
    }' unless defined(&reiserfs_no_border);
    eval 'sub reiserfs_no_unhashed_relocation {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NO_UNHASHED_RELOCATION)));
    }' unless defined(&reiserfs_no_unhashed_relocation);
    eval 'sub reiserfs_hashed_relocation {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_HASHED_RELOCATION)));
    }' unless defined(&reiserfs_hashed_relocation);
    eval 'sub reiserfs_test4 {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_TEST4)));
    }' unless defined(&reiserfs_test4);
    eval 'sub dont_have_tails {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &NOTAIL)));
    }' unless defined(&dont_have_tails);
    eval 'sub replay_only {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REPLAYONLY)));
    }' unless defined(&replay_only);
    eval 'sub reiserfs_dont_log {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_NOLOG)));
    }' unless defined(&reiserfs_dont_log);
    eval 'sub old_format_only {
        my($s) = @_;
	    eval q((( &SB_VERSION($s) !=  &REISERFS_VERSION_2)  && !(($s)-> ($u->{reiserfs_sb}->{s_mount_opt}) & (1<<  &REISERFS_CONVERT))));
    }' unless defined(&old_format_only);
    eval 'sub CARRY_ON () {0;}' unless defined(&CARRY_ON);
    eval 'sub SCHEDULE_OCCURRED () {1;}' unless defined(&SCHEDULE_OCCURRED);
    eval 'sub SB_BUFFER_WITH_SB {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_sbh})));
    }' unless defined(&SB_BUFFER_WITH_SB);
    eval 'sub SB_JOURNAL {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_journal})));
    }' unless defined(&SB_JOURNAL);
    eval 'sub SB_JOURNAL_LIST {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_list));
    }' unless defined(&SB_JOURNAL_LIST);
    eval 'sub SB_JOURNAL_LIST_INDEX {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_list_index));
    }' unless defined(&SB_JOURNAL_LIST_INDEX);
    eval 'sub SB_JOURNAL_LEN_FREE {
        my($s) = @_;
	    eval q(( &SB_JOURNAL($s)-> &j_journal_len_free));
    }' unless defined(&SB_JOURNAL_LEN_FREE);
    eval 'sub SB_AP_BITMAP {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_ap_bitmap})));
    }' unless defined(&SB_AP_BITMAP);
    eval 'sub SB_DISK_SUPER_BLOCK {
        my($s) = @_;
	    eval q((($s)-> ($u->{reiserfs_sb}->{s_rs})));
    }' unless defined(&SB_DISK_SUPER_BLOCK);
    eval 'sub SB_BLOCK_COUNT {
        my($s) = @_;
	    eval q( &sb_block_count ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_BLOCK_COUNT);
    eval 'sub SB_FREE_BLOCKS {
        my($s) = @_;
	    eval q( &sb_free_blocks ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_FREE_BLOCKS);
    eval 'sub SB_REISERFS_MAGIC {
        my($s) = @_;
	    eval q(( &SB_DISK_SUPER_BLOCK($s)-> &s_magic));
    }' unless defined(&SB_REISERFS_MAGIC);
    eval 'sub SB_ROOT_BLOCK {
        my($s) = @_;
	    eval q( &sb_root_block ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_ROOT_BLOCK);
    eval 'sub SB_TREE_HEIGHT {
        my($s) = @_;
	    eval q( &sb_tree_height ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_TREE_HEIGHT);
    eval 'sub SB_REISERFS_STATE {
        my($s) = @_;
	    eval q( &sb_state ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_REISERFS_STATE);
    eval 'sub SB_VERSION {
        my($s) = @_;
	    eval q( &sb_version ( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_VERSION);
    eval 'sub SB_BMAP_NR {
        my($s) = @_;
	    eval q( &sb_bmap_nr( &SB_DISK_SUPER_BLOCK($s)));
    }' unless defined(&SB_BMAP_NR);
    eval 'sub PUT_SB_BLOCK_COUNT {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_block_count(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_BLOCK_COUNT);
    eval 'sub PUT_SB_FREE_BLOCKS {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_free_blocks(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_FREE_BLOCKS);
    eval 'sub PUT_SB_ROOT_BLOCK {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_root_block(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_ROOT_BLOCK);
    eval 'sub PUT_SB_TREE_HEIGHT {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_tree_height(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_TREE_HEIGHT);
    eval 'sub PUT_SB_REISERFS_STATE {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_state(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_REISERFS_STATE);
    eval 'sub PUT_SB_VERSION {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_version(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_VERSION);
    eval 'sub PUT_SB_BMAP_NR {
        my($s, $val) = @_;
	    eval q( &do {  &set_sb_bmap_nr(  &SB_DISK_SUPER_BLOCK($s), $val); }  &while (0));
    }' unless defined(&PUT_SB_BMAP_NR);
}
1;
