package Proxmox::NoCachePNG;

use strict;
use Apache2::Const qw(:common);

sub handler {
    my $r = shift;
    my $uri = $r->uri();
    my $filename = "/var/www/proxmox/$uri";

    return NOT_FOUND if !($uri =~ m|^.*/([^/]+\.png)|i);

    my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	$atime,$mtime,$ctime,$blksize,$blocks)
	= stat($filename); 

    return NOT_FOUND if !$size;
    
    $r->no_cache (1);
    $r->content_type ("image/png");
    $r->headers_out->set ('Content-Transfer-Encoding', 'binary');
    $r->headers_out->set ('Content-Length', $size);
    $r->headers_out->set ("Pragma", "no-cache");

    open (TMP, "$filename") || return NOT_FOUND;
    while (<TMP>) { $r->print ($_); }
    close (TMP);

    return OK; 
}



1;
