#!/usr/bin/perl -w

use strict;
use CGI '3.12';
use mod_perl2;
use Apache2::Util;
use Apache2::Request;
use Proxmox::RuleDB;
use Proxmox::Utils;
use Proxmox::Config::System;
use Proxmox::HTMLMail;

my $r = Apache2::RequestUtil->request();
my $cgi = CGI->new ($r);
my $arglist = $cgi->Vars();

my $uri = $r->uri;

my $rdb = Proxmox::RuleDB->new();
my $dbh = $rdb->{dbh};

my $system_cfg = Proxmox::Config::System->new ();

my $ticket = $arglist->{'ticket'};

my $width = $arglist->{'width'} || 600;

my $cid = $arglist->{'cid'}; # content ID

my $htmlhead = <<__EOD;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Strict//EN"
       "http://www.w3.org/TR/html4/strict.dtd">

<html>
<head>
  <title>Proxmox Mail Gateway - Mail Preview</title>
  <meta http-equiv="expires" content="0">
  <meta http-equiv="cache-control" content="no-cache">
</head>
<body>
__EOD

if (my $dbref = Proxmox::Utils::loadmaildata ($dbh, $ticket)) {

    my $section = $dbref->{qtype} eq 'S' ? 'spamquar' : 'virusquar';

    my $viewimages = $system_cfg->get ($section, 'viewimages');
    my $allowhref =  $system_cfg->get ($section, 'allowhrefs');

    if ($viewimages && $cid) {
	my ($ctype, $data) = Proxmox::HTMLMail::parse_content ($dbref, $cid);

	if ($ctype && $data && $ctype =~ m|^image/|) {
	    $r->headers_out->set ('Content-Transfer-Encoding', 'binary');
	    $r->headers_out->set ('Content-Length', length ($data));
	    $r->content_type ($ctype);
	    $r->print ($data);
	}

    } else {
	my $raw = $arglist->{'raw'};

	my $data = $htmlhead;
	$data .= Proxmox::HTMLMail::parse_mail ($dbref, "?ticket=$ticket", $width, 0, $viewimages, $allowhref, $raw);
	$data .= "</html>\n";

	$r->content_type ('text/html');
	$r->print ($data);

    }
} else {

    my $data = $htmlhead;
    $data .= __("Unable to load data.");
    $data .= "</html>\n";
    $r->content_type ('text/html');
    $r->print ($data);
}



