<!DOCTYPE book PUBLIC "-//OASIS//DTD DocBook XML V4.2//EN"
              "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"
	       [<!ENTITY mdash "&#8212;">]>
<!--
 - Copyright (C) 2004-2013  Internet Systems Consortium, Inc. ("ISC")
 - Copyright (C) 2000-2003  Internet Software Consortium.
 -
 - Permission to use, copy, modify, and/or distribute this software for any
 - purpose with or without fee is hereby granted, provided that the above
 - copyright notice and this permission notice appear in all copies.
 -
 - THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 - REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 - AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 - INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 - LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 - OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 - PERFORMANCE OF THIS SOFTWARE.
-->

<!-- File: $Id$ -->
<book xmlns:xi="http://www.w3.org/2001/XInclude">
  <title>BIND 9 Administrator Reference Manual</title>

  <bookinfo>
    <copyright>
      <year>2004</year>
      <year>2005</year>
      <year>2006</year>
      <year>2007</year>
      <year>2008</year>
      <year>2009</year>
      <year>2010</year>
      <year>2011</year>
      <year>2012</year>
      <year>2013</year>
      <holder>Internet Systems Consortium, Inc. ("ISC")</holder>
    </copyright>
    <copyright>
      <year>2000</year>
      <year>2001</year>
      <year>2002</year>
      <year>2003</year>
      <holder>Internet Software Consortium.</holder>
    </copyright>
  </bookinfo>

  <chapter id="Bv9ARM.ch01">
    <title>Introduction</title>
    <para>
      The Internet Domain Name System (<acronym>DNS</acronym>)
      consists of the syntax
      to specify the names of entities in the Internet in a hierarchical
      manner, the rules used for delegating authority over names, and the
      system implementation that actually maps names to Internet
      addresses.  <acronym>DNS</acronym> data is maintained in a
      group of distributed
      hierarchical databases.
    </para>

    <sect1>
      <title>Scope of Document</title>

      <para>
        The Berkeley Internet Name Domain
        (<acronym>BIND</acronym>) implements a
        domain name server for a number of operating systems. This
        document provides basic information about the installation and
        care of the Internet Systems Consortium (<acronym>ISC</acronym>)
        <acronym>BIND</acronym> version 9 software package for
        system administrators.
      </para>

      <para>
        This version of the manual corresponds to BIND version 9.9.
      </para>

    </sect1>
    <sect1>
      <title>Organization of This Document</title>
      <para>
        In this document, <emphasis>Chapter 1</emphasis> introduces
        the basic <acronym>DNS</acronym> and <acronym>BIND</acronym> concepts. <emphasis>Chapter 2</emphasis>
        describes resource requirements for running <acronym>BIND</acronym> in various
        environments. Information in <emphasis>Chapter 3</emphasis> is
        <emphasis>task-oriented</emphasis> in its presentation and is
        organized functionally, to aid in the process of installing the
        <acronym>BIND</acronym> 9 software. The task-oriented
        section is followed by
        <emphasis>Chapter 4</emphasis>, which contains more advanced
        concepts that the system administrator may need for implementing
        certain options. <emphasis>Chapter 5</emphasis>
        describes the <acronym>BIND</acronym> 9 lightweight
        resolver.  The contents of <emphasis>Chapter 6</emphasis> are
        organized as in a reference manual to aid in the ongoing
        maintenance of the software. <emphasis>Chapter 7</emphasis> addresses
        security considerations, and
        <emphasis>Chapter 8</emphasis> contains troubleshooting help. The
        main body of the document is followed by several
        <emphasis>appendices</emphasis> which contain useful reference
        information, such as a <emphasis>bibliography</emphasis> and
        historic information related to <acronym>BIND</acronym>
        and the Domain Name
        System.
      </para>
    </sect1>
    <sect1>
      <title>Conventions Used in This Document</title>

      <para>
        In this document, we use the following general typographic
        conventions:
      </para>

      <informaltable>
        <tgroup cols="2">
          <colspec colname="1" colnum="1" colwidth="3.000in"/>
          <colspec colname="2" colnum="2" colwidth="2.625in"/>
          <tbody>
            <row>
              <entry colname="1">
                <para>
                  <emphasis>To describe:</emphasis>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  <emphasis>We use the style:</emphasis>
                </para>
              </entry>
            </row>
            <row>
              <entry colname="1">
                <para>
                  a pathname, filename, URL, hostname,
                  mailing list name, or new term or concept
                </para>
              </entry>
              <entry colname="2">
                <para>
                  <filename>Fixed width</filename>
                </para>
              </entry>
            </row>
            <row>
              <entry colname="1">
                <para>
                  literal user
                  input
                </para>
              </entry>
              <entry colname="2">
                <para>
                  <userinput>Fixed Width Bold</userinput>
                </para>
              </entry>
            </row>
            <row>
              <entry colname="1">
                <para>
                  program output
                </para>
              </entry>
              <entry colname="2">
                <para>
                  <computeroutput>Fixed Width</computeroutput>
                </para>
              </entry>
            </row>
          </tbody>
        </tgroup>
      </informaltable>

      <para>
        The following conventions are used in descriptions of the
        <acronym>BIND</acronym> configuration file:<informaltable colsep="0" frame="all" rowsep="0">
                  <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="2Level-table">
                      <colspec colname="1" colnum="1" colsep="0" colwidth="3.000in"/>
            <colspec colname="2" colnum="2" colsep="0" colwidth="2.625in"/>
            <tbody>
              <row rowsep="0">
                <entry colname="1" colsep="1" rowsep="1">
                  <para>
                    <emphasis>To describe:</emphasis>
                  </para>
                </entry>
                <entry colname="2" rowsep="1">
                  <para>
                    <emphasis>We use the style:</emphasis>
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1" colsep="1" rowsep="1">
                  <para>
                    keywords
                  </para>
                </entry>
                <entry colname="2" rowsep="1">
                  <para>
                    <literal>Fixed Width</literal>
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1" colsep="1" rowsep="1">
                  <para>
                    variables
                  </para>
                </entry>
                <entry colname="2" rowsep="1">
                  <para>
                    <varname>Fixed Width</varname>
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1" colsep="1">
                  <para>
                    Optional input
                  </para>
                </entry>
                <entry colname="2">
                  <para>
                    <optional>Text is enclosed in square brackets</optional>
                  </para>
                </entry>
              </row>
            </tbody>
          </tgroup>
        </informaltable>
      </para>
    </sect1>
    <sect1>
      <title>The Domain Name System (<acronym>DNS</acronym>)</title>
      <para>
        The purpose of this document is to explain the installation
        and upkeep of the <acronym>BIND</acronym> (Berkeley Internet
	Name Domain) software package, and we
        begin by reviewing the fundamentals of the Domain Name System
        (<acronym>DNS</acronym>) as they relate to <acronym>BIND</acronym>.
      </para>

      <sect2>
        <title>DNS Fundamentals</title>

        <para>
          The Domain Name System (DNS) is a hierarchical, distributed
          database.  It stores information for mapping Internet host names to
          IP
          addresses and vice versa, mail routing information, and other data
          used by Internet applications.
        </para>

        <para>
          Clients look up information in the DNS by calling a
          <emphasis>resolver</emphasis> library, which sends queries to one or
          more <emphasis>name servers</emphasis> and interprets the responses.
          The <acronym>BIND</acronym> 9 software distribution
          contains a
          name server, <command>named</command>, and a resolver
          library, <command>liblwres</command>.  The older
          <command>libbind</command> resolver library is also available
          from ISC as a separate download.
        </para>

        </sect2><sect2>
        <title>Domains and Domain Names</title>

        <para>
          The data stored in the DNS is identified by <emphasis>domain names</emphasis> that are organized as a tree according to
          organizational or administrative boundaries. Each node of the tree,
          called a <emphasis>domain</emphasis>, is given a label. The domain
          name of the
          node is the concatenation of all the labels on the path from the
          node to the <emphasis>root</emphasis> node.  This is represented
          in written form as a string of labels listed from right to left and
          separated by dots. A label need only be unique within its parent
          domain.
        </para>

        <para>
          For example, a domain name for a host at the
          company <emphasis>Example, Inc.</emphasis> could be
          <literal>ourhost.example.com</literal>,
          where <literal>com</literal> is the
          top level domain to which
          <literal>ourhost.example.com</literal> belongs,
          <literal>example</literal> is
          a subdomain of <literal>com</literal>, and
          <literal>ourhost</literal> is the
          name of the host.
        </para>

        <para>
          For administrative purposes, the name space is partitioned into
          areas called <emphasis>zones</emphasis>, each starting at a node and
          extending down to the leaf nodes or to nodes where other zones
          start.
          The data for each zone is stored in a <emphasis>name server</emphasis>, which answers queries about the zone using the
          <emphasis>DNS protocol</emphasis>.
        </para>

        <para>
          The data associated with each domain name is stored in the
          form of <emphasis>resource records</emphasis> (<acronym>RR</acronym>s).
          Some of the supported resource record types are described in
          <xref linkend="types_of_resource_records_and_when_to_use_them"/>.
        </para>

        <para>
          For more detailed information about the design of the DNS and
          the DNS protocol, please refer to the standards documents listed in
          <xref linkend="rfcs"/>.
        </para>
      </sect2>

      <sect2>
        <title>Zones</title>
        <para>
          To properly operate a name server, it is important to understand
          the difference between a <emphasis>zone</emphasis>
          and a <emphasis>domain</emphasis>.
        </para>

        <para>
          As stated previously, a zone is a point of delegation in
          the <acronym>DNS</acronym> tree. A zone consists of
          those contiguous parts of the domain
          tree for which a name server has complete information and over which
          it has authority. It contains all domain names from a certain point
          downward in the domain tree except those which are delegated to
          other zones. A delegation point is marked by one or more
          <emphasis>NS records</emphasis> in the
          parent zone, which should be matched by equivalent NS records at
          the root of the delegated zone.
        </para>

        <para>
          For instance, consider the <literal>example.com</literal>
          domain which includes names
          such as <literal>host.aaa.example.com</literal> and
          <literal>host.bbb.example.com</literal> even though
          the <literal>example.com</literal> zone includes
          only delegations for the <literal>aaa.example.com</literal> and
          <literal>bbb.example.com</literal> zones.  A zone can
          map
          exactly to a single domain, but could also include only part of a
          domain, the rest of which could be delegated to other
          name servers. Every name in the <acronym>DNS</acronym>
          tree is a
          <emphasis>domain</emphasis>, even if it is
          <emphasis>terminal</emphasis>, that is, has no
          <emphasis>subdomains</emphasis>.  Every subdomain is a domain and
          every domain except the root is also a subdomain. The terminology is
          not intuitive and we suggest that you read RFCs 1033, 1034 and 1035
          to
          gain a complete understanding of this difficult and subtle
          topic.
        </para>

        <para>
          Though <acronym>BIND</acronym> is called a "domain name
          server",
          it deals primarily in terms of zones. The master and slave
          declarations in the <filename>named.conf</filename> file
          specify
          zones, not domains. When you ask some other site if it is willing to
          be a slave server for your <emphasis>domain</emphasis>, you are
          actually asking for slave service for some collection of zones.
        </para>
      </sect2>

      <sect2>
        <title>Authoritative Name Servers</title>

        <para>
          Each zone is served by at least
          one <emphasis>authoritative name server</emphasis>,
          which contains the complete data for the zone.
          To make the DNS tolerant of server and network failures,
          most zones have two or more authoritative servers, on
          different networks.
        </para>

        <para>
          Responses from authoritative servers have the "authoritative
          answer" (AA) bit set in the response packets.  This makes them
          easy to identify when debugging DNS configurations using tools like
          <command>dig</command> (<xref linkend="diagnostic_tools"/>).
        </para>

        <sect3>
          <title>The Primary Master</title>

          <para>
            The authoritative server where the master copy of the zone
            data is maintained is called the
	    <emphasis>primary master</emphasis> server, or simply the
            <emphasis>primary</emphasis>.  Typically it loads the zone
            contents from some local file edited by humans or perhaps
            generated mechanically from some other local file which is
            edited by humans.  This file is called the
	    <emphasis>zone file</emphasis> or
	    <emphasis>master file</emphasis>.
          </para>

	  <para>
	    In some cases, however, the master file may not be edited
	    by humans at all, but may instead be the result of
	    <emphasis>dynamic update</emphasis> operations.
	  </para>
        </sect3>

        <sect3>
          <title>Slave Servers</title>
          <para>
            The other authoritative servers, the <emphasis>slave</emphasis>
            servers (also known as <emphasis>secondary</emphasis> servers)
            load
            the zone contents from another server using a replication process
            known as a <emphasis>zone transfer</emphasis>.  Typically the data
            are
            transferred directly from the primary master, but it is also
            possible
            to transfer it from another slave.  In other words, a slave server
            may itself act as a master to a subordinate slave server.
          </para>
        </sect3>

        <sect3>
          <title>Stealth Servers</title>

          <para>
            Usually all of the zone's authoritative servers are listed in
            NS records in the parent zone.  These NS records constitute
            a <emphasis>delegation</emphasis> of the zone from the parent.
            The authoritative servers are also listed in the zone file itself,
            at the <emphasis>top level</emphasis> or <emphasis>apex</emphasis>
            of the zone.  You can list servers in the zone's top-level NS
            records that are not in the parent's NS delegation, but you cannot
            list servers in the parent's delegation that are not present at
            the zone's top level.
          </para>

          <para>
            A <emphasis>stealth server</emphasis> is a server that is
            authoritative for a zone but is not listed in that zone's NS
            records.  Stealth servers can be used for keeping a local copy of
            a
            zone to speed up access to the zone's records or to make sure that
            the
            zone is available even if all the "official" servers for the zone
            are
            inaccessible.
          </para>

          <para>
            A configuration where the primary master server itself is a
            stealth server is often referred to as a "hidden primary"
            configuration.  One use for this configuration is when the primary
            master
            is behind a firewall and therefore unable to communicate directly
            with the outside world.
          </para>

        </sect3>

      </sect2>
      <sect2>

        <title>Caching Name Servers</title>

	<!--
	  - Terminology here is inconsistent.  Probably ought to
	  - convert to using "recursive name server" everywhere
	  - with just a note about "caching" terminology.
	  -->

        <para>
          The resolver libraries provided by most operating systems are
          <emphasis>stub resolvers</emphasis>, meaning that they are not
          capable of
          performing the full DNS resolution process by themselves by talking
          directly to the authoritative servers.  Instead, they rely on a
          local
          name server to perform the resolution on their behalf.  Such a
          server
          is called a <emphasis>recursive</emphasis> name server; it performs
          <emphasis>recursive lookups</emphasis> for local clients.
        </para>

        <para>
          To improve performance, recursive servers cache the results of
          the lookups they perform.  Since the processes of recursion and
          caching are intimately connected, the terms
          <emphasis>recursive server</emphasis> and
          <emphasis>caching server</emphasis> are often used synonymously.
        </para>

        <para>
          The length of time for which a record may be retained in
          the cache of a caching name server is controlled by the
          Time To Live (TTL) field associated with each resource record.
        </para>

        <sect3>
          <title>Forwarding</title>

          <para>
            Even a caching name server does not necessarily perform
            the complete recursive lookup itself.  Instead, it can
            <emphasis>forward</emphasis> some or all of the queries
            that it cannot satisfy from its cache to another caching name
            server,
            commonly referred to as a <emphasis>forwarder</emphasis>.
          </para>

          <para>
            There may be one or more forwarders,
            and they are queried in turn until the list is exhausted or an
            answer
            is found. Forwarders are typically used when you do not
            wish all the servers at a given site to interact directly with the
            rest of
            the Internet servers. A typical scenario would involve a number
            of internal <acronym>DNS</acronym> servers and an
            Internet firewall. Servers unable
            to pass packets through the firewall would forward to the server
            that can do it, and that server would query the Internet <acronym>DNS</acronym> servers
            on the internal server's behalf.
          </para>
        </sect3>

      </sect2>

      <sect2>
        <title>Name Servers in Multiple Roles</title>

        <para>
          The <acronym>BIND</acronym> name server can
          simultaneously act as
          a master for some zones, a slave for other zones, and as a caching
          (recursive) server for a set of local clients.
        </para>

        <para>
          However, since the functions of authoritative name service
          and caching/recursive name service are logically separate, it is
          often advantageous to run them on separate server machines.

          A server that only provides authoritative name service
          (an <emphasis>authoritative-only</emphasis> server) can run with
          recursion disabled, improving reliability and security.

          A server that is not authoritative for any zones and only provides
          recursive service to local
          clients (a <emphasis>caching-only</emphasis> server)
          does not need to be reachable from the Internet at large and can
          be placed inside a firewall.
        </para>

      </sect2>
    </sect1>

  </chapter>

  <chapter id="Bv9ARM.ch02">
    <title><acronym>BIND</acronym> Resource Requirements</title>

    <sect1>
      <title>Hardware requirements</title>

      <para>
        <acronym>DNS</acronym> hardware requirements have
        traditionally been quite modest.
        For many installations, servers that have been pensioned off from
        active duty have performed admirably as <acronym>DNS</acronym> servers.
      </para>
      <para>
        The DNSSEC features of <acronym>BIND</acronym> 9
        may prove to be quite
        CPU intensive however, so organizations that make heavy use of these
        features may wish to consider larger systems for these applications.
        <acronym>BIND</acronym> 9 is fully multithreaded, allowing
        full utilization of
        multiprocessor systems for installations that need it.
      </para>
    </sect1>
    <sect1>
      <title>CPU Requirements</title>
      <para>
        CPU requirements for <acronym>BIND</acronym> 9 range from
        i486-class machines
        for serving of static zones without caching, to enterprise-class
        machines if you intend to process many dynamic updates and DNSSEC
        signed zones, serving many thousands of queries per second.
      </para>
    </sect1>

    <sect1>
      <title>Memory Requirements</title>
      <para>
        The memory of the server has to be large enough to fit the
        cache and zones loaded off disk.  The <command>max-cache-size</command>
        option can be used to limit the amount of memory used by the cache,
        at the expense of reducing cache hit rates and causing more <acronym>DNS</acronym>
        traffic.
        Additionally, if additional section caching
        (<xref linkend="acache"/>) is enabled,
        the <command>max-acache-size</command> option can be used to
        limit the amount
        of memory used by the mechanism.
        It is still good practice to have enough memory to load
        all zone and cache data into memory &mdash; unfortunately, the best
        way
        to determine this for a given installation is to watch the name server
        in operation. After a few weeks the server process should reach
        a relatively stable size where entries are expiring from the cache as
        fast as they are being inserted.
      </para>
      <!--
        - Add something here about leaving overhead for attacks?
	- How much overhead?  Percentage?
        -->
    </sect1>

    <sect1>
      <title>Name Server Intensive Environment Issues</title>
      <para>
        For name server intensive environments, there are two alternative
        configurations that may be used. The first is where clients and
        any second-level internal name servers query a main name server, which
        has enough memory to build a large cache. This approach minimizes
        the bandwidth used by external name lookups. The second alternative
        is to set up second-level internal name servers to make queries
        independently.
        In this configuration, none of the individual machines needs to
        have as much memory or CPU power as in the first alternative, but
        this has the disadvantage of making many more external queries,
        as none of the name servers share their cached data.
      </para>
    </sect1>

    <sect1>
      <title>Supported Operating Systems</title>
      <para>
        ISC <acronym>BIND</acronym> 9 compiles and runs on a large
        number
        of Unix-like operating systems and on 
        Microsoft Windows Server 2003 and 2008, and Windows XP and Vista.
        For an up-to-date
        list of supported systems, see the README file in the top level
        directory
        of the BIND 9 source distribution.
      </para>
    </sect1>
  </chapter>

  <chapter id="Bv9ARM.ch03">
    <title>Name Server Configuration</title>
    <para>
      In this chapter we provide some suggested configurations along
      with guidelines for their use.  We suggest reasonable values for
      certain option settings.
    </para>

    <sect1 id="sample_configuration">
      <title>Sample Configurations</title>
      <sect2>
        <title>A Caching-only Name Server</title>
        <para>
          The following sample configuration is appropriate for a caching-only
          name server for use by clients internal to a corporation.  All
          queries
          from outside clients are refused using the <command>allow-query</command>
          option.  Alternatively, the same effect could be achieved using
          suitable
          firewall rules.
        </para>

<programlisting>
// Two corporate subnets we wish to allow queries from.
acl corpnets { 192.168.4.0/24; 192.168.7.0/24; };
options {
     // Working directory
     directory "/etc/namedb";

     allow-query { corpnets; };
};
// Provide a reverse mapping for the loopback
// address 127.0.0.1
zone "0.0.127.in-addr.arpa" {
     type master;
     file "localhost.rev";
     notify no;
};
</programlisting>

      </sect2>

      <sect2>
        <title>An Authoritative-only Name Server</title>
        <para>
          This sample configuration is for an authoritative-only server
          that is the master server for "<filename>example.com</filename>"
          and a slave for the subdomain "<filename>eng.example.com</filename>".
        </para>

<programlisting>
options {
     // Working directory
     directory "/etc/namedb";
     // Do not allow access to cache
     allow-query-cache { none; };
     // This is the default
     allow-query { any; };
     // Do not provide recursive service
     recursion no;
};

// Provide a reverse mapping for the loopback
// address 127.0.0.1
zone "0.0.127.in-addr.arpa" {
     type master;
     file "localhost.rev";
     notify no;
};
// We are the master server for example.com
zone "example.com" {
     type master;
     file "example.com.db";
     // IP addresses of slave servers allowed to
     // transfer example.com
     allow-transfer {
          192.168.4.14;
          192.168.5.53;
     };
};
// We are a slave server for eng.example.com
zone "eng.example.com" {
     type slave;
     file "eng.example.com.bk";
     // IP address of eng.example.com master server
     masters { 192.168.4.12; };
};
</programlisting>

      </sect2>
    </sect1>

    <sect1>
      <title>Load Balancing</title>
      <!--
        - Add explanation of why load balancing is fragile at best
	- and completely pointless in the general case.
        -->

      <para>
        A primitive form of load balancing can be achieved in
        the <acronym>DNS</acronym> by using multiple records
	(such as multiple A records) for one name.
      </para>

      <para>
        For example, if you have three WWW servers with network addresses
        of 10.0.0.1, 10.0.0.2 and 10.0.0.3, a set of records such as the
        following means that clients will connect to each machine one third
        of the time:
      </para>

      <informaltable colsep="0" rowsep="0">
        <tgroup cols="5" colsep="0" rowsep="0" tgroupstyle="2Level-table">
          <colspec colname="1" colnum="1" colsep="0" colwidth="0.875in"/>
          <colspec colname="2" colnum="2" colsep="0" colwidth="0.500in"/>
          <colspec colname="3" colnum="3" colsep="0" colwidth="0.750in"/>
          <colspec colname="4" colnum="4" colsep="0" colwidth="0.750in"/>
          <colspec colname="5" colnum="5" colsep="0" colwidth="2.028in"/>
          <tbody>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  Name
                </para>
              </entry>
              <entry colname="2">
                <para>
                  TTL
                </para>
              </entry>
              <entry colname="3">
                <para>
                  CLASS
                </para>
              </entry>
              <entry colname="4">
                <para>
                  TYPE
                </para>
              </entry>
              <entry colname="5">
                <para>
                  Resource Record (RR) Data
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <literal>www</literal>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  <literal>600</literal>
                </para>
              </entry>
              <entry colname="3">
                <para>
                  <literal>IN</literal>
                </para>
              </entry>
              <entry colname="4">
                <para>
                  <literal>A</literal>
                </para>
              </entry>
              <entry colname="5">
                <para>
                  <literal>10.0.0.1</literal>
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para/>
              </entry>
              <entry colname="2">
                <para>
                  <literal>600</literal>
                </para>
              </entry>
              <entry colname="3">
                <para>
                  <literal>IN</literal>
                </para>
              </entry>
              <entry colname="4">
                <para>
                  <literal>A</literal>
                </para>
              </entry>
              <entry colname="5">
                <para>
                  <literal>10.0.0.2</literal>
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para/>
              </entry>
              <entry colname="2">
                <para>
                  <literal>600</literal>
                </para>
              </entry>
              <entry colname="3">
                <para>
                  <literal>IN</literal>
                </para>
              </entry>
              <entry colname="4">
                <para>
                  <literal>A</literal>
                </para>
              </entry>
              <entry colname="5">
                <para>
                  <literal>10.0.0.3</literal>
                </para>
              </entry>
            </row>
          </tbody>
        </tgroup>
      </informaltable>
      <para>
        When a resolver queries for these records, <acronym>BIND</acronym> will rotate
        them and respond to the query with the records in a different
        order.  In the example above, clients will randomly receive
        records in the order 1, 2, 3; 2, 3, 1; and 3, 1, 2. Most clients
        will use the first record returned and discard the rest.
      </para>
      <para>
        For more detail on ordering responses, check the
        <command>rrset-order</command> sub-statement in the
        <command>options</command> statement, see
        <xref endterm="rrset_ordering_title" linkend="rrset_ordering"/>.
      </para>

    </sect1>

    <sect1>
      <title>Name Server Operations</title>

      <sect2>
        <title>Tools for Use With the Name Server Daemon</title>
        <para>
          This section describes several indispensable diagnostic,
          administrative and monitoring tools available to the system
          administrator for controlling and debugging the name server
          daemon.
        </para>
        <sect3 id="diagnostic_tools">
          <title>Diagnostic Tools</title>
          <para>
            The <command>dig</command>, <command>host</command>, and
            <command>nslookup</command> programs are all command
            line tools
            for manually querying name servers.  They differ in style and
            output format.
          </para>

          <variablelist>
            <varlistentry>
              <term id="dig"><command>dig</command></term>
              <listitem>
                <para>
                  The domain information groper (<command>dig</command>)
                  is the most versatile and complete of these lookup tools.
                  It has two modes: simple interactive
                  mode for a single query, and batch mode which executes a
                  query for
                  each in a list of several query lines. All query options are
                  accessible
                  from the command line.
                </para>
                <cmdsynopsis label="Usage">
                  <command>dig</command>
                  <arg>@<replaceable>server</replaceable></arg>
                  <arg choice="plain"><replaceable>domain</replaceable></arg>
                  <arg><replaceable>query-type</replaceable></arg>
                  <arg><replaceable>query-class</replaceable></arg>
                  <arg>+<replaceable>query-option</replaceable></arg>
                  <arg>-<replaceable>dig-option</replaceable></arg>
                  <arg>%<replaceable>comment</replaceable></arg>
                </cmdsynopsis>
                <para>
                  The usual simple use of <command>dig</command> will take the form
                </para>
                <simpara>
                  <command>dig @server domain query-type query-class</command>
                </simpara>
                <para>
                  For more information and a list of available commands and
                  options, see the <command>dig</command> man
                  page.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>host</command></term>
              <listitem>
                <para>
                  The <command>host</command> utility emphasizes
                  simplicity
                  and ease of use.  By default, it converts
                  between host names and Internet addresses, but its
                  functionality
                  can be extended with the use of options.
                </para>
                <cmdsynopsis label="Usage">
                  <command>host</command>
                  <arg>-aCdlnrsTwv</arg>
                  <arg>-c <replaceable>class</replaceable></arg>
                  <arg>-N <replaceable>ndots</replaceable></arg>
                  <arg>-t <replaceable>type</replaceable></arg>
                  <arg>-W <replaceable>timeout</replaceable></arg>
                  <arg>-R <replaceable>retries</replaceable></arg>
                  <arg>-m <replaceable>flag</replaceable></arg>
		  <arg>-4</arg>
		  <arg>-6</arg>
                  <arg choice="plain"><replaceable>hostname</replaceable></arg>
                  <arg><replaceable>server</replaceable></arg>
                </cmdsynopsis>
                <para>
                  For more information and a list of available commands and
                  options, see the <command>host</command> man
                  page.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>nslookup</command></term>
              <listitem>
                <para><command>nslookup</command>
		  has two modes: interactive and
                  non-interactive. Interactive mode allows the user to
                  query name servers for information about various
                  hosts and domains or to print a list of hosts in a
                  domain. Non-interactive mode is used to print just
                  the name and requested information for a host or
                  domain.
                </para>
                <cmdsynopsis label="Usage">
                  <command>nslookup</command>
                  <arg rep="repeat">-option</arg>
                  <group>
                    <arg><replaceable>host-to-find</replaceable></arg>
                    <arg>- <arg>server</arg></arg>
                  </group>
                </cmdsynopsis>
                <para>
                  Interactive mode is entered when no arguments are given (the
                  default name server will be used) or when the first argument
                  is a
                  hyphen (`-') and the second argument is the host name or
                  Internet address
                  of a name server.
                </para>
                <para>
                  Non-interactive mode is used when the name or Internet
                  address
                  of the host to be looked up is given as the first argument.
                  The
                  optional second argument specifies the host name or address
                  of a name server.
                </para>
                <para>
                  Due to its arcane user interface and frequently inconsistent
                  behavior, we do not recommend the use of <command>nslookup</command>.
                  Use <command>dig</command> instead.
                </para>
              </listitem>

            </varlistentry>
          </variablelist>
        </sect3>

        <sect3 id="admin_tools">
          <title>Administrative Tools</title>
          <para>
            Administrative tools play an integral part in the management
            of a server.
          </para>
          <variablelist>
            <varlistentry id="named-checkconf" xreflabel="Named Configuration Checking application">

              <term><command>named-checkconf</command></term>
              <listitem>
                <para>
                  The <command>named-checkconf</command> program
                  checks the syntax of a <filename>named.conf</filename> file.
                </para>
                <cmdsynopsis label="Usage">
                  <command>named-checkconf</command>
                  <arg>-jvz</arg>
                  <arg>-t <replaceable>directory</replaceable></arg>
                  <arg><replaceable>filename</replaceable></arg>
                </cmdsynopsis>
              </listitem>
            </varlistentry>
            <varlistentry id="named-checkzone" xreflabel="Zone Checking application">

              <term><command>named-checkzone</command></term>
              <listitem>
                <para>
                  The <command>named-checkzone</command> program
                  checks a master file for
                  syntax and consistency.
                </para>
                <cmdsynopsis label="Usage">
                  <command>named-checkzone</command>
                  <arg>-djqvD</arg>
                  <arg>-c <replaceable>class</replaceable></arg>
                  <arg>-o <replaceable>output</replaceable></arg>
                  <arg>-t <replaceable>directory</replaceable></arg>
                  <arg>-w <replaceable>directory</replaceable></arg>
                  <arg>-k <replaceable>(ignore|warn|fail)</replaceable></arg>
                  <arg>-n <replaceable>(ignore|warn|fail)</replaceable></arg>
                  <arg>-W <replaceable>(ignore|warn)</replaceable></arg>
                  <arg choice="plain"><replaceable>zone</replaceable></arg>
                  <arg><replaceable>filename</replaceable></arg>
                </cmdsynopsis>
              </listitem>
            </varlistentry>
	    <varlistentry id="named-compilezone" xreflabel="Zone Compilation application">
	      <term><command>named-compilezone</command></term>
	      <listitem>
		<para>
		  Similar to <command>named-checkzone,</command> but
		  it always dumps the zone content to a specified file
		  (typically in a different format).
		</para>
	      </listitem>
	    </varlistentry>
            <varlistentry id="rndc" xreflabel="Remote Name Daemon Control application">

              <term><command>rndc</command></term>
              <listitem>
                <para>
                  The remote name daemon control
                  (<command>rndc</command>) program allows the
                  system
                  administrator to control the operation of a name server.
                  Since <acronym>BIND</acronym> 9.2, <command>rndc</command>
                  supports all the commands of the BIND 8 <command>ndc</command>
                  utility except <command>ndc start</command> and
                  <command>ndc restart</command>, which were also
                  not supported in <command>ndc</command>'s
                  channel mode.
                  If you run <command>rndc</command> without any
                  options
                  it will display a usage message as follows:
                </para>
                <cmdsynopsis label="Usage">
                  <command>rndc</command>
                  <arg>-c <replaceable>config</replaceable></arg>
                  <arg>-s <replaceable>server</replaceable></arg>
                  <arg>-p <replaceable>port</replaceable></arg>
                  <arg>-y <replaceable>key</replaceable></arg>
                  <arg choice="plain"><replaceable>command</replaceable></arg>
                  <arg rep="repeat"><replaceable>command</replaceable></arg>
                </cmdsynopsis>
                <para>The <command>command</command>
		  is one of the following:
                </para>

                <variablelist>

                  <varlistentry>
                    <term><userinput>reload</userinput></term>
                    <listitem>
                      <para>
                        Reload configuration file and zones.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>reload <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Reload the given zone.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>refresh <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Schedule zone maintenance for the given zone.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>retransfer <replaceable>zone</replaceable>

                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Retransfer the given zone from the master.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>sign <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Fetch all DNSSEC keys for the given zone
                        from the key directory (see
                        <command>key-directory</command> in
                        <xref linkend="options"/>).  If they are within
                        their publication period, merge them into the
                        zone's DNSKEY RRset.  If the DNSKEY RRset
                        is changed, then the zone is automatically
                        re-signed with the new key set.
                      </para>
                      <para>
                        This command requires that the
                        <command>auto-dnssec</command> zone option be set
                        to <literal>allow</literal> or
                        <literal>maintain</literal>,
                        and also requires the zone to be configured to
                        allow dynamic DNS.
                        See <xref linkend="dynamic_update_policies"/> for
                        more details.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>loadkeys <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Fetch all DNSSEC keys for the given zone
                        from the key directory (see
                        <command>key-directory</command> in
                        <xref linkend="options"/>).  If they are within
                        their publication period, merge them into the
                        zone's DNSKEY RRset.  Unlike <command>rndc
                        sign</command>, however, the zone is not
                        immediately re-signed by the new keys, but is
                        allowed to incrementally re-sign over time.
                      </para>
                      <para>
                        This command requires that the
                        <command>auto-dnssec</command> zone option
                        be set to <literal>maintain</literal>,
                        and also requires the zone to be configured to
                        allow dynamic DNS.
                        See <xref linkend="dynamic_update_policies"/> for
                        more details.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>freeze
                        <optional><replaceable>zone</replaceable>
       <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Suspend updates to a dynamic zone.  If no zone is
                        specified, then all zones are suspended.  This allows
                        manual edits to be made to a zone normally updated by
                        dynamic update.  It also causes changes in the
                        journal file to be synced into the master file.
                        All dynamic update attempts will be refused while
                        the zone is frozen.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>thaw
                        <optional><replaceable>zone</replaceable>
       <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Enable updates to a frozen dynamic zone.  If no
                        zone is specified, then all frozen zones are
                        enabled.  This causes the server to reload the zone
                        from disk, and re-enables dynamic updates after the
                        load has completed.  After a zone is thawed,
                        dynamic updates will no longer be refused.  If
                        the zone has changed and the
                        <command>ixfr-from-differences</command> option is
                        in use, then the journal file will be updated to
                        reflect changes in the zone.  Otherwise, if the
                        zone has changed, any existing journal file will be
                        removed.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>sync
                        <optional>-clean</optional>
                        <optional><replaceable>zone</replaceable>
       <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Sync changes in the journal file for a dynamic zone
                        to the master file.  If the "-clean" option is
                        specified, the journal file is also removed.  If
                        no zone is specified, then all zones are synced.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>notify <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
           <optional><replaceable>view</replaceable></optional></optional></userinput></term>
                    <listitem>
                      <para>
                        Resend NOTIFY messages for the zone.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>reconfig</userinput></term>
                    <listitem>
                      <para>
                        Reload the configuration file and load new zones,
                        but do not reload existing zone files even if they
                        have changed.
                        This is faster than a full <command>reload</command> when there
                        is a large number of zones because it avoids the need
                        to examine the
                        modification times of the zones files.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>stats</userinput></term>
                    <listitem>
                      <para>
                        Write server statistics to the statistics file.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
		    <term><userinput>querylog</userinput>
			  <optional>on|off</optional>
		    </term>
                    <listitem>
                      <para>
                        Enable or disable query logging.  (For backward
                        compatibility, this command can also be used without
                        an argument to toggle query logging on and off.)
                      </para>
                      <para>
                        Query logging can also be enabled
                        by explicitly directing the <command>queries</command>
                        <command>category</command> to a
		        <command>channel</command> in the
                        <command>logging</command> section of
                        <filename>named.conf</filename> or by specifying
			<command>querylog yes;</command> in the
			<command>options</command> section of
			<filename>named.conf</filename>.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>dumpdb
                        <optional>-all|-cache|-zone</optional>
                        <optional><replaceable>view ...</replaceable></optional></userinput></term>
                    <listitem>
                      <para>
                        Dump the server's caches (default) and/or zones to
                        the
                        dump file for the specified views.  If no view is
                        specified, all
                        views are dumped.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>secroots
                        <optional><replaceable>view ...</replaceable></optional></userinput></term>
                    <listitem>
                      <para>
                        Dump the server's security roots to the secroots
                        file for the specified views.  If no view is
                        specified, security roots for all
                        views are dumped.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>stop <optional>-p</optional></userinput></term>
                    <listitem>
                      <para>
                        Stop the server, making sure any recent changes
                        made through dynamic update or IXFR are first saved to
                        the master files of the updated zones.
			If <option>-p</option> is specified <command>named</command>'s process id is returned.
			This allows an external process to determine when <command>named</command>
			had completed stopping.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>halt <optional>-p</optional></userinput></term>
                    <listitem>
                      <para>
                        Stop the server immediately.  Recent changes
                        made through dynamic update or IXFR are not saved to
                        the master files, but will be rolled forward from the
			journal files when the server is restarted.
			If <option>-p</option> is specified <command>named</command>'s process id is returned.
			This allows an external process to determine when <command>named</command>
			had completed halting.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>trace</userinput></term>
                    <listitem>
                      <para>
                        Increment the servers debugging level by one.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>trace <replaceable>level</replaceable></userinput></term>
                    <listitem>
                      <para>
                        Sets the server's debugging level to an explicit
                        value.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>notrace</userinput></term>
                    <listitem>
                      <para>
                        Sets the server's debugging level to 0.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>flush</userinput></term>
                    <listitem>
                      <para>
                        Flushes the server's cache.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>flushname</userinput>
                       <replaceable>name</replaceable>
                       <optional><replaceable>view</replaceable></optional>
                       </term>
                    <listitem>
                      <para>
                        Flushes the given name from the server's DNS cache,
                        and from the server's nameserver address database
                        if applicable.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>flushtree</userinput>
                       <replaceable>name</replaceable>
                       <optional><replaceable>view</replaceable></optional>
                       </term>
                    <listitem>
                      <para>
                        Flushes the given name, and all of its subdomains,
                        from the server's DNS cache.  (The server's
                        nameserver address database is not affected.)
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>status</userinput></term>
                    <listitem>
                      <para>
                        Display status of the server.
                        Note that the number of zones includes the internal <command>bind/CH</command> zone
                        and the default <command>./IN</command>
                        hint zone if there is not an
                        explicit root zone configured.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>recursing</userinput></term>
                    <listitem>
                      <para>
                        Dump the list of queries <command>named</command> is currently recursing
                        on.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>validation
                        <optional>on|off</optional>
                        <optional><replaceable>view ...</replaceable></optional>
                    </userinput></term>
                    <listitem>
                      <para>
                        Enable or disable DNSSEC validation.
                        Note <command>dnssec-enable</command> also needs to be
                        set to <userinput>yes</userinput> to be effective.
                        It defaults to enabled.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>tsig-list</userinput></term>
                    <listitem>
                      <para>
                        List the names of all TSIG keys currently configured
                        for use by <command>named</command> in each view.  The
                        list both statically configured keys and dynamic
                        TKEY-negotiated keys.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>tsig-delete</userinput>
                     <replaceable>keyname</replaceable>
                     <optional><replaceable>view</replaceable></optional></term>
                    <listitem>
                      <para>
                        Delete a given TKEY-negotiated key from the server.
                        (This does not apply to statically configured TSIG
                        keys.)
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>addzone
                        <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
                        <optional><replaceable>view</replaceable></optional></optional>
                        <replaceable>configuration</replaceable>
                    </userinput></term>
                    <listitem>
                      <para>
                        Add a zone while the server is running.  This
                        command requires the
                        <command>allow-new-zones</command> option to be set
                        to <userinput>yes</userinput>.  The
                        <replaceable>configuration</replaceable> string
                        specified on the command line is the zone
                        configuration text that would ordinarily be
                        placed in <filename>named.conf</filename>.
                      </para>
                      <para>
                        The configuration is saved in a file called
                       <filename><replaceable>hash</replaceable>.nzf</filename>,
                        where <replaceable>hash</replaceable> is a
                        cryptographic hash generated from the name of
                        the view.  When <command>named</command> is
                        restarted, the file will be loaded into the view
                        configuration, so that zones that were added
                        can persist after a restart.
                      </para>
                      <para>
                        This sample <command>addzone</command> command
                        would add the zone <literal>example.com</literal>
                        to the default view:
                      </para>
                      <para>
<prompt>$ </prompt><userinput>rndc addzone example.com '{ type master; file "example.com.db"; };'</userinput>
                      </para>
                      <para>
                        (Note the brackets and semi-colon around the zone
                        configuration text.)
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>delzone
                        <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
                        <optional><replaceable>view</replaceable></optional></optional>
                    </userinput></term>
                    <listitem>
                      <para>
                        Delete a zone while the server is running.
                        Only zones that were originally added via
                        <command>rndc addzone</command> can be deleted
                        in this matter.
                      </para>
                    </listitem>
                  </varlistentry>

                  <varlistentry>
                    <term><userinput>signing
                        <optional>( -list | -clear <replaceable>keyid/algorithm</replaceable> | -clear <literal>all</literal> | -nsec3param ( <replaceable>parameters</replaceable> | <literal>none</literal> ) ) </optional>
                        <replaceable>zone</replaceable>
                        <optional><replaceable>class</replaceable>
                        <optional><replaceable>view</replaceable></optional></optional>
                    </userinput></term>
                    <listitem>
                      <para>
                        List, edit, or remove the DNSSEC signing state for 
                        the specified zone.  The status of ongoing DNSSEC
                        operations (such as signing or generating
                        NSEC3 chains) is stored in the zone in the form
                        of DNS resource records of type
                        <command>sig-signing-type</command>. 
                        <command>rndc signing -list</command> converts
                        these records into a human-readable form,
                        indicating which keys are currently signing
                        or have finished signing the zone, and which NSEC3
                        NSEC3 chains are being created or removed.
                      </para>
                      <para>
                        <command>rndc signing -clear</command> can remove
                        a single key (specified in the same format that
                        <command>rndc signing -list</command> uses to
                        display it), or all keys.  In either case, only
                        completed keys are removed; any record indicating
                        that a key has not yet finished signing the zone
                        will be retained.
                      </para>
                      <para>
                        <command>rndc signing -nsec3param</command> sets
                        the NSEC3 parameters for a zone.  This is the
                        only supported mechanism for using NSEC3 with
                        <command>inline-signing</command> zones.
                        Parameters are specified in the same format as
                        an NSEC3PARAM resource record: hash algorithm,
                        flags, iterations, and salt, in that order.
                      </para>
                      <para>
                        Currently, the only defined value for hash algorithm 
                        is <literal>1</literal>, representing SHA-1.
                        The <option>flags</option> may be set to
                        <literal>0</literal> or <literal>1</literal>,
                        depending on whether you wish to set the opt-out
                        bit in the NSEC3 chain.  <option>iterations</option>
                        defines the number of additional times to apply
                        the algorithm when generating an NSEC3 hash.  The
                        <option>salt</option> is a string of data expressed
                        in hexidecimal, or a hyphen (`-') if no salt is
                        to be used.
                      </para>
                      <para>
                        So, for example, to create an NSEC3 chain using
                        the SHA-1 hash algorithm, no opt-out flag,
                        10 iterations, and a salt value of "FFFF", use:
                        <command>rndc signing -nsec3param 1 0 10 FFFF &lt;zone&gt;</command>.
                        To set the opt-out flag, 15 iterations, and no
                        salt, use:
                        <command>rndc signing -nsec3param 1 1 15 - &lt;zone&gt;</command>.
                      </para>
                      <para>
                        <command>rndc signing -nsec3param none</command>
                        removes an existing NSEC3 chain and replaces it
                        with NSEC.
                      </para>
                    </listitem>
                  </varlistentry>

                </variablelist>

                <para>
                  A configuration file is required, since all
                  communication with the server is authenticated with
                  digital signatures that rely on a shared secret, and
                  there is no way to provide that secret other than with a
                  configuration file.  The default location for the
                  <command>rndc</command> configuration file is
                  <filename>/etc/rndc.conf</filename>, but an
                  alternate
                  location can be specified with the <option>-c</option>
                  option.  If the configuration file is not found,
                  <command>rndc</command> will also look in
                  <filename>/etc/rndc.key</filename> (or whatever
                  <varname>sysconfdir</varname> was defined when
                  the <acronym>BIND</acronym> build was
                  configured).
                  The <filename>rndc.key</filename> file is
                  generated by
                  running <command>rndc-confgen -a</command> as
                  described in
                  <xref linkend="controls_statement_definition_and_usage"/>.
                </para>

                <para>
                  The format of the configuration file is similar to
                  that of <filename>named.conf</filename>, but
                  limited to
                  only four statements, the <command>options</command>,
                  <command>key</command>, <command>server</command> and
                  <command>include</command>
                  statements.  These statements are what associate the
                  secret keys to the servers with which they are meant to
                  be shared.  The order of statements is not
                  significant.
                </para>

                <para>
                  The <command>options</command> statement has
                  three clauses:
                  <command>default-server</command>, <command>default-key</command>,
                  and <command>default-port</command>.
                  <command>default-server</command> takes a
                  host name or address argument  and represents the server
                  that will
                  be contacted if no <option>-s</option>
                  option is provided on the command line.
                  <command>default-key</command> takes
                  the name of a key as its argument, as defined by a <command>key</command> statement.
                  <command>default-port</command> specifies the
                  port to which
                  <command>rndc</command> should connect if no
                  port is given on the command line or in a
                  <command>server</command> statement.
                </para>

                <para>
                  The <command>key</command> statement defines a
                  key to be used
                  by <command>rndc</command> when authenticating
                  with
                  <command>named</command>.  Its syntax is
                  identical to the
                  <command>key</command> statement in <filename>named.conf</filename>.
                  The keyword <userinput>key</userinput> is
                  followed by a key name, which must be a valid
                  domain name, though it need not actually be hierarchical;
                  thus,
                  a string like "<userinput>rndc_key</userinput>" is a valid
                  name.
                  The <command>key</command> statement has two
                  clauses:
                  <command>algorithm</command> and <command>secret</command>.
                  While the configuration parser will accept any string as the
                  argument
                  to algorithm, currently only the string "<userinput>hmac-md5</userinput>"
                  has any meaning.  The secret is a base-64 encoded string
		  as specified in RFC 3548.
                </para>

                <para>
                  The <command>server</command> statement
                  associates a key
                  defined using the <command>key</command>
                  statement with a server.
                  The keyword <userinput>server</userinput> is followed by a
                  host name or address.  The <command>server</command> statement
                  has two clauses: <command>key</command> and <command>port</command>.
                  The <command>key</command> clause specifies the
                  name of the key
                  to be used when communicating with this server, and the
                  <command>port</command> clause can be used to
                  specify the port <command>rndc</command> should
                  connect
                  to on the server.
                </para>

                <para>
                  A sample minimal configuration file is as follows:
                </para>

<programlisting>
key rndc_key {
     algorithm "hmac-md5";
     secret
       "c3Ryb25nIGVub3VnaCBmb3IgYSBtYW4gYnV0IG1hZGUgZm9yIGEgd29tYW4K";
};
options {
     default-server 127.0.0.1;
     default-key    rndc_key;
};
</programlisting>

                <para>
                  This file, if installed as <filename>/etc/rndc.conf</filename>,
                  would allow the command:
                </para>

                <para>
                  <prompt>$ </prompt><userinput>rndc reload</userinput>
                </para>

                <para>
                  to connect to 127.0.0.1 port 953 and cause the name server
                  to reload, if a name server on the local machine were
                  running with
                  following controls statements:
                </para>

<programlisting>
controls {
        inet 127.0.0.1
            allow { localhost; } keys { rndc_key; };
};
</programlisting>

                <para>
                  and it had an identical key statement for
                  <literal>rndc_key</literal>.
                </para>

                <para>
                  Running the <command>rndc-confgen</command>
                  program will
                  conveniently create a <filename>rndc.conf</filename>
                  file for you, and also display the
                  corresponding <command>controls</command>
                  statement that you need to
                  add to <filename>named.conf</filename>.
                  Alternatively,
                  you can run <command>rndc-confgen -a</command>
                  to set up
                  a <filename>rndc.key</filename> file and not
                  modify
                  <filename>named.conf</filename> at all.
                </para>

              </listitem>
            </varlistentry>
          </variablelist>

        </sect3>
      </sect2>
      <sect2>

        <title>Signals</title>
        <para>
          Certain UNIX signals cause the name server to take specific
          actions, as described in the following table.  These signals can
          be sent using the <command>kill</command> command.
        </para>
        <informaltable frame="all">
          <tgroup cols="2">
            <colspec colname="1" colnum="1" colsep="0" colwidth="1.125in"/>
            <colspec colname="2" colnum="2" colsep="0" colwidth="4.000in"/>
            <tbody>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>SIGHUP</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Causes the server to read <filename>named.conf</filename> and
                    reload the database.
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>SIGTERM</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Causes the server to clean up and exit.
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>SIGINT</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Causes the server to clean up and exit.
                  </para>
                </entry>
              </row>
            </tbody>
          </tgroup>
        </informaltable>
      </sect2>
    </sect1>
  </chapter>

  <chapter id="Bv9ARM.ch04">
    <title>Advanced DNS Features</title>

    <sect1 id="notify">

      <title>Notify</title>
      <para>
        <acronym>DNS</acronym> NOTIFY is a mechanism that allows master
        servers to notify their slave servers of changes to a zone's data. In
        response to a <command>NOTIFY</command> from a master server, the
        slave will check to see that its version of the zone is the
        current version and, if not, initiate a zone transfer.
      </para>

      <para>
        For more information about <acronym>DNS</acronym>
        <command>NOTIFY</command>, see the description of the
        <command>notify</command> option in <xref linkend="boolean_options"/> and
        the description of the zone option <command>also-notify</command> in
        <xref linkend="zone_transfers"/>.  The <command>NOTIFY</command>
        protocol is specified in RFC 1996.
      </para>

      <note>
	As a slave zone can also be a master to other slaves, <command>named</command>,
        by default, sends <command>NOTIFY</command> messages for every zone
	it loads.  Specifying <command>notify master-only;</command> will
	cause <command>named</command> to only send <command>NOTIFY</command> for master
	zones that it loads.
      </note>

    </sect1>

    <sect1 id="dynamic_update">
      <title>Dynamic Update</title>

      <para>
        Dynamic Update is a method for adding, replacing or deleting
        records in a master server by sending it a special form of DNS
        messages.  The format and meaning of these messages is specified
        in RFC 2136.
      </para>

      <para>
	Dynamic update is enabled by including an
	<command>allow-update</command> or an <command>update-policy</command>
	clause in the <command>zone</command> statement.
      </para>
      
      <para>
	If the zone's <command>update-policy</command> is set to
	<userinput>local</userinput>, updates to the zone
	will be permitted for the key <varname>local-ddns</varname>,
        which will be generated by <command>named</command> at startup.
	See <xref linkend="dynamic_update_policies"/> for more details.
      </para>

      <para>
	Dynamic updates using Kerberos signed requests can be made
	using the TKEY/GSS protocol by setting either the
	<command>tkey-gssapi-keytab</command> option, or alternatively
	by setting both the <command>tkey-gssapi-credential</command>
	and <command>tkey-domain</command> options. Once enabled,
	Kerberos signed requests will be matched against the update
	policies for the zone, using the Kerberos principal as the
	signer for the request.
      </para>

      <para>
	Updating of secure zones (zones using DNSSEC) follows RFC
	3007: RRSIG, NSEC and NSEC3 records affected by updates are
	automatically regenerated by the server using an online
	zone key.  Update authorization is based on transaction
	signatures and an explicit server policy.
      </para>

      <sect2 id="journal">
	<title>The journal file</title>

        <para>
          All changes made to a zone using dynamic update are stored
          in the zone's journal file.  This file is automatically created
          by the server when the first dynamic update takes place.
          The name of the journal file is formed by appending the extension
          <filename>.jnl</filename> to the name of the
          corresponding zone
          file unless specifically overridden.  The journal file is in a
          binary format and should not be edited manually.
        </para>

        <para>
          The server will also occasionally write ("dump")
          the complete contents of the updated zone to its zone file.
          This is not done immediately after
          each dynamic update, because that would be too slow when a large
          zone is updated frequently.  Instead, the dump is delayed by
          up to 15 minutes, allowing additional updates to take place.
          During the dump process, transient files will be created
          with the extensions <filename>.jnw</filename> and
          <filename>.jbk</filename>; under ordinary circumstances, these
          will be removed when the dump is complete, and can be safely
          ignored.
        </para>

        <para>
          When a server is restarted after a shutdown or crash, it will replay
              the journal file to incorporate into the zone any updates that
          took
          place after the last zone dump.
        </para>

        <para>
          Changes that result from incoming incremental zone transfers are
          also
          journalled in a similar way.
        </para>

        <para>
          The zone files of dynamic zones cannot normally be edited by
          hand because they are not guaranteed to contain the most recent
          dynamic changes &mdash; those are only in the journal file.
          The only way to ensure that the zone file of a dynamic zone
          is up to date is to run <command>rndc stop</command>.
        </para>

        <para>
          If you have to make changes to a dynamic zone
          manually, the following procedure will work: Disable dynamic updates
              to the zone using
          <command>rndc freeze <replaceable>zone</replaceable></command>.
          This will also remove the zone's <filename>.jnl</filename> file
          and update the master file.  Edit the zone file.  Run
          <command>rndc thaw <replaceable>zone</replaceable></command>
          to reload the changed zone and re-enable dynamic updates.
        </para>

      </sect2>

    </sect1>

    <sect1 id="incremental_zone_transfers">
      <title>Incremental Zone Transfers (IXFR)</title>

      <para>
        The incremental zone transfer (IXFR) protocol is a way for
        slave servers to transfer only changed data, instead of having to
        transfer the entire zone. The IXFR protocol is specified in RFC
        1995. See <xref linkend="proposed_standards"/>.
      </para>

      <para>
        When acting as a master, <acronym>BIND</acronym> 9
        supports IXFR for those zones
        where the necessary change history information is available. These
        include master zones maintained by dynamic update and slave zones
        whose data was obtained by IXFR.  For manually maintained master
        zones, and for slave zones obtained by performing a full zone
        transfer (AXFR), IXFR is supported only if the option
        <command>ixfr-from-differences</command> is set
        to <userinput>yes</userinput>.
      </para>

      <para>
        When acting as a slave, <acronym>BIND</acronym> 9 will
        attempt to use IXFR unless
        it is explicitly disabled. For more information about disabling
        IXFR, see the description of the <command>request-ixfr</command> clause
        of the <command>server</command> statement.
      </para>
    </sect1>

    <sect1>
      <title>Split DNS</title>
      <para>
        Setting up different views, or visibility, of the DNS space to
        internal and external resolvers is usually referred to as a
	<emphasis>Split DNS</emphasis> setup. There are several
        reasons an organization would want to set up its DNS this way.
      </para>
      <para>
        One common reason for setting up a DNS system this way is
        to hide "internal" DNS information from "external" clients on the
        Internet. There is some debate as to whether or not this is actually
        useful.
        Internal DNS information leaks out in many ways (via email headers,
        for example) and most savvy "attackers" can find the information
        they need using other means.
	However, since listing addresses of internal servers that
        external clients cannot possibly reach can result in
        connection delays and other annoyances, an organization may
        choose to use a Split DNS to present a consistent view of itself
        to the outside world.
      </para>
      <para>
        Another common reason for setting up a Split DNS system is
        to allow internal networks that are behind filters or in RFC 1918
        space (reserved IP space, as documented in RFC 1918) to resolve DNS
        on the Internet. Split DNS can also be used to allow mail from outside
        back in to the internal network.
      </para>
     <sect2>
      <title>Example split DNS setup</title>
      <para>
        Let's say a company named <emphasis>Example, Inc.</emphasis>
        (<literal>example.com</literal>)
        has several corporate sites that have an internal network with
        reserved
        Internet Protocol (IP) space and an external demilitarized zone (DMZ),
        or "outside" section of a network, that is available to the public.
      </para>
      <para>
        <emphasis>Example, Inc.</emphasis> wants its internal clients
        to be able to resolve external hostnames and to exchange mail with
        people on the outside. The company also wants its internal resolvers
        to have access to certain internal-only zones that are not available
        at all outside of the internal network.
      </para>
      <para>
        In order to accomplish this, the company will set up two sets
        of name servers. One set will be on the inside network (in the
        reserved
        IP space) and the other set will be on bastion hosts, which are
        "proxy"
        hosts that can talk to both sides of its network, in the DMZ.
      </para>
      <para>
        The internal servers will be configured to forward all queries,
        except queries for <filename>site1.internal</filename>, <filename>site2.internal</filename>, <filename>site1.example.com</filename>,
        and <filename>site2.example.com</filename>, to the servers
        in the
        DMZ. These internal servers will have complete sets of information
        for <filename>site1.example.com</filename>, <filename>site2.example.com</filename>, <filename>site1.internal</filename>,
        and <filename>site2.internal</filename>.
      </para>
      <para>
        To protect the <filename>site1.internal</filename> and <filename>site2.internal</filename> domains,
        the internal name servers must be configured to disallow all queries
        to these domains from any external hosts, including the bastion
        hosts.
      </para>
      <para>
        The external servers, which are on the bastion hosts, will
        be configured to serve the "public" version of the <filename>site1</filename> and <filename>site2.example.com</filename> zones.
        This could include things such as the host records for public servers
        (<filename>www.example.com</filename> and <filename>ftp.example.com</filename>),
        and mail exchange (MX)  records (<filename>a.mx.example.com</filename> and <filename>b.mx.example.com</filename>).
      </para>
      <para>
        In addition, the public <filename>site1</filename> and <filename>site2.example.com</filename> zones
        should have special MX records that contain wildcard (`*') records
        pointing to the bastion hosts. This is needed because external mail
        servers do not have any other way of looking up how to deliver mail
        to those internal hosts. With the wildcard records, the mail will
        be delivered to the bastion host, which can then forward it on to
        internal hosts.
      </para>
      <para>
        Here's an example of a wildcard MX record:
      </para>
      <programlisting>*   IN MX 10 external1.example.com.</programlisting>
      <para>
        Now that they accept mail on behalf of anything in the internal
        network, the bastion hosts will need to know how to deliver mail
        to internal hosts. In order for this to work properly, the resolvers
        on
        the bastion hosts will need to be configured to point to the internal
        name servers for DNS resolution.
      </para>
      <para>
        Queries for internal hostnames will be answered by the internal
        servers, and queries for external hostnames will be forwarded back
        out to the DNS servers on the bastion hosts.
      </para>
      <para>
        In order for all this to work properly, internal clients will
        need to be configured to query <emphasis>only</emphasis> the internal
        name servers for DNS queries. This could also be enforced via
        selective
        filtering on the network.
      </para>
      <para>
        If everything has been set properly, <emphasis>Example, Inc.</emphasis>'s
        internal clients will now be able to:
      </para>
      <itemizedlist>
        <listitem>
          <simpara>
            Look up any hostnames in the <literal>site1</literal>
            and
            <literal>site2.example.com</literal> zones.
          </simpara>
        </listitem>
        <listitem>
          <simpara>
            Look up any hostnames in the <literal>site1.internal</literal> and
            <literal>site2.internal</literal> domains.
          </simpara>
        </listitem>
        <listitem>
          <simpara>Look up any hostnames on the Internet.</simpara>
        </listitem>
        <listitem>
          <simpara>Exchange mail with both internal and external people.</simpara>
        </listitem>
      </itemizedlist>
      <para>
        Hosts on the Internet will be able to:
      </para>
      <itemizedlist>
        <listitem>
          <simpara>
            Look up any hostnames in the <literal>site1</literal>
            and
            <literal>site2.example.com</literal> zones.
          </simpara>
        </listitem>
        <listitem>
          <simpara>
            Exchange mail with anyone in the <literal>site1</literal> and
            <literal>site2.example.com</literal> zones.
          </simpara>
        </listitem>
      </itemizedlist>

      <para>
        Here is an example configuration for the setup we just
        described above. Note that this is only configuration information;
        for information on how to configure your zone files, see <xref linkend="sample_configuration"/>.
      </para>

      <para>
        Internal DNS server config:
      </para>

<programlisting>

acl internals { 172.16.72.0/24; 192.168.1.0/24; };

acl externals { <varname>bastion-ips-go-here</varname>; };

options {
    ...
    ...
    forward only;
    // forward to external servers
    forwarders {
        <varname>bastion-ips-go-here</varname>;
    };
    // sample allow-transfer (no one)
    allow-transfer { none; };
    // restrict query access
    allow-query { internals; externals; };
    // restrict recursion
    allow-recursion { internals; };
    ...
    ...
};

// sample master zone
zone "site1.example.com" {
  type master;
  file "m/site1.example.com";
  // do normal iterative resolution (do not forward)
  forwarders { };
  allow-query { internals; externals; };
  allow-transfer { internals; };
};

// sample slave zone
zone "site2.example.com" {
  type slave;
  file "s/site2.example.com";
  masters { 172.16.72.3; };
  forwarders { };
  allow-query { internals; externals; };
  allow-transfer { internals; };
};

zone "site1.internal" {
  type master;
  file "m/site1.internal";
  forwarders { };
  allow-query { internals; };
  allow-transfer { internals; }
};

zone "site2.internal" {
  type slave;
  file "s/site2.internal";
  masters { 172.16.72.3; };
  forwarders { };
  allow-query { internals };
  allow-transfer { internals; }
};
</programlisting>

      <para>
        External (bastion host) DNS server config:
      </para>

<programlisting>
acl internals { 172.16.72.0/24; 192.168.1.0/24; };

acl externals { bastion-ips-go-here; };

options {
  ...
  ...
  // sample allow-transfer (no one)
  allow-transfer { none; };
  // default query access
  allow-query { any; };
  // restrict cache access
  allow-query-cache { internals; externals; };
  // restrict recursion
  allow-recursion { internals; externals; };
  ...
  ...
};

// sample slave zone
zone "site1.example.com" {
  type master;
  file "m/site1.foo.com";
  allow-transfer { internals; externals; };
};

zone "site2.example.com" {
  type slave;
  file "s/site2.foo.com";
  masters { another_bastion_host_maybe; };
  allow-transfer { internals; externals; }
};
</programlisting>

      <para>
        In the <filename>resolv.conf</filename> (or equivalent) on
        the bastion host(s):
      </para>

<programlisting>
search ...
nameserver 172.16.72.2
nameserver 172.16.72.3
nameserver 172.16.72.4
</programlisting>

     </sect2>
    </sect1>
    <sect1 id="tsig">
      <title>TSIG</title>
      <para>
        This is a short guide to setting up Transaction SIGnatures
        (TSIG) based transaction security in <acronym>BIND</acronym>. It describes changes
        to the configuration file as well as what changes are required for
        different features, including the process of creating transaction
        keys and using transaction signatures with <acronym>BIND</acronym>.
      </para>
      <para>
        <acronym>BIND</acronym> primarily supports TSIG for server
        to server communication.
        This includes zone transfer, notify, and recursive query messages.
        Resolvers based on newer versions of <acronym>BIND</acronym> 8 have limited support
        for TSIG.
      </para>

      <para>
        TSIG can also be useful for dynamic update. A primary
        server for a dynamic zone should control access to the dynamic
        update service, but IP-based access control is insufficient.
        The cryptographic access control provided by TSIG
        is far superior. The <command>nsupdate</command>
        program supports TSIG via the <option>-k</option> and
        <option>-y</option> command line options or inline by use
	of the <command>key</command>.
      </para>

      <sect2>
        <title>Generate Shared Keys for Each Pair of Hosts</title>
        <para>
          A shared secret is generated to be shared between <emphasis>host1</emphasis> and <emphasis>host2</emphasis>.
          An arbitrary key name is chosen: "host1-host2.". The key name must
          be the same on both hosts.
        </para>
        <sect3>
          <title>Automatic Generation</title>
          <para>
            The following command will generate a 128-bit (16 byte) HMAC-SHA256
            key as described above. Longer keys are better, but shorter keys
            are easier to read. Note that the maximum key length is the digest
            length, here 256 bits.
          </para>
          <para>
            <userinput>dnssec-keygen -a hmac-sha256 -b 128 -n HOST host1-host2.</userinput>
          </para>
          <para>
            The key is in the file <filename>Khost1-host2.+163+00000.private</filename>.
            Nothing directly uses this file, but the base-64 encoded string
            following "<literal>Key:</literal>"
            can be extracted from the file and used as a shared secret:
          </para>
          <programlisting>Key: La/E5CjG9O+os1jq0a2jdA==</programlisting>
          <para>
            The string "<literal>La/E5CjG9O+os1jq0a2jdA==</literal>" can
            be used as the shared secret.
          </para>
        </sect3>
        <sect3>
          <title>Manual Generation</title>
          <para>
            The shared secret is simply a random sequence of bits, encoded
            in base-64. Most ASCII strings are valid base-64 strings (assuming
            the length is a multiple of 4 and only valid characters are used),
            so the shared secret can be manually generated.
          </para>
          <para>
            Also, a known string can be run through <command>mmencode</command> or
            a similar program to generate base-64 encoded data.
          </para>
        </sect3>
      </sect2>
      <sect2>
        <title>Copying the Shared Secret to Both Machines</title>
        <para>
          This is beyond the scope of DNS. A secure transport mechanism
          should be used. This could be secure FTP, ssh, telephone, etc.
        </para>
      </sect2>
      <sect2>
        <title>Informing the Servers of the Key's Existence</title>
        <para>
          Imagine <emphasis>host1</emphasis> and <emphasis>host 2</emphasis>
          are
          both servers. The following is added to each server's <filename>named.conf</filename> file:
        </para>

<programlisting>
key host1-host2. {
  algorithm hmac-sha256;
  secret "La/E5CjG9O+os1jq0a2jdA==";
};
</programlisting>

        <para>
          The secret is the one generated above. Since this is a secret, it
          is recommended that either <filename>named.conf</filename> be
          non-world readable, or the key directive be added to a non-world
          readable file that is included by <filename>named.conf</filename>.
        </para>
        <para>
          At this point, the key is recognized. This means that if the
          server receives a message signed by this key, it can verify the
          signature. If the signature is successfully verified, the
          response is signed by the same key.
        </para>
      </sect2>

      <sect2>
        <title>Instructing the Server to Use the Key</title>
        <para>
          Since keys are shared between two hosts only, the server must
          be told when keys are to be used. The following is added to the <filename>named.conf</filename> file
          for <emphasis>host1</emphasis>, if the IP address of <emphasis>host2</emphasis> is
          10.1.2.3:
        </para>

<programlisting>
server 10.1.2.3 {
  keys { host1-host2. ;};
};
</programlisting>

        <para>
          Multiple keys may be present, but only the first is used.
          This directive does not contain any secrets, so it may be in a
          world-readable
          file.
        </para>
        <para>
          If <emphasis>host1</emphasis> sends a message that is a request
          to that address, the message will be signed with the specified key. <emphasis>host1</emphasis> will
          expect any responses to signed messages to be signed with the same
          key.
        </para>
        <para>
          A similar statement must be present in <emphasis>host2</emphasis>'s
          configuration file (with <emphasis>host1</emphasis>'s address) for <emphasis>host2</emphasis> to
          sign request messages to <emphasis>host1</emphasis>.
        </para>
      </sect2>
      <sect2>
        <title>TSIG Key Based Access Control</title>
        <para>
          <acronym>BIND</acronym> allows IP addresses and ranges
          to be specified in ACL
          definitions and
          <command>allow-{ query | transfer | update }</command>
          directives.
          This has been extended to allow TSIG keys also. The above key would
          be denoted <command>key host1-host2.</command>
        </para>
        <para>
          An example of an <command>allow-update</command> directive would be:
        </para>

<programlisting>
allow-update { key host1-host2. ;};
</programlisting>

	<para>
	  This allows dynamic updates to succeed only if the request
	  was signed by a key named "<command>host1-host2.</command>".
	</para>

	<para>
	  See <xref linkend="dynamic_update_policies"/> for a discussion of
          the more flexible <command>update-policy</command> statement.
	</para>

      </sect2>
      <sect2>
        <title>Errors</title>

        <para>
          The processing of TSIG signed messages can result in
          several errors. If a signed message is sent to a non-TSIG aware
          server, a FORMERR (format error) will be returned, since the server will not
          understand the record. This is a result of misconfiguration,
          since the server must be explicitly configured to send a TSIG
          signed message to a specific server.
        </para>

        <para>
          If a TSIG aware server receives a message signed by an
          unknown key, the response will be unsigned with the TSIG
          extended error code set to BADKEY. If a TSIG aware server
          receives a message with a signature that does not validate, the
          response will be unsigned with the TSIG extended error code set
          to BADSIG. If a TSIG aware server receives a message with a time
          outside of the allowed range, the response will be signed with
          the TSIG extended error code set to BADTIME, and the time values
          will be adjusted so that the response can be successfully
          verified. In any of these cases, the message's rcode (response code) is set to
          NOTAUTH (not authenticated).
        </para>

      </sect2>
    </sect1>
    <sect1>
      <title>TKEY</title>

      <para><command>TKEY</command>
        is a mechanism for automatically generating a shared secret
        between two hosts.  There are several "modes" of
        <command>TKEY</command> that specify how the key is generated
        or assigned.  <acronym>BIND</acronym> 9 implements only one of
        these modes, the Diffie-Hellman key exchange.  Both hosts are
        required to have a Diffie-Hellman KEY record (although this
        record is not required to be present in a zone).  The
        <command>TKEY</command> process must use signed messages,
        signed either by TSIG or SIG(0).  The result of
        <command>TKEY</command> is a shared secret that can be used to
        sign messages with TSIG.  <command>TKEY</command> can also be
        used to delete shared secrets that it had previously
        generated.
      </para>

      <para>
        The <command>TKEY</command> process is initiated by a
        client
        or server by sending a signed <command>TKEY</command>
        query
        (including any appropriate KEYs) to a TKEY-aware server.  The
        server response, if it indicates success, will contain a
        <command>TKEY</command> record and any appropriate keys.
        After
        this exchange, both participants have enough information to
        determine the shared secret; the exact process depends on the
        <command>TKEY</command> mode.  When using the
        Diffie-Hellman
        <command>TKEY</command> mode, Diffie-Hellman keys are
        exchanged,
        and the shared secret is derived by both participants.
      </para>

    </sect1>
    <sect1>
      <title>SIG(0)</title>

      <para>
        <acronym>BIND</acronym> 9 partially supports DNSSEC SIG(0)
            transaction signatures as specified in RFC 2535 and RFC 2931.
        SIG(0)
        uses public/private keys to authenticate messages.  Access control
        is performed in the same manner as TSIG keys; privileges can be
        granted or denied based on the key name.
      </para>

      <para>
        When a SIG(0) signed message is received, it will only be
        verified if the key is known and trusted by the server; the server
        will not attempt to locate and/or validate the key.
      </para>

      <para>
        SIG(0) signing of multiple-message TCP streams is not
        supported.
      </para>

      <para>
        The only tool shipped with <acronym>BIND</acronym> 9 that
        generates SIG(0) signed messages is <command>nsupdate</command>.
      </para>

    </sect1>
    <sect1 id="DNSSEC">
      <title>DNSSEC</title>

      <para>
        Cryptographic authentication of DNS information is possible
        through the DNS Security (<emphasis>DNSSEC-bis</emphasis>) extensions,
        defined in RFC 4033, RFC 4034, and RFC 4035.
	This section describes the creation and use of DNSSEC signed zones.
      </para>

      <para>
        In order to set up a DNSSEC secure zone, there are a series
        of steps which must be followed.  <acronym>BIND</acronym>
        9 ships
        with several tools
        that are used in this process, which are explained in more detail
        below.  In all cases, the <option>-h</option> option prints a
        full list of parameters.  Note that the DNSSEC tools require the
        keyset files to be in the working directory or the
        directory specified by the <option>-d</option> option, and
        that the tools shipped with BIND 9.2.x and earlier are not compatible
        with the current ones.
      </para>

      <para>
        There must also be communication with the administrators of
        the parent and/or child zone to transmit keys.  A zone's security
        status must be indicated by the parent zone for a DNSSEC capable
        resolver to trust its data.  This is done through the presence
        or absence of a <literal>DS</literal> record at the
        delegation
        point.
      </para>

      <para>
        For other servers to trust data in this zone, they must
        either be statically configured with this zone's zone key or the
        zone key of another zone above this one in the DNS tree.
      </para>

      <sect2>
        <title>Generating Keys</title>

        <para>
          The <command>dnssec-keygen</command> program is used to
          generate keys.
        </para>

        <para>
          A secure zone must contain one or more zone keys.  The
          zone keys will sign all other records in the zone, as well as
          the zone keys of any secure delegated zones.  Zone keys must
          have the same name as the zone, a name type of
          <command>ZONE</command>, and must be usable for
          authentication.
          It is recommended that zone keys use a cryptographic algorithm
          designated as "mandatory to implement" by the IETF; currently
          the only one is RSASHA1.
        </para>

        <para>
          The following command will generate a 768-bit RSASHA1 key for
          the <filename>child.example</filename> zone:
        </para>

        <para>
          <userinput>dnssec-keygen -a RSASHA1 -b 768 -n ZONE child.example.</userinput>
        </para>

        <para>
          Two output files will be produced:
          <filename>Kchild.example.+005+12345.key</filename> and
          <filename>Kchild.example.+005+12345.private</filename>
          (where
          12345 is an example of a key tag).  The key filenames contain
          the key name (<filename>child.example.</filename>),
          algorithm (3
          is DSA, 1 is RSAMD5, 5 is RSASHA1, etc.), and the key tag (12345 in
          this case).
          The private key (in the <filename>.private</filename>
          file) is
          used to generate signatures, and the public key (in the
          <filename>.key</filename> file) is used for signature
          verification.
        </para>

        <para>
          To generate another key with the same properties (but with
          a different key tag), repeat the above command.
        </para>

        <para>
          The <command>dnssec-keyfromlabel</command> program is used
          to get a key pair from a crypto hardware and build the key
          files. Its usage is similar to <command>dnssec-keygen</command>.
        </para>

        <para>
          The public keys should be inserted into the zone file by
          including the <filename>.key</filename> files using
          <command>$INCLUDE</command> statements.
        </para>

      </sect2>
      <sect2>
        <title>Signing the Zone</title>

	<para>
	  The <command>dnssec-signzone</command> program is used
	  to sign a zone.
	</para>

	<para>
	  Any <filename>keyset</filename> files corresponding to
	  secure subzones should be present.  The zone signer will
	  generate <literal>NSEC</literal>, <literal>NSEC3</literal>
	  and <literal>RRSIG</literal> records for the zone, as
	  well as <literal>DS</literal> for the child zones if
	  <literal>'-g'</literal> is specified.  If <literal>'-g'</literal>
	  is not specified, then DS RRsets for the secure child
	  zones need to be added manually.
	</para>

        <para>
          The following command signs the zone, assuming it is in a
          file called <filename>zone.child.example</filename>.  By
                default, all zone keys which have an available private key are
                used to generate signatures.
        </para>

        <para>
          <userinput>dnssec-signzone -o child.example zone.child.example</userinput>
        </para>

        <para>
          One output file is produced:
          <filename>zone.child.example.signed</filename>.  This
          file
          should be referenced by <filename>named.conf</filename>
          as the
          input file for the zone.
        </para>

        <para><command>dnssec-signzone</command>
	  will also produce a keyset and dsset files and optionally a
          dlvset file.  These are used to provide the parent zone
          administrators with the <literal>DNSKEYs</literal> (or their
          corresponding <literal>DS</literal> records) that are the
          secure entry point to the zone.
        </para>

      </sect2>

      <sect2>
        <title>Configuring Servers</title>

	<para>
	  To enable <command>named</command> to respond appropriately
	  to DNS requests from DNSSEC aware clients,
	  <command>dnssec-enable</command> must be set to yes.
          (This is the default setting.)
        </para>

	<para>
	  To enable <command>named</command> to validate answers from
	  other servers, the <command>dnssec-enable</command> option
          must be set to <userinput>yes</userinput>, and the
          <command>dnssec-validation</command> options must be set to 
          <userinput>yes</userinput> or <userinput>auto</userinput>.
        </para>
	  
	<para>
          If <command>dnssec-validation</command> is set to
          <userinput>auto</userinput>, then a default
          trust anchor for the DNS root zone will be used.
          If it is set to <userinput>yes</userinput>, however,
          then at least one trust anchor must be configured
          with a <command>trusted-keys</command> or
          <command>managed-keys</command> statement in
          <filename>named.conf</filename>, or DNSSEC validation
          will not occur.  The default setting is
          <userinput>yes</userinput>.
        </para>
	  
	<para>
	  <command>trusted-keys</command> are copies of DNSKEY RRs
	  for zones that are used to form the first link in the
	  cryptographic chain of trust.  All keys listed in
	  <command>trusted-keys</command> (and corresponding zones)
	  are deemed to exist and only the listed keys will be used
	  to validated the DNSKEY RRset that they are from.
	</para>

	<para>
	  <command>managed-keys</command> are trusted keys which are
          automatically kept up to date via RFC 5011 trust anchor
          maintenance.
	</para>

	<para>
	  <command>trusted-keys</command> and
          <command>managed-keys</command> are described in more detail
	  later in this document.
	</para>

	<para>
	  Unlike <acronym>BIND</acronym> 8, <acronym>BIND</acronym>
	  9 does not verify signatures on load, so zone keys for
	  authoritative zones do not need to be specified in the
	  configuration file.
	</para>

	<para>
	  After DNSSEC gets established, a typical DNSSEC configuration
	  will look something like the following.  It has one or
	  more public keys for the root.  This allows answers from
	  outside the organization to be validated.  It will also
	  have several keys for parts of the namespace the organization
          controls.  These are here to ensure that <command>named</command>
          is immune to compromises in the DNSSEC components of the security
          of parent zones.
	</para>

<programlisting>
managed-keys {
	/* Root Key */
        "." initial-key 257 3 3 "BNY4wrWM1nCfJ+CXd0rVXyYmobt7sEEfK3clRbGaTwS
                                 JxrGkxJWoZu6I7PzJu/E9gx4UC1zGAHlXKdE4zYIpRh
                                 aBKnvcC2U9mZhkdUpd1Vso/HAdjNe8LmMlnzY3zy2Xy
                                 4klWOADTPzSv9eamj8V18PHGjBLaVtYvk/ln5ZApjYg
                                 hf+6fElrmLkdaz MQ2OCnACR817DF4BBa7UR/beDHyp
                                 5iWTXWSi6XmoJLbG9Scqc7l70KDqlvXR3M/lUUVRbke
                                 g1IPJSidmK3ZyCllh4XSKbje/45SKucHgnwU5jefMtq
                                 66gKodQj+MiA21AfUVe7u99WzTLzY3qlxDhxYQQ20FQ
                                 97S+LKUTpQcq27R7AT3/V5hRQxScINqwcz4jYqZD2fQ
                                 dgxbcDTClU0CRBdiieyLMNzXG3";
};

trusted-keys {
        /* Key for our organization's forward zone */
        example.com. 257 3 5 "AwEAAaxPMcR2x0HbQV4WeZB6oEDX+r0QM6
                              5KbhTjrW1ZaARmPhEZZe3Y9ifgEuq7vZ/z
                              GZUdEGNWy+JZzus0lUptwgjGwhUS1558Hb
                              4JKUbbOTcM8pwXlj0EiX3oDFVmjHO444gL
                              kBOUKUf/mC7HvfwYH/Be22GnClrinKJp1O
                              g4ywzO9WglMk7jbfW33gUKvirTHr25GL7S
                              TQUzBb5Usxt8lgnyTUHs1t3JwCY5hKZ6Cq
                              FxmAVZP20igTixin/1LcrgX/KMEGd/biuv
                              F4qJCyduieHukuY3H4XMAcR+xia2nIUPvm
                              /oyWR8BW/hWdzOvnSCThlHf3xiYleDbt/o
                              1OTQ09A0=";

        /* Key for our reverse zone. */
        2.0.192.IN-ADDRPA.NET. 257 3 5 "AQOnS4xn/IgOUpBPJ3bogzwc
                                       xOdNax071L18QqZnQQQAVVr+i
                                       LhGTnNGp3HoWQLUIzKrJVZ3zg
                                       gy3WwNT6kZo6c0tszYqbtvchm
                                       gQC8CzKojM/W16i6MG/eafGU3
                                       siaOdS0yOI6BgPsw+YZdzlYMa
                                       IJGf4M4dyoKIhzdZyQ2bYQrjy
                                       Q4LB0lC7aOnsMyYKHHYeRvPxj
                                       IQXmdqgOJGq+vsevG06zW+1xg
                                       YJh9rCIfnm1GX/KMgxLPG2vXT
                                       D/RnLX+D3T3UL7HJYHJhAZD5L
                                       59VvjSPsZJHeDCUyWYrvPZesZ
                                       DIRvhDD52SKvbheeTJUm6Ehkz
                                       ytNN2SN96QRk8j/iI8ib";
};

options {
	...
	dnssec-enable yes;
	dnssec-validation yes;
};
</programlisting>

	<note>
	  None of the keys listed in this example are valid.  In particular,
	  the root key is not valid.
	</note>

	<para>
	  When DNSSEC validation is enabled and properly configured,
	  the resolver will reject any answers from signed, secure zones
	  which fail to validate, and will return SERVFAIL to the client.
	</para>

	<para>
	  Responses may fail to validate for any of several reasons,
	  including missing, expired, or invalid signatures, a key which
	  does not match the DS RRset in the parent zone, or an insecure
	  response from a zone which, according to its parent, should have
	  been secure.  
	</para>

	<note>
	  <para>
	    When the validator receives a response from an unsigned zone
	    that has a signed parent, it must confirm with the parent
	    that the zone was intentionally left unsigned.  It does
	    this by verifying, via signed and validated NSEC/NSEC3 records,
	    that the parent zone contains no DS records for the child.
	  </para>
	  <para>
	    If the validator <emphasis>can</emphasis> prove that the zone
	    is insecure, then the response is accepted.  However, if it
	    cannot, then it must assume an insecure response to be a
	    forgery; it rejects the response and logs an error.
	  </para>
	  <para>
            The logged error reads "insecurity proof failed" and
            "got insecure response; parent indicates it should be secure".
	    (Prior to BIND 9.7, the logged error was "not insecure".
            This referred to the zone, not the response.)
	  </para>
	</note>
      </sect2>

    </sect1>

    <xi:include href="dnssec.xml"/>

    <xi:include href="managed-keys.xml"/>

    <xi:include href="pkcs11.xml"/>

    <sect1>
      <title>IPv6 Support in <acronym>BIND</acronym> 9</title>

      <para>
        <acronym>BIND</acronym> 9 fully supports all currently
        defined forms of IPv6 name to address and address to name
        lookups.  It will also use IPv6 addresses to make queries when
        running on an IPv6 capable system.
      </para>

      <para>
        For forward lookups, <acronym>BIND</acronym> 9 supports
        only AAAA records.  RFC 3363 deprecated the use of A6 records,
        and client-side support for A6 records was accordingly removed
        from <acronym>BIND</acronym> 9.
        However, authoritative <acronym>BIND</acronym> 9 name servers still
        load zone files containing A6 records correctly, answer queries
        for A6 records, and accept zone transfer for a zone containing A6
        records.
      </para>

      <para>
        For IPv6 reverse lookups, <acronym>BIND</acronym> 9 supports
        the traditional "nibble" format used in the
        <emphasis>ip6.arpa</emphasis> domain, as well as the older, deprecated
        <emphasis>ip6.int</emphasis> domain.
        Older versions of <acronym>BIND</acronym> 9 
        supported the "binary label" (also known as "bitstring") format,
        but support of binary labels has been completely removed per
        RFC 3363.
        Many applications in <acronym>BIND</acronym> 9 do not understand
        the binary label format at all any more, and will return an
        error if given.
	In particular, an authoritative <acronym>BIND</acronym> 9
        name server will not load a zone file containing binary labels.
      </para>

      <para>
        For an overview of the format and structure of IPv6 addresses,
        see <xref linkend="ipv6addresses"/>.
      </para>

      <sect2>
        <title>Address Lookups Using AAAA Records</title>

        <para>
          The IPv6 AAAA record is a parallel to the IPv4 A record,
          and, unlike the deprecated A6 record, specifies the entire
          IPv6 address in a single record.  For example,
        </para>

<programlisting>
$ORIGIN example.com.
host            3600    IN      AAAA    2001:db8::1
</programlisting>

        <para>
          Use of IPv4-in-IPv6 mapped addresses is not recommended.
	  If a host has an IPv4 address, use an A record, not
          a AAAA, with <literal>::ffff:192.168.42.1</literal> as
          the address.
        </para>
      </sect2>
      <sect2>
        <title>Address to Name Lookups Using Nibble Format</title>

        <para>
          When looking up an address in nibble format, the address
          components are simply reversed, just as in IPv4, and
          <literal>ip6.arpa.</literal> is appended to the
          resulting name.
          For example, the following would provide reverse name lookup for
          a host with address
          <literal>2001:db8::1</literal>.
        </para>

<programlisting>
$ORIGIN 0.0.0.0.0.0.0.0.8.b.d.0.1.0.0.2.ip6.arpa.
1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0  14400   IN    PTR    (
                                    host.example.com. )
</programlisting>

      </sect2>
    </sect1>
  </chapter>

  <chapter id="Bv9ARM.ch05">
    <title>The <acronym>BIND</acronym> 9 Lightweight Resolver</title>
    <sect1>
      <title>The Lightweight Resolver Library</title>
      <para>
        Traditionally applications have been linked with a stub resolver
        library that sends recursive DNS queries to a local caching name
        server.
      </para>
      <para>
        IPv6 once introduced new complexity into the resolution process,
        such as following A6 chains and DNAME records, and simultaneous
        lookup of IPv4 and IPv6 addresses.  Though most of the complexity was
        then removed, these are hard or impossible
        to implement in a traditional stub resolver.
      </para>
      <para>
        <acronym>BIND</acronym> 9 therefore can also provide resolution
        services to local clients
        using a combination of a lightweight resolver library and a resolver
        daemon process running on the local host.  These communicate using
        a simple UDP-based protocol, the "lightweight resolver protocol"
        that is distinct from and simpler than the full DNS protocol.
      </para>
    </sect1>
    <sect1 id="lwresd">
      <title>Running a Resolver Daemon</title>

      <para>
        To use the lightweight resolver interface, the system must
        run the resolver daemon <command>lwresd</command> or a
        local
        name server configured with a <command>lwres</command>
        statement.
      </para>

      <para>
        By default, applications using the lightweight resolver library will
        make
        UDP requests to the IPv4 loopback address (127.0.0.1) on port 921.
        The
        address can be overridden by <command>lwserver</command>
        lines in
        <filename>/etc/resolv.conf</filename>.
      </para>

      <para>
        The daemon currently only looks in the DNS, but in the future
        it may use other sources such as <filename>/etc/hosts</filename>,
        NIS, etc.
      </para>

      <para>
        The <command>lwresd</command> daemon is essentially a
        caching-only name server that responds to requests using the
        lightweight
        resolver protocol rather than the DNS protocol.  Because it needs
        to run on each host, it is designed to require no or minimal
        configuration.
        Unless configured otherwise, it uses the name servers listed on
        <command>nameserver</command> lines in <filename>/etc/resolv.conf</filename>
        as forwarders, but is also capable of doing the resolution
        autonomously if
        none are specified.
      </para>
      <para>
        The <command>lwresd</command> daemon may also be
        configured with a
        <filename>named.conf</filename> style configuration file,
        in
        <filename>/etc/lwresd.conf</filename> by default.  A name
        server may also
        be configured to act as a lightweight resolver daemon using the
        <command>lwres</command> statement in <filename>named.conf</filename>.
      </para>

    </sect1>
  </chapter>

  <chapter id="Bv9ARM.ch06">
    <title><acronym>BIND</acronym> 9 Configuration Reference</title>

    <para>
      <acronym>BIND</acronym> 9 configuration is broadly similar
      to <acronym>BIND</acronym> 8; however, there are a few new
      areas
      of configuration, such as views. <acronym>BIND</acronym>
      8 configuration files should work with few alterations in <acronym>BIND</acronym>
      9, although more complex configurations should be reviewed to check
      if they can be more efficiently implemented using the new features
      found in <acronym>BIND</acronym> 9.
    </para>

    <para>
      <acronym>BIND</acronym> 4 configuration files can be
      converted to the new format
      using the shell script
      <filename>contrib/named-bootconf/named-bootconf.sh</filename>.
    </para>
    <sect1 id="configuration_file_elements">
      <title>Configuration File Elements</title>
      <para>
        Following is a list of elements used throughout the <acronym>BIND</acronym> configuration
        file documentation:
      </para>
      <informaltable colsep="0" rowsep="0">
        <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="2Level-table">
          <colspec colname="1" colnum="1" colsep="0" colwidth="1.855in"/>
          <colspec colname="2" colnum="2" colsep="0" colwidth="3.770in"/>
          <tbody>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>acl_name</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  The name of an <varname>address_match_list</varname> as
                  defined by the <command>acl</command> statement.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>address_match_list</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A list of one or more
                  <varname>ip_addr</varname>,
                  <varname>ip_prefix</varname>, <varname>key_id</varname>,
                  or <varname>acl_name</varname> elements, see
                  <xref linkend="address_match_lists"/>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>masters_list</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A named list of one or more <varname>ip_addr</varname>
		  with optional <varname>key_id</varname> and/or
		  <varname>ip_port</varname>.
		  A <varname>masters_list</varname> may include other
		  <varname>masters_lists</varname>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>domain_name</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A quoted string which will be used as
                  a DNS name, for example "<literal>my.test.domain</literal>".
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>namelist</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A list of one or more <varname>domain_name</varname>
                  elements.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>dotted_decimal</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  One to four integers valued 0 through
                  255 separated by dots (`.'), such as <command>123</command>,
                  <command>45.67</command> or <command>89.123.45.67</command>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>ip4_addr</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  An IPv4 address with exactly four elements
                  in <varname>dotted_decimal</varname> notation.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>ip6_addr</varname>
                </para>
              </entry>
	      <entry colname="2">
		<para>
		  An IPv6 address, such as <command>2001:db8::1234</command>.
		  IPv6 scoped addresses that have ambiguity on their
		  scope zones must be disambiguated by an appropriate
		  zone ID with the percent character (`%') as
		  delimiter.  It is strongly recommended to use
		  string zone names rather than numeric identifiers,
		  in order to be robust against system configuration
		  changes.  However, since there is no standard
		  mapping for such names and identifier values,
		  currently only interface names as link identifiers
		  are supported, assuming one-to-one mapping between
		  interfaces and links.  For example, a link-local
		  address <command>fe80::1</command> on the link
		  attached to the interface <command>ne0</command>
		  can be specified as <command>fe80::1%ne0</command>.
		  Note that on most systems link-local addresses
		  always have the ambiguity, and need to be
		  disambiguated.
		</para>
	      </entry>
	    </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>ip_addr</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  An <varname>ip4_addr</varname> or <varname>ip6_addr</varname>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>ip_port</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  An IP port <varname>number</varname>.
                  The <varname>number</varname> is limited to 0
                  through 65535, with values
                  below 1024 typically restricted to use by processes running
                  as root.
                  In some cases, an asterisk (`*') character can be used as a
                  placeholder to
                  select a random high-numbered port.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>ip_prefix</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  An IP network specified as an <varname>ip_addr</varname>,
                  followed by a slash (`/') and then the number of bits in the
                  netmask.
                  Trailing zeros in a <varname>ip_addr</varname>
                  may omitted.
                  For example, <command>127/8</command> is the
                  network <command>127.0.0.0</command> with
                  netmask <command>255.0.0.0</command> and <command>1.2.3.0/28</command> is
                  network <command>1.2.3.0</command> with netmask <command>255.255.255.240</command>.
                </para>
                <para>
		  When specifying a prefix involving a IPv6 scoped address
		  the scope may be omitted.  In that case the prefix will
		  match packets from any scope.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>key_id</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A <varname>domain_name</varname> representing
                  the name of a shared key, to be used for transaction
                  security.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>key_list</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A list of one or more
                  <varname>key_id</varname>s,
                  separated by semicolons and ending with a semicolon.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>number</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A non-negative 32-bit integer
                  (i.e., a number between 0 and 4294967295, inclusive).
                  Its acceptable value might further
                  be limited by the context in which it is used.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>path_name</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A quoted string which will be used as
                  a pathname, such as <filename>zones/master/my.test.domain</filename>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>port_list</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
		  A list of an <varname>ip_port</varname> or a port
		  range.
		  A port range is specified in the form of
		  <userinput>range</userinput> followed by
		  two <varname>ip_port</varname>s,
		  <varname>port_low</varname> and
		  <varname>port_high</varname>, which represents
		  port numbers from <varname>port_low</varname> through
		  <varname>port_high</varname>, inclusive.
		  <varname>port_low</varname> must not be larger than
		  <varname>port_high</varname>.
		  For example,
		  <userinput>range 1024 65535</userinput> represents
		  ports from 1024 through 65535.
		  In either case an asterisk (`*') character is not
		  allowed as a valid <varname>ip_port</varname>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>size_spec</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  A 64-bit unsigned integer, or the keywords
                  <userinput>unlimited</userinput> or
                  <userinput>default</userinput>.
                </para>
                <para>
                  Integers may take values
                  0 &lt;= value &lt;= 18446744073709551615, though
                  certain parameters may use a more limited range
                  within these extremes.  In most cases, setting a
                  value to 0 does not literally mean zero; it means
                  "undefined" or "as big as psosible", depending on
                  the context. See the expalantions of particular
                  parameters that use <varname>size_spec</varname>
                  for details on how they interpret its use. 
                </para>
                <para>
                  Numeric values can optionally be followed by a
                  scaling factor:
		  <userinput>K</userinput> or <userinput>k</userinput>
		  for kilobytes,
		  <userinput>M</userinput> or <userinput>m</userinput>
		  for megabytes, and
                  <userinput>G</userinput> or <userinput>g</userinput>
                  for gigabytes, which scale by 1024, 1024*1024, and
                  1024*1024*1024 respectively.
                </para>
		<para>
                  <varname>unlimited</varname> generally means
                  "as big as possible", though in certain contexts,
                  (including <option>max-cache-size</option>), it may
                  mean the largest possible 32-bit unsigned integer
                  (0xffffffff); this distinction can be important when
                  dealing with larger quantities. 
                  <varname>unlimited</varname> is usually the best way
                  to safely set a very large number.
                </para>
		<para>
                  <varname>default</varname> 
                  uses the limit that was in force when the server was started.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>yes_or_no</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  Either <userinput>yes</userinput> or <userinput>no</userinput>.
                  The words <userinput>true</userinput> and <userinput>false</userinput> are
                  also accepted, as are the numbers <userinput>1</userinput>
                  and <userinput>0</userinput>.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para>
                  <varname>dialup_option</varname>
                </para>
              </entry>
              <entry colname="2">
                <para>
                  One of <userinput>yes</userinput>,
                  <userinput>no</userinput>, <userinput>notify</userinput>,
                  <userinput>notify-passive</userinput>, <userinput>refresh</userinput> or
                  <userinput>passive</userinput>.
                  When used in a zone, <userinput>notify-passive</userinput>,
                  <userinput>refresh</userinput>, and <userinput>passive</userinput>
                  are restricted to slave and stub zones.
                </para>
              </entry>
            </row>
          </tbody>
        </tgroup>
      </informaltable>
      <sect2 id="address_match_lists">
        <title>Address Match Lists</title>
        <sect3>
          <title>Syntax</title>

<programlisting><varname>address_match_list</varname> = address_match_list_element ;
  <optional> address_match_list_element; ... </optional>
<varname>address_match_list_element</varname> = <optional> ! </optional> (ip_address <optional>/length</optional> |
   key key_id | acl_name | { address_match_list } )
</programlisting>

        </sect3>
        <sect3>
          <title>Definition and Usage</title>
          <para>
            Address match lists are primarily used to determine access
            control for various server operations. They are also used in
            the <command>listen-on</command> and <command>sortlist</command>
            statements. The elements which constitute an address match
            list can be any of the following:
          </para>
          <itemizedlist>
            <listitem>
              <simpara>an IP address (IPv4 or IPv6)</simpara>
            </listitem>
            <listitem>
              <simpara>an IP prefix (in `/' notation)</simpara>
            </listitem>
            <listitem>
              <simpara>
                a key ID, as defined by the <command>key</command>
                statement
              </simpara>
            </listitem>
            <listitem>
              <simpara>the name of an address match list defined with
                the <command>acl</command> statement
              </simpara>
            </listitem>
            <listitem>
              <simpara>a nested address match list enclosed in braces</simpara>
            </listitem>
          </itemizedlist>

          <para>
            Elements can be negated with a leading exclamation mark (`!'),
            and the match list names "any", "none", "localhost", and
            "localnets" are predefined. More information on those names
            can be found in the description of the acl statement.
          </para>

          <para>
            The addition of the key clause made the name of this syntactic
            element something of a misnomer, since security keys can be used
            to validate access without regard to a host or network address.
            Nonetheless, the term "address match list" is still used
            throughout the documentation.
          </para>

          <para>
            When a given IP address or prefix is compared to an address
            match list, the comparison takes place in approximately O(1)
            time.  However, key comparisons require that the list of keys
            be traversed until a matching key is found, and therefore may
            be somewhat slower.
          </para>

          <para>
            The interpretation of a match depends on whether the list is being
            used for access control, defining <command>listen-on</command> ports, or in a
            <command>sortlist</command>, and whether the element was negated.
          </para>

	  <para>
	    When used as an access control list, a non-negated match
	    allows access and a negated match denies access. If
	    there is no match, access is denied. The clauses
	    <command>allow-notify</command>,
	    <command>allow-recursion</command>,
	    <command>allow-recursion-on</command>,
	    <command>allow-query</command>,
	    <command>allow-query-on</command>,
	    <command>allow-query-cache</command>,
	    <command>allow-query-cache-on</command>,
	    <command>allow-transfer</command>,
	    <command>allow-update</command>,
	    <command>allow-update-forwarding</command>, and
	    <command>blackhole</command> all use address match
	    lists.  Similarly, the <command>listen-on</command> option will cause the
	    server to refuse queries on any of the machine's
	    addresses which do not match the list.
	  </para>

          <para>
            Order of insertion is significant.  If more than one element
            in an ACL is found to match a given IP address or prefix,
            preference will be given to the one that came
            <emphasis>first</emphasis> in the ACL definition.
            Because of this first-match behavior, an element that
            defines a subset of another element in the list should
            come before the broader element, regardless of whether
            either is negated. For example, in
            <command>1.2.3/24; ! 1.2.3.13;</command>
            the 1.2.3.13 element is completely useless because the
            algorithm will match any lookup for 1.2.3.13 to the 1.2.3/24
            element.  Using <command>! 1.2.3.13; 1.2.3/24</command> fixes
            that problem by having 1.2.3.13 blocked by the negation, but
            all other 1.2.3.* hosts fall through.
          </para>
        </sect3>
      </sect2>

      <sect2>
        <title>Comment Syntax</title>

        <para>
          The <acronym>BIND</acronym> 9 comment syntax allows for
          comments to appear
          anywhere that whitespace may appear in a <acronym>BIND</acronym> configuration
          file. To appeal to programmers of all kinds, they can be written
          in the C, C++, or shell/perl style.
        </para>

        <sect3>
          <title>Syntax</title>

          <para>
            <programlisting>/* This is a <acronym>BIND</acronym> comment as in C */</programlisting>
            <programlisting>// This is a <acronym>BIND</acronym> comment as in C++</programlisting>
            <programlisting># This is a <acronym>BIND</acronym> comment as in common UNIX shells
# and perl</programlisting>
          </para>
        </sect3>
        <sect3>
          <title>Definition and Usage</title>
          <para>
            Comments may appear anywhere that whitespace may appear in
            a <acronym>BIND</acronym> configuration file.
          </para>
          <para>
            C-style comments start with the two characters /* (slash,
            star) and end with */ (star, slash). Because they are completely
            delimited with these characters, they can be used to comment only
            a portion of a line or to span multiple lines.
          </para>
          <para>
            C-style comments cannot be nested. For example, the following
            is not valid because the entire comment ends with the first */:
          </para>
          <para>

<programlisting>/* This is the start of a comment.
   This is still part of the comment.
/* This is an incorrect attempt at nesting a comment. */
   This is no longer in any comment. */
</programlisting>

          </para>

          <para>
            C++-style comments start with the two characters // (slash,
            slash) and continue to the end of the physical line. They cannot
            be continued across multiple physical lines; to have one logical
            comment span multiple lines, each line must use the // pair.
            For example:
          </para>
          <para>

<programlisting>// This is the start of a comment.  The next line
// is a new comment, even though it is logically
// part of the previous comment.
</programlisting>

          </para>
          <para>
            Shell-style (or perl-style, if you prefer) comments start
            with the character <literal>#</literal> (number sign)
            and continue to the end of the
            physical line, as in C++ comments.
            For example:
          </para>

          <para>

<programlisting># This is the start of a comment.  The next line
# is a new comment, even though it is logically
# part of the previous comment.
</programlisting>

          </para>

          <warning>
            <para>
              You cannot use the semicolon (`;') character
              to start a comment such as you would in a zone file. The
              semicolon indicates the end of a configuration
              statement.
            </para>
          </warning>
        </sect3>
      </sect2>
    </sect1>

    <sect1 id="Configuration_File_Grammar">
      <title>Configuration File Grammar</title>

      <para>
        A <acronym>BIND</acronym> 9 configuration consists of
        statements and comments.
        Statements end with a semicolon. Statements and comments are the
        only elements that can appear without enclosing braces. Many
        statements contain a block of sub-statements, which are also
        terminated with a semicolon.
      </para>

      <para>
        The following statements are supported:
      </para>

      <informaltable colsep="0" rowsep="0">
        <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="2Level-table">
          <colspec colname="1" colnum="1" colsep="0" colwidth="1.336in"/>
          <colspec colname="2" colnum="2" colsep="0" colwidth="3.778in"/>
          <tbody>
            <row rowsep="0">
              <entry colname="1">
                <para><command>acl</command></para>
              </entry>
              <entry colname="2">
                <para>
                  defines a named IP address
                  matching list, for access control and other uses.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>controls</command></para>
              </entry>
              <entry colname="2">
                <para>
                  declares control channels to be used
                  by the <command>rndc</command> utility.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>include</command></para>
              </entry>
              <entry colname="2">
                <para>
                  includes a file.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>key</command></para>
              </entry>
              <entry colname="2">
                <para>
                  specifies key information for use in
                  authentication and authorization using TSIG.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>logging</command></para>
              </entry>
              <entry colname="2">
                <para>
                  specifies what the server logs, and where
                  the log messages are sent.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>lwres</command></para>
              </entry>
              <entry colname="2">
                <para>
                  configures <command>named</command> to
                  also act as a light-weight resolver daemon (<command>lwresd</command>).
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>masters</command></para>
              </entry>
              <entry colname="2">
                <para>
                  defines a named masters list for
                  inclusion in stub and slave zones'
                  <command>masters</command> or 
                  <command>also-notify</command> lists.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>options</command></para>
              </entry>
              <entry colname="2">
                <para>
                  controls global server configuration
                  options and sets defaults for other statements.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>server</command></para>
              </entry>
              <entry colname="2">
                <para>
                  sets certain configuration options on
                  a per-server basis.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>statistics-channels</command></para>
              </entry>
              <entry colname="2">
                <para>
		  declares communication channels to get access to
		  <command>named</command> statistics.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>trusted-keys</command></para>
              </entry>
              <entry colname="2">
                <para>
                  defines trusted DNSSEC keys.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>managed-keys</command></para>
              </entry>
              <entry colname="2">
                <para>
                  lists DNSSEC keys to be kept up to date
                  using RFC 5011 trust anchor maintenance.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>view</command></para>
              </entry>
              <entry colname="2">
                <para>
                  defines a view.
                </para>
              </entry>
            </row>
            <row rowsep="0">
              <entry colname="1">
                <para><command>zone</command></para>
              </entry>
              <entry colname="2">
                <para>
                  defines a zone.
                </para>
              </entry>
            </row>
          </tbody>
        </tgroup>
      </informaltable>

      <para>
        The <command>logging</command> and
        <command>options</command> statements may only occur once
        per
        configuration.
      </para>

      <sect2>
        <title><command>acl</command> Statement Grammar</title>

<programlisting><command>acl</command> acl-name {
    address_match_list
};
</programlisting>

      </sect2>
      <sect2 id="acl">
        <title><command>acl</command> Statement Definition and
          Usage</title>

        <para>
          The <command>acl</command> statement assigns a symbolic
          name to an address match list. It gets its name from a primary
          use of address match lists: Access Control Lists (ACLs).
        </para>

        <para>
          Note that an address match list's name must be defined
          with <command>acl</command> before it can be used
          elsewhere; no forward references are allowed.
        </para>

        <para>
          The following ACLs are built-in:
        </para>

        <informaltable colsep="0" rowsep="0">
          <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="3Level-table">
            <colspec colname="1" colnum="1" colsep="0" colwidth="1.130in"/>
            <colspec colname="2" colnum="2" colsep="0" colwidth="4.000in"/>
            <tbody>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>any</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Matches all hosts.
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>none</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Matches no hosts.
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>localhost</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Matches the IPv4 and IPv6 addresses of all network
                    interfaces on the system.
                  </para>
                </entry>
              </row>
              <row rowsep="0">
                <entry colname="1">
                  <para><command>localnets</command></para>
                </entry>
                <entry colname="2">
                  <para>
                    Matches any host on an IPv4 or IPv6 network
                    for which the system has an interface.
                    Some systems do not provide a way to determine the prefix
                    lengths of
                    local IPv6 addresses.
                    In such a case, <command>localnets</command>
                    only matches the local
                    IPv6 addresses, just like <command>localhost</command>.
                  </para>
                </entry>
              </row>
            </tbody>
          </tgroup>
        </informaltable>

      </sect2>
      <sect2>
        <title><command>controls</command> Statement Grammar</title>

<programlisting><command>controls</command> {
   [ inet ( ip_addr | * ) [ port ip_port ]
                allow { <replaceable> address_match_list </replaceable> }
                keys { <replaceable>key_list</replaceable> }; ]
   [ inet ...; ]
   [ unix <replaceable>path</replaceable> perm <replaceable>number</replaceable> owner <replaceable>number</replaceable> group <replaceable>number</replaceable>
     keys { <replaceable>key_list</replaceable> }; ]
   [ unix ...; ]
};
</programlisting>

      </sect2>

      <sect2 id="controls_statement_definition_and_usage">
        <title><command>controls</command> Statement Definition and
          Usage</title>

        <para>
          The <command>controls</command> statement declares control
          channels to be used by system administrators to control the
          operation of the name server. These control channels are
          used by the <command>rndc</command> utility to send
          commands to and retrieve non-DNS results from a name server.
        </para>

        <para>
          An <command>inet</command> control channel is a TCP socket
	  listening at the specified <command>ip_port</command> on the
	  specified <command>ip_addr</command>, which can be an IPv4 or IPv6
	  address.  An <command>ip_addr</command> of <literal>*</literal> (asterisk) is
	  interpreted as the IPv4 wildcard address; connections will be
	  accepted on any of the system's IPv4 addresses.
	  To listen on the IPv6 wildcard address,
          use an <command>ip_addr</command> of <literal>::</literal>.
          If you will only use <command>rndc</command> on the local host,
          using the loopback address (<literal>127.0.0.1</literal>
          or <literal>::1</literal>) is recommended for maximum security.
        </para>

        <para>
          If no port is specified, port 953 is used. The asterisk
	  "<literal>*</literal>" cannot be used for <command>ip_port</command>.
        </para>

        <para>
          The ability to issue commands over the control channel is
          restricted by the <command>allow</command> and
          <command>keys</command> clauses.
	  Connections to the control channel are permitted based on the
          <command>address_match_list</command>.  This is for simple
          IP address based filtering only; any <command>key_id</command>
          elements of the <command>address_match_list</command>
          are ignored.
        </para>

	<para>
	  A <command>unix</command> control channel is a UNIX domain
	  socket listening at the specified path in the file system.
	  Access to the socket is specified by the <command>perm</command>,
	  <command>owner</command> and <command>group</command> clauses.
	  Note on some platforms (SunOS and Solaris) the permissions
	  (<command>perm</command>) are applied to the parent directory
	  as the permissions on the socket itself are ignored.
	</para>

        <para>
          The primary authorization mechanism of the command
          channel is the <command>key_list</command>, which
          contains a list of <command>key_id</command>s.
          Each <command>key_id</command> in the <command>key_list</command>
	  is authorized to execute commands over the control channel.
          See <xref linkend="rndc"/> in <xref linkend="admin_tools"/>)
	  for information about configuring keys in <command>rndc</command>.
        </para>

        <para>
          If no <command>controls</command> statement is present,
          <command>named</command> will set up a default
          control channel listening on the loopback address 127.0.0.1
          and its IPv6 counterpart ::1.
          In this case, and also when the <command>controls</command> statement
          is present but does not have a <command>keys</command> clause,
          <command>named</command> will attempt to load the command channel key
          from the file <filename>rndc.key</filename> in
          <filename>/etc</filename> (or whatever <varname>sysconfdir</varname>
          was specified as when <acronym>BIND</acronym> was built).
          To create a <filename>rndc.key</filename> file, run
          <userinput>rndc-confgen -a</userinput>.
        </para>

        <para>
          The <filename>rndc.key</filename> feature was created to
          ease the transition of systems from <acronym>BIND</acronym> 8,
          which did not have digital signatures on its command channel
          messages and thus did not have a <command>keys</command> clause.

          It makes it possible to use an existing <acronym>BIND</acronym> 8
          configuration file in <acronym>BIND</acronym> 9 unchanged,
          and still have <command>rndc</command> work the same way
          <command>ndc</command> worked in BIND 8, simply by executing the
          command <userinput>rndc-confgen -a</userinput> after BIND 9 is
          installed.
        </para>

        <para>
          Since the <filename>rndc.key</filename> feature
          is only intended to allow the backward-compatible usage of
          <acronym>BIND</acronym> 8 configuration files, this
          feature does not
          have a high degree of configurability.  You cannot easily change
          the key name or the size of the secret, so you should make a
          <filename>rndc.conf</filename> with your own key if you
          wish to change
          those things.  The <filename>rndc.key</filename> file
          also has its
          permissions set such that only the owner of the file (the user that
          <command>named</command> is running as) can access it.
          If you
          desire greater flexibility in allowing other users to access
          <command>rndc</command> commands, then you need to create
          a
          <filename>rndc.conf</filename> file and make it group
          readable by a group
          that contains the users who should have access.
        </para>

        <para>
          To disable the command channel, use an empty
	  <command>controls</command> statement:
	  <command>controls { };</command>.
        </para>

      </sect2>
      <sect2>
        <title><command>include</command> Statement Grammar</title>
        <programlisting><command>include</command> <replaceable>filename</replaceable>;</programlisting>
      </sect2>
      <sect2>
        <title><command>include</command> Statement Definition and
          Usage</title>

        <para>
          The <command>include</command> statement inserts the
          specified file at the point where the <command>include</command>
          statement is encountered. The <command>include</command>
                statement facilitates the administration of configuration
          files
          by permitting the reading or writing of some things but not
          others. For example, the statement could include private keys
          that are readable only by the name server.
        </para>

      </sect2>
      <sect2>
        <title><command>key</command> Statement Grammar</title>

<programlisting><command>key</command> <replaceable>key_id</replaceable> {
    algorithm <replaceable>string</replaceable>;
    secret <replaceable>string</replaceable>;
};
</programlisting>

      </sect2>

      <sect2>
        <title><command>key</command> Statement Definition and Usage</title>

        <para>
          The <command>key</command> statement defines a shared
          secret key for use with TSIG (see <xref linkend="tsig"/>)
          or the command channel
          (see <xref linkend="controls_statement_definition_and_usage"/>).
        </para>

        <para>
          The <command>key</command> statement can occur at the
          top level
          of the configuration file or inside a <command>view</command>
          statement.  Keys defined in top-level <command>key</command>
          statements can be used in all views.  Keys intended for use in
          a <command>controls</command> statement
          (see <xref linkend="controls_statement_definition_and_usage"/>)
          must be defined at the top level.
        </para>

        <para>
          The <replaceable>key_id</replaceable>, also known as the
          key name, is a domain name uniquely identifying the key. It can
          be used in a <command>server</command>
          statement to cause requests sent to that
          server to be signed with this key, or in address match lists to
          verify that incoming requests have been signed with a key
          matching this name, algorithm, and secret.
        </para>

	<para>
	  The <replaceable>algorithm_id</replaceable> is a string
	  that specifies a security/authentication algorithm.  Named
	  supports <literal>hmac-md5</literal>,
	  <literal>hmac-sha1</literal>, <literal>hmac-sha224</literal>,
	  <literal>hmac-sha256</literal>, <literal>hmac-sha384</literal>
	  and <literal>hmac-sha512</literal> TSIG authentication.
	  Truncated hashes are supported by appending the minimum
	  number of required bits preceded by a dash, e.g.
	  <literal>hmac-sha1-80</literal>.  The
	  <replaceable>secret_string</replaceable> is the secret
	  to be used by the algorithm, and is treated as a base-64
	  encoded string.
	</para>

      </sect2>
      <sect2>
        <title><command>logging</command> Statement Grammar</title>

<programlisting><command>logging</command> {
   [ <command>channel</command> <replaceable>channel_name</replaceable> {
     ( <command>file</command> <replaceable>path_name</replaceable>
         [ <command>versions</command> ( <replaceable>number</replaceable> | <command>unlimited</command> ) ]
         [ <command>size</command> <replaceable>size_spec</replaceable> ]
       | <command>syslog</command> <replaceable>syslog_facility</replaceable>
       | <command>stderr</command>
       | <command>null</command> );
     [ <command>severity</command> (<option>critical</option> | <option>error</option> | <option>warning</option> | <option>notice</option> |
                 <option>info</option> | <option>debug</option> [ <replaceable>level</replaceable> ] | <option>dynamic</option> ); ]
     [ <command>print-category</command> <option>yes</option> or <option>no</option>; ]
     [ <command>print-severity</command> <option>yes</option> or <option>no</option>; ]
     [ <command>print-time</command> <option>yes</option> or <option>no</option>; ]
   }; ]
   [ <command>category</command> <replaceable>category_name</replaceable> {
     <replaceable>channel_name</replaceable> ; [ <replaceable>channel_name</replaceable> ; ... ]
   }; ]
   ...
};
</programlisting>

      </sect2>

      <sect2>
        <title><command>logging</command> Statement Definition and
          Usage</title>

        <para>
          The <command>logging</command> statement configures a
          wide
          variety of logging options for the name server. Its <command>channel</command> phrase
          associates output methods, format options and severity levels with
          a name that can then be used with the <command>category</command> phrase
          to select how various classes of messages are logged.
        </para>
        <para>
          Only one <command>logging</command> statement is used to
          define
          as many channels and categories as are wanted. If there is no <command>logging</command> statement,
          the logging configuration will be:
        </para>

<programlisting>logging {
     category default { default_syslog; default_debug; };
     category unmatched { null; };
};
</programlisting>

        <para>
          In <acronym>BIND</acronym> 9, the logging configuration
          is only established when
          the entire configuration file has been parsed.  In <acronym>BIND</acronym> 8, it was
          established as soon as the <command>logging</command>
          statement
          was parsed. When the server is starting up, all logging messages
          regarding syntax errors in the configuration file go to the default
          channels, or to standard error if the "<option>-g</option>" option
          was specified.
        </para>

        <sect3>
          <title>The <command>channel</command> Phrase</title>

          <para>
            All log output goes to one or more <emphasis>channels</emphasis>;
            you can make as many of them as you want.
          </para>

          <para>
            Every channel definition must include a destination clause that
            says whether messages selected for the channel go to a file, to a
            particular syslog facility, to the standard error stream, or are
            discarded. It can optionally also limit the message severity level
            that will be accepted by the channel (the default is
            <command>info</command>), and whether to include a
            <command>named</command>-generated time stamp, the
            category name
            and/or severity level (the default is not to include any).
          </para>

          <para>
            The <command>null</command> destination clause
            causes all messages sent to the channel to be discarded;
            in that case, other options for the channel are meaningless.
          </para>

          <para>
            The <command>file</command> destination clause directs
            the channel
            to a disk file.  It can include limitations
            both on how large the file is allowed to become, and how many
            versions
            of the file will be saved each time the file is opened.
          </para>

          <para>
            If you use the <command>versions</command> log file
            option, then
            <command>named</command> will retain that many backup
            versions of the file by
            renaming them when opening.  For example, if you choose to keep
            three old versions
            of the file <filename>lamers.log</filename>, then just
            before it is opened
            <filename>lamers.log.1</filename> is renamed to
            <filename>lamers.log.2</filename>, <filename>lamers.log.0</filename> is renamed
            to <filename>lamers.log.1</filename>, and <filename>lamers.log</filename> is
            renamed to <filename>lamers.log.0</filename>.
            You can say <command>versions unlimited</command> to
            not limit
            the number of versions.
            If a <command>size</command> option is associated with
            the log file,
            then renaming is only done when the file being opened exceeds the
            indicated size.  No backup versions are kept by default; any
            existing
            log file is simply appended.
          </para>

          <para>
            The <command>size</command> option for files is used
            to limit log
            growth. If the file ever exceeds the size, then <command>named</command> will
            stop writing to the file unless it has a <command>versions</command> option
            associated with it.  If backup versions are kept, the files are
            rolled as
            described above and a new one begun.  If there is no
            <command>versions</command> option, no more data will
            be written to the log
            until some out-of-band mechanism removes or truncates the log to
            less than the
            maximum size.  The default behavior is not to limit the size of
            the
            file.
          </para>

          <para>
            Example usage of the <command>size</command> and
            <command>versions</command> options:
          </para>

<programlisting>channel an_example_channel {
    file "example.log" versions 3 size 20m;
    print-time yes;
    print-category yes;
};
</programlisting>

          <para>
            The <command>syslog</command> destination clause
            directs the
            channel to the system log.  Its argument is a
            syslog facility as described in the <command>syslog</command> man
            page. Known facilities are <command>kern</command>, <command>user</command>,
            <command>mail</command>, <command>daemon</command>, <command>auth</command>,
            <command>syslog</command>, <command>lpr</command>, <command>news</command>,
            <command>uucp</command>, <command>cron</command>, <command>authpriv</command>,
            <command>ftp</command>, <command>local0</command>, <command>local1</command>,
            <command>local2</command>, <command>local3</command>, <command>local4</command>,
            <command>local5</command>, <command>local6</command> and
            <command>local7</command>, however not all facilities
            are supported on
            all operating systems.
            How <command>syslog</command> will handle messages
            sent to
            this facility is described in the <command>syslog.conf</command> man
            page. If you have a system which uses a very old version of <command>syslog</command> that
            only uses two arguments to the <command>openlog()</command> function,
            then this clause is silently ignored.
          </para>
          <para>
            The <command>severity</command> clause works like <command>syslog</command>'s
            "priorities", except that they can also be used if you are writing
            straight to a file rather than using <command>syslog</command>.
            Messages which are not at least of the severity level given will
            not be selected for the channel; messages of higher severity
            levels
            will be accepted.
          </para>
          <para>
            If you are using <command>syslog</command>, then the <command>syslog.conf</command> priorities
            will also determine what eventually passes through. For example,
            defining a channel facility and severity as <command>daemon</command> and <command>debug</command> but
            only logging <command>daemon.warning</command> via <command>syslog.conf</command> will
            cause messages of severity <command>info</command> and
            <command>notice</command> to
            be dropped. If the situation were reversed, with <command>named</command> writing
            messages of only <command>warning</command> or higher,
            then <command>syslogd</command> would
            print all messages it received from the channel.
          </para>

          <para>
            The <command>stderr</command> destination clause
            directs the
            channel to the server's standard error stream.  This is intended
            for
            use when the server is running as a foreground process, for
            example
            when debugging a configuration.
          </para>

          <para>
            The server can supply extensive debugging information when
            it is in debugging mode. If the server's global debug level is
            greater
            than zero, then debugging mode will be active. The global debug
            level is set either by starting the <command>named</command> server
            with the <option>-d</option> flag followed by a positive integer,
            or by running <command>rndc trace</command>.
            The global debug level
            can be set to zero, and debugging mode turned off, by running <command>rndc
notrace</command>. All debugging messages in the server have a debug
            level, and higher debug levels give more detailed output. Channels
            that specify a specific debug severity, for example:
          </para>

<programlisting>channel specific_debug_level {
    file "foo";
    severity debug 3;
};
</programlisting>

          <para>
            will get debugging output of level 3 or less any time the
            server is in debugging mode, regardless of the global debugging
            level. Channels with <command>dynamic</command>
            severity use the
            server's global debug level to determine what messages to print.
          </para>
          <para>
            If <command>print-time</command> has been turned on,
            then
            the date and time will be logged. <command>print-time</command> may
            be specified for a <command>syslog</command> channel,
            but is usually
            pointless since <command>syslog</command> also logs
            the date and
            time. If <command>print-category</command> is
            requested, then the
            category of the message will be logged as well. Finally, if <command>print-severity</command> is
            on, then the severity level of the message will be logged. The <command>print-</command> options may
            be used in any combination, and will always be printed in the
            following
            order: time, category, severity. Here is an example where all
            three <command>print-</command> options
            are on:
          </para>

          <para>
            <computeroutput>28-Feb-2000 15:05:32.863 general: notice: running</computeroutput>
          </para>

          <para>
            There are four predefined channels that are used for
            <command>named</command>'s default logging as follows.
            How they are
            used is described in <xref linkend="the_category_phrase"/>.
          </para>

<programlisting>channel default_syslog {
    // send to syslog's daemon facility
    syslog daemon;
    // only send priority info and higher
    severity info;

channel default_debug {
    // write to named.run in the working directory
    // Note: stderr is used instead of "named.run" if
    // the server is started with the '-f' option.
    file "named.run";
    // log at the server's current debug level
    severity dynamic;
};

channel default_stderr {
    // writes to stderr
    stderr;
    // only send priority info and higher
    severity info;
};

channel null {
   // toss anything sent to this channel
   null;
};
</programlisting>

          <para>
            The <command>default_debug</command> channel has the
            special
            property that it only produces output when the server's debug
            level is
            nonzero.  It normally writes to a file called <filename>named.run</filename>
            in the server's working directory.
          </para>

          <para>
            For security reasons, when the "<option>-u</option>"
            command line option is used, the <filename>named.run</filename> file
            is created only after <command>named</command> has
            changed to the
            new UID, and any debug output generated while <command>named</command> is
            starting up and still running as root is discarded.  If you need
            to capture this output, you must run the server with the "<option>-g</option>"
            option and redirect standard error to a file.
          </para>

          <para>
            Once a channel is defined, it cannot be redefined. Thus you
            cannot alter the built-in channels directly, but you can modify
            the default logging by pointing categories at channels you have
            defined.
          </para>
        </sect3>

        <sect3 id="the_category_phrase">
          <title>The <command>category</command> Phrase</title>

          <para>
            There are many categories, so you can send the logs you want
            to see wherever you want, without seeing logs you don't want. If
            you don't specify a list of channels for a category, then log
            messages
            in that category will be sent to the <command>default</command> category
            instead. If you don't specify a default category, the following
            "default default" is used:
          </para>

<programlisting>category default { default_syslog; default_debug; };
</programlisting>

          <para>
            As an example, let's say you want to log security events to
            a file, but you also want keep the default logging behavior. You'd
            specify the following:
          </para>

<programlisting>channel my_security_channel {
    file "my_security_file";
    severity info;
};
category security {
    my_security_channel;
    default_syslog;
    default_debug;
};</programlisting>

          <para>
            To discard all messages in a category, specify the <command>null</command> channel:
          </para>

<programlisting>category xfer-out { null; };
category notify { null; };
</programlisting>

          <para>
            Following are the available categories and brief descriptions
            of the types of log information they contain. More
            categories may be added in future <acronym>BIND</acronym> releases.
          </para>
          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="3.350in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>default</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      The default category defines the logging
                      options for those categories where no specific
                      configuration has been
                      defined.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>general</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      The catch-all. Many things still aren't
                      classified into categories, and they all end up here.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>database</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Messages relating to the databases used
                      internally by the name server to store zone and cache
                      data.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>security</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Approval and denial of requests.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>config</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Configuration file parsing and processing.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>resolver</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      DNS resolution, such as the recursive
                      lookups performed on behalf of clients by a caching name
                      server.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>xfer-in</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Zone transfers the server is receiving.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>xfer-out</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Zone transfers the server is sending.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>notify</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      The NOTIFY protocol.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>client</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Processing of client requests.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>unmatched</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Messages that <command>named</command> was unable to determine the
                      class of or for which there was no matching <command>view</command>.
                      A one line summary is also logged to the <command>client</command> category.
                      This category is best sent to a file or stderr, by
                      default it is sent to
                      the <command>null</command> channel.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>network</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Network operations.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>update</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Dynamic updates.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>update-security</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Approval and denial of update requests.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>queries</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Specify where queries should be logged to.
                    </para>
                    <para>
                      At startup, specifying the category <command>queries</command> will also
                      enable query logging unless <command>querylog</command> option has been
                      specified.
                    </para>

		    <para>
		      The query log entry reports the client's IP
		      address and port number, and the query name,
		      class and type.  Next it reports whether the
		      Recursion Desired flag was set (+ if set, -
		      if not set), if the query was signed (S),
		      EDNS was in use (E), if TCP was used (T), if
		      DO (DNSSEC Ok) was set (D), or if CD (Checking
		      Disabled) was set (C).  After this the
		      destination address the query was sent to is
		      reported.
		    </para>

                    <para>
                      <computeroutput>client 127.0.0.1#62536 (www.example.com): query: www.example.com IN AAAA +SE</computeroutput>
                    </para>
                    <para>
                      <computeroutput>client ::1#62537 (www.example.net): query: www.example.net IN AAAA -SE</computeroutput>
                    </para>
		    <para>
                      (The first part of this log message, showing the
                      client address/port number and query name, is
                      repeated in all subsequent log messages related
                      to the same query.)
		    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>query-errors</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Information about queries that resulted in some
                      failure.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>dispatch</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Dispatching of incoming packets to the
                      server modules where they are to be processed.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>dnssec</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      DNSSEC and TSIG protocol processing.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>lame-servers</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Lame servers.  These are misconfigurations
                      in remote servers, discovered by BIND 9 when trying to
                      query those servers during resolution.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>delegation-only</command></para>
                  </entry>
		  <entry colname="2">
		    <para>
		      Delegation only.  Logs queries that have been
		      forced to NXDOMAIN as the result of a
		      delegation-only zone or a
		      <command>delegation-only</command> in a hint
		      or stub zone declaration.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>edns-disabled</command></para>
                  </entry>
		  <entry colname="2">
		    <para>
		      Log queries that have been forced to use plain
		      DNS due to timeouts.  This is often due to
		      the remote servers not being RFC 1034 compliant
		      (not always returning FORMERR or similar to
		      EDNS queries and other extensions to the DNS
		      when they are not understood).  In other words, this is
		      targeted at servers that fail to respond to
		      DNS queries that they don't understand.
		    </para>
		    <para>
		      Note: the log message can also be due to
		      packet loss.  Before reporting servers for
		      non-RFC 1034 compliance they should be re-tested
		      to determine the nature of the non-compliance.
		      This testing should prevent or reduce the
		      number of false-positive reports.
		    </para>
		    <para>
		      Note: eventually <command>named</command> will have to stop
		      treating such timeouts as due to RFC 1034 non
		      compliance and start treating it as plain
		      packet loss.  Falsely classifying packet
		      loss as due to RFC 1034 non compliance impacts
		      on DNSSEC validation which requires EDNS for
		      the DNSSEC records to be returned.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>RPZ</command></para>
                  </entry>
		  <entry colname="2">
		    <para>
		      Information about errors in response policy zone files,
		      rewritten responses, and at the highest
		      <command>debug</command> levels, mere rewriting
		      attempts.
		    </para>
		  </entry>
		</row>
	      </tbody>
	    </tgroup>
	  </informaltable>
	</sect3>
	<sect3>
	  <title>The <command>query-errors</command> Category</title>
	  <para>
	    The <command>query-errors</command> category is
	    specifically intended for debugging purposes: To identify
	    why and how specific queries result in responses which
	    indicate an error.
	    Messages of this category are therefore only logged
	    with <command>debug</command> levels.
	  </para>

	  <para>
	    At the debug levels of 1 or higher, each response with the
	    rcode of SERVFAIL is logged as follows:
	  </para>
	  <para>
	    <computeroutput>client 127.0.0.1#61502: query failed (SERVFAIL) for www.example.com/IN/AAAA at query.c:3880</computeroutput>
	  </para>
	  <para>
	    This means an error resulting in SERVFAIL was
	    detected at line 3880 of source file
	    <filename>query.c</filename>.
	    Log messages of this level will particularly
	    help identify the cause of SERVFAIL for an
	    authoritative server.
	  </para>
	  <para>
	    At the debug levels of 2 or higher, detailed context
	    information of recursive resolutions that resulted in
	    SERVFAIL is logged.
	    The log message will look like as follows:
	  </para>
	  <para>
<!-- NOTE: newlines and some spaces added so this would fit on page -->
            <programlisting>
fetch completed at resolver.c:2970 for www.example.com/A
in 30.000183: timed out/success [domain:example.com,
referral:2,restart:7,qrysent:8,timeout:5,lame:0,neterr:0,
badresp:1,adberr:0,findfail:0,valfail:0]
            </programlisting>
	  </para>
	  <para>
	    The first part before the colon shows that a recursive
	    resolution for AAAA records of www.example.com completed
	    in 30.000183 seconds and the final result that led to the
	    SERVFAIL was determined at line 2970 of source file
	    <filename>resolver.c</filename>.
	  </para>
	  <para>
	    The following part shows the detected final result and the
	    latest result of DNSSEC validation.
	    The latter is always success when no validation attempt
	    is made.
	    In this example, this query resulted in SERVFAIL probably
	    because all name servers are down or unreachable, leading
	    to a timeout in 30 seconds.
	    DNSSEC validation was probably not attempted.
	  </para>
	  <para>
	    The last part enclosed in square brackets shows statistics
	    information collected for this particular resolution
	    attempt.
	    The <varname>domain</varname> field shows the deepest zone
	    that the resolver reached;
	    it is the zone where the error was finally detected.
	    The meaning of the other fields is summarized in the
	    following table.
	  </para>

          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="3.350in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>referral</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of referrals the resolver received
		      throughout the resolution process.
		      In the above example this is 2, which are most
		      likely com and example.com.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>restart</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of cycles that the resolver tried
		      remote servers at the <varname>domain</varname>
		      zone.
		      In each cycle the resolver sends one query
		      (possibly resending it, depending on the response)
		      to each known name server of
		      the <varname>domain</varname> zone.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>qrysent</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of queries the resolver sent at the
		      <varname>domain</varname> zone.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>timeout</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of timeouts since the resolver
		      received the last response.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>lame</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of lame servers the resolver detected
		      at the <varname>domain</varname> zone.
		      A server is detected to be lame either by an
		      invalid response or as a result of lookup in
		      BIND9's address database (ADB), where lame
		      servers are cached.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>neterr</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of erroneous results that the
		      resolver encountered in sending queries
		      at the <varname>domain</varname> zone.
		      One common case is the remote server is
		      unreachable and the resolver receives an ICMP
		      unreachable error message.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>badresp</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      The number of unexpected responses (other than
		      <varname>lame</varname>) to queries sent by the
		      resolver at the <varname>domain</varname> zone.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>adberr</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Failures in finding remote server addresses
		      of the <varname>domain</varname> zone in the ADB.
		      One common case of this is that the remote
		      server's name does not have any address records.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>findfail</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Failures of resolving remote server addresses.
		      This is a total number of failures throughout
		      the resolution process.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><varname>valfail</varname></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Failures of DNSSEC validation.
		      Validation failures are counted throughout
		      the resolution process (not limited to
		      the <varname>domain</varname> zone), but should
		      only happen in <varname>domain</varname>.
		    </para>
		  </entry>
		</row>
	      </tbody>
	    </tgroup>
	  </informaltable>
	  <para>
	    At the debug levels of 3 or higher, the same messages
	    as those at the debug 1 level are logged for other errors
	    than SERVFAIL.
	    Note that negative responses such as NXDOMAIN are not
	    regarded as errors here.
	  </para>
	  <para>
	    At the debug levels of 4 or higher, the same messages
	    as those at the debug 2 level are logged for other errors
	    than SERVFAIL.
	    Unlike the above case of level 3, messages are logged for
	    negative responses.
	    This is because any unexpected results can be difficult to
	    debug in the recursion case.
	  </para>
	</sect3>
      </sect2>

      <sect2>
        <title><command>lwres</command> Statement Grammar</title>

        <para>
           This is the grammar of the <command>lwres</command>
          statement in the <filename>named.conf</filename> file:
        </para>

<programlisting><command>lwres</command> {
    <optional> listen-on { <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ;
                <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> view <replaceable>view_name</replaceable>; </optional>
    <optional> search { <replaceable>domain_name</replaceable> ; <optional> <replaceable>domain_name</replaceable> ; ... </optional> }; </optional>
    <optional> ndots <replaceable>number</replaceable>; </optional>
};
</programlisting>

      </sect2>
      <sect2>
        <title><command>lwres</command> Statement Definition and Usage</title>

        <para>
          The <command>lwres</command> statement configures the
          name
          server to also act as a lightweight resolver server. (See
          <xref linkend="lwresd"/>.)  There may be multiple
          <command>lwres</command> statements configuring
          lightweight resolver servers with different properties.
        </para>

        <para>
          The <command>listen-on</command> statement specifies a
          list of
          addresses (and ports) that this instance of a lightweight resolver
          daemon
          should accept requests on.  If no port is specified, port 921 is
          used.
          If this statement is omitted, requests will be accepted on
          127.0.0.1,
          port 921.
        </para>

        <para>
          The <command>view</command> statement binds this
          instance of a
          lightweight resolver daemon to a view in the DNS namespace, so that
          the
          response will be constructed in the same manner as a normal DNS
          query
          matching this view.  If this statement is omitted, the default view
          is
          used, and if there is no default view, an error is triggered.
        </para>

        <para>
          The <command>search</command> statement is equivalent to
          the
          <command>search</command> statement in
          <filename>/etc/resolv.conf</filename>.  It provides a
          list of domains
          which are appended to relative names in queries.
        </para>

        <para>
          The <command>ndots</command> statement is equivalent to
          the
          <command>ndots</command> statement in
          <filename>/etc/resolv.conf</filename>.  It indicates the
          minimum
          number of dots in a relative domain name that should result in an
          exact match lookup before search path elements are appended.
        </para>
      </sect2>
      <sect2>
        <title><command>masters</command> Statement Grammar</title>

<programlisting>
<command>masters</command> <replaceable>name</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> { ( <replaceable>masters_list</replaceable> | 
      <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> <optional>key <replaceable>key</replaceable></optional> ) ; <optional>...</optional> };
</programlisting>

      </sect2>

      <sect2>
        <title><command>masters</command> Statement Definition and
          Usage</title>
        <para><command>masters</command>
	  lists allow for a common set of masters to be easily used by
          multiple stub and slave zones in their <command>masters</command>
          or <command>also-notify</command> lists.
        </para>
      </sect2>

      <sect2>
        <title><command>options</command> Statement Grammar</title>

        <para>
          This is the grammar of the <command>options</command>
          statement in the <filename>named.conf</filename> file:
        </para>

<programlisting><command>options</command> {
    <optional> attach-cache <replaceable>cache_name</replaceable>; </optional>
    <optional> version <replaceable>version_string</replaceable>; </optional>
    <optional> hostname <replaceable>hostname_string</replaceable>; </optional>
    <optional> server-id <replaceable>server_id_string</replaceable>; </optional>
    <optional> directory <replaceable>path_name</replaceable>; </optional>
    <optional> key-directory <replaceable>path_name</replaceable>; </optional>
    <optional> managed-keys-directory <replaceable>path_name</replaceable>; </optional>
    <optional> named-xfer <replaceable>path_name</replaceable>; </optional>
    <optional> tkey-gssapi-keytab <replaceable>path_name</replaceable>; </optional>
    <optional> tkey-gssapi-credential <replaceable>principal</replaceable>; </optional>
    <optional> tkey-domain <replaceable>domainname</replaceable>; </optional>
    <optional> tkey-dhkey <replaceable>key_name</replaceable> <replaceable>key_tag</replaceable>; </optional>
    <optional> cache-file <replaceable>path_name</replaceable>; </optional>
    <optional> dump-file <replaceable>path_name</replaceable>; </optional>
    <optional> bindkeys-file <replaceable>path_name</replaceable>; </optional>
    <optional> secroots-file <replaceable>path_name</replaceable>; </optional>
    <optional> session-keyfile <replaceable>path_name</replaceable>; </optional>
    <optional> session-keyname <replaceable>key_name</replaceable>; </optional>
    <optional> session-keyalg <replaceable>algorithm_id</replaceable>; </optional>
    <optional> memstatistics <replaceable>yes_or_no</replaceable>; </optional>
    <optional> memstatistics-file <replaceable>path_name</replaceable>; </optional>
    <optional> pid-file <replaceable>path_name</replaceable>; </optional>
    <optional> recursing-file <replaceable>path_name</replaceable>; </optional>
    <optional> statistics-file <replaceable>path_name</replaceable>; </optional>
    <optional> zone-statistics <replaceable>full</replaceable> | <replaceable>terse</replaceable> | <replaceable>none</replaceable>; </optional>
    <optional> auth-nxdomain <replaceable>yes_or_no</replaceable>; </optional>
    <optional> deallocate-on-exit <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dialup <replaceable>dialup_option</replaceable>; </optional>
    <optional> fake-iquery <replaceable>yes_or_no</replaceable>; </optional>
    <optional> fetch-glue <replaceable>yes_or_no</replaceable>; </optional>
    <optional> flush-zones-on-shutdown <replaceable>yes_or_no</replaceable>; </optional>
    <optional> has-old-clients <replaceable>yes_or_no</replaceable>; </optional>
    <optional> host-statistics <replaceable>yes_or_no</replaceable>; </optional>
    <optional> host-statistics-max <replaceable>number</replaceable>; </optional>
    <optional> minimal-responses <replaceable>yes_or_no</replaceable>; </optional>
    <optional> multiple-cnames <replaceable>yes_or_no</replaceable>; </optional>
    <optional> notify <replaceable>yes_or_no</replaceable> | <replaceable>explicit</replaceable> | <replaceable>master-only</replaceable>; </optional>
    <optional> recursion <replaceable>yes_or_no</replaceable>; </optional>
    <optional> request-nsid <replaceable>yes_or_no</replaceable>; </optional>
    <optional> rfc2308-type1 <replaceable>yes_or_no</replaceable>; </optional>
    <optional> use-id-pool <replaceable>yes_or_no</replaceable>; </optional>
    <optional> maintain-ixfr-base <replaceable>yes_or_no</replaceable>; </optional>
    <optional> ixfr-from-differences (<replaceable>yes_or_no</replaceable> | <constant>master</constant> | <constant>slave</constant>); </optional>
    <optional> dnssec-enable <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-validation (<replaceable>yes_or_no</replaceable> | <constant>auto</constant>); </optional>
    <optional> dnssec-lookaside ( <replaceable>auto</replaceable> |
			<replaceable>no</replaceable> |
                        <replaceable>domain</replaceable> trust-anchor <replaceable>domain</replaceable> ); </optional>
    <optional> dnssec-must-be-secure <replaceable>domain yes_or_no</replaceable>; </optional>
    <optional> dnssec-accept-expired <replaceable>yes_or_no</replaceable>; </optional>
    <optional> forward ( <replaceable>only</replaceable> | <replaceable>first</replaceable> ); </optional>
    <optional> forwarders { <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> dual-stack-servers <optional>port <replaceable>ip_port</replaceable></optional> {
        ( <replaceable>domain_name</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> |
          <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ) ; 
        ... }; </optional>
    <optional> check-names ( <replaceable>master</replaceable> | <replaceable>slave</replaceable> | <replaceable>response</replaceable> )
        ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-dup-records ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-mx ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-wildcard <replaceable>yes_or_no</replaceable>; </optional>
    <optional> check-integrity <replaceable>yes_or_no</replaceable>; </optional>
    <optional> check-mx-cname ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-srv-cname ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-sibling <replaceable>yes_or_no</replaceable>; </optional>
    <optional> check-spf ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> allow-new-zones { <replaceable>yes_or_no</replaceable> }; </optional>
    <optional> allow-notify { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-cache { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-cache-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-transfer { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-recursion { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-recursion-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-update { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-update-forwarding { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> update-check-ksk <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-update-mode ( <replaceable>maintain</replaceable> | <replaceable>no-resign</replaceable> ); </optional>
    <optional> dnssec-dnskey-kskonly <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-loadkeys-interval <replaceable>number</replaceable>; </optional>
    <optional> dnssec-secure-to-insecure <replaceable>yes_or_no</replaceable> ;</optional>
    <optional> try-tcp-refresh <replaceable>yes_or_no</replaceable>; </optional>
    <optional> allow-v6-synthesis { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> blackhole { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> use-v4-udp-ports { <replaceable>port_list</replaceable> }; </optional>
    <optional> avoid-v4-udp-ports { <replaceable>port_list</replaceable> }; </optional>
    <optional> use-v6-udp-ports { <replaceable>port_list</replaceable> }; </optional>
    <optional> avoid-v6-udp-ports { <replaceable>port_list</replaceable> }; </optional>
    <optional> listen-on <optional> port <replaceable>ip_port</replaceable> </optional> { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> listen-on-v6 <optional> port <replaceable>ip_port</replaceable> </optional> { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> query-source ( ( <replaceable>ip4_addr</replaceable> | <replaceable>*</replaceable> )
        <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional> |
        <optional> address ( <replaceable>ip4_addr</replaceable> | <replaceable>*</replaceable> ) </optional>
        <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional> ) ; </optional>
    <optional> query-source-v6 ( ( <replaceable>ip6_addr</replaceable> | <replaceable>*</replaceable> )
        <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional> | 
        <optional> address ( <replaceable>ip6_addr</replaceable> | <replaceable>*</replaceable> ) </optional> 
        <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional> ) ; </optional>
    <optional> use-queryport-pool <replaceable>yes_or_no</replaceable>; </optional>
    <optional> queryport-pool-ports <replaceable>number</replaceable>; </optional>
    <optional> queryport-pool-updateinterval <replaceable>number</replaceable>; </optional>
    <optional> max-transfer-time-in <replaceable>number</replaceable>; </optional>
    <optional> max-transfer-time-out <replaceable>number</replaceable>; </optional>
    <optional> max-transfer-idle-in <replaceable>number</replaceable>; </optional>
    <optional> max-transfer-idle-out <replaceable>number</replaceable>; </optional>
    <optional> tcp-clients <replaceable>number</replaceable>; </optional>
    <optional> reserved-sockets <replaceable>number</replaceable>; </optional>
    <optional> recursive-clients <replaceable>number</replaceable>; </optional>
    <optional> serial-query-rate <replaceable>number</replaceable>; </optional>
    <optional> serial-queries <replaceable>number</replaceable>; </optional>
    <optional> tcp-listen-queue <replaceable>number</replaceable>; </optional>
    <optional> transfer-format <replaceable>( one-answer | many-answers )</replaceable>; </optional>
    <optional> transfers-in  <replaceable>number</replaceable>; </optional>
    <optional> transfers-out <replaceable>number</replaceable>; </optional>
    <optional> transfers-per-ns <replaceable>number</replaceable>; </optional>
    <optional> transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>)
                             <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> use-alt-transfer-source <replaceable>yes_or_no</replaceable>; </optional>
    <optional> notify-delay <replaceable>seconds</replaceable> ; </optional>
    <optional> notify-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-to-soa <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> also-notify { <replaceable>ip_addr</replaceable>
                    <optional>port <replaceable>ip_port</replaceable></optional> <optional>key <replaceable>keyname</replaceable></optional> ;
                    <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> <optional>key <replaceable>keyname</replaceable></optional> ; ... </optional> }; </optional>
    <optional> max-ixfr-log-size <replaceable>number</replaceable>; </optional>
    <optional> max-journal-size <replaceable>size_spec</replaceable>; </optional>
    <optional> coresize <replaceable>size_spec</replaceable> ; </optional>
    <optional> datasize <replaceable>size_spec</replaceable> ; </optional>
    <optional> files <replaceable>size_spec</replaceable> ; </optional>
    <optional> stacksize <replaceable>size_spec</replaceable> ; </optional>
    <optional> cleaning-interval <replaceable>number</replaceable>; </optional>
    <optional> heartbeat-interval <replaceable>number</replaceable>; </optional>
    <optional> interface-interval <replaceable>number</replaceable>; </optional>
    <optional> statistics-interval <replaceable>number</replaceable>; </optional>
    <optional> topology { <replaceable>address_match_list</replaceable> }</optional>;
    <optional> sortlist { <replaceable>address_match_list</replaceable> }</optional>;
    <optional> rrset-order { <replaceable>order_spec</replaceable> ; <optional> <replaceable>order_spec</replaceable> ; ... </optional> </optional> };
    <optional> lame-ttl <replaceable>number</replaceable>; </optional>
    <optional> max-ncache-ttl <replaceable>number</replaceable>; </optional>
    <optional> max-cache-ttl <replaceable>number</replaceable>; </optional>
    <optional> sig-validity-interval <replaceable>number</replaceable> <optional><replaceable>number</replaceable></optional> ; </optional>
    <optional> sig-signing-nodes <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-signatures <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-type <replaceable>number</replaceable> ; </optional>
    <optional> min-roots <replaceable>number</replaceable>; </optional>
    <optional> use-ixfr <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> provide-ixfr <replaceable>yes_or_no</replaceable>; </optional>
    <optional> request-ixfr <replaceable>yes_or_no</replaceable>; </optional>
    <optional> treat-cr-as-space <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> min-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> max-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> min-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> max-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> port <replaceable>ip_port</replaceable>; </optional>
    <optional> additional-from-auth <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> additional-from-cache <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> random-device <replaceable>path_name</replaceable> ; </optional>
    <optional> max-cache-size <replaceable>size_spec</replaceable> ; </optional>
    <optional> match-mapped-addresses <replaceable>yes_or_no</replaceable>; </optional>
    <optional> filter-aaaa-on-v4 ( <replaceable>yes_or_no</replaceable> | <replaceable>break-dnssec</replaceable> ); </optional>
    <optional> filter-aaaa { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> dns64 <replaceable>IPv6-prefix</replaceable> {
	<optional> clients { <replaceable>address_match_list</replaceable> }; </optional>
	<optional> mapped { <replaceable>address_match_list</replaceable> }; </optional>
        <optional> exclude { <replaceable>address_match_list</replaceable> }; </optional>
	<optional> suffix IPv6-address; </optional>
	<optional> recursive-only <replaceable>yes_or_no</replaceable>; </optional>
	<optional> break-dnssec <replaceable>yes_or_no</replaceable>; </optional>
    }; </optional>;
    <optional> dns64-server <replaceable>name</replaceable> </optional>
    <optional> dns64-contact <replaceable>name</replaceable> </optional>
    <optional> preferred-glue ( <replaceable>A</replaceable> | <replaceable>AAAA</replaceable> | <replaceable>NONE</replaceable> ); </optional>
    <optional> edns-udp-size <replaceable>number</replaceable>; </optional>
    <optional> max-udp-size <replaceable>number</replaceable>; </optional>
    <optional> max-rsa-exponent-size <replaceable>number</replaceable>; </optional>
    <optional> root-delegation-only <optional> exclude { <replaceable>namelist</replaceable> } </optional> ; </optional>
    <optional> querylog <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> disable-algorithms <replaceable>domain</replaceable> { <replaceable>algorithm</replaceable>;
                                <optional> <replaceable>algorithm</replaceable>; </optional> }; </optional>
    <optional> acache-enable <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> acache-cleaning-interval <replaceable>number</replaceable>; </optional>
    <optional> max-acache-size <replaceable>size_spec</replaceable> ; </optional>
    <optional> clients-per-query <replaceable>number</replaceable> ; </optional>
    <optional> max-clients-per-query <replaceable>number</replaceable> ; </optional>
    <optional> masterfile-format (<constant>text</constant>|<constant>raw</constant>) ; </optional>
    <optional> empty-server <replaceable>name</replaceable> ; </optional>
    <optional> empty-contact <replaceable>name</replaceable> ; </optional>
    <optional> empty-zones-enable <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> disable-empty-zone <replaceable>zone_name</replaceable> ; </optional>
    <optional> zero-no-soa-ttl <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> zero-no-soa-ttl-cache <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> resolver-query-timeout <replaceable>number</replaceable> ; </optional>
    <optional> deny-answer-addresses { <replaceable>address_match_list</replaceable> } <optional> except-from { <replaceable>namelist</replaceable> } </optional>;</optional>
    <optional> deny-answer-aliases { <replaceable>namelist</replaceable> } <optional> except-from { <replaceable>namelist</replaceable> } </optional>;</optional>
    <optional> response-policy { <replaceable>zone_name</replaceable>
	<optional> policy given | disabled | passthru | nxdomain | nodata | cname <replaceable>domain</replaceable> </optional>
	<optional> recursive-only <replaceable>yes_or_no</replaceable> </optional> <optional> max-policy-ttl <replaceable>number</replaceable> </optional> ;
    } <optional> recursive-only <replaceable>yes_or_no</replaceable> </optional> <optional> max-policy-ttl <replaceable>number</replaceable> </optional>
	<optional> break-dnssec <replaceable>yes_or_no</replaceable> </optional> <optional> min-ns-dots <replaceable>number</replaceable> </optional> ; </optional>
};
</programlisting>

      </sect2>

      <sect2 id="options">
        <title><command>options</command> Statement Definition and
          Usage</title>

        <para>
          The <command>options</command> statement sets up global
          options
          to be used by <acronym>BIND</acronym>. This statement
          may appear only
          once in a configuration file. If there is no <command>options</command>
          statement, an options block with each option set to its default will
          be used.
        </para>

        <variablelist>

            <varlistentry>
              <term><command>attach-cache</command></term>
              <listitem>
                <para>
		  Allows multiple views to share a single cache
		  database.
		  Each view has its own cache database by default, but
		  if multiple views have the same operational policy
		  for name resolution and caching, those views can
		  share a single cache to save memory and possibly
		  improve resolution efficiency by using this option.
                </para>

                <para>
                  The <command>attach-cache</command> option
                  may also be specified in <command>view</command>
                  statements, in which case it overrides the
                  global <command>attach-cache</command> option.
                </para>

		<para>
		  The <replaceable>cache_name</replaceable> specifies
		  the cache to be shared.
		  When the <command>named</command> server configures
		  views which are supposed to share a cache, it
		  creates a cache with the specified name for the
		  first view of these sharing views.
		  The rest of the views will simply refer to the
		  already created cache.
		</para>

		<para>
		  One common configuration to share a cache would be to
		  allow all views to share a single cache.
		  This can be done by specifying
		  the <command>attach-cache</command> as a global
		  option with an arbitrary name.
		</para>

		<para>
		  Another possible operation is to allow a subset of
		  all views to share a cache while the others to
		  retain their own caches.
		  For example, if there are three views A, B, and C,
		  and only A and B should share a cache, specify the
		  <command>attach-cache</command> option as a view A (or
		  B)'s option, referring to the other view name:
		</para>

<programlisting>
  view "A" {
    // this view has its own cache
    ...
  };
  view "B" {
    // this view refers to A's cache
    attach-cache "A";
  };
  view "C" {
    // this view has its own cache
    ...
  };
</programlisting>

		<para>
		  Views that share a cache must have the same policy
		  on configurable parameters that may affect caching.
		  The current implementation requires the following
		  configurable options be consistent among these
		  views:
		  <command>check-names</command>,
		  <command>cleaning-interval</command>,
		  <command>dnssec-accept-expired</command>,
		  <command>dnssec-validation</command>,
		  <command>max-cache-ttl</command>,
		  <command>max-ncache-ttl</command>,
		  <command>max-cache-size</command>, and
		  <command>zero-no-soa-ttl</command>.
		</para>

		<para>
		  Note that there may be other parameters that may
		  cause confusion if they are inconsistent for
		  different views that share a single cache.
		  For example, if these views define different sets of
		  forwarders that can return different answers for the
		  same question, sharing the answer does not make
		  sense or could even be harmful.
		  It is administrator's responsibility to ensure
		  configuration differences in different views do
		  not cause disruption with a shared cache.
		</para>
              </listitem>

            </varlistentry>

          <varlistentry>
            <term><command>directory</command></term>
            <listitem>
              <para>
                The working directory of the server.
                Any non-absolute pathnames in the configuration file will be
                taken
                as relative to this directory. The default location for most
                server
                output files (e.g. <filename>named.run</filename>)
                is this directory.
                If a directory is not specified, the working directory
                defaults to `<filename>.</filename>', the directory from
                which the server
                was started. The directory specified should be an absolute
                path.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>key-directory</command></term>
            <listitem>
              <para>
                When performing dynamic update of secure zones, the
                directory where the public and private DNSSEC key files
                should be found, if different than the current working
                directory.  (Note that this option has no effect on the
                paths for files containing non-DNSSEC keys such as
                <filename>bind.keys</filename>,
                <filename>rndc.key</filename> or
                <filename>session.key</filename>.)
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>managed-keys-directory</command></term>
            <listitem>
              <para>
                Specifies the directory in which to store the files that
                track managed DNSSEC keys.  By default, this is the working
                directory.
              </para>
              <para>
                If <command>named</command> is not configured to use views,
                then managed keys for the server will be tracked in a single
                file called <filename>managed-keys.bind</filename>.
                Otherwise, managed keys will be tracked in separate files,
                one file per view; each file name will be the SHA256 hash
                of the view name, followed by the extension
                <filename>.mkeys</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>named-xfer</command></term>
	    <listitem>
	      <para>
		<emphasis>This option is obsolete.</emphasis> It
		was used in <acronym>BIND</acronym> 8 to specify
		the pathname to the <command>named-xfer</command>
		program.  In <acronym>BIND</acronym> 9, no separate
		<command>named-xfer</command> program is needed;
		its functionality is built into the name server.
	      </para>
	    </listitem>
	  </varlistentry>

	  <varlistentry>
	    <term><command>tkey-gssapi-keytab</command></term>
	    <listitem>
	      <para>
		The KRB5 keytab file to use for GSS-TSIG updates. If
		this option is set and tkey-gssapi-credential is not
		set, then updates will be allowed with any key
		matching a principal in the specified keytab.
	      </para>
	    </listitem>
	  </varlistentry>

	  <varlistentry>
	    <term><command>tkey-gssapi-credential</command></term>
	    <listitem>
	      <para>
		The security credential with which the server should
		authenticate keys requested by the GSS-TSIG protocol.
		Currently only Kerberos 5 authentication is available
		and the credential is a Kerberos principal which the
		server can acquire through the default system key
		file, normally <filename>/etc/krb5.keytab</filename>.
		The location keytab file can be overridden using the
		tkey-gssapi-keytab option. Normally this principal is
		of the form "<userinput>DNS/</userinput><varname>server.domain</varname>".
		To use GSS-TSIG, <command>tkey-domain</command> must
		also be set if a specific keytab is not set with
		tkey-gssapi-keytab.
	      </para>
	    </listitem>
	  </varlistentry>

          <varlistentry>
            <term><command>tkey-domain</command></term>
	    <listitem>
	      <para>
		The domain appended to the names of all shared keys
		generated with <command>TKEY</command>.  When a
		client requests a <command>TKEY</command> exchange,
		it may or may not specify the desired name for the
		key. If present, the name of the shared key will
		be <varname>client specified part</varname> +
		<varname>tkey-domain</varname>.  Otherwise, the
		name of the shared key will be <varname>random hex
		digits</varname> + <varname>tkey-domain</varname>.
		In most cases, the <command>domainname</command>
		should be the server's domain name, or an otherwise
		non-existent subdomain like
		"_tkey.<varname>domainname</varname>".  If you are
		using GSS-TSIG, this variable must be defined, unless
		you specify a specific keytab using tkey-gssapi-keytab.
	      </para>
	    </listitem>
	  </varlistentry>

          <varlistentry>
            <term><command>tkey-dhkey</command></term>
            <listitem>
              <para>
                The Diffie-Hellman key used by the server
                to generate shared keys with clients using the Diffie-Hellman
                mode
                of <command>TKEY</command>. The server must be
                able to load the
                public and private keys from files in the working directory.
                In
                most cases, the keyname should be the server's host name.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>cache-file</command></term>
            <listitem>
              <para>
		This is for testing only.  Do not use.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>dump-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server dumps
                the database to when instructed to do so with
                <command>rndc dumpdb</command>.
                If not specified, the default is <filename>named_dump.db</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>memstatistics-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server writes memory
                usage statistics to on exit. If not specified,
                the default is <filename>named.memstats</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>pid-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server writes its process ID
                in. If not specified, the default is
		<filename>/var/run/named/named.pid</filename>.
                The PID file is used by programs that want to send signals to
                the running
                name server. Specifying <command>pid-file none</command> disables the
                use of a PID file &mdash; no file will be written and any
                existing one will be removed.  Note that <command>none</command>
                is a keyword, not a filename, and therefore is not enclosed
                in
                double quotes.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>recursing-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server dumps
                the queries that are currently recursing when instructed
                to do so with <command>rndc recursing</command>.
                If not specified, the default is <filename>named.recursing</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>statistics-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server appends statistics
                to when instructed to do so using <command>rndc stats</command>.
                If not specified, the default is <filename>named.stats</filename> in the
                server's current directory.  The format of the file is
                described
                in <xref linkend="statsfile"/>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>bindkeys-file</command></term>
            <listitem>
              <para>
                The pathname of a file to override the built-in trusted
		keys provided by <command>named</command>.
		See the discussion of <command>dnssec-lookaside</command>
                and <command>dnssec-validation</command> for details. 
                If not specified, the default is
		<filename>/etc/bind.keys</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>secroots-file</command></term>
            <listitem>
              <para>
                The pathname of the file the server dumps
                security roots to when instructed to do so with
                <command>rndc secroots</command>.
                If not specified, the default is
		<filename>named.secroots</filename>.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>session-keyfile</command></term>
            <listitem>
              <para>
                The pathname of the file into which to write a TSIG
                session key generated by <command>named</command> for use by
                <command>nsupdate -l</command>.  If not specified, the
                default is <filename>/var/run/named/session.key</filename>.
                (See <xref linkend="dynamic_update_policies"/>, and in
                particular the discussion of the
                <command>update-policy</command> statement's
                <userinput>local</userinput> option for more
                information about this feature.)
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>session-keyname</command></term>
            <listitem>
              <para>
                The key name to use for the TSIG session key.
                If not specified, the default is "local-ddns".
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>session-keyalg</command></term>
            <listitem>
              <para>
                The algorithm to use for the TSIG session key.
                Valid values are hmac-sha1, hmac-sha224, hmac-sha256,
                hmac-sha384, hmac-sha512 and hmac-md5.  If not
                specified, the default is hmac-sha256.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>port</command></term>
            <listitem>
              <para>
                The UDP/TCP port number the server uses for
                receiving and sending DNS protocol traffic.
                The default is 53.  This option is mainly intended for server
                testing;
                a server using a port other than 53 will not be able to
                communicate with
                the global DNS.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>random-device</command></term>
            <listitem>
              <para>
                The source of entropy to be used by the server.  Entropy is
                primarily needed
                for DNSSEC operations, such as TKEY transactions and dynamic
                update of signed
                zones.  This options specifies the device (or file) from which
                to read
                entropy.  If this is a file, operations requiring entropy will
                fail when the
                file has been exhausted.  If not specified, the default value
                is
                <filename>/dev/random</filename>
                (or equivalent) when present, and none otherwise.  The
                <command>random-device</command> option takes
                effect during
                the initial configuration load at server startup time and
                is ignored on subsequent reloads.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>preferred-glue</command></term>
            <listitem>
              <para>
                If specified, the listed type (A or AAAA) will be emitted
                before other glue
                in the additional section of a query response.
                The default is not to prefer any type (NONE).
              </para>
            </listitem>
          </varlistentry>

          <varlistentry id="root_delegation_only">
            <term><command>root-delegation-only</command></term>
            <listitem>
              <para>
                Turn on enforcement of delegation-only in TLDs
		(top level domains) and root zones with an optional
		exclude list.
              </para>
	      <para>
		DS queries are expected to be made to and be answered by
		delegation only zones.  Such queries and responses are
		treated as an exception to delegation-only processing
		and are not converted to NXDOMAIN responses provided
		a CNAME is not discovered at the query name.
	      </para>
	      <para>
		If a delegation only zone server also serves a child
		zone it is not always possible to determine whether
		an answer comes from the delegation only zone or the
		child zone.  SOA NS and DNSKEY records are apex
		only records and a matching response that contains
		these records or DS is treated as coming from a
		child zone.  RRSIG records are also examined to see
		if they are signed by a child zone or not.  The
		authority section is also examined to see if there
		is evidence that the answer is from the child zone.
		Answers that are determined to be from a child zone
		are not converted to NXDOMAIN responses.  Despite
		all these checks there is still a possibility of
		false negatives when a child zone is being served.
	      </para>
	      <para>
		Similarly false positives can arise from empty nodes
		(no records at the name) in the delegation only zone
		when the query type is not ANY.
	      </para>
              <para>
                Note some TLDs are not delegation only (e.g. "DE", "LV",
		"US" and "MUSEUM").  This list is not exhaustive.
              </para>

<programlisting>
options {
	root-delegation-only exclude { "de"; "lv"; "us"; "museum"; };
};
</programlisting>

            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>disable-algorithms</command></term>
            <listitem>
              <para>
                Disable the specified DNSSEC algorithms at and below the
                specified name.
                Multiple <command>disable-algorithms</command>
                statements are allowed.
                Only the most specific will be applied.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>dnssec-lookaside</command></term>
            <listitem>
              <para>
		When set, <command>dnssec-lookaside</command> provides the
		validator with an alternate method to validate DNSKEY
		records at the top of a zone.  When a DNSKEY is at or
		below a domain specified by the deepest
		<command>dnssec-lookaside</command>, and the normal DNSSEC
		validation has left the key untrusted, the trust-anchor
		will be appended to the key name and a DLV record will be
		looked up to see if it can validate the key.  If the DLV
		record validates a DNSKEY (similarly to the way a DS
                record does) the DNSKEY RRset is deemed to be trusted.
	      </para>
	      <para>
		If <command>dnssec-lookaside</command> is set to
		<userinput>auto</userinput>, then built-in default
		values for the DLV domain and trust anchor will be
		used, along with a built-in key for validation.
	      </para>
	      <para>
		If <command>dnssec-lookaside</command> is set to
		<userinput>no</userinput>, then dnssec-lookaside
		is not used.
	      </para>
              <para>
                The default DLV key is stored in the file
                <filename>bind.keys</filename>;
                <command>named</command> will load that key at
                startup if <command>dnssec-lookaside</command> is set to
                <constant>auto</constant>.  A copy of the file is
                installed along with <acronym>BIND</acronym> 9, and is
                current as of the release date.  If the DLV key expires, a
                new copy of <filename>bind.keys</filename> can be downloaded
                from <ulink url="https://www.isc.org/solutions/dlv/"
		>https://www.isc.org/solutions/dlv/</ulink>.
              </para>
              <para>
                (To prevent problems if <filename>bind.keys</filename> is
                not found, the current key is also compiled in to
                <command>named</command>.  Relying on this is not
                recommended, however, as it requires <command>named</command>
                to be recompiled with a new key when the DLV key expires.)
              </para>
              <para>
                NOTE: <command>named</command> only loads certain specific
                keys from <filename>bind.keys</filename>:  those for the
                DLV zone and for the DNS root zone.  The file cannot be
                used to store keys for other zones.
              </para>
            </listitem>
          </varlistentry>

          <varlistentry>
            <term><command>dnssec-must-be-secure</command></term>
            <listitem>
              <para>
                Specify hierarchies which must be or may not be secure
                (signed and validated).  If <userinput>yes</userinput>,
                then <command>named</command> will only accept answers if
                they are secure.  If <userinput>no</userinput>, then normal
                DNSSEC validation applies allowing for insecure answers to
                be accepted.  The specified domain must be under a
                <command>trusted-keys</command> or
                <command>managed-keys</command> statement, or
                <command>dnssec-lookaside</command> must be active.
              </para>
            </listitem>
          </varlistentry>

	  <varlistentry>
	    <term><command>dns64</command></term>
            <listitem>
	      <para>
		This directive instructs <command>named</command> to
		return mapped IPv4 addresses to AAAA queries when
		there are no AAAA records.  It is intended to be
		used in conjunction with a NAT64.  Each
		<command>dns64</command> defines one DNS64 prefix.
		Multiple DNS64 prefixes can be defined.
	      </para>
	      <para>
		Compatible IPv6 prefixes have lengths of 32, 40, 48, 56,
		64 and 96 as per RFC 6052.
	      </para>
	      <para>
		Additionally a reverse IP6.ARPA zone will be created for
		the prefix to provide a mapping from the IP6.ARPA names
		to the corresponding IN-ADDR.ARPA names using synthesized
		CNAMEs.  <command>dns64-server</command> and
		<command>dns64-contact</command> can be used to specify
		the name of the server and contact for the zones. These
		are settable at the view / options level.  These are
		not settable on a per-prefix basis.
	      </para>
	      <para>
		Each <command>dns64</command> supports an optional
		<command>clients</command> ACL that determines which
                clients are affected by this directive.  If not defined,
                it defaults to <userinput>any;</userinput>.
	      </para>
	      <para>
		Each <command>dns64</command> supports an optional
		<command>mapped</command> ACL that selects which
		IPv4 addresses are to be mapped in the corresponding	
		A RRset.  If not defined it defaults to
		<userinput>any;</userinput>.
	      </para>
	      <para>
		Normally, DNS64 won't apply to a domain name that
		owns one or more AAAA records; these records will
		simply be returned.  The optional
		<command>exclude</command> ACL allows specification
		of a list of IPv6 addresses that will be ignored
		if they appear in a domain name's AAAA records, and
		DNS64 will be applied to any A records the domain
		name owns.  If not defined, <command>exclude</command>
		defaults to none.
	      </para>
	      <para>
		A optional <command>suffix</command> can also
		be defined to set the bits trailing the mapped
		IPv4 address bits.  By default these bits are
		set to <userinput>::</userinput>.  The bits
		matching the prefix and mapped IPv4 address
		must be zero.
	      </para>
	      <para>
		If <command>recursive-only</command> is set to
		<command>yes</command> the DNS64 synthesis will
		only happen for recursive queries.  The default
		is <command>no</command>.
	      </para>
	      <para>
		If <command>break-dnssec</command> is set to
		<command>yes</command> the DNS64 synthesis will
		happen even if the result, if validated, would
		cause a DNSSEC validation failure.  If this option
		is set to <command>no</command> (the default), the DO
		is set on the incoming query, and there are RRSIGs on
		the applicable records, then synthesis will not happen.
	      </para>
<programlisting>
	acl rfc1918 { 10/8; 192.168/16; 172.16/12; };

        dns64 64:FF9B::/96 {
                clients { any; };
                mapped { !rfc1918; any; };
                exclude { 64:FF9B::/96; ::ffff:0000:0000/96; };
                suffix ::;
        };
</programlisting>
            </listitem>
	  </varlistentry>

	  <varlistentry>
	    <term><command>dnssec-update-mode</command></term>
	    <listitem>
	        <para>
                  If this option is set to its default value of
                  <literal>maintain</literal> in a zone of type
                  <literal>master</literal> which is DNSSEC-signed
                  and configured to allow dynamic updates (see
                  <xref linkend="dynamic_update_policies"/>), and
                  if <command>named</command> has access to the
                  private signing key(s) for the zone, then
                  <command>named</command> will automatically sign all new
                  or changed records and maintain signatures for the zone
                  by regenerating RRSIG records whenever they approach
                  their expiration date.
		</para>
		<para>
                  If the option is changed to <literal>no-resign</literal>,
                  then <command>named</command> will sign all new or
                  changed records, but scheduled maintenance of
                  signatures is disabled.
                </para>
                <para>
                  With either of these settings, <command>named</command>
                  will reject updates to a DNSSEC-signed zone when the
                  signing keys are inactive or unavailable to
                  <command>named</command>.  (A planned third option,
                  <literal>external</literal>, will disable all automatic
                  signing and allow DNSSEC data to be submitted into a zone
                  via dyanmic update; this is not yet implemented.)
		</para>
	    </listitem>
	  </varlistentry>

          <varlistentry>
            <term><command>zone-statistics</command></term>
            <listitem>
              <para>
                If <userinput>full</userinput>, the server will collect
                statistical data on all zones (unless specifically
                turned off on a per-zone basis by specifying
                <command>zone-statistics terse</command> or
                <command>zone-statistics none</command>
                in the <command>zone</command> statement).
                The default is <userinput>terse</userinput>, providing
                minimal statistics on zones (including name and
                current serial number, but not query type
                counters).
              </para>
              <para>
                These statistics may be accessed via the
                <command>statistics-channel</command> or
                using <command>rndc stats</command>, which
                will dump them to the file listed
                in the <command>statistics-file</command>.  See
                also <xref linkend="statsfile"/>.
              </para>
              <para>
                For backward compatibility with earlier versions
                of BIND 9, the <command>zone-statistics</command>
                option can also accept <userinput>yes</userinput>
                or <userinput>no</userinput>, which have the same
                effect as <userinput>full</userinput> and
                <userinput>terse</userinput>, respectively.
              </para>
            </listitem>
          </varlistentry>
        </variablelist>

        <sect3 id="boolean_options">
          <title>Boolean Options</title>

          <variablelist>

            <varlistentry>
              <term><command>allow-new-zones</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then zones can be
                  added at runtime via <command>rndc addzone</command>
                  or deleted via <command>rndc delzone</command>.
                  The default is <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>auth-nxdomain</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then the <command>AA</command> bit
                  is always set on NXDOMAIN responses, even if the server is
                  not actually
                  authoritative. The default is <userinput>no</userinput>;
                  this is
                  a change from <acronym>BIND</acronym> 8. If you
                  are using very old DNS software, you
                  may need to set it to <userinput>yes</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>deallocate-on-exit</command></term>
              <listitem>
                <para>
                  This option was used in <acronym>BIND</acronym>
                  8 to enable checking
                  for memory leaks on exit. <acronym>BIND</acronym> 9 ignores the option and always performs
                  the checks.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>memstatistics</command></term>
              <listitem>
                <para>
		  Write memory statistics to the file specified by
		  <command>memstatistics-file</command> at exit.
		  The default is <userinput>no</userinput> unless
		  '-m record' is specified on the command line in
		  which case it is <userinput>yes</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>dialup</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then the
                  server treats all zones as if they are doing zone transfers
                  across
                  a dial-on-demand dialup link, which can be brought up by
                  traffic
                  originating from this server. This has different effects
                  according
                  to zone type and concentrates the zone maintenance so that
                  it all
                  happens in a short interval, once every <command>heartbeat-interval</command> and
                  hopefully during the one call. It also suppresses some of
                  the normal
                  zone maintenance traffic. The default is <userinput>no</userinput>.
                </para>
                <para>
                  The <command>dialup</command> option
                  may also be specified in the <command>view</command> and
                  <command>zone</command> statements,
                  in which case it overrides the global <command>dialup</command>
                  option.
                </para>
                <para>
                  If the zone is a master zone, then the server will send out a
                  NOTIFY
                  request to all the slaves (default). This should trigger the
                  zone serial
                  number check in the slave (providing it supports NOTIFY)
                  allowing the slave
                  to verify the zone while the connection is active.
                  The set of servers to which NOTIFY is sent can be controlled
                  by
                  <command>notify</command> and <command>also-notify</command>.
                </para>
                <para>
                  If the
                  zone is a slave or stub zone, then the server will suppress
                  the regular
                  "zone up to date" (refresh) queries and only perform them
                  when the
                  <command>heartbeat-interval</command> expires in
                  addition to sending
                  NOTIFY requests.
                </para>
                <para>
                  Finer control can be achieved by using
                  <userinput>notify</userinput> which only sends NOTIFY
                  messages,
                  <userinput>notify-passive</userinput> which sends NOTIFY
                  messages and
                  suppresses the normal refresh queries, <userinput>refresh</userinput>
                  which suppresses normal refresh processing and sends refresh
                  queries
                  when the <command>heartbeat-interval</command>
                  expires, and
                  <userinput>passive</userinput> which just disables normal
                  refresh
                  processing.
                </para>

                <informaltable colsep="0" rowsep="0">
                  <tgroup cols="4" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                    <colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
                    <colspec colname="2" colnum="2" colsep="0" colwidth="1.150in"/>
                    <colspec colname="3" colnum="3" colsep="0" colwidth="1.150in"/>
                    <colspec colname="4" colnum="4" colsep="0" colwidth="1.150in"/>
                    <tbody>
                      <row rowsep="0">
                        <entry colname="1">
                          <para>
                            dialup mode
                          </para>
                        </entry>
                        <entry colname="2">
                          <para>
                            normal refresh
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            heart-beat refresh
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            heart-beat notify
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>no</command> (default)</para>
                        </entry>
                        <entry colname="2">
                          <para>
                            yes
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            no
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>yes</command></para>
                        </entry>
                        <entry colname="2">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            yes
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            yes
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>notify</command></para>
                        </entry>
                        <entry colname="2">
                          <para>
                            yes
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            yes
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>refresh</command></para>
                        </entry>
                        <entry colname="2">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            yes
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            no
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>passive</command></para>
                        </entry>
                        <entry colname="2">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            no
                          </para>
                        </entry>
                      </row>
                      <row rowsep="0">
                        <entry colname="1">
                          <para><command>notify-passive</command></para>
                        </entry>
                        <entry colname="2">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="3">
                          <para>
                            no
                          </para>
                        </entry>
                        <entry colname="4">
                          <para>
                            yes
                          </para>
                        </entry>
                      </row>
                    </tbody>
                  </tgroup>
                </informaltable>

                <para>
                  Note that normal NOTIFY processing is not affected by
                  <command>dialup</command>.
                </para>

              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>fake-iquery</command></term>
              <listitem>
                <para>
                  In <acronym>BIND</acronym> 8, this option
                  enabled simulating the obsolete DNS query type
                  IQUERY. <acronym>BIND</acronym> 9 never does
                  IQUERY simulation.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>fetch-glue</command></term>
              <listitem>
                <para>
                  This option is obsolete.
                  In BIND 8, <userinput>fetch-glue yes</userinput>
                  caused the server to attempt to fetch glue resource records
                  it
                  didn't have when constructing the additional
                  data section of a response.  This is now considered a bad
                  idea
                  and BIND 9 never does it.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>flush-zones-on-shutdown</command></term>
              <listitem>
                <para>
                  When the nameserver exits due receiving SIGTERM,
                  flush or do not flush any pending zone writes.  The default
                  is
                  <command>flush-zones-on-shutdown</command> <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>has-old-clients</command></term>
              <listitem>
                <para>
                  This option was incorrectly implemented
                  in <acronym>BIND</acronym> 8, and is ignored by <acronym>BIND</acronym> 9.
                  To achieve the intended effect
                  of
                  <command>has-old-clients</command> <userinput>yes</userinput>, specify
                  the two separate options <command>auth-nxdomain</command> <userinput>yes</userinput>
                  and <command>rfc2308-type1</command> <userinput>no</userinput> instead.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>host-statistics</command></term>
              <listitem>
                <para>
                  In BIND 8, this enables keeping of
                  statistics for every host that the name server interacts
                  with.
                  Not implemented in BIND 9.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>maintain-ixfr-base</command></term>
              <listitem>
                <para>
                  <emphasis>This option is obsolete</emphasis>.
                  It was used in <acronym>BIND</acronym> 8 to
                  determine whether a transaction log was
                  kept for Incremental Zone Transfer. <acronym>BIND</acronym> 9 maintains a transaction
                  log whenever possible.  If you need to disable outgoing
                  incremental zone
                  transfers, use <command>provide-ixfr</command> <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>minimal-responses</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then when generating
                  responses the server will only add records to the authority
                  and additional data sections when they are required (e.g.
                  delegations, negative responses).  This may improve the
		  performance of the server.
                  The default is <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>multiple-cnames</command></term>
              <listitem>
                <para>
                  This option was used in <acronym>BIND</acronym> 8 to allow
                  a domain name to have multiple CNAME records in violation of
                  the DNS standards.  <acronym>BIND</acronym> 9.2 onwards
                  always strictly enforces the CNAME rules both in master
		  files and dynamic updates.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>notify</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput> (the default),
                  DNS NOTIFY messages are sent when a zone the server is
                  authoritative for
                  changes, see <xref linkend="notify"/>.  The messages are
                  sent to the
                  servers listed in the zone's NS records (except the master
                  server identified
                  in the SOA MNAME field), and to any servers listed in the
                  <command>also-notify</command> option.
                </para>
                <para>
                  If <userinput>master-only</userinput>, notifies are only
                  sent
                  for master zones.
                  If <userinput>explicit</userinput>, notifies are sent only
                  to
                  servers explicitly listed using <command>also-notify</command>.
                  If <userinput>no</userinput>, no notifies are sent.
                </para>
                <para>
                  The <command>notify</command> option may also be
                  specified in the <command>zone</command>
                  statement,
                  in which case it overrides the <command>options notify</command> statement.
                  It would only be necessary to turn off this option if it
                  caused slaves
                  to crash.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>notify-to-soa</command></term>
              <listitem>
                <para>
		  If <userinput>yes</userinput> do not check the nameservers
		  in the NS RRset against the SOA MNAME.  Normally a NOTIFY
		  message is not sent to the SOA MNAME (SOA ORIGIN) as it is
		  supposed to contain the name of the ultimate master.
		  Sometimes, however, a slave is listed as the SOA MNAME in
		  hidden master configurations and in that case you would
		  want the ultimate master to still send NOTIFY messages to
		  all the nameservers listed in the NS RRset.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>recursion</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, and a
                  DNS query requests recursion, then the server will attempt
                  to do
                  all the work required to answer the query. If recursion is
                  off
                  and the server does not already know the answer, it will
                  return a
                  referral response. The default is
                  <userinput>yes</userinput>.
                  Note that setting <command>recursion no</command> does not prevent
                  clients from getting data from the server's cache; it only
                  prevents new data from being cached as an effect of client
                  queries.
                  Caching may still occur as an effect the server's internal
                  operation, such as NOTIFY address lookups.
                  See also <command>fetch-glue</command> above.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>request-nsid</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then an empty EDNS(0)
                  NSID (Name Server Identifier) option is sent with all 
                  queries to authoritative name servers during iterative
                  resolution. If the authoritative server returns an NSID
                  option in its response, then its contents are logged in
                  the <command>resolver</command> category at level
                  <command>info</command>.
                  The default is <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>rfc2308-type1</command></term>
              <listitem>
                <para>
                  Setting this to <userinput>yes</userinput> will
                  cause the server to send NS records along with the SOA
                  record for negative
                  answers. The default is <userinput>no</userinput>.
                </para>
                <note>
                  <simpara>
                    Not yet implemented in <acronym>BIND</acronym>
                    9.
                  </simpara>
                </note>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>use-id-pool</command></term>
              <listitem>
                <para>
                  <emphasis>This option is obsolete</emphasis>.
                  <acronym>BIND</acronym> 9 always allocates query
                  IDs from a pool.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>use-ixfr</command></term>
              <listitem>
                <para>
                  <emphasis>This option is obsolete</emphasis>.
                  If you need to disable IXFR to a particular server or
                  servers, see
                  the information on the <command>provide-ixfr</command> option
                  in <xref linkend="server_statement_definition_and_usage"/>.
                  See also
                  <xref linkend="incremental_zone_transfers"/>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>provide-ixfr</command></term>
              <listitem>
                <para>
                  See the description of
                  <command>provide-ixfr</command> in
                  <xref linkend="server_statement_definition_and_usage"/>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>request-ixfr</command></term>
              <listitem>
                <para>
                  See the description of
                  <command>request-ixfr</command> in
                  <xref linkend="server_statement_definition_and_usage"/>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>treat-cr-as-space</command></term>
              <listitem>
                <para>
                  This option was used in <acronym>BIND</acronym>
                  8 to make
                  the server treat carriage return ("<command>\r</command>") characters the same way
                  as a space or tab character,
                  to facilitate loading of zone files on a UNIX system that
                  were generated
                  on an NT or DOS machine. In <acronym>BIND</acronym> 9, both UNIX "<command>\n</command>"
                  and NT/DOS "<command>\r\n</command>" newlines
                  are always accepted,
                  and the option is ignored.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>additional-from-auth</command></term>
              <term><command>additional-from-cache</command></term>
              <listitem>

                <para>
                  These options control the behavior of an authoritative
                  server when
                  answering queries which have additional data, or when
                  following CNAME
                  and DNAME chains.
                </para>

                <para>
                  When both of these options are set to <userinput>yes</userinput>
                  (the default) and a
                  query is being answered from authoritative data (a zone
                  configured into the server), the additional data section of
                  the
                  reply will be filled in using data from other authoritative
                  zones
                  and from the cache.  In some situations this is undesirable,
                  such
                  as when there is concern over the correctness of the cache,
                  or
                  in servers where slave zones may be added and modified by
                  untrusted third parties.  Also, avoiding
                  the search for this additional data will speed up server
                  operations
                  at the possible expense of additional queries to resolve
                  what would
                  otherwise be provided in the additional section.
                </para>

                <para>
                  For example, if a query asks for an MX record for host <literal>foo.example.com</literal>,
                  and the record found is "<literal>MX 10 mail.example.net</literal>", normally the address
                  records (A and AAAA) for <literal>mail.example.net</literal> will be provided as well,
                  if known, even though they are not in the example.com zone.
                  Setting these options to <command>no</command>
                  disables this behavior and makes
                  the server only search for additional data in the zone it
                  answers from.
                </para>

                <para>
                  These options are intended for use in authoritative-only
                  servers, or in authoritative-only views.  Attempts to set
                  them to <command>no</command> without also
                  specifying
                  <command>recursion no</command> will cause the
                  server to
                  ignore the options and log a warning message.
                </para>

                <para>
                  Specifying <command>additional-from-cache no</command> actually
                  disables the use of the cache not only for additional data
                  lookups
                  but also when looking up the answer.  This is usually the
                  desired
                  behavior in an authoritative-only server where the
                  correctness of
                  the cached data is an issue.
                </para>

                <para>
                  When a name server is non-recursively queried for a name
                  that is not
                  below the apex of any served zone, it normally answers with
                  an
                  "upwards referral" to the root servers or the servers of
                  some other
                  known parent of the query name.  Since the data in an
                  upwards referral
                  comes from the cache, the server will not be able to provide
                  upwards
                  referrals when <command>additional-from-cache no</command>
                  has been specified.  Instead, it will respond to such
                  queries
                  with REFUSED.  This should not cause any problems since
                  upwards referrals are not required for the resolution
                  process.
                </para>

              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>match-mapped-addresses</command></term>
              <listitem>
                <para>
                  If <userinput>yes</userinput>, then an
                  IPv4-mapped IPv6 address will match any address match
                  list entries that match the corresponding IPv4 address.
                </para>
                <para>
                  This option was introduced to work around a kernel quirk
                  in some operating systems that causes IPv4 TCP
                  connections, such as zone transfers, to be accepted on an
                  IPv6 socket using mapped addresses.  This caused address
                  match lists designed for IPv4 to fail to match.  However,
                  <command>named</command> now solves this problem
                  internally.  The use of this option is discouraged.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>filter-aaaa-on-v4</command></term>
              <listitem>
                <para>
                  This option is only available when
                  <acronym>BIND</acronym> 9 is compiled with the
                  <userinput>--enable-filter-aaaa</userinput> option on the
                  "configure" command line.  It is intended to help the
                  transition from IPv4 to IPv6 by not giving IPv6 addresses
                  to DNS clients unless they have connections to the IPv6
                  Internet.  This is not recommended unless absolutely
                  necessary.  The default is <userinput>no</userinput>.
                  The <command>filter-aaaa-on-v4</command> option
                  may also be specified in <command>view</command> statements
                  to override the global <command>filter-aaaa-on-v4</command>
                  option.
                </para>
                <para>
                  If <userinput>yes</userinput>,
                  the DNS client is at an IPv4 address, in <command>filter-aaaa</command>,
                  and if the response does not include DNSSEC signatures, 
                  then all AAAA records are deleted from the response.
                  This filtering applies to all responses and not only
                  authoritative responses.
                </para>
                <para>
                  If <userinput>break-dnssec</userinput>,
                  then AAAA records are deleted even when dnssec is enabled.
                  As suggested by the name, this makes the response not verify,
                  because the DNSSEC protocol is designed detect deletions.
                </para>
                <para>
                  This mechanism can erroneously cause other servers to 
		  not give AAAA records to their clients.  
		  A recursing server with both IPv6 and IPv4 network connections
		  that queries an authoritative server using this mechanism
		  via IPv4 will be denied AAAA records even if its client is
		  using IPv6.
                </para>
                <para>
                  This mechanism is applied to authoritative as well as
		  non-authoritative records.
		  A client using IPv4 that is not allowed recursion can
		  erroneously be given AAAA records because the server is not
		  allowed to check for A records.
                </para>
                <para>
		  Some AAAA records are given to IPv4 clients in glue records.
		  IPv4 clients that are servers can then erroneously
		  answer requests for AAAA records received via IPv4.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>ixfr-from-differences</command></term>
              <listitem>
                <para>
                  When <userinput>yes</userinput> and the server loads a new
                  version of a master zone from its zone file or receives a
                  new version of a slave file via zone transfer, it will
                  compare the new version to the previous one and calculate
                  a set of differences.  The differences are then logged in
                  the zone's journal file such that the changes can be
                  transmitted to downstream slaves as an incremental zone
                  transfer.
                </para>
                <para>
                  By allowing incremental zone transfers to be used for
                  non-dynamic zones, this option saves bandwidth at the
                  expense of increased CPU and memory consumption at the
                  master.
                  In particular, if the new version of a zone is completely
                  different from the previous one, the set of differences
                  will be of a size comparable to the combined size of the
                  old and new zone version, and the server will need to
                  temporarily allocate memory to hold this complete
                  difference set.
                </para>
                <para><command>ixfr-from-differences</command>
		  also accepts <command>master</command> and
                  <command>slave</command> at the view and options
                  levels which causes
                  <command>ixfr-from-differences</command> to be enabled for
                  all <command>master</command> or
                  <command>slave</command> zones respectively.
                  It is off by default.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>multi-master</command></term>
              <listitem>
                <para>
                  This should be set when you have multiple masters for a zone
                  and the
                  addresses refer to different machines.  If <userinput>yes</userinput>, <command>named</command> will
                  not log
                  when the serial number on the master is less than what <command>named</command>
                  currently
                  has.  The default is <userinput>no</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>dnssec-enable</command></term>
              <listitem>
                <para>
                  Enable DNSSEC support in <command>named</command>.  Unless set to <userinput>yes</userinput>,
                  <command>named</command> behaves as if it does not support DNSSEC.
                  The default is <userinput>yes</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>dnssec-validation</command></term>
              <listitem>
                <para>
                  Enable DNSSEC validation in <command>named</command>.
		  Note <command>dnssec-enable</command> also needs to be
		  set to <userinput>yes</userinput> to be effective.
                  If set to <userinput>no</userinput>, DNSSEC validation
                  is disabled.  If set to <userinput>auto</userinput>,
                  DNSSEC validation is enabled, and a default
                  trust-anchor for the DNS root zone is used.  If set to
                  <userinput>yes</userinput>, DNSSEC validation is enabled,
                  but a trust anchor must be manually configured using
                  a <command>trusted-keys</command> or
                  <command>managed-keys</command> statement.  The default
                  is <userinput>yes</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>dnssec-accept-expired</command></term>
              <listitem>
                <para>
		  Accept expired signatures when verifying DNSSEC signatures.
                  The default is <userinput>no</userinput>.
		  Setting this option to <userinput>yes</userinput>
		  leaves <command>named</command> vulnerable to
		  replay attacks.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>querylog</command></term>
              <listitem>
                <para>
                  Specify whether query logging should be started when <command>named</command>
                  starts.
                  If <command>querylog</command> is not specified,
                  then the query logging
                  is determined by the presence of the logging category <command>queries</command>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>check-names</command></term>
              <listitem>
                <para>
                  This option is used to restrict the character set and syntax
                  of
                  certain domain names in master files and/or DNS responses
                  received
                  from the network.  The default varies according to usage
                  area.  For
                  <command>master</command> zones the default is <command>fail</command>.
                  For <command>slave</command> zones the default
                  is <command>warn</command>.
                  For answers received from the network (<command>response</command>)
                  the default is <command>ignore</command>.
                </para>
                <para>
                  The rules for legal hostnames and mail domains are derived
                  from RFC 952 and RFC 821 as modified by RFC 1123.
                </para>
                <para><command>check-names</command>
		  applies to the owner names of A, AAAA and MX records.
		  It also applies to the domain names in the RDATA of NS, SOA,
		  MX, and SRV records.
		  It also applies to the RDATA of PTR records where the owner
		  name indicated that it is a reverse lookup of a hostname
		  (the owner name ends in IN-ADDR.ARPA, IP6.ARPA, or IP6.INT).
                </para>
              </listitem>
            </varlistentry>

	    <varlistentry>
	      <term><command>check-dup-records</command></term>
	      <listitem>
		<para>
		  Check master zones for records that are treated as different
		  by DNSSEC but are semantically equal in plain DNS.  The
		  default is to <command>warn</command>.  Other possible
		  values are <command>fail</command> and
		  <command>ignore</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>check-mx</command></term>
	      <listitem>
		<para>
		  Check whether the MX record appears to refer to a IP address.
		  The default is to <command>warn</command>.  Other possible
		  values are <command>fail</command> and
		  <command>ignore</command>.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>check-wildcard</command></term>
              <listitem>
                <para>
                  This option is used to check for non-terminal wildcards.
                  The use of non-terminal wildcards is almost always as a
                  result of a failure
                  to understand the wildcard matching algorithm (RFC 1034).
                  This option
                  affects master zones.  The default (<command>yes</command>) is to check
                  for non-terminal wildcards and issue a warning.
                </para>
              </listitem>
            </varlistentry>

	    <varlistentry>
	      <term><command>check-integrity</command></term>
	      <listitem>
		<para>
		  Perform post load zone integrity checks on master
		  zones.  This checks that MX and SRV records refer
		  to address (A or AAAA) records and that glue
		  address records exist for delegated zones.  For
		  MX and SRV records only in-zone hostnames are
		  checked (for out-of-zone hostnames use
		  <command>named-checkzone</command>).
		  For NS records only names below top of zone are
		  checked (for out-of-zone names and glue consistency
		  checks use <command>named-checkzone</command>).
	          The default is <command>yes</command>.
		</para>
		<para>
		  Check that the two forms of Sender Policy Framework
		  records (TXT records starting with "v=spf1" and SPF) either
		  both exist or both don't exist.  Warnings are
		  emitted it they don't and be suppressed with
		  <command>check-spf</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>check-mx-cname</command></term>
	      <listitem>
		<para>
		  If <command>check-integrity</command> is set then
		  fail, warn or ignore MX records that refer
		  to CNAMES.  The default is to <command>warn</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>check-srv-cname</command></term>
	      <listitem>
		<para>
		  If <command>check-integrity</command> is set then
		  fail, warn or ignore SRV records that refer
		  to CNAMES.  The default is to <command>warn</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>check-sibling</command></term>
	      <listitem>
		<para>
		  When performing integrity checks, also check that
		  sibling glue exists.  The default is <command>yes</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>check-spf</command></term>
	      <listitem>
		<para>
		  When performing integrity checks, check that the
		  two forms of Sender Policy Framwork records (TXT
		  records starting with "v=spf1" and SPF) both exist
		  or both don't exist and issue a warning if not
		  met.  The default is <command>warn</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>zero-no-soa-ttl</command></term>
	      <listitem>
	        <para>
		  When returning authoritative negative responses to
		  SOA queries set the TTL of the SOA record returned in
		  the authority section to zero.
		  The default is <command>yes</command>.
	        </para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>zero-no-soa-ttl-cache</command></term>
	      <listitem>
	        <para>
		  When caching a negative response to a SOA query
		  set the TTL to zero.
		  The default is <command>no</command>.
	        </para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>update-check-ksk</command></term>
	      <listitem>
	        <para>
                  When set to the default value of <literal>yes</literal>,
                  check the KSK bit in each key to determine how the key
                  should be used when generating RRSIGs for a secure zone.
		</para>
		<para>
                  Ordinarily, zone-signing keys (that is, keys without the
                  KSK bit set) are used to sign the entire zone, while
                  key-signing keys (keys with the KSK bit set) are only
                  used to sign the DNSKEY RRset at the zone apex.
                  However, if this option is set to <literal>no</literal>,
                  then the KSK bit is ignored; KSKs are treated as if they
                  were ZSKs and are used to sign the entire zone.  This is
                  similar to the <command>dnssec-signzone -z</command>
                  command line option.
		</para>
		<para>
                  When this option is set to <literal>yes</literal>, there
                  must be at least two active keys for every algorithm
                  represented in the DNSKEY RRset: at least one KSK and one
                  ZSK per algorithm.  If there is any algorithm for which
                  this requirement is not met, this option will be ignored
                  for that algorithm.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>dnssec-dnskey-kskonly</command></term>
	      <listitem>
	        <para>
                  When this option and <command>update-check-ksk</command>
                  are both set to <literal>yes</literal>, only key-signing
                  keys (that is, keys with the KSK bit set) will be used
                  to sign the DNSKEY RRset at the zone apex.  Zone-signing
                  keys (keys without the KSK bit set) will be used to sign
                  the remainder of the zone, but not the DNSKEY RRset.
                  This is similar to the
                  <command>dnssec-signzone -x</command> command line option.
		</para>
		<para>
		  The default is <command>no</command>.  If
                  <command>update-check-ksk</command> is set to
                  <literal>no</literal>, this option is ignored.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>dnssec-loadkeys-interval</command></term>
	      <listitem>
	        <para>
                  When a zone is configured with <command>auto-dnssec
                  maintain;</command> its key repository must be checked
                  periodically to see if any new keys have been added
                  or any existing keys' timing metadata has been updated
                  (see <xref linkend="man.dnssec-keygen"/> and
                  <xref linkend="man.dnssec-settime"/>).  The
                  <command>dnssec-loadkeys-interval</command> option
                  sets the frequency of autoatic repository checks, in
                  minutes.  The default is <literal>60</literal> (1 hour),
                  the minimum is <literal>1</literal> (1 minute), and the
                  maximum is <literal>1440</literal> (24 hours); any higher
                  value is silently reduced.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>try-tcp-refresh</command></term>
	      <listitem>
	        <para>
		  Try to refresh the zone using TCP if UDP queries fail.
		  For BIND 8 compatibility, the default is
		  <command>yes</command>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>dnssec-secure-to-insecure</command></term>
	      <listitem>
	        <para>
		  Allow a dynamic zone to transition from secure to
                  insecure (i.e., signed to unsigned) by deleting all
                  of the DNSKEY records.  The default is <command>no</command>.
                  If set to <command>yes</command>, and if the DNSKEY RRset
                  at the zone apex is deleted, all RRSIG and NSEC records
                  will be removed from the zone as well.
		</para>
	        <para>
                  If the zone uses NSEC3, then it is also necessary to
                  delete the NSEC3PARAM RRset from the zone apex; this will
                  cause the removal of all corresponding NSEC3 records.
                  (It is expected that this requirement will be eliminated
                  in a future release.)
		</para>
	        <para>
                  Note that if a zone has been configured with
                  <command>auto-dnssec maintain</command> and the
                  private keys remain accessible in the key repository,
                  then the zone will be automatically signed again the
                  next time <command>named</command> is started.
		</para>
	      </listitem>
	    </varlistentry>

          </variablelist>

        </sect3>

        <sect3>
          <title>Forwarding</title>
          <para>
            The forwarding facility can be used to create a large site-wide
            cache on a few servers, reducing traffic over links to external
            name servers. It can also be used to allow queries by servers that
            do not have direct access to the Internet, but wish to look up
            exterior
            names anyway. Forwarding occurs only on those queries for which
            the server is not authoritative and does not have the answer in
            its cache.
          </para>

          <variablelist>
            <varlistentry>
              <term><command>forward</command></term>
              <listitem>
                <para>
                  This option is only meaningful if the
                  forwarders list is not empty. A value of <varname>first</varname>,
                  the default, causes the server to query the forwarders
                  first &mdash; and
                  if that doesn't answer the question, the server will then
                  look for
                  the answer itself. If <varname>only</varname> is
                  specified, the
                  server will only query the forwarders.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>forwarders</command></term>
              <listitem>
                <para>
                  Specifies the IP addresses to be used
                  for forwarding. The default is the empty list (no
                  forwarding).
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

          <para>
            Forwarding can also be configured on a per-domain basis, allowing
            for the global forwarding options to be overridden in a variety
            of ways. You can set particular domains to use different
            forwarders,
            or have a different <command>forward only/first</command> behavior,
            or not forward at all, see <xref linkend="zone_statement_grammar"/>.
          </para>
        </sect3>

        <sect3>
          <title>Dual-stack Servers</title>
          <para>
            Dual-stack servers are used as servers of last resort to work
            around
            problems in reachability due the lack of support for either IPv4
            or IPv6
            on the host machine.
          </para>

          <variablelist>
            <varlistentry>
              <term><command>dual-stack-servers</command></term>
              <listitem>
                <para>
                  Specifies host names or addresses of machines with access to
                  both IPv4 and IPv6 transports. If a hostname is used, the
                  server must be able
                  to resolve the name using only the transport it has.  If the
                  machine is dual
                  stacked, then the <command>dual-stack-servers</command> have no effect unless
                  access to a transport has been disabled on the command line
                  (e.g. <command>named -4</command>).
                </para>
              </listitem>
            </varlistentry>
          </variablelist>
        </sect3>

        <sect3 id="access_control">
          <title>Access Control</title>

          <para>
            Access to the server can be restricted based on the IP address
            of the requesting system. See <xref linkend="address_match_lists"/> for
            details on how to specify IP address lists.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>allow-notify</command></term>
              <listitem>
                <para>
                  Specifies which hosts are allowed to
                  notify this server, a slave, of zone changes in addition
                  to the zone masters.
                  <command>allow-notify</command> may also be
                  specified in the
                  <command>zone</command> statement, in which case
                  it overrides the
                  <command>options allow-notify</command>
                  statement.  It is only meaningful
                  for a slave zone.  If not specified, the default is to
                  process notify messages
                  only from a zone's master.
                </para>
              </listitem>
            </varlistentry>

	    <varlistentry>
	      <term><command>allow-query</command></term>
	      <listitem>
		<para>
		  Specifies which hosts are allowed to ask ordinary
		  DNS questions. <command>allow-query</command> may
		  also be specified in the <command>zone</command>
		  statement, in which case it overrides the
		  <command>options allow-query</command> statement.
		  If not specified, the default is to allow queries
		  from all hosts.
		</para>
		<note>
		  <para>
		    <command>allow-query-cache</command> is now
		    used to specify access to the cache.
		  </para>
		</note>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>allow-query-on</command></term>
	      <listitem>
		<para>
		  Specifies which local addresses can accept ordinary
		  DNS questions. This makes it possible, for instance,
		  to allow queries on internal-facing interfaces but
		  disallow them on external-facing ones, without
		  necessarily knowing the internal network's addresses.
		</para>
		<para>
                  Note that <command>allow-query-on</command> is only
                  checked for queries that are permitted by
                  <command>allow-query</command>.  A query must be
                  allowed by both ACLs, or it will be refused.
		</para>
		<para>
		  <command>allow-query-on</command> may
		  also be specified in the <command>zone</command>
		  statement, in which case it overrides the
		  <command>options allow-query-on</command> statement.
		</para>
		<para>
		  If not specified, the default is to allow queries
		  on all addresses.
		</para>
		<note>
		  <para>
		    <command>allow-query-cache</command> is
		    used to specify access to the cache.
		  </para>
		</note>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>allow-query-cache</command></term>
	      <listitem>
		<para>
		  Specifies which hosts are allowed to get answers
		  from the cache.  If <command>allow-query-cache</command>
		  is not set then <command>allow-recursion</command>
		  is used if set, otherwise <command>allow-query</command>
		  is used if set unless <command>recursion no;</command> is
		  set in which case <command>none;</command> is used,
		  otherwise the default (<command>localnets;</command>
		  <command>localhost;</command>) is used.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>allow-query-cache-on</command></term>
	      <listitem>
		<para>
		  Specifies which local addresses can give answers
		  from the cache.  If not specified, the default is
		  to allow cache queries on any address,
		  <command>localnets</command> and
		  <command>localhost</command>.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>allow-recursion</command></term>
              <listitem>
		<para>
		  Specifies which hosts are allowed to make recursive
		  queries through this server. If
		  <command>allow-recursion</command> is not set
		  then <command>allow-query-cache</command> is
		  used if set, otherwise <command>allow-query</command>
		  is used if set, otherwise the default
		  (<command>localnets;</command>
		  <command>localhost;</command>) is used.
		</para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>allow-recursion-on</command></term>
              <listitem>
                <para>
		  Specifies which local addresses can accept recursive
		  queries.  If not specified, the default is to allow
		  recursive queries on all addresses.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>allow-update</command></term>
              <listitem>
                <para>
                  Specifies which hosts are allowed to
                  submit Dynamic DNS updates for master zones. The default is
                  to deny
                  updates from all hosts.  Note that allowing updates based
                  on the requestor's IP address is insecure; see
                  <xref linkend="dynamic_update_security"/> for details.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>allow-update-forwarding</command></term>
              <listitem>
                <para>
                  Specifies which hosts are allowed to
                  submit Dynamic DNS updates to slave zones to be forwarded to
                  the
                  master.  The default is <userinput>{ none; }</userinput>,
                  which
                  means that no update forwarding will be performed.  To
                  enable
                  update forwarding, specify
                  <userinput>allow-update-forwarding { any; };</userinput>.
                  Specifying values other than <userinput>{ none; }</userinput> or
                  <userinput>{ any; }</userinput> is usually
                  counterproductive, since
                  the responsibility for update access control should rest
                  with the
                  master server, not the slaves.
                </para>
                <para>
                  Note that enabling the update forwarding feature on a slave
                  server
                  may expose master servers relying on insecure IP address
                  based
                  access control to attacks; see <xref linkend="dynamic_update_security"/>
                  for more details.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>allow-v6-synthesis</command></term>
              <listitem>
                <para>
                  This option was introduced for the smooth transition from
                  AAAA
                  to A6 and from "nibble labels" to binary labels.
                  However, since both A6 and binary labels were then
                  deprecated,
                  this option was also deprecated.
                  It is now ignored with some warning messages.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>allow-transfer</command></term>
              <listitem>
                <para>
                  Specifies which hosts are allowed to
                  receive zone transfers from the server. <command>allow-transfer</command> may
                  also be specified in the <command>zone</command>
                  statement, in which
                  case it overrides the <command>options allow-transfer</command> statement.
                  If not specified, the default is to allow transfers to all
                  hosts.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>blackhole</command></term>
              <listitem>
                <para>
                  Specifies a list of addresses that the
                  server will not accept queries from or use to resolve a
                  query. Queries
                  from these addresses will not be responded to. The default
                  is <userinput>none</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>filter-aaaa</command></term>
              <listitem>
                <para>
                  Specifies a list of addresses to which
		  <command>filter-aaaa-on-v4</command>
                  is applies.  The default is <userinput>any</userinput>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>resolver-query-timeout</command></term>
              <listitem>
                <para>
		  The amount of time the resolver will spend attempting
		  to resolve a recursive query before failing.  The default
		  and minimum is <literal>10</literal> and the maximum is
		  <literal>30</literal>.  Setting it to <literal>0</literal>
		  will result in the default being used.
                </para>
              </listitem>
            </varlistentry>
          </variablelist>

        </sect3>

        <sect3>
          <title>Interfaces</title>
          <para>
            The interfaces and ports that the server will answer queries
            from may be specified using the <command>listen-on</command> option. <command>listen-on</command> takes
            an optional port and an <varname>address_match_list</varname>.
            The server will listen on all interfaces allowed by the address
            match list. If a port is not specified, port 53 will be used.
          </para>
          <para>
            Multiple <command>listen-on</command> statements are
            allowed.
            For example,
          </para>

<programlisting>listen-on { 5.6.7.8; };
listen-on port 1234 { !1.2.3.4; 1.2/16; };
</programlisting>

          <para>
            will enable the name server on port 53 for the IP address
            5.6.7.8, and on port 1234 of an address on the machine in net
            1.2 that is not 1.2.3.4.
          </para>

          <para>
            If no <command>listen-on</command> is specified, the
            server will listen on port 53 on all IPv4 interfaces.
          </para>

          <para>
            The <command>listen-on-v6</command> option is used to
            specify the interfaces and the ports on which the server will
            listen
            for incoming queries sent using IPv6.
          </para>

          <para>
            When <programlisting>{ any; }</programlisting> is
            specified
            as the <varname>address_match_list</varname> for the
            <command>listen-on-v6</command> option,
            the server does not bind a separate socket to each IPv6 interface
            address as it does for IPv4 if the operating system has enough API
            support for IPv6 (specifically if it conforms to RFC 3493 and RFC
            3542).
            Instead, it listens on the IPv6 wildcard address.
            If the system only has incomplete API support for IPv6, however,
            the behavior is the same as that for IPv4.
          </para>

          <para>
            A list of particular IPv6 addresses can also be specified, in
            which case
            the server listens on a separate socket for each specified
            address,
            regardless of whether the desired API is supported by the system.
          </para>

          <para>
            Multiple <command>listen-on-v6</command> options can
            be used.
            For example,
          </para>

<programlisting>listen-on-v6 { any; };
listen-on-v6 port 1234 { !2001:db8::/32; any; };
</programlisting>

          <para>
            will enable the name server on port 53 for any IPv6 addresses
            (with a single wildcard socket),
            and on port 1234 of IPv6 addresses that is not in the prefix
            2001:db8::/32 (with separate sockets for each matched address.)
          </para>

          <para>
            To make the server not listen on any IPv6 address, use
          </para>

<programlisting>listen-on-v6 { none; };
</programlisting>

          <para>
            If no <command>listen-on-v6</command> option is
            specified, the server will not listen on any IPv6 address
	    unless <command>-6</command> is specified when <command>named</command> is
	    invoked.  If <command>-6</command> is specified then
	    <command>named</command> will listen on port 53 on all IPv6 interfaces by default.
          </para>
        </sect3>

        <sect3 id="query_address">
          <title>Query Address</title>
          <para>
            If the server doesn't know the answer to a question, it will
            query other name servers. <command>query-source</command> specifies
            the address and port used for such queries. For queries sent over
            IPv6, there is a separate <command>query-source-v6</command> option.
            If <command>address</command> is <command>*</command> (asterisk) or is omitted,
            a wildcard IP address (<command>INADDR_ANY</command>)
            will be used.
	  </para>

	  <para>
            If <command>port</command> is <command>*</command> or is omitted,
	    a random port number from a pre-configured
	    range is picked up and will be used for each query.
	    The port range(s) is that specified in
	    the <command>use-v4-udp-ports</command> (for IPv4)
            and <command>use-v6-udp-ports</command> (for IPv6)
	    options, excluding the ranges specified in
	    the <command>avoid-v4-udp-ports</command>
            and <command>avoid-v6-udp-ports</command> options, respectively.
	  </para>

          <para>
	    The defaults of the <command>query-source</command> and
	    <command>query-source-v6</command> options
	    are:
          </para>

<programlisting>query-source address * port *;
query-source-v6 address * port *;
</programlisting>

          <para>
	    If <command>use-v4-udp-ports</command> or
            <command>use-v6-udp-ports</command> is unspecified,
	    <command>named</command> will check if the operating
	    system provides a programming interface to retrieve the
	    system's default range for ephemeral ports.
	    If such an interface is available,
	    <command>named</command> will use the corresponding system
	    default range; otherwise, it will use its own defaults:
         </para>

<programlisting>use-v4-udp-ports { range 1024 65535; };
use-v6-udp-ports { range 1024 65535; };
</programlisting>

          <para>
	    Note: make sure the ranges be sufficiently large for
	    security.  A desirable size depends on various parameters,
	    but we generally recommend it contain at least 16384 ports
	    (14 bits of entropy).
	    Note also that the system's default range when used may be
	    too small for this purpose, and that the range may even be
	    changed while <command>named</command> is running; the new
	    range will automatically be applied when <command>named</command>
	    is reloaded.
	    It is encouraged to
	    configure <command>use-v4-udp-ports</command> and
            <command>use-v6-udp-ports</command> explicitly so that the
            ranges are sufficiently large and are reasonably
            independent from the ranges used by other applications.
          </para>

	  <para>
	    Note: the operational configuration
	    where <command>named</command> runs may prohibit the use
	    of some ports.  For example, UNIX systems will not allow
	    <command>named</command> running without a root privilege
	    to use ports less than 1024.
	    If such ports are included in the specified (or detected)
	    set of query ports, the corresponding query attempts will
	    fail, resulting in resolution failures or delay.
	    It is therefore important to configure the set of ports
	    that can be safely used in the expected operational environment.
	  </para>

          <para>
	    The defaults of the <command>avoid-v4-udp-ports</command> and
	    <command>avoid-v6-udp-ports</command> options
	    are:
          </para>

<programlisting>avoid-v4-udp-ports {};
avoid-v6-udp-ports {};
</programlisting>

	  <para>
	    Note: BIND 9.5.0 introduced
	    the <command>use-queryport-pool</command> 
	    option to support a pool of such random ports, but this
	    option is now obsolete because reusing the same ports in
	    the pool may not be sufficiently secure.
	    For the same reason, it is generally strongly discouraged to
            specify a particular port for the
	    <command>query-source</command> or
	    <command>query-source-v6</command> options;
	    it implicitly disables the use of randomized port numbers.
          </para>

          <variablelist>
            <varlistentry>
              <term><command>use-queryport-pool</command></term>
              <listitem>
                <para>
		  This option is obsolete.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>queryport-pool-ports</command></term>
              <listitem>
                <para>
		  This option is obsolete.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>queryport-pool-updateinterval</command></term>
              <listitem>
                <para>
		  This option is obsolete.
		</para>
	      </listitem>
	    </varlistentry>
	    
          </variablelist>
          <note>
            <para>
              The address specified in the <command>query-source</command> option
              is used for both UDP and TCP queries, but the port applies only
              to UDP queries.  TCP queries always use a random
              unprivileged port.
            </para>
          </note>
	  <note>
	    <para>
	      Solaris 2.5.1 and earlier does not support setting the source
	      address for TCP sockets.
	    </para>
	  </note>
          <note>
            <para>
              See also <command>transfer-source</command> and
              <command>notify-source</command>.
            </para>
          </note>
        </sect3>

        <sect3 id="zone_transfers">
          <title>Zone Transfers</title>
          <para>
            <acronym>BIND</acronym> has mechanisms in place to
            facilitate zone transfers
            and set limits on the amount of load that transfers place on the
            system. The following options apply to zone transfers.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>also-notify</command></term>
              <listitem>
                <para>
                  Defines a global list of IP addresses of name servers
                  that are also sent NOTIFY messages whenever a fresh copy of
                  the
                  zone is loaded, in addition to the servers listed in the
                  zone's NS records.
                  This helps to ensure that copies of the zones will
                  quickly converge on stealth servers.
                  Optionally, a port may be specified with each
                  <command>also-notify</command> address to send
                  the notify messages to a port other than the
                  default of 53.
                  An optional TSIG key can also be specified with each
                  address to cause the notify messages to be signed; this
                  can be useful when sending notifies to multiple views.
                  In place of explicit addresses, one or more named
                  <command>masters</command> lists can be used.
                </para>
                <para>
                  If an <command>also-notify</command> list
                  is given in a <command>zone</command> statement,
                  it will override
                  the <command>options also-notify</command>
                  statement. When a <command>zone notify</command>
                  statement
                  is set to <command>no</command>, the IP
                  addresses in the global <command>also-notify</command> list will
                  not be sent NOTIFY messages for that zone. The default is
                  the empty
                  list (no global notification list).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-transfer-time-in</command></term>
              <listitem>
                <para>
                  Inbound zone transfers running longer than
                  this many minutes will be terminated. The default is 120
                  minutes
                  (2 hours).  The maximum value is 28 days (40320 minutes).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-transfer-idle-in</command></term>
              <listitem>
                <para>
                  Inbound zone transfers making no progress
                  in this many minutes will be terminated. The default is 60
                  minutes
                  (1 hour).  The maximum value is 28 days (40320 minutes).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-transfer-time-out</command></term>
              <listitem>
                <para>
                  Outbound zone transfers running longer than
                  this many minutes will be terminated. The default is 120
                  minutes
                  (2 hours).  The maximum value is 28 days (40320 minutes).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-transfer-idle-out</command></term>
              <listitem>
                <para>
                  Outbound zone transfers making no progress
                  in this many minutes will be terminated.  The default is 60
                  minutes (1
                  hour).  The maximum value is 28 days (40320 minutes).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>serial-query-rate</command></term>
	      <listitem>
		<para>
		  Slave servers will periodically query master
		  servers to find out if zone serial numbers have
		  changed. Each such query uses a minute amount of
		  the slave server's network bandwidth.  To limit
		  the amount of bandwidth used, BIND 9 limits the
		  rate at which queries are sent.  The value of the
		  <command>serial-query-rate</command> option, an
		  integer, is the maximum number of queries sent
		  per second.  The default is 20.
		</para>
		<para>
		  In addition to controlling the rate SOA refresh
		  queries are issued at
		  <command>serial-query-rate</command> also controls
		  the rate at which NOTIFY messages are sent from
		  both master and slave zones.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>serial-queries</command></term>
              <listitem>
                <para>
                  In BIND 8, the <command>serial-queries</command>
                  option
                  set the maximum number of concurrent serial number queries
                  allowed to be outstanding at any given time.
                  BIND 9 does not limit the number of outstanding
                  serial queries and ignores the <command>serial-queries</command> option.
                  Instead, it limits the rate at which the queries are sent
                  as defined using the <command>serial-query-rate</command> option.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfer-format</command></term>
              <listitem>

                <para>
                  Zone transfers can be sent using two different formats,
                  <command>one-answer</command> and
		  <command>many-answers</command>.
                  The <command>transfer-format</command> option is used
                  on the master server to determine which format it sends.
                  <command>one-answer</command> uses one DNS message per
                  resource record transferred.
                  <command>many-answers</command> packs as many resource
		  records as possible into a message.
		  <command>many-answers</command> is more efficient, but is
		  only supported by relatively new slave servers,
                  such as <acronym>BIND</acronym> 9, <acronym>BIND</acronym>
		  8.x and <acronym>BIND</acronym> 4.9.5 onwards.
	          The <command>many-answers</command> format is also supported by
		  recent Microsoft Windows nameservers.
		  The default is <command>many-answers</command>.
		  <command>transfer-format</command> may be overridden on a
		  per-server basis by using the <command>server</command>
		  statement.
                </para>

              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfers-in</command></term>
              <listitem>
                <para>
                  The maximum number of inbound zone transfers
                  that can be running concurrently. The default value is <literal>10</literal>.
                  Increasing <command>transfers-in</command> may
                  speed up the convergence
                  of slave zones, but it also may increase the load on the
                  local system.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfers-out</command></term>
              <listitem>
                <para>
                  The maximum number of outbound zone transfers
                  that can be running concurrently. Zone transfer requests in
                  excess
                  of the limit will be refused. The default value is <literal>10</literal>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfers-per-ns</command></term>
              <listitem>
                <para>
                  The maximum number of inbound zone transfers
                  that can be concurrently transferring from a given remote
                  name server.
                  The default value is <literal>2</literal>.
                  Increasing <command>transfers-per-ns</command>
                  may
                  speed up the convergence of slave zones, but it also may
                  increase
                  the load on the remote name server. <command>transfers-per-ns</command> may
                  be overridden on a per-server basis by using the <command>transfers</command> phrase
                  of the <command>server</command> statement.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfer-source</command></term>
              <listitem>
                <para><command>transfer-source</command>
		  determines which local address will be bound to IPv4
                  TCP connections used to fetch zones transferred
                  inbound by the server.  It also determines the
                  source IPv4 address, and optionally the UDP port,
                  used for the refresh queries and forwarded dynamic
                  updates.  If not set, it defaults to a system
                  controlled value which will usually be the address
                  of the interface "closest to" the remote end. This
                  address must appear in the remote end's
                  <command>allow-transfer</command> option for the
                  zone being transferred, if one is specified. This
                  statement sets the
                  <command>transfer-source</command> for all zones,
                  but can be overridden on a per-view or per-zone
                  basis by including a
                  <command>transfer-source</command> statement within
                  the <command>view</command> or
                  <command>zone</command> block in the configuration
                  file.
                </para>
	        <note>
	          <para>
	            Solaris 2.5.1 and earlier does not support setting the
		    source address for TCP sockets.
	          </para>
                </note>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>transfer-source-v6</command></term>
              <listitem>
                <para>
                  The same as <command>transfer-source</command>,
                  except zone transfers are performed using IPv6.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>alt-transfer-source</command></term>
              <listitem>
                <para>
                  An alternate transfer source if the one listed in
                  <command>transfer-source</command> fails and
                  <command>use-alt-transfer-source</command> is
                  set.
                </para>
		<note>
		  If you do not wish the alternate transfer source
		  to be used, you should set
		  <command>use-alt-transfer-source</command>
		  appropriately and you should not depend upon
		  getting an answer back to the first refresh
		  query.
		</note>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>alt-transfer-source-v6</command></term>
              <listitem>
                <para>
                  An alternate transfer source if the one listed in
                  <command>transfer-source-v6</command> fails and
                  <command>use-alt-transfer-source</command> is
                  set.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>use-alt-transfer-source</command></term>
              <listitem>
                <para>
                  Use the alternate transfer sources or not.  If views are
                  specified this defaults to <command>no</command>
                  otherwise it defaults to
                  <command>yes</command> (for BIND 8
                  compatibility).
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>notify-source</command></term>
              <listitem>
                <para><command>notify-source</command>
		  determines which local source address, and
                  optionally UDP port, will be used to send NOTIFY
                  messages.  This address must appear in the slave
                  server's <command>masters</command> zone clause or
                  in an <command>allow-notify</command> clause.  This
                  statement sets the <command>notify-source</command>
                  for all zones, but can be overridden on a per-zone or
                  per-view basis by including a
                  <command>notify-source</command> statement within
                  the <command>zone</command> or
                  <command>view</command> block in the configuration
                  file.
                </para>
	        <note>
	          <para>
	            Solaris 2.5.1 and earlier does not support setting the
		    source address for TCP sockets.
	          </para>
                </note>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>notify-source-v6</command></term>
              <listitem>
                <para>
                  Like <command>notify-source</command>,
                  but applies to notify messages sent to IPv6 addresses.
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3>
          <title>UDP Port Lists</title>
          <para>
	    <command>use-v4-udp-ports</command>,
	    <command>avoid-v4-udp-ports</command>,
	    <command>use-v6-udp-ports</command>, and
	    <command>avoid-v6-udp-ports</command>
	    specify a list of IPv4 and IPv6 UDP ports that will be
	    used or not used as source ports for UDP messages.
	    See <xref linkend="query_address"/> about how the
	    available ports are determined.
	    For example, with the following configuration
          </para>

<programlisting>
use-v6-udp-ports { range 32768 65535; };
avoid-v6-udp-ports { 40000; range 50000 60000; };
</programlisting>

	   <para>
	     UDP ports of IPv6 messages sent
	     from <command>named</command> will be in one
	     of the following ranges: 32768 to 39999, 40001 to 49999,
	     and 60001 to 65535.
	   </para>

	   <para>
	     <command>avoid-v4-udp-ports</command> and
	     <command>avoid-v6-udp-ports</command> can be used
             to prevent <command>named</command> from choosing as its random source port a
             port that is blocked by your firewall or a port that is
             used by other applications;
	     if a query went out with a source port blocked by a
             firewall, the
	     answer would not get by the firewall and the name server would
             have to query again.
	     Note: the desired range can also be represented only with
	     <command>use-v4-udp-ports</command> and
	     <command>use-v6-udp-ports</command>, and the
	     <command>avoid-</command> options are redundant in that
	     sense; they are provided for backward compatibility and
	     to possibly simplify the port specification.
	   </para>
        </sect3>

        <sect3>
          <title>Operating System Resource Limits</title>

          <para>
            The server's usage of many system resources can be limited.
            Scaled values are allowed when specifying resource limits.  For
            example, <command>1G</command> can be used instead of
            <command>1073741824</command> to specify a limit of
            one
            gigabyte. <command>unlimited</command> requests
            unlimited use, or the
            maximum available amount. <command>default</command>
            uses the limit
            that was in force when the server was started. See the description
            of <command>size_spec</command> in <xref linkend="configuration_file_elements"/>.
          </para>

          <para>
            The following options set operating system resource limits for
            the name server process.  Some operating systems don't support
            some or
            any of the limits. On such systems, a warning will be issued if
            the
            unsupported limit is used.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>coresize</command></term>
              <listitem>
                <para>
                  The maximum size of a core dump. The default
                  is <literal>default</literal>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>datasize</command></term>
              <listitem>
                <para>
                  The maximum amount of data memory the server
                  may use. The default is <literal>default</literal>.
                  This is a hard limit on server memory usage.
                  If the server attempts to allocate memory in excess of this
                  limit, the allocation will fail, which may in turn leave
                  the server unable to perform DNS service.  Therefore,
                  this option is rarely useful as a way of limiting the
                  amount of memory used by the server, but it can be used
                  to raise an operating system data size limit that is
                  too small by default.  If you wish to limit the amount
                  of memory used by the server, use the
                  <command>max-cache-size</command> and
                  <command>recursive-clients</command>
                  options instead.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>files</command></term>
              <listitem>
                <para>
                  The maximum number of files the server
                  may have open concurrently. The default is <literal>unlimited</literal>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>stacksize</command></term>
              <listitem>
                <para>
                  The maximum amount of stack memory the server
                  may use. The default is <literal>default</literal>.
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3 id="server_resource_limits">
          <title>Server  Resource Limits</title>

          <para>
            The following options set limits on the server's
            resource consumption that are enforced internally by the
            server rather than the operating system.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>max-ixfr-log-size</command></term>
              <listitem>
                <para>
                  This option is obsolete; it is accepted
                  and ignored for BIND 8 compatibility.  The option
                  <command>max-journal-size</command> performs a
                  similar function in BIND 9.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-journal-size</command></term>
              <listitem>
                <para>
                  Sets a maximum size for each journal file
                  (see <xref linkend="journal"/>).  When the journal file
                  approaches
                  the specified size, some of the oldest transactions in the
                  journal
                  will be automatically removed.  The largest permitted
                  value is 2 gigabytes. The default is
                  <literal>unlimited</literal>, which also
                  means 2 gigabytes.
                  This may also be set on a per-zone basis.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>host-statistics-max</command></term>
              <listitem>
                <para>
                  In BIND 8, specifies the maximum number of host statistics
                  entries to be kept.
                  Not implemented in BIND 9.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>recursive-clients</command></term>
              <listitem>
                <para>
                  The maximum number of simultaneous recursive lookups
                  the server will perform on behalf of clients.  The default
                  is
                  <literal>1000</literal>.  Because each recursing
                  client uses a fair
                  bit of memory, on the order of 20 kilobytes, the value of
                  the
                  <command>recursive-clients</command> option may
                  have to be decreased
                  on hosts with limited memory.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>tcp-clients</command></term>
              <listitem>
                <para>
                  The maximum number of simultaneous client TCP
                  connections that the server will accept.
                  The default is <literal>100</literal>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>reserved-sockets</command></term>
              <listitem>
                <para>
		  The number of file descriptors reserved for TCP, stdio,
		  etc.  This needs to be big enough to cover the number of
		  interfaces <command>named</command> listens on, <command>tcp-clients</command> as well as
		  to provide room for outgoing TCP queries and incoming zone
		  transfers.  The default is <literal>512</literal>.
		  The minimum value is <literal>128</literal> and the
		  maximum value is <literal>128</literal> less than
		  maxsockets (-S).  This option may be removed in the future.
                </para>
                <para>
		  This option has little effect on Windows.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-cache-size</command></term>
              <listitem>
                <para>
                  The maximum amount of memory to use for the
                  server's cache, in bytes.
                  When the amount of data in the cache
                  reaches this limit, the server will cause records to expire
                  prematurely based on an LRU based strategy so that
                  the limit is not exceeded.
                  A value of 0 is special, meaning that
                  records are purged from the cache only when their
                  TTLs expire.
                  Another special keyword <userinput>unlimited</userinput>
                  means the maximum value of 32-bit unsigned integers
                  (0xffffffff), which may not have the same effect as
                  0 on machines that support more than 32 bits of
                  memory space.
                  Any positive values less than 2MB will be ignored reset
                  to 2MB.
                  In a server with multiple views, the limit applies
                  separately to the cache of each view.
                  The default is 0.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>tcp-listen-queue</command></term>
              <listitem>
                <para>
                  The listen queue depth.  The default and minimum is 3.
                  If the kernel supports the accept filter "dataready" this
                  also controls how
                  many TCP connections that will be queued in kernel space
                  waiting for
                  some data before being passed to accept.  Values less than 3
                  will be
                  silently raised.
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3>
          <title>Periodic Task Intervals</title>

          <variablelist>

            <varlistentry>
              <term><command>cleaning-interval</command></term>
              <listitem>
                <para>
		  This interval is effectively obsolete.  Previously,
		  the server would remove expired resource records
                  from the cache every <command>cleaning-interval</command> minutes.
		  <acronym>BIND</acronym> 9 now manages cache
		  memory in a more sophisticated manner and does not
		  rely on the periodic cleaning any more.
		  Specifying this option therefore has no effect on
		  the server's behavior.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>heartbeat-interval</command></term>
              <listitem>
                <para>
                  The server will perform zone maintenance tasks
                  for all zones marked as <command>dialup</command> whenever this
                  interval expires. The default is 60 minutes. Reasonable
                  values are up
                  to 1 day (1440 minutes).  The maximum value is 28 days
                  (40320 minutes).
                  If set to 0, no zone maintenance for these zones will occur.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>interface-interval</command></term>
              <listitem>
                <para>
                  The server will scan the network interface list
                  every <command>interface-interval</command>
                  minutes. The default
                  is 60 minutes. The maximum value is 28 days (40320 minutes).
                  If set to 0, interface scanning will only occur when
                  the configuration file is  loaded. After the scan, the
                  server will
                  begin listening for queries on any newly discovered
                  interfaces (provided they are allowed by the
                  <command>listen-on</command> configuration), and
                  will
                  stop listening on interfaces that have gone away.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>statistics-interval</command></term>
              <listitem>
                <para>
                  Name server statistics will be logged
                  every <command>statistics-interval</command>
                  minutes. The default is
                  60. The maximum value is 28 days (40320 minutes).
                  If set to 0, no statistics will be logged.
                  </para><note>
                  <simpara>
                    Not yet implemented in
                    <acronym>BIND</acronym> 9.
                  </simpara>
                </note>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3 id="topology">
          <title>Topology</title>

          <para>
            All other things being equal, when the server chooses a name
            server
            to query from a list of name servers, it prefers the one that is
            topologically closest to itself. The <command>topology</command> statement
            takes an <command>address_match_list</command> and
            interprets it
            in a special way. Each top-level list element is assigned a
            distance.
            Non-negated elements get a distance based on their position in the
            list, where the closer the match is to the start of the list, the
            shorter the distance is between it and the server. A negated match
            will be assigned the maximum distance from the server. If there
            is no match, the address will get a distance which is further than
            any non-negated list element, and closer than any negated element.
            For example,
          </para>

<programlisting>topology {
    10/8;
    !1.2.3/24;
    { 1.2/16; 3/8; };
};</programlisting>

          <para>
            will prefer servers on network 10 the most, followed by hosts
            on network 1.2.0.0 (netmask 255.255.0.0) and network 3, with the
            exception of hosts on network 1.2.3 (netmask 255.255.255.0), which
            is preferred least of all.
          </para>
          <para>
            The default topology is
          </para>

<programlisting>    topology { localhost; localnets; };
</programlisting>

          <note>
            <simpara>
              The <command>topology</command> option
              is not implemented in <acronym>BIND</acronym> 9.
            </simpara>
          </note>
        </sect3>

        <sect3 id="the_sortlist_statement">

          <title>The <command>sortlist</command> Statement</title>

          <para>
            The response to a DNS query may consist of multiple resource
            records (RRs) forming a resource records set (RRset).
            The name server will normally return the
            RRs within the RRset in an indeterminate order
            (but see the <command>rrset-order</command>
            statement in <xref linkend="rrset_ordering"/>).
            The client resolver code should rearrange the RRs as appropriate,
            that is, using any addresses on the local net in preference to
            other addresses.
            However, not all resolvers can do this or are correctly
            configured.
            When a client is using a local server, the sorting can be performed
            in the server, based on the client's address. This only requires
            configuring the name servers, not all the clients.
          </para>

          <para>
            The <command>sortlist</command> statement (see below)
            takes
            an <command>address_match_list</command> and
            interprets it even
            more specifically than the <command>topology</command>
            statement
            does (<xref linkend="topology"/>).
            Each top level statement in the <command>sortlist</command> must
            itself be an explicit <command>address_match_list</command> with
            one or two elements. The first element (which may be an IP
            address,
            an IP prefix, an ACL name or a nested <command>address_match_list</command>)
            of each top level list is checked against the source address of
            the query until a match is found.
          </para>
          <para>
            Once the source address of the query has been matched, if
            the top level statement contains only one element, the actual
            primitive
            element that matched the source address is used to select the
            address
            in the response to move to the beginning of the response. If the
            statement is a list of two elements, then the second element is
            treated the same as the <command>address_match_list</command> in
            a <command>topology</command> statement. Each top
            level element
            is assigned a distance and the address in the response with the
            minimum
            distance is moved to the beginning of the response.
          </para>
          <para>
            In the following example, any queries received from any of
            the addresses of the host itself will get responses preferring
            addresses
            on any of the locally connected networks. Next most preferred are
            addresses
            on the 192.168.1/24 network, and after that either the
            192.168.2/24
            or
            192.168.3/24 network with no preference shown between these two
            networks. Queries received from a host on the 192.168.1/24 network
            will prefer other addresses on that network to the 192.168.2/24
            and
            192.168.3/24 networks. Queries received from a host on the
            192.168.4/24
            or the 192.168.5/24 network will only prefer other addresses on
            their directly connected networks.
          </para>

<programlisting>sortlist {
    // IF the local host
    // THEN first fit on the following nets
    { localhost;
        { localnets;
            192.168.1/24;
            { 192.168.2/24; 192.168.3/24; }; }; };
    // IF on class C 192.168.1 THEN use .1, or .2 or .3
    { 192.168.1/24;
        { 192.168.1/24;
            { 192.168.2/24; 192.168.3/24; }; }; };
    // IF on class C 192.168.2 THEN use .2, or .1 or .3
    { 192.168.2/24;
        { 192.168.2/24;
            { 192.168.1/24; 192.168.3/24; }; }; };
    // IF on class C 192.168.3 THEN use .3, or .1 or .2
    { 192.168.3/24;
        { 192.168.3/24;
            { 192.168.1/24; 192.168.2/24; }; }; };
    // IF .4 or .5 THEN prefer that net
    { { 192.168.4/24; 192.168.5/24; };
    };
};</programlisting>

          <para>
            The following example will give reasonable behavior for the
            local host and hosts on directly connected networks. It is similar
            to the behavior of the address sort in <acronym>BIND</acronym> 4.9.x. Responses sent
            to queries from the local host will favor any of the directly
            connected
            networks. Responses sent to queries from any other hosts on a
            directly
            connected network will prefer addresses on that same network.
            Responses
            to other queries will not be sorted.
          </para>

<programlisting>sortlist {
           { localhost; localnets; };
           { localnets; };
};
</programlisting>

        </sect3>
        <sect3 id="rrset_ordering">
          <title id="rrset_ordering_title">RRset Ordering</title>
          <para>
            When multiple records are returned in an answer it may be
            useful to configure the order of the records placed into the
            response.
            The <command>rrset-order</command> statement permits
            configuration
            of the ordering of the records in a multiple record response.
            See also the <command>sortlist</command> statement,
            <xref linkend="the_sortlist_statement"/>.
          </para>

          <para>
            An <command>order_spec</command> is defined as
            follows:
          </para>
          <para>
	    <optional>class <replaceable>class_name</replaceable></optional>
            <optional>type <replaceable>type_name</replaceable></optional>
            <optional>name <replaceable>"domain_name"</replaceable></optional>
	    order <replaceable>ordering</replaceable>
	  </para>
          <para>
            If no class is specified, the default is <command>ANY</command>.
            If no type is specified, the default is <command>ANY</command>.
            If no name is specified, the default is "<command>*</command>" (asterisk).
          </para>
          <para>
            The legal values for <command>ordering</command> are:
          </para>
          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="0.750in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="3.750in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>fixed</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Records are returned in the order they
                      are defined in the zone file.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>random</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Records are returned in some random order.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>cyclic</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Records are returned in a cyclic round-robin order.
                    </para>
                    <para>
                      If <acronym>BIND</acronym> is configured with the
                      "--enable-fixed-rrset" option at compile time, then
                      the initial ordering of the RRset will match the
                      one specified in the zone file.
                    </para>
                  </entry>
                </row>
              </tbody>
            </tgroup>
          </informaltable>
          <para>
            For example:
          </para>

<programlisting>rrset-order {
   class IN type A name "host.example.com" order random;
   order cyclic;
};
</programlisting>

          <para>
            will cause any responses for type A records in class IN that
            have "<literal>host.example.com</literal>" as a
            suffix, to always be returned
            in random order. All other records are returned in cyclic order.
          </para>
          <para>
            If multiple <command>rrset-order</command> statements
            appear, they are not combined &mdash; the last one applies.
          </para>
          <para>
            By default, all records are returned in random order.
          </para>

          <note>
            <simpara>
              In this release of <acronym>BIND</acronym> 9, the
              <command>rrset-order</command> statement does not support
              "fixed" ordering by default.  Fixed ordering can be enabled
              at compile time by specifying "--enable-fixed-rrset" on
              the "configure" command line.
            </simpara>
          </note>
        </sect3>

        <sect3 id="tuning">
          <title>Tuning</title>

          <variablelist>

            <varlistentry>
              <term><command>lame-ttl</command></term>
              <listitem>
                <para>
                  Sets the number of seconds to cache a
                  lame server indication. 0 disables caching. (This is
                  <emphasis role="bold">NOT</emphasis> recommended.)
                  The default is <literal>600</literal> (10 minutes) and the
                  maximum value is
                  <literal>1800</literal> (30 minutes).
                </para>

		<para>
		  Lame-ttl also controls the amount of time DNSSEC
		  validation failures are cached.  There is a minimum
		  of 30 seconds applied to bad cache entries if the
		  lame-ttl is set to less than 30 seconds.
		</para>

              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-ncache-ttl</command></term>
              <listitem>
                <para>
                  To reduce network traffic and increase performance,
                  the server stores negative answers. <command>max-ncache-ttl</command> is
                  used to set a maximum retention time for these answers in
                  the server
                  in seconds. The default
                  <command>max-ncache-ttl</command> is <literal>10800</literal> seconds (3 hours).
                  <command>max-ncache-ttl</command> cannot exceed
                  7 days and will
                  be silently truncated to 7 days if set to a greater value.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-cache-ttl</command></term>
              <listitem>
                <para>
		  Sets the maximum time for which the server will
                  cache ordinary (positive) answers. The default is
                  one week (7 days).
		  A value of zero may cause all queries to return
		  SERVFAIL, because of lost caches of intermediate
		  RRsets (such as NS and glue AAAA/A records) in the
		  resolution process.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>min-roots</command></term>
              <listitem>
                <para>
                  The minimum number of root servers that
                  is required for a request for the root servers to be
                  accepted. The default
                  is <userinput>2</userinput>.
                </para>
                <note>
                  <simpara>
                    Not implemented in <acronym>BIND</acronym> 9.
                  </simpara>
                </note>
              </listitem>
            </varlistentry>

	    <varlistentry>
	      <term><command>sig-validity-interval</command></term>
	      <listitem>
		<para>
		  Specifies the number of days into the future when
		  DNSSEC signatures automatically generated as a
		  result of dynamic updates (<xref
		  linkend="dynamic_update"/>) will expire.  There
		  is an optional second field which specifies how
		  long before expiry that the signatures will be
		  regenerated.  If not specified, the signatures will
		  be regenerated at 1/4 of base interval.  The second
		  field is specified in days if the base interval is
		  greater than 7 days otherwise it is specified in hours.
		  The default base interval is <literal>30</literal> days
		  giving a re-signing interval of 7 1/2 days.  The maximum
		  values are 10 years (3660 days).
		</para>
		<para>
		  The signature inception time is unconditionally
		  set to one hour before the current time to allow
		  for a limited amount of clock skew.
		</para>
		<para>
		  The <command>sig-validity-interval</command>
		  should be, at least, several multiples of the SOA
		  expire interval to allow for reasonable interaction
		  between the various timer and expiry dates.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>sig-signing-nodes</command></term>
	      <listitem>
		<para>
		  Specify the maximum number of nodes to be
		  examined in each quantum when signing a zone with
		  a new DNSKEY. The default is
		  <literal>100</literal>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>sig-signing-signatures</command></term>
	      <listitem>
		<para>
		  Specify a threshold number of signatures that
		  will terminate processing a quantum when signing
		  a zone with a new DNSKEY.  The default is
		  <literal>10</literal>.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>sig-signing-type</command></term>
	      <listitem>
		<para>
		  Specify a private RDATA type to be used when generating
		  key signing records.  The default is
		  <literal>65534</literal>.
		</para>
		<para>
		  It is expected that this parameter may be removed
		  in a future version once there is a standard type.
		</para>
		<para>
		  These records can be removed from the zone once named
		  has completed signing the zone with the matching key
		  using <command>nsupdate</command> or
		  <command>rndc signing -clear</command>.
		  <command>rndc signing -clear</command> is the only supported
		  way to remove these records from
		  <command>inline-signing</command> zones.
		</para>
	      </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>min-refresh-time</command></term>
              <term><command>max-refresh-time</command></term>
              <term><command>min-retry-time</command></term>
              <term><command>max-retry-time</command></term>
              <listitem>
                <para>
                  These options control the server's behavior on refreshing a
                  zone
                  (querying for SOA changes) or retrying failed transfers.
                  Usually the SOA values for the zone are used, but these
                  values
                  are set by the master, giving slave server administrators
                  little
                  control over their contents.
                </para>
                <para>
                  These options allow the administrator to set a minimum and
                  maximum
                  refresh and retry time either per-zone, per-view, or
                  globally.
                  These options are valid for slave and stub zones,
                  and clamp the SOA refresh and retry times to the specified
                  values.
                </para>
		<para>
		  The following defaults apply.
		  <command>min-refresh-time</command> 300 seconds,
		  <command>max-refresh-time</command> 2419200 seconds
		  (4 weeks), <command>min-retry-time</command> 500 seconds,
		  and <command>max-retry-time</command> 1209600 seconds
		  (2 weeks).
		</para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>edns-udp-size</command></term>
              <listitem>
                <para>
		  Sets the advertised EDNS UDP buffer size in bytes
                  to control the size of packets received.
                  Valid values are 512 to 4096 (values outside this range
		  will be silently adjusted).  The default value
		  is 4096.  The usual reason for setting
		  <command>edns-udp-size</command> to a non-default
		  value is to get UDP answers to pass through broken
		  firewalls that block fragmented packets and/or
		  block UDP packets that are greater than 512 bytes.
                </para>
		<para>
		  <command>named</command> will fallback to using 512 bytes
		  if it get a series of timeout at the initial value.  512
		  bytes is not being offered to encourage sites to fix their
	          firewalls.  Small EDNS UDP sizes will result in the
		  excessive use of TCP.
		</para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-udp-size</command></term>
	      <listitem>
		<para>
		  Sets the maximum EDNS UDP message size
		  <command>named</command> will send in bytes.
		  Valid values are 512 to 4096 (values outside this
		  range will be silently adjusted).  The default
		  value is 4096.  The usual reason for setting
		  <command>max-udp-size</command> to a non-default
		  value is to get UDP answers to pass through broken
		  firewalls that block fragmented packets and/or
		  block UDP packets that are greater than 512 bytes.
		  This is independent of the advertised receive
		  buffer (<command>edns-udp-size</command>).
		</para>
		<para>
		  Setting this to a low value will encourage additional
		  TCP traffic to the nameserver.
		</para>
	      </listitem>
	    </varlistentry>

	    <varlistentry>
	      <term><command>masterfile-format</command></term>
	      <listitem>
	        <para>Specifies
		  the file format of zone files (see
	          <xref linkend="zonefile_format"/>).
	          The default value is <constant>text</constant>, which is the
		  standard textual representation, except for slave zones,
                  in which the default value is <constant>raw</constant>.
                  Files in other formats than <constant>text</constant> are
                  typically expected to be generated by the
                  <command>named-compilezone</command> tool, or dumped by
                  <command>named</command>.
                </para>
                <para>
		  Note that when a zone file in a different format than
		  <constant>text</constant> is loaded, <command>named</command>
	          may omit some of the checks which would be performed for a
		  file in the <constant>text</constant> format.  In particular,
		  <command>check-names</command> checks do not apply
		  for the <constant>raw</constant> format.  This means
		  a zone file in the <constant>raw</constant> format
		  must be generated with the same check level as that
		  specified in the <command>named</command> configuration
		  file.  This statement sets the
		  <command>masterfile-format</command> for all zones,
		  but can be overridden on a per-zone or per-view basis
		  by including a <command>masterfile-format</command>
		  statement within the <command>zone</command> or
		  <command>view</command> block in the configuration
		  file.
	        </para>
	      </listitem>
	    </varlistentry>

	    <varlistentry id="clients-per-query">
	      <term><command>clients-per-query</command></term>
	      <term><command>max-clients-per-query</command></term>
              <listitem>
		<para>These set the
		  initial value (minimum) and maximum number of recursive
		  simultaneous clients for any given query
		  (&lt;qname,qtype,qclass&gt;) that the server will accept
		  before dropping additional clients.  <command>named</command> will attempt to
		  self tune this value and changes will be logged.  The
		  default values are 10 and 100.
		</para>
		<para>
	          This value should reflect how many queries come in for
		  a given name in the time it takes to resolve that name.
		  If the number of queries exceed this value, <command>named</command> will
		  assume that it is dealing with a non-responsive zone
		  and will drop additional queries.  If it gets a response
		  after dropping queries, it will raise the estimate.  The
		  estimate will then be lowered in 20 minutes if it has
		  remained unchanged.
		</para>
		<para>
		  If <command>clients-per-query</command> is set to zero,
		  then there is no limit on the number of clients per query
		  and no queries will be dropped.
		</para>
		<para>
		  If <command>max-clients-per-query</command> is set to zero,
		  then there is no upper bound other than imposed by
		  <command>recursive-clients</command>.
		</para>
              </listitem>
	    </varlistentry>

            <varlistentry>
              <term><command>notify-delay</command></term>
              <listitem>
                <para>
                  The delay, in seconds, between sending sets of notify
                  messages for a zone.  The default is five (5) seconds.
                </para>
                <para>
		  The overall rate that NOTIFY messages are sent for all
		  zones is controlled by <command>serial-query-rate</command>.
		</para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-rsa-exponent-size</command></term>
              <listitem>
                <para>
		  The maximum RSA exponent size, in bits, that will
		  be accepted when validating.  Valid values are 35
		  to 4096 bits.  The default zero (0) is also accepted
		  and is equivalent to 4096.
		</para>
              </listitem>
            </varlistentry>
	  </variablelist>

        </sect3>

        <sect3 id="builtin">
          <title>Built-in server information zones</title>

          <para>
            The server provides some helpful diagnostic information
            through a number of built-in zones under the
            pseudo-top-level-domain <literal>bind</literal> in the
            <command>CHAOS</command> class.  These zones are part
            of a
            built-in view (see <xref linkend="view_statement_grammar"/>) of
            class
            <command>CHAOS</command> which is separate from the
            default view of class <command>IN</command>. Most global
            configuration options (<command>allow-query</command>,
            etc) will apply to this view, but some are locally
            overridden: <command>notify</command>,
            <command>recursion</command> and
            <command>allow-new-zones</command> are
            always set to <userinput>no</userinput>.
          </para>
          <para>
            If you need to disable these zones, use the options
            below, or hide the built-in <command>CHAOS</command>
            view by
            defining an explicit view of class <command>CHAOS</command>
            that matches all clients.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>version</command></term>
              <listitem>
                <para>
                  The version the server should report
                  via a query of the name <literal>version.bind</literal>
                  with type <command>TXT</command>, class <command>CHAOS</command>.
                  The default is the real version number of this server.
                  Specifying <command>version none</command>
                  disables processing of the queries.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>hostname</command></term>
              <listitem>
                <para>
                  The hostname the server should report via a query of
                  the name <filename>hostname.bind</filename>
                  with type <command>TXT</command>, class <command>CHAOS</command>.
                  This defaults to the hostname of the machine hosting the
                  name server as
                  found by the gethostname() function.  The primary purpose of such queries
                  is to
                  identify which of a group of anycast servers is actually
                  answering your queries.  Specifying <command>hostname none;</command>
                  disables processing of the queries.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>server-id</command></term>
              <listitem>
                <para>
                  The ID the server should report when receiving a Name
                  Server Identifier (NSID) query, or a query of the name
                  <filename>ID.SERVER</filename> with type
                  <command>TXT</command>, class <command>CHAOS</command>.
                  The primary purpose of such queries is to
                  identify which of a group of anycast servers is actually
                  answering your queries.  Specifying <command>server-id none;</command>
                  disables processing of the queries.
                  Specifying <command>server-id hostname;</command> will cause <command>named</command> to
                  use the hostname as found by the gethostname() function.
                  The default <command>server-id</command> is <command>none</command>.
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3 id="empty">
          <title>Built-in Empty Zones</title>
	  <para>
	    Named has some built-in empty zones (SOA and NS records only).
	    These are for zones that should normally be answered locally
	    and which queries should not be sent to the Internet's root
	    servers.  The official servers which cover these namespaces
	    return NXDOMAIN responses to these queries.  In particular,
            these cover the reverse namespaces for addresses from
            RFC 1918, RFC 4193, RFC 5737 and RFC 6598.  They also include the
            reverse namespace for IPv6 local address (locally assigned),
            IPv6 link local addresses, the IPv6 loopback address and the
            IPv6 unknown address.
	  </para>
	  <para>
	    Named will attempt to determine if a built-in zone already exists
	    or is active (covered by a forward-only forwarding declaration)
	    and will not create an empty zone in that case.
	  </para>
	  <para>
	    The current list of empty zones is:
	    <itemizedlist>
	      <listitem>10.IN-ADDR.ARPA</listitem>
	      <listitem>16.172.IN-ADDR.ARPA</listitem>
	      <listitem>17.172.IN-ADDR.ARPA</listitem>
	      <listitem>18.172.IN-ADDR.ARPA</listitem>
	      <listitem>19.172.IN-ADDR.ARPA</listitem>
	      <listitem>20.172.IN-ADDR.ARPA</listitem>
	      <listitem>21.172.IN-ADDR.ARPA</listitem>
	      <listitem>22.172.IN-ADDR.ARPA</listitem>
	      <listitem>23.172.IN-ADDR.ARPA</listitem>
	      <listitem>24.172.IN-ADDR.ARPA</listitem>
	      <listitem>25.172.IN-ADDR.ARPA</listitem>
	      <listitem>26.172.IN-ADDR.ARPA</listitem>
	      <listitem>27.172.IN-ADDR.ARPA</listitem>
	      <listitem>28.172.IN-ADDR.ARPA</listitem>
	      <listitem>29.172.IN-ADDR.ARPA</listitem>
	      <listitem>30.172.IN-ADDR.ARPA</listitem>
	      <listitem>31.172.IN-ADDR.ARPA</listitem>
	      <listitem>168.192.IN-ADDR.ARPA</listitem>
	      <listitem>64.100.IN-ADDR.ARPA</listitem>
	      <listitem>65.100.IN-ADDR.ARPA</listitem>
	      <listitem>66.100.IN-ADDR.ARPA</listitem>
	      <listitem>67.100.IN-ADDR.ARPA</listitem>
	      <listitem>68.100.IN-ADDR.ARPA</listitem>
	      <listitem>69.100.IN-ADDR.ARPA</listitem>
	      <listitem>70.100.IN-ADDR.ARPA</listitem>
	      <listitem>71.100.IN-ADDR.ARPA</listitem>
	      <listitem>72.100.IN-ADDR.ARPA</listitem>
	      <listitem>73.100.IN-ADDR.ARPA</listitem>
	      <listitem>74.100.IN-ADDR.ARPA</listitem>
	      <listitem>75.100.IN-ADDR.ARPA</listitem>
	      <listitem>76.100.IN-ADDR.ARPA</listitem>
	      <listitem>77.100.IN-ADDR.ARPA</listitem>
	      <listitem>78.100.IN-ADDR.ARPA</listitem>
	      <listitem>79.100.IN-ADDR.ARPA</listitem>
	      <listitem>80.100.IN-ADDR.ARPA</listitem>
	      <listitem>81.100.IN-ADDR.ARPA</listitem>
	      <listitem>82.100.IN-ADDR.ARPA</listitem>
	      <listitem>83.100.IN-ADDR.ARPA</listitem>
	      <listitem>84.100.IN-ADDR.ARPA</listitem>
	      <listitem>85.100.IN-ADDR.ARPA</listitem>
	      <listitem>86.100.IN-ADDR.ARPA</listitem>
	      <listitem>87.100.IN-ADDR.ARPA</listitem>
	      <listitem>88.100.IN-ADDR.ARPA</listitem>
	      <listitem>89.100.IN-ADDR.ARPA</listitem>
	      <listitem>90.100.IN-ADDR.ARPA</listitem>
	      <listitem>91.100.IN-ADDR.ARPA</listitem>
	      <listitem>92.100.IN-ADDR.ARPA</listitem>
	      <listitem>93.100.IN-ADDR.ARPA</listitem>
	      <listitem>94.100.IN-ADDR.ARPA</listitem>
	      <listitem>95.100.IN-ADDR.ARPA</listitem>
	      <listitem>96.100.IN-ADDR.ARPA</listitem>
	      <listitem>97.100.IN-ADDR.ARPA</listitem>
	      <listitem>98.100.IN-ADDR.ARPA</listitem>
	      <listitem>99.100.IN-ADDR.ARPA</listitem>
	      <listitem>100.100.IN-ADDR.ARPA</listitem>
	      <listitem>101.100.IN-ADDR.ARPA</listitem>
	      <listitem>102.100.IN-ADDR.ARPA</listitem>
	      <listitem>103.100.IN-ADDR.ARPA</listitem>
	      <listitem>104.100.IN-ADDR.ARPA</listitem>
	      <listitem>105.100.IN-ADDR.ARPA</listitem>
	      <listitem>106.100.IN-ADDR.ARPA</listitem>
	      <listitem>107.100.IN-ADDR.ARPA</listitem>
	      <listitem>108.100.IN-ADDR.ARPA</listitem>
	      <listitem>109.100.IN-ADDR.ARPA</listitem>
	      <listitem>110.100.IN-ADDR.ARPA</listitem>
	      <listitem>111.100.IN-ADDR.ARPA</listitem>
	      <listitem>112.100.IN-ADDR.ARPA</listitem>
	      <listitem>113.100.IN-ADDR.ARPA</listitem>
	      <listitem>114.100.IN-ADDR.ARPA</listitem>
	      <listitem>115.100.IN-ADDR.ARPA</listitem>
	      <listitem>116.100.IN-ADDR.ARPA</listitem>
	      <listitem>117.100.IN-ADDR.ARPA</listitem>
	      <listitem>118.100.IN-ADDR.ARPA</listitem>
	      <listitem>119.100.IN-ADDR.ARPA</listitem>
	      <listitem>120.100.IN-ADDR.ARPA</listitem>
	      <listitem>121.100.IN-ADDR.ARPA</listitem>
	      <listitem>122.100.IN-ADDR.ARPA</listitem>
	      <listitem>123.100.IN-ADDR.ARPA</listitem>
	      <listitem>124.100.IN-ADDR.ARPA</listitem>
	      <listitem>125.100.IN-ADDR.ARPA</listitem>
	      <listitem>126.100.IN-ADDR.ARPA</listitem>
	      <listitem>127.100.IN-ADDR.ARPA</listitem>
	      <listitem>0.IN-ADDR.ARPA</listitem>
	      <listitem>127.IN-ADDR.ARPA</listitem>
	      <listitem>254.169.IN-ADDR.ARPA</listitem>
	      <listitem>2.0.192.IN-ADDR.ARPA</listitem>
	      <listitem>100.51.198.IN-ADDR.ARPA</listitem>
	      <listitem>113.0.203.IN-ADDR.ARPA</listitem>
	      <listitem>255.255.255.255.IN-ADDR.ARPA</listitem>
	      <listitem>0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.IP6.ARPA</listitem>
	      <listitem>1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.IP6.ARPA</listitem>
	      <listitem>8.B.D.0.1.0.0.2.IP6.ARPA</listitem>
	      <listitem>D.F.IP6.ARPA</listitem>
	      <listitem>8.E.F.IP6.ARPA</listitem>
	      <listitem>9.E.F.IP6.ARPA</listitem>
	      <listitem>A.E.F.IP6.ARPA</listitem>
	      <listitem>B.E.F.IP6.ARPA</listitem>
	    </itemizedlist>
	  </para>
	  <para>
	    Empty zones are settable at the view level and only apply to
	    views of class IN.  Disabled empty zones are only inherited
	    from options if there are no disabled empty zones specified
	    at the view level.  To override the options list of disabled
	    zones, you can disable the root zone at the view level, for example:
<programlisting>
	    disable-empty-zone ".";
</programlisting>
	  </para>
	  <para>
	    If you are using the address ranges covered here, you should
	    already have reverse zones covering the addresses you use.
	    In practice this appears to not be the case with many queries
	    being made to the infrastructure servers for names in these
	    spaces.  So many in fact that sacrificial servers were needed
	    to be deployed to channel the query load away from the
	    infrastructure servers.
	  </para>
	  <note>
	    The real parent servers for these zones should disable all
	    empty zone under the parent zone they serve.  For the real
	    root servers, this is all built-in empty zones.  This will
	    enable them to return referrals to deeper in the tree.
	  </note>
          <variablelist>
	    <varlistentry>
	      <term><command>empty-server</command></term>
	      <listitem>
	        <para>
		  Specify what server name will appear in the returned
		  SOA record for empty zones.  If none is specified, then
		  the zone's name will be used.
	        </para>
	       </listitem>
	    </varlistentry>
	      
	    <varlistentry>
	      <term><command>empty-contact</command></term>
	      <listitem>
	        <para>
		  Specify what contact name will appear in the returned
		  SOA record for empty zones.  If none is specified, then
		  "." will be used.
	        </para>
	      </listitem>
	    </varlistentry>
  
	    <varlistentry>
	      <term><command>empty-zones-enable</command></term>
	      <listitem>
	        <para>
		  Enable or disable all empty zones.  By default, they
		  are enabled.
	        </para>
	      </listitem>
	    </varlistentry>
  
	    <varlistentry>
	    <term><command>disable-empty-zone</command></term>
	      <listitem>
	        <para>
		  Disable individual empty zones.  By default, none are
		  disabled.  This option can be specified multiple times.
	        </para>
	      </listitem>
	    </varlistentry>
          </variablelist>
        </sect3>

        <sect3 id="acache">
          <title>Additional Section Caching</title>

          <para>
            The additional section cache, also called <command>acache</command>,
            is an internal cache to improve the response performance of BIND 9.
            When additional section caching is enabled, BIND 9 will
            cache an internal short-cut to the additional section content for
            each answer RR.
            Note that <command>acache</command> is an internal caching
            mechanism of BIND 9, and is not related to the DNS caching
            server function.
          </para>

          <para>
            Additional section caching does not change the
            response content (except the RRsets ordering of the additional
            section, see below), but can improve the response performance
            significantly.
            It is particularly effective when BIND 9 acts as an authoritative
            server for a zone that has many delegations with many glue RRs.
          </para>

          <para>
            In order to obtain the maximum performance improvement
            from additional section caching, setting
            <command>additional-from-cache</command>
            to <command>no</command> is recommended, since the current
            implementation of <command>acache</command>
            does not short-cut of additional section information from the
            DNS cache data.
          </para>

          <para>
            One obvious disadvantage of <command>acache</command> is
            that it requires much more
            memory for the internal cached data.
            Thus, if the response performance does not matter and memory
            consumption is much more critical, the
            <command>acache</command> mechanism can be
            disabled by setting <command>acache-enable</command> to
            <command>no</command>.
            It is also possible to specify the upper limit of memory
            consumption
            for acache by using <command>max-acache-size</command>.
          </para>

          <para>
            Additional section caching also has a minor effect on the
            RRset ordering in the additional section.
            Without <command>acache</command>,
            <command>cyclic</command> order is effective for the additional
            section as well as the answer and authority sections.
            However, additional section caching fixes the ordering when it
            first caches an RRset for the additional section, and the same
            ordering will be kept in succeeding responses, regardless of the
            setting of <command>rrset-order</command>.
            The effect of this should be minor, however, since an
            RRset in the additional section
            typically only contains a small number of RRs (and in many cases
            it only contains a single RR), in which case the
            ordering does not matter much.
          </para>

          <para>
            The following is a summary of options related to
            <command>acache</command>.
          </para>

          <variablelist>

            <varlistentry>
              <term><command>acache-enable</command></term>
              <listitem>
                <para>
                  If <command>yes</command>, additional section caching is
		  enabled.  The default value is <command>no</command>.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>acache-cleaning-interval</command></term>
              <listitem>
                <para>
                  The server will remove stale cache entries, based on an LRU
                  based
                  algorithm, every <command>acache-cleaning-interval</command> minutes.
                  The default is 60 minutes.
                  If set to 0, no periodic cleaning will occur.
                </para>
              </listitem>
            </varlistentry>

            <varlistentry>
              <term><command>max-acache-size</command></term>
              <listitem>
                <para>
                  The maximum amount of memory in bytes to use for the server's acache.
                  When the amount of data in the acache reaches this limit,
                  the server
                  will clean more aggressively so that the limit is not
                  exceeded.
                  In a server with multiple views, the limit applies
                  separately to the
                  acache of each view.
                  The default is <literal>16M</literal>.
                </para>
              </listitem>
            </varlistentry>

          </variablelist>

        </sect3>

        <sect3>
          <title>Content Filtering</title>
	  <para>
	    <acronym>BIND</acronym> 9 provides the ability to filter
	    out DNS responses from external DNS servers containing
	    certain types of data in the answer section.
	    Specifically, it can reject address (A or AAAA) records if
	    the corresponding IPv4 or IPv6 addresses match the given
	    <varname>address_match_list</varname> of the
	    <command>deny-answer-addresses</command> option.
	    It can also reject CNAME or DNAME records if the "alias"
	    name (i.e., the CNAME alias or the substituted query name
	    due to DNAME) matches the
	    given <varname>namelist</varname> of the
	    <command>deny-answer-aliases</command> option, where
	    "match" means the alias name is a subdomain of one of
	    the <varname>name_list</varname> elements.
	    If the optional <varname>namelist</varname> is specified
	    with <command>except-from</command>, records whose query name
	    matches the list will be accepted regardless of the filter
	    setting.
	    Likewise, if the alias name is a subdomain of the
	    corresponding zone, the <command>deny-answer-aliases</command>
	    filter will not apply;
	    for example, even if "example.com" is specified for
	    <command>deny-answer-aliases</command>,
	  </para>
<programlisting>www.example.com. CNAME xxx.example.com.</programlisting>

	  <para>
	    returned by an "example.com" server will be accepted.
	  </para>

	  <para>
	    In the <varname>address_match_list</varname> of the
	    <command>deny-answer-addresses</command> option, only
            <varname>ip_addr</varname>
	    and <varname>ip_prefix</varname>
	    are meaningful;
	    any <varname>key_id</varname> will be silently ignored.
	  </para>

	  <para>
	    If a response message is rejected due to the filtering,
	    the entire message is discarded without being cached, and
	    a SERVFAIL error will be returned to the client.
	  </para>

	  <para>
	    This filtering is intended to prevent "DNS rebinding attacks," in
	    which an attacker, in response to a query for a domain name the
	    attacker controls, returns an IP address within your own network or
	    an alias name within your own domain.
	    A naive web browser or script could then serve as an
	    unintended proxy, allowing the attacker
	    to get access to an internal node of your local network
	    that couldn't be externally accessed otherwise.
	    See the paper available at
	    <ulink url="http://portal.acm.org/citation.cfm?id=1315245.1315298">
	    http://portal.acm.org/citation.cfm?id=1315245.1315298
	    </ulink>
	    for more details about the attacks.
	  </para>

	  <para>
	    For example, if you own a domain named "example.net" and
	    your internal network uses an IPv4 prefix 192.0.2.0/24,
	    you might specify the following rules:
	  </para>

<programlisting>deny-answer-addresses { 192.0.2.0/24; } except-from { "example.net"; };
deny-answer-aliases { "example.net"; };
</programlisting>

	  <para>
	    If an external attacker lets a web browser in your local
	    network look up an IPv4 address of "attacker.example.com",
	    the attacker's DNS server would return a response like this:
	  </para>

<programlisting>attacker.example.com. A 192.0.2.1</programlisting>

	  <para>
	    in the answer section.
	    Since the rdata of this record (the IPv4 address) matches
	    the specified prefix 192.0.2.0/24, this response will be
	    ignored.
	  </para>

	  <para>
	    On the other hand, if the browser looks up a legitimate
	    internal web server "www.example.net" and the
	    following response is returned to
	    the <acronym>BIND</acronym> 9 server
	  </para>

<programlisting>www.example.net. A 192.0.2.2</programlisting>

	  <para>
	    it will be accepted since the owner name "www.example.net"
	    matches the <command>except-from</command> element,
	    "example.net".
	  </para>

	  <para>
	    Note that this is not really an attack on the DNS per se.
	    In fact, there is nothing wrong for an "external" name to
	    be mapped to your "internal" IP address or domain name
	    from the DNS point of view.
	    It might actually be provided for a legitimate purpose,
	    such as for debugging.
	    As long as the mapping is provided by the correct owner,
	    it is not possible or does not make sense to detect
	    whether the intent of the mapping is legitimate or not
	    within the DNS.
	    The "rebinding" attack must primarily be protected at the
	    application that uses the DNS.
	    For a large site, however, it may be difficult to protect
	    all possible applications at once.
	    This filtering feature is provided only to help such an
	    operational environment;
	    it is generally discouraged to turn it on unless you are
	    very sure you have no other choice and the attack is a
	    real threat for your applications.
	  </para>

	  <para>
	    Care should be particularly taken if you want to use this
	    option for addresses within 127.0.0.0/8.
	    These addresses are obviously "internal", but many
	    applications conventionally rely on a DNS mapping from
	    some name to such an address.
	    Filtering out DNS records containing this address
	    spuriously can break such applications.
	  </para>
	</sect3>

        <sect3>
	  <title>Response Policy Zone (RPZ) Rewriting</title>
	  <para>
	    <acronym>BIND</acronym> 9 includes a limited
	    mechanism to modify DNS responses for requests
	    analogous to email anti-spam DNS blacklists.
	    Responses can be changed to deny the existence of domains(NXDOMAIN),
	    deny the existence of IP addresses for domains (NODATA),
	    or contain other IP addresses or data.
	  </para>

	  <para>
	    Response policy zones are named in the
	    <command>response-policy</command> option for the view or among the
	    global options if there is no response-policy option for the view.
	    RPZs are ordinary DNS zones containing RRsets
	    that can be queried normally if allowed.
	    It is usually best to restrict those queries with something like
	    <command>allow-query { localhost; };</command>.
	  </para>

	  <para>
	    Four policy triggers are encoded in RPZ records, QNAME, IP, NSIP,
	    and NSDNAME.
	    QNAME RPZ records triggered by query names of requests and targets
	    of CNAME records resolved to generate the response.
	    The owner name of a QNAME RPZ record is the query name relativized
	    to the RPZ.
	  </para>

	  <para>
	    The second kind of RPZ trigger is an IP address in an A and AAAA
	    record in the ANSWER section of a response.
	    IP address triggers are encoded in records that have owner names
	    that are subdomains of <userinput>rpz-ip</userinput> relativized
	    to the RPZ origin name and encode an IP address or address block.
	    IPv4 trigger addresses are represented as
	    <userinput>prefixlength.B4.B3.B2.B1.rpz-ip</userinput>.
	    The prefix length must be between 1 and 32.
	    All four bytes, B4, B3, B2, and B1, must be present.
	    B4 is the decimal value of the least significant byte of the
	    IPv4 address as in IN-ADDR.ARPA.
	    IPv6 addresses are encoded in a format similar to the standard
	    IPv6 text representation,
	    <userinput>prefixlength.W8.W7.W6.W5.W4.W3.W2.W1.rpz-ip</userinput>.
	    Each of W8,...,W1 is a one to four digit hexadecimal number
	    representing 16 bits of the IPv6 address as in the standard text
	    representation of IPv6 addresses, but reversed as in IN-ADDR.ARPA.
	    All 8 words must be present except when consecutive
	    zero words are replaced with <userinput>.zz.</userinput>
	    analogous to double colons (::) in standard IPv6 text encodings.
	    The prefix length must be between 1 and 128.
	  </para>

	  <para>
	    NSDNAME triggers match names of authoritative servers
	    for the query name, a parent of the query name, a CNAME for
	    query name, or a parent of a CNAME.
	    They are encoded as subdomains of
	    <userinput>rpz-nsdomain</userinput> relativized
	    to the RPZ origin name.
	    NSIP triggers match IP addresses in A and
	    AAAA RRsets for domains that can be checked against NSDNAME
	    policy records.
	    NSIP triggers are encoded like IP triggers except as subdomains of
	    <userinput>rpz-nsip</userinput>.
	    NSDNAME and NSIP triggers are checked only for names with at
	    least <command>min-ns-dots</command> dots.
	    The default value of <command>min-ns-dots</command> is 1 to
	    exclude top level domains.
	  </para>

	  <para>
	    The query response is checked against all RPZs, so
	    two or more policy records can be triggered by a response.
	    Because DNS responses can be rewritten according to at most one
	    policy record, a single record encoding an action (other than
	    <command>DISABLED</command> actions) must be chosen.
	    Triggers or the records that encode them are chosen in
	    the following order:
	    <itemizedlist>
	      <listitem>Choose the triggered record in the zone that appears
		first in the response-policy option.
	      </listitem>
	      <listitem>Prefer QNAME to IP to NSDNAME to NSIP triggers
		in a single zone.
	      </listitem>
	      <listitem>Among NSDNAME triggers, prefer the
		trigger that matches the smallest name under the DNSSEC ordering.
	      </listitem>
	      <listitem>Among IP or NSIP triggers, prefer the trigger
		with the longest prefix.
	      </listitem>
	      <listitem>Among triggers with the same prefex length,
		prefer the IP or NSIP trigger that matches
		the smallest IP address.
	      </listitem>
	    </itemizedlist>
	  </para>

	  <para>
	    When the processing of a response is restarted to resolve
	    DNAME or CNAME records and a policy record set has
	    not been triggered,
	    all RPZs are again consulted for the DNAME or CNAME names
	    and addresses.
	  </para>

	  <para>
	    RPZ record sets are sets of any types of DNS record except
	    DNAME or DNSSEC that encode actions or responses to queries.
	    <itemizedlist>
	      <listitem>The <command>NXDOMAIN</command> response is encoded
		by a CNAME whose target is the root domain (.)
	      </listitem>
	      <listitem>A CNAME whose target is the wildcard top-level
		domain (*.) specifies the <command>NODATA</command> action,
		which rewrites the response to NODATA or ANCOUNT=1.
	      </listitem>
	      <listitem>The <command>Local Data</command> action is
		represented by a set ordinary DNS records that are used
		to answer queries.  Queries for record types not the
		set are answered with NODATA.

		A special form of local data is a CNAME whose target is a
		wildcard such as *.example.com.
		It is used as if were an ordinary CNAME after the astrisk (*)
		has been replaced with the query name.
		The purpose for this special form is query logging in the
		walled garden's authority DNS server.
	      </listitem>
	      <listitem>The <command>PASSTHRU</command> policy is specified
		by a CNAME whose target is <command>rpz-passthru.</command>
		It causes the response to not be rewritten
		and is most often used to "poke holes" in policies for
		CIDR blocks.
		(A CNAME whose target is the variable part of its owner name
		is an obsolete specification of the PASSTHRU policy.)
	      </listitem>
	    </itemizedlist>
	  </para>

	  <para>
	    The actions specified in an RPZ can be overridden with a
	    <command>policy</command> clause in the
	    <command>response-policy</command> option.
	    An organization using an RPZ provided by another organization might
	    use this mechanism to redirect domains to its own walled garden.
	    <itemizedlist>
	      <listitem><command>GIVEN</command> says "do not override but
		perform the action specified in the zone."
	      </listitem>
	      <listitem><command>DISABLED</command> causes policy records to do
		nothing but log what they might have done.
		The response to the DNS query will be written according to
		any triggered policy records that are not disabled.
		Disabled policy zones should appear first,
		because they will often not be logged
		if a higher precedence trigger is found first.
	      </listitem>
	      <listitem><command>PASSTHRU</command> causes all policy records
		to act as if they were CNAME records with targets the variable
		part of their owner name.  They protect the response from
		being changed.
	      </listitem>
	      <listitem><command>NXDOMAIN</command> causes all RPZ records
		to specify NXDOMAIN policies.
	      </listitem>
	      <listitem><command>NODATA</command> overrides with the
		NODATA policy
	      </listitem>
	      <listitem><command>CNAME domain</command> causes all RPZ
		policy records to act as if they were "cname domain" records.
	      </listitem>
	    </itemizedlist>
	  </para>

	  <para>
	    By default, the actions encoded in an RPZ are applied
	    only to queries that ask for recursion (RD=1).
	    That default can be changed for a single RPZ or all RPZs in a view
	    with a <command>recursive-only no</command> clause.
	    This feature is useful for serving the same zone files
	    both inside and outside an RFC 1918 cloud and using RPZ to
	    delete answers that would otherwise contain RFC 1918 values
	    on the externally visible name server or view.
	  </para>

	  <para>
	    Also by default, RPZ actions are applied only to DNS requests that
	    either do not request DNSSEC metadata (DO=0) or when no DNSSEC
	    records are available for request name in the original zone (not
	    the response policy zone).
	    This default can be changed for all RPZs in a view with a
	    <command>break-dnssec yes</command> clause.
	    In that case, RPZ actions are applied regardless of DNSSEC.
	    The name of the clause option reflects the fact that results
	    rewritten by RPZ actions cannot verify.
	  </para>

	  <para>
	    The TTL of a record modified by RPZ policies is set from the
	    TTL of the relevant record in policy zone.  It is then limited
	    to a maximum value.
	    The <command>max-policy-ttl</command> clause changes that
	    maximum from its default of 5.
	  </para>

	  <para>
	    For example, you might use this option statement
          </para>
<programlisting>    response-policy { zone "badlist"; };</programlisting>
          <para>
            and this zone statement
          </para>
<programlisting>    zone "badlist" {type master; file "master/badlist"; allow-query {none;}; };</programlisting>
          <para>
            with this zone file
          </para>
<programlisting>$TTL 1H
@                       SOA LOCALHOST. named-mgr.example.com (1 1h 15m 30d 2h)
                        NS  LOCALHOST.

; QNAME policy records.  There are no periods (.) after the owner names.
nxdomain.domain.com     CNAME   .               ; NXDOMAIN policy
nodata.domain.com       CNAME   *.              ; NODATA policy
bad.domain.com          A       10.0.0.1        ; redirect to a walled garden
                        AAAA    2001:2::1

; do not rewrite (PASSTHRU) OK.DOMAIN.COM
ok.domain.com           CNAME   rpz-passthru.

bzone.domain.com        CNAME   garden.example.com.

; redirect x.bzone.domain.com to x.bzone.domain.com.garden.example.com
*.bzone.domain.com      CNAME   *.garden.example.com.


; IP policy records that rewrite all answers for 127/8 except 127.0.0.1
8.0.0.0.127.rpz-ip      CNAME   .
32.1.0.0.127.rpz-ip     CNAME   rpz-passthru.

; NSDNAME and NSIP policy records
ns.domain.com.rpz-nsdname   CNAME   .
48.zz.2.2001.rpz-nsip       CNAME   .
</programlisting>
          <para>
            RPZ can affect server performance.
            Each configured response policy zone requires the server to
            perform one to four additional database lookups before a
            query can be answered.
            For example, a DNS server with four policy zones, each with all
            four kinds of response triggers, QNAME, IP, NSIP, and
            NSDNAME, requires a total of 17 times as many database
            lookups as a similar DNS server with no response policy zones.
            A <acronym>BIND9</acronym> server with adequate memory and one
            response policy zone with QNAME and IP triggers might achieve a
            maximum queries-per-second rate about 20% lower.
            A server with four response policy zones with QNAME and IP
            triggers might have a maximum QPS rate about 50% lower.
          </para>

          <para>
            Responses rewritten by RPZ are counted in the
            <command>RPZRewrites</command> statistics.
          </para>
        </sect3>
      </sect2>

      <sect2 id="server_statement_grammar">
        <title><command>server</command> Statement Grammar</title>

<programlisting><command>server</command> <replaceable>ip_addr[/prefixlen]</replaceable> {
    <optional> bogus <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> provide-ixfr <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> request-ixfr <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> edns <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> edns-udp-size <replaceable>number</replaceable> ; </optional>
    <optional> max-udp-size <replaceable>number</replaceable> ; </optional>
    <optional> transfers <replaceable>number</replaceable> ; </optional>
    <optional> transfer-format <replaceable>( one-answer | many-answers )</replaceable> ; ]</optional>
    <optional> keys <replaceable>{ string ; <optional> string ; <optional>...</optional></optional> }</replaceable> ; </optional>
    <optional> transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> query-source <optional> address ( <replaceable>ip_addr</replaceable> | <replaceable>*</replaceable> ) </optional>
                  <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional>; </optional>
    <optional> query-source-v6 <optional> address ( <replaceable>ip_addr</replaceable> | <replaceable>*</replaceable> ) </optional>
                     <optional> port ( <replaceable>ip_port</replaceable> | <replaceable>*</replaceable> ) </optional>; </optional>
    <optional> use-queryport-pool <replaceable>yes_or_no</replaceable>; </optional>
    <optional> queryport-pool-ports <replaceable>number</replaceable>; </optional>
    <optional> queryport-pool-updateinterval <replaceable>number</replaceable>; </optional>
};
</programlisting>

        </sect2>

        <sect2 id="server_statement_definition_and_usage">
          <title><command>server</command> Statement Definition and
            Usage</title>

          <para>
            The <command>server</command> statement defines
            characteristics
            to be associated with a remote name server.  If a prefix length is
            specified, then a range of servers is covered.  Only the most
            specific
            server clause applies regardless of the order in
            <filename>named.conf</filename>.
          </para>

          <para>
            The <command>server</command> statement can occur at
            the top level of the
            configuration file or inside a <command>view</command>
            statement.
            If a <command>view</command> statement contains
            one or more <command>server</command> statements, only
            those
            apply to the view and any top-level ones are ignored.
            If a view contains no <command>server</command>
            statements,
            any top-level <command>server</command> statements are
            used as
            defaults.
          </para>

          <para>
            If you discover that a remote server is giving out bad data,
            marking it as bogus will prevent further queries to it. The
            default
            value of <command>bogus</command> is <command>no</command>.
          </para>
          <para>
            The <command>provide-ixfr</command> clause determines
            whether
            the local server, acting as master, will respond with an
            incremental
            zone transfer when the given remote server, a slave, requests it.
            If set to <command>yes</command>, incremental transfer
            will be provided
            whenever possible. If set to <command>no</command>,
            all transfers
            to the remote server will be non-incremental. If not set, the
            value
            of the <command>provide-ixfr</command> option in the
            view or
            global options block is used as a default.
          </para>

          <para>
            The <command>request-ixfr</command> clause determines
            whether
            the local server, acting as a slave, will request incremental zone
            transfers from the given remote server, a master. If not set, the
            value of the <command>request-ixfr</command> option in
            the view or global options block is used as a default. It may
            also be set in the zone block and, if set there, it will
            override the global or view setting for that zone.
          </para>

          <para>
            IXFR requests to servers that do not support IXFR will
            automatically
            fall back to AXFR.  Therefore, there is no need to manually list
            which servers support IXFR and which ones do not; the global
            default
            of <command>yes</command> should always work.
            The purpose of the <command>provide-ixfr</command> and
            <command>request-ixfr</command> clauses is
            to make it possible to disable the use of IXFR even when both
            master
            and slave claim to support it, for example if one of the servers
            is buggy and crashes or corrupts data when IXFR is used.
          </para>

          <para>
            The <command>edns</command> clause determines whether
            the local server will attempt to use EDNS when communicating
	    with the remote server.  The default is <command>yes</command>.
          </para>

          <para>
            The <command>edns-udp-size</command> option sets the EDNS UDP size
	    that is advertised by <command>named</command> when querying the remote server.
	    Valid values are 512 to 4096 bytes (values outside this range will be
	    silently adjusted).  This option is useful when you wish to
	    advertises a different value to this server than the value you
	    advertise globally, for example, when there is a firewall at the
	    remote site that is blocking large replies.
          </para>

          <para>
	    The <command>max-udp-size</command> option sets the
	    maximum EDNS UDP message size <command>named</command> will send.  Valid
	    values are 512 to 4096 bytes (values outside this range will
	    be silently adjusted).  This option is useful when you
	    know that there is a firewall that is blocking large
	    replies from <command>named</command>.
	  </para>

          <para>
            The server supports two zone transfer methods. The first, <command>one-answer</command>,
            uses one DNS message per resource record transferred. <command>many-answers</command> packs
            as many resource records as possible into a message. <command>many-answers</command> is
            more efficient, but is only known to be understood by <acronym>BIND</acronym> 9, <acronym>BIND</acronym>
            8.x, and patched versions of <acronym>BIND</acronym>
            4.9.5. You can specify which method
            to use for a server with the <command>transfer-format</command> option.
            If <command>transfer-format</command> is not
            specified, the <command>transfer-format</command>
            specified
            by the <command>options</command> statement will be
            used.
          </para>

          <para><command>transfers</command>
	    is used to limit the number of concurrent inbound zone
            transfers from the specified server. If no
            <command>transfers</command> clause is specified, the
            limit is set according to the
            <command>transfers-per-ns</command> option.
          </para>

          <para>
            The <command>keys</command> clause identifies a
            <command>key_id</command> defined by the <command>key</command> statement,
            to be used for transaction security (TSIG, <xref linkend="tsig"/>)
            when talking to the remote server.
            When a request is sent to the remote server, a request signature
            will be generated using the key specified here and appended to the
            message. A request originating from the remote server is not
            required
            to be signed by this key.
          </para>

          <para>
            Although the grammar of the <command>keys</command>
            clause
            allows for multiple keys, only a single key per server is
            currently
            supported.
          </para>

          <para>
            The <command>transfer-source</command> and
            <command>transfer-source-v6</command> clauses specify
            the IPv4 and IPv6 source
            address to be used for zone transfer with the remote server,
            respectively.
            For an IPv4 remote server, only <command>transfer-source</command> can
            be specified.
            Similarly, for an IPv6 remote server, only
            <command>transfer-source-v6</command> can be
            specified.
            For more details, see the description of
            <command>transfer-source</command> and
            <command>transfer-source-v6</command> in
            <xref linkend="zone_transfers"/>.
          </para>

	  <para>
	    The <command>notify-source</command> and
	    <command>notify-source-v6</command> clauses specify the
	    IPv4 and IPv6 source address to be used for notify
	    messages sent to remote servers, respectively.  For an
	    IPv4 remote server, only <command>notify-source</command>
	    can be specified.  Similarly, for an IPv6 remote server,
	    only <command>notify-source-v6</command> can be specified.
	  </para>

	  <para>
	    The <command>query-source</command> and
	    <command>query-source-v6</command> clauses specify the
	    IPv4 and IPv6 source address to be used for queries
	    sent to remote servers, respectively.  For an IPv4
	    remote server, only <command>query-source</command> can
	    be specified.  Similarly, for an IPv6 remote server,
	    only <command>query-source-v6</command> can be specified.
	  </para>

        </sect2>

      <sect2 id="statschannels">
        <title><command>statistics-channels</command> Statement Grammar</title>

<programlisting><command>statistics-channels</command> {
   [ inet ( ip_addr | * ) [ port ip_port ]
   [ allow { <replaceable> address_match_list </replaceable> } ]; ]
   [ inet ...; ]
};
</programlisting>
      </sect2>

      <sect2>
          <title><command>statistics-channels</command> Statement Definition and
            Usage</title>

        <para>
          The <command>statistics-channels</command> statement
	  declares communication channels to be used by system
	  administrators to get access to statistics information of
	  the name server.
        </para>

        <para>
	  This statement intends to be flexible to support multiple
	  communication protocols in the future, but currently only
	  HTTP access is supported.
	  It requires that BIND 9 be compiled with libxml2;
	  the <command>statistics-channels</command> statement is
	  still accepted even if it is built without the library,
	  but any HTTP access will fail with an error.
        </para>

        <para>
          An <command>inet</command> control channel is a TCP socket
	  listening at the specified <command>ip_port</command> on the
	  specified <command>ip_addr</command>, which can be an IPv4 or IPv6
	  address.  An <command>ip_addr</command> of <literal>*</literal> (asterisk) is
	  interpreted as the IPv4 wildcard address; connections will be
	  accepted on any of the system's IPv4 addresses.
	  To listen on the IPv6 wildcard address,
          use an <command>ip_addr</command> of <literal>::</literal>.
        </para>

        <para>
          If no port is specified, port 80 is used for HTTP channels.
	  The asterisk "<literal>*</literal>" cannot be used for
	  <command>ip_port</command>.
        </para>

        <para>
          The attempt of opening a statistics channel is
          restricted by the optional <command>allow</command> clause.
	  Connections to the statistics channel are permitted based on the
          <command>address_match_list</command>.
	  If no <command>allow</command> clause is present,
	  <command>named</command> accepts connection
	  attempts from any address; since the statistics may
	  contain sensitive internal information, it is highly
	  recommended to restrict the source of connection requests
	  appropriately.
        </para>

        <para>
          If no <command>statistics-channels</command> statement is present,
          <command>named</command> will not open any communication channels.
        </para>

        <para>
          If the statistics channel is configured to listen on 127.0.0.1
          port 8888, then the statistics are accessible in XML format at
          <ulink url="http://127.0.0.1:8888/"
                  >http://127.0.0.1:8888/</ulink> or
          <ulink url="http://127.0.0.1:8888/xml"
                  >http://127.0.0.1:8888/xml</ulink>. A CSS file is
          included which can format the XML statistics into tables 
          when viewed with a stylesheet-capable browser.  When
          <acronym>BIND</acronym> 9 is configured with --enable-newstats, 
          a new XML schema is used (version 3) which adds additional
          zone statistics and uses a flatter tree for more efficient
          parsing.  The stylesheet included uses the Google Charts API
          to render data into into charts and graphs when using a
          javascript-capable browser.
        </para>

        <para>
          Applications that depend on a particular XML schema
          can request 
          <ulink url="http://127.0.0.1:8888/xml/v2"
                  >http://127.0.0.1:8888/xml/v2</ulink> for version 2
          of the statistics XML schema or 
          <ulink url="http://127.0.0.1:8888/xml/v3"
                  >http://127.0.0.1:8888/xml/v3</ulink> for version 3.
          If the requested schema is supported by the server, then
          it will respond; if not, it will return a "page not found"
          error.
        </para>
      </sect2>

	<sect2 id="trusted-keys">
          <title><command>trusted-keys</command> Statement Grammar</title>

<programlisting><command>trusted-keys</command> {
    <replaceable>string</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>string</replaceable> ;
    <optional> <replaceable>string</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>string</replaceable> ; <optional>...</optional></optional>
};
</programlisting>

        </sect2>
	<sect2>
	  <title><command>trusted-keys</command> Statement Definition
	    and Usage</title>
	  <para>
	    The <command>trusted-keys</command> statement defines
	    DNSSEC security roots. DNSSEC is described in <xref
	    linkend="DNSSEC"/>. A security root is defined when the
	    public key for a non-authoritative zone is known, but
	    cannot be securely obtained through DNS, either because
	    it is the DNS root zone or because its parent zone is
	    unsigned.  Once a key has been configured as a trusted
	    key, it is treated as if it had been validated and
	    proven secure. The resolver attempts DNSSEC validation
	    on all DNS data in subdomains of a security root.
	  </para>
	  <para>
	    All keys (and corresponding zones) listed in
	    <command>trusted-keys</command> are deemed to exist regardless
	    of what parent zones say.  Similarly for all keys listed in
	    <command>trusted-keys</command> only those keys are
	    used to validate the DNSKEY RRset.  The parent's DS RRset
	    will not be used.
	  </para>
	  <para>
	    The <command>trusted-keys</command> statement can contain
	    multiple key entries, each consisting of the key's
	    domain name, flags, protocol, algorithm, and the Base-64
	    representation of the key data.
	    Spaces, tabs, newlines and carriage returns are ignored
	    in the key data, so the configuration may be split up into
	    multiple lines.
	  </para>
	  <para>
	    <command>trusted-keys</command> may be set at the top level
	    of <filename>named.conf</filename> or within a view.  If it is
	    set in both places, they are additive: keys defined at the top
	    level are inherited by all views, but keys defined in a view
	    are only used within that view.
	  </para>
	</sect2>

        <sect2>
          <title><command>managed-keys</command> Statement Grammar</title>

<programlisting><command>managed-keys</command> {
    <replaceable>name</replaceable> <literal>initial-key</literal> <replaceable>flags</replaceable> <replaceable>protocol</replaceable> <replaceable>algorithm</replaceable> <replaceable>key-data</replaceable> ;
    <optional> <replaceable>name</replaceable> <literal>initial-key</literal> <replaceable>flags</replaceable> <replaceable>protocol</replaceable> <replaceable>algorithm</replaceable> <replaceable>key-data</replaceable> ; <optional>...</optional></optional>
};
</programlisting>

        </sect2>
	<sect2 id="managed-keys">
	  <title><command>managed-keys</command> Statement Definition
	    and Usage</title>
	  <para>
	    The <command>managed-keys</command> statement, like 
            <command>trusted-keys</command>, defines DNSSEC
            security roots.  The difference is that
            <command>managed-keys</command> can be kept up to date
            automatically, without intervention from the resolver
            operator.
	  </para>
	  <para>
            Suppose, for example, that a zone's key-signing
            key was compromised, and the zone owner had to revoke and
            replace the key.  A resolver which had the old key in a
            <command>trusted-keys</command> statement would be
            unable to validate this zone any longer; it would
            reply with a SERVFAIL response code.  This would
            continue until the resolver operator had updated the
            <command>trusted-keys</command> statement with the new key.
	  </para>
	  <para>
            If, however, the zone were listed in a
            <command>managed-keys</command> statement instead, then the
            zone owner could add a "stand-by" key to the zone in advance.
            <command>named</command> would store the stand-by key, and
            when the original key was revoked, <command>named</command>
            would be able to transition smoothly to the new key.  It would
            also recognize that the old key had been revoked, and cease
            using that key to validate answers, minimizing the damage that
            the compromised key could do.
	  </para>
          <para>
            A <command>managed-keys</command> statement contains a list of
            the keys to be managed, along with information about how the
            keys are to be initialized for the first time.  The only
            initialization method currently supported (as of
            <acronym>BIND</acronym> 9.7.0) is <literal>initial-key</literal>.
            This means the <command>managed-keys</command> statement must
            contain a copy of the initializing key.  (Future releases may
            allow keys to be initialized by other methods, eliminating this
            requirement.)
	  </para>
          <para>
            Consequently, a <command>managed-keys</command> statement
            appears similar to a <command>trusted-keys</command>, differing
            in the presence of the second field, containing the keyword
            <literal>initial-key</literal>.  The difference is, whereas the
            keys listed in a <command>trusted-keys</command> continue to be
            trusted until they are removed from
            <filename>named.conf</filename>, an initializing key listed 
            in a <command>managed-keys</command> statement is only trusted
            <emphasis>once</emphasis>: for as long as it takes to load the
            managed key database and start the RFC 5011 key maintenance
            process.
	  </para>
          <para>
            The first time <command>named</command> runs with a managed key
            configured in <filename>named.conf</filename>, it fetches the
            DNSKEY RRset directly from the zone apex, and validates it
            using the key specified in the <command>managed-keys</command>
            statement.  If the DNSKEY RRset is validly signed, then it is
            used as the basis for a new managed keys database.
	  </para>
          <para>
            From that point on, whenever <command>named</command> runs, it
            sees the <command>managed-keys</command> statement, checks to
            make sure RFC 5011 key maintenance has already been initialized
            for the specified domain, and if so, it simply moves on.  The
            key specified in the <command>managed-keys</command> is not
            used to validate answers; it has been superseded by the key or
            keys stored in the managed keys database.
          </para>
          <para>
            The next time <command>named</command> runs after a name
            has been <emphasis>removed</emphasis> from the
            <command>managed-keys</command> statement, the corresponding
            zone will be removed from the managed keys database,
            and RFC 5011 key maintenance will no longer be used for that
            domain.
	  </para>
	  <para>
	    <command>named</command> only maintains a single managed keys
            database; consequently, unlike <command>trusted-keys</command>,
            <command>managed-keys</command> may only be set at the top
            level of <filename>named.conf</filename>, not within a view.
	  </para>
          <para>
            In the current implementation, the managed keys database is
            stored as a master-format zone file called
            <filename>managed-keys.bind</filename>.  When the key database
            is changed, the zone is updated.  As with any other dynamic
            zone, changes will be written into a journal file,
            <filename>managed-keys.bind.jnl</filename>.  They are committed
            to the master file as soon as possible afterward; in the case
            of the managed key database, this will usually occur within 30
            seconds.  So, whenever <command>named</command> is using
            automatic key maintenance, those two files can be expected to
            exist in the working directory.  (For this reason among others,
            the working directory should be always be writable by
            <command>named</command>.)
	  </para>
	  <para>
	    If the <command>dnssec-validation</command> option is
	    set to <userinput>auto</userinput>, <command>named</command>
	    will automatically initialize a managed key for the
            root zone.  Similarly, if the <command>dnssec-lookaside</command>
            option is set to <userinput>auto</userinput>,
            <command>named</command> will automatically initialize
            a managed key for the zone <literal>dlv.isc.org</literal>.
            In both cases, the key that is used to initialize the key
            maintenance process is built into <command>named</command>,
            and can be overridden from <command>bindkeys-file</command>.
	  </para>
	</sect2>

        <sect2 id="view_statement_grammar">
          <title><command>view</command> Statement Grammar</title>

<programlisting><command>view</command> <replaceable>view_name</replaceable>
      <optional><replaceable>class</replaceable></optional> {
      match-clients { <replaceable>address_match_list</replaceable> };
      match-destinations { <replaceable>address_match_list</replaceable> };
      match-recursive-only <replaceable>yes_or_no</replaceable> ;
      <optional> <replaceable>view_option</replaceable>; ...</optional>
      <optional> <replaceable>zone_statement</replaceable>; ...</optional>
};
</programlisting>

        </sect2>
        <sect2>
          <title><command>view</command> Statement Definition and Usage</title>

          <para>
            The <command>view</command> statement is a powerful
            feature
            of <acronym>BIND</acronym> 9 that lets a name server
            answer a DNS query differently
            depending on who is asking. It is particularly useful for
            implementing
            split DNS setups without having to run multiple servers.
          </para>

          <para>
            Each <command>view</command> statement defines a view
            of the
            DNS namespace that will be seen by a subset of clients.  A client
            matches
            a view if its source IP address matches the
            <varname>address_match_list</varname> of the view's
            <command>match-clients</command> clause and its
            destination IP address matches
            the <varname>address_match_list</varname> of the
            view's
            <command>match-destinations</command> clause.  If not
            specified, both
            <command>match-clients</command> and <command>match-destinations</command>
            default to matching all addresses.  In addition to checking IP
            addresses
            <command>match-clients</command> and <command>match-destinations</command>
            can also take <command>keys</command> which provide an
            mechanism for the
            client to select the view.  A view can also be specified
            as <command>match-recursive-only</command>, which
            means that only recursive
            requests from matching clients will match that view.
            The order of the <command>view</command> statements is
            significant &mdash;
            a client request will be resolved in the context of the first
            <command>view</command> that it matches.
          </para>

          <para>
            Zones defined within a <command>view</command>
            statement will
            only be accessible to clients that match the <command>view</command>.
            By defining a zone of the same name in multiple views, different
            zone data can be given to different clients, for example,
            "internal"
            and "external" clients in a split DNS setup.
          </para>

          <para>
            Many of the options given in the <command>options</command> statement
            can also be used within a <command>view</command>
            statement, and then
            apply only when resolving queries with that view.  When no
            view-specific
            value is given, the value in the <command>options</command> statement
            is used as a default.  Also, zone options can have default values
            specified
            in the <command>view</command> statement; these
            view-specific defaults
            take precedence over those in the <command>options</command> statement.
          </para>

          <para>
            Views are class specific.  If no class is given, class IN
            is assumed.  Note that all non-IN views must contain a hint zone,
            since only the IN class has compiled-in default hints.
          </para>

          <para>
            If there are no <command>view</command> statements in
            the config
            file, a default view that matches any client is automatically
            created
            in class IN. Any <command>zone</command> statements
            specified on
            the top level of the configuration file are considered to be part
            of
            this default view, and the <command>options</command>
            statement will
            apply to the default view. If any explicit <command>view</command>
            statements are present, all <command>zone</command>
            statements must
            occur inside <command>view</command> statements.
          </para>

          <para>
            Here is an example of a typical split DNS setup implemented
            using <command>view</command> statements:
          </para>

<programlisting>view "internal" {
      // This should match our internal networks.
      match-clients { 10.0.0.0/8; };

      // Provide recursive service to internal
      // clients only.
      recursion yes;

      // Provide a complete view of the example.com
      // zone including addresses of internal hosts.
      zone "example.com" {
            type master;
            file "example-internal.db";
      };
};

view "external" {
      // Match all clients not matched by the
      // previous view.
      match-clients { any; };

      // Refuse recursive service to external clients.
      recursion no;

      // Provide a restricted view of the example.com
      // zone containing only publicly accessible hosts.
      zone "example.com" {
           type master;
           file "example-external.db";
      };
};
</programlisting>

        </sect2>
        <sect2 id="zone_statement_grammar">
          <title><command>zone</command>
            Statement Grammar</title>

<programlisting><command>zone</command> <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type master;
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-transfer { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-update { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> update-check-ksk <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-dnskey-kskonly <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-loadkeys-interval <replaceable>number</replaceable>; </optional>
    <optional> update-policy <replaceable>local</replaceable> | { <replaceable>update_policy_rule</replaceable> <optional>...</optional> }; </optional>
    <optional> also-notify { <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ;
                  <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> check-names (<constant>warn</constant>|<constant>fail</constant>|<constant>ignore</constant>) ; </optional>
    <optional> check-mx (<constant>warn</constant>|<constant>fail</constant>|<constant>ignore</constant>) ; </optional>
    <optional> check-wildcard <replaceable>yes_or_no</replaceable>; </optional>
    <optional> check-spf ( <replaceable>warn</replaceable> | <replaceable>fail</replaceable> | <replaceable>ignore</replaceable> ); </optional>
    <optional> check-integrity <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> dialup <replaceable>dialup_option</replaceable> ; </optional>
    <optional> file <replaceable>string</replaceable> ; </optional>
    <optional> masterfile-format (<constant>text</constant>|<constant>raw</constant>) ; </optional>
    <optional> journal <replaceable>string</replaceable> ; </optional>
    <optional> max-journal-size <replaceable>size_spec</replaceable>; </optional>
    <optional> forward (<constant>only</constant>|<constant>first</constant>) ; </optional>
    <optional> forwarders { <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> ixfr-base <replaceable>string</replaceable> ; </optional>
    <optional> ixfr-from-differences <replaceable>yes_or_no</replaceable>; </optional>
    <optional> ixfr-tmp-file <replaceable>string</replaceable> ; </optional>
    <optional> request-ixfr <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> maintain-ixfr-base <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> max-ixfr-log-size <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-idle-out <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-time-out <replaceable>number</replaceable> ; </optional>
    <optional> notify <replaceable>yes_or_no</replaceable> | <replaceable>explicit</replaceable> | <replaceable>master-only</replaceable> ; </optional>
    <optional> notify-delay <replaceable>seconds</replaceable> ; </optional>
    <optional> notify-to-soa <replaceable>yes_or_no</replaceable>; </optional>
    <optional> pubkey <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>string</replaceable> ; </optional>
    <optional> notify-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> zone-statistics <replaceable>full</replaceable> | <replaceable>terse</replaceable> | <replaceable>none</replaceable>; </optional>
    <optional> sig-validity-interval <replaceable>number</replaceable> <optional><replaceable>number</replaceable></optional> ; </optional>
    <optional> sig-signing-nodes <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-signatures <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-type <replaceable>number</replaceable> ; </optional>
    <optional> database <replaceable>string</replaceable> ; </optional>
    <optional> min-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> max-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> min-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> max-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> key-directory <replaceable>path_name</replaceable>; </optional>
    <optional> auto-dnssec <constant>allow</constant>|<constant>maintain</constant>|<constant>off</constant>; </optional>
    <optional> inline-signing <replaceable>yes_or_no</replaceable>; </optional>
    <optional> zero-no-soa-ttl <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> serial-update-method <constant>increment</constant>|<constant>unixtime</constant>; </optional>
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type slave;
    <optional> allow-notify { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-transfer { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-update-forwarding { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> dnssec-update-mode ( <replaceable>maintain</replaceable> | <replaceable>no-resign</replaceable> ); </optional>
    <optional> update-check-ksk <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-dnskey-kskonly <replaceable>yes_or_no</replaceable>; </optional>
    <optional> dnssec-loadkeys-interval <replaceable>number</replaceable>; </optional>
    <optional> dnssec-secure-to-insecure <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> try-tcp-refresh <replaceable>yes_or_no</replaceable>; </optional>
    <optional> also-notify <optional>port <replaceable>ip_port</replaceable></optional> { ( <replaceable>masters_list</replaceable> | <replaceable>ip_addr</replaceable>
                              <optional>port <replaceable>ip_port</replaceable></optional>
                              <optional>key <replaceable>key</replaceable></optional> ) ; <optional>...</optional> }; </optional>
    <optional> check-names (<constant>warn</constant>|<constant>fail</constant>|<constant>ignore</constant>) ; </optional>
    <optional> dialup <replaceable>dialup_option</replaceable> ; </optional>
    <optional> file <replaceable>string</replaceable> ; </optional>
    <optional> masterfile-format (<constant>text</constant>|<constant>raw</constant>) ; </optional>
    <optional> journal <replaceable>string</replaceable> ; </optional>
    <optional> max-journal-size <replaceable>size_spec</replaceable>; </optional>
    <optional> forward (<constant>only</constant>|<constant>first</constant>) ; </optional>
    <optional> forwarders { <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> ixfr-base <replaceable>string</replaceable> ; </optional>
    <optional> ixfr-from-differences <replaceable>yes_or_no</replaceable>; </optional>
    <optional> ixfr-tmp-file <replaceable>string</replaceable> ; </optional>
    <optional> maintain-ixfr-base <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> masters <optional>port <replaceable>ip_port</replaceable></optional> { ( <replaceable>masters_list</replaceable> | <replaceable>ip_addr</replaceable>
                              <optional>port <replaceable>ip_port</replaceable></optional>
                              <optional>key <replaceable>key</replaceable></optional> ) ; <optional>...</optional> }; </optional>
    <optional> max-ixfr-log-size <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-idle-in <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-idle-out <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-time-in <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-time-out <replaceable>number</replaceable> ; </optional>
    <optional> notify <replaceable>yes_or_no</replaceable> | <replaceable>explicit</replaceable> | <replaceable>master-only</replaceable> ; </optional>
    <optional> notify-delay <replaceable>seconds</replaceable> ; </optional>
    <optional> notify-to-soa <replaceable>yes_or_no</replaceable>; </optional>
    <optional> pubkey <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>string</replaceable> ; </optional>
    <optional> transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>)
                             <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> use-alt-transfer-source <replaceable>yes_or_no</replaceable>; </optional>
    <optional> notify-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> notify-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> zone-statistics <replaceable>full</replaceable> | <replaceable>terse</replaceable> | <replaceable>none</replaceable>; </optional>
    <optional> sig-validity-interval <replaceable>number</replaceable> <optional><replaceable>number</replaceable></optional> ; </optional>
    <optional> sig-signing-nodes <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-signatures <replaceable>number</replaceable> ; </optional>
    <optional> sig-signing-type <replaceable>number</replaceable> ; </optional>
    <optional> database <replaceable>string</replaceable> ; </optional>
    <optional> min-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> max-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> min-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> max-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> key-directory <replaceable>path_name</replaceable>; </optional>
    <optional> auto-dnssec <constant>allow</constant>|<constant>maintain</constant>|<constant>off</constant>; </optional>
    <optional> inline-signing <replaceable>yes_or_no</replaceable>; </optional>
    <optional> multi-master <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> zero-no-soa-ttl <replaceable>yes_or_no</replaceable> ; </optional>
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type hint;
    file <replaceable>string</replaceable> ;
    <optional> delegation-only <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> check-names (<constant>warn</constant>|<constant>fail</constant>|<constant>ignore</constant>) ; </optional> // Not Implemented.
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type stub;
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> allow-query-on { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> check-names (<constant>warn</constant>|<constant>fail</constant>|<constant>ignore</constant>) ; </optional>
    <optional> dialup <replaceable>dialup_option</replaceable> ; </optional>
    <optional> delegation-only <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> file <replaceable>string</replaceable> ; </optional>
    <optional> masterfile-format (<constant>text</constant>|<constant>raw</constant>) ; </optional>
    <optional> forward (<constant>only</constant>|<constant>first</constant>) ; </optional>
    <optional> forwarders { <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> masters <optional>port <replaceable>ip_port</replaceable></optional> { ( <replaceable>masters_list</replaceable> | <replaceable>ip_addr</replaceable>
                              <optional>port <replaceable>ip_port</replaceable></optional>
                              <optional>key <replaceable>key</replaceable></optional> ) ; <optional>...</optional> }; </optional>
    <optional> max-transfer-idle-in <replaceable>number</replaceable> ; </optional>
    <optional> max-transfer-time-in <replaceable>number</replaceable> ; </optional>
    <optional> pubkey <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>number</replaceable> <replaceable>string</replaceable> ; </optional>
    <optional> transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>)
                         <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source (<replaceable>ip4_addr</replaceable> | <constant>*</constant>) <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> alt-transfer-source-v6 (<replaceable>ip6_addr</replaceable> | <constant>*</constant>)
                            <optional>port <replaceable>ip_port</replaceable></optional> ; </optional>
    <optional> use-alt-transfer-source <replaceable>yes_or_no</replaceable>; </optional>
    <optional> zone-statistics <replaceable>yes_or_no</replaceable> ; </optional>
    <optional> database <replaceable>string</replaceable> ; </optional>
    <optional> min-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> max-refresh-time <replaceable>number</replaceable> ; </optional>
    <optional> min-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> max-retry-time <replaceable>number</replaceable> ; </optional>
    <optional> multi-master <replaceable>yes_or_no</replaceable> ; </optional>
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type static-stub;
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
    <optional> server-addresses { <optional> <replaceable>ip_addr</replaceable> ; ... </optional> }; </optional>
    <optional> server-names { <optional> <replaceable>namelist</replaceable> </optional> }; </optional>  
    <optional> zone-statistics <replaceable>yes_or_no</replaceable> ; </optional>
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type forward;
    <optional> forward (<constant>only</constant>|<constant>first</constant>) ; </optional>
    <optional> forwarders { <optional> <replaceable>ip_addr</replaceable> <optional>port <replaceable>ip_port</replaceable></optional> ; ... </optional> }; </optional>
    <optional> delegation-only <replaceable>yes_or_no</replaceable> ; </optional>
};

zone <replaceable>"."</replaceable> <optional><replaceable>class</replaceable></optional> {
    type redirect;
    file <replaceable>string</replaceable> ;
    <optional> masterfile-format (<constant>text</constant>|<constant>raw</constant>) ; </optional>
    <optional> allow-query { <replaceable>address_match_list</replaceable> }; </optional>
};

zone <replaceable>zone_name</replaceable> <optional><replaceable>class</replaceable></optional> {
    type delegation-only;
};

</programlisting>

        </sect2>
        <sect2>
          <title><command>zone</command> Statement Definition and Usage</title>
          <sect3>
            <title>Zone Types</title>
            <informaltable colsep="0" rowsep="0">
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="3Level-table">
                <!--colspec colname="1" colnum="1" colsep="0" colwidth="1.108in"/-->
                <!--colspec colname="2" colnum="2" colsep="0" colwidth="4.017in"/-->
		<colspec colname="1" colnum="1" colsep="0"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="4.017in"/>
                <tbody>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>master</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The server has a master copy of the data
                        for the zone and will be able to provide authoritative
                        answers for
                        it.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>slave</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A slave zone is a replica of a master
                        zone. The <command>masters</command> list
                        specifies one or more IP addresses
                        of master servers that the slave contacts to update
                        its copy of the zone.
                        Masters list elements can also be names of other
                        masters lists.
                        By default, transfers are made from port 53 on the
                        servers; this can
                        be changed for all servers by specifying a port number
                        before the
                        list of IP addresses, or on a per-server basis after
                        the IP address.
                        Authentication to the master can also be done with
                        per-server TSIG keys.
                        If a file is specified, then the
                        replica will be written to this file whenever the zone
                        is changed,
                        and reloaded from this file on a server restart. Use
                        of a file is
                        recommended, since it often speeds server startup and
                        eliminates
                        a needless waste of bandwidth. Note that for large
                        numbers (in the
                        tens or hundreds of thousands) of zones per server, it
                        is best to
                        use a two-level naming scheme for zone filenames. For
                        example,
                        a slave server for the zone <literal>example.com</literal> might place
                        the zone contents into a file called
                        <filename>ex/example.com</filename> where <filename>ex/</filename> is
                        just the first two letters of the zone name. (Most
                        operating systems
                        behave very slowly if you put 100000 files into
                        a single directory.)
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>stub</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A stub zone is similar to a slave zone,
                        except that it replicates only the NS records of a
                        master zone instead
                        of the entire zone. Stub zones are not a standard part
                        of the DNS;
                        they are a feature specific to the <acronym>BIND</acronym> implementation.
                      </para>

                      <para>
                        Stub zones can be used to eliminate the need for glue
                        NS record
                        in a parent zone at the expense of maintaining a stub
                        zone entry and
                        a set of name server addresses in <filename>named.conf</filename>.
                        This usage is not recommended for new configurations,
                        and BIND 9
                        supports it only in a limited way.
                        In <acronym>BIND</acronym> 4/8, zone
                        transfers of a parent zone
                        included the NS records from stub children of that
                        zone. This meant
                        that, in some cases, users could get away with
                        configuring child stubs
                        only in the master server for the parent zone. <acronym>BIND</acronym>
                        9 never mixes together zone data from different zones
                        in this
                        way. Therefore, if a <acronym>BIND</acronym> 9 master serving a parent
                        zone has child stub zones configured, all the slave
                        servers for the
                        parent zone also need to have the same child stub
                        zones
                        configured.
                      </para>

                      <para>
                        Stub zones can also be used as a way of forcing the
                        resolution
                        of a given domain to use a particular set of
                        authoritative servers.
                        For example, the caching name servers on a private
                        network using
                        RFC1918 addressing may be configured with stub zones
                        for
                        <literal>10.in-addr.arpa</literal>
                        to use a set of internal name servers as the
                        authoritative
                        servers for that domain.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>static-stub</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			A static-stub zone is similar to a stub zone
			with the following exceptions:
			the zone data is statically configured, rather
			than transferred from a master server;
			when recursion is necessary for a query that
			matches a static-stub zone, the locally
			configured data (nameserver names and glue addresses)
			is always used even if different authoritative
			information is cached.
                      </para>
                      <para>
			Zone data is configured via the
			<command>server-addresses</command> and
			<command>server-names</command> zone options.
                      </para>
		      <para>
			The zone data is maintained in the form of NS
			and (if necessary) glue A or AAAA RRs
			internally, which can be seen by dumping zone
			databases by <command>rndc dumpdb -all</command>.
			The configured RRs are considered local configuration
			parameters rather than public data.
			Non recursive queries (i.e., those with the RD
			bit off) to a static-stub zone are therefore
			prohibited and will be responded with REFUSED.
		      </para>
		      <para>
			Since the data is statically configured, no
			zone maintenance action takes place for a static-stub
			zone.
			For example, there is no periodic refresh
			attempt, and an incoming notify message
			will be rejected with an rcode of NOTAUTH.
		      </para>
		      <para>
			Each static-stub zone is configured with
			internally generated NS and (if necessary)
			glue A or AAAA RRs 
		      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>forward</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A "forward zone" is a way to configure
                        forwarding on a per-domain basis.  A <command>zone</command> statement
                        of type <command>forward</command> can
                        contain a <command>forward</command>
                        and/or <command>forwarders</command>
                        statement,
                        which will apply to queries within the domain given by
                        the zone
                        name. If no <command>forwarders</command>
                        statement is present or
                        an empty list for <command>forwarders</command> is given, then no
                        forwarding will be done for the domain, canceling the
                        effects of
                        any forwarders in the <command>options</command> statement. Thus
                        if you want to use this type of zone to change the
                        behavior of the
                        global <command>forward</command> option
                        (that is, "forward first"
                        to, then "forward only", or vice versa, but want to
                        use the same
                        servers as set globally) you need to re-specify the
                        global forwarders.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>hint</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The initial set of root name servers is
                        specified using a "hint zone". When the server starts
                        up, it uses
                        the root hints to find a root name server and get the
                        most recent
                        list of root name servers. If no hint zone is
                        specified for class
                        IN, the server uses a compiled-in default set of root
                        servers hints.
                        Classes other than IN have no built-in defaults hints.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>redirect</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Redirect zones are used to provide answers to
                        queries when normal resolution would result in
                        NXDOMAIN being returned.
			Only one redirect zone is supported
                        per view.  <command>allow-query</command> can be
                        used to restrict which clients see these answers.
                      </para>
                      <para>
			If the client has requested DNSSEC records (DO=1) and
			the NXDOMAIN response is signed then no substitution
			will occur.
                      </para>
                      <para>
                        To redirect all NXDOMAIN responses to
                        100.100.100.2 and
                        2001:ffff:ffff::100.100.100.2, one would
                        configure a type redirect zone named ".",
                        with the zone file containing wildcard records
                        that point to the desired addresses: 
                        <literal>"*. IN A 100.100.100.2"</literal>
                        and
                        <literal>"*. IN AAAA 2001:ffff:ffff::100.100.100.2"</literal>.
                      </para>
                      <para>
                        To redirect all Spanish names (under .ES) one
                        would use similar entries but with the names
                        "*.ES." instead of "*.".  To redirect all 
                        commercial Spanish names (under COM.ES) one
			would use wildcard entries called "*.COM.ES.".
                      </para>
                      <para>
                        Note that the redirect zone supports all
                        possible types; it is not limited to A and
                        AAAA records.
                      </para>
                      <para>
                        Because redirect zones are not referenced
                        directly by name, they are not kept in the
                        zone lookup table with normal master and slave
                        zones. Consequently, it is not currently possible
                        to use
                        <command>rndc reload
                                <replaceable>zonename</replaceable></command>
                        to reload a redirect zone.  However, when using
                        <command>rndc reload</command> without specifying
                        a zone name, redirect zones will be reloaded along
                        with other zones.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>delegation-only</varname>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			This is used to enforce the delegation-only
			status of infrastructure zones (e.g. COM,
			NET, ORG).  Any answer that is received
			without an explicit or implicit delegation
			in the authority section will be treated
			as NXDOMAIN.  This does not apply to the
			zone apex.  This should not be applied to
			leaf zones.
                      </para>
                      <para>
                        <varname>delegation-only</varname> has no
                        effect on answers received from forwarders.
                      </para>
		      <para>
			See caveats in <xref linkend="root_delegation_only"/>.
		      </para>
                    </entry>
                  </row>
                </tbody>
              </tgroup>
            </informaltable>
          </sect3>

          <sect3>
            <title>Class</title>
            <para>
              The zone's name may optionally be followed by a class. If
              a class is not specified, class <literal>IN</literal> (for <varname>Internet</varname>),
              is assumed. This is correct for the vast majority of cases.
            </para>
            <para>
              The <literal>hesiod</literal> class is
              named for an information service from MIT's Project Athena. It
              is
              used to share information about various systems databases, such
              as users, groups, printers and so on. The keyword
              <literal>HS</literal> is
              a synonym for hesiod.
            </para>
            <para>
              Another MIT development is Chaosnet, a LAN protocol created
              in the mid-1970s. Zone data for it can be specified with the <literal>CHAOS</literal> class.
            </para>
          </sect3>
          <sect3>

            <title>Zone Options</title>

            <variablelist>

              <varlistentry>
                <term><command>allow-notify</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>allow-notify</command> in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>allow-query</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>allow-query</command> in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>allow-query-on</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>allow-query-on</command> in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>allow-transfer</command></term>
                <listitem>
                  <para>
                    See the description of <command>allow-transfer</command>
                    in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>allow-update</command></term>
                <listitem>
                  <para>
                    See the description of <command>allow-update</command>
                    in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>update-policy</command></term>
                <listitem>
                  <para>
                    Specifies a "Simple Secure Update" policy. See
                    <xref linkend="dynamic_update_policies"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>allow-update-forwarding</command></term>
                <listitem>
                  <para>
                    See the description of <command>allow-update-forwarding</command>
                    in <xref linkend="access_control"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>also-notify</command></term>
                <listitem>
                  <para>
                    Only meaningful if <command>notify</command>
                    is
                    active for this zone. The set of machines that will
                    receive a
                    <literal>DNS NOTIFY</literal> message
                    for this zone is made up of all the listed name servers
                    (other than
                    the primary master) for the zone plus any IP addresses
                    specified
                    with <command>also-notify</command>. A port
                    may be specified
                    with each <command>also-notify</command>
                    address to send the notify
                    messages to a port other than the default of 53.
                    A TSIG key may also be specified to cause the
                    <literal>NOTIFY</literal> to be signed by the
                    given key.
                    <command>also-notify</command> is not
                    meaningful for stub zones.
                    The default is the empty list.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-names</command></term>
                <listitem>
                  <para>
                    This option is used to restrict the character set and
                    syntax of
                    certain domain names in master files and/or DNS responses
                    received from the
                    network.  The default varies according to zone type.  For <command>master</command> zones the default is <command>fail</command>.  For <command>slave</command>
                    zones the default is <command>warn</command>.
                    It is not implemented for <command>hint</command> zones.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-mx</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>check-mx</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-spf</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>check-spf</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-wildcard</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>check-wildcard</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-integrity</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>check-integrity</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>check-sibling</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>check-sibling</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>zero-no-soa-ttl</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>zero-no-soa-ttl</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

	      <varlistentry>
	        <term><command>update-check-ksk</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>update-check-ksk</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

	      <varlistentry>
	        <term><command>dnssec-update-mode</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>dnssec-update-mode</command> in <xref linkend="options"/>.
                  </para>
                </listitem>
              </varlistentry>

	      <varlistentry>
	        <term><command>dnssec-dnskey-kskonly</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>dnssec-dnskey-kskonly</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

	      <varlistentry>
	        <term><command>try-tcp-refresh</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>try-tcp-refresh</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>database</command></term>
                <listitem>
                  <para>
                    Specify the type of database to be used for storing the
                    zone data.  The string following the <command>database</command> keyword
                    is interpreted as a list of whitespace-delimited words.
                    The first word
                    identifies the database type, and any subsequent words are
                    passed
                    as arguments to the database to be interpreted in a way
                    specific
                    to the database type.
                  </para>
                  <para>
                    The default is <userinput>"rbt"</userinput>, BIND 9's
                    native in-memory
                    red-black-tree database.  This database does not take
                    arguments.
                  </para>
                  <para>
                    Other values are possible if additional database drivers
                    have been linked into the server.  Some sample drivers are
                    included
                    with the distribution but none are linked in by default.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>dialup</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>dialup</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>delegation-only</command></term>
                <listitem>
                  <para>
                    The flag only applies to hint and stub zones.  If set
                    to <userinput>yes</userinput>, then the zone will also be
                    treated as if it is also a delegation-only type zone.
                  </para>
		  <para>
		    See caveats in <xref linkend="root_delegation_only"/>.
		  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>forward</command></term>
                <listitem>
                  <para>
                    Only meaningful if the zone has a forwarders
                    list. The <command>only</command> value causes
                    the lookup to fail
                    after trying the forwarders and getting no answer, while <command>first</command> would
                    allow a normal lookup to be tried.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>forwarders</command></term>
                <listitem>
                  <para>
                    Used to override the list of global forwarders.
                    If it is not specified in a zone of type <command>forward</command>,
                    no forwarding is done for the zone and the global options are
                    not used.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>ixfr-base</command></term>
                <listitem>
                  <para>
                    Was used in <acronym>BIND</acronym> 8 to
                    specify the name
                    of the transaction log (journal) file for dynamic update
                    and IXFR.
                    <acronym>BIND</acronym> 9 ignores the option
                    and constructs the name of the journal
                    file by appending "<filename>.jnl</filename>"
                    to the name of the
                    zone file.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>ixfr-tmp-file</command></term>
                <listitem>
                  <para>
                    Was an undocumented option in <acronym>BIND</acronym> 8.
                    Ignored in <acronym>BIND</acronym> 9.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>journal</command></term>
                <listitem>
                  <para>
                    Allow the default journal's filename to be overridden.
                    The default is the zone's filename with "<filename>.jnl</filename>" appended.
                    This is applicable to <command>master</command> and <command>slave</command> zones.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>max-journal-size</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>max-journal-size</command> in <xref linkend="server_resource_limits"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>max-transfer-time-in</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>max-transfer-time-in</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>max-transfer-idle-in</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>max-transfer-idle-in</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>max-transfer-time-out</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>max-transfer-time-out</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>max-transfer-idle-out</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>max-transfer-idle-out</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>notify</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>notify</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>notify-delay</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>notify-delay</command> in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>notify-to-soa</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>notify-to-soa</command> in
		    <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>pubkey</command></term>
                <listitem>
                  <para>
                    In <acronym>BIND</acronym> 8, this option was
                    intended for specifying
                    a public zone key for verification of signatures in DNSSEC
                    signed
                    zones when they are loaded from disk. <acronym>BIND</acronym> 9 does not verify signatures
                    on load and ignores the option.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>zone-statistics</command></term>
                <listitem>
                  <para>
                    If <userinput>yes</userinput>, the server will keep
                    statistical
                    information for this zone, which can be dumped to the
                    <command>statistics-file</command> defined in
                    the server options.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>server-addresses</command></term>
                <listitem>
                  <para>
                    Only meaningful for static-stub zones.
		    This is a list of IP addresses to which queries
		    should be sent in recursive resolution for the
		    zone.
		    A non empty list for this option will internally
		    configure the apex NS RR with associated glue A or
		    AAAA RRs.
                  </para>
		  <para>
		    For example, if "example.com" is configured as a
		    static-stub zone with 192.0.2.1 and 2001:db8::1234
		    in a <command>server-addresses</command> option,
		    the following RRs will be internally configured.
		  </para>
<programlisting>example.com. NS example.com.
example.com. A 192.0.2.1
example.com. AAAA 2001:db8::1234</programlisting>
		  <para>
		    These records are internally used to resolve
		    names under the static-stub zone.
		    For instance, if the server receives a query for
		    "www.example.com" with the RD bit on, the server
		    will initiate recursive resolution and send
		    queries to 192.0.2.1 and/or 2001:db8::1234.
		  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>server-names</command></term>
                <listitem>
                  <para>
                    Only meaningful for static-stub zones.
		    This is a list of domain names of nameservers that
		    act as authoritative servers of the static-stub
		    zone.
		    These names will be resolved to IP addresses when
		    <command>named</command> needs to send queries to
		    these servers.
		    To make this supplemental resolution successful,
		    these names must not be a subdomain of the origin
		    name of static-stub zone.
		    That is, when "example.net" is the origin of a
		    static-stub zone, "ns.example" and
		    "master.example.com" can be specified in the
		    <command>server-names</command> option, but
		    "ns.example.net" cannot, and will be rejected by
		    the configuration parser.
		  </para>
		  <para>
		    A non empty list for this option will internally
		    configure the apex NS RR with the specified names.
		    For example, if "example.com" is configured as a
		    static-stub zone with "ns1.example.net" and
		    "ns2.example.net"
		    in a <command>server-names</command> option,
		    the following RRs will be internally configured.
		  </para>
<programlisting>example.com. NS ns1.example.net.
example.com. NS ns2.example.net.
</programlisting>
		  <para>
		    These records are internally used to resolve
		    names under the static-stub zone.
		    For instance, if the server receives a query for
		    "www.example.com" with the RD bit on, the server
		    initiate recursive resolution,
		    resolve "ns1.example.net" and/or
		    "ns2.example.net" to IP addresses, and then send
		    queries to (one or more of) these addresses.
		  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>sig-validity-interval</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>sig-validity-interval</command> in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>sig-signing-nodes</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>sig-signing-nodes</command> in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>sig-signing-signatures</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>sig-signing-signatures</command> in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>sig-signing-type</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>sig-signing-type</command> in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>transfer-source</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>transfer-source</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>transfer-source-v6</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>transfer-source-v6</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>alt-transfer-source</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>alt-transfer-source</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>alt-transfer-source-v6</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>alt-transfer-source-v6</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>use-alt-transfer-source</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>use-alt-transfer-source</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>


              <varlistentry>
                <term><command>notify-source</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>notify-source</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>notify-source-v6</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>notify-source-v6</command> in <xref linkend="zone_transfers"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>min-refresh-time</command></term>
                <term><command>max-refresh-time</command></term>
                <term><command>min-retry-time</command></term>
                <term><command>max-retry-time</command></term>
                <listitem>
                  <para>
                    See the description in <xref linkend="tuning"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>ixfr-from-differences</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>ixfr-from-differences</command> in <xref linkend="boolean_options"/>.
		    (Note that the <command>ixfr-from-differences</command>
		    <userinput>master</userinput> and
		    <userinput>slave</userinput> choices are not
		    available at the zone level.)
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>key-directory</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>key-directory</command> in <xref linkend="options"/>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>auto-dnssec</command></term>
                <listitem>
                  <para>
                    Zones configured for dynamic DNS may also use this
                    option to allow varying levels of automatic DNSSEC key
                    management. There are three possible settings:
                  </para>
                  <para>
                    <command>auto-dnssec allow;</command> permits
                    keys to be updated and the zone fully re-signed
                    whenever the user issues the command <command>rndc sign
                    <replaceable>zonename</replaceable></command>.
                  </para>
                  <para>
                    <command>auto-dnssec maintain;</command> includes the
                    above, but also automatically adjusts the zone's DNSSEC
                    keys on schedule, according to the keys' timing metadata
                    (see <xref linkend="man.dnssec-keygen"/> and
                    <xref linkend="man.dnssec-settime"/>).  The command
                    <command>rndc sign
                    <replaceable>zonename</replaceable></command> causes
                    <command>named</command> to load keys from the key
                    repository and sign the zone with all keys that are
                    active. 
                    <command>rndc loadkeys
                    <replaceable>zonename</replaceable></command> causes
                    <command>named</command> to load keys from the key
                    repository and schedule key maintenance events to occur
                    in the future, but it does not sign the full zone
                    immediately.  Note: once keys have been loaded for a
                    zone the first time, the repository will be searched
                    for changes periodically, regardless of whether
                    <command>rndc loadkeys</command> is used.  The recheck
                    interval is defined by
                    <command>dnssec-loadkeys-interval</command>.)
                  </para>
                  <para>
                    The default setting is <command>auto-dnssec off</command>.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>serial-update-method</command></term>
                <listitem>
                  <para>
                    Zones configured for dynamic DNS may use this
                    option to set the update method that will be used for
                    the zone serial number in the SOA record.
                  </para>
                  <para>
                    With the default setting of
                    <command>serial-update-method increment;</command>, the
                    SOA serial number will be incremented by one each time
                    the zone is updated.
                  </para>
                  <para>
                    When set to 
                    <command>serial-update-method unixtime;</command>, the
                    SOA serial number will be set to the number of seconds
                    since the UNIX epoch, unless the serial number is
                    already greater than or equal to that value, in which
                    case it is simply incremented by one.
                  </para>
                </listitem>
              </varlistentry>

              <varlistentry>
                <term><command>inline-signing</command></term>
		<listitem>
		  <para>
                    If <literal>yes</literal>, this enables
		    "bump in the wire" signing of a zone, where a
		    unsigned zone is transferred in or loaded from
		    disk and a signed version of the zone is served,
		    with possibly, a different serial number.  This
		    behaviour is disabled by default.
		  </para>
		</listitem>
	      </varlistentry>

              <varlistentry>
                <term><command>multi-master</command></term>
                <listitem>
                  <para>
                    See the description of <command>multi-master</command> in
		    <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>
	
	      <varlistentry>
		<term><command>masterfile-format</command></term>
		<listitem>
		  <para>
		    See the description of <command>masterfile-format</command>
		    in <xref linkend="tuning"/>.
		  </para>
		</listitem>
	      </varlistentry>

              <varlistentry>
                <term><command>dnssec-secure-to-insecure</command></term>
                <listitem>
                  <para>
                    See the description of
                    <command>dnssec-secure-to-insecure</command> in <xref linkend="boolean_options"/>.
                  </para>
                </listitem>
              </varlistentry>

            </variablelist>

          </sect3>
          <sect3 id="dynamic_update_policies">
            <title>Dynamic Update Policies</title>
	    <para><acronym>BIND</acronym> 9 supports two alternative
	      methods of granting clients the right to perform
	      dynamic updates to a zone, configured by the
	      <command>allow-update</command> and
	      <command>update-policy</command> option, respectively.
	    </para>
	    <para>
	      The <command>allow-update</command> clause works the
	      same way as in previous versions of <acronym>BIND</acronym>.
	      It grants given clients the permission to update any
	      record of any name in the zone.
	    </para>
	    <para>
	      The <command>update-policy</command> clause
	      allows more fine-grained control over what updates are
	      allowed.  A set of rules is specified, where each rule
	      either grants or denies permissions for one or more
	      names to be updated by one or more identities.  If
	      the dynamic update request message is signed (that is,
	      it includes either a TSIG or SIG(0) record), the
	      identity of the signer can be determined.
	    </para>
	    <para>
	      Rules are specified in the <command>update-policy</command>
	      zone option, and are only meaningful for master zones.
	      When the <command>update-policy</command> statement
	      is present, it is a configuration error for the
	      <command>allow-update</command> statement to be
	      present.  The <command>update-policy</command> statement
	      only examines the signer of a message; the source
	      address is not relevant.
	    </para>
	    <para>
              There is a pre-defined <command>update-policy</command>
              rule which can be switched on with the command
              <command>update-policy local;</command>.
              Switching on this rule in a zone causes
              <command>named</command> to generate a TSIG session
              key and place it in a file, and to allow that key
              to update the zone.  (By default, the file is
              <filename>/var/run/named/session.key</filename>, the key
              name is "local-ddns" and the key algorithm is HMAC-SHA256,
              but these values are configurable with the
              <command>session-keyfile</command>,
              <command>session-keyname</command> and
              <command>session-keyalg</command> options, respectively).
            </para>
	    <para>
              A client running on the local system, and with appropriate
              permissions, may read that file and use the key to sign update
              requests.  The zone's update policy will be set to allow that
              key to change any record within the zone.  Assuming the
              key name is "local-ddns", this policy is equivalent to:
            </para>

            <programlisting>update-policy { grant local-ddns zonesub any; };
            </programlisting>

	    <para>
              The command <command>nsupdate -l</command> sends update
              requests to localhost, and signs them using the session key.
	    </para>

	    <para>
              Other rule definitions look like this:
            </para>

<programlisting>
( <command>grant</command> | <command>deny</command> ) <replaceable>identity</replaceable> <replaceable>nametype</replaceable> <optional> <replaceable>name</replaceable> </optional> <optional> <replaceable>types</replaceable> </optional>
</programlisting>

            <para>
              Each rule grants or denies privileges.  Once a message has
              successfully matched a rule, the operation is immediately
              granted or denied and no further rules are examined.  A rule
              is matched when the signer matches the identity field, the
              name matches the name field in accordance with the nametype
              field, and the type matches the types specified in the type
              field.
            </para>
            <para>
	      No signer is required for <replaceable>tcp-self</replaceable>
	      or <replaceable>6to4-self</replaceable> however the standard
	      reverse mapping / prefix conversion must match the identity
	      field.
	    </para>
	    <para>
	      The identity field specifies a name or a wildcard
	      name.  Normally, this is the name of the TSIG or
	      SIG(0) key used to sign the update request.  When a
	      TKEY exchange has been used to create a shared secret,
	      the identity of the shared secret is the same as the
	      identity of the key used to authenticate the TKEY
	      exchange.  TKEY is also the negotiation method used
	      by GSS-TSIG, which establishes an identity that is
	      the Kerberos principal of the client, such as
	      <userinput>"user@host.domain"</userinput>.  When the
	      <replaceable>identity</replaceable> field specifies
	      a wildcard name, it is subject to DNS wildcard
	      expansion, so the rule will apply to multiple identities.
	      The <replaceable>identity</replaceable> field must
	      contain a fully-qualified domain name.
	    </para>
	    <para>
	      For nametypes <varname>krb5-self</varname>,
	      <varname>ms-self</varname>, <varname>krb5-subdomain</varname>,
              and <varname>ms-subdomain</varname> the
	      <replaceable>identity</replaceable> field specifies
	      the Windows or Kerberos realm of the machine belongs to.
	    </para>
            <para>
              The <replaceable>nametype</replaceable> field has 13
              values:
              <varname>name</varname>, <varname>subdomain</varname>,
              <varname>wildcard</varname>, <varname>self</varname>,
	      <varname>selfsub</varname>, <varname>selfwild</varname>,
	      <varname>krb5-self</varname>, <varname>ms-self</varname>,
	      <varname>krb5-subdomain</varname>,
	      <varname>ms-subdomain</varname>,
	      <varname>tcp-self</varname>, <varname>6to4-self</varname>,
	      <varname>zonesub</varname>, and <varname>external</varname>.
            </para>
            <informaltable>
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="0.819in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="3.681in"/>
                <tbody>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>name</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			Exact-match semantics.  This rule matches
			when the name being updated is identical
			to the contents of the
			<replaceable>name</replaceable> field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>subdomain</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule matches when the name being updated
			is a subdomain of, or identical to, the
			contents of the <replaceable>name</replaceable>
			field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>zonesub</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule is similar to subdomain, except that
			it matches when the name being updated is a
			subdomain of the zone in which the
			<command>update-policy</command> statement
			appears.  This obviates the need to type the zone
			name twice, and enables the use of a standard
			<command>update-policy</command> statement in
			multiple zones without modification.
		      </para>
		      <para>
                        When this rule is used, the
                        <replaceable>name</replaceable> field is omitted.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>wildcard</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			The <replaceable>name</replaceable> field
			is subject to DNS wildcard expansion, and
			this rule matches when the name being updated
			name is a valid expansion of the wildcard.
		      </para>
		    </entry>
		  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <varname>self</varname>
                      </para>
                    </entry>
                    <entry colname="2">
		      <para>
			This rule matches when the name being updated
			matches the contents of the
			<replaceable>identity</replaceable> field.
			The <replaceable>name</replaceable> field
			is ignored, but should be the same as the
			<replaceable>identity</replaceable> field.
			The <varname>self</varname> nametype is
			most useful when allowing using one key per
			name to update, where the key has the same
			name as the name to be updated.  The
			<replaceable>identity</replaceable> would
			be specified as <constant>*</constant> (an asterisk) in
			this case.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>selfsub</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule is similar to <varname>self</varname>
			except that subdomains of <varname>self</varname>
			can also be updated.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>selfwild</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule is similar to <varname>self</varname>
			except that only subdomains of
			<varname>self</varname> can be updated.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>ms-self</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule takes a Windows machine principal
			(machine$@REALM) for machine in REALM and
			and converts it machine.realm allowing the machine 
                        to update machine.realm.  The REALM to be matched
			is specified in the <replaceable>identity</replaceable>
			field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>ms-subdomain</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule takes a Windows machine principal 
			(machine$@REALM) for machine in REALM and
			converts it to machine.realm allowing the machine
			to update subdomains of machine.realm.  The REALM
			to be matched is specified in the
			<replaceable>identity</replaceable> field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>krb5-self</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule takes a Kerberos machine principal
			(host/machine@REALM) for machine in REALM and
			and converts it machine.realm allowing the machine 
                        to update machine.realm.  The REALM to be matched
			is specified in the <replaceable>identity</replaceable>
			field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>krb5-subdomain</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule takes a Kerberos machine principal 
			(host/machine@REALM) for machine in REALM and
			converts it to machine.realm allowing the machine
			to update subdomains of machine.realm.  The REALM
			to be matched is specified in the
			<replaceable>identity</replaceable> field.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>tcp-self</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			Allow updates that have been sent via TCP and
			for which the standard mapping from the initiating
			IP address into the IN-ADDR.ARPA and IP6.ARPA
			namespaces match the name to be updated.
		      </para>
		      <note>
			It is theoretically possible to spoof these TCP
			sessions.
		      </note>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>6to4-self</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			Allow the 6to4 prefix to be update by any TCP
			connection from the 6to4 network or from the
			corresponding IPv4 address.  This is intended
			to allow NS or DNAME RRsets to be added to the
			reverse tree.
		      </para>
		      <note>
			It is theoretically possible to spoof these TCP
			sessions.
		      </note>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para>
			<varname>external</varname>
		      </para>
		    </entry> <entry colname="2">
		      <para>
			This rule allows <command>named</command>
			to defer the decision of whether to allow a
			given update to an external daemon.
		      </para>
		      <para>
			The method of communicating with the daemon is
			specified in the <replaceable>identity</replaceable>
			field, the format of which is
			"<constant>local:</constant><replaceable>path</replaceable>",
			where <replaceable>path</replaceable> is the location
                        of a UNIX-domain socket.  (Currently, "local" is the
                        only supported mechanism.)
		      </para>
		      <para>
			Requests to the external daemon are sent over the
			UNIX-domain socket as datagrams with the following
			format:
		      </para>
		      <programlisting>
   Protocol version number (4 bytes, network byte order, currently 1)
   Request length (4 bytes, network byte order)
   Signer (null-terminated string)
   Name (null-terminated string)
   TCP source address (null-terminated string)
   Rdata type (null-terminated string)
   Key (null-terminated string)
   TKEY token length (4 bytes, network byte order)
   TKEY token (remainder of packet)</programlisting>
		      <para>
			The daemon replies with a four-byte value in
			network byte order, containing either 0 or 1; 0
			indicates that the specified update is not
			permitted, and 1 indicates that it is.
		      </para>
		    </entry>
		  </row>
                </tbody>
              </tgroup>
            </informaltable>

            <para>
              In all cases, the <replaceable>name</replaceable>
              field must specify a fully-qualified domain name.
            </para>

	    <para>
	      If no types are explicitly specified, this rule matches
	      all types except RRSIG, NS, SOA, NSEC and NSEC3. Types
	      may be specified by name, including "ANY" (ANY matches
	      all types except NSEC and NSEC3, which can never be
	      updated).  Note that when an attempt is made to delete
	      all records associated with a name, the rules are
	      checked for each existing record type.
	    </para>
          </sect3>
        </sect2>
      </sect1>
      <sect1>
        <title>Zone File</title>
        <sect2 id="types_of_resource_records_and_when_to_use_them">
          <title>Types of Resource Records and When to Use Them</title>
          <para>
            This section, largely borrowed from RFC 1034, describes the
            concept of a Resource Record (RR) and explains when each is used.
            Since the publication of RFC 1034, several new RRs have been
            identified
            and implemented in the DNS. These are also included.
          </para>
          <sect3>
            <title>Resource Records</title>

            <para>
              A domain name identifies a node.  Each node has a set of
              resource information, which may be empty.  The set of resource
              information associated with a particular name is composed of
              separate RRs. The order of RRs in a set is not significant and
              need not be preserved by name servers, resolvers, or other
              parts of the DNS. However, sorting of multiple RRs is
              permitted for optimization purposes, for example, to specify
              that a particular nearby server be tried first. See <xref linkend="the_sortlist_statement"/> and <xref linkend="rrset_ordering"/>.
            </para>

            <para>
              The components of a Resource Record are:
            </para>
            <informaltable colsep="0" rowsep="0">
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="1.000in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="3.500in"/>
                <tbody>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        owner name
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The domain name where the RR is found.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        type
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        An encoded 16-bit value that specifies
                        the type of the resource record.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        TTL
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The time-to-live of the RR. This field
                        is a 32-bit integer in units of seconds, and is
                        primarily used by
                        resolvers when they cache RRs. The TTL describes how
                        long a RR can
                        be cached before it should be discarded.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        class
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        An encoded 16-bit value that identifies
                        a protocol family or instance of a protocol.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        RDATA
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The resource data.  The format of the
                        data is type (and sometimes class) specific.
                      </para>
                    </entry>
                  </row>
                </tbody>
              </tgroup>
            </informaltable>
            <para>
              The following are <emphasis>types</emphasis> of valid RRs:
            </para>
            <informaltable colsep="0" rowsep="0">
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="0.875in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="3.625in"/>
                <tbody>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        A
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A host address.  In the IN class, this is a
                        32-bit IP address.  Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        AAAA
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        IPv6 address.  Described in RFC 1886.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        A6
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        IPv6 address.  This can be a partial
                        address (a suffix) and an indirection to the name
                        where the rest of the
                        address (the prefix) can be found.  Experimental.
                        Described in RFC 2874.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        AFSDB
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Location of AFS database servers.
                        Experimental.  Described in RFC 1183.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        APL
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Address prefix list.  Experimental.
                        Described in RFC 3123.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        CERT
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Holds a digital certificate.
                        Described in RFC 2538.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        CNAME
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Identifies the canonical name of an alias.
                        Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        DHCID
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			Is used for identifying which DHCP client is
			associated with this name.  Described in RFC 4701.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        DNAME
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Replaces the domain name specified with
                        another name to be looked up, effectively aliasing an
                        entire
                        subtree of the domain name space rather than a single
                        record
                        as in the case of the CNAME RR.
                        Described in RFC 2672.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        DNSKEY
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Stores a public key associated with a signed
                        DNS zone.  Described in RFC 4034.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        DS
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Stores the hash of a public key associated with a
                        signed DNS zone.  Described in RFC 4034.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        GPOS
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Specifies the global position.  Superseded by LOC.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        HINFO
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Identifies the CPU and OS used by a host.
                        Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        IPSECKEY
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			Provides a method for storing IPsec keying material in
			DNS.  Described in RFC 4025.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        ISDN
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Representation of ISDN addresses.
                        Experimental.  Described in RFC 1183.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        KEY
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Stores a public key associated with a
                        DNS name.  Used in original DNSSEC; replaced
			by DNSKEY in DNSSECbis, but still used with
			SIG(0).  Described in RFCs 2535 and 2931.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        KX
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Identifies a key exchanger for this
                        DNS name.  Described in RFC 2230.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        LOC
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        For storing GPS info.  Described in RFC 1876.
                        Experimental.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        MX
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Identifies a mail exchange for the domain with
                        a 16-bit preference value (lower is better)
                        followed by the host name of the mail exchange.
                        Described in RFC 974, RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NAPTR
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Name authority pointer.  Described in RFC 2915.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NSAP
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A network service access point.
                        Described in RFC 1706.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NS
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The authoritative name server for the
                        domain.  Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NSEC
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Used in DNSSECbis to securely indicate that
                        RRs with an owner name in a certain name interval do
                        not exist in
                        a zone and indicate what RR types are present for an
                        existing name.
                        Described in RFC 4034.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NSEC3
                      </para>
                    </entry>
		    <entry colname="2">
		      <para>
			Used in DNSSECbis to securely indicate that
			RRs with an owner name in a certain name
			interval do not exist in a zone and indicate
			what RR types are present for an existing
			name.  NSEC3 differs from NSEC in that it
			prevents zone enumeration but is more
			computationally expensive on both the server
			and the client than NSEC.  Described in RFC
			5155.
		      </para>
		    </entry>
		  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NSEC3PARAM
                      </para>
                    </entry>
		    <entry colname="2">
		      <para>
			Used in DNSSECbis to tell the authoritative
			server which NSEC3 chains are available to use.
			Described in RFC 5155.
		      </para>
		    </entry>
		  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        NXT
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Used in DNSSEC to securely indicate that
                        RRs with an owner name in a certain name interval do
                        not exist in
                        a zone and indicate what RR types are present for an
                        existing name.
			Used in original DNSSEC; replaced by NSEC in
			DNSSECbis.
                        Described in RFC 2535.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        PTR
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        A pointer to another part of the domain
                        name space.  Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        PX
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Provides mappings between RFC 822 and X.400
                        addresses.  Described in RFC 2163.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        RP
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Information on persons responsible
                        for the domain.  Experimental.  Described in RFC 1183.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        RRSIG
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Contains DNSSECbis signature data.  Described
			in RFC 4034.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        RT
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Route-through binding for hosts that
                        do not have their own direct wide area network
                        addresses.
                        Experimental.  Described in RFC 1183.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        SIG
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Contains DNSSEC signature data.  Used in
			original DNSSEC; replaced by RRSIG in
			DNSSECbis, but still used for SIG(0).
			Described in RFCs 2535 and 2931.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        SOA
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Identifies the start of a zone of authority.
                        Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        SPF
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			Contains the Sender Policy Framework information
			for a given email domain.  Described in RFC 4408.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        SRV
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Information about well known network
                        services (replaces WKS).  Described in RFC 2782.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        SSHFP
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
			Provides a way to securely publish a secure shell key's
			fingerprint.  Described in RFC 4255.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        TXT
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Text records.  Described in RFC 1035.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        WKS
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Information about which well known
                        network services, such as SMTP, that a domain
                        supports. Historical.
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        X25
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Representation of X.25 network addresses.
                        Experimental.  Described in RFC 1183.
                      </para>
                    </entry>
                  </row>
                </tbody>
              </tgroup>
            </informaltable>
            <para>
              The following <emphasis>classes</emphasis> of resource records
              are currently valid in the DNS:
            </para>
            <informaltable colsep="0" rowsep="0"><tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="0.875in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="3.625in"/>
                <tbody>

                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        IN
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        The Internet.
                      </para>
                    </entry>
                  </row>

                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        CH
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Chaosnet, a LAN protocol created at MIT in the
                        mid-1970s.
                        Rarely used for its historical purpose, but reused for
                        BIND's
                        built-in server information zones, e.g.,
                        <literal>version.bind</literal>.
                      </para>
                    </entry>
                  </row>

                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        HS
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        Hesiod, an information service
                        developed by MIT's Project Athena. It is used to share
                        information
                        about various systems databases, such as users,
                        groups, printers
                        and so on.
                      </para>
                    </entry>
                  </row>

                </tbody>
              </tgroup>
            </informaltable>

            <para>
              The owner name is often implicit, rather than forming an
              integral
              part of the RR.  For example, many name servers internally form
              tree
              or hash structures for the name space, and chain RRs off nodes.
              The remaining RR parts are the fixed header (type, class, TTL)
              which is consistent for all RRs, and a variable part (RDATA)
              that
              fits the needs of the resource being described.
            </para>
            <para>
              The meaning of the TTL field is a time limit on how long an
              RR can be kept in a cache.  This limit does not apply to
              authoritative
              data in zones; it is also timed out, but by the refreshing
              policies
              for the zone.  The TTL is assigned by the administrator for the
              zone where the data originates.  While short TTLs can be used to
              minimize caching, and a zero TTL prohibits caching, the
              realities
              of Internet performance suggest that these times should be on
              the
              order of days for the typical host.  If a change can be
              anticipated,
              the TTL can be reduced prior to the change to minimize
              inconsistency
              during the change, and then increased back to its former value
              following
              the change.
            </para>
            <para>
              The data in the RDATA section of RRs is carried as a combination
              of binary strings and domain names.  The domain names are
              frequently
              used as "pointers" to other data in the DNS.
            </para>
          </sect3>
          <sect3>
            <title>Textual expression of RRs</title>
            <para>
              RRs are represented in binary form in the packets of the DNS
              protocol, and are usually represented in highly encoded form
              when
              stored in a name server or resolver.  In the examples provided
              in
              RFC 1034, a style similar to that used in master files was
              employed
              in order to show the contents of RRs.  In this format, most RRs
              are shown on a single line, although continuation lines are
              possible
              using parentheses.
            </para>
            <para>
              The start of the line gives the owner of the RR.  If a line
              begins with a blank, then the owner is assumed to be the same as
              that of the previous RR.  Blank lines are often included for
              readability.
            </para>
            <para>
              Following the owner, we list the TTL, type, and class of the
              RR.  Class and type use the mnemonics defined above, and TTL is
              an integer before the type field.  In order to avoid ambiguity
              in
              parsing, type and class mnemonics are disjoint, TTLs are
              integers,
              and the type mnemonic is always last. The IN class and TTL
              values
              are often omitted from examples in the interests of clarity.
            </para>
            <para>
              The resource data or RDATA section of the RR are given using
              knowledge of the typical representation for the data.
            </para>
            <para>
              For example, we might show the RRs carried in a message as:
            </para>
            <informaltable colsep="0" rowsep="0"><tgroup cols="3" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="1.381in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="1.020in"/>
                <colspec colname="3" colnum="3" colsep="0" colwidth="2.099in"/>
                <tbody>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <literal>ISI.EDU.</literal>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>MX</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>10 VENERA.ISI.EDU.</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para/>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>MX</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>10 VAXA.ISI.EDU</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <literal>VENERA.ISI.EDU</literal>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>128.9.0.32</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para/>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>10.1.0.52</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <literal>VAXA.ISI.EDU</literal>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>10.2.0.27</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
                    <entry colname="1">
                      <para/>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>128.9.0.33</literal>
                      </para>
                    </entry>
                  </row>
                </tbody>
              </tgroup>
            </informaltable>
            <para>
              The MX RRs have an RDATA section which consists of a 16-bit
              number followed by a domain name.  The address RRs use a
              standard
              IP address format to contain a 32-bit internet address.
            </para>
            <para>
              The above example shows six RRs, with two RRs at each of three
              domain names.
            </para>
            <para>
              Similarly we might see:
            </para>
            <informaltable colsep="0" rowsep="0"><tgroup cols="3" colsep="0" rowsep="0" tgroupstyle="4Level-table">
                <colspec colname="1" colnum="1" colsep="0" colwidth="1.491in"/>
                <colspec colname="2" colnum="2" colsep="0" colwidth="1.067in"/>
                <colspec colname="3" colnum="3" colsep="0" colwidth="2.067in"/>
                <tbody>
                  <row rowsep="0">
                    <entry colname="1">
                      <para>
                        <literal>XX.LCS.MIT.EDU.</literal>
                      </para>
                    </entry>
                    <entry colname="2">
                      <para>
                        <literal>IN A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>10.0.0.44</literal>
                      </para>
                    </entry>
                  </row>
                  <row rowsep="0">
		    <entry colname="1"/>
                    <entry colname="2">
                      <para>
                        <literal>CH A</literal>
                      </para>
                    </entry>
                    <entry colname="3">
                      <para>
                        <literal>MIT.EDU. 2420</literal>
                      </para>
                    </entry>
                  </row>
                </tbody>
              </tgroup>
            </informaltable>
            <para>
              This example shows two addresses for
	      <literal>XX.LCS.MIT.EDU</literal>, each of a different class.
            </para>
          </sect3>
        </sect2>

        <sect2>
          <title>Discussion of MX Records</title>

          <para>
            As described above, domain servers store information as a
            series of resource records, each of which contains a particular
            piece of information about a given domain name (which is usually,
            but not always, a host). The simplest way to think of a RR is as
            a typed pair of data, a domain name matched with a relevant datum,
            and stored with some additional type information to help systems
            determine when the RR is relevant.
          </para>

          <para>
            MX records are used to control delivery of email. The data
            specified in the record is a priority and a domain name. The
            priority
            controls the order in which email delivery is attempted, with the
            lowest number first. If two priorities are the same, a server is
            chosen randomly. If no servers at a given priority are responding,
            the mail transport agent will fall back to the next largest
            priority.
            Priority numbers do not have any absolute meaning &mdash; they are
            relevant
            only respective to other MX records for that domain name. The
            domain
            name given is the machine to which the mail will be delivered.
	    It <emphasis>must</emphasis> have an associated address record
	    (A or AAAA) &mdash; CNAME is not sufficient.
          </para>
          <para>
            For a given domain, if there is both a CNAME record and an
            MX record, the MX record is in error, and will be ignored.
            Instead,
            the mail will be delivered to the server specified in the MX
            record
            pointed to by the CNAME.
            For example:
          </para>
          <informaltable colsep="0" rowsep="0">
            <tgroup cols="5" colsep="0" rowsep="0" tgroupstyle="3Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="1.708in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="0.444in"/>
              <colspec colname="3" colnum="3" colsep="0" colwidth="0.444in"/>
              <colspec colname="4" colnum="4" colsep="0" colwidth="0.976in"/>
              <colspec colname="5" colnum="5" colsep="0" colwidth="1.553in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      <literal>example.com.</literal>
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN</literal>
                    </para>
                  </entry>
                  <entry colname="3">
                    <para>
                      <literal>MX</literal>
                    </para>
                  </entry>
                  <entry colname="4">
                    <para>
                      <literal>10</literal>
                    </para>
                  </entry>
                  <entry colname="5">
                    <para>
                      <literal>mail.example.com.</literal>
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para/>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN</literal>
                    </para>
                  </entry>
                  <entry colname="3">
                    <para>
                      <literal>MX</literal>
                    </para>
                  </entry>
                  <entry colname="4">
                    <para>
                      <literal>10</literal>
                    </para>
                  </entry>
                  <entry colname="5">
                    <para>
                      <literal>mail2.example.com.</literal>
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para/>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN</literal>
                    </para>
                  </entry>
                  <entry colname="3">
                    <para>
                      <literal>MX</literal>
                    </para>
                  </entry>
                  <entry colname="4">
                    <para>
                      <literal>20</literal>
                    </para>
                  </entry>
                  <entry colname="5">
                    <para>
                      <literal>mail.backup.org.</literal>
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      <literal>mail.example.com.</literal>
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN</literal>
                    </para>
                  </entry>
                  <entry colname="3">
                    <para>
                      <literal>A</literal>
                    </para>
                  </entry>
                  <entry colname="4">
                    <para>
                      <literal>10.0.0.1</literal>
                    </para>
                  </entry>
                  <entry colname="5">
                    <para/>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      <literal>mail2.example.com.</literal>
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN</literal>
                    </para>
                  </entry>
                  <entry colname="3">
                    <para>
                      <literal>A</literal>
                    </para>
                  </entry>
                  <entry colname="4">
                    <para>
                      <literal>10.0.0.2</literal>
                    </para>
                  </entry>
                  <entry colname="5">
                    <para/>
                  </entry>
                </row>
              </tbody>
            </tgroup>
            </informaltable><para>
            Mail delivery will be attempted to <literal>mail.example.com</literal> and
            <literal>mail2.example.com</literal> (in
            any order), and if neither of those succeed, delivery to <literal>mail.backup.org</literal> will
            be attempted.
          </para>
        </sect2>
        <sect2 id="Setting_TTLs">
          <title>Setting TTLs</title>
          <para>
            The time-to-live of the RR field is a 32-bit integer represented
            in units of seconds, and is primarily used by resolvers when they
            cache RRs. The TTL describes how long a RR can be cached before it
            should be discarded. The following three types of TTL are
            currently
            used in a zone file.
          </para>
          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="3Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="0.750in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="4.375in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      SOA
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      The last field in the SOA is the negative
                      caching TTL. This controls how long other servers will
                      cache no-such-domain
                      (NXDOMAIN) responses from you.
                    </para>
                    <para>
                      The maximum time for
                      negative caching is 3 hours (3h).
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      $TTL
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      The $TTL directive at the top of the
                      zone file (before the SOA) gives a default TTL for every
                      RR without
                      a specific TTL set.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      RR TTLs
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      Each RR can have a TTL as the second
                      field in the RR, which will control how long other
                      servers can cache
                      the it.
                    </para>
                  </entry>
                </row>
              </tbody>
            </tgroup>
          </informaltable>
          <para>
            All of these TTLs default to units of seconds, though units
            can be explicitly specified, for example, <literal>1h30m</literal>.
          </para>
        </sect2>
        <sect2>
          <title>Inverse Mapping in IPv4</title>
          <para>
            Reverse name resolution (that is, translation from IP address
            to name) is achieved by means of the <emphasis>in-addr.arpa</emphasis> domain
            and PTR records. Entries in the in-addr.arpa domain are made in
            least-to-most significant order, read left to right. This is the
            opposite order to the way IP addresses are usually written. Thus,
            a machine with an IP address of 10.1.2.3 would have a
            corresponding
            in-addr.arpa name of
            3.2.1.10.in-addr.arpa. This name should have a PTR resource record
            whose data field is the name of the machine or, optionally,
            multiple
            PTR records if the machine has more than one name. For example,
            in the <optional>example.com</optional> domain:
          </para>
          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="3Level-table">
              <colspec colname="1" colnum="1" colsep="0" colwidth="1.125in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="4.000in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      <literal>$ORIGIN</literal>
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>2.1.10.in-addr.arpa</literal>
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para>
                      <literal>3</literal>
                    </para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <literal>IN PTR foo.example.com.</literal>
                    </para>
                  </entry>
                </row>
              </tbody>
            </tgroup>
          </informaltable>
          <note>
            <para>
              The <command>$ORIGIN</command> lines in the examples
              are for providing context to the examples only &mdash; they do not
              necessarily
              appear in the actual usage. They are only used here to indicate
              that the example is relative to the listed origin.
            </para>
          </note>
        </sect2>
        <sect2>
          <title>Other Zone File Directives</title>
          <para>
            The Master File Format was initially defined in RFC 1035 and
            has subsequently been extended. While the Master File Format
            itself
            is class independent all records in a Master File must be of the
            same
            class.
          </para>
          <para>
            Master File Directives include <command>$ORIGIN</command>, <command>$INCLUDE</command>,
            and <command>$TTL.</command>
          </para>
          <sect3>
            <title>The <command>@</command> (at-sign)</title>
            <para>
              When used in the label (or name) field, the asperand or
              at-sign (@) symbol represents the current origin.
              At the start of the zone file, it is the 
              &lt;<varname>zone_name</varname>&gt; (followed by
              trailing dot).
            </para>
          </sect3>
          <sect3>
            <title>The <command>$ORIGIN</command> Directive</title>
            <para>
              Syntax: <command>$ORIGIN</command>
	      <replaceable>domain-name</replaceable>
              <optional><replaceable>comment</replaceable></optional>
            </para>
            <para><command>$ORIGIN</command>
	      sets the domain name that will be appended to any
              unqualified records. When a zone is first read in there
              is an implicit <command>$ORIGIN</command>
              &lt;<varname>zone_name</varname>&gt;<command>.</command>
              (followed by trailing dot).
              The current <command>$ORIGIN</command> is appended to
              the domain specified in the <command>$ORIGIN</command>
              argument if it is not absolute.
            </para>

<programlisting>
$ORIGIN example.com.
WWW     CNAME   MAIN-SERVER
</programlisting>

            <para>
              is equivalent to
            </para>

<programlisting>
WWW.EXAMPLE.COM. CNAME MAIN-SERVER.EXAMPLE.COM.
</programlisting>

          </sect3>
          <sect3>
            <title>The <command>$INCLUDE</command> Directive</title>
            <para>
              Syntax: <command>$INCLUDE</command>
              <replaceable>filename</replaceable>
              <optional>
<replaceable>origin</replaceable> </optional>
              <optional> <replaceable>comment</replaceable> </optional>
            </para>
            <para>
              Read and process the file <filename>filename</filename> as
              if it were included into the file at this point.  If <command>origin</command> is
              specified the file is processed with <command>$ORIGIN</command> set
              to that value, otherwise the current <command>$ORIGIN</command> is
              used.
            </para>
            <para>
              The origin and the current domain name
              revert to the values they had prior to the <command>$INCLUDE</command> once
              the file has been read.
            </para>
            <note>
              <para>
                RFC 1035 specifies that the current origin should be restored
                after
                an <command>$INCLUDE</command>, but it is silent
                on whether the current
                domain name should also be restored.  BIND 9 restores both of
                them.
                This could be construed as a deviation from RFC 1035, a
                feature, or both.
              </para>
            </note>
          </sect3>
          <sect3>
            <title>The <command>$TTL</command> Directive</title>
            <para>
              Syntax: <command>$TTL</command>
              <replaceable>default-ttl</replaceable>
              <optional>
<replaceable>comment</replaceable> </optional>
            </para>
            <para>
              Set the default Time To Live (TTL) for subsequent records
              with undefined TTLs. Valid TTLs are of the range 0-2147483647
              seconds.
            </para>
            <para><command>$TTL</command>
	       is defined in RFC 2308.
            </para>
          </sect3>
        </sect2>
        <sect2>
          <title><acronym>BIND</acronym> Master File Extension: the  <command>$GENERATE</command> Directive</title>
          <para>
            Syntax: <command>$GENERATE</command>
	    <replaceable>range</replaceable>
	    <replaceable>lhs</replaceable>
            <optional><replaceable>ttl</replaceable></optional>
            <optional><replaceable>class</replaceable></optional>
	    <replaceable>type</replaceable>
	    <replaceable>rhs</replaceable>
            <optional><replaceable>comment</replaceable></optional>
          </para>
          <para><command>$GENERATE</command>
	    is used to create a series of resource records that only
            differ from each other by an
            iterator. <command>$GENERATE</command> can be used to
            easily generate the sets of records required to support
            sub /24 reverse delegations described in RFC 2317:
            Classless IN-ADDR.ARPA delegation.
          </para>

<programlisting>$ORIGIN 0.0.192.IN-ADDR.ARPA.
$GENERATE 1-2 @ NS SERVER$.EXAMPLE.
$GENERATE 1-127 $ CNAME $.0</programlisting>

          <para>
            is equivalent to
          </para>

<programlisting>0.0.0.192.IN-ADDR.ARPA. NS SERVER1.EXAMPLE.
0.0.0.192.IN-ADDR.ARPA. NS SERVER2.EXAMPLE.
1.0.0.192.IN-ADDR.ARPA. CNAME 1.0.0.0.192.IN-ADDR.ARPA.
2.0.0.192.IN-ADDR.ARPA. CNAME 2.0.0.0.192.IN-ADDR.ARPA.
...
127.0.0.192.IN-ADDR.ARPA. CNAME 127.0.0.0.192.IN-ADDR.ARPA.
</programlisting>

	   <para>
	    Generate a set of A and MX records.  Note the MX's right hand
	    side is a quoted string.  The quotes will be stripped when the
	    right hand side is processed.
	   </para>

<programlisting>
$ORIGIN EXAMPLE.
$GENERATE 1-127 HOST-$ A 1.2.3.$
$GENERATE 1-127 HOST-$ MX "0 ."</programlisting>

          <para>
            is equivalent to
          </para>

<programlisting>HOST-1.EXAMPLE.   A  1.2.3.1
HOST-1.EXAMPLE.   MX 0 .
HOST-2.EXAMPLE.   A  1.2.3.2
HOST-2.EXAMPLE.   MX 0 .
HOST-3.EXAMPLE.   A  1.2.3.3
HOST-3.EXAMPLE.   MX 0 .
...
HOST-127.EXAMPLE. A  1.2.3.127
HOST-127.EXAMPLE. MX 0 .
</programlisting>

          <informaltable colsep="0" rowsep="0">
            <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="3Level-table">
                        <colspec colname="1" colnum="1" colsep="0" colwidth="0.875in"/>
              <colspec colname="2" colnum="2" colsep="0" colwidth="4.250in"/>
              <tbody>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>range</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      This can be one of two forms: start-stop
                      or start-stop/step. If the first form is used, then step
                      is set to
                      1. All of start, stop and step must be positive.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>lhs</command></para>
                  </entry>
                  <entry colname="2">
                    <para>This
		      describes the owner name of the resource records
                      to be created.  Any single <command>$</command>
                      (dollar sign)
                      symbols within the <command>lhs</command> string
                      are replaced by the iterator value.

                      To get a $ in the output, you need to escape the
                      <command>$</command> using a backslash
                      <command>\</command>,
                      e.g. <command>\$</command>. The
                      <command>$</command> may optionally be followed
                      by modifiers which change the offset from the
                      iterator, field width and base.

                      Modifiers are introduced by a
                      <command>{</command> (left brace) immediately following the
                      <command>$</command> as
                      <command>${offset[,width[,base]]}</command>.
                      For example, <command>${-20,3,d}</command>
                      subtracts 20 from the current value, prints the
                      result as a decimal in a zero-padded field of
                      width 3.

		      Available output forms are decimal
                      (<command>d</command>), octal
                      (<command>o</command>), hexadecimal
                      (<command>x</command> or <command>X</command>
                      for uppercase) and nibble
		      (<command>n</command> or <command>N</command>\
		      for uppercase).  The default modifier is
                      <command>${0,0,d}</command>.  If the
                      <command>lhs</command> is not absolute, the
                      current <command>$ORIGIN</command> is appended
                      to the name.
                    </para>
		    <para>
		      In nibble mode the value will be treated as
		      if it was a reversed hexadecimal string
		      with each hexadecimal digit as a separate
		      label.  The width field includes the label
		      separator.
		    </para>
		    <para>
		      For compatibility with earlier versions,
		      <command>$$</command> is still recognized as
		      indicating a literal $ in the output.
		    </para>
		  </entry>
		</row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>ttl</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Specifies the time-to-live of the generated records. If
                      not specified this will be inherited using the
                      normal TTL inheritance rules.
                    </para>
                    <para><command>class</command>
		      and <command>ttl</command> can be
                      entered in either order.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>class</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Specifies the class of the generated records.
                      This must match the zone class if it is
                      specified.
                    </para>
                    <para><command>class</command>
		      and <command>ttl</command> can be
                      entered in either order.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>type</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
		      Any valid type.
                    </para>
                  </entry>
                </row>
                <row rowsep="0">
                  <entry colname="1">
                    <para><command>rhs</command></para>
                  </entry>
                  <entry colname="2">
                    <para>
                      <command>rhs</command>, optionally, quoted string.
                    </para>
                  </entry>
                </row>
              </tbody>
            </tgroup>
          </informaltable>
          <para>
            The <command>$GENERATE</command> directive is a <acronym>BIND</acronym> extension
            and not part of the standard zone file format.
          </para>
          <para>
            BIND 8 does not support the optional TTL and CLASS fields.
          </para>
        </sect2>

	<sect2 id="zonefile_format">
	  <title>Additional File Formats</title>
	  <para>
	    In addition to the standard textual format, BIND 9
	    supports the ability to read or dump to zone files in
	    other formats.  The <constant>raw</constant> format is
	    currently available as an additional format.  It is a
	    binary format representing BIND 9's internal data
	    structure directly, thereby remarkably improving the
	    loading time.
	  </para>
	  <para>
	    For a primary server, a zone file in the
	    <constant>raw</constant> format is expected to be
	    generated from a textual zone file by the
	    <command>named-compilezone</command> command.  For a
	    secondary server or for a dynamic zone, it is automatically
	    generated (if this format is specified by the
	    <command>masterfile-format</command> option) when
	    <command>named</command> dumps the zone contents after
	    zone transfer or when applying prior updates.
	  </para>
	  <para>
	    If a zone file in a binary format needs manual modification,
	    it first must be converted to a textual form by the
	    <command>named-compilezone</command> command.  All
	    necessary modification should go to the text file, which
	    should then be converted to the binary form by the
	    <command>named-compilezone</command> command again.
	  </para>
    	  <para>
	     Although the <constant>raw</constant> format uses the
	     network byte order and avoids architecture-dependent
	     data alignment so that it is as much portable as
	     possible, it is primarily expected to be used inside
	     the same single system.  In order to export a zone
	     file in the <constant>raw</constant> format or make a
	     portable backup of the file, it is recommended to
	     convert the file to the standard textual representation.
	  </para>
	</sect2>
      </sect1>

      <sect1 id="statistics">
        <title>BIND9 Statistics</title>
        <para>
	  <acronym>BIND</acronym> 9 maintains lots of statistics
	  information and provides several interfaces for users to
	  get access to the statistics.
	  The available statistics include all statistics counters
	  that were available in <acronym>BIND</acronym> 8 and
	  are meaningful in <acronym>BIND</acronym> 9,
	  and other information that is considered useful.
        </para>

        <para>
	  The statistics information is categorized into the following
	  sections.
        </para>

	<informaltable frame="all">
          <tgroup cols="2">
            <colspec colname="1" colnum="1" colsep="0" colwidth="3.300in"/>
            <colspec colname="2" colnum="2" colsep="0" colwidth="2.625in"/>
            <tbody>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Incoming Requests</para>
                </entry>
                <entry colname="2">
                  <para>
                    The number of incoming DNS requests for each OPCODE.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Incoming Queries</para>
                </entry>
                <entry colname="2">
                  <para>
		    The number of incoming queries for each RR type.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Outgoing Queries</para>
                </entry>
                <entry colname="2">
                  <para>
                    The number of outgoing queries for each RR
                    type sent from the internal resolver.
		    Maintained per view.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Name Server Statistics</para>
                </entry>
                <entry colname="2">
                  <para>
                    Statistics counters about incoming request processing.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Zone Maintenance Statistics</para>
                </entry>
                <entry colname="2">
                  <para>
                    Statistics counters regarding zone maintenance
                    operations such as zone transfers.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Resolver Statistics</para>
                </entry>
                <entry colname="2">
                  <para>
                    Statistics counters about name resolution
                    performed in the internal resolver.
		    Maintained per view.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Cache DB RRsets</para>
                </entry>
                <entry colname="2">
                  <para>
		    The number of RRsets per RR type and nonexistent
		    names stored in the cache database.
		    If the exclamation mark (!) is printed for a RR
		    type, it means that particular type of RRset is
		    known to be nonexistent (this is also known as
		    "NXRRSET").
		    Maintained per view.
                  </para>
                </entry>
	      </row>

	      <row rowsep="0">
                <entry colname="1">
                  <para>Socket I/O Statistics</para>
                </entry>
                <entry colname="2">
                  <para>
                    Statistics counters about network related events.
                  </para>
                </entry>
	      </row>

	    </tbody>
	  </tgroup>
	</informaltable>

	<para>
	  A subset of Name Server Statistics is collected and shown
	  per zone for which the server has the authority when
	  <command>zone-statistics</command> is set to
	  <userinput>yes</userinput>.
	  These statistics counters are shown with their zone and view
	  names.
	  In some cases the view names are omitted for the default view.
	</para>

	<para>
	  There are currently two user interfaces to get access to the
	  statistics.
	  One is in the plain text format dumped to the file specified
	  by the <command>statistics-file</command> configuration option.
	  The other is remotely accessible via a statistics channel
	  when the <command>statistics-channels</command> statement
	  is specified in the configuration file
	  (see <xref linkend="statschannels"/>.)
	</para>

        <sect3 id="statsfile">
          <title>The Statistics File</title>
          <para>
            The text format statistics dump begins with a line, like:
	  </para>
          <para>
	    <command>+++ Statistics Dump +++ (973798949)</command>
	  </para>
	  <para>
	    The number in parentheses is a standard
            Unix-style timestamp, measured as seconds since January 1, 1970.

            Following
            that line is a set of statistics information, which is categorized
            as described above.
	    Each section begins with a line, like:
	  </para>

	  <para>
	    <command>++ Name Server Statistics ++</command>
	  </para>

	  <para>
	    Each section consists of lines, each containing the statistics
	    counter value followed by its textual description.
	    See below for available counters.
	    For brevity, counters that have a value of 0 are not shown
	    in the statistics file.
	  </para>

	  <para>
	    The statistics dump ends with the line where the
            number is identical to the number in the beginning line; for example:
          </para>
          <para>
	    <command>--- Statistics Dump --- (973798949)</command>
          </para>
	</sect3>

        <sect2 id="statistics_counters">
	  <title>Statistics Counters</title>
	  <para>
	    The following tables summarize statistics counters that
	    <acronym>BIND</acronym> 9 provides.
	    For each row of the tables, the leftmost column is the
	    abbreviated symbol name of that counter.
	    These symbols are shown in the statistics information
	    accessed via an HTTP statistics channel.
	    The rightmost column gives the description of the counter,
	    which is also shown in the statistics file
	    (but, in this document, possibly with slight modification
	    for better readability).
	    Additional notes may also be provided in this column.
	    When a middle column exists between these two columns,
	    it gives the corresponding counter name of the
	    <acronym>BIND</acronym> 8 statistics, if applicable.
	  </para>

	  <sect3>
            <title>Name Server Statistics Counters</title>

            <informaltable colsep="0" rowsep="0">
              <tgroup cols="3" colsep="0" rowsep="0" tgroupstyle="4Level-table">
		<colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
		<colspec colname="2" colnum="2" colsep="0" colwidth="1.150in"/>
		<colspec colname="3" colnum="3" colsep="0" colwidth="3.350in"/>
		<tbody>
		  <row>
		    <entry colname="1">
                      <para>
			<emphasis>Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="2">
                      <para>
			<emphasis>BIND8 Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="3">
                      <para>
			<emphasis>Description</emphasis>
                      </para>
		    </entry>
		  </row>

		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Requestv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv4 requests received.
			Note: this also counts non query requests.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Requestv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv6 requests received.
			Note: this also counts non query requests.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqEdns0</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requests with EDNS(0) received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqBadEDNSVer</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requests with unsupported EDNS version received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqTSIG</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requests with TSIG received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqSIG0</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requests with SIG(0) received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqBadSIG</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requests with invalid (TSIG or SIG(0)) signature.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ReqTCP</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RTCP</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			TCP requests received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>AuthQryRej</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RUQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Authoritative (non recursive) queries rejected.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RecQryRej</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RURQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Recursive queries rejected.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>XfrRej</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RUXFR</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Zone transfer requests rejected.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateRej</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RUUpd</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Dynamic update requests rejected.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Response</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SAns</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Responses sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RespTruncated</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Truncated responses sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RespEDNS0</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Responses with EDNS(0) sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RespTSIG</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Responses with TSIG sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RespSIG0</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Responses with SIG(0) sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QrySuccess</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in a successful answer.
			This means the query which returns a NOERROR response
			with at least one answer RR.
			This corresponds to the
			<command>success</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryAuthAns</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in authoritative answer.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryNoauthAns</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SNaAns</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in non authoritative answer.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryReferral</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in referral answer.
			This corresponds to the
			<command>referral</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryNxrrset</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in NOERROR responses with no data.
			This corresponds to the
			<command>nxrrset</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QrySERVFAIL</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SFail</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in SERVFAIL.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryFORMERR</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SFErr</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in FORMERR.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryNXDOMAIN</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SNXD</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries resulted in NXDOMAIN.
			This corresponds to the
			<command>nxdomain</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryRecursion</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RFwdQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries which caused the server
			to perform recursion in order to find the final answer.
			This corresponds to the
			<command>recursion</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryDuplicate</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RDupQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries which the server attempted to
			recurse but discovered an existing query with the same
			IP address, port, query ID, name, type and class
			already being processed.
			This corresponds to the
			<command>duplicate</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryDropped</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Recursive queries for which the server
			discovered an excessive number of existing
			recursive queries for the same name, type and
			class and were subsequently dropped.
			This is the number of dropped queries due to
			the reason explained with the
			<command>clients-per-query</command>
			and
			<command>max-clients-per-query</command>
			options
			(see the description about
			<xref linkend="clients-per-query"/>.)
			This corresponds to the
			<command>dropped</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryFailure</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Other query failures.
			This corresponds to the
			<command>failure</command> counter
			of previous versions of
			<acronym>BIND</acronym> 9.
			Note: this counter is provided mainly for
			backward compatibility with the previous versions.
			Normally a more fine-grained counters such as
			<command>AuthQryRej</command> and
			<command>RecQryRej</command>
			that would also fall into this counter are provided,
			and so this counter would not be of much
			interest in practice.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>XfrReqDone</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Requested zone transfers completed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateReqFwd</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Update requests forwarded.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateRespFwd</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Update responses forwarded.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateFwdFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Dynamic update forward failed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateDone</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Dynamic updates completed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Dynamic updates failed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>UpdateBadPrereq</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Dynamic updates rejected due to prerequisite failure.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>RPZRewrites</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Response policy zone rewrites.
		      </para>
		    </entry>
		  </row>
		</tbody>
              </tgroup>
            </informaltable>
          </sect3>

	  <sect3>
            <title>Zone Maintenance Statistics Counters</title>

            <informaltable colsep="0" rowsep="0">
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
		<colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
		<colspec colname="2" colnum="2" colsep="0" colwidth="3.350in"/>
		<tbody>
		  <row>
		    <entry colname="1">
                      <para>
			<emphasis>Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="2">
                      <para>
			<emphasis>Description</emphasis>
                      </para>
		    </entry>
		  </row>

		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NotifyOutv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv4 notifies sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NotifyOutv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv6 notifies sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NotifyInv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv4 notifies received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NotifyInv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv6 notifies received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NotifyRej</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Incoming notifies rejected.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>SOAOutv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv4 SOA queries sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>SOAOutv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv6 SOA queries sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>AXFRReqv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv4 AXFR requested.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>AXFRReqv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv6 AXFR requested.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>IXFRReqv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv4 IXFR requested.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>IXFRReqv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			IPv6 IXFR requested.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>XfrSuccess</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Zone transfer requests succeeded.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>XfrFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Zone transfer requests failed.
		      </para>
		    </entry>
		  </row>
		</tbody>
              </tgroup>
            </informaltable>
	  </sect3>

	  <sect3>
            <title>Resolver Statistics Counters</title>

            <informaltable colsep="0" rowsep="0">
              <tgroup cols="3" colsep="0" rowsep="0" tgroupstyle="4Level-table">
		<colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
		<colspec colname="2" colnum="2" colsep="0" colwidth="1.150in"/>
		<colspec colname="3" colnum="3" colsep="0" colwidth="3.350in"/>
		<tbody>
		  <row>
		    <entry colname="1">
                      <para>
			<emphasis>Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="2">
                      <para>
			<emphasis>BIND8 Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="3">
                      <para>
			<emphasis>Description</emphasis>
                      </para>
		    </entry>
		  </row>

		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Queryv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SFwdQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv4 queries sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Queryv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SFwdQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv6 queries sent.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Responsev4</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RR</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv4 responses received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Responsev6</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RR</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv6 responses received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>NXDOMAIN</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RNXD</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			NXDOMAIN received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>SERVFAIL</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RFail</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			SERVFAIL received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>FORMERR</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RFErr</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			FORMERR received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>OtherError</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RErr</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Other errors received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>EDNS0Fail</command></para>
						 </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			EDNS(0) query failures.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Mismatch</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RDupR</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Mismatch responses received.
			The DNS ID, response's source address,
			and/or the response's source port does not
			match what was expected.
			(The port must be 53 or as defined by
			the <command>port</command> option.)
			This may be an indication of a cache
			poisoning attempt.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Truncated</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Truncated responses received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Lame</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>RLame</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Lame delegations received.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>Retry</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SDupQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Query retries performed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QueryAbort</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Queries aborted due to quota control.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QuerySockFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Failures in opening query sockets.
			One common reason for such failures is a
			failure of opening a new socket due to a
			limitation on file descriptors.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QueryTimeout</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Query timeouts.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>GlueFetchv4</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SSysQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv4 NS address fetches invoked.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>GlueFetchv6</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command>SSysQ</command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv6 NS address fetches invoked.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>GlueFetchv4Fail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv4 NS address fetch failed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>GlueFetchv6Fail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			IPv6 NS address fetch failed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ValAttempt</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			DNSSEC validation attempted.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ValOk</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			DNSSEC validation succeeded.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ValNegOk</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			DNSSEC validation on negative information succeeded.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>ValFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			DNSSEC validation failed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>QryRTTnn</command></para>
		    </entry>
		    <entry colname="2">
		      <para><command></command></para>
		    </entry>
		    <entry colname="3">
		      <para>
			Frequency table on round trip times (RTTs) of
			queries.
			Each <command>nn</command> specifies the corresponding
			frequency.
			In the sequence of
			<command>nn_1</command>,
			<command>nn_2</command>,
			...,
			<command>nn_m</command>,
			the value of <command>nn_i</command> is the
			number of queries whose RTTs are between
			<command>nn_(i-1)</command> (inclusive) and
			<command>nn_i</command> (exclusive) milliseconds.
			For the sake of convenience we define
			<command>nn_0</command> to be 0.
			The last entry should be represented as
			<command>nn_m+</command>, which means the
			number of queries whose RTTs are equal to or over
			<command>nn_m</command> milliseconds.
		      </para>
		    </entry>
		  </row>
		</tbody>
              </tgroup>
            </informaltable>

	  </sect3>

	  <sect3>
            <title>Socket I/O Statistics Counters</title>

	    <para>
	      Socket I/O statistics counters are defined per socket
	      types, which are
	      <command>UDP4</command> (UDP/IPv4),
	      <command>UDP6</command> (UDP/IPv6),
	      <command>TCP4</command> (TCP/IPv4),
	      <command>TCP6</command> (TCP/IPv6),
	      <command>Unix</command> (Unix Domain), and
	      <command>FDwatch</command> (sockets opened outside the
	      socket module).
	      In the following table <command>&lt;TYPE&gt;</command>
	      represents a socket type.
	      Not all counters are available for all socket types;
	      exceptions are noted in the description field.
	    </para>

	    <informaltable colsep="0" rowsep="0">
              <tgroup cols="2" colsep="0" rowsep="0" tgroupstyle="4Level-table">
		<colspec colname="1" colnum="1" colsep="0" colwidth="1.150in"/>
		<colspec colname="2" colnum="2" colsep="0" colwidth="3.350in"/>
		<tbody>
		  <row>
		    <entry colname="1">
                      <para>
			<emphasis>Symbol</emphasis>
                      </para>
		    </entry>
		    <entry colname="2">
                      <para>
			<emphasis>Description</emphasis>
                      </para>
		    </entry>
		  </row>

		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;Open</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Sockets opened successfully.
			This counter is not applicable to the
			<command>FDwatch</command> type.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;OpenFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Failures of opening sockets.
			This counter is not applicable to the
			<command>FDwatch</command> type.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;Close</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Sockets closed.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;BindFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Failures of binding sockets.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;ConnFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Failures of connecting sockets.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;Conn</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Connections established successfully.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;AcceptFail</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Failures of accepting incoming connection requests.
			This counter is not applicable to the
			<command>UDP</command> and
			<command>FDwatch</command> types.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;Accept</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Incoming connections successfully accepted.
			This counter is not applicable to the
			<command>UDP</command> and
			<command>FDwatch</command> types.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;SendErr</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Errors in socket send operations.
			This counter corresponds
			to <command>SErr</command> counter of
			<command>BIND</command> 8.
		      </para>
		    </entry>
		  </row>
		  <row rowsep="0">
		    <entry colname="1">
		      <para><command>&lt;TYPE&gt;RecvErr</command></para>
		    </entry>
		    <entry colname="2">
		      <para>
			Errors in socket receive operations.
			This includes errors of send operations on a
			connected UDP socket notified by an ICMP error
			message.
		      </para>
		    </entry>
		  </row>
		</tbody>
              </tgroup>
	    </informaltable>
	  </sect3>
	  <sect3>
            <title>Compatibility with <emphasis>BIND</emphasis> 8 Counters</title>
	    <para>
	      Most statistics counters that were available
	      in <command>BIND</command> 8 are also supported in
	      <command>BIND</command> 9 as shown in the above tables.
	      Here are notes about other counters that do not appear
	      in these tables.
	    </para>

            <variablelist>
              <varlistentry>
		<term><command>RFwdR,SFwdR</command></term>
		<listitem>
		  <para>
		    These counters are not supported
		    because <command>BIND</command> 9 does not adopt
		    the notion of <emphasis>forwarding</emphasis>
		    as <command>BIND</command> 8 did.
		  </para>
		</listitem>
	      </varlistentry>

              <varlistentry>
		<term><command>RAXFR</command></term>
		<listitem>
		  <para>
		    This counter is accessible in the Incoming Queries section.
		  </para>
		</listitem>
	      </varlistentry>

              <varlistentry>
		<term><command>RIQ</command></term>
		<listitem>
		  <para>
		    This counter is accessible in the Incoming Requests section.
		  </para>
		</listitem>
	      </varlistentry>

              <varlistentry>
		<term><command>ROpts</command></term>
		<listitem>
		  <para>
		    This counter is not supported
		    because <command>BIND</command> 9 does not care
		    about IP options in the first place.
		  </para>
		</listitem>
	      </varlistentry>
	    </variablelist>
	  </sect3>
        </sect2>
      </sect1>

    </chapter>
    <chapter id="Bv9ARM.ch07">
      <title><acronym>BIND</acronym> 9 Security Considerations</title>
      <sect1 id="Access_Control_Lists">
        <title>Access Control Lists</title>
        <para>
          Access Control Lists (ACLs) are address match lists that
          you can set up and nickname for future use in <command>allow-notify</command>,
          <command>allow-query</command>, <command>allow-query-on</command>,
	  <command>allow-recursion</command>, <command>allow-recursion-on</command>,
          <command>blackhole</command>, <command>allow-transfer</command>,
          etc.
        </para>
        <para>
          Using ACLs allows you to have finer control over who can access
          your name server, without cluttering up your config files with huge
          lists of IP addresses.
        </para>
        <para>
          It is a <emphasis>good idea</emphasis> to use ACLs, and to
          control access to your server. Limiting access to your server by
          outside parties can help prevent spoofing and denial of service (DoS) attacks against
          your server.
        </para>
        <para>
          Here is an example of how to properly apply ACLs:
        </para>

<programlisting>
// Set up an ACL named "bogusnets" that will block
// RFC1918 space and some reserved space, which is
// commonly used in spoofing attacks.
acl bogusnets {
        0.0.0.0/8;  192.0.2.0/24; 224.0.0.0/3;
        10.0.0.0/8; 172.16.0.0/12; 192.168.0.0/16;
};

// Set up an ACL called our-nets. Replace this with the
// real IP numbers.
acl our-nets { x.x.x.x/24; x.x.x.x/21; };
options {
  ...
  ...
  allow-query { our-nets; };
  allow-recursion { our-nets; };
  ...
  blackhole { bogusnets; };
  ...
};

zone "example.com" {
  type master;
  file "m/example.com";
  allow-query { any; };
};
</programlisting>

        <para>
          This allows recursive queries of the server from the outside
          unless recursion has been previously disabled.
        </para>
      </sect1>
      <sect1>
        <title><command>Chroot</command> and <command>Setuid</command></title>
        <para>
	  On UNIX servers, it is possible to run <acronym>BIND</acronym>
	  in a <emphasis>chrooted</emphasis> environment (using
	  the <command>chroot()</command> function) by specifying
	  the "<option>-t</option>" option for <command>named</command>.
	  This can help improve system security by placing
	  <acronym>BIND</acronym> in a "sandbox", which will limit
	  the damage done if a server is compromised.
        </para>
        <para>
          Another useful feature in the UNIX version of <acronym>BIND</acronym> is the
          ability to run the daemon as an unprivileged user ( <option>-u</option> <replaceable>user</replaceable> ).
          We suggest running as an unprivileged user when using the <command>chroot</command> feature.
        </para>
        <para>
          Here is an example command line to load <acronym>BIND</acronym> in a <command>chroot</command> sandbox,
          <command>/var/named</command>, and to run <command>named</command> <command>setuid</command> to
          user 202:
        </para>
        <para>
          <userinput>/usr/local/sbin/named -u 202 -t /var/named</userinput>
        </para>

        <sect2>
          <title>The <command>chroot</command> Environment</title>

          <para>
            In order for a <command>chroot</command> environment
            to
            work properly in a particular directory
            (for example, <filename>/var/named</filename>),
            you will need to set up an environment that includes everything
            <acronym>BIND</acronym> needs to run.
            From <acronym>BIND</acronym>'s point of view, <filename>/var/named</filename> is
            the root of the filesystem.  You will need to adjust the values of
            options like
            like <command>directory</command> and <command>pid-file</command> to account
            for this.
          </para>
          <para>
            Unlike with earlier versions of BIND, you typically will
            <emphasis>not</emphasis> need to compile <command>named</command>
            statically nor install shared libraries under the new root.
            However, depending on your operating system, you may need
            to set up things like
            <filename>/dev/zero</filename>,
            <filename>/dev/random</filename>,
            <filename>/dev/log</filename>, and
            <filename>/etc/localtime</filename>.
          </para>
        </sect2>

        <sect2>
          <title>Using the <command>setuid</command> Function</title>

          <para>
            Prior to running the <command>named</command> daemon,
            use
            the <command>touch</command> utility (to change file
            access and
            modification times) or the <command>chown</command>
            utility (to
            set the user id and/or group id) on files
            to which you want <acronym>BIND</acronym>
            to write.
          </para>
	  <note>
	    Note that if the <command>named</command> daemon is running as an
            unprivileged user, it will not be able to bind to new restricted
            ports if the server is reloaded.
	  </note>
        </sect2>
      </sect1>

      <sect1 id="dynamic_update_security">
        <title>Dynamic Update Security</title>

        <para>
          Access to the dynamic
          update facility should be strictly limited.  In earlier versions of
          <acronym>BIND</acronym>, the only way to do this was
          based on the IP
          address of the host requesting the update, by listing an IP address
          or
          network prefix in the <command>allow-update</command>
          zone option.
          This method is insecure since the source address of the update UDP
          packet
          is easily forged.  Also note that if the IP addresses allowed by the
          <command>allow-update</command> option include the
          address of a slave
          server which performs forwarding of dynamic updates, the master can
          be
          trivially attacked by sending the update to the slave, which will
          forward it to the master with its own source IP address causing the
          master to approve it without question.
        </para>

        <para>
          For these reasons, we strongly recommend that updates be
          cryptographically authenticated by means of transaction signatures
          (TSIG).  That is, the <command>allow-update</command>
          option should
          list only TSIG key names, not IP addresses or network
          prefixes. Alternatively, the new <command>update-policy</command>
          option can be used.
        </para>

        <para>
          Some sites choose to keep all dynamically-updated DNS data
          in a subdomain and delegate that subdomain to a separate zone. This
          way, the top-level zone containing critical data such as the IP
          addresses
          of public web and mail servers need not allow dynamic update at
          all.
        </para>

      </sect1>
    </chapter>

    <chapter id="Bv9ARM.ch08">
      <title>Troubleshooting</title>
      <sect1>
        <title>Common Problems</title>
        <sect2>
          <title>It's not working; how can I figure out what's wrong?</title>

          <para>
            The best solution to solving installation and
            configuration issues is to take preventative measures by setting
            up logging files beforehand. The log files provide a
            source of hints and information that can be used to figure out
            what went wrong and how to fix the problem.
          </para>

        </sect2>
      </sect1>
      <sect1>
        <title>Incrementing and Changing the Serial Number</title>

	<para>
	  Zone serial numbers are just numbers &mdash; they aren't
	  date related.  A lot of people set them to a number that
	  represents a date, usually of the form YYYYMMDDRR.
	  Occasionally they will make a mistake and set them to a
	  "date in the future" then try to correct them by setting
	  them to the "current date".  This causes problems because
	  serial numbers are used to indicate that a zone has been
	  updated.  If the serial number on the slave server is
	  lower than the serial number on the master, the slave
	  server will attempt to update its copy of the zone.
	</para>

        <para>
          Setting the serial number to a lower number on the master
          server than the slave server means that the slave will not perform
          updates to its copy of the zone.
        </para>

        <para>
          The solution to this is to add 2147483647 (2^31-1) to the
          number, reload the zone and make sure all slaves have updated to
          the new zone serial number, then reset the number to what you want
          it to be, and reload the zone again.
        </para>

      </sect1>
      <sect1>
        <title>Where Can I Get Help?</title>

        <para>
          The Internet Systems Consortium
          (<acronym>ISC</acronym>) offers a wide range
          of support and service agreements for <acronym>BIND</acronym> and <acronym>DHCP</acronym> servers. Four
          levels of premium support are available and each level includes
          support for all <acronym>ISC</acronym> programs,
          significant discounts on products
          and training, and a recognized priority on bug fixes and
          non-funded feature requests. In addition, <acronym>ISC</acronym> offers a standard
          support agreement package which includes services ranging from bug
          fix announcements to remote support. It also includes training in
          <acronym>BIND</acronym> and <acronym>DHCP</acronym>.
        </para>

        <para>
          To discuss arrangements for support, contact
          <ulink url="mailto:info@isc.org">info@isc.org</ulink> or visit the
          <acronym>ISC</acronym> web page at
	  <ulink url="http://www.isc.org/services/support/"
	             >http://www.isc.org/services/support/</ulink>
          to read more.
        </para>
      </sect1>
    </chapter>
    <appendix id="Bv9ARM.ch09">
      <title>Appendices</title>
      <sect1>
        <title>Acknowledgments</title>
        <sect2 id="historical_dns_information">
          <title>A Brief History of the <acronym>DNS</acronym> and <acronym>BIND</acronym></title>

          <para>
            Although the "official" beginning of the Domain Name
            System occurred in 1984 with the publication of RFC 920, the
            core of the new system was described in 1983 in RFCs 882 and
            883. From 1984 to 1987, the ARPAnet (the precursor to today's
            Internet) became a testbed of experimentation for developing the
            new naming/addressing scheme in a rapidly expanding,
            operational network environment.  New RFCs were written and
            published in 1987 that modified the original documents to
            incorporate improvements based on the working model. RFC 1034,
            "Domain Names-Concepts and Facilities", and RFC 1035, "Domain
            Names-Implementation and Specification" were published and
            became the standards upon which all <acronym>DNS</acronym> implementations are
            built.
          </para>

          <para>
            The first working domain name server, called "Jeeves", was
            written in 1983-84 by Paul Mockapetris for operation on DEC
            Tops-20
            machines located at the University of Southern California's
            Information
            Sciences Institute (USC-ISI) and SRI International's Network
            Information
            Center (SRI-NIC). A <acronym>DNS</acronym> server for
            Unix machines, the Berkeley Internet
            Name Domain (<acronym>BIND</acronym>) package, was
            written soon after by a group of
            graduate students at the University of California at Berkeley
            under
            a grant from the US Defense Advanced Research Projects
            Administration
            (DARPA).
          </para>
          <para>
	    Versions of <acronym>BIND</acronym> through
            4.8.3 were maintained by the Computer
            Systems Research Group (CSRG) at UC Berkeley. Douglas Terry, Mark
            Painter, David Riggle and Songnian Zhou made up the initial <acronym>BIND</acronym>
            project team. After that, additional work on the software package
            was done by Ralph Campbell. Kevin Dunlap, a Digital Equipment
            Corporation
            employee on loan to the CSRG, worked on <acronym>BIND</acronym> for 2 years, from 1985
            to 1987. Many other people also contributed to <acronym>BIND</acronym> development
            during that time: Doug Kingston, Craig Partridge, Smoot
            Carl-Mitchell,
            Mike Muuss, Jim Bloom and Mike Schwartz. <acronym>BIND</acronym> maintenance was subsequently
            handled by Mike Karels and &#216;ivind Kure.
          </para>
          <para>
            <acronym>BIND</acronym> versions 4.9 and 4.9.1 were
            released by Digital Equipment
            Corporation (now Compaq Computer Corporation). Paul Vixie, then
            a DEC employee, became <acronym>BIND</acronym>'s
            primary caretaker. He was assisted
            by Phil Almquist, Robert Elz, Alan Barrett, Paul Albitz, Bryan
            Beecher, Andrew
            Partan, Andy Cherenson, Tom Limoncelli, Berthold Paffrath, Fuat
            Baran, Anant Kumar, Art Harkin, Win Treese, Don Lewis, Christophe
            Wolfhugel, and others.
          </para>
          <para>
            In 1994, <acronym>BIND</acronym> version 4.9.2 was sponsored by
            Vixie Enterprises. Paul
            Vixie became <acronym>BIND</acronym>'s principal
            architect/programmer.
          </para>
          <para>
            <acronym>BIND</acronym> versions from 4.9.3 onward
            have been developed and maintained
            by the Internet Systems Consortium and its predecessor,
            the Internet Software Consortium,  with support being provided
            by ISC's sponsors.
          </para>
	  <para>
	    As co-architects/programmers, Bob Halley and
            Paul Vixie released the first production-ready version of
	    <acronym>BIND</acronym> version 8 in May 1997.
          </para>
	  <para>
	    BIND version 9 was released in September 2000 and is a
	    major rewrite of nearly all aspects of the underlying
	    BIND architecture.
          </para>
          <para>
	    BIND versions 4 and 8 are officially deprecated.
	    No additional development is done
	    on BIND version 4 or BIND version 8.
          </para>
          <para>
            <acronym>BIND</acronym> development work is made
            possible today by the sponsorship
            of several corporations, and by the tireless work efforts of
            numerous individuals.
          </para>
        </sect2>
      </sect1>
      <sect1>
        <title>General <acronym>DNS</acronym> Reference Information</title>
        <sect2 id="ipv6addresses">
          <title>IPv6 addresses (AAAA)</title>
          <para>
            IPv6 addresses are 128-bit identifiers for interfaces and
            sets of interfaces which were introduced in the <acronym>DNS</acronym> to facilitate
            scalable Internet routing. There are three types of addresses: <emphasis>Unicast</emphasis>,
            an identifier for a single interface;
            <emphasis>Anycast</emphasis>,
            an identifier for a set of interfaces; and <emphasis>Multicast</emphasis>,
            an identifier for a set of interfaces. Here we describe the global
            Unicast address scheme. For more information, see RFC 3587,
	    "Global Unicast Address Format."
          </para>
          <para>
	    IPv6 unicast addresses consist of a
	    <emphasis>global routing prefix</emphasis>, a
	    <emphasis>subnet identifier</emphasis>, and an
	    <emphasis>interface identifier</emphasis>.
          </para>
          <para>
            The global routing prefix is provided by the
            upstream provider or ISP, and (roughly) corresponds to the
	    IPv4 <emphasis>network</emphasis> section
            of the address range.

	    The subnet identifier is for local subnetting, much the
            same as subnetting an
            IPv4 /16 network into /24 subnets.

	    The interface identifier is the address of an individual
            interface on a given network; in IPv6, addresses belong to
            interfaces rather than to machines.
          </para>
          <para>
            The subnetting capability of IPv6 is much more flexible than
            that of IPv4: subnetting can be carried out on bit boundaries,
            in much the same way as Classless InterDomain Routing
            (CIDR), and the DNS PTR representation ("nibble" format)
            makes setting up reverse zones easier.
          </para>
          <para>
            The Interface Identifier must be unique on the local link,
            and is usually generated automatically by the IPv6
            implementation, although it is usually possible to
            override the default setting if necessary.  A typical IPv6
            address might look like:
	    <command>2001:db8:201:9:a00:20ff:fe81:2b32</command>
	  </para>
          <para>
            IPv6 address specifications often contain long strings
            of zeros, so the architects have included a shorthand for
            specifying
            them. The double colon (`::') indicates the longest possible
            string
            of zeros that can fit, and can be used only once in an address.
          </para>
        </sect2>
      </sect1>
      <sect1 id="bibliography">
        <title>Bibliography (and Suggested Reading)</title>
        <sect2 id="rfcs">
          <title>Request for Comments (RFCs)</title>
          <para>
            Specification documents for the Internet protocol suite, including
            the <acronym>DNS</acronym>, are published as part of
            the Request for Comments (RFCs)
            series of technical notes. The standards themselves are defined
            by the Internet Engineering Task Force (IETF) and the Internet
            Engineering Steering Group (IESG). RFCs can be obtained online via FTP at:
	  </para>
	  <para>
            <ulink url="ftp://www.isi.edu/in-notes/">
	      ftp://www.isi.edu/in-notes/RFC<replaceable>xxxx</replaceable>.txt
	    </ulink>
	  </para>
	  <para>
	    (where <replaceable>xxxx</replaceable> is
            the number of the RFC). RFCs are also available via the Web at:
	  </para>
	  <para>
            <ulink url="http://www.ietf.org/rfc/"
	               >http://www.ietf.org/rfc/</ulink>.
          </para>
          <bibliography>
            <bibliodiv>
              <!-- one of (BIBLIOENTRY BIBLIOMIXED) -->
              <title>Standards</title>
              <biblioentry>
                <abbrev>RFC974</abbrev>
                <author>
                  <surname>Partridge</surname>
                  <firstname>C.</firstname>
                </author>
                <title>Mail Routing and the Domain System</title>
                <pubdate>January 1986</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1034</abbrev>
                <author>
                  <surname>Mockapetris</surname>
                  <firstname>P.V.</firstname>
                </author>
                <title>Domain Names &mdash; Concepts and Facilities</title>
                <pubdate>November 1987</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1035</abbrev>
                <author>
                  <surname>Mockapetris</surname>
                  <firstname>P. V.</firstname>
                  </author> <title>Domain Names &mdash; Implementation and
                  Specification</title>
                <pubdate>November 1987</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv id="proposed_standards" xreflabel="Proposed Standards">

              <title>Proposed Standards</title>
              <!-- one of (BIBLIOENTRY BIBLIOMIXED) -->
              <biblioentry>
                <abbrev>RFC2181</abbrev>
                <author>
                  <surname>Elz</surname>
                  <firstname>R., R. Bush</firstname>
                </author>
                <title>Clarifications to the <acronym>DNS</acronym>
                  Specification</title>
                <pubdate>July 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2308</abbrev>
                <author>
                  <surname>Andrews</surname>
                  <firstname>M.</firstname>
                </author>
                <title>Negative Caching of <acronym>DNS</acronym>
                  Queries</title>
                <pubdate>March 1998</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1995</abbrev>
                <author>
                  <surname>Ohta</surname>
                  <firstname>M.</firstname>
                </author>
                <title>Incremental Zone Transfer in <acronym>DNS</acronym></title>
                <pubdate>August 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1996</abbrev>
                <author>
                  <surname>Vixie</surname>
                  <firstname>P.</firstname>
                </author>
                <title>A Mechanism for Prompt Notification of Zone Changes</title>
                <pubdate>August 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2136</abbrev>
                <authorgroup>
                  <author>
                    <surname>Vixie</surname>
                    <firstname>P.</firstname>
                  </author>
                  <author>
                    <firstname>S.</firstname>
                    <surname>Thomson</surname>
                  </author>
                  <author>
                    <firstname>Y.</firstname>
                    <surname>Rekhter</surname>
                  </author>
                  <author>
                    <firstname>J.</firstname>
                    <surname>Bound</surname>
                  </author>
                </authorgroup>
                <title>Dynamic Updates in the Domain Name System</title>
                <pubdate>April 1997</pubdate>
              </biblioentry>
	      <biblioentry>
                <abbrev>RFC2671</abbrev>
                <authorgroup>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Vixie</surname>
                  </author>
                </authorgroup>
                <title>Extension Mechanisms for DNS (EDNS0)</title>
                <pubdate>August 1997</pubdate>
	      </biblioentry>
	      <biblioentry>
                <abbrev>RFC2672</abbrev>
                <authorgroup>
                  <author>
                    <firstname>M.</firstname>
                    <surname>Crawford</surname>
                  </author>
                </authorgroup>
                <title>Non-Terminal DNS Name Redirection</title>
                <pubdate>August 1999</pubdate>
	      </biblioentry>
              <biblioentry>
                <abbrev>RFC2845</abbrev>
                <authorgroup>
                  <author>
                    <surname>Vixie</surname>
                    <firstname>P.</firstname>
                  </author>
                  <author>
                    <firstname>O.</firstname>
                    <surname>Gudmundsson</surname>
                  </author>
                  <author>
                    <firstname>D.</firstname>
                    <surname>Eastlake</surname>
                    <lineage>3rd</lineage>
                  </author>
                  <author>
                    <firstname>B.</firstname>
                    <surname>Wellington</surname>
                  </author>
                </authorgroup>
                <title>Secret Key Transaction Authentication for <acronym>DNS</acronym> (TSIG)</title>
                <pubdate>May 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2930</abbrev>
                <authorgroup>
                  <author>
                    <firstname>D.</firstname>
                    <surname>Eastlake</surname>
                    <lineage>3rd</lineage>
                  </author>
                </authorgroup>
                <title>Secret Key Establishment for DNS (TKEY RR)</title>
                <pubdate>September 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2931</abbrev>
                <authorgroup>
                  <author>
                    <firstname>D.</firstname>
                    <surname>Eastlake</surname>
                    <lineage>3rd</lineage>
                  </author>
                </authorgroup>
                <title>DNS Request and Transaction Signatures (SIG(0)s)</title>
                <pubdate>September 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3007</abbrev>
                <authorgroup>
                  <author>
                    <firstname>B.</firstname>
                    <surname>Wellington</surname>
                  </author>
                </authorgroup>
                <title>Secure Domain Name System (DNS) Dynamic Update</title>
                <pubdate>November 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3645</abbrev>
                <authorgroup>
                  <author>
                    <firstname>S.</firstname>
                    <surname>Kwan</surname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Garg</surname>
                  </author>
                  <author>
                    <firstname>J.</firstname>
                    <surname>Gilroy</surname>
                  </author>
                  <author>
                    <firstname>L.</firstname>
                    <surname>Esibov</surname>
                  </author>
                  <author>
                    <firstname>J.</firstname>
                    <surname>Westhead</surname>
                  </author>
                  <author>
                    <firstname>R.</firstname>
                    <surname>Hall</surname>
                  </author>
                </authorgroup>
                <title>Generic Security Service Algorithm for Secret
		       Key Transaction Authentication for DNS
		       (GSS-TSIG)</title>
                <pubdate>October 2003</pubdate>
              </biblioentry>
            </bibliodiv>
	    <bibliodiv>
	      <title><acronym>DNS</acronym> Security Proposed Standards</title>
	      <biblioentry>
		<abbrev>RFC3225</abbrev>
	 	<authorgroup>
		  <author>
		    <firstname>D.</firstname>
		    <surname>Conrad</surname>
		  </author>
	 	</authorgroup>
		<title>Indicating Resolver Support of DNSSEC</title>
		<pubdate>December 2001</pubdate>
	      </biblioentry>
	      <biblioentry>
	        <abbrev>RFC3833</abbrev>
	 	<authorgroup>
		  <author>
		    <firstname>D.</firstname>
		    <surname>Atkins</surname>
		  </author>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Austein</surname>
		  </author>
		</authorgroup>
		<title>Threat Analysis of the Domain Name System (DNS)</title>
		<pubdate>August 2004</pubdate>
	      </biblioentry>
	      <biblioentry>
	        <abbrev>RFC4033</abbrev>
	 	<authorgroup>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Arends</surname>
		  </author>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Austein</surname>
		  </author>
		  <author>
		    <firstname>M.</firstname>
		    <surname>Larson</surname>
		  </author>
		  <author>
		    <firstname>D.</firstname>
		    <surname>Massey</surname>
		  </author>
		  <author>
		    <firstname>S.</firstname>
		    <surname>Rose</surname>
		  </author>
		</authorgroup>
		<title>DNS Security Introduction and Requirements</title>
		<pubdate>March 2005</pubdate>
	      </biblioentry>
	      <biblioentry>
	        <abbrev>RFC4034</abbrev>
	 	<authorgroup>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Arends</surname>
		  </author>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Austein</surname>
		  </author>
		  <author>
		    <firstname>M.</firstname>
		    <surname>Larson</surname>
		  </author>
		  <author>
		    <firstname>D.</firstname>
		    <surname>Massey</surname>
		  </author>
		  <author>
		    <firstname>S.</firstname>
		    <surname>Rose</surname>
		  </author>
		</authorgroup>
		<title>Resource Records for the DNS Security Extensions</title>
		<pubdate>March 2005</pubdate>
	      </biblioentry>
	      <biblioentry>
	        <abbrev>RFC4035</abbrev>
	 	<authorgroup>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Arends</surname>
		  </author>
		  <author>
		    <firstname>R.</firstname>
		    <surname>Austein</surname>
		  </author>
		  <author>
		    <firstname>M.</firstname>
		    <surname>Larson</surname>
		  </author>
		  <author>
		    <firstname>D.</firstname>
		    <surname>Massey</surname>
		  </author>
		  <author>
		    <firstname>S.</firstname>
		    <surname>Rose</surname>
		  </author>
		</authorgroup>
		<title>Protocol Modifications for the DNS
		       Security Extensions</title>
		<pubdate>March 2005</pubdate>
	      </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title>Other Important RFCs About <acronym>DNS</acronym>
                Implementation</title>
              <biblioentry>
                <abbrev>RFC1535</abbrev>
                <author>
                  <surname>Gavron</surname>
                  <firstname>E.</firstname>
                </author>
                <title>A Security Problem and Proposed Correction With Widely
                  Deployed <acronym>DNS</acronym> Software.</title>
                <pubdate>October 1993</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1536</abbrev>
                <authorgroup>
                  <author>
                    <surname>Kumar</surname>
                    <firstname>A.</firstname>
                  </author>
                  <author>
                    <firstname>J.</firstname>
                    <surname>Postel</surname>
                  </author>
                  <author>
                    <firstname>C.</firstname>
                    <surname>Neuman</surname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Danzig</surname>
                  </author>
                  <author>
                    <firstname>S.</firstname>
                    <surname>Miller</surname>
                  </author>
                </authorgroup>
                <title>Common <acronym>DNS</acronym> Implementation
                  Errors and Suggested Fixes</title>
                <pubdate>October 1993</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1982</abbrev>
                <authorgroup>
                  <author>
                    <surname>Elz</surname>
                    <firstname>R.</firstname>
                  </author>
                  <author>
                    <firstname>R.</firstname>
                    <surname>Bush</surname>
                  </author>
                </authorgroup>
                <title>Serial Number Arithmetic</title>
                <pubdate>August 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC4074</abbrev>
                <authorgroup>
                  <author>
                    <surname>Morishita</surname>
                    <firstname>Y.</firstname>
                  </author>
                  <author>
                    <firstname>T.</firstname>
                    <surname>Jinmei</surname>
                  </author>
                </authorgroup>
                <title>Common Misbehaviour Against <acronym>DNS</acronym>
		Queries for IPv6 Addresses</title>
                <pubdate>May 2005</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title>Resource Record Types</title>
              <biblioentry>
                <abbrev>RFC1183</abbrev>
                <authorgroup>
                  <author>
                    <surname>Everhart</surname>
                    <firstname>C.F.</firstname>
                  </author>
                  <author>
                    <firstname>L. A.</firstname>
                    <surname>Mamakos</surname>
                  </author>
                  <author>
                    <firstname>R.</firstname>
                    <surname>Ullmann</surname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Mockapetris</surname>
                  </author>
                </authorgroup>
                <title>New <acronym>DNS</acronym> RR Definitions</title>
                <pubdate>October 1990</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1706</abbrev>
                <authorgroup>
                  <author>
                    <surname>Manning</surname>
                    <firstname>B.</firstname>
                  </author>
                  <author>
                    <firstname>R.</firstname>
                    <surname>Colella</surname>
                  </author>
                </authorgroup>
                <title><acronym>DNS</acronym> NSAP Resource Records</title>
                <pubdate>October 1994</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2168</abbrev>
                <authorgroup>
                  <author>
                    <surname>Daniel</surname>
                    <firstname>R.</firstname>
                  </author>
                  <author>
                    <firstname>M.</firstname>
                    <surname>Mealling</surname>
                  </author>
                </authorgroup>
                <title>Resolution of Uniform Resource Identifiers using
                  the Domain Name System</title>
                <pubdate>June 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1876</abbrev>
                <authorgroup>
                  <author>
                    <surname>Davis</surname>
                    <firstname>C.</firstname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Vixie</surname>
                  </author>
                  <author>
                    <firstname>T.</firstname>
                    <firstname>Goodwin</firstname>
                  </author>
                  <author>
                    <firstname>I.</firstname>
                    <surname>Dickinson</surname>
                  </author>
                </authorgroup>
                <title>A Means for Expressing Location Information in the
                  Domain
                  Name System</title>
                <pubdate>January 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2052</abbrev>
                <authorgroup>
                  <author>
                    <surname>Gulbrandsen</surname>
                    <firstname>A.</firstname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Vixie</surname>
                  </author>
                </authorgroup>
                <title>A <acronym>DNS</acronym> RR for Specifying the
                  Location of
                  Services.</title>
                <pubdate>October 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2163</abbrev>
                <author>
                  <surname>Allocchio</surname>
                  <firstname>A.</firstname>
                </author>
                <title>Using the Internet <acronym>DNS</acronym> to
                  Distribute MIXER
                  Conformant Global Address Mapping</title>
                <pubdate>January 1998</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2230</abbrev>
                <author>
                  <surname>Atkinson</surname>
                  <firstname>R.</firstname>
                </author>
                <title>Key Exchange Delegation Record for the <acronym>DNS</acronym></title>
                <pubdate>October 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2536</abbrev>
                <author>
                  <surname>Eastlake</surname>
                  <firstname>D.</firstname>
                  <lineage>3rd</lineage>
                </author>
                <title>DSA KEYs and SIGs in the Domain Name System (DNS)</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2537</abbrev>
                <author>
                  <surname>Eastlake</surname>
                  <firstname>D.</firstname>
                  <lineage>3rd</lineage>
                </author>
                <title>RSA/MD5 KEYs and SIGs in the Domain Name System (DNS)</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2538</abbrev>
		<authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <firstname>D.</firstname>
                    <lineage>3rd</lineage>
                  </author>
		  <author>
		    <surname>Gudmundsson</surname>
		    <firstname>O.</firstname>
		  </author>
		</authorgroup>
                <title>Storing Certificates in the Domain Name System (DNS)</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2539</abbrev>
		<authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <firstname>D.</firstname>
                    <lineage>3rd</lineage>
                  </author>
		</authorgroup>
                <title>Storage of Diffie-Hellman Keys in the Domain Name System (DNS)</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2540</abbrev>
		<authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <firstname>D.</firstname>
                    <lineage>3rd</lineage>
                  </author>
		</authorgroup>
                <title>Detached Domain Name System (DNS) Information</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2782</abbrev>
                <author>
                  <surname>Gulbrandsen</surname>
                  <firstname>A.</firstname>
                </author>
                <author>
                  <surname>Vixie</surname>
                  <firstname>P.</firstname>
                </author>
                <author>
                  <surname>Esibov</surname>
                  <firstname>L.</firstname>
                </author>
                <title>A DNS RR for specifying the location of services (DNS SRV)</title>
                <pubdate>February 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2915</abbrev>
                <author>
                  <surname>Mealling</surname>
                  <firstname>M.</firstname>
                </author>
                <author>
                  <surname>Daniel</surname>
                  <firstname>R.</firstname>
                </author>
                <title>The Naming Authority Pointer (NAPTR) DNS Resource Record</title>
                <pubdate>September 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3110</abbrev>
                <author>
                    <surname>Eastlake</surname>
                    <firstname>D.</firstname>
                    <lineage>3rd</lineage>
                </author>
                <title>RSA/SHA-1 SIGs and RSA KEYs in the Domain Name System (DNS)</title>
                <pubdate>May 2001</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3123</abbrev>
                <author>
                  <surname>Koch</surname>
                  <firstname>P.</firstname>
                </author>
                <title>A DNS RR Type for Lists of Address Prefixes (APL RR)</title>
                <pubdate>June 2001</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3596</abbrev>
                <authorgroup>
                  <author>
                    <surname>Thomson</surname>
                    <firstname>S.</firstname>
                  </author>
                  <author>
                    <firstname>C.</firstname>
                    <surname>Huitema</surname>
                  </author>
                  <author>
                    <firstname>V.</firstname>
                    <surname>Ksinant</surname>
                  </author>
                  <author>
                    <firstname>M.</firstname>
                    <surname>Souissi</surname>
                  </author>
                </authorgroup>
                <title><acronym>DNS</acronym> Extensions to support IP
                  version 6</title>
                <pubdate>October 2003</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3597</abbrev>
                <author>
                  <surname>Gustafsson</surname>
                  <firstname>A.</firstname>
                </author>
                <title>Handling of Unknown DNS Resource Record (RR) Types</title>
                <pubdate>September 2003</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title><acronym>DNS</acronym> and the Internet</title>
              <biblioentry>
                <abbrev>RFC1101</abbrev>
                <author>
                  <surname>Mockapetris</surname>
                  <firstname>P. V.</firstname>
                </author>
                <title><acronym>DNS</acronym> Encoding of Network Names
                  and Other Types</title>
                <pubdate>April 1989</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1123</abbrev>
                <author>
                  <surname>Braden</surname>
                  <surname>R.</surname>
                </author>
                <title>Requirements for Internet Hosts - Application and
                  Support</title>
                <pubdate>October 1989</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1591</abbrev>
                <author>
                  <surname>Postel</surname>
                  <firstname>J.</firstname>
                </author>
                <title>Domain Name System Structure and Delegation</title>
                <pubdate>March 1994</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2317</abbrev>
                <authorgroup>
                  <author>
                    <surname>Eidnes</surname>
                    <firstname>H.</firstname>
                  </author>
                  <author>
                    <firstname>G.</firstname>
                    <surname>de Groot</surname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Vixie</surname>
                  </author>
                </authorgroup>
                <title>Classless IN-ADDR.ARPA Delegation</title>
                <pubdate>March 1998</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2826</abbrev>
                <authorgroup>
                  <author>
                    <surname>Internet Architecture Board</surname>
                  </author>
                </authorgroup>
                <title>IAB Technical Comment on the Unique DNS Root</title>
                <pubdate>May 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2929</abbrev>
                <authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <firstname>D.</firstname>
                    <lineage>3rd</lineage>
                  </author>
                  <author>
                    <surname>Brunner-Williams</surname>
                    <firstname>E.</firstname>
                  </author>
                  <author>
                    <surname>Manning</surname>
                    <firstname>B.</firstname>
                  </author>
                </authorgroup>
                <title>Domain Name System (DNS) IANA Considerations</title>
                <pubdate>September 2000</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title><acronym>DNS</acronym> Operations</title>
              <biblioentry>
                <abbrev>RFC1033</abbrev>
                <author>
                  <surname>Lottor</surname>
                  <firstname>M.</firstname>
                </author>
                <title>Domain administrators operations guide.</title>
                <pubdate>November 1987</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1537</abbrev>
                <author>
                  <surname>Beertema</surname>
                  <firstname>P.</firstname>
                </author>
                <title>Common <acronym>DNS</acronym> Data File
                  Configuration Errors</title>
                <pubdate>October 1993</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1912</abbrev>
                <author>
                  <surname>Barr</surname>
                  <firstname>D.</firstname>
                </author>
                <title>Common <acronym>DNS</acronym> Operational and
                  Configuration Errors</title>
                <pubdate>February 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2010</abbrev>
                <authorgroup>
                  <author>
                    <surname>Manning</surname>
                    <firstname>B.</firstname>
                  </author>
                  <author>
                    <firstname>P.</firstname>
                    <surname>Vixie</surname>
                  </author>
                </authorgroup>
                <title>Operational Criteria for Root Name Servers.</title>
                <pubdate>October 1996</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2219</abbrev>
                <authorgroup>
                  <author>
                    <surname>Hamilton</surname>
                    <firstname>M.</firstname>
                  </author>
                  <author>
                    <firstname>R.</firstname>
                    <surname>Wright</surname>
                  </author>
                </authorgroup>
                <title>Use of <acronym>DNS</acronym> Aliases for
                  Network Services.</title>
                <pubdate>October 1997</pubdate>
              </biblioentry>
            </bibliodiv>
	    <bibliodiv>
              <title>Internationalized Domain Names</title>
              <biblioentry>
                <abbrev>RFC2825</abbrev>
		<authorgroup>
                  <author>
                    <surname>IAB</surname>
                  </author>
                  <author>
                    <surname>Daigle</surname>
                    <firstname>R.</firstname>
                  </author>
		</authorgroup>
                <title>A Tangled Web: Issues of I18N, Domain Names,
		       and the Other Internet protocols</title>
                <pubdate>May 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3490</abbrev>
		<authorgroup>
                  <author>
                    <surname>Faltstrom</surname>
                    <firstname>P.</firstname>
                  </author>
                  <author>
                    <surname>Hoffman</surname>
                    <firstname>P.</firstname>
                  </author>
                  <author>
                    <surname>Costello</surname>
                    <firstname>A.</firstname>
                  </author>
		</authorgroup>
                <title>Internationalizing Domain Names in Applications (IDNA)</title>
                <pubdate>March 2003</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3491</abbrev>
		<authorgroup>
                  <author>
                    <surname>Hoffman</surname>
                    <firstname>P.</firstname>
                  </author>
                  <author>
                    <surname>Blanchet</surname>
                    <firstname>M.</firstname>
                  </author>
		</authorgroup>
                <title>Nameprep: A Stringprep Profile for Internationalized Domain Names</title>
                <pubdate>March 2003</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3492</abbrev>
		<authorgroup>
                  <author>
                    <surname>Costello</surname>
                    <firstname>A.</firstname>
                  </author>
		</authorgroup>
                <title>Punycode: A Bootstring encoding of Unicode
		       for Internationalized Domain Names in
		       Applications (IDNA)</title>
                <pubdate>March 2003</pubdate>
              </biblioentry>
	    </bibliodiv>
            <bibliodiv>
              <title>Other <acronym>DNS</acronym>-related RFCs</title>
              <note>
                <para>
                  Note: the following list of RFCs, although
                  <acronym>DNS</acronym>-related, are not
                  concerned with implementing software.
                </para>
              </note>
              <biblioentry>
                <abbrev>RFC1464</abbrev>
                <author>
                  <surname>Rosenbaum</surname>
                  <firstname>R.</firstname>
                </author>
                <title>Using the Domain Name System To Store Arbitrary String
                  Attributes</title>
                <pubdate>May 1993</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1713</abbrev>
                <author>
                  <surname>Romao</surname>
                  <firstname>A.</firstname>
                </author>
                <title>Tools for <acronym>DNS</acronym> Debugging</title>
                <pubdate>November 1994</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC1794</abbrev>
                <author>
                  <surname>Brisco</surname>
                  <firstname>T.</firstname>
                </author>
                <title><acronym>DNS</acronym> Support for Load
                  Balancing</title>
                <pubdate>April 1995</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2240</abbrev>
                <author>
                  <surname>Vaughan</surname>
                  <firstname>O.</firstname>
                </author>
                <title>A Legal Basis for Domain Name Allocation</title>
                <pubdate>November 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2345</abbrev>
                <authorgroup>
                  <author>
                    <surname>Klensin</surname>
                    <firstname>J.</firstname>
                  </author>
                  <author>
                    <firstname>T.</firstname>
                    <surname>Wolf</surname>
                  </author>
                  <author>
                    <firstname>G.</firstname>
                    <surname>Oglesby</surname>
                  </author>
                </authorgroup>
                <title>Domain Names and Company Name Retrieval</title>
                <pubdate>May 1998</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2352</abbrev>
                <author>
                  <surname>Vaughan</surname>
                  <firstname>O.</firstname>
                </author>
                <title>A Convention For Using Legal Names as Domain Names</title>
                <pubdate>May 1998</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3071</abbrev>
                <authorgroup>
                  <author>
                    <surname>Klensin</surname>
                    <firstname>J.</firstname>
                  </author>
                </authorgroup>
                <title>Reflections on the DNS, RFC 1591, and Categories of Domains</title>
                <pubdate>February 2001</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3258</abbrev>
                <authorgroup>
                  <author>
                    <surname>Hardie</surname>
                    <firstname>T.</firstname>
                  </author>
                </authorgroup>
                <title>Distributing Authoritative Name Servers via
		       Shared Unicast Addresses</title>
                <pubdate>April 2002</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3901</abbrev>
                <authorgroup>
                  <author>
                    <surname>Durand</surname>
                    <firstname>A.</firstname>
                  </author>
                  <author>
                    <firstname>J.</firstname>
                    <surname>Ihren</surname>
                  </author>
                </authorgroup>
                <title>DNS IPv6 Transport Operational Guidelines</title>
                <pubdate>September 2004</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title>Obsolete and Unimplemented Experimental RFC</title>
              <biblioentry>
                <abbrev>RFC1712</abbrev>
                <authorgroup>
                  <author>
                    <surname>Farrell</surname>
                    <firstname>C.</firstname>
                  </author>
                  <author>
                    <firstname>M.</firstname>
                    <surname>Schulze</surname>
                  </author>
                  <author>
                    <firstname>S.</firstname>
                    <surname>Pleitner</surname>
                  </author>
                  <author>
                    <firstname>D.</firstname>
                    <surname>Baldoni</surname>
                  </author>
                </authorgroup>
                <title><acronym>DNS</acronym> Encoding of Geographical
                  Location</title>
                <pubdate>November 1994</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2673</abbrev>
                <authorgroup>
                  <author>
                    <surname>Crawford</surname>
                    <firstname>M.</firstname>
                  </author>
                </authorgroup>
                <title>Binary Labels in the Domain Name System</title>
                <pubdate>August 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2874</abbrev>
                <authorgroup>
                  <author>
                    <surname>Crawford</surname>
                    <firstname>M.</firstname>
                  </author>
                  <author>
                    <surname>Huitema</surname>
                    <firstname>C.</firstname>
                  </author>
                </authorgroup>
                <title>DNS Extensions to Support IPv6 Address Aggregation
		       and Renumbering</title>
                <pubdate>July 2000</pubdate>
              </biblioentry>
            </bibliodiv>
            <bibliodiv>
              <title>Obsoleted DNS Security RFCs</title>
	      <note>
		<para>
		  Most of these have been consolidated into RFC4033,
		  RFC4034 and RFC4035 which collectively describe DNSSECbis.
		</para>
	      </note>
              <biblioentry>
                <abbrev>RFC2065</abbrev>
                <authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <lineage>3rd</lineage>
                    <firstname>D.</firstname>
                  </author>
                  <author>
                    <firstname>C.</firstname>
                    <surname>Kaufman</surname>
                  </author>
                </authorgroup>
                <title>Domain Name System Security Extensions</title>
                <pubdate>January 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2137</abbrev>
                <author>
                  <surname>Eastlake</surname>
                  <lineage>3rd</lineage>
                  <firstname>D.</firstname>
                </author>
                <title>Secure Domain Name System Dynamic Update</title>
                <pubdate>April 1997</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC2535</abbrev>
                <authorgroup>
                  <author>
                    <surname>Eastlake</surname>
                    <lineage>3rd</lineage>
                    <firstname>D.</firstname>
                  </author>
                </authorgroup>
                <title>Domain Name System Security Extensions</title>
                <pubdate>March 1999</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3008</abbrev>
                <authorgroup>
                  <author>
                    <surname>Wellington</surname>
                    <firstname>B.</firstname>
                  </author>
                </authorgroup>
                <title>Domain Name System Security (DNSSEC)
		       Signing Authority</title>
                <pubdate>November 2000</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3090</abbrev>
                <authorgroup>
                  <author>
                    <surname>Lewis</surname>
                    <firstname>E.</firstname>
                  </author>
                </authorgroup>
                <title>DNS Security Extension Clarification on Zone Status</title>
                <pubdate>March 2001</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3445</abbrev>
                <authorgroup>
                  <author>
                    <surname>Massey</surname>
                    <firstname>D.</firstname>
                  </author>
                  <author>
                    <surname>Rose</surname>
                    <firstname>S.</firstname>
                  </author>
                </authorgroup>
                <title>Limiting the Scope of the KEY Resource Record (RR)</title>
                <pubdate>December 2002</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3655</abbrev>
                <authorgroup>
                  <author>
                    <surname>Wellington</surname>
                    <firstname>B.</firstname>
                  </author>
                  <author>
                    <surname>Gudmundsson</surname>
                    <firstname>O.</firstname>
                  </author>
                </authorgroup>
                <title>Redefinition of DNS Authenticated Data (AD) bit</title>
                <pubdate>November 2003</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3658</abbrev>
                <authorgroup>
                  <author>
                    <surname>Gudmundsson</surname>
                    <firstname>O.</firstname>
                  </author>
                </authorgroup>
                <title>Delegation Signer (DS) Resource Record (RR)</title>
                <pubdate>December 2003</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3755</abbrev>
                <authorgroup>
                  <author>
                    <surname>Weiler</surname>
                    <firstname>S.</firstname>
                  </author>
                </authorgroup>
                <title>Legacy Resolver Compatibility for Delegation Signer (DS)</title>
                <pubdate>May 2004</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3757</abbrev>
                <authorgroup>
                  <author>
                    <surname>Kolkman</surname>
                    <firstname>O.</firstname>
                  </author>
                  <author>
                    <surname>Schlyter</surname>
                    <firstname>J.</firstname>
                  </author>
                  <author>
                    <surname>Lewis</surname>
                    <firstname>E.</firstname>
                  </author>
                </authorgroup>
                <title>Domain Name System KEY (DNSKEY) Resource Record
		      (RR) Secure Entry Point (SEP) Flag</title>
                <pubdate>April 2004</pubdate>
              </biblioentry>
              <biblioentry>
                <abbrev>RFC3845</abbrev>
                <authorgroup>
                  <author>
                    <surname>Schlyter</surname>
                    <firstname>J.</firstname>
                  </author>
                </authorgroup>
                <title>DNS Security (DNSSEC) NextSECure (NSEC) RDATA Format</title>
                <pubdate>August 2004</pubdate>
              </biblioentry>
            </bibliodiv>
          </bibliography>
        </sect2>
        <sect2 id="internet_drafts">
          <title>Internet Drafts</title>
          <para>
            Internet Drafts (IDs) are rough-draft working documents of
            the Internet Engineering Task Force. They are, in essence, RFCs
            in the preliminary stages of development. Implementors are
            cautioned not
            to regard IDs as archival, and they should not be quoted or cited
            in any formal documents unless accompanied by the disclaimer that
            they are "works in progress." IDs have a lifespan of six months
            after which they are deleted unless updated by their authors.
          </para>
        </sect2>
        <sect2>
          <title>Other Documents About <acronym>BIND</acronym></title>
          <para/>
          <bibliography>
            <biblioentry>
              <authorgroup>
                <author>
                  <surname>Albitz</surname>
                  <firstname>Paul</firstname>
                </author>
                <author>
                  <firstname>Cricket</firstname>
                  <surname>Liu</surname>
                </author>
              </authorgroup>
              <title><acronym>DNS</acronym> and <acronym>BIND</acronym></title>
              <copyright>
                <year>1998</year>
                <holder>Sebastopol, CA: O'Reilly and Associates</holder>
              </copyright>
            </biblioentry>
          </bibliography>
        </sect2>
      </sect1>

      <xi:include href="libdns.xml"/>

    </appendix>


    <reference id="Bv9ARM.ch10">
      <title>Manual pages</title>
      <xi:include href="../../bin/dig/dig.docbook"/>
      <xi:include href="../../bin/dig/host.docbook"/>
      <xi:include href="../../bin/python/dnssec-checkds.docbook"/>
      <xi:include href="../../bin/python/dnssec-coverage.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-dsfromkey.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-keyfromlabel.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-keygen.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-revoke.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-settime.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-signzone.docbook"/>
      <xi:include href="../../bin/dnssec/dnssec-verify.docbook"/>
      <xi:include href="../../bin/check/named-checkconf.docbook"/>
      <xi:include href="../../bin/check/named-checkzone.docbook"/>
      <xi:include href="../../bin/named/named.docbook"/>
      <xi:include href="../../bin/tools/named-journalprint.docbook"/>
      <!-- named.conf.docbook and others? -->
      <xi:include href="../../bin/nsupdate/nsupdate.docbook"/>
      <xi:include href="../../bin/rndc/rndc.docbook"/>
      <xi:include href="../../bin/rndc/rndc.conf.docbook"/>
      <xi:include href="../../bin/confgen/rndc-confgen.docbook"/>
      <xi:include href="../../bin/confgen/ddns-confgen.docbook"/>
      <xi:include href="../../bin/tools/arpaname.docbook"/>
      <xi:include href="../../bin/tools/genrandom.docbook"/>
      <xi:include href="../../bin/tools/isc-hmac-fixup.docbook"/>
      <xi:include href="../../bin/tools/nsec3hash.docbook"/>
    </reference>

  </book>

<!--
  - Local variables:
  - mode: sgml
  - End:
 -->
