# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /ostemplate ; mkdir /ostemplate
mkdir -p /ostemplate/var/lib
touch /ostemplate/var/lib/random-seed

yum \
--installroot=/ostemplate \
--nogpg \
--releasever=6 \
--disablerepo=* --enablerepo=sl --enablerepo=sl-fastbugs --enablerepo=sl-security \
-y install \
setup sl-release dhcp-common mailcap ncurses-base glibc-common ncurses-libs libattr zlib libcom_err popt nspr libacl nss-util libstdc++ \
libselinux sed dbus-libs libidn elfutils-libelf pcre libxml2 apr-util sqlite cyrus-sasl-lib libtasn1 libgcrypt libblkid psmisc findutils gawk \
pth gpm-libs newt perl-Pod-Escapes perl-Pod-Simple perl-version libjpeg-turbo sysvinit-tools p11-kit-trust gnutls avahi-libs upstart \
xz-lzma-compat procps libselinux-utils gmp tcp_wrappers portreserve db4-utils e2fsprogs binutils make which libpng ncurses less cracklib \
coreutils-libs pam hwdata logrotate nss-sysinit openldap nss_compat_ossl libpcap keyutils-libs openssl python-libs libcurl libtirpc python-urlgrabber \
rpm-libs net-snmp-libs gnupg2 pygpgme python-iniparse fipscheck-lib bind-libs pkgconfig gamin libuser yum-metadata-parser yum libcap-ng libsemanage \
libnl policycoreutils iproute util-linux-ng udev xinetd sendmail crontabs cronie setuptool talk-server openssh-clients mc httpd quota gettext \
authconfig man vim-enhanced tcpdump lynx elinks mailx screen tcsh elfutils tmpwatch ftp tar aspell rsync ed libtalloc talk ncompress libtdb \
man-pages libgcc filesystem basesystem tzdata sl-indexhtml nss-softokn-freebl glibc bash libcap info db4 chkconfig audit-libs \
bzip2-libs tcp_wrappers-libs libsepol shadow-utils xz-libs expat readline libuuid grep apr lua nss-softokn file-libs libgpg-error p11-kit libutempter \
vim-minimal e2fsprogs-libs procmail hesiod slang gdbm perl-Module-Pluggable perl-libs perl lm_sensors-libs libtiff ca-certificates elfutils-libs libnih \
xz MAKEDEV checkpolicy net-tools libusb bzip2 pinentry libss diffutils m4 libgomp cpio vim-common groff gzip cracklib-dicts coreutils module-init-tools \
redhat-logos nss nss-tools apr-util-ldap libedit libffi krb5-libs python libssh2 libgssglue python-pycurl curl rpm rpm-python gpgme newt-python \
httpd-tools fipscheck cvs shared-mime-info glib2 passwd yum-plugin-fastestmirror dbus-glib ustr mingetty ethtool iptables iputils initscripts openssh \
cyrus-sasl rsyslog cronie-anacron usermode sendmail-cf finger-server openssh-server net-snmp dhclient bind net-snmp-utils rpcbind wget stunnel fetchmail \
cups-libs sudo nscd ntsysv mlocate jwhois lsof unzip time nano telnet traceroute finger rootfiles yum-conf-sl-other

# Fix up /etc/fstab
echo "none /dev/pts devpts rw,gid=5,mode=620 0 0" > /ostemplate/etc/fstab
echo "none /dev/shm tmpfs defaults 0 0" >> /ostemplate/etc/fstab
ln -sf /proc/mounts /ostemplate/etc/mtab

# Get rid of gettys
sed -i -e 's/ACTIVE_CONSOLES=\/dev\/tty\[1\-6\]/ACTIVE_CONSOLES=/g' /ostemplate/etc/sysconfig/init

# Clean up yum, etc
# yum --installroot=/ostemplate clean all
rm -rf /ostemplate/var/cache/yum/*
rm -f /ostemplate/dev/null
mknod -m 600 /ostemplate/dev/console c 5 1

# Copy the scripts into the new container
cp /root/create-sl6* /ostemplate/root/

# Create .tar.xz file
cd /ostemplate ; tar -cvJf /root/scientific-6-x86_64-$(date +%Y%m%d).tar.xz . 
ls -lh /root/scientific-6-x86_64-$(date +%Y%m%d).tar.xz 
echo "Done building OS Template.  Now test it."
