/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * K3: AM6 SoC definitions, structures etc.
 *
 * (C) Copyright (C) 2018 Texas Instruments Incorporated - https://www.ti.com/
 */
#ifndef __ASM_ARCH_AM6_HARDWARE_H
#define __ASM_ARCH_AM6_HARDWARE_H

#include <config.h>
#ifndef __ASSEMBLY__
#include <linux/bitops.h>
#endif

#define CTRL_MMR0_BASE					0x00100000
#define WKUP_CTRL_MMR0_BASE				0x43000000
#define MCU_CTRL_MMR0_BASE				0x40f00000

#define CTRLMMR_MAIN_DEVSTAT				(CTRL_MMR0_BASE + 0x30)
#define CTRLMMR_MAIN_DEVSTAT_BOOTMODE_MASK		GENMASK(3, 0)
#define CTRLMMR_MAIN_DEVSTAT_BOOTMODE_SHIFT		0
#define CTRLMMR_MAIN_DEVSTAT_BKUP_BOOTMODE_MASK		GENMASK(6, 4)
#define CTRLMMR_MAIN_DEVSTAT_BKUP_BOOTMODE_SHIFT	4
#define CTRLMMR_MAIN_DEVSTAT_MMC_PORT_MASK		GENMASK(12, 12)
#define CTRLMMR_MAIN_DEVSTAT_MMC_PORT_SHIFT		12
#define CTRLMMR_MAIN_DEVSTAT_EMMC_PORT_MASK		GENMASK(14, 14)
#define CTRLMMR_MAIN_DEVSTAT_EMMC_PORT_SHIFT		14
#define CTRLMMR_MAIN_DEVSTAT_BKUP_MMC_PORT_MASK		GENMASK(17, 17)
#define CTRLMMR_MAIN_DEVSTAT_BKUP_MMC_PORT_SHIFT	12
#define CTRLMMR_MAIN_DEVSTAT_USB_MODE_SHIFT		9
#define CTRLMMR_MAIN_DEVSTAT_USB_MODE_MASK		GENMASK(10, 9)

/* MCU SCRATCHPAD usage */
#define TI_SRAM_SCRATCH_BOARD_EEPROM_START CONFIG_SYS_K3_MCU_SCRATCHPAD_BASE

/* NAVSS Northbridge config */
#define	NAVSS0_NBSS_NB0_CFG_BASE			0x03802000
#define	NAVSS0_NBSS_NB1_CFG_BASE			0x03803000

#define	NAVSS_NBSS_THREADMAP				0x10

#if defined(CONFIG_SYS_K3_SPL_ATF) && !defined(__ASSEMBLY__)

#define AM6_DEV_MCU_RTI0			134
#define AM6_DEV_MCU_RTI1			135

static const u32 put_device_ids[] = {
	AM6_DEV_MCU_RTI0,
	AM6_DEV_MCU_RTI1,
};

#endif

#define AM6_DEV_MCU_ARMSS0_CPU0			159
#define AM6_DEV_MCU_ARMSS0_CPU1			245

static const u32 put_core_ids[] = {
	AM6_DEV_MCU_ARMSS0_CPU1,
	AM6_DEV_MCU_ARMSS0_CPU0,	/* Handle CPU0 after CPU1 */
};

#endif /* __ASM_ARCH_AM6_HARDWARE_H */
