// SPDX-License-Identifier:     GPL-2.0+
/*
 * This file's test data is derived from UEFI SCT.
 * The original copyright is attached below.
 */

/*
 * Copyright 2006 - 2016 Unified EFI, Inc.<BR>
 * Copyright (c) 2010 - 2016, Intel Corporation. All rights reserved.<BR>
 *
 * This program and the accompanying materials
 * are licensed and made available under the terms and conditions of the BSD
 * License which accompanies this distribution.  The full text of the license
 * may be found at
 * http://opensource.org/licenses/bsd-license.php
 *
 * THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
 * WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.
 */

#include <efi.h>

#ifdef NOT_USED
/*
 * TODO: These macro's are not used as they appear only in
 * "#ifdef NOT_USED" clauses. In the future, define them elsewhere.
 */

/* HII form */
#define EFI_IFR_AND_OP			0x15
#define EFI_IFR_END_OP			0x29
#define EFI_IFR_BITWISE_AND_OP		0x35

/* HII image */
#define EFI_HII_IIBT_END		0x00
#define EFI_HII_IIBT_IMAGE_1BIT		0x10
#endif

/* HII keyboard layout */
#define EFI_NULL_MODIFIER		0x0000

static u8 packagelist1[] = {
	// EFI_HII_PACKAGE_LIST_HEADER, length = 20
	// SimpleFont, Font, GUID, Form, String, Image, DevicePath,
	// (74)        (110) 20    (8)   78      (67)   (8)
	// KeyboardLayout, End
	// 192             4

	0x89, 0xcd, 0xab, 0x03, 0xf4, 0x03, 0x44, 0x70,
	0x81, 0xde, 0x99, 0xb1, 0x81, 0x20, 0xf7, 0x68,	//16: guid
	0x3a, 0x01, 0x00, 0x00,				// 4: total 314(0x13a)
#ifdef NOT_USED /* TODO: simple font package not implemented yet */
	//
	// Simple Font Package 1, length = 74
	//
	0x4A, 0x00, 0x00,
	EFI_HII_PACKAGE_SIMPLE_FONTS,
	1, 0,
	1, 0,
	0x55, 0x0, 0x1,
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	0x77, 0x0, 0x2,
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
	3, 4, 5,
	6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 0, 0, 0,
	//
	// Font Package 1, length = 110
	//
	0x6e, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_FONTS,				// 1
	0x5c, 0x00, 0x00, 0x00,				// 4: size of header
	0x5c, 0x00, 0x00, 0x00,				// 4: offset
	0xf1, 0x00, 0xf2, 0x00, 0xf3, 0x00, 0xf4, 0x00,
	0xf5, 0x00, 0xec, 0xec,				//10+2(pads)
	0xff, 0x33, 0xff, 0x44,				// 4: font style
	0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66,	//64
	//
	// Glyph block  1, length = 18
	//
	EFI_HII_GIBT_GLYPH_DEFAULT,			// 1
	0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x99,
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,	//16: BitMapData
	EFI_HII_GIBT_END,				// 1
#endif
	//
	// Guid Package 1, length = 20
	//
	0x14, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_TYPE_GUID,			// 1
	0x5a, 0xc9, 0x87, 0x03, 0x3, 0xd7, 0x46, 0x23,
	0xb2, 0xab, 0xd0, 0xc7, 0xdd, 0x90, 0x44, 0xf8,	//16: guid
#ifdef NOT_USED /* TODO: form package not implemented yet */
	//
	// EFI_HII_PACKAGE_FORMS, length = 8
	//
	0x08, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_FORMS,				// 1
	//
	// Opcode 1, length = 4
	//
	EFI_IFR_AND_OP,
	0x82,
	EFI_IFR_END_OP,
	0x02,
	//
#endif
	// EFI_HII_PACKAGE_STRINGS, length = 78
	//
	0x4e, 0x00, 0x00,				// 3: length(header)
	EFI_HII_PACKAGE_STRINGS,			// 1: type(header)
	0x3c, 0x00, 0x00, 0x00,				// 4: header_size
	0x3c, 0x00, 0x00, 0x00,				// 4: string_offset
	0x00, 0x00, 0x11, 0x22, 0x44, 0x55, 0x77, 0x89,	//32: language_window
	0x11, 0x00, 0x11, 0x22, 0x44, 0x55, 0x87, 0x89,
	0x22, 0x00, 0x11, 0x22, 0x44, 0x55, 0x77, 0x89,
	0x33, 0x00, 0x11, 0x22, 0x44, 0x55, 0x77, 0x89,
	0x01, 0x00,					// 2: language name
	0x65, 0x6e, 0x2d, 0x55, 0x53, 0x3b, 0x7a, 0x68, //14: language
	0x2d, 0x48, 0x61, 0x6e, 0x74, 0x00,		//    "en-US;zh-Hant"
	EFI_HII_SIBT_STRING_UCS2,			// 1
	0x45,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x6C, 0x00,
	0x69,  0x00,  0x73,  0x00,  0x68,  0x00,  0x00, 0x00,	//16: "English"
	EFI_HII_SIBT_END,				// 1
#ifdef NOT_USED /* TODO: image package not implemented yet */
	//
	// EFI_HII_PACKAGE_IMAGES, length = 67
	//
	0x43, 0x00, 0x00,			// 3
	EFI_HII_PACKAGE_IMAGES,			// 1
	0x0c, 0x00, 0x00, 0x00,			// 4: image info offset
	0x39, 0x00, 0x00, 0x00,			// 4: palette info offset
	EFI_HII_IIBT_IMAGE_1BIT,		// 1
	0x01,
	0x0b, 0x00,
	0x13, 0x00,
	0x80, 0x00,
	0xc0, 0x00,
	0xe0, 0x00,
	0xf0, 0x00,
	0xf8, 0x00,
	0xfc, 0x00,
	0xfe, 0x00,
	0xff, 0x00,
	0xff, 0x80,
	0xff, 0xc0,
	0xff, 0xe0,
	0xfe, 0x00,
	0xef, 0x00,
	0xcf, 0x00,
	0x87, 0x80,
	0x07, 0x80,
	0x03, 0xc0,
	0x03, 0xc0,
	0x01, 0x80,				//43
	EFI_HII_IIBT_END,			// 1
	0x01, 0x00,
	0x06, 0x00,
	0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF,			//10
	//
	// EFI_HII_PACKAGE_DEVICE_PATH, length = 8
	//
	0x08, 0x00, 0x00,			// 3
	EFI_HII_PACKAGE_DEVICE_PATH,		// 1
	0x01, 0x23, 0x45, 0x66,			// 4: dummy device path protocol
						//    instance address
#endif
	//
	// Keyboard layout package 1, length = 192
	0xc0, 0x00, 0x00,			// 3: length(header)
	EFI_HII_PACKAGE_KEYBOARD_LAYOUT,	// 1: type(header)
	0x02, 0x00,				// 2: LayoutCount
	//
	// Layout 1, length = 93
	//
	0x5d, 0x00,				// 2: layout_length
	0x95, 0xe4, 0x40, 0x8d, 0xaa, 0xe2, 0x6f, 0x4c,
	0x89, 0x70, 0x68, 0x85, 0x09, 0xee, 0xc7, 0xd2, //16: guid
	0x37, 0x00, 0x00, 0x00,			// 4: layout_descriptor_
						//        string_offset
	0x02,					// 1: descriptor_count
	//
	// Descriptor 1, length = 16
	//
	49, 0x00, 0x00, 0x00,			// 4: key (EfiKeyD1)
	'q', 0x00,				// 2: unicode
	'Q', 0x00,				// 2: shifted_unicode
	0x00, 0x00,				// 2: alt_gr_unicode
	0x00, 0x00,				// 2: shifted_alt_gr_unicode
	EFI_NULL_MODIFIER, 0x00,		// 2: modifier
	0x03, 0x00,				// 2: affected_attribute
	//
	// Descriptor 2,  length = 16
	//
	50, 0x00, 0x00, 0x00,			// 4: key (EfiKeyD2)
	'w', 0x00,				// 2: unicode
	'W', 0x00,				// 2: shifted_unicode
	0x00, 0x00,				// 2: alt_gr_unicode
	0x00, 0x00,				// 2: shifted_alt_gr_unicode
	EFI_NULL_MODIFIER, 0x00,		// 2: modifier
	0x3, 0x0,				// 2: affected_attribute
	//
	// EFI_DESCRIPTOR_STRING_BUNDLE, length = 38
	//
	0x01, 0x00,				// 2: DescriptionCount
	'e', 0x0, 'n', 0x0, '-', 0x0, 'U', 0x0, 'S', 0x0,
						//10: RFC3066 language code
	' ', 0x0,				// 2: Space
	'S', 0x0, 'i', 0x0, 'm', 0x0, 'p', 0x0, 'l', 0x0, 'e', 0x0,
	'1', 0x0, 'o', 0x0, 'n', 0x0, 'l', 0x0, 'y', 0x0, '\0', 0x0,
						//24: DescriptionString
	//
	// Layout 2, length = 93
	//
	0x5d, 0x00,				// 2: layout_length
	0x3e, 0x0b, 0xe6, 0x2a, 0xd6, 0xb9, 0xd8, 0x49,
	0x9a, 0x16, 0xc2, 0x48, 0xf1, 0xeb, 0xa8, 0xdb,	//16: guid
	0x37, 0x00, 0x00, 0x00,			// 4: layout_descriptor_
						//    string_offset
	0x02,					// 1 Descriptor count
	//
	// Descriptor 1, length = 16
	//
	51, 0x0, 0x0, 0x0,			// 4: key (EfiKeyD3)
	'e', 0x00,				// 2: unicode
	'E', 0x00,				// 2: shifted_unicode
	0x00, 0x00,				// 2: alt_gr_unicode
	0x00, 0x00,				// 2: shifted_alt_gr_unicode
	EFI_NULL_MODIFIER, 0x0,			// 2: modifier
	0x3, 0x0,				// 2: affected_attribute
	//
	// Descriptor 2,  length = 16
	//
	52, 0x0, 0x0, 0x0,			// 4: key (EfiKeyD4)
	'r', 0x00,				// 2: unicode
	'R', 0x00,				// 2: shifted_unicode
	0x00, 0x00,				// 2: alt_gr_unicode
	0x00, 0x00,				// 2: shifted_alt_gr_unicode
	EFI_NULL_MODIFIER, 0x0,			// 2: modifier
	0x3, 0x0,				// 2: affected_attribute
	//
	// EFI_DESCRIPTOR_STRING_BUNDLE, length = 38
	//
	0x01, 0x00,				// 2: DescriptionCount
	'e', 0x0, 'n', 0x0, '-', 0x0, 'U', 0x0, 'S', 0x0,
						//10: RFC3066 language code
	' ', 0x0,				// 2: Space
	'S', 0x0, 'i', 0x0, 'm', 0x0, 'p', 0x0, 'l', 0x0, 'e', 0x0,
	'2', 0x0, 'o', 0x0, 'n', 0x0, 'l', 0x0, 'y', 0x0, '\0', 0x0,
						//24: DescriptionString
	//
	// End of package list, length = 4
	//
	0x4, 0x00, 0x00,
	EFI_HII_PACKAGE_END
};

static u8 packagelist2[] = {
	// EFI_HII_PACKAGE_LIST_HEADER, length = 20
	// SimpleFont, Font, GUID, KeyboardLayout, Form, End
	// (74)        (122) 20    192             (8)   4
	0xd3, 0xde, 0x85, 0x86, 0xce, 0x1b, 0xf3, 0x43,
	0xa2, 0x0c, 0xa3, 0x06, 0xec, 0x69, 0x72, 0xdd,	//16
	0xec, 0x00, 0x00, 0x00,				// 4: total 236(0xec)

#ifdef NOT_USED /* TODO: simple font package not implemented yet */
	//
	// Simple Font Package 2, length = 74
	//
	0x4A, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_SIMPLE_FONTS,			// 1
	1, 0,						// 2
	1, 0,						// 2
	0x33, 0x0, 0, 1, 2, 3, 4, 5, 0, 7, 8, 9,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 19,		//22
	0x44, 0x0, 0x2, 2, 3, 4, 5, 6, 0, 8, 9,
	10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,	//22
	3, 4, 5, 6, 7, 8, 9, 10, 11, 9, 13,
	14, 15, 16, 17, 18, 19, 20, 21, 0, 0, 0,	//22
	//
	// Font Package 2, length = 122
	//
	0x7A, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_FONTS,				// 1
	0x5C, 0x00, 0x00, 0x00,				// 4: size of header
	0x5C, 0x00, 0x00, 0x00,				// 4: dummy offset
	0xf1, 0x00, 0xf2, 0x00, 0xf3, 0x00, 0xf4, 0x00,
	0xf5, 0x00, 0xec, 0xec,				//10+2(pads)
	0xff, 0x11, 0xff, 0x22,				// 4: font style
	0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88,	//64
	//
	// Glyph block  1, length = 30
	//
	EFI_HII_GIBT_GLYPH,				// 1
	0xf1, 0x00, 0xf2, 0x00, 0xf3, 0x00, 0xf4, 0x00,
	0xf5, 0x00,					//10
	0xff, 0x01,					// 2
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,	//16: BitMapData
	EFI_HII_GIBT_END,				// 1
#endif
	//
	// Guid Package 1, length = 20
	//
	0x14, 0x00, 0x00,				// 3
	EFI_HII_PACKAGE_TYPE_GUID,			// 1
	0x5a, 0xc9, 0x87, 0x03, 0x3, 0xd7, 0x46, 0x23,
	0xb2, 0xab, 0xd0, 0xc7, 0xdd, 0x90, 0x44, 0xf8,	//16: guid
	//
	// Keyboard layout package 2, length = 192
	0xc0, 0x00, 0x00,			// 3
	EFI_HII_PACKAGE_KEYBOARD_LAYOUT,	// 1
	0x02, 0x00, //0xec, 0xec,		// 2: LayoutCount
	//
	// Layout 1, length = 93
	//
	0x5d, 0x00,					// 2: layout_length
	0x1f, 0x6a, 0xf5, 0xe0, 0x6b, 0xdf, 0x7e, 0x4a,
	 0xa3, 0x9a, 0xe7, 0xa5, 0x19, 0x15, 0x45, 0xd6,//16: guid
	0x37, 0x00, 0x00, 0x00,				// 4: layout_descriptor
							//    string offset
	0x02,						// 1: descriptor_count
	//
	// Descriptor 1, length = 16
	//
	32, 0x00, 0x00, 0x00,			// 4: key (EfiKeyC1)
	'a', 0x00,				// 2: unicode
	'A', 0x00,				// 2: shifted_unicode
	0x00, 0x00,				// 2: alt_gr_unicode
	0x00, 0x00,				// 2: shifted_alt_gr_unic
	EFI_NULL_MODIFIER, 0x00,		// 2: modifier
	0x03, 0x00,				// 2: affected_attribute
	//
	// Descriptor 2,  length = 16
	//
	33 /*EfiKeyC2*/, 0x00, 0x00, 0x00,
	's', 0x00,
	'S', 0x00,
	0x00, 0x00,
	0x00, 0x00,
	EFI_NULL_MODIFIER, 0x00,
	0x3, 0x0,
	//
	// EFI_DESCRIPTOR_STRING_BUNDLE, length = 38
	//
	0x01, 0x00,				// 2: DescriptionCount
	'e', 0x0, 'n', 0x0, '-', 0x0, 'U', 0x0, 'S', 0x0,
						//10: RFC3066 language code
	' ', 0x0,				// 2: Space
	'S', 0x0, 'i', 0x0, 'm', 0x0, 'p', 0x0, 'l', 0x0, 'e', 0x0,
	'3', 0x0, 'o', 0x0, 'n', 0x0, 'l', 0x0, 'y', 0x0, '\0', 0x0,
						//24: DescriptionString
	//
	// Layout 2, length = 93
	//
	0x5d, 0x00,					// 2: layout_length
	0xc9, 0x6a, 0xbe, 0x47, 0xcc, 0x54, 0xf9, 0x46,
	0xa2, 0x62, 0xd5, 0x3b, 0x25, 0x6a, 0xc, 0x34,	//16: guid
	0x37, 0x00, 0x00, 0x00,				// 4: layout_descriptor
							//    string_offset
	0x02,						// 1: descriptor_count
	//
	// Descriptor 1, length = 16
	//
	34 /*EfiKeyC3*/, 0x0, 0x0, 0x0,
	'd', 0x00,
	'D', 0x00,
	0x00, 0x00,
	0x00, 0x00,
	EFI_NULL_MODIFIER, 0x0,
	0x3, 0x0,
	//
	// Descriptor 2,  length = 16
	//
	35 /*EfiKeyC4*/, 0x0, 0x0, 0x0,
	'e', 0x00,
	'E', 0x00,
	0x00, 0x00,
	0x00, 0x00,
	EFI_NULL_MODIFIER,  0x0,
	0x3, 0x0,
	//
	// EFI_DESCRIPTOR_STRING_BUNDLE, length = 38
	//
	0x01, 0x00,				// 2: DescriptionCount
	'e', 0x0, 'n', 0x0, '-', 0x0, 'U', 0x0, 'S', 0x0,
						//10: RFC3066 language code
	' ', 0x0,				// 2: Space
	'S', 0x0, 'i', 0x0, 'm', 0x0, 'p', 0x0, 'l', 0x0, 'e', 0x0,
	'4', 0x0, 'o', 0x0, 'n', 0x0, 'l', 0x0, 'y', 0x0, '\0', 0x0,
						//24: DescriptionString
#ifdef NOT_USED /* TODO: form package not implemented yet */
	//
	// EFI_HII_PACKAGE_FORMS, length = 8
	//
	0x08, 0x00, 0x00,			// 3
	EFI_HII_PACKAGE_FORMS,			// 1
	//
	// Opcode 1
	//
	EFI_IFR_BITWISE_AND_OP,			// 1
	0x02,					// 1
	EFI_IFR_END_OP,				// 1
	0x02,					// 1
#endif
	//
	// End of package list, length = 4
	//
	0x4, 0x00, 0x00,			// 3
	EFI_HII_PACKAGE_END			// 1
};

static efi_guid_t kb_layout_guid11 =
	EFI_GUID(0x8d40e495, 0xe2aa, 0x4c6f,
		 0x89, 0x70, 0x68, 0x85, 0x09, 0xee, 0xc7, 0xd2);

static efi_guid_t package_guid =
	EFI_GUID(0x0387c95a, 0xd703, 0x2346,
		 0xb2, 0xab, 0xd0, 0xc7, 0xdd, 0x90, 0x44, 0xf8);
