!!****h* BigDFT/lazy_20
!! NAME
!!   lazy_20
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 30)
!!
!! SOURCE
!!
integer, parameter :: m=22
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     -3.53757059201598167e-7_dp,0._dp,7.51213519833981991e-6_dp,0._dp, &
     -0.0000766237790230661631_dp,0._dp,0.000501001632073894143_dp,0._dp, &
     -0.00236837135162204504_dp,0._dp,0.00868402828928083181_dp,0._dp,&
     -0.0260520848678424954_dp,0._dp,0.0677354206563904881_dp,0._dp,&
     -0.16933855164097622_dp,0._dp,0.620908022683579475_dp,1._dp,0.620908022683579475_dp,&
     0._dp,-0.16933855164097622_dp,0._dp,0.0677354206563904881_dp,0._dp,&
     -0.0260520848678424954_dp,0._dp,0.00868402828928083181_dp,0._dp,&
     -0.00236837135162204504_dp,0._dp,0.000501001632073894143_dp,0._dp,&
     -0.0000766237790230661631_dp,0._dp,7.51213519833981991e-6_dp,0._dp,&
     -3.53757059201598167e-7_dp, &
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

