!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_free_type_wfs
!!
!! NAME
!! wvl_free_type_wfs
!!
!! FUNCTION
!! Freeing routine.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  wfs <type(wvl_wf_type)>=wavefunctions informations in a wavelet basis.
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_free_type_wfs(wfs)

  use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_14wvl_wfs, except_this_one => wvl_free_type_wfs
#endif
!End of the abilint section

  implicit none

!Arguments ------------------------------------
  !scalars
  type(wvl_wf_type), intent(inout) :: wfs

!Local variables -------------------------
! *********************************************************************

  call wvl_free_type_keyArrays(wfs%keys)

  deallocate(wfs%psi)
  deallocate(wfs%hpsi)
  deallocate(wfs%eval)
#if defined MPI
  deallocate(wfs%psit)
#endif
  if (wfs%mband_init > 0) then
    deallocate(wfs%psi_init)
    deallocate(wfs%occ_init)
  end if
  deallocate(wfs%ibyz_c, wfs%ibxz_c, wfs%ibxy_c)
  deallocate(wfs%ibyz_f, wfs%ibxz_f, wfs%ibxy_f)
  if (associated(wfs%psidst)) deallocate(wfs%psidst)
  if (associated(wfs%hpsidst)) deallocate(wfs%hpsidst)
  if (associated(wfs%ads)) deallocate(wfs%ads)
end subroutine wvl_free_type_wfs
!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_free_type_proj
!!
!! NAME
!! wvl_free_type_proj
!!
!! FUNCTION
!! Freeing routine.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  proj <type(wvl_projectors_type)>=projectors informations in a wavelet basis.
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!
!! SOURCE
subroutine wvl_free_type_proj(proj)

  use defs_basis
  use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_14wvl_wfs, except_this_one => wvl_free_type_proj
#endif
!End of the abilint section

  implicit none

!Arguments ------------------------------------
  !scalars
  type(wvl_projectors_type), intent(inout) :: proj
!Local variables -------------------------
! *********************************************************************

  call wvl_free_type_keyArrays(proj%keys)

  deallocate(proj%proj)
  deallocate(proj%nbox_c, proj%nbox_f)
end subroutine wvl_free_type_proj
!!***

!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_free_type_keyArrays
!!
!! NAME
!! wvl_free_type_keyArrays
!!
!! FUNCTION
!! Freeing routine.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  keys <type(wvl_keyArrays_type)>=access keys informations for wavelet storage.
!!
!! PARENTS
!!      wvl_free_type
!!
!! CHILDREN
!!
!! SOURCE
subroutine wvl_free_type_keyArrays(keys)

  use defs_basis
  use defs_datatypes

  implicit none

!Arguments ------------------------------------
  !scalars
  type(wvl_keyArrays_type), intent(inout) :: keys
!Local variables -------------------------
! *********************************************************************

  deallocate(keys%nseg)
  deallocate(keys%nvctr)
  deallocate(keys%keyv)
  deallocate(keys%keyg)
end subroutine wvl_free_type_keyArrays
!!***
