!{\src2tex{textfont=tt}}
!!****f* ABINIT/setshells
!! NAME
!! setshells
!!
!! FUNCTION
!! Set consistently the number of shells, the number of plane-waves,
!! and the energy cut-off
!!
!! COPYRIGHT
!! Copyright (C) 2001-2007 ABINIT group (GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  gprimd(3,3)=dimensional primitive vectors in reciprocal space
!!  gmet(3,3)=metric tensor in reciprocal space
!!  nsym=number of symmetry operations
!!  symrel(3,3,nsym)=symmetry operations in real space
!!  tag(len=3)=suffix to npw, ecut or nsh, to account for the different
!!   possibilities for these variables
!!  ucvol=unit cell volume
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  ecut,npw,nsh=one of them is an input, the two others are output
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      kpgsph,leave_new,sort_dp,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine setshells(ecut,npw,nsh,nsym,gmet,gprimd,symrel,tag,ucvol)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13recipspace
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nsym
 integer,intent(inout) :: npw,nsh
 real(dp),intent(in) :: ucvol
 real(dp),intent(inout) :: ecut
 character(len=3),intent(in) :: tag
!arrays
 integer,intent(in) :: symrel(3,3,nsym)
 real(dp),intent(in) :: gmet(3,3),gprimd(3,3)

!Local variables-------------------------------
!scalars
 integer :: exchn2n3,ifound,ig,ii,ish,isym,nproc_fft,npw_found,npwave,npwwrk
 integer :: nsh_found,pad=50
 real(dp) :: ecut_found,ecut_trial,eps,scale=1.3_dp
 logical :: found
 character(len=500) :: message
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: geq(3)
 integer,allocatable :: gvec(:,:),gvec_sh(:,:),insort(:),npw_sh(:)
 real(dp) :: gctr(3)
 real(dp),allocatable :: gnorm(:),gnorm_sh(:)

!******************************************************************
!BEGIN EXECUTABLE SECTION

 write(6,*)' setshells : enter '

!Check coherence of input variables ecut, npw, and nsh
!1-> one at least should be non-null
 if(npw==0 .and. nsh==0 .and. ecut==0) then
  write(message, '(a,a,a,a,a3,a,a3,a,a3,a,a,a)' ) ch10,&
&   ' setshells: ERROR -',ch10,&
&   '  One of the three variables ecut',tag,', npw',tag,', or nsh',tag,&
&   ' must be non-null.',ch10,&
&   ' Action : modify the value of one of these in input file.'
  call wrtout(ab_out,message,'COLL')
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if

!2-> one and only one should be non-null
 if(npw/=0 .and. nsh/=0) then
  write(message, '(a,a,a,a,a3,a,a3,a,a,a)' ) ch10,&
&  ' setshells: ERROR -',ch10,&
&  '  Only one of the two variables npw',tag,' and nsh',tag,&
&  ' can be non-null.',ch10,&
&  ' Action : modify the value of one of these in input file.'
  call wrtout(ab_out,message,'COLL')
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if
 if(ecut/=0 .and. npw/=0) then
  write(message, '(a,a,a,a,a3,a,a3,a,a,a)' ) ch10,&
&  ' setshells: ERROR -',ch10,&
&  '  Only one of the two variables ecut',tag,' and npw',tag,&
&  ' can be non-null.',ch10,&
&  ' Action : modify the value of one of these in input file.'
  call wrtout(ab_out,message,'COLL')
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if
 if(ecut/=0 .and. nsh/=0) then
  write(message, '(a,a,a,a,a3,a,a3,a,a,a)' ) ch10,&
&  ' setshells: ERROR -',ch10,&
&  '  Only one of the two variables ecut',tag,' and nsh',tag,&
&  ' can be non-null.',ch10,&
&  ' Action : modify the value of one of these in input file.'
  call wrtout(ab_out,message,'COLL')
  call wrtout(06,  message,'COLL')
  call leave_new('COLL')
 end if

!Center of the g-vector sphere
 gctr(:)=(/ 0.0_dp, 0.0_dp, 0.0_dp /)

!Calculates an upper bound for npw
!1. If ecut is given in the input
 if(ecut>tol6) then
! the average number of plane-waves in the cutoff sphere is
! npwave = (2*ecut)**(3/2) * ucvol / (6*pi**2)
  npwave=nint(ucvol*(2.0_dp*ecut)**1.5_dp/(6.0_dp*pi**2))
! the upper bound is calculated as
! npwwrk = int(scale * npwave) + pad
  npwwrk=nint(dble(npwave)*scale)+pad
  ecut_trial=ecut
!2. If npw is given in the input
 elseif(npw /= 0) then
  npwwrk=nint(dble(npw)*scale)+pad
  ecut_trial=(6.0_dp*pi**2*npw/ucvol)**two_thirds/two
!3. If nsh is given in the input
 else
  npwwrk=nsh*18+2*pad
  ecut_trial=(6.0_dp*pi**2*nsh*18/ucvol)**two_thirds/two
 end if

 allocate(gvec(3,npwwrk))
 ifound=0
 do while(ifound==0)

  write(6,*)' setshells : ecut_trial=',ecut_trial
  exchn2n3=0 ! For the time being, no exchange of n2 and n3
  mpi_enreg%me_fft=0   ! Sequential
  mpi_enreg%nproc_fft=1! Sequential
  mpi_enreg%paral_compil_fft=0! Sequential
  call kpgsph(ecut_trial,exchn2n3,gmet,0,1,1,gvec,gctr,&
&  1,mpi_enreg,npwwrk,npw_found)
  allocate(gnorm(npw_found))
  allocate(insort(npw_found))

  do ig=1,npw_found
   insort(ig)=ig
   gnorm(ig)=0.0_dp
   do ii=1,3
    gnorm(ig)=gnorm(ig)+(gvec(1,ig)*gprimd(ii,1)+&
&                        gvec(2,ig)*gprimd(ii,2)+&
&                        gvec(3,ig)*gprimd(ii,3))**2
   end do
  end do
  call sort_dp(npw_found,gnorm,insort,tol14)
  allocate(npw_sh(npw_found))
  allocate(gnorm_sh(npw_found))
  allocate(gvec_sh(3,npw_found))
  npw_sh(:)=0
  gnorm_sh(:)=0.0_dp
  gvec_sh(:,:)=0
! Count the number of shells:
! (search for the G-vectors generating the others by symmetry)
  nsh_found=0
  do ig=1,npw_found
   eps=1.d-8*gnorm(ig)
   found=.false.
   ish=1
   do while ((.not.found).and.(ish<=nsh_found))
    if (abs(gnorm(ig)-gnorm_sh(ish))<=eps) then
     isym=1
     do while ((.not.found).and.(isym<=nsym))
      geq(:)=(symrel(1,:,isym)*gvec(1,insort(ig))+&
&             symrel(2,:,isym)*gvec(2,insort(ig))+ &
&             symrel(3,:,isym)*gvec(3,insort(ig)))
      found=((geq(1)==gvec_sh(1,ish)).and.&
&            (geq(2)==gvec_sh(2,ish)).and.&
&            (geq(3)==gvec_sh(3,ish)))
      isym=isym+1
     end do
    end if
    ish=ish+1
   end do
   if (.not.found) then
    nsh_found=nsh_found+1
    gnorm_sh(nsh_found)=gnorm(ig)
    gvec_sh(:,nsh_found)=gvec(:,insort(ig))
    npw_sh(nsh_found)=1
   else
    ish=ish-1
    npw_sh(ish)=npw_sh(ish)+1
   end if
  end do
  ecut_found=2*pi**2*gnorm(npw_found)

! 1. If ecut is given in the input
  if(ecut>tol6) then
   if(ecut_found<ecut)then
    write(message, '(a,a,a,a,a3,a,e14.6,a,a,a,a3,a,a3,a,a3,a,e14.6,a,a,a)' )&
&    ch10,&
&    ' setshells: WARNING -',ch10,&
&    '  The value ecut',tag,'=',ecut,' given in the input file leads to',ch10,&
&    '  the same values for nsh',tag,' and npw',tag,' as ecut',&
&    tag,'=',ecut_found,ch10,&
&    '  This value will be adopted for the calculation.',ch10
    call wrtout(06,  message,'COLL')
   end if
   ifound=1
! 2. If npw is given in the input
  elseif(npw/=0) then
   if(npw_found==npw) then
    ecut_found=2*pi**2*gnorm(npw_found)
    ifound=1
   elseif(npw_found>npw) then
    npw_found=0
    nsh_found=0
    do while(npw_found<npw)
      nsh_found=nsh_found+1
      npw_found=npw_found+npw_sh(nsh_found)
    end do
!   check that the shell is closed
    if(npw_found>npw) then
!    shell not closed
     npw_found=npw_found-npw_sh(nsh_found)
     nsh_found=nsh_found-1
     do while(abs(gnorm_sh(nsh_found)-gnorm_sh(nsh_found+1))<0.000001)
      npw_found=npw_found-npw_sh(nsh_found)
      nsh_found=nsh_found-1
     end do
     write(message, '(a,a,a,a,a3,a,i6,a,a,a,a,a3,a,i6,a,a,a)' ) ch10,&
&     ' setshells: WARNING -',ch10,&
&     '  The value npw',tag,'=',npw,' given in the input file does',&
&     ' not close the shell',ch10,&
&     '  The lower closed-shell is obtained for a value npw',tag,'=',&
&     npw_found,ch10,&
&     '  This value will be adopted for the calculation.',ch10
     call wrtout(06,  message,'COLL')
    end if
    ecut_found=2*pi**2*gnorm(npw_found)
    ifound=1
   end if
! 3. If nsh is given in the input
  elseif(nsh/=0) then
   if(nsh_found==nsh) then
    ecut_found=2*pi**2*gnorm(npw_found)
    ifound=1
   elseif(nsh_found>nsh) then
    npw_found=0
    nsh_found=0
    do ish=1,nsh
     npw_found=npw_found+npw_sh(ish)
     nsh_found=nsh_found+1
    end do
    if(abs(gnorm_sh(nsh_found)-gnorm_sh(nsh_found+1))<0.000001) then
     do while(abs(gnorm_sh(nsh_found)-gnorm_sh(nsh_found+1))<0.000001)
      nsh_found=nsh_found+1
      npw_found=npw_found+npw_sh(nsh_found)
     end do
     write(message, '(a,a,a,a,a3,a,i6,a,a,a,a,a3,a,i6,a,a,a)' ) ch10,&
&     ' setshells: WARNING -',ch10,&
&     '  The value nsh',tag,'=',nsh,' given in the input file',&
&     ' corresponds to the same',ch10,&
&     '  cut-off energy as for closed-shell upto nsh',tag,'=',&
&     nsh_found,ch10,&
&     '  This value will be adopted for the calculation.',ch10
     call wrtout(06,  message,'COLL')
    end if
    ecut_found=2*pi**2*gnorm(npw_found)
    ifound=1
   end if
  end if

  if(ifound==0) then
   ecut_trial=1.1*ecut_trial
   deallocate(gnorm,gnorm_sh,gvec_sh,insort,npw_sh)
  else
   ecut=ecut_found
   npw=npw_found
   nsh=nsh_found
  end if

 end do !while(ifound==0)
 deallocate(gnorm,gnorm_sh,gvec,gvec_sh,insort,npw_sh)

 write(6,*)' setshells : exit '

end subroutine setshells
!!***
