!{\src2tex{textfont=tt}}
!!****f* ABINIT/subdiago_htor
!! NAME
!! subdiago_htor
!!
!! FUNCTION
!! This routine diagonalizes the Hamiltionian is the eigenfunctions subspace
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  filstat=name of the status file
!!  icg=shift to be applied on the location of data in the array cg
!!  igsc=shift to be applied on the location of data in the array gsc
!!  ikpt=number of the k-point
!!  inonsc=index of non self-consistent loop
!!  istwf_k=input parameter that describes the storage of wfs
!!  mcg=second dimension of the cg array
!!  mgsc=second dimension of the gsc array
!!  mpi_enreg=informations about MPI parallelization
!!  nband_k=number of bands at this k point for that spin polarization
!!  npw_k=number of plane waves at this k point
!!  nspinor=number of spinorial components of the wavefunctions
!!  prtvol=control print volume and debugging output
!!  subham(nband_k*(nband_k+1))=Hamiltonian expressed in sthe WFs subspace
!!  subovl(nband_k*(nband_k+1)*use_subovl)=overlap matrix expressed in sthe WFs subspace
!!  use_subovl=1 if the overlap matrix is not identity in WFs subspace
!!  usepaw= 0 for non paw calculation; =1 for paw calculation
!!
!! OUTPUT
!!  eig_k(nband_k)=array for holding eigenvalues (hartree)
!!  evec(2*nband_k,nband_k)=array for holding eigenvectors
!!
!! SIDE EFFECTS
!!  cg(2,mcg)=wavefunctions
!!  gsc(2,mgsc)=<g|S|c> matrix elements (S=overlap)
!!
!! PARENTS
!!      vtowfk_htor
!!
!! CHILDREN
!!      hermit,status,wrtout,zhpev
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine subdiago_htor(cg,filstat,eig_k,evec,gsc,icg,igsc,ikpt,inonsc,istwf_k,&
&                    mcg,mgsc,mpi_enreg,nband_k,npw_k,nspinor,prtvol,&
&                    subham,subovl,use_subovl,usepaw)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: icg,igsc,ikpt,inonsc,istwf_k,mcg,mgsc,nband_k,npw_k
 integer,intent(in) :: nspinor,prtvol,use_subovl,usepaw
 character(len=fnlen),intent(in) :: filstat
 type(MPI_type),intent(inout) :: mpi_enreg
 real(dp),intent(inout) :: subovl(nband_k*(nband_k+1)*use_subovl)
 real(dp),intent(inout) :: subham(nband_k*(nband_k+1))
 real(dp),intent(out) :: eig_k(nband_k),evec(2*nband_k,nband_k)
 real(dp),intent(inout) :: cg(2,mcg),gsc(2,mgsc)

!Local variables-------------------------------
 integer,parameter :: level=8
 integer :: iband,ii,jj,ierr,iexit,nb,nn,index1,n2,blksz,index2,ipw,nre,nim
 character(len=500) :: message
 real(dp) :: tsec(2), xnorm, phre, phim, den, evre, evim
 real(dp),allocatable :: zhpev1(:,:),zhpev2(:),work(:,:)

! *********************************************************************

#ifdef VMS
!DEC$ ATTRIBUTES ALIAS:'ZHPEV' :: zhpev
#endif

!Impose Hermiticity on diagonal elements of subham (and subovl, if needed)
 call status(inonsc,filstat,iexit,level,'call hermit   ')
 call hermit(subham,subham,ierr,nband_k)
 if (use_subovl==1) call hermit(subovl,subovl,ierr,nband_k)

! Diagonalize the Hamitonian matrix
 call status(inonsc,filstat,iexit,level,'call zhpev    ')
 allocate(zhpev1(2,2*nband_k-1),zhpev2(3*nband_k-2))

 call ZHPEV ('V','U',nband_k,subham,eig_k,evec,nband_k,zhpev1,zhpev2,ierr)

 deallocate(zhpev1,zhpev2)

 !Normalize each eigenvector and set phase:
 !!!!!! call normev(evec,nband_k,nband_k)
 do ii=1,nband_k
   ! find norm
   xnorm=0.0_dp
   do jj=1,2*nband_k
     xnorm=xnorm+evec(jj,ii)**2
   end do
   xnorm=1.0_dp/sqrt(xnorm)
   ! Set up phase
   phre=evec(2*ii-1,ii)
   phim=evec(2*ii,ii)
   if (phim/=0.0_dp) then
     den=1.0_dp/sqrt(phre**2+phim**2)
     phre=phre*xnorm*den
     phim=phim*xnorm*den
   else
     ! give xnorm the same sign as phre (negate if negative)
     phre=sign(xnorm,phre)
     phim=0.0_dp
   end if
   ! normalize with phase change
   do jj=1,2*nband_k,2
     evre=evec(jj,ii)
     evim=evec(jj+1,ii)
     evec(jj,ii)=phre*evre+phim*evim
     evec(jj+1,ii)=phre*evim-phim*evre
   end do
 end do
 !!!! /normev

 if(prtvol==-level)then
  write(message,'(a)') ' subdiago : iband band  evec(re:im)'
  call wrtout(06,message,'PERS')
  do iband=1,nband_k
   do ii=1,nband_k
    write(message,'(2i5,2es16.6)') iband,ii,evec(2*ii-1,iband),evec(2*ii,iband)
    call wrtout(06,message,'PERS')
   end do
  end do
 end if

 ! Carry out rotation of bands C(G,n) according to evecs:
 call status(inonsc,filstat,iexit,level,'call sdirot   ')
! call sdirot(cg,evec,icg,mcg,nband_k,nband_k,npw_k*nspinor)
 blksz=1
 allocate(work(2,nband_k))
 do ipw=1,npw_k
! Loop over bands:
  index2=ipw+icg
  ! calculate actual block size
  work(:,:)=0.0
  do n2=1,nband_k
   nim=2*n2
   nre=nim-1
   do nn=1,nband_k
    work(1,nn)=work(1,nn)+cg(1,index2)*evec(nre,nn)-cg(2,index2)*evec(nim,nn)
    work(2,nn)=work(2,nn)+cg(2,index2)*evec(nre,nn)+cg(1,index2)*evec(nim,nn)
   end do
   index2=index2+npw_k
   ! Define re and im of C(G,nn) at given G for each nn:
  end do
  ! Copy re and im of C(G,nn) into CG over all bands (single G):
  index1=ipw+icg
  do nn=1,nband_k
   cg(1,index1)=work(1,nn)
   cg(2,index1)=work(2,nn)
   index1=index1+npw_k
  end do
 end do
 deallocate(work)
 !!!!!!!! /sdirot

end subroutine subdiago_htor
