!---------------------------------!
!-----Atomic Position Symetry-----!
!---------------------------------!

subroutine atom_sym(nbtime,position,a,b,c,indexAtom1,Pos1,Pos2,Pos3,size1,size2,nba1)

  !input 
  integer :: size1,size2,nba1
  integer, intent(in) :: nbtime
  real(8), intent(in) :: a,b,c
  !f2py  optional  ,  depend(position)    ::  size1=len(position[:,1,1])
  !f2py  optional  ,  depend(position)    ::  size2=len(position[1,:,1])
  !f2py  optional  ,  depend(indexAtom1)  ::  nba1=len(indexAtom1)
  real, intent(in)  ::  position(size1,size2,3)
  integer, intent(in)  ::  indexAtom1(nba1)
  !output
  real(8),intent(out)  ::  Pos1(nbtime*nba1),Pos2(nbtime*nba1),Pos3(nbtime*nba1)
  !local variable
  real(8) :: x,y,z
  integer :: i,j,k

  k = 1

  do  i=1,nbtime
     do j=1,nba1
 
        x = position(i,indexAtom1(j),1)
        y = position(i,indexAtom1(j),2)
        z = position(i,indexAtom1(j),3)

        if (x >= 0) then  !replace atoms in a box [0:1]

           Pos1(k) = x - a*int(x/a)

        else

           Pos1(k) = x - a*int(x/a-1)

        endif

        if (y >= 0) then  !replace atoms in a box [0:1]

           Pos2(k) = y - b*int(y/b) 

        else

           Pos2(k) = y - b*int(y/b-1) 

        endif

        if (z >= 0) then  !replace atoms in a box [0:1]

           Pos3(k) = z - c*int(z/c)

        else

           Pos3(k) = z - c*int(z/c-1)

        endif

        k = k+1

     enddo
  enddo

end subroutine atom_sym


!---------------------------------!
!-----Atomic Position Average-----!
!---------------------------------!

subroutine atom_ave(nbtime,position,indexAtom1,Pos1,Pos2,Pos3,size1,size2,nba1)

  !input 
  integer :: size1,size2,nba1
  integer, intent(in) :: nbtime
  !f2py  optional  ,  depend(position)    ::  size1=len(position[:,1,1])
  !f2py  optional  ,  depend(position)    ::  size2=len(position[1,:,1])
  !f2py  optional  ,  depend(indexAtom1)  ::  nba1=len(indexAtom1)
  real, intent(in)  ::  position(size1,size2,3)
  integer, intent(in)  ::  indexAtom1(nba1)
  !output
  real(8),intent(out)  ::  Pos1(nba1),Pos2(nba1),Pos3(nba1)
  !local variable
  integer :: i,j

  do  i=1,nbtime
     do j=1,nba1

        x = position(i,indexAtom1(j),1)
        y = position(i,indexAtom1(j),2)
        z = position(i,indexAtom1(j),3)
 
        Pos1(j) = Pos1(j) + x/nbtime
        Pos2(j) = Pos2(j) + y/nbtime
        Pos3(j) = Pos3(j) + z/nbtime

     enddo
  enddo

end subroutine atom_ave
