/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.IExpressionEvaluator;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.util.Traverser;

public class ScriptEvaluator
extends ClassBodyEvaluator
implements IScriptEvaluator {
    public static final String DEFAULT_METHOD_NAME = "eval*";
    @Nullable
    protected boolean[] optionalOverrideMethod;
    @Nullable
    protected boolean[] optionalStaticMethod;
    @Nullable
    protected Class<?>[] optionalReturnTypes;
    @Nullable
    private String[] optionalMethodNames;
    @Nullable
    private String[][] optionalParameterNames;
    @Nullable
    private Class<?>[][] optionalParameterTypes;
    @Nullable
    private Class<?>[][] optionalThrownExceptions;
    @Nullable
    private Method[] result;

    public ScriptEvaluator(String script) throws CompileException {
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType) throws CompileException {
        this.setReturnType(returnType);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.cook(script);
    }

    public ScriptEvaluator(String script, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions) throws CompileException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.cook(script);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, InputStream is, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, is);
    }

    public ScriptEvaluator(@Nullable String optionalFileName, Reader reader, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(optionalFileName, reader);
    }

    public ScriptEvaluator(Scanner scanner, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, @Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, Class<?> returnType, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setReturnType(returnType);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator(Scanner scanner, String className, @Nullable Class<?> optionalExtendedType, Class<?>[] implementedTypes, boolean staticMethod, Class<?> returnType, String methodName, String[] parameterNames, Class<?>[] parameterTypes, Class<?>[] thrownExceptions, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        this.setClassName(className);
        this.setExtendedClass(optionalExtendedType);
        this.setImplementedInterfaces(implementedTypes);
        this.setStaticMethod(staticMethod);
        this.setReturnType(returnType);
        this.setMethodName(methodName);
        this.setParameters(parameterNames, parameterTypes);
        this.setThrownExceptions(thrownExceptions);
        this.setParentClassLoader(optionalParentClassLoader);
        this.cook(scanner);
    }

    public ScriptEvaluator() {
    }

    public void setOverrideMethod(boolean overrideMethod) {
        this.setOverrideMethod(new boolean[]{overrideMethod});
    }

    public void setStaticMethod(boolean staticMethod) {
        this.setStaticMethod(new boolean[]{staticMethod});
    }

    public void setReturnType(Class<?> returnType) {
        this.setReturnTypes(new Class[]{returnType});
    }

    public void setMethodName(String methodName) {
        this.setMethodNames(new String[]{methodName});
    }

    public void setParameters(String[] parameterNames, Class<?>[] parameterTypes) {
        this.setParameters(new String[][]{parameterNames}, new Class[][]{parameterTypes});
    }

    public void setThrownExceptions(Class<?>[] thrownExceptions) {
        this.setThrownExceptions(new Class[][]{thrownExceptions});
    }

    public void setOverrideMethod(boolean[] overrideMethod) {
        this.optionalOverrideMethod = (boolean[])overrideMethod.clone();
    }

    public void setStaticMethod(boolean[] staticMethod) {
        this.optionalStaticMethod = (boolean[])staticMethod.clone();
    }

    public void setReturnTypes(Class<?>[] returnTypes) {
        this.optionalReturnTypes = (Class[])returnTypes.clone();
    }

    public void setMethodNames(String[] methodNames) {
        this.optionalMethodNames = (String[])methodNames.clone();
    }

    public void setParameters(String[][] parameterNames, Class<?>[][] parameterTypes) {
        this.optionalParameterNames = (String[][])parameterNames.clone();
        this.optionalParameterTypes = (Class[][])parameterTypes.clone();
    }

    public void setThrownExceptions(Class<?>[][] thrownExceptions) {
        this.optionalThrownExceptions = (Class[][])thrownExceptions.clone();
    }

    public final void cook(String[] strings) throws CompileException {
        this.cook(null, strings);
    }

    public final void cook(@Nullable String[] optionalFileNames, String[] strings) throws CompileException {
        Reader[] readers = new Reader[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            readers[i] = new StringReader(strings[i]);
        }
        try {
            this.cook(optionalFileNames, readers);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException("SNO: IOException despite StringReader", ex);
        }
    }

    public final void cook(Reader[] readers) throws CompileException, IOException {
        this.cook(null, readers);
    }

    public final void cook(@Nullable String[] optionalFileNames, Reader[] readers) throws CompileException, IOException {
        Scanner[] scanners = new Scanner[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            scanners[i] = new Scanner(optionalFileNames == null ? null : optionalFileNames[i], readers[i]);
        }
        this.cook(scanners);
    }

    @Override
    public final void cook(Scanner scanner) throws CompileException, IOException {
        this.cook(new Scanner[]{scanner});
    }

    public final void cook(Scanner[] scanners) throws CompileException, IOException {
        Parser[] parsers = new Parser[scanners.length];
        for (int i = 0; i < scanners.length; ++i) {
            parsers[i] = new Parser(scanners[i]);
        }
        this.cook(parsers);
    }

    public final void cook(Parser[] parsers) throws CompileException, IOException {
        int count = parsers.length;
        String[] mns = ScriptEvaluator.array(this.optionalMethodNames, count, DEFAULT_METHOD_NAME);
        String[][] pns = ScriptEvaluator.array(this.optionalParameterNames, count, new String[0], String[].class);
        Class[][] pts = ScriptEvaluator.array(this.optionalParameterTypes, count, new Class[0], Class[].class);
        boolean[] oms = ScriptEvaluator.array(this.optionalOverrideMethod, count, false);
        Class[] rts = ScriptEvaluator.array(this.optionalReturnTypes, count, this.getDefaultReturnType(), Class.class);
        boolean[] sms = ScriptEvaluator.array(this.optionalStaticMethod, count, true);
        Class[][] tes = ScriptEvaluator.array(this.optionalThrownExceptions, count, new Class[0], Class[].class);
        Java.CompilationUnit compilationUnit = this.makeCompilationUnit(count == 1 ? parsers[0] : null);
        Java.PackageMemberClassDeclaration cd = this.addPackageMemberClassDeclaration(parsers[0].location(), compilationUnit);
        for (int i = 0; i < count; ++i) {
            Java.Annotation[] annotationArray;
            Parser parser = parsers[i];
            ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
            ArrayList<Java.MethodDeclarator> localMethods = new ArrayList<Java.MethodDeclarator>();
            this.makeStatements(i, parser, statements, localMethods);
            Location loc = parser.location();
            if (oms[i]) {
                Java.Annotation[] annotationArray2 = new Java.Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = new Java.MarkerAnnotation(this.classToType(loc, Override.class));
            } else {
                annotationArray = new Java.Annotation[]{};
            }
            cd.addDeclaredMethod(this.makeMethodDeclaration(loc, annotationArray, sms[i], rts[i], mns[i], pts[i], pns[i], tes[i], statements));
            for (Java.MethodDeclarator method : localMethods) {
                cd.addDeclaredMethod(method);
            }
        }
        this.cook2(count, compilationUnit);
    }

    protected void cook2(int count, Java.CompilationUnit compilationUnit) throws CompileException {
        Class<?> c = this.compileToClass(compilationUnit);
        String[] mns = ScriptEvaluator.array(this.optionalMethodNames, count, DEFAULT_METHOD_NAME);
        Class[][] pts = ScriptEvaluator.array(this.optionalParameterTypes, count, new Class[0], Class[].class);
        Method[] methods = new Method[count];
        if (count <= 10) {
            for (int i = 0; i < count; ++i) {
                String methodName = mns[i];
                Class[] parameterTypes = pts[i];
                try {
                    methods[i] = c.getDeclaredMethod(methodName, parameterTypes);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodName + "\"", ex);
                }
            }
        } else {
            Method[] ma = c.getDeclaredMethods();
            class MethodWrapper {
                private final String name;
                private final Class<?>[] parameterTypes;

                MethodWrapper(String name, Class<?>[] parameterTypes) {
                    this.name = name;
                    this.parameterTypes = parameterTypes;
                }

                public boolean equals(@Nullable Object o) {
                    if (!(o instanceof MethodWrapper)) {
                        return false;
                    }
                    MethodWrapper that = (MethodWrapper)o;
                    if (!this.name.equals(that.name)) {
                        return false;
                    }
                    int cnt = this.parameterTypes.length;
                    if (cnt != that.parameterTypes.length) {
                        return false;
                    }
                    for (int i = 0; i < cnt; ++i) {
                        if (this.parameterTypes[i].equals(that.parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int hc = this.name.hashCode();
                    for (Class<?> parameterType : this.parameterTypes) {
                        hc ^= parameterType.hashCode();
                    }
                    return hc;
                }
            }
            HashMap<MethodWrapper, Method> dms = new HashMap<MethodWrapper, Method>(2 * count);
            for (Method m : ma) {
                dms.put(new MethodWrapper(m.getName(), m.getParameterTypes()), m);
            }
            for (int i = 0; i < count; ++i) {
                Method m;
                String methodName = mns[i];
                Class[] parameterTypes = pts[i];
                m = (Method)dms.get(new MethodWrapper(methodName, parameterTypes));
                if (m == null) {
                    throw new JaninoRuntimeException("SNO: Loaded class does not declare method \"" + methodName + "\"");
                }
                methods[i] = m;
            }
        }
        this.result = methods;
    }

    private static boolean[] array(@Nullable boolean[] subject, int count, boolean defaultValue) {
        boolean[] result;
        if (subject == null) {
            result = new boolean[count];
            if (defaultValue) {
                for (int i = 0; i < count; ++i) {
                    result[i] = true;
                }
            }
        } else {
            if (subject.length != count) {
                throw new IllegalStateException();
            }
            result = subject;
        }
        return result;
    }

    private static String[] array(@Nullable String[] subject, int count, @Nullable String defaultValue) {
        String[] result;
        if (subject == null) {
            result = new String[count];
        } else {
            if (subject.length != count) {
                throw new IllegalStateException();
            }
            result = subject;
        }
        if (defaultValue != null) {
            for (int i = 0; i < count; ++i) {
                if (result[i] != null) continue;
                result[i] = defaultValue.replace("*", Integer.toString(i));
            }
        }
        return result;
    }

    private static <T> T[] array(@Nullable T[] subject, int count, @Nullable T defaultValue, Class<T> componentType) {
        Object[] result;
        if (subject == null) {
            result = (Object[])Array.newInstance(componentType, count);
        } else {
            if (subject.length != count) {
                throw new IllegalStateException();
            }
            result = (Object[])subject.clone();
        }
        if (defaultValue != null) {
            for (int i = 0; i < count; ++i) {
                if (result[i] != null) continue;
                result[i] = defaultValue;
            }
        }
        return result;
    }

    @Nullable
    public Object evaluate(@Nullable Object[] arguments) throws InvocationTargetException {
        return this.evaluate(0, arguments);
    }

    @Nullable
    public Object evaluate(int idx, @Nullable Object[] arguments) throws InvocationTargetException {
        Method method = this.getMethod(idx);
        try {
            return method.invoke(null, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new JaninoRuntimeException(ex.toString(), ex);
        }
    }

    public Method getMethod() {
        return this.getMethod(0);
    }

    public Method getMethod(int idx) {
        return this.assertCooked()[idx];
    }

    protected Class<?> getDefaultReturnType() {
        return Void.TYPE;
    }

    protected final Class<?> getReturnType(int i) {
        if (this.optionalReturnTypes != null) {
            Class<?> rt = this.optionalReturnTypes[i];
            assert (rt != null);
            return rt;
        }
        return this.getDefaultReturnType();
    }

    protected void makeStatements(int idx, Parser parser, List<Java.BlockStatement> resultStatements, List<Java.MethodDeclarator> resultMethods) throws CompileException, IOException {
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            ScriptEvaluator.parseScriptStatement(parser, resultStatements, resultMethods);
        }
    }

    private static void parseScriptStatement(Parser parser, List<Java.BlockStatement> mainStatements, List<Java.MethodDeclarator> localMethods) throws CompileException, IOException {
        if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne(":") || parser.peek("if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue", "assert", "{", ";") != -1) {
            mainStatements.add(parser.parseStatement());
            return;
        }
        if (parser.peekRead("class")) {
            Java.LocalClassDeclaration lcd = (Java.LocalClassDeclaration)parser.parseClassDeclarationRest(null, new Java.Modifiers(), Parser.ClassDeclarationContext.BLOCK);
            mainStatements.add(new Java.LocalClassDeclarationStatement(lcd));
            return;
        }
        Java.Modifiers modifiers = parser.parseModifiers();
        if (parser.peekRead("void")) {
            String name = parser.read(TokenType.IDENTIFIER);
            localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, new Java.PrimitiveType(parser.location(), Java.Primitive.VOID), name));
            return;
        }
        if (!modifiers.isBlank()) {
            Java.Type methodOrVariableType = parser.parseType();
            if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne("(")) {
                localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, methodOrVariableType, parser.read(TokenType.IDENTIFIER)));
                return;
            }
            mainStatements.add(new Java.LocalVariableDeclarationStatement(parser.location(), modifiers, methodOrVariableType, parser.parseVariableDeclarators()));
            parser.read(";");
            return;
        }
        Java.Atom a = parser.parseExpression();
        if (parser.peekRead(";")) {
            mainStatements.add(new Java.ExpressionStatement(a.toRvalueOrCompileException()));
            return;
        }
        Java.Type methodOrVariableType = a.toTypeOrCompileException();
        if (parser.peek(TokenType.IDENTIFIER) && parser.peekNextButOne("(")) {
            localMethods.add(parser.parseMethodDeclarationRest(null, modifiers, null, methodOrVariableType, parser.read(TokenType.IDENTIFIER)));
            return;
        }
        mainStatements.add(new Java.LocalVariableDeclarationStatement(a.getLocation(), modifiers, methodOrVariableType, parser.parseVariableDeclarators()));
        parser.read(";");
    }

    protected Java.MethodDeclarator makeMethodDeclaration(Location location, Java.Annotation[] annotations, boolean staticMethod, Class<?> returnType, String methodName, Class<?>[] parameterTypes, String[] parameterNames, Class<?>[] thrownExceptions, List<Java.BlockStatement> statements) {
        if (parameterNames.length != parameterTypes.length) {
            throw new JaninoRuntimeException("Lengths of \"parameterNames\" (" + parameterNames.length + ") and \"parameterTypes\" (" + parameterTypes.length + ") do not match");
        }
        Java.FunctionDeclarator.FormalParameters fps = new Java.FunctionDeclarator.FormalParameters(location, new Java.FunctionDeclarator.FormalParameter[parameterNames.length], false);
        for (int i = 0; i < fps.parameters.length; ++i) {
            fps.parameters[i] = new Java.FunctionDeclarator.FormalParameter(location, true, this.classToType(location, parameterTypes[i]), parameterNames[i]);
        }
        return new Java.MethodDeclarator(location, null, new Java.Modifiers(staticMethod ? (short)9 : 1, annotations), null, this.classToType(location, returnType), methodName, fps, this.classesToTypes(location, thrownExceptions), statements);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(String script, Class<?> interfaceToImplement, String[] parameterNames) throws CompileException {
        ScriptEvaluator se = new ScriptEvaluator();
        return se.createFastEvaluator(script, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, String className, @Nullable Class<?> optionalExtendedType, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedType);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Deprecated
    public static Object createFastScriptEvaluator(Scanner scanner, @Nullable String[] optionalDefaultImports, String className, @Nullable Class<?> optionalExtendedClass, Class<?> interfaceToImplement, String[] parameterNames, @Nullable ClassLoader optionalParentClassLoader) throws CompileException, IOException {
        ScriptEvaluator se = new ScriptEvaluator();
        se.setDefaultImports(optionalDefaultImports);
        se.setClassName(className);
        se.setExtendedClass(optionalExtendedClass);
        se.setParentClassLoader(optionalParentClassLoader);
        return se.createFastEvaluator(scanner, interfaceToImplement, parameterNames);
    }

    @Override
    public final Object createInstance(Reader reader) {
        throw new UnsupportedOperationException("createInstance");
    }

    public <T> Object createFastEvaluator(Reader reader, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        return this.createFastEvaluator(new Scanner(null, reader), interfaceToImplement, parameterNames);
    }

    public <T> Object createFastEvaluator(String script, Class<T> interfaceToImplement, String[] parameterNames) throws CompileException {
        try {
            return this.createFastEvaluator(new StringReader(script), interfaceToImplement, parameterNames);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException("IOException despite StringReader", ex);
        }
    }

    public Object createFastEvaluator(Scanner scanner, Class<?> interfaceToImplement, String[] parameterNames) throws CompileException, IOException {
        if (!interfaceToImplement.isInterface()) {
            throw new JaninoRuntimeException("\"" + interfaceToImplement + "\" is not an interface");
        }
        Method[] methods = interfaceToImplement.getDeclaredMethods();
        if (methods.length != 1) {
            throw new JaninoRuntimeException("Interface \"" + interfaceToImplement + "\" must declare exactly one method");
        }
        Method methodToImplement = methods[0];
        this.setImplementedInterfaces(new Class[]{interfaceToImplement});
        this.setOverrideMethod(true);
        this.setStaticMethod(false);
        if (this instanceof IExpressionEvaluator) {
            ((IExpressionEvaluator)this).setExpressionType(methodToImplement.getReturnType());
        } else {
            this.setReturnType(methodToImplement.getReturnType());
        }
        this.setMethodName(methodToImplement.getName());
        this.setParameters(parameterNames, methodToImplement.getParameterTypes());
        this.setThrownExceptions(methodToImplement.getExceptionTypes());
        this.cook(scanner);
        Class<?> c = this.getMethod().getDeclaringClass();
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new JaninoRuntimeException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new JaninoRuntimeException(e.toString(), e);
        }
    }

    public static String[] guessParameterNames(Scanner scanner) throws CompileException, IOException {
        Parser parser = new Parser(scanner);
        while (parser.peek("import")) {
            parser.parseImportDeclaration();
        }
        Java.Block block = new Java.Block(scanner.location());
        while (!parser.peek(TokenType.END_OF_INPUT)) {
            block.addStatement(parser.parseBlockStatement());
        }
        final HashSet localVariableNames = new HashSet();
        final HashSet parameterNames = new HashSet();
        new Traverser<RuntimeException>(){

            @Override
            public void traverseLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement lvds) {
                for (Java.VariableDeclarator vd : lvds.variableDeclarators) {
                    localVariableNames.add(vd.name);
                }
                super.traverseLocalVariableDeclarationStatement(lvds);
            }

            @Override
            public void traverseAmbiguousName(Java.AmbiguousName an) {
                for (int i = 0; i < an.identifiers.length; ++i) {
                    if (!Character.isUpperCase(an.identifiers[i].charAt(0))) continue;
                    return;
                }
                if (localVariableNames.contains(an.identifiers[0])) {
                    return;
                }
                parameterNames.add(an.identifiers[0]);
            }
        }.visitBlockStatement(block);
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    private Method[] assertCooked() {
        if (this.result != null) {
            return this.result;
        }
        throw new IllegalStateException("Must only be called after \"cook()\"");
    }
}

