/*
 *  playlist.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <gst/gst.h>
#include "ap_config.h"
#include "functions.h"
#include "stream.h"

gboolean        playlist_add              (const gchar* path);
Stream*         playlist_next             ();
Stream*         playlist_previous         ();
Stream*         playlist_first            ();
Stream*         playlist_last             ();
void            playlist_shuffle          ();
void            playlist_free             ();
gboolean        playlist_add_from_file    (const gchar* path);

#endif /* PLAYLIST_H */

