/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.png.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class PNGTranscoderInternalCodecWriteAdapter
implements PNGTranscoder.WriteAdapter {
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        float f;
        PNGEncodeParam pNGEncodeParam;
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey((Object)PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get((Object)PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage(bufferedImage, 1 << n);
        }
        if ((pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam(bufferedImage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pNGEncodeParam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (transcodingHints.containsKey((Object)PNGTranscoder.KEY_GAMMA)) {
            f = ((Float)transcodingHints.get((Object)PNGTranscoder.KEY_GAMMA)).floatValue();
            if (f > 0.0f) {
                pNGEncodeParam.setGamma(f);
            }
            pNGEncodeParam.setChromaticity(PNGTranscoder.DEFAULT_CHROMA);
        } else {
            pNGEncodeParam.setSRGBIntent(0);
        }
        f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n2 = (int)((double)(1000.0f / f) + 0.5);
        pNGEncodeParam.setPhysicalDimension(n2, n2, 1);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, pNGEncodeParam);
            pNGImageEncoder.encode(bufferedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }
}

