;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 ;; CHECK-TEXT:      (type $i32_=>_v128 (func (param i32) (result v128)))
 ;; CHECK-BIN:      (type $i32_=>_v128 (func (param i32) (result v128)))
 (type $i32_=>_v128 (func (param i32) (result v128)))
 ;; CHECK-TEXT:      (type $i32_v128_=>_none (func (param i32 v128)))
 ;; CHECK-BIN:      (type $i32_v128_=>_none (func (param i32 v128)))
 (type $i32_v128_=>_none (func (param i32 v128)))
 ;; CHECK-TEXT:      (type $i32_v128_=>_v128 (func (param i32 v128) (result v128)))
 ;; CHECK-BIN:      (type $i32_v128_=>_v128 (func (param i32 v128) (result v128)))
 (type $i32_v128_=>_v128 (func (param i32 v128) (result v128)))
 ;; CHECK-TEXT:      (memory $memorya 1 1)
 ;; CHECK-BIN:      (memory $memorya 1 1)
 (memory $memorya 1 1)
 ;; CHECK-TEXT:      (memory $memoryb 1 1)
 ;; CHECK-BIN:      (memory $memoryb 1 1)
 (memory $memoryb 1 1)
 ;; CHECK-TEXT:      (memory $memoryc 1 1)
 ;; CHECK-BIN:      (memory $memoryc 1 1)
 (memory $memoryc 1 1)
 ;; CHECK-TEXT:      (memory $memoryd 1 1)
 ;; CHECK-BIN:      (memory $memoryd 1 1)
 (memory $memoryd 1 1)

 ;; CHECK-TEXT:      (func $v128.load (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load (param $0 i32) (result v128)
  (v128.load $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load2 (param $0 i32) (result v128)
  (v128.load $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_s $memoryc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_s $memoryc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_s (param $0 i32) (result v128)
  (v128.load8x8_s $memoryc
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_s $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_s $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_s2 (param $0 i32) (result v128)
  (v128.load8x8_s $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_u $memoryd
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_u $memoryd
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_u (param $0 i32) (result v128)
  (v128.load8x8_u $memoryd
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8x8_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8x8_u $memoryd
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8x8_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8x8_u $memoryd
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8x8_u2 (param $0 i32) (result v128)
  (v128.load8x8_u $memoryd
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_s $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_s $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_s (param $0 i32) (result v128)
  (v128.load16x4_s $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_s $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_s $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_s2 (param $0 i32) (result v128)
  (v128.load16x4_s $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_u $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_u $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_u (param $0 i32) (result v128)
  (v128.load16x4_u $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16x4_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16x4_u $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16x4_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16x4_u $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16x4_u2 (param $0 i32) (result v128)
  (v128.load16x4_u $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_s $memoryc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_s (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_s $memoryc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_s (param $0 i32) (result v128)
  (v128.load32x2_s $memoryc
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_s $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_s2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_s $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_s2 (param $0 i32) (result v128)
  (v128.load32x2_s $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_u $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_u (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_u $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_u (param $0 i32) (result v128)
  (v128.load32x2_u $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32x2_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32x2_u $memoryc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32x2_u2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32x2_u $memoryc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32x2_u2 (param $0 i32) (result v128)
  (v128.load32x2_u $memoryc
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_splat $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_splat $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_splat (param $0 i32) (result v128)
  (v128.load8_splat $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_splat $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_splat $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_splat2 (param $0 i32) (result v128)
  (v128.load8_splat $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_splat $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_splat $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_splat (param $0 i32) (result v128)
  (v128.load16_splat $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_splat $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_splat $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_splat2 (param $0 i32) (result v128)
  (v128.load16_splat $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_splat $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_splat $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_splat (param $0 i32) (result v128)
  (v128.load32_splat $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_splat $memoryd
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_splat $memoryd
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_splat2 (param $0 i32) (result v128)
  (v128.load32_splat $memoryd
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_splat $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_splat (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_splat $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_splat (param $0 i32) (result v128)
  (v128.load64_splat $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_splat $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_splat2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_splat $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_splat2 (param $0 i32) (result v128)
  (v128.load64_splat $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store (param $0 i32) (param $1 v128)
  (v128.store $memorya
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store2 (param $0 i32) (param $1 v128)
  (v128.store $memoryb
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_lane $memorya 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_lane $memorya 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load8_lane $memorya 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load8_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load8_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load8_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load8_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load8_lane2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load8_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load16_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load16_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load16_lane $memoryd 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load16_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load16_lane $memoryd 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load16_lane2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load16_lane $memoryd 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_lane $memorya 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_lane $memorya 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load32_lane $memorya 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_lane2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load32_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryd 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryd 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryd 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memorya align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memorya align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memorya align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryb align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryb align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryb align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_offset (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryc offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_offset (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryc offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_offset (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryc offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_offset2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryb offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_offset2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryb offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_offset2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryb offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align_offset (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memorya offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align_offset (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memorya offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align_offset (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memorya offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_lane_align_offset2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_lane $memoryd offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_lane_align_offset2 (type $i32_v128_=>_v128) (param $0 i32) (param $1 v128) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_lane $memoryd offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_lane_align_offset2 (param $0 i32) (param $1 v128) (result v128)
  (v128.load64_lane $memoryd offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store8_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store8_lane $memorya 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store8_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store8_lane $memorya 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store8_lane (param $0 i32) (param $1 v128)
  (v128.store8_lane $memorya 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store8_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store8_lane $memoryd 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store8_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store8_lane $memoryd 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store8_lane2 (param $0 i32) (param $1 v128)
  (v128.store8_lane $memoryd 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store16_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store16_lane $memorya 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store16_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store16_lane $memorya 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store16_lane (param $0 i32) (param $1 v128)
  (v128.store16_lane $memorya 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store16_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store16_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store16_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store16_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store16_lane2 (param $0 i32) (param $1 v128)
  (v128.store16_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store32_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store32_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store32_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store32_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store32_lane (param $0 i32) (param $1 v128)
  (v128.store32_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store32_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store32_lane $memoryc 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store32_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store32_lane $memoryc 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store32_lane2 (param $0 i32) (param $1 v128)
  (v128.store32_lane $memoryc 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryc 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryc 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryc 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryb 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryb 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane2 (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryb 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryb align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryb align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryb align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memorya align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memorya align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align2 (param $0 i32) (param $1 v128)
  (v128.store64_lane $memorya align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_offset (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryd offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_offset (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryd offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_offset (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryd offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_offset2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memorya offset=32 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_offset2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memorya offset=32 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_offset2 (param $0 i32) (param $1 v128)
  (v128.store64_lane $memorya offset=32 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align_offset (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryb offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align_offset (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryb offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align_offset (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryb offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.store64_lane_align_offset2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-TEXT-NEXT:  (v128.store64_lane $memoryd offset=32 align=1 0
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.store64_lane_align_offset2 (type $i32_v128_=>_none) (param $0 i32) (param $1 v128)
 ;; CHECK-BIN-NEXT:  (v128.store64_lane $memoryd offset=32 align=1 0
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.store64_lane_align_offset2 (param $0 i32) (param $1 v128)
  (v128.store64_lane $memoryd offset=32 align=1 0
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_zero (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_zero $memorya
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_zero (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_zero $memorya
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_zero (param $0 i32) (result v128)
  (v128.load32_zero $memorya
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load32_zero2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load32_zero $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load32_zero2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load32_zero $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load32_zero2 (param $0 i32) (result v128)
  (v128.load32_zero $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_zero (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_zero $memoryb
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_zero (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_zero $memoryb
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_zero (param $0 i32) (result v128)
  (v128.load64_zero $memoryb
   (local.get $0)
  )
 )

 ;; CHECK-TEXT:      (func $v128.load64_zero2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-TEXT-NEXT:  (v128.load64_zero $memoryc
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $v128.load64_zero2 (type $i32_=>_v128) (param $0 i32) (result v128)
 ;; CHECK-BIN-NEXT:  (v128.load64_zero $memoryc
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $v128.load64_zero2 (param $0 i32) (result v128)
  (v128.load64_zero $memoryc
   (local.get $0)
  )
 )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func (param i32) (result v128)))

;; CHECK-BIN-NODEBUG:      (type $1 (func (param i32 v128)))

;; CHECK-BIN-NODEBUG:      (type $2 (func (param i32 v128) (result v128)))

;; CHECK-BIN-NODEBUG:      (memory $0 1 1)

;; CHECK-BIN-NODEBUG:      (memory $1 1 1)

;; CHECK-BIN-NODEBUG:      (memory $2 1 1)

;; CHECK-BIN-NODEBUG:      (memory $3 1 1)

;; CHECK-BIN-NODEBUG:      (func $0 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_s $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_s $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_u $3
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8x8_u $3
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_s $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_s $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_u $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16x4_u $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_s $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_s $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_u $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32x2_u $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_splat $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_splat $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_splat $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_splat $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_splat $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_splat $3
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_splat $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_splat $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $24 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_lane $0 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $25 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load8_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $26 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $27 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load16_lane $3 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $28 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_lane $0 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $29 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $30 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $3 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $31 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $32 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $0 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $33 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $1 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $34 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $2 offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $35 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $1 offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $36 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $0 offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $37 (type $2) (param $0 i32) (param $1 v128) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_lane $3 offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $38 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store8_lane $0 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $39 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store8_lane $3 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $40 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store16_lane $0 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $41 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store16_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $42 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store32_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $43 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store32_lane $2 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $44 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $2 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $45 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $46 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $1 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $47 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $0 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $48 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $3 offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $49 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $0 offset=32 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $50 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $1 offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $51 (type $1) (param $0 i32) (param $1 v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.store64_lane $3 offset=32 align=1 0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $52 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_zero $0
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $53 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load32_zero $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $54 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_zero $1
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $55 (type $0) (param $0 i32) (result v128)
;; CHECK-BIN-NODEBUG-NEXT:  (v128.load64_zero $2
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )
