/*-
 * Copyright (c) 2004 Free (Olivier Beyssac)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "options.h"
#include "utils.h"
#include "parse_args.h"


extern struct options opt;

/* Search if we have a particular config file to use */
extern void parse_args_for_config_file(int argc, char **argv)
{
  int i;

  for (i = 1; i < argc - 1; i++)
    if (!strcmp(argv[i], "-f")) {
      opt.config_file = argv[i+1];
      return;
    }
}


/* Parse arguments and fill global options */
/* Return:
   - -1 if error and must exit with code 1,
   - 0 if success and must exit with usage printing and code 0,
   - 1 if success and must continue.

   Exits with -v option */
/* FIXME: use getopt(3)? */
extern int parse_args(int argc, char **argv)
{
  int i;

  for (i = 1; i < argc; i++)
    if (!strcmp(argv[i], "-n"))
      opt.daemon = 0;
    else if (i < argc - 1 && !strcmp(argv[i], "-a")) {
      printf("Warning, -a option might be insecure, depending on your environment!\n");
      printf("Use at your own risk!  Please see the README file or bld(8).\n");
      opt.listening_ip = argv[++i];
    } else if (i < argc - 1 && !strcmp(argv[i], "-p"))
      opt.port = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-I"))
      opt.wl_filename = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-B"))
      opt.bl_filename = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-P"))
      opt.pid_filename = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-A"))
      opt.acl_filename = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-W"))
      opt.whitelist_filename = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-u"))
      opt.uid = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-g"))
      opt.gid = argv[++i];
    else if (i < argc - 1 && !strcmp(argv[i], "-l")) {
      if ((opt.log_level = xstrtol(argv[++i])) < 0) {
	fprintf(stderr, "%s: Invalid log level: %s\n", opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-t")) {
      opt.interval = xstrtol(argv[++i]);
      if (!options_check(INTERVAL_CHK, opt.interval)) {
	fprintf(stderr, "%s: Invalid interval: %s\n", opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-m")) {
      opt.max_req = xstrtol(argv[++i]);
      if (!options_check(MAX_REQ_CHK, opt.max_req)) {
	fprintf(stderr, "%s: Invalid value for max requests: %s\n",
                opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-i")) {
      opt.list_size = xstrtol(argv[++i]);
      if (!options_check(LIST_SIZE_CHK, opt.list_size)) {
	fprintf(stderr, "%s: Invalid IP list size: %s\n",
                opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-b")) {
      opt.blacklist_size = xstrtol(argv[++i]);
      if (!options_check(BLACKLIST_SIZE_CHK, opt.blacklist_size)) {
	fprintf(stderr, "%s: Invalid blacklist size: %s\n",
                opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-e")) {
      opt.blacklist_expiration = xstrtol(argv[++i]);
      if (!options_check(BLACKLIST_EXPIRATION_CHK,
			 opt.blacklist_expiration)) {
	fprintf(stderr, "%s: Invalid blacklist expiration: %s\n",
                opt.progname, argv[i]);
	return -1;
      }
    } else if (i < argc - 1 && !strcmp(argv[i], "-T")) {
      opt.client_timeout = xstrtol(argv[++i]);
      if (!options_check(CLIENT_TIMEOUT_CHK, opt.client_timeout)) {
	fprintf(stderr, "%s: Invalid client timeout: %s\n",
                opt.progname, argv[i]);
	return -1;
      }
    } else if (!strcmp(argv[i], "-h")) {
      return 0;
    } else if (!strcmp(argv[i], "-v")){
      printf("%s %s\n", PROGNAME, PROGRAM_VERSION);
      exit(EXIT_SUCCESS);
    } else if (!strcmp(argv[i], "-f")) {
      i++;
    } else {
      fprintf(stderr, "%s: Invalid option: %s\n", opt.progname, argv[i]);
      return -1;
    }

  return 1;
}
