When you have fixed a bug, simply create a [pull request](https://github.com/raphw/byte-buddy/pulls) on GitHub. We will look into the matter as quickly as possible, once we receive the notification. Make however sure that you have accurately described your changes and the fixed issue and please provide a test case that reproduces the problem and proves that your fix is working. This makes our work much easier and we will be able to apply your patch much quicker. If you add new methods, fields or types, make sure to write some in-code documentation that describes their purpose. If you apply performance-relevant changes, please self-critically reflect those changes using the `byte-buddy-benchmark` suite. Finally, please note that new releases of Byte Buddy are normally developed in their own branch.

If you are contributing a feature, please [get in touch](https://groups.google.com/forum/#!forum/byte-buddy) before spending a lot of time with it such that we can discuss how your changes are meaningful at Byte Buddy's current development state. Byte Buddy is meant to steadily provide more functionality but we do not grow its feature set on the expense of its stability and code consistency. However, do not be discouraged by this announcement. If you got deep enough into Byte Buddy's source to being able to implement a new awesome feature that you want to share, you did for sure give it some thought and we will do our best to merge it into our build! Simply come talk to us and we are more than happy to welcome you on board.

If you feel like contributing to Byte Buddy's documentation, to its description on this web page or even to the structure and design of this web page, you are absolutely welcome to do so! We deeply believe that a thorough and up-to-date documentation is the key to a successful project and we will do our best to live up to this conviction. Even minor changes are welcome as long as they improve Byte Buddy's accessibility or appearance, because in the end, this project was made for its users. Simply clone this web page which is hosted on GitHub in the project's [`gh-pages`](https://github.com/raphw/byte-buddy/tree/gh-pages) branch. The web page was created using [angular.js](https://angularjs.org/) and [Twitter's Bootstrap](http://getbootstrap.com/). 
