FIND_PATH(FATRAT_INCLUDE_DIR NAMES fatrat/fatrat.h)
MARK_AS_ADVANCED(FATRAT_INCLUDE_DIR)


IF(FATRAT_INCLUDE_DIR)
  SET(FATRAT_FOUND 1)
  SET(FATRAT_INCLUDE_DIRS ${FATRAT_INCLUDE_DIR} ${FATRAT_INCLUDE_DIR}/fatrat)
ELSE(FATRAT_INCLUDE_DIR)
  SET(FATRAT_FOUND 0)
  SET(FATRAT_INCLUDE_DIRS)
ENDIF(FATRAT_INCLUDE_DIR)

# Report the results.
IF(NOT FATRAT_FOUND)
  SET(FATRAT_DIR_MESSAGE
      "FATRAT was not found. Make sure FATRAT_INCLUDE_DIR are set.")
  IF(NOT FATRAT_FIND_QUIETLY)
    MESSAGE(STATUS "${FATRAT_DIR_MESSAGE}")
  ELSE(NOT FATRAT_FIND_QUIETLY)
    IF(FATRAT_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "${FATRAT_DIR_MESSAGE}")
    ENDIF(FATRAT_FIND_REQUIRED)
  ENDIF(NOT FATRAT_FIND_QUIETLY)
ENDIF(NOT FATRAT_FOUND)


