/*
 * Decompiled with CFR 0.152.
 */
package visad.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.matrix.JamaMatrix;

public class JamaLUDecomposition
extends Tuple {
    private static final RealType LUL_row = RealType.getRealType("LU_L_row");
    private static final RealType LUL_column = RealType.getRealType("LU_L_column");
    private static final RealType LUL_value = RealType.getRealType("LU_L_value");
    private static final FunctionType LULType = JamaLUDecomposition.constructLFunction();
    private static final RealType LUU_row = RealType.getRealType("LU_U_row");
    private static final RealType LUU_column = RealType.getRealType("LU_U_column");
    private static final RealType LUU_value = RealType.getRealType("LU_U_value");
    private static final FunctionType LUUType = JamaLUDecomposition.constructUFunction();
    private static final RealType pivot_domain = RealType.getRealType("pivot_domain");
    private static final RealType pivot_value = RealType.getRealType("pivot_value");
    private static final FunctionType pivotType = JamaLUDecomposition.constructPFunction();
    private static final Class[] classes = JamaLUDecomposition.constructClasses();
    private static final Class classMatrix = classes[0];
    private static final Class classCholeskyDecomposition = classes[1];
    private static final Class classEigenvalueDecomposition = classes[2];
    private static final Class classLUDecomposition = classes[3];
    private static final Class classQRDecomposition = classes[4];
    private static final Class classSingularValueDecomposition = classes[5];
    private Object lud = ((JamaMatrix)this.getComponent(0)).getStash();
    private static final Method[] methods = JamaLUDecomposition.constructMethods();
    private static final Method getL = methods[0];
    private static final Method getU = methods[1];
    private static final Method getPivot = methods[2];
    private static final Method getDoublePivot = methods[3];
    private static final Method det = methods[4];
    private static final Method isNonsingular = methods[5];
    private static final Method solve = methods[6];
    private static final Constructor matrixLUDecomposition = JamaLUDecomposition.constructConstructor();

    private static FunctionType constructLFunction() {
        try {
            RealTupleType tuple = new RealTupleType(LUL_row, LUL_column);
            FunctionType function = new FunctionType(tuple, LUL_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructUFunction() {
        try {
            RealTupleType tuple = new RealTupleType(LUU_row, LUU_column);
            FunctionType function = new FunctionType(tuple, LUU_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static FunctionType constructPFunction() {
        try {
            FunctionType function = new FunctionType(pivot_domain, pivot_value);
            return function;
        }
        catch (VisADException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Class[] constructClasses() {
        Class[] cs = new Class[6];
        try {
            cs[0] = Class.forName("Jama.Matrix");
            cs[1] = Class.forName("Jama.CholeskyDecomposition");
            cs[2] = Class.forName("Jama.EigenvalueDecomposition");
            cs[3] = Class.forName("Jama.LUDecomposition");
            cs[4] = Class.forName("Jama.QRDecomposition");
            cs[5] = Class.forName("Jama.SingularValueDecomposition");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return cs;
    }

    private static Method[] constructMethods() {
        Method[] ms = new Method[7];
        try {
            Class[] param = new Class[]{};
            ms[0] = classLUDecomposition.getMethod("getL", param);
            ms[1] = classLUDecomposition.getMethod("getU", param);
            ms[2] = classLUDecomposition.getMethod("getPivot", param);
            ms[3] = classLUDecomposition.getMethod("getDoublePivot", param);
            ms[4] = classLUDecomposition.getMethod("det", param);
            ms[5] = classLUDecomposition.getMethod("isNonsingular", param);
            param = new Class[]{classMatrix};
            ms[6] = classLUDecomposition.getMethod("solve", param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return ms;
    }

    private static Constructor constructConstructor() {
        try {
            Class[] param = new Class[]{classMatrix};
            return classLUDecomposition.getConstructor(param);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JamaLUDecomposition(JamaMatrix matrix) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        this(matrixLUDecomposition.newInstance(matrix.getMatrix()), false);
    }

    JamaLUDecomposition(Object lu, boolean copy) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        super(JamaLUDecomposition.makeDatums(lu), copy);
    }

    private static Data[] makeDatums(Object lu) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Object l = getL.invoke(lu, new Object[0]);
        JamaMatrix jl = new JamaMatrix(l, LULType, null, null, null, null, null);
        jl.setStash(lu);
        Object u = getU.invoke(lu, new Object[0]);
        JamaMatrix ju = new JamaMatrix(u, LUUType, null, null, null, null, null);
        double[] pivot = (double[])getDoublePivot.invoke(lu, new Object[0]);
        FlatField pf = new FlatField(pivotType, new Integer1DSet(pivot.length));
        pf.setSamples(new double[][]{pivot});
        return new Data[]{jl, ju, pf};
    }

    public Object getLUDecomposition() {
        return this.lud;
    }

    public JamaMatrix getL() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(0);
    }

    public JamaMatrix getU() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        return (JamaMatrix)this.getComponent(1);
    }

    public double det() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        double val = (Double)det.invoke(this.lud, new Object[0]);
        return val;
    }

    public double[] getDoublePivot() throws VisADException, RemoteException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        FlatField pf = (FlatField)this.getComponent(2);
        double[][] p = pf.getValues(false);
        return p[0];
    }

    public int[] getPivot() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        int[] p = (int[])getPivot.invoke(this.lud, new Object[0]);
        return p;
    }

    public boolean isNonsingular() throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        boolean ns = (Boolean)isNonsingular.invoke(this.lud, new Object[0]);
        return ns;
    }

    public JamaMatrix solve(JamaMatrix B) throws VisADException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (classLUDecomposition == null) {
            throw new VisADException("you need to install Jama from http://math.nist.gov/javanumerics/jama/");
        }
        Object m = solve.invoke(this.lud, B.getMatrix());
        return new JamaMatrix(m);
    }
}

