/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 * 		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __RAW_WAVE_H

#ifndef __SAMPLE_H
  #include "sample.h"
#endif

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif




typedef struct raw_wave{
  sample *(*get_buffer)(struct raw_wave *);
  void (*next_buffer)(struct raw_wave *);
  sample_producer **(*get_children)(struct raw_wave *);
  char **(*get_header)(struct raw_wave *);
  char **(*get_code)(struct raw_wave *);
  char **(*get_footer)(struct raw_wave *);
  void (* schedule)(sample_producer *sp, event *e, int offset);
  void (* trigger) (sample_producer *this);
  event **events;

  char* filename;
  sample *table;
  sample *buffer;
  double current_index;
  int length;
  int next;
  double pitch;
}raw_wave;


raw_wave *raw_wave_new(char *filename);
sample *raw_wave_get_buffer(raw_wave *this);
void raw_wave_set_pitch(raw_wave *this, double p);
void raw_wave_next_buffer(raw_wave *this);
void raw_wave_trigger(raw_wave *this);
void raw_wave_set_sample_file(raw_wave* this, char *filename);

event *event_pitch_change_new(int seq_handle, double pitch);

// #define FB_SAMPLES "/usr/local/lib/freebirth"
#define FB_SAMPLES "."

/*
  Local Variables:
  mode: font-lock
  End:
*/
