#                                                         -*- Perl -*-
# Copyright (c) 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ʸΥ˥塼뤿Υ饹
#
package FreePWING::FPWUtils::Menu;

require 5.005;
use English;
use FreePWING::Text;
use FreePWING::FPWUtils::FPWUtils;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(FreePWING::Text);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    return $type->SUPER::new();
}

#
# :
#	open()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤθФե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    
    if (!$self->SUPER::open($menu_file_name, $menu_ref_file_name,
			    $menu_tag_file_name)) {
	return 1;
    }

    #
    # եɤ߹ࡣ
    #
    if (-f $half_char_name_file_name
	&& !$self->set_half_user_characters_in_file($half_char_name_file_name)) {
        return 0;
    }
    if (-f $full_char_name_file_name
        && !$self->set_full_user_characters_in_file($full_char_name_file_name)) {
        return 0;
    }

    #
    # եɤ߹ࡣ(satomii)
    #
    if (-f $sound_fmt_file_name
	&& !$self->set_sounds_in_file($sound_fmt_file_name)) {
	return 0;
    }

    return 1;
}

1;
