/*		
*		GRAMophone II, a grammar based algorithmic musical composition tool
*		--------------------------------------------------------------------
*		
*		errors.c
*
*		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
*
* 		GRAMophone II is free software; you can redistribute it and/or modify
* 		it under the terms of the GNU General Public License as published by
* 		the Free Software Foundation; either version 2 of the License, or
* 		(at your option) any later version.
*
* 		This program is distributed in the hope that it will be useful,
* 		but WITHOUT ANY WARRANTY; without even the implied warranty of
* 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* 		GNU Library General Public License for more details.
*
*		You should have received a copy of the GNU General Public License along
*		with this program; if not, write to the Free Software Foundation, Inc.,
*		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*		--------------------------------------------------------------------
*/

#include "global.h"

extern int row;

void sntx_err(unsigned int error, char *msg) {
  static char *e[]={
    "unterminated string costant.",
    "end of file reached!",
    "discographies nested too deeply!",
    "discography not found!",
    "expected.",
    "memory allocation error!",
    "already defined.",
    "which grammar do you want to use?",
    "'resolution' value out of range 24..960",
    "a composition must have at least 1 iteration.",
    "out of range 0..127",
    "fraction's numerator out of range 1..64",
    "fraction's denominator can be: 1, 2, 4, 8, 16, 32 or 64.",
    "'octave' value out of range -2..8",
    "'tempo' value out of range 1..300",
    "...and the player(s)?",
    "variable not declared.",
    "too long.",
    "'channel' value out of range 0..15",
    "too many players!",
    "too many variables!",
    "incompatible type in expression.",
    "too many macros!",
    "too many note parameters!",
	"or not allowed in repeat arguments with chomsky grammar.",
	"silent note not allowed in the head of production.",
    "too many strings!",
	"...and the first condition?"
  };
  fprintf(stderr, "Error!\n");
  fprintf(stderr, "GRAMophone row %d: %s%s\n", row, msg, e[error]);
  exit(1);
}

void usageError(void) {
  fprintf(stderr, "Usage: gramophone2 [-c|-d] sourcefile [midifile]\n");
  exit(1);
}
