/*
 * Decompiled with CFR 0.152.
 */
package org.haskell.hslogger4j;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.haskell.hslogger4j.HsloggerLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLDecoder
implements Decoder {
    private static final String BEGINPART = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE log4j:eventSet SYSTEM \"log4j.dtd\"><log4j:eventSet version=\"1.2\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">";
    private static final String ENDPART = "</log4j:eventSet>";
    private static final String RECORD_END = "</log4j:event>";
    private DocumentBuilderFactory dbf;
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private Component owner = null;

    public XMLDecoder(Component component) {
        this();
        this.owner = component;
    }

    public XMLDecoder() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setValidating(false);
        try {
            this.docBuilder = this.dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler((ErrorHandler)new SAXErrorHandler());
            this.docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Unable to get document builder");
        }
    }

    public void setAdditionalProperties(Map map) {
        this.additionalProperties = map;
    }

    private Document parse(String string) {
        if (this.docBuilder == null || string == null) {
            return null;
        }
        Document document = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(1024);
            stringBuffer.append(BEGINPART);
            stringBuffer.append(string);
            stringBuffer.append(ENDPART);
            InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
            inputSource.setSystemId("dummy://log4j.dtd");
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector decode(URL uRL) throws IOException {
        LineNumberReader lineNumberReader = null;
        lineNumberReader = this.owner != null ? new LineNumberReader(new InputStreamReader(new ProgressMonitorInputStream(this.owner, "Loading " + uRL, uRL.openStream()))) : new LineNumberReader(new InputStreamReader(uRL.openStream()));
        Vector vector = new Vector();
        String string = null;
        Vector vector2 = null;
        try {
            while ((string = lineNumberReader.readLine()) != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                for (int i = 0; i < 1000; ++i) {
                    stringBuffer.append(lineNumberReader.readLine()).append("\n");
                }
                vector2 = this.decodeEvents(stringBuffer.toString());
                if (vector2 == null) continue;
                vector.addAll(vector2);
            }
        }
        finally {
            this.partialEvent = null;
            try {
                if (lineNumberReader != null) {
                    lineNumberReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public Vector decodeEvents(String string) {
        if (string != null) {
            if (string.trim().equals("")) {
                return null;
            }
            String string2 = null;
            String string3 = null;
            if (string.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + string;
                return null;
            }
            if (string.lastIndexOf(RECORD_END) + RECORD_END.length() < string.length()) {
                string2 = string.substring(0, string.lastIndexOf(RECORD_END) + RECORD_END.length());
                string3 = string.substring(string.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                string2 = string;
            }
            if (this.partialEvent != null) {
                string2 = this.partialEvent + string2;
            }
            this.partialEvent = string3;
            Document document = this.parse(string2);
            if (document == null) {
                return null;
            }
            return this.decodeEvents(document);
        }
        return null;
    }

    public LoggingEvent decode(String string) {
        Document document = this.parse(string);
        if (document == null) {
            return null;
        }
        Vector vector = this.decodeEvents(document);
        if (vector.size() > 0) {
            return (LoggingEvent)vector.firstElement();
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    private Vector decodeEvents(Document document) {
        Vector<String> vector = new Vector<String>();
        Logger logger = null;
        long l = 0L;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        Object var11_10 = null;
        Object var12_11 = null;
        Object var13_12 = null;
        Object var14_13 = null;
        Hashtable<String, String> hashtable = null;
        NodeList nodeList = document.getElementsByTagName("log4j:eventSet");
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            String string5;
            Node node2 = nodeList2.item(i);
            if (node2.getNodeType() != 1) continue;
            logger = Logger.getLogger((String)node2.getAttributes().getNamedItem("logger").getNodeValue());
            l = Long.parseLong(node2.getAttributes().getNamedItem("timestamp").getNodeValue());
            string = node2.getAttributes().getNamedItem("level").getNodeValue();
            string2 = node2.getAttributes().getNamedItem("thread").getNodeValue();
            NodeList nodeList3 = node2.getChildNodes();
            int n = nodeList3.getLength();
            for (int j = 0; j < n; ++j) {
                String string6;
                String string7;
                Node node3;
                String string8;
                int n2;
                int n3;
                Object object;
                string5 = nodeList3.item(j).getNodeName();
                if (string5.equalsIgnoreCase("log4j:message")) {
                    string3 = this.getCData(nodeList3.item(j));
                }
                if (string5.equalsIgnoreCase("log4j:NDC")) {
                    string4 = this.getCData(nodeList3.item(j));
                }
                if (string5.equalsIgnoreCase("log4j:MDC")) {
                    hashtable = new Hashtable<String, String>();
                    object = nodeList3.item(j).getChildNodes();
                    n3 = object.getLength();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string8 = object.item(n2).getNodeName();
                        if (!string8.equalsIgnoreCase("log4j:data")) continue;
                        node3 = object.item(n2);
                        string7 = node3.getAttributes().getNamedItem("name").getNodeValue();
                        string6 = node3.getAttributes().getNamedItem("value").getNodeValue();
                        hashtable.put(string7, string6);
                    }
                }
                if (string5.equalsIgnoreCase("log4j:throwable")) {
                    stringArray = new String[]{this.getCData(nodeList3.item(j))};
                }
                if (string5.equalsIgnoreCase("log4j:properties")) {
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    object = nodeList3.item(j).getChildNodes();
                    n3 = object.getLength();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string8 = object.item(n2).getNodeName();
                        if (!string8.equalsIgnoreCase("log4j:data")) continue;
                        node3 = object.item(n2);
                        string7 = node3.getAttributes().getNamedItem("name").getNodeValue();
                        string6 = node3.getAttributes().getNamedItem("value").getNodeValue();
                        hashtable.put(string7, string6);
                    }
                }
                if (this.additionalProperties.size() <= 0) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable(this.additionalProperties);
                    continue;
                }
                for (Map.Entry entry : this.additionalProperties.entrySet()) {
                    if (hashtable.containsKey(entry.getKey())) continue;
                    hashtable.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            Level level = HsloggerLevel.toLevel(string);
            if (stringArray == null) {
                stringArray = new String[]{""};
            }
            string5 = new LoggingEvent();
            string5.setLogger(logger);
            string5.setTimeStamp(l);
            string5.setLevel(level);
            string5.setThreadName(string2);
            string5.setMessage((Object)string3);
            string5.setNDC(string4);
            string5.setThrowableInformation(new ThrowableInformation(stringArray));
            string5.setProperties(hashtable);
            vector.add(string5);
            logger = null;
            l = 0L;
            string = null;
            string2 = null;
            string3 = null;
            string4 = null;
            stringArray = null;
            var11_10 = null;
            var12_11 = null;
            var13_12 = null;
            var14_13 = null;
            hashtable = null;
        }
        return vector;
    }

    private String getCData(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
            stringBuffer.append(node2.getNodeValue());
        }
        return stringBuffer.toString();
    }
}

