// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "MasterUI.h"
//Copyright (c) 2002-2009 Nasca Octavian Paul
//License: GNU GPL version 2 or later

VUMeter::VUMeter(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  master=NULL;
  npart=-1;
}

void VUMeter::init(Master *master_,int part_) {
  //the "part_" parameters sets the part (if it is >=0), else it sets the master
  master=master_;
  label(NULL);
  npart=part_;
  olddbl=0.0;
  olddbr=0.0;
  oldrmsdbl=0.0;
  oldrmsdbr=0.0;
}

void VUMeter::draw_master() {
  #define MIN_DB (-48)
  
  int ox=x(); int oy=y(); int lx=w(); int ly=h();
  
  pthread_mutex_lock(&master->mutex);
  REALTYPE dbl=rap2dB(master->vuoutpeakl);
  REALTYPE dbr=rap2dB(master->vuoutpeakr);
  REALTYPE rmsdbl=rap2dB(master->vurmspeakl);
  REALTYPE rmsdbr=rap2dB(master->vurmspeakr);
  REALTYPE maxdbl=rap2dB(master->vumaxoutpeakl);
  REALTYPE maxdbr=rap2dB(master->vumaxoutpeakr);
  int clipped=master->vuclipped;
  pthread_mutex_unlock(&master->mutex);
  
  dbl=(MIN_DB-dbl)/MIN_DB; 
  if (dbl<0.0) dbl=0.0;
    else if (dbl>1.0)dbl=1.0;
  
  dbr=(MIN_DB-dbr)/MIN_DB; 
  if (dbr<0.0) dbr=0.0;
    else if (dbr>1.0) dbr=1.0; 
  
  dbl=dbl*0.4+olddbl*0.6;
  dbr=dbr*0.4+olddbr*0.6;
  
  olddbl=dbl;
  olddbr=dbr;
  
  #define VULENX (lx-35)
  #define VULENY (ly/2-3)
  
  dbl*=VULENX;dbr*=VULENX;
  
  int idbl=(int) dbl;
  int idbr=(int) dbr;
  
  //compute RMS - start
  rmsdbl=(MIN_DB-rmsdbl)/MIN_DB; 
  if (rmsdbl<0.0) rmsdbl=0.0;
    else if (rmsdbl>1.0) rmsdbl=1.0;
  
  rmsdbr=(MIN_DB-rmsdbr)/MIN_DB; 
  if (rmsdbr<0.0) rmsdbr=0.0;
    else if (rmsdbr>1.0) rmsdbr=1.0; 
  
  rmsdbl=rmsdbl*0.4+oldrmsdbl*0.6;
  rmsdbr=rmsdbr*0.4+oldrmsdbr*0.6;
  
  oldrmsdbl=rmsdbl;
  oldrmsdbr=rmsdbr;
  
  
  rmsdbl*=VULENX;rmsdbr*=VULENX;
  
  int irmsdbl=(int) rmsdbl;
  int irmsdbr=(int) rmsdbr;
  //compute RMS - end
  
  
  
  //draw the vu-meter lines
  //db
  fl_rectf(ox,oy,idbr,VULENY,0,200,255);
  fl_rectf(ox,oy+ly/2,idbl,VULENY,0,200,255);
  //black
  fl_rectf(ox+idbr,oy,VULENX-idbr,VULENY,0,0,0);
  fl_rectf(ox+idbl,oy+ly/2,VULENX-idbl,VULENY,0,0,0);
  
  //draw the scales
  REALTYPE  tmp=VULENX*1.0/MIN_DB;
  for (int i=1;i<1-MIN_DB;i++){
     int tx=VULENX+(int) (tmp*i);
     fl_rectf(ox+tx,oy,1,VULENY+ly/2,0,160,200);
     if (i%5==0) fl_rectf(ox+tx,oy,1,VULENY+ly/2,0,230,240);
     if (i%10==0) fl_rectf(ox+tx-1,oy,2,VULENY+ly/2,0,225,255);
  };
  
  //rms
  if (irmsdbr>2) fl_rectf(ox+irmsdbr-1,oy,3,VULENY,255,255,0);
  if (irmsdbl>2) fl_rectf(ox+irmsdbl-1,oy+ly/2,3,VULENY,255,255,0);
  
  
  //draw the red box if clipping has occured
  if (clipped==0) fl_rectf(ox+VULENX+2,oy+1,lx-VULENX-3,ly-4,0,0,10);
             else fl_rectf(ox+VULENX+2,oy+1,lx-VULENX-3,ly-4,250,10,10);
  
  //draw the maxdB 
  fl_font(FL_HELVETICA|FL_BOLD,10);
  fl_color(255,255,255);
  char tmpstr[10];
  if ((maxdbl>MIN_DB-20)){
    snprintf((char *)&tmpstr,10,"%ddB",(int)maxdbr);
    fl_draw(tmpstr,ox+VULENX+1,oy+1,lx-VULENX-1,VULENY,FL_ALIGN_RIGHT,NULL,0);
  };
  if ((maxdbr>MIN_DB-20)){
    snprintf((char *)&tmpstr,10,"%ddB",(int)maxdbl);
    fl_draw(tmpstr,ox+VULENX+1,oy+ly/2+1,lx-VULENX-1,VULENY,FL_ALIGN_RIGHT,NULL,0);
  };
}

void VUMeter::draw_part() {
  #define MIN_DB (-48)
  int ox=x(); int oy=y(); int lx=w(); int ly=h();
  
  if (!active_r()){
    pthread_mutex_lock(&master->mutex);
     int fakedb=master->fakepeakpart[npart];
    pthread_mutex_unlock(&master->mutex);
    fl_rectf(ox,oy,lx,ly,140,140,140);
    if (fakedb>0){
      fakedb=(int)(fakedb/255.0*ly)+4;
      fl_rectf(ox+2,oy+ly-fakedb,lx-4,fakedb,0,0,0);
    };
    
    return;
  };
  
  //draw the vu lines
  pthread_mutex_lock(&master->mutex);
   REALTYPE db=rap2dB(master->vuoutpeakpart[npart]);
  pthread_mutex_unlock(&master->mutex);
  
  db=(MIN_DB-db)/MIN_DB; 
  if (db<0.0) db=0.0;
    else if (db>1.0) db=1.0;
  
  db*=ly-2;
  
  int idb=(int) db;
  
  fl_rectf(ox,oy+ly-idb,lx,idb,0,200,255);
  fl_rectf(ox,oy,lx,ly-idb,0,0,0);
  
  
  //draw the scales
  REALTYPE  tmp=ly*1.0/MIN_DB;
   for (int i=1;i<1-MIN_DB;i++){
      int ty=ly+(int) (tmp*i);
      if (i%5==0) fl_rectf(ox,oy+ly-ty,lx,1,0,160,200);
      if (i%10==0) fl_rectf(ox,oy+ly-ty,lx,1,0,230,240);
  };
}

void VUMeter::draw() {
  if (npart>=0) draw_part();
     else draw_master();
}

void VUMeter::tickdraw(VUMeter *o) {
  o->redraw();
}

void VUMeter::tick(void *v) {
  tickdraw((VUMeter *) v);
  Fl::add_timeout(1.0/25.0,tick,v);//25 fps
}

int VUMeter::handle(int event) {
  switch(event){
     case FL_SHOW:
               tick(this);
               break;
     case FL_HIDE:
               Fl::remove_timeout(tick,this);
               break;
     case FL_PUSH:
               if (npart>=0) break;
               pthread_mutex_lock(&master->mutex);
               master->vuresetpeaks();
               pthread_mutex_unlock(&master->mutex);
               break;
  };
  return(1);
}

SysEffSend::SysEffSend(int x,int y, int w, int h, const char *label):WidgetPDial(x,y,w,h,label) {
  master=NULL;
  neff1=0;
  neff2=0;
}

void SysEffSend::init(Master *master_,int neff1_,int neff2_) {
  neff1=neff1_;
  neff2=neff2_;
  master=master_;
  minimum(0);
  maximum(127);
  step(1);
  labelfont(1);
  labelsize(10);
  align(FL_ALIGN_TOP);
  
  value(master->Psysefxsend[neff1][neff2]);
  char tmp[20];snprintf(tmp,20,"%d->%d",neff1+1,neff2+1);
  this->copy_label(tmp);
}

SysEffSend::~SysEffSend() {
  hide();
}

int SysEffSend::handle(int event) {
  if ((event==FL_PUSH) || (event==FL_DRAG)){
     master->setPsysefxsend(neff1,neff2,(int) value());
  };
  
  return(WidgetPDial::handle(event));
}

void Panellistitem::cb_partname_i(Fl_Button*, void*) {
  if ((int)bankui->cbwig->value()!=(npart+1)){
   bankui->cbwig->value(npart+1);
   bankui->cbwig->do_callback();
};
bankui->show();
}
void Panellistitem::cb_partname(Fl_Button* o, void* v) {
  ((Panellistitem*)(o->parent()->parent()->user_data()))->cb_partname_i(o,v);
}

void Panellistitem::cb_partvolume_i(Fl_Slider* o, void*) {
  master->part[npart]->setPvolume((int) o->value());
}
void Panellistitem::cb_partvolume(Fl_Slider* o, void* v) {
  ((Panellistitem*)(o->parent()->parent()->user_data()))->cb_partvolume_i(o,v);
}

void Panellistitem::cb_partpanning_i(WidgetPDial* o, void*) {
  master->part[npart]->setPpanning((int) o->value());
}
void Panellistitem::cb_partpanning(WidgetPDial* o, void* v) {
  ((Panellistitem*)(o->parent()->parent()->user_data()))->cb_partpanning_i(o,v);
}

void Panellistitem::cb_edit_i(Fl_Button*, void*) {
  if ((int)bankui->cbwig->value()!=(npart+1)){
   bankui->cbwig->value(npart+1);
   bankui->cbwig->do_callback();
};
}
void Panellistitem::cb_edit(Fl_Button* o, void* v) {
  ((Panellistitem*)(o->parent()->parent()->user_data()))->cb_edit_i(o,v);
}

void Panellistitem::cb_partrcv_i(Fl_Choice* o, void*) {
  master->part[npart]->Prcvchn=(int) o->value();
}
void Panellistitem::cb_partrcv(Fl_Choice* o, void* v) {
  ((Panellistitem*)(o->parent()->parent()->user_data()))->cb_partrcv_i(o,v);
}

void Panellistitem::cb_partenabled_i(Fl_Check_Button* o, void*) {
  pthread_mutex_lock(&master->mutex);
 master->partonoff(npart,(int) o->value());
pthread_mutex_unlock(&master->mutex);

if ((int) o->value()==0) panellistitemgroup->deactivate();
  else {
    panellistitemgroup->activate();
    if ((int)bankui->cbwig->value()!=(npart+1)){
       bankui->cbwig->value(npart+1);
       bankui->cbwig->do_callback();
    };
};

o->redraw();
}
void Panellistitem::cb_partenabled(Fl_Check_Button* o, void* v) {
  ((Panellistitem*)(o->parent()->user_data()))->cb_partenabled_i(o,v);
}

Fl_Group* Panellistitem::make_window() {
  { panellistitem = new Fl_Group(0, 0, 70, 260);
    panellistitem->box(FL_FLAT_BOX);
    panellistitem->color(FL_BACKGROUND_COLOR);
    panellistitem->selection_color(FL_BACKGROUND_COLOR);
    panellistitem->labeltype(FL_NO_LABEL);
    panellistitem->labelfont(0);
    panellistitem->labelsize(14);
    panellistitem->labelcolor(FL_FOREGROUND_COLOR);
    panellistitem->user_data((void*)(this));
    panellistitem->align(Fl_Align(FL_ALIGN_TOP));
    panellistitem->when(FL_WHEN_RELEASE);
    { Fl_Group* o = panellistitemgroup = new Fl_Group(0, 20, 70, 240);
      panellistitemgroup->box(FL_PLASTIC_THIN_UP_BOX);
      { Fl_Group* o = new Fl_Group(45, 65, 15, 110);
        o->box(FL_ENGRAVED_FRAME);
        { VUMeter* o = new VUMeter(45, 65, 15, 110, "V U");
          o->box(FL_FLAT_BOX);
          o->color(FL_FOREGROUND_COLOR);
          o->selection_color((Fl_Color)75);
          o->labeltype(FL_NORMAL_LABEL);
          o->labelfont(0);
          o->labelsize(14);
          o->labelcolor((Fl_Color)55);
          o->align(Fl_Align(FL_ALIGN_WRAP));
          o->when(FL_WHEN_RELEASE);
          o->init(master,npart);
        } // VUMeter* o
        o->end();
      } // Fl_Group* o
      { partname = new Fl_Button(5, 27, 60, 30, "  ");
        partname->box(FL_THIN_DOWN_BOX);
        partname->down_box(FL_FLAT_BOX);
        partname->labelfont(1);
        partname->labelsize(10);
        partname->callback((Fl_Callback*)cb_partname);
        partname->align(Fl_Align(192|FL_ALIGN_INSIDE));
      } // Fl_Button* partname
      { Fl_Slider* o = partvolume = new Fl_Slider(10, 65, 30, 110);
        partvolume->type(4);
        partvolume->box(FL_FLAT_BOX);
        partvolume->minimum(127);
        partvolume->maximum(0);
        partvolume->step(1);
        partvolume->value(127);
        partvolume->callback((Fl_Callback*)cb_partvolume);
        o->value(master->part[npart]->Pvolume);
      } // Fl_Slider* partvolume
      { WidgetPDial* o = partpanning = new WidgetPDial(20, 180, 30, 30);
        partpanning->box(FL_OVAL_BOX);
        partpanning->color(FL_BACKGROUND_COLOR);
        partpanning->selection_color(FL_INACTIVE_COLOR);
        partpanning->labeltype(FL_NORMAL_LABEL);
        partpanning->labelfont(0);
        partpanning->labelsize(14);
        partpanning->labelcolor(FL_FOREGROUND_COLOR);
        partpanning->maximum(127);
        partpanning->step(1);
        partpanning->callback((Fl_Callback*)cb_partpanning);
        partpanning->align(Fl_Align(FL_ALIGN_BOTTOM));
        partpanning->when(FL_WHEN_CHANGED);
        o->value(master->part[npart]->Ppanning);
      } // WidgetPDial* partpanning
      { Fl_Button* o = new Fl_Button(15, 235, 40, 20, "edit");
        o->box(FL_PLASTIC_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_edit);
      } // Fl_Button* o
      { Fl_Choice* o = partrcv = new Fl_Choice(10, 213, 50, 15);
        partrcv->tooltip("receive from Midi channel");
        partrcv->down_box(FL_BORDER_BOX);
        partrcv->labelsize(10);
        partrcv->textfont(1);
        partrcv->textsize(10);
        partrcv->callback((Fl_Callback*)cb_partrcv);
        partrcv->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        char nrstr[10]; for(int i=0;i<NUM_MIDI_CHANNELS;i++){sprintf(nrstr,"Ch%d",i+1);if (i!=9) o->add(nrstr); else o->add("Dr10");};
        o->value(master->part[npart]->Prcvchn);
      } // Fl_Choice* partrcv
      if (master->part[npart]->Penabled==0) o->deactivate();
      panellistitemgroup->end();
    } // Fl_Group* panellistitemgroup
    { Fl_Check_Button* o = partenabled = new Fl_Check_Button(5, 0, 45, 20, "01");
      partenabled->down_box(FL_DOWN_BOX);
      partenabled->labeltype(FL_EMBOSSED_LABEL);
      partenabled->labelfont(1);
      partenabled->labelsize(13);
      partenabled->callback((Fl_Callback*)cb_partenabled);
      partenabled->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      char tmp[10];snprintf(tmp,10,"%d",npart+1);o->copy_label(tmp);
      o->value(master->part[npart]->Penabled);
    } // Fl_Check_Button* partenabled
    panellistitem->end();
  } // Fl_Group* panellistitem
  return panellistitem;
}

Panellistitem::Panellistitem(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  npart=0;
  master=NULL;
  bankui=NULL;
}

void Panellistitem::init(Master *master_, int npart_,BankUI *bankui_) {
  npart=npart_;
  master=master_;
  bankui=bankui_;
  
  make_window();
  panellistitem->show();
  end();
}

void Panellistitem::refresh() {
  partenabled->value(master->part[npart]->Penabled);
  if (master->part[npart]->Penabled!=0) panellistitemgroup->activate();
       else panellistitemgroup->deactivate();
  
  partvolume->value(master->part[npart]->Pvolume);
  partpanning->value(master->part[npart]->Ppanning);
  partrcv->value(master->part[npart]->Prcvchn);
  
  partname->label((char *)master->part[npart]->Pname);
  
  if ((int)bankui->cbwig->value()!=(npart+1))
     panellistitemgroup->color(fl_rgb_color(160,160,160));
  else 
     panellistitemgroup->color(fl_rgb_color(50,190,240));
  
  panellistitemgroup->redraw();
}

Panellistitem::~Panellistitem() {
  panellistitem->hide();
  //delete(panellistitem);
}

void MasterUI::cb_masterwindow_i(Fl_Double_Window*, void*) {
  #ifdef VSTAUDIOOUT
fl_alert("ZynAddSubFX could not be closed this way, because it's a VST plugin. Please use the host aplication to close it.");
#else
//if (fl_choice("Exit and leave the unsaved data?","No","Yes",NULL)) {
    config.save();
    *exitprogram=1;
//};
#endif
}
void MasterUI::cb_masterwindow(Fl_Double_Window* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_masterwindow_i(o,v);
}

void MasterUI::cb_New_i(Fl_Menu_*, void*) {
  do_new_master();
}
void MasterUI::cb_New(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_New_i(o,v);
}

void MasterUI::cb_Open_i(Fl_Menu_*, void*) {
  do_load_master();
}
void MasterUI::cb_Open(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Open_i(o,v);
}

void MasterUI::cb_Save_i(Fl_Menu_*, void*) {
  do_save_master();
}
void MasterUI::cb_Save(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Save_i(o,v);
}

void MasterUI::cb_Load_i(Fl_Menu_*, void*) {
  char *filename;
filename=fl_file_chooser("Open:","({*.xsz})",NULL,0);
if (filename==NULL) return;

pthread_mutex_lock(&master->mutex);
  //clear all parameters
  master->microtonal.defaults();

  //load the data
  int result=master->microtonal.loadXML(filename);
pthread_mutex_unlock(&master->mutex);


 delete microtonalui;  
 microtonalui=new MicrotonalUI(&master->microtonal);

if (result==-10) fl_alert("Error: Could not load the file\nbecause it is not a scale file.");
      else if (result<0) fl_alert("Error: Could not load the file.");
}
void MasterUI::cb_Load(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Load_i(o,v);
}

void MasterUI::cb_Save1_i(Fl_Menu_*, void*) {
  char *filename;
int result=0;

filename=fl_file_chooser("Save:","({*.xsz})",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".xsz");

result=fileexists(filename);
if (result) {
    result=0;
   if (!fl_choice("The file exists. \nOverwrite it?","No","Yes",NULL)) return;
       
};


pthread_mutex_lock(&master->mutex);
result=master->microtonal.saveXML(filename);
pthread_mutex_unlock(&master->mutex);

if (result<0) fl_alert("Error: Could not save the file.");


updatepanel();
}
void MasterUI::cb_Save1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Save1_i(o,v);
}

void MasterUI::cb_Show_i(Fl_Menu_*, void*) {
  microtonalui->show();
}
void MasterUI::cb_Show(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Show_i(o,v);
}

void MasterUI::cb_Settings_i(Fl_Menu_*, void*) {
  configui->show();
}
void MasterUI::cb_Settings(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Settings_i(o,v);
}

void MasterUI::cb_Copyright_i(Fl_Menu_*, void*) {
  aboutwindow->show();
}
void MasterUI::cb_Copyright(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Copyright_i(o,v);
}

void MasterUI::cb_E_i(Fl_Menu_*, void*) {
  masterwindow->do_callback();
}
void MasterUI::cb_E(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_E_i(o,v);
}

void MasterUI::cb_Clear_i(Fl_Menu_*, void*) {
  if (fl_choice("Clear instrument's parameters ?","No","Yes",NULL)){
//       int npart=(int)npartcounter->value()-1;
       pthread_mutex_lock(&master->mutex);
       master->part[npart]->defaultsinstrument();
       pthread_mutex_unlock(&master->mutex);

       npartcounter->do_callback();
};

updatepanel();
}
void MasterUI::cb_Clear(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Clear_i(o,v);
}

void MasterUI::cb_Open1_i(Fl_Menu_*, void*) {
  const char *filename;
filename=fl_file_chooser("Load:","({*.xiz})",NULL,0);
if (filename==NULL) return;


pthread_mutex_lock(&master->mutex);
//  int npart=(int)npartcounter->value()-1;

  //clear all instrument parameters, first
  master->part[npart]->defaultsinstrument();

  //load the instr. parameters
  int result=master->part[npart]->loadXMLinstrument(filename);

pthread_mutex_unlock(&master->mutex);
master->part[npart]->applyparameters();

npartcounter->do_callback();
updatepanel();

if (result==-10) fl_alert("Error: Could not load the file\nbecause it is not an instrument file.");
      else if (result<0) fl_alert("Error: Could not load the file.");
}
void MasterUI::cb_Open1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Open1_i(o,v);
}

void MasterUI::cb_Save2_i(Fl_Menu_*, void*) {
  char *filename;

filename=fl_file_chooser("Save:","({*.xiz})",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".xiz");

int result=fileexists(filename);
if (result) {
    result=0;
   if (!fl_choice("The file exists. \nOverwrite it?","No","Yes",NULL)) return;
       
};


pthread_mutex_lock(&master->mutex);
result=master->part[npart]->saveXML(filename);
pthread_mutex_unlock(&master->mutex);

if (result<0) fl_alert("Error: Could not save the file.");

updatepanel();
}
void MasterUI::cb_Save2(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Save2_i(o,v);
}

void MasterUI::cb_Show1_i(Fl_Menu_*, void*) {
  bankui->show();
}
void MasterUI::cb_Show1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Show1_i(o,v);
}

void MasterUI::cb_Virtual_i(Fl_Menu_*, void*) {
  virkeyboard->show();
}
void MasterUI::cb_Virtual(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Virtual_i(o,v);
}

void MasterUI::cb_Choose_i(Fl_Menu_*, void*) {
  char *filename;
recordbutton->deactivate();
pausebutton->deactivate();
pauselabel->deactivate();
stopbutton->deactivate();
filename=fl_file_chooser("Record to audio file:","(*.wav)",NULL,0);
if (filename==NULL) return;
fl_filename_setext(filename,".wav");

int result=master->HDDRecorder.preparefile(filename,0);
if (result==1) {
    result=0;
   if (fl_choice("The file exists. \nOverwrite it?","No","Yes",NULL))
       master->HDDRecorder.preparefile(filename,1);
};
if (result==0) recordbutton->activate();

if (result!=0) fl_alert("Error: Could not save the file.");
}
void MasterUI::cb_Choose(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Choose_i(o,v);
}

void MasterUI::cb_Show2_i(Fl_Menu_*, void*) {
  sequi->show();
}
void MasterUI::cb_Show2(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Show2_i(o,v);
}

void MasterUI::cb_Switch_i(Fl_Menu_*, void*) {
  if (fl_choice("Switch the User Interface to Beginner mode ?","No","Yes",NULL)){
	masterwindow->hide();
	refresh_master_ui();
	simplemasterwindow->show();
	config.cfg.UserInterfaceMode=2;
};
}
void MasterUI::cb_Switch(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Switch_i(o,v);
}

Fl_Menu_Item MasterUI::menu_mastermenu[] = {
 {"&File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"&New (erase all)...", 0,  (Fl_Callback*)MasterUI::cb_New, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Open Parameters...", 0,  (Fl_Callback*)MasterUI::cb_Open, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Save All Parameters...", 0,  (Fl_Callback*)MasterUI::cb_Save, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Load Scale Settings...", 0,  (Fl_Callback*)MasterUI::cb_Load, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save Sc&ale Settings ..", 0,  (Fl_Callback*)MasterUI::cb_Save1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Show Scale Settings...", 0,  (Fl_Callback*)MasterUI::cb_Show, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Settings...", 0,  (Fl_Callback*)MasterUI::cb_Settings, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Copyright...", 0,  (Fl_Callback*)MasterUI::cb_Copyright, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"E&xit", 0,  (Fl_Callback*)MasterUI::cb_E, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Instrument", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Clear Instrument...", 0,  (Fl_Callback*)MasterUI::cb_Clear, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Open Instrument...", 0,  (Fl_Callback*)MasterUI::cb_Open1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Save Instrument ...", 0,  (Fl_Callback*)MasterUI::cb_Save2, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Show Instrument &Bank...", 0,  (Fl_Callback*)MasterUI::cb_Show1, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Virtual Keyboard...", 0,  (Fl_Callback*)MasterUI::cb_Virtual, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Record", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Choose WAV file...", 0,  (Fl_Callback*)MasterUI::cb_Choose, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Sequencer", 0,  0, 0, 80, FL_NORMAL_LABEL, 0, 14, 0},
 {"Show &Sequencer...", 0,  (Fl_Callback*)MasterUI::cb_Show2, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Misc", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Switch User Interface Mode", 0,  (Fl_Callback*)MasterUI::cb_Switch, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* MasterUI::recordmenu = MasterUI::menu_mastermenu + 18;

void MasterUI::cb_mastervolumedial_i(WidgetPDial* o, void*) {
  master->setPvolume((int) o->value());
}
void MasterUI::cb_mastervolumedial(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_mastervolumedial_i(o,v);
}

void MasterUI::cb_masterkeyshiftcounter_i(Fl_Counter* o, void*) {
  master->setPkeyshift((int) o->value()+64);
}
void MasterUI::cb_masterkeyshiftcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_masterkeyshiftcounter_i(o,v);
}

void MasterUI::cb_Panic_i(Fl_Button*, void*) {
  virkeyboard->relaseallkeys();
pthread_mutex_lock(&master->mutex);
master->shutup=1;
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_Panic(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Panic_i(o,v);
}

void MasterUI::cb_syseffnocounter_i(Fl_Counter* o, void*) {
  nsyseff=(int) o->value()-1;
sysefftype->value(master->sysefx[nsyseff]->geteffect());
syseffectui->refresh(master->sysefx[nsyseff]);
}
void MasterUI::cb_syseffnocounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_syseffnocounter_i(o,v);
}

void MasterUI::cb_sysefftype_i(Fl_Choice* o, void*) {
  pthread_mutex_lock(&master->mutex);
master->sysefx[nsyseff]->changeeffect((int) o->value());
pthread_mutex_unlock(&master->mutex);
syseffectui->refresh(master->sysefx[nsyseff]);
}
void MasterUI::cb_sysefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_sysefftype_i(o,v);
}

Fl_Menu_Item MasterUI::menu_sysefftype[] = {
 {"No Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Reverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"AlienWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Distortion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"EQ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DynFilter", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MasterUI::cb_Send_i(Fl_Button*, void*) {
  syseffsendwindow->show();
}
void MasterUI::cb_Send(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_Send_i(o,v);
}

void MasterUI::cb_C_i(Fl_Button*, void*) {
  presetsui->copy(master->sysefx[nsyseff]);
}
void MasterUI::cb_C(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_C_i(o,v);
}

void MasterUI::cb_P_i(Fl_Button*, void*) {
  pthread_mutex_lock(&master->mutex);
presetsui->paste(master->sysefx[nsyseff],syseffectui);
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_P(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_P_i(o,v);
}

void MasterUI::cb_inseffnocounter_i(Fl_Counter* o, void*) {
  ninseff=(int) o->value()-1;
insefftype->value(master->insefx[ninseff]->geteffect());
inseffpart->value(master->Pinsparts[ninseff]+2);
inseffectui->refresh(master->insefx[ninseff]);

if (master->Pinsparts[ninseff]!=-1) {
        insefftype->activate();
	inseffectui->activate();
        inseffectuigroup->activate();
} else {
	insefftype->deactivate();
 	inseffectui->deactivate();
        inseffectuigroup->deactivate();
};
}
void MasterUI::cb_inseffnocounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_inseffnocounter_i(o,v);
}

void MasterUI::cb_insefftype_i(Fl_Choice* o, void*) {
  pthread_mutex_lock(&master->mutex);
master->insefx[ninseff]->changeeffect((int) o->value());
pthread_mutex_unlock(&master->mutex);
inseffectui->refresh(master->insefx[ninseff]);
inseffectui->show();
}
void MasterUI::cb_insefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_insefftype_i(o,v);
}

Fl_Menu_Item MasterUI::menu_insefftype[] = {
 {"No Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Reverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"AlienWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Distortion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"EQ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DynFilter", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MasterUI::cb_inseffpart_i(Fl_Choice* o, void*) {
  master->Pinsparts[ninseff]=(int) o->value()-2;
if ((int) o->value()==1){
    inseffectuigroup->deactivate();
    insefftype->deactivate();
    inseffectui->deactivate();
} else {
    inseffectuigroup->activate();
    insefftype->activate();
    inseffectui->activate();
};
master->insefx[ninseff]->cleanup();
}
void MasterUI::cb_inseffpart(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_inseffpart_i(o,v);
}

void MasterUI::cb_C1_i(Fl_Button*, void*) {
  presetsui->copy(master->insefx[ninseff]);
}
void MasterUI::cb_C1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_C1_i(o,v);
}

void MasterUI::cb_P1_i(Fl_Button*, void*) {
  pthread_mutex_lock(&master->mutex);
presetsui->paste(master->insefx[ninseff],inseffectui);
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_P1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_P1_i(o,v);
}

void MasterUI::cb_Scales_i(Fl_Button*, void*) {
  microtonalui->show();
}
void MasterUI::cb_Scales(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Scales_i(o,v);
}

void MasterUI::cb_recordbutton_i(Fl_Button* o, void*) {
  o->deactivate();
recordmenu->deactivate();
recordmenu->label("&Record(*)");
stopbutton->activate();
pausebutton->activate();
pauselabel->activate();
master->HDDRecorder.start();
master->vuresetpeaks();
mastermenu->redraw();
}
void MasterUI::cb_recordbutton(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_recordbutton_i(o,v);
}

void MasterUI::cb_stopbutton_i(Fl_Button* o, void*) {
  o->deactivate();
master->HDDRecorder.stop();
recordbutton->deactivate();
pausebutton->deactivate();
pauselabel->deactivate();
recordmenu->activate();
recordmenu->label("&Record");
mastermenu->redraw();
}
void MasterUI::cb_stopbutton(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_stopbutton_i(o,v);
}

void MasterUI::cb_pausebutton_i(Fl_Button* o, void*) {
  o->deactivate();
master->HDDRecorder.pause();
recordbutton->activate();
mastermenu->redraw();
}
void MasterUI::cb_pausebutton(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_pausebutton_i(o,v);
}

void MasterUI::cb_nrpnbutton_i(Fl_Check_Button* o, void*) {
  master->ctl.NRPN.receive=(int) o->value();
}
void MasterUI::cb_nrpnbutton(Fl_Check_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_nrpnbutton_i(o,v);
}

void MasterUI::cb_npartcounter_i(Fl_Counter* o, void*) {
  int nval=(int) o->value()-1;
partuigroup->remove(partui);
delete partui;
partui=new PartUI(0,0,765,525);
partuigroup->add(partui);
partui->init(master->part[nval],master,nval,bankui);
partui->redraw();
o->redraw();
npart=nval;

updatepanel();
simplenpartcounter->value(nval+1);
simplenpartcounter->do_callback();
}
void MasterUI::cb_npartcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_npartcounter_i(o,v);
}

void MasterUI::cb_vK_i(Fl_Button*, void*) {
  virkeyboard->show();
}
void MasterUI::cb_vK(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_vK_i(o,v);
}

void MasterUI::cb_R_i(Fl_Button*, void*) {
  globalfinedetuneslider->value(64.0);
globalfinedetuneslider->do_callback();
}
void MasterUI::cb_R(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_R_i(o,v);
}

void MasterUI::cb_globalfinedetuneslider_i(WidgetPDial* o, void*) {
  master->microtonal.Pglobalfinedetune=(int) o->value();
}
void MasterUI::cb_globalfinedetuneslider(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_globalfinedetuneslider_i(o,v);
}

void MasterUI::cb_Panel_i(Fl_Button*, void*) {
  updatepanel();
panelwindow->show();
}
void MasterUI::cb_Panel(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Panel_i(o,v);
}

void MasterUI::cb_Close_i(Fl_Button*, void*) {
  aboutwindow->hide();
}
void MasterUI::cb_Close(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

void MasterUI::cb_Close1_i(Fl_Button*, void*) {
  syseffsendwindow->hide();
}
void MasterUI::cb_Close1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Close1_i(o,v);
}

void MasterUI::cb_Close2_i(Fl_Button*, void*) {
  panelwindow->hide();
updatepanel();
}
void MasterUI::cb_Close2(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Close2_i(o,v);
}

void MasterUI::cb_Refresh_i(Fl_Button*, void*) {
  updatepanel();
}
void MasterUI::cb_Refresh(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Refresh_i(o,v);
}

void MasterUI::cb_simplemasterwindow_i(Fl_Double_Window*, void*) {
  #ifdef VSTAUDIOOUT
fl_alert("ZynAddSubFX could not be closed this way, because it's a VST plugin. Please use the host aplication to close it.");
#else
//if (fl_choice("Exit and leave the unsaved data?","No","Yes",NULL)) {
	config.save();
	*exitprogram=1;
//};
#endif
}
void MasterUI::cb_simplemasterwindow(Fl_Double_Window* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_simplemasterwindow_i(o,v);
}

void MasterUI::cb_New1_i(Fl_Menu_*, void*) {
  do_new_master();
}
void MasterUI::cb_New1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_New1_i(o,v);
}

void MasterUI::cb_Open2_i(Fl_Menu_*, void*) {
  do_load_master();
}
void MasterUI::cb_Open2(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Open2_i(o,v);
}

void MasterUI::cb_Save3_i(Fl_Menu_*, void*) {
  do_save_master();
}
void MasterUI::cb_Save3(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Save3_i(o,v);
}

void MasterUI::cb_Settings1_i(Fl_Menu_*, void*) {
  configui->show();
}
void MasterUI::cb_Settings1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Settings1_i(o,v);
}

void MasterUI::cb_Copyright1_i(Fl_Menu_*, void*) {
  aboutwindow->show();
}
void MasterUI::cb_Copyright1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Copyright1_i(o,v);
}

void MasterUI::cb_E1_i(Fl_Menu_*, void*) {
  masterwindow->do_callback();
}
void MasterUI::cb_E1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_E1_i(o,v);
}

void MasterUI::cb_Open3_i(Fl_Menu_*, void*) {
  const char *filename;
filename=fl_file_chooser("Load:","({*.xiz})",NULL,0);
if (filename==NULL) return;


pthread_mutex_lock(&master->mutex);
//  int npart=(int)npartcounter->value()-1;

  //clear all instrument parameters, first
  master->part[npart]->defaultsinstrument();

  //load the instr. parameters
  int result=master->part[npart]->loadXMLinstrument(filename);

pthread_mutex_unlock(&master->mutex);
master->part[npart]->applyparameters();

simplenpartcounter->do_callback();

if (result==-10) fl_alert("Error: Could not load the file\nbecause it is not an instrument file.");
      else if (result<0) fl_alert("Error: Could not load the file.");
}
void MasterUI::cb_Open3(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Open3_i(o,v);
}

void MasterUI::cb_Show3_i(Fl_Menu_*, void*) {
  bankui->show();
}
void MasterUI::cb_Show3(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Show3_i(o,v);
}

void MasterUI::cb_Switch1_i(Fl_Menu_*, void*) {
  if (fl_choice("Switch the User Interface to Advanced mode ?","No","Yes",NULL)){
	simplemasterwindow->hide();
	refresh_master_ui();
	masterwindow->show();
	config.cfg.UserInterfaceMode=1;
};
}
void MasterUI::cb_Switch1(Fl_Menu_* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Switch1_i(o,v);
}

Fl_Menu_Item MasterUI::menu_[] = {
 {"&File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"&New (erase all)...", 0,  (Fl_Callback*)MasterUI::cb_New1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Open Parameters...", 0,  (Fl_Callback*)MasterUI::cb_Open2, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Save All Parameters...", 0,  (Fl_Callback*)MasterUI::cb_Save3, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Settings...", 0,  (Fl_Callback*)MasterUI::cb_Settings1, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Copyright...", 0,  (Fl_Callback*)MasterUI::cb_Copyright1, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"E&xit", 0,  (Fl_Callback*)MasterUI::cb_E1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Instrument", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Open Instrument...", 0,  (Fl_Callback*)MasterUI::cb_Open3, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Show Instrument &Bank...", 0,  (Fl_Callback*)MasterUI::cb_Show3, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Misc", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Switch User Interface Mode", 0,  (Fl_Callback*)MasterUI::cb_Switch1, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

void MasterUI::cb_partname1_i(Fl_Button*, void*) {
  if ((int)bankui->cbwig->value()!=(npart+1)){
   bankui->cbwig->value(npart+1);
   bankui->cbwig->do_callback();
};
bankui->show();
}
void MasterUI::cb_partname1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_partname1_i(o,v);
}

void MasterUI::cb_partpanning1_i(Fl_Slider* o, void*) {
  master->part[npart]->setPpanning((int) o->value());
}
void MasterUI::cb_partpanning1(Fl_Slider* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_partpanning1_i(o,v);
}

void MasterUI::cb_partrcv1_i(Fl_Choice* o, void*) {
  virkeys->relaseallkeys(0);
master->part[npart]->Prcvchn=(int) o->value();
virkeys->midich=(int) o->value();
}
void MasterUI::cb_partrcv1(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_partrcv1_i(o,v);
}

void MasterUI::cb_partvolume1_i(WidgetPDial* o, void*) {
  master->part[npart]->setPvolume((int) o->value());
}
void MasterUI::cb_partvolume1(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_partvolume1_i(o,v);
}

void MasterUI::cb_simplepartportamento_i(Fl_Check_Button* o, void*) {
  master->part[npart]->ctl.portamento.portamento=(int) o->value();
}
void MasterUI::cb_simplepartportamento(Fl_Check_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_simplepartportamento_i(o,v);
}

void MasterUI::cb_simpleminkcounter_i(Fl_Counter* o, void*) {
  master->part[npart]->Pminkey=(int) o->value();
if (master->part[npart]->Pminkey>master->part[npart]->Pmaxkey) o->textcolor(FL_RED);
 else o->textcolor(FL_BLACK);
}
void MasterUI::cb_simpleminkcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_simpleminkcounter_i(o,v);
}

void MasterUI::cb_simplemaxkcounter_i(Fl_Counter* o, void*) {
  master->part[npart]->Pmaxkey=(int) o->value();

if (master->part[npart]->Pminkey>master->part[npart]->Pmaxkey) o->textcolor(FL_RED);
 else o->textcolor(FL_BLACK);
}
void MasterUI::cb_simplemaxkcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_simplemaxkcounter_i(o,v);
}

void MasterUI::cb_m_i(Fl_Button*, void*) {
  if (master->part[npart]->lastnote>=0) simpleminkcounter->value(master->part[npart]->lastnote);
simpleminkcounter->do_callback();
simplemaxkcounter->do_callback();
}
void MasterUI::cb_m(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_m_i(o,v);
}

void MasterUI::cb_M_i(Fl_Button*, void*) {
  if (master->part[npart]->lastnote>=0) simplemaxkcounter->value(master->part[npart]->lastnote);
simplemaxkcounter->do_callback();
simpleminkcounter->do_callback();
}
void MasterUI::cb_M(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_M_i(o,v);
}

void MasterUI::cb_R1_i(Fl_Button*, void*) {
  simpleminkcounter->value(0);
simpleminkcounter->do_callback();
simplemaxkcounter->value(127);
simplemaxkcounter->do_callback();
}
void MasterUI::cb_R1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_R1_i(o,v);
}

void MasterUI::cb_simplepartkeyshiftcounter_i(Fl_Counter* o, void*) {
  master->part[npart]->Pkeyshift=(int) o->value()+64;
}
void MasterUI::cb_simplepartkeyshiftcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_simplepartkeyshiftcounter_i(o,v);
}

void MasterUI::cb_simplesyseffsend_i(WidgetPDial* o, void*) {
  master->setPsysefxvol(npart,nsyseff,(int) o->value());
}
void MasterUI::cb_simplesyseffsend(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_simplesyseffsend_i(o,v);
}

void MasterUI::cb_partenabled1_i(Fl_Check_Button* o, void*) {
  pthread_mutex_lock(&master->mutex);
 master->partonoff(npart,(int) o->value());
pthread_mutex_unlock(&master->mutex);

if ((int) o->value()==0) simplelistitemgroup->deactivate();
  else {
    simplelistitemgroup->activate();
    if ((int)bankui->cbwig->value()!=(npart+1)){
       bankui->cbwig->value(npart+1);
       bankui->cbwig->do_callback();
    };
};

o->redraw();
}
void MasterUI::cb_partenabled1(Fl_Check_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_partenabled1_i(o,v);
}

void MasterUI::cb_simplesyseffnocounter_i(Fl_Counter* o, void*) {
  nsyseff=(int) o->value()-1;
simplesysefftype->value(master->sysefx[nsyseff]->geteffect());
simplesyseffectui->refresh(master->sysefx[nsyseff]);
simplerefresh();
}
void MasterUI::cb_simplesyseffnocounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_simplesyseffnocounter_i(o,v);
}

void MasterUI::cb_simplesysefftype_i(Fl_Choice* o, void*) {
  pthread_mutex_lock(&master->mutex);
master->sysefx[nsyseff]->changeeffect((int) o->value());
pthread_mutex_unlock(&master->mutex);
simplesyseffectui->refresh(master->sysefx[nsyseff]);
}
void MasterUI::cb_simplesysefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_simplesysefftype_i(o,v);
}

Fl_Menu_Item MasterUI::menu_simplesysefftype[] = {
 {"No Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Reverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"AlienWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Distortion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"EQ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DynFilter", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MasterUI::cb_Send1_i(Fl_Button*, void*) {
  syseffsendwindow->show();
}
void MasterUI::cb_Send1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Send1_i(o,v);
}

void MasterUI::cb_P2_i(Fl_Button*, void*) {
  pthread_mutex_lock(&master->mutex);
presetsui->paste(master->sysefx[nsyseff],simplesyseffectui);
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_P2(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_P2_i(o,v);
}

void MasterUI::cb_simpleinseffnocounter_i(Fl_Counter* o, void*) {
  ninseff=(int) o->value()-1;
simpleinsefftype->value(master->insefx[ninseff]->geteffect());
simpleinseffpart->value(master->Pinsparts[ninseff]+2);
simpleinseffectui->refresh(master->insefx[ninseff]);

if (master->Pinsparts[ninseff]!=-1) {
        simpleinsefftype->activate();
	simpleinseffectui->activate();
        simpleinseffectuigroup->activate();
} else {
	simpleinsefftype->deactivate();
 	simpleinseffectui->deactivate();
        simpleinseffectuigroup->deactivate();
};
}
void MasterUI::cb_simpleinseffnocounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_simpleinseffnocounter_i(o,v);
}

void MasterUI::cb_simpleinsefftype_i(Fl_Choice* o, void*) {
  pthread_mutex_lock(&master->mutex);
master->insefx[ninseff]->changeeffect((int) o->value());
pthread_mutex_unlock(&master->mutex);
simpleinseffectui->refresh(master->insefx[ninseff]);
simpleinseffectui->show();
}
void MasterUI::cb_simpleinsefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_simpleinsefftype_i(o,v);
}

Fl_Menu_Item MasterUI::menu_simpleinsefftype[] = {
 {"No Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Reverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"AlienWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Distortion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"EQ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DynFilter", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void MasterUI::cb_simpleinseffpart_i(Fl_Choice* o, void*) {
  master->Pinsparts[ninseff]=(int) o->value()-2;
if ((int) o->value()==1){
    simpleinseffectuigroup->deactivate();
    simpleinsefftype->deactivate();
    simpleinseffectui->deactivate();
} else {
    simpleinseffectuigroup->activate();
    simpleinsefftype->activate();
    simpleinseffectui->activate();
};
master->insefx[ninseff]->cleanup();
}
void MasterUI::cb_simpleinseffpart(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_simpleinseffpart_i(o,v);
}

void MasterUI::cb_P3_i(Fl_Button*, void*) {
  pthread_mutex_lock(&master->mutex);
presetsui->paste(master->insefx[ninseff],simpleinseffectui);
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_P3(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_P3_i(o,v);
}

void MasterUI::cb_simplemastervolumedial_i(WidgetPDial* o, void*) {
  master->setPvolume((int) o->value());
}
void MasterUI::cb_simplemastervolumedial(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_simplemastervolumedial_i(o,v);
}

void MasterUI::cb_simplemasterkeyshiftcounter_i(Fl_Counter* o, void*) {
  master->setPkeyshift((int) o->value()+64);
}
void MasterUI::cb_simplemasterkeyshiftcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_simplemasterkeyshiftcounter_i(o,v);
}

void MasterUI::cb_Stop_i(Fl_Button*, void*) {
  virkeyboard->relaseallkeys();
pthread_mutex_lock(&master->mutex);
master->shutup=1;
pthread_mutex_unlock(&master->mutex);
}
void MasterUI::cb_Stop(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Stop_i(o,v);
}

void MasterUI::cb_Reset_i(Fl_Button*, void*) {
  simpleglobalfinedetuneslider->value(64.0);
simpleglobalfinedetuneslider->do_callback();
}
void MasterUI::cb_Reset(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Reset_i(o,v);
}

void MasterUI::cb_simpleglobalfinedetuneslider_i(WidgetPDial* o, void*) {
  master->microtonal.Pglobalfinedetune=(int) o->value();
}
void MasterUI::cb_simpleglobalfinedetuneslider(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_simpleglobalfinedetuneslider_i(o,v);
}

void MasterUI::cb_simplenpartcounter_i(Fl_Counter* o, void*) {
  virkeys->relaseallkeys(0);
npartcounter->value(o->value());
npart=(int) o->value()-1;

simplerefresh();
virkeys->midich=master->part[npart]->Prcvchn;
}
void MasterUI::cb_simplenpartcounter(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_simplenpartcounter_i(o,v);
}

void MasterUI::cb_Keyb_i(Fl_Counter* o, void*) {
  virkeys->relaseallkeys(0);
virkeys->midioct=(int) o->value();
virkeys->take_focus();
}
void MasterUI::cb_Keyb(Fl_Counter* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Keyb_i(o,v);
}

void MasterUI::cb_selectuiwindow_i(Fl_Double_Window*, void*) {
  *exitprogram=1;
}
void MasterUI::cb_selectuiwindow(Fl_Double_Window* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_selectuiwindow_i(o,v);
}

void MasterUI::cb_Advanced_i(Fl_Button*, void*) {
  config.cfg.UserInterfaceMode=1;
masterwindow->show();
selectuiwindow->hide();
}
void MasterUI::cb_Advanced(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Advanced_i(o,v);
}

void MasterUI::cb_Beginner_i(Fl_Button*, void*) {
  simplemasterwindow->show();
selectuiwindow->hide();
config.cfg.UserInterfaceMode=2;
}
void MasterUI::cb_Beginner(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Beginner_i(o,v);
}

Fl_Double_Window* MasterUI::make_window() {
  { masterwindow = new Fl_Double_Window(390, 465, "zynaddsubfx");
    masterwindow->callback((Fl_Callback*)cb_masterwindow, (void*)(this));
    { mastermenu = new Fl_Menu_Bar(-5, 0, 690, 25);
      mastermenu->menu(menu_mastermenu);
    } // Fl_Menu_Bar* mastermenu
    { WidgetPDial* o = mastervolumedial = new WidgetPDial(5, 30, 30, 30, "M.Vol");
      mastervolumedial->tooltip("Master Volume");
      mastervolumedial->box(FL_ROUND_UP_BOX);
      mastervolumedial->color(FL_BACKGROUND_COLOR);
      mastervolumedial->selection_color(FL_INACTIVE_COLOR);
      mastervolumedial->labeltype(FL_NORMAL_LABEL);
      mastervolumedial->labelfont(1);
      mastervolumedial->labelsize(11);
      mastervolumedial->labelcolor(FL_FOREGROUND_COLOR);
      mastervolumedial->maximum(127);
      mastervolumedial->step(1);
      mastervolumedial->callback((Fl_Callback*)cb_mastervolumedial);
      mastervolumedial->align(Fl_Align(130));
      mastervolumedial->when(FL_WHEN_CHANGED);
      o->value(master->Pvolume);
    } // WidgetPDial* mastervolumedial
    { Fl_Counter* o = masterkeyshiftcounter = new Fl_Counter(45, 31, 90, 20, "Master KeyShift");
      masterkeyshiftcounter->labelsize(11);
      masterkeyshiftcounter->minimum(-64);
      masterkeyshiftcounter->maximum(64);
      masterkeyshiftcounter->step(1);
      masterkeyshiftcounter->callback((Fl_Callback*)cb_masterkeyshiftcounter);
      o->lstep(12);
      o->value(master->Pkeyshift-64);
    } // Fl_Counter* masterkeyshiftcounter
    { Fl_Button* o = new Fl_Button(293, 29, 92, 31, "Panic!");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)231);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Panic);
    } // Fl_Button* o
    { partuigroup = new Fl_Group(0, 242, 390, 183);
      partuigroup->box(FL_ENGRAVED_FRAME);
      { PartUI* o = partui = new PartUI(4, 245, 383, 175);
        partui->box(FL_FLAT_BOX);
        partui->color(FL_BACKGROUND_COLOR);
        partui->selection_color(FL_BACKGROUND_COLOR);
        partui->labeltype(FL_NORMAL_LABEL);
        partui->labelfont(0);
        partui->labelsize(14);
        partui->labelcolor(FL_FOREGROUND_COLOR);
        partui->align(Fl_Align(FL_ALIGN_TOP));
        partui->when(FL_WHEN_RELEASE);
        o->init(master->part[0],master,0,bankui);
        o->show();
        partui->end();
      } // PartUI* partui
      partuigroup->end();
    } // Fl_Group* partuigroup
    { Fl_Tabs* o = new Fl_Tabs(0, 80, 390, 160);
      { Fl_Group* o = new Fl_Group(0, 100, 390, 140, "System Effects");
        o->box(FL_ENGRAVED_FRAME);
        o->labeltype(FL_EMBOSSED_LABEL);
        o->labelsize(15);
        o->align(Fl_Align(FL_ALIGN_TOP_RIGHT|FL_ALIGN_INSIDE));
        { Fl_Counter* o = syseffnocounter = new Fl_Counter(5, 120, 80, 20, "Sys.Effect No.");
          syseffnocounter->type(1);
          syseffnocounter->labelfont(1);
          syseffnocounter->labelsize(10);
          syseffnocounter->minimum(0);
          syseffnocounter->maximum(127);
          syseffnocounter->step(1);
          syseffnocounter->value(1);
          syseffnocounter->textfont(1);
          syseffnocounter->callback((Fl_Callback*)cb_syseffnocounter);
          syseffnocounter->align(Fl_Align(FL_ALIGN_TOP));
          o->bounds(1,NUM_SYS_EFX);
          o->value(nsyseff+1);
        } // Fl_Counter* syseffnocounter
        { Fl_Choice* o = sysefftype = new Fl_Choice(315, 125, 70, 15, "EffType");
          sysefftype->down_box(FL_BORDER_BOX);
          sysefftype->labelsize(10);
          sysefftype->callback((Fl_Callback*)cb_sysefftype);
          sysefftype->menu(menu_sysefftype);
          o->value(master->sysefx[nsyseff]->geteffect());
        } // Fl_Choice* sysefftype
        { syseffectuigroup = new Fl_Group(5, 140, 380, 95);
          syseffectuigroup->box(FL_FLAT_BOX);
          syseffectuigroup->color((Fl_Color)48);
          { EffUI* o = syseffectui = new EffUI(5, 140, 380, 95);
            syseffectui->box(FL_NO_BOX);
            syseffectui->color(FL_BACKGROUND_COLOR);
            syseffectui->selection_color(FL_BACKGROUND_COLOR);
            syseffectui->labeltype(FL_NORMAL_LABEL);
            syseffectui->labelfont(0);
            syseffectui->labelsize(14);
            syseffectui->labelcolor(FL_FOREGROUND_COLOR);
            syseffectui->align(Fl_Align(FL_ALIGN_TOP));
            syseffectui->when(FL_WHEN_RELEASE);
            o->init(master->sysefx[nsyseff]);
            syseffectui->end();
          } // EffUI* syseffectui
          syseffectuigroup->end();
        } // Fl_Group* syseffectuigroup
        { Fl_Button* o = new Fl_Button(95, 120, 75, 20, "Send to...");
          o->box(FL_THIN_UP_BOX);
          o->labelfont(1);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Send);
        } // Fl_Button* o
        { Fl_Button* o = new Fl_Button(215, 124, 25, 15, "C");
          o->box(FL_THIN_UP_BOX);
          o->color((Fl_Color)179);
          o->labelfont(1);
          o->labelsize(11);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_C);
        } // Fl_Button* o
        { Fl_Button* o = new Fl_Button(245, 124, 25, 15, "P");
          o->box(FL_THIN_UP_BOX);
          o->color((Fl_Color)179);
          o->labelfont(1);
          o->labelsize(11);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_P);
        } // Fl_Button* o
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(0, 100, 390, 140, "Insertion Effects");
        o->box(FL_ENGRAVED_FRAME);
        o->labeltype(FL_EMBOSSED_LABEL);
        o->labelsize(15);
        o->align(Fl_Align(FL_ALIGN_TOP_RIGHT|FL_ALIGN_INSIDE));
        o->hide();
        { Fl_Counter* o = inseffnocounter = new Fl_Counter(5, 120, 80, 20, "Ins.Effect No.");
          inseffnocounter->type(1);
          inseffnocounter->labelfont(1);
          inseffnocounter->labelsize(10);
          inseffnocounter->minimum(0);
          inseffnocounter->maximum(127);
          inseffnocounter->step(1);
          inseffnocounter->value(1);
          inseffnocounter->textfont(1);
          inseffnocounter->callback((Fl_Callback*)cb_inseffnocounter);
          inseffnocounter->align(Fl_Align(FL_ALIGN_TOP));
          o->bounds(1,NUM_INS_EFX);
          o->value(ninseff+1);
        } // Fl_Counter* inseffnocounter
        { Fl_Choice* o = insefftype = new Fl_Choice(315, 125, 70, 15, "EffType");
          insefftype->down_box(FL_BORDER_BOX);
          insefftype->labelsize(10);
          insefftype->callback((Fl_Callback*)cb_insefftype);
          insefftype->menu(menu_insefftype);
          o->value(master->insefx[ninseff]->geteffect());
          if (master->Pinsparts[ninseff]== -1) o->deactivate();
        } // Fl_Choice* insefftype
        { inseffectuigroup = new Fl_Group(5, 140, 380, 95);
          inseffectuigroup->box(FL_FLAT_BOX);
          inseffectuigroup->color((Fl_Color)48);
          { EffUI* o = inseffectui = new EffUI(5, 140, 380, 95);
            inseffectui->box(FL_NO_BOX);
            inseffectui->color(FL_BACKGROUND_COLOR);
            inseffectui->selection_color(FL_BACKGROUND_COLOR);
            inseffectui->labeltype(FL_NORMAL_LABEL);
            inseffectui->labelfont(0);
            inseffectui->labelsize(14);
            inseffectui->labelcolor(FL_FOREGROUND_COLOR);
            inseffectui->align(Fl_Align(FL_ALIGN_TOP));
            inseffectui->when(FL_WHEN_RELEASE);
            o->init(master->insefx[ninseff]);
            if (master->Pinsparts[ninseff]== -1) o->deactivate();
            inseffectui->end();
          } // EffUI* inseffectui
          inseffectuigroup->end();
        } // Fl_Group* inseffectuigroup
        { Fl_Choice* o = inseffpart = new Fl_Choice(95, 120, 80, 20, "Insert To.");
          inseffpart->down_box(FL_BORDER_BOX);
          inseffpart->labelfont(1);
          inseffpart->labelsize(10);
          inseffpart->textsize(10);
          inseffpart->callback((Fl_Callback*)cb_inseffpart);
          inseffpart->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Master Out");o->add("Off");
          char tmp[50]; for (int i=0;i<NUM_MIDI_PARTS;i++) {sprintf(tmp,"Part %2d",i+1);o->add(tmp);};
          o->value(master->Pinsparts[ninseff]+2);
        } // Fl_Choice* inseffpart
        { Fl_Button* o = new Fl_Button(215, 124, 25, 15, "C");
          o->box(FL_THIN_UP_BOX);
          o->color((Fl_Color)179);
          o->labelfont(1);
          o->labelsize(11);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_C1);
        } // Fl_Button* o
        { Fl_Button* o = new Fl_Button(245, 124, 25, 15, "P");
          o->box(FL_THIN_UP_BOX);
          o->color((Fl_Color)179);
          o->labelfont(1);
          o->labelsize(11);
          o->labelcolor(FL_BACKGROUND2_COLOR);
          o->callback((Fl_Callback*)cb_P1);
        } // Fl_Button* o
        o->end();
      } // Fl_Group* o
      o->end();
    } // Fl_Tabs* o
    { Fl_Button* o = new Fl_Button(330, 80, 56, 19, "Scales");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)231);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_Scales);
    } // Fl_Button* o
    { Fl_Group* o = new Fl_Group(172, 30, 117, 45);
      o->box(FL_ENGRAVED_BOX);
      { recordbutton = new Fl_Button(181, 36, 21, 21, "Rec.");
        recordbutton->tooltip("Start Recording");
        recordbutton->box(FL_ROUND_UP_BOX);
        recordbutton->color(FL_RED);
        recordbutton->labelfont(1);
        recordbutton->labelsize(10);
        recordbutton->callback((Fl_Callback*)cb_recordbutton);
        recordbutton->align(Fl_Align(FL_ALIGN_BOTTOM));
        recordbutton->deactivate();
      } // Fl_Button* recordbutton
      { stopbutton = new Fl_Button(259, 36, 21, 21, "Stop");
        stopbutton->tooltip("Stop Recording and close the audio file");
        stopbutton->box(FL_THIN_UP_BOX);
        stopbutton->color((Fl_Color)4);
        stopbutton->labelfont(1);
        stopbutton->labelsize(10);
        stopbutton->callback((Fl_Callback*)cb_stopbutton);
        stopbutton->align(Fl_Align(FL_ALIGN_BOTTOM));
        stopbutton->deactivate();
      } // Fl_Button* stopbutton
      { pausebutton = new Fl_Button(220, 36, 21, 21, "@||");
        pausebutton->tooltip("Pause Recording");
        pausebutton->box(FL_THIN_UP_BOX);
        pausebutton->color((Fl_Color)4);
        pausebutton->selection_color((Fl_Color)4);
        pausebutton->labelfont(1);
        pausebutton->labelcolor((Fl_Color)3);
        pausebutton->callback((Fl_Callback*)cb_pausebutton);
        pausebutton->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        pausebutton->deactivate();
      } // Fl_Button* pausebutton
      { pauselabel = new Fl_Box(214, 56, 30, 15, "Pause");
        pauselabel->labelfont(1);
        pauselabel->labelsize(10);
        pauselabel->deactivate();
      } // Fl_Box* pauselabel
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(1, 427, 389, 33);
      o->box(FL_ENGRAVED_FRAME);
      { VUMeter* o = new VUMeter(4, 430, 384, 30, "VU-Meter");
        o->box(FL_FLAT_BOX);
        o->color((Fl_Color)48);
        o->selection_color((Fl_Color)75);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->init(master,-1);
      } // VUMeter* o
      o->end();
    } // Fl_Group* o
    { Fl_Check_Button* o = nrpnbutton = new Fl_Check_Button(45, 65, 47, 10, "NRPN");
      nrpnbutton->tooltip("Receive NRPNs");
      nrpnbutton->down_box(FL_DOWN_BOX);
      nrpnbutton->labelsize(10);
      nrpnbutton->callback((Fl_Callback*)cb_nrpnbutton);
      o->value(master->ctl.NRPN.receive);
    } // Fl_Check_Button* nrpnbutton
    { Fl_Counter* o = npartcounter = new Fl_Counter(5, 247, 70, 23);
      npartcounter->tooltip("The part number");
      npartcounter->type(1);
      npartcounter->labelfont(1);
      npartcounter->minimum(0);
      npartcounter->maximum(127);
      npartcounter->step(1);
      npartcounter->value(1);
      npartcounter->textfont(1);
      npartcounter->callback((Fl_Callback*)cb_npartcounter);
      o->bounds(1,NUM_MIDI_PARTS);
      bankui->init(o);
    } // Fl_Counter* npartcounter
    { Fl_Button* o = new Fl_Button(292, 80, 35, 19, "vK");
      o->tooltip("Virtual Keyboard");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)231);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_vK);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(140, 65, 30, 10, "R.D.");
      o->tooltip("Master fine detune reset");
      o->box(FL_THIN_UP_BOX);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_R);
    } // Fl_Button* o
    { WidgetPDial* o = globalfinedetuneslider = new WidgetPDial(143, 30, 20, 20, "F.Det.");
      globalfinedetuneslider->tooltip("global fine detune");
      globalfinedetuneslider->box(FL_ROUND_UP_BOX);
      globalfinedetuneslider->color(FL_BACKGROUND_COLOR);
      globalfinedetuneslider->selection_color(FL_INACTIVE_COLOR);
      globalfinedetuneslider->labeltype(FL_NORMAL_LABEL);
      globalfinedetuneslider->labelfont(0);
      globalfinedetuneslider->labelsize(10);
      globalfinedetuneslider->labelcolor(FL_FOREGROUND_COLOR);
      globalfinedetuneslider->maximum(127);
      globalfinedetuneslider->step(1);
      globalfinedetuneslider->value(64);
      globalfinedetuneslider->callback((Fl_Callback*)cb_globalfinedetuneslider);
      globalfinedetuneslider->align(Fl_Align(130));
      globalfinedetuneslider->when(FL_WHEN_CHANGED);
      o->value(master->microtonal.Pglobalfinedetune);
    } // WidgetPDial* globalfinedetuneslider
    { Fl_Button* o = new Fl_Button(293, 62, 92, 16, "Panel Window");
      o->tooltip("Panel Window");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)183);
      o->labelfont(1);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Panel);
    } // Fl_Button* o
    masterwindow->xclass("zynaddsubfx");
    masterwindow->end();
  } // Fl_Double_Window* masterwindow
  { aboutwindow = new Fl_Double_Window(365, 280, "Copyright...");
    aboutwindow->user_data((void*)(this));
    { Fl_Box* o = new Fl_Box(15, 35, 335, 55, "Copyright (c) 2002-2009 Nasca O. PAUL and others. Please read AUTHORS.txt");
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelsize(15);
      o->align(Fl_Align(192|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(15, 90, 335, 145, "This is free software; you may redistribute it and/or modify it under the ter\
ms of the \nversion 2 (or any later version) of the GNU General Public License\
 as published by the Free Software Fundation.\n  This program comes with\n ABS\
OLUTELY NO WARRANTY. \n See the version 2 (or any later version) of the \nGNU \
General Public License for details.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Button* o = new Fl_Button(80, 245, 190, 25, "Close this window");
      o->box(FL_THIN_UP_BOX);
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    { Fl_Box* o = new Fl_Box(15, 5, 335, 30, "ZynAddSubFX");
      o->labeltype(FL_EMBOSSED_LABEL);
      o->labelfont(1);
      o->labelsize(20);
      o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    aboutwindow->end();
  } // Fl_Double_Window* aboutwindow
  { syseffsendwindow = new Fl_Double_Window(120, 250, "System Effects Send");
    syseffsendwindow->user_data((void*)(this));
    { Fl_Scroll* o = new Fl_Scroll(0, 45, 120, 170);
      o->box(FL_FLAT_BOX);
      for (int neff1=0;neff1<NUM_SYS_EFX;neff1++) for (int neff2=neff1+1;neff2<NUM_SYS_EFX;neff2++)
      {syseffsend[neff1][neff2]=new SysEffSend(o->x()+(neff2-1)*35,o->y()+15+neff1*50,30,30);syseffsend[neff1][neff2]->label("aaa");syseffsend[neff1][neff2]->init(master,neff1,neff2);};
      o->end();
      Fl_Group::current()->resizable(o);
    } // Fl_Scroll* o
    { Fl_Button* o = new Fl_Button(25, 220, 80, 25, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close1);
    } // Fl_Button* o
    { Fl_Box* o = new Fl_Box(5, 5, 110, 35, "Send system effect\'s output to other system effects");
      o->labelsize(10);
      o->align(Fl_Align(192));
    } // Fl_Box* o
    syseffsendwindow->end();
  } // Fl_Double_Window* syseffsendwindow
  { panelwindow = new Fl_Double_Window(630, 635, "ZynAddSubFX Panel");
    panelwindow->user_data((void*)(this));
    { Fl_Scroll* o = new Fl_Scroll(0, 5, 570, 310);
      o->type(1);
      o->box(FL_THIN_UP_BOX);
      { Fl_Pack* o = new Fl_Pack(5, 10, 560, 285);
        o->type(1);
        for (int i=0;i<NUM_MIDI_PARTS/2;i++){panellistitem[i]=new Panellistitem(0,0,70,260,"");panellistitem[i]->init(master,i,bankui);}
        o->end();
      } // Fl_Pack* o
      o->end();
    } // Fl_Scroll* o
    { Fl_Scroll* o = new Fl_Scroll(0, 320, 570, 310);
      o->type(1);
      o->box(FL_THIN_UP_BOX);
      { Fl_Pack* o = new Fl_Pack(5, 325, 560, 285);
        o->type(1);
        for (int i=NUM_MIDI_PARTS/2;i<NUM_MIDI_PARTS;i++){panellistitem[i]=new Panellistitem(0,0,70,260,"");panellistitem[i]->init(master,i,bankui);}
        o->end();
      } // Fl_Pack* o
      o->end();
    } // Fl_Scroll* o
    { Fl_Button* o = new Fl_Button(575, 605, 50, 25, "Close");
      o->box(FL_THIN_UP_BOX);
      o->labelsize(13);
      o->callback((Fl_Callback*)cb_Close2);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(575, 570, 55, 25, "Refresh");
      o->box(FL_THIN_UP_BOX);
      o->labelsize(13);
      o->callback((Fl_Callback*)cb_Refresh);
    } // Fl_Button* o
    panelwindow->end();
  } // Fl_Double_Window* panelwindow
  { simplemasterwindow = new Fl_Double_Window(600, 335, "ZynAddSubFX");
    simplemasterwindow->callback((Fl_Callback*)cb_simplemasterwindow, (void*)(this));
    { Fl_Menu_Bar* o = new Fl_Menu_Bar(0, 0, 690, 25);
      o->menu(menu_);
    } // Fl_Menu_Bar* o
    { Fl_Group* o = simplelistitemgroup = new Fl_Group(125, 65, 215, 150);
      simplelistitemgroup->box(FL_ENGRAVED_BOX);
      { partname = new Fl_Button(130, 72, 205, 18);
        partname->box(FL_PLASTIC_THIN_DOWN_BOX);
        partname->down_box(FL_FLAT_BOX);
        partname->color((Fl_Color)247);
        partname->labelfont(1);
        partname->labelsize(11);
        partname->callback((Fl_Callback*)cb_partname1);
        partname->align(Fl_Align(192|FL_ALIGN_INSIDE));
      } // Fl_Button* partname
      { Fl_Slider* o = partpanning = new Fl_Slider(185, 95, 70, 15, "Pan");
        partpanning->type(5);
        partpanning->box(FL_FLAT_BOX);
        partpanning->maximum(127);
        partpanning->step(1);
        partpanning->value(64);
        partpanning->callback((Fl_Callback*)cb_partpanning1);
        o->value(master->part[npart]->Ppanning);
      } // Fl_Slider* partpanning
      { Fl_Choice* o = partrcv = new Fl_Choice(140, 157, 65, 18, "Midi Channel Receive");
        partrcv->tooltip("receive from Midi channel");
        partrcv->down_box(FL_BORDER_BOX);
        partrcv->labelsize(10);
        partrcv->textfont(1);
        partrcv->callback((Fl_Callback*)cb_partrcv1);
        partrcv->align(Fl_Align(130));
        char nrstr[10]; for(int i=0;i<NUM_MIDI_CHANNELS;i++){sprintf(nrstr,"Ch%d",i+1);if (i!=9) o->add(nrstr); else o->add("Dr10");};
        o->value(master->part[npart]->Prcvchn);
      } // Fl_Choice* partrcv
      { WidgetPDial* o = partvolume = new WidgetPDial(145, 95, 30, 30);
        partvolume->box(FL_OVAL_BOX);
        partvolume->color(FL_BACKGROUND_COLOR);
        partvolume->selection_color(FL_INACTIVE_COLOR);
        partvolume->labeltype(FL_NORMAL_LABEL);
        partvolume->labelfont(0);
        partvolume->labelsize(14);
        partvolume->labelcolor(FL_FOREGROUND_COLOR);
        partvolume->maximum(127);
        partvolume->step(1);
        partvolume->callback((Fl_Callback*)cb_partvolume1);
        partvolume->align(Fl_Align(FL_ALIGN_BOTTOM));
        partvolume->when(FL_WHEN_CHANGED);
        o->value(master->part[npart]->Pvolume);
      } // WidgetPDial* partvolume
      { new Fl_Box(130, 125, 60, 15, "Volume");
      } // Fl_Box* o
      { Fl_Check_Button* o = simplepartportamento = new Fl_Check_Button(260, 95, 75, 20, "Portamento");
        simplepartportamento->tooltip("Enable/Disable the portamento");
        simplepartportamento->down_box(FL_DOWN_BOX);
        simplepartportamento->labelfont(1);
        simplepartportamento->labelsize(10);
        simplepartportamento->callback((Fl_Callback*)cb_simplepartportamento);
        o->value(master->part[npart]->ctl.portamento.portamento);
      } // Fl_Check_Button* simplepartportamento
      { Fl_Counter* o = simpleminkcounter = new Fl_Counter(210, 158, 40, 15, "Min.key");
        simpleminkcounter->tooltip("Minimum key (that the part receives NoteOn messages)");
        simpleminkcounter->type(1);
        simpleminkcounter->labelfont(1);
        simpleminkcounter->labelsize(10);
        simpleminkcounter->minimum(0);
        simpleminkcounter->maximum(127);
        simpleminkcounter->step(1);
        simpleminkcounter->textsize(10);
        simpleminkcounter->callback((Fl_Callback*)cb_simpleminkcounter);
        o->value(master->part[npart]->Pminkey);
      } // Fl_Counter* simpleminkcounter
      { Fl_Counter* o = simplemaxkcounter = new Fl_Counter(255, 158, 40, 15, "Max.key");
        simplemaxkcounter->tooltip("Maximum key (that the part receives NoteOn messages)");
        simplemaxkcounter->type(1);
        simplemaxkcounter->labelfont(1);
        simplemaxkcounter->labelsize(10);
        simplemaxkcounter->minimum(0);
        simplemaxkcounter->maximum(127);
        simplemaxkcounter->step(1);
        simplemaxkcounter->textsize(10);
        simplemaxkcounter->callback((Fl_Callback*)cb_simplemaxkcounter);
        o->value(master->part[npart]->Pmaxkey);
      } // Fl_Counter* simplemaxkcounter
      { Fl_Button* o = new Fl_Button(230, 188, 15, 12, "m");
        o->tooltip("set the minimum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_m);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(260, 188, 15, 12, "M");
        o->tooltip("set the maximum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_M);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(245, 188, 15, 12, "R");
        o->tooltip("reset the minimum key to 0 and maximum key to 127");
        o->box(FL_THIN_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_R1);
      } // Fl_Button* o
      { Fl_Counter* o = simplepartkeyshiftcounter = new Fl_Counter(240, 120, 90, 20, "KeyShift");
        simplepartkeyshiftcounter->labelsize(11);
        simplepartkeyshiftcounter->minimum(-64);
        simplepartkeyshiftcounter->maximum(64);
        simplepartkeyshiftcounter->step(1);
        simplepartkeyshiftcounter->callback((Fl_Callback*)cb_simplepartkeyshiftcounter);
        o->lstep(12);
        o->value(master->part[npart]->Pkeyshift-64);
      } // Fl_Counter* simplepartkeyshiftcounter
      { simplesyseffsend = new WidgetPDial(300, 160, 30, 30);
        simplesyseffsend->box(FL_OVAL_BOX);
        simplesyseffsend->color(FL_BACKGROUND_COLOR);
        simplesyseffsend->selection_color(FL_INACTIVE_COLOR);
        simplesyseffsend->labeltype(FL_NORMAL_LABEL);
        simplesyseffsend->labelfont(0);
        simplesyseffsend->labelsize(14);
        simplesyseffsend->labelcolor(FL_FOREGROUND_COLOR);
        simplesyseffsend->maximum(127);
        simplesyseffsend->step(1);
        simplesyseffsend->callback((Fl_Callback*)cb_simplesyseffsend);
        simplesyseffsend->align(Fl_Align(FL_ALIGN_BOTTOM));
        simplesyseffsend->when(FL_WHEN_CHANGED);
      } // WidgetPDial* simplesyseffsend
      { new Fl_Box(295, 190, 40, 15, "Effect");
      } // Fl_Box* o
      if (master->part[npart]->Penabled==0) o->deactivate();
      simplelistitemgroup->end();
    } // Fl_Group* simplelistitemgroup
    { Fl_Check_Button* o = partenabled = new Fl_Check_Button(250, 40, 85, 20, "Enabled");
      partenabled->down_box(FL_DOWN_BOX);
      partenabled->labeltype(FL_EMBOSSED_LABEL);
      partenabled->labelfont(1);
      partenabled->labelsize(13);
      partenabled->callback((Fl_Callback*)cb_partenabled1);
      partenabled->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
      //char tmp[10];snprintf(tmp,10,"%d",npart+1);o->copy_label(tmp);
      o->value(master->part[npart]->Penabled);
    } // Fl_Check_Button* partenabled
    { VirKeys* o = virkeys = new VirKeys(5, 215, 590, 80, "Keyboard");
      virkeys->box(FL_BORDER_BOX);
      virkeys->color((Fl_Color)17);
      virkeys->selection_color(FL_BACKGROUND_COLOR);
      virkeys->labeltype(FL_NORMAL_LABEL);
      virkeys->labelfont(0);
      virkeys->labelsize(14);
      virkeys->labelcolor(FL_FOREGROUND_COLOR);
      virkeys->align(Fl_Align(FL_ALIGN_CENTER));
      virkeys->when(FL_WHEN_RELEASE);
      o->init(master);
    } // VirKeys* virkeys
    { Fl_Group* o = new Fl_Group(340, 30, 255, 185);
      o->box(FL_ENGRAVED_BOX);
      { Fl_Tabs* o = new Fl_Tabs(345, 35, 245, 175);
        o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
        { Fl_Group* o = new Fl_Group(345, 55, 245, 155, "System Effects");
          o->box(FL_ENGRAVED_FRAME);
          o->labelfont(1);
          o->labelsize(12);
          o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
          o->hide();
          { Fl_Counter* o = simplesyseffnocounter = new Fl_Counter(350, 75, 80, 20, "Sys.Effect No.");
            simplesyseffnocounter->type(1);
            simplesyseffnocounter->labelfont(1);
            simplesyseffnocounter->labelsize(10);
            simplesyseffnocounter->minimum(0);
            simplesyseffnocounter->maximum(127);
            simplesyseffnocounter->step(1);
            simplesyseffnocounter->value(1);
            simplesyseffnocounter->textfont(1);
            simplesyseffnocounter->callback((Fl_Callback*)cb_simplesyseffnocounter);
            simplesyseffnocounter->align(Fl_Align(FL_ALIGN_TOP));
            o->bounds(1,NUM_SYS_EFX);
            o->value(nsyseff+1);
          } // Fl_Counter* simplesyseffnocounter
          { Fl_Choice* o = simplesysefftype = new Fl_Choice(515, 80, 70, 15, "EffType");
            simplesysefftype->down_box(FL_BORDER_BOX);
            simplesysefftype->labelsize(10);
            simplesysefftype->callback((Fl_Callback*)cb_simplesysefftype);
            simplesysefftype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            simplesysefftype->menu(menu_simplesysefftype);
            o->value(master->sysefx[nsyseff]->geteffect());
          } // Fl_Choice* simplesysefftype
          { simplesyseffectuigroup = new Fl_Group(350, 95, 235, 95);
            simplesyseffectuigroup->box(FL_FLAT_BOX);
            simplesyseffectuigroup->color((Fl_Color)48);
            { SimpleEffUI* o = simplesyseffectui = new SimpleEffUI(350, 95, 234, 95);
              simplesyseffectui->box(FL_NO_BOX);
              simplesyseffectui->color(FL_BACKGROUND_COLOR);
              simplesyseffectui->selection_color(FL_BACKGROUND_COLOR);
              simplesyseffectui->labeltype(FL_NORMAL_LABEL);
              simplesyseffectui->labelfont(0);
              simplesyseffectui->labelsize(14);
              simplesyseffectui->labelcolor(FL_FOREGROUND_COLOR);
              simplesyseffectui->align(Fl_Align(FL_ALIGN_TOP));
              simplesyseffectui->when(FL_WHEN_RELEASE);
              o->init(master->sysefx[nsyseff]);
              simplesyseffectui->end();
            } // SimpleEffUI* simplesyseffectui
            simplesyseffectuigroup->end();
          } // Fl_Group* simplesyseffectuigroup
          { Fl_Button* o = new Fl_Button(435, 75, 75, 20, "Send to...");
            o->box(FL_THIN_UP_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->callback((Fl_Callback*)cb_Send1);
          } // Fl_Button* o
          { Fl_Button* o = new Fl_Button(560, 65, 25, 15, "P");
            o->box(FL_THIN_UP_BOX);
            o->color((Fl_Color)179);
            o->labelfont(1);
            o->labelsize(11);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_P2);
          } // Fl_Button* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(345, 55, 245, 155, "Insertion Effects");
          o->box(FL_ENGRAVED_FRAME);
          o->labelfont(1);
          o->labelsize(12);
          o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
          { Fl_Counter* o = simpleinseffnocounter = new Fl_Counter(350, 75, 80, 20, "Ins.Effect No.");
            simpleinseffnocounter->type(1);
            simpleinseffnocounter->labelfont(1);
            simpleinseffnocounter->labelsize(10);
            simpleinseffnocounter->minimum(0);
            simpleinseffnocounter->maximum(127);
            simpleinseffnocounter->step(1);
            simpleinseffnocounter->value(1);
            simpleinseffnocounter->textfont(1);
            simpleinseffnocounter->callback((Fl_Callback*)cb_simpleinseffnocounter);
            simpleinseffnocounter->align(Fl_Align(FL_ALIGN_TOP));
            o->bounds(1,NUM_INS_EFX);
            o->value(ninseff+1);
          } // Fl_Counter* simpleinseffnocounter
          { Fl_Choice* o = simpleinsefftype = new Fl_Choice(515, 80, 70, 15, "EffType");
            simpleinsefftype->down_box(FL_BORDER_BOX);
            simpleinsefftype->labelsize(10);
            simpleinsefftype->callback((Fl_Callback*)cb_simpleinsefftype);
            simpleinsefftype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            simpleinsefftype->menu(menu_simpleinsefftype);
            o->value(master->insefx[ninseff]->geteffect());
            if (master->Pinsparts[ninseff]== -1) o->deactivate();
          } // Fl_Choice* simpleinsefftype
          { simpleinseffectuigroup = new Fl_Group(350, 95, 234, 95);
            simpleinseffectuigroup->box(FL_FLAT_BOX);
            simpleinseffectuigroup->color((Fl_Color)48);
            { SimpleEffUI* o = simpleinseffectui = new SimpleEffUI(350, 95, 234, 95);
              simpleinseffectui->box(FL_NO_BOX);
              simpleinseffectui->color(FL_BACKGROUND_COLOR);
              simpleinseffectui->selection_color(FL_BACKGROUND_COLOR);
              simpleinseffectui->labeltype(FL_NORMAL_LABEL);
              simpleinseffectui->labelfont(0);
              simpleinseffectui->labelsize(14);
              simpleinseffectui->labelcolor(FL_FOREGROUND_COLOR);
              simpleinseffectui->align(Fl_Align(FL_ALIGN_TOP));
              simpleinseffectui->when(FL_WHEN_RELEASE);
              o->init(master->insefx[ninseff]);
              if (master->Pinsparts[ninseff]== -1) o->deactivate();
              simpleinseffectui->end();
            } // SimpleEffUI* simpleinseffectui
            simpleinseffectuigroup->end();
          } // Fl_Group* simpleinseffectuigroup
          { Fl_Choice* o = simpleinseffpart = new Fl_Choice(435, 75, 80, 20, "Insert To.");
            simpleinseffpart->down_box(FL_BORDER_BOX);
            simpleinseffpart->labelfont(1);
            simpleinseffpart->labelsize(10);
            simpleinseffpart->textsize(10);
            simpleinseffpart->callback((Fl_Callback*)cb_simpleinseffpart);
            simpleinseffpart->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("Master Out");o->add("Off");
            char tmp[50]; for (int i=0;i<NUM_MIDI_PARTS;i++) {sprintf(tmp,"Part %2d",i+1);o->add(tmp);};
            o->value(master->Pinsparts[ninseff]+2);
          } // Fl_Choice* simpleinseffpart
          { Fl_Button* o = new Fl_Button(560, 65, 25, 15, "P");
            o->box(FL_THIN_UP_BOX);
            o->color((Fl_Color)179);
            o->labelfont(1);
            o->labelsize(11);
            o->labelcolor(FL_BACKGROUND2_COLOR);
            o->callback((Fl_Callback*)cb_P3);
          } // Fl_Button* o
          o->end();
        } // Fl_Group* o
        o->end();
      } // Fl_Tabs* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(5, 300, 590, 30);
      o->box(FL_ENGRAVED_FRAME);
      { VUMeter* o = new VUMeter(5, 300, 590, 30, "VU-Meter");
        o->box(FL_FLAT_BOX);
        o->color((Fl_Color)41);
        o->selection_color((Fl_Color)75);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(14);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->align(Fl_Align(FL_ALIGN_CENTER));
        o->when(FL_WHEN_RELEASE);
        o->init(master,-1);
      } // VUMeter* o
      o->end();
    } // Fl_Group* o
    { WidgetPDial* o = simplemastervolumedial = new WidgetPDial(10, 35, 40, 40, "Master Volume");
      simplemastervolumedial->tooltip("Master Volume");
      simplemastervolumedial->box(FL_ROUND_UP_BOX);
      simplemastervolumedial->color(FL_BACKGROUND_COLOR);
      simplemastervolumedial->selection_color(FL_INACTIVE_COLOR);
      simplemastervolumedial->labeltype(FL_NORMAL_LABEL);
      simplemastervolumedial->labelfont(1);
      simplemastervolumedial->labelsize(11);
      simplemastervolumedial->labelcolor(FL_FOREGROUND_COLOR);
      simplemastervolumedial->maximum(127);
      simplemastervolumedial->step(1);
      simplemastervolumedial->callback((Fl_Callback*)cb_simplemastervolumedial);
      simplemastervolumedial->align(Fl_Align(130));
      simplemastervolumedial->when(FL_WHEN_CHANGED);
      o->value(master->Pvolume);
    } // WidgetPDial* simplemastervolumedial
    { Fl_Counter* o = simplemasterkeyshiftcounter = new Fl_Counter(25, 110, 90, 20, "Master KeyShift");
      simplemasterkeyshiftcounter->labelsize(11);
      simplemasterkeyshiftcounter->minimum(-64);
      simplemasterkeyshiftcounter->maximum(64);
      simplemasterkeyshiftcounter->step(1);
      simplemasterkeyshiftcounter->callback((Fl_Callback*)cb_simplemasterkeyshiftcounter);
      o->lstep(12);
      o->value(master->Pkeyshift-64);
    } // Fl_Counter* simplemasterkeyshiftcounter
    { Fl_Button* o = new Fl_Button(5, 149, 115, 31, "Stop ALL sounds!");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)231);
      o->labelfont(1);
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Stop);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(70, 32, 50, 10, "Reset");
      o->tooltip("Master fine detune reset");
      o->box(FL_THIN_UP_BOX);
      o->labelfont(1);
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Reset);
      o->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Button* o
    { WidgetPDial* o = simpleglobalfinedetuneslider = new WidgetPDial(80, 45, 30, 30, "Fine Detune");
      simpleglobalfinedetuneslider->tooltip("global fine detune");
      simpleglobalfinedetuneslider->box(FL_ROUND_UP_BOX);
      simpleglobalfinedetuneslider->color(FL_BACKGROUND_COLOR);
      simpleglobalfinedetuneslider->selection_color(FL_INACTIVE_COLOR);
      simpleglobalfinedetuneslider->labeltype(FL_NORMAL_LABEL);
      simpleglobalfinedetuneslider->labelfont(0);
      simpleglobalfinedetuneslider->labelsize(11);
      simpleglobalfinedetuneslider->labelcolor(FL_FOREGROUND_COLOR);
      simpleglobalfinedetuneslider->maximum(127);
      simpleglobalfinedetuneslider->step(1);
      simpleglobalfinedetuneslider->value(64);
      simpleglobalfinedetuneslider->callback((Fl_Callback*)cb_simpleglobalfinedetuneslider);
      simpleglobalfinedetuneslider->align(Fl_Align(130));
      simpleglobalfinedetuneslider->when(FL_WHEN_CHANGED);
      o->value(master->microtonal.Pglobalfinedetune);
    } // WidgetPDial* simpleglobalfinedetuneslider
    { Fl_Counter* o = simplenpartcounter = new Fl_Counter(170, 40, 70, 20, "Part");
      simplenpartcounter->tooltip("The part number");
      simplenpartcounter->type(1);
      simplenpartcounter->labelfont(1);
      simplenpartcounter->minimum(0);
      simplenpartcounter->maximum(127);
      simplenpartcounter->step(1);
      simplenpartcounter->value(1);
      simplenpartcounter->textfont(1);
      simplenpartcounter->callback((Fl_Callback*)cb_simplenpartcounter);
      simplenpartcounter->align(Fl_Align(FL_ALIGN_LEFT));
      o->bounds(1,NUM_MIDI_PARTS);
    } // Fl_Counter* simplenpartcounter
    { Fl_Counter* o = new Fl_Counter(5, 195, 55, 20, "Keyb.Oct.");
      o->tooltip("Midi Octave");
      o->type(1);
      o->labelsize(11);
      o->minimum(0);
      o->maximum(5);
      o->step(1);
      o->textfont(1);
      o->textsize(11);
      o->callback((Fl_Callback*)cb_Keyb);
      o->align(Fl_Align(FL_ALIGN_RIGHT));
      o->when(FL_WHEN_RELEASE_ALWAYS);
      o->value(virkeys->midioct);
    } // Fl_Counter* o
    simplemasterwindow->end();
  } // Fl_Double_Window* simplemasterwindow
  { selectuiwindow = new Fl_Double_Window(430, 250, "User Interface mode");
    selectuiwindow->callback((Fl_Callback*)cb_selectuiwindow, (void*)(this));
    { Fl_Box* o = new Fl_Box(5, 5, 425, 40, "Welcome to ZynAddSubFX");
      o->labeltype(FL_SHADOW_LABEL);
      o->labelfont(1);
      o->labelsize(26);
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(10, 50, 265, 25, "Please choose the interface mode:");
      o->labelfont(1);
      o->labelsize(13);
    } // Fl_Box* o
    { Fl_Button* o = new Fl_Button(10, 165, 100, 35, "Advanced");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)229);
      o->labelfont(1);
      o->labelsize(16);
      o->callback((Fl_Callback*)cb_Advanced);
    } // Fl_Button* o
    { Fl_Box* o = new Fl_Box(110, 165, 310, 35, ".. if you have used ZynAddSubFX before, or you like to have full controll to \
all parameters.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Button* o = new Fl_Button(10, 80, 100, 65, "Beginner");
      o->box(FL_PLASTIC_UP_BOX);
      o->color((Fl_Color)238);
      o->labelfont(1);
      o->labelsize(16);
      o->callback((Fl_Callback*)cb_Beginner);
    } // Fl_Button* o
    { Fl_Box* o = new Fl_Box(110, 75, 320, 75, "..if you are a beginner, you prefer using presets or you prefer to use simple\
r user interfaces. Most functionality of ZynAddSubFX will be hidden in this mo\
de to make simple the learning/using it.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(30, 215, 360, 25, "You can switch the interface modes anytime you want.");
      o->box(FL_BORDER_BOX);
      o->color((Fl_Color)51);
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    selectuiwindow->set_non_modal();
    selectuiwindow->end();
  } // Fl_Double_Window* selectuiwindow
  return selectuiwindow;
}

void MasterUI::updatesendwindow() {
  for (int neff1=0;neff1<NUM_SYS_EFX;neff1++) 
    for (int neff2=neff1+1;neff2<NUM_SYS_EFX;neff2++)
      syseffsend[neff1][neff2]->value(master->Psysefxsend[neff1][neff2]);
}

void MasterUI::updatepanel() {
  for (int npart=0;npart<NUM_MIDI_PARTS;npart++){
    panellistitem[npart]->refresh();
  };
}

void MasterUI::setfilelabel(const char *filename) {
  if (filename!=NULL) snprintf(&masterwindowlabel[0],100,"%s - ZynAddSubFX",fl_filename_name(filename));
    else snprintf(&masterwindowlabel[0],100,"%s","ZynAddSubFX");
  masterwindowlabel[99]='\0';
  masterwindow->label(&masterwindowlabel[0]);
  simplemasterwindow->label(&masterwindowlabel[0]);
}

MasterUI::MasterUI(Master *master_,int *exitprogram_) {
  master=master_;
  exitprogram=exitprogram_;
  ninseff=0;
  nsyseff=0;
  npart=0;
  
  for (int i=0;i<NUM_SYS_EFX;i++)
     for (int j=0;j<NUM_SYS_EFX;j++)
       syseffsend[i][j]=NULL;
  
  microtonalui=new MicrotonalUI(&master->microtonal);
  virkeyboard=new VirKeyboard(master);
  bankui=new BankUI(master,&npart);
  configui=new ConfigUI();
  sequi=new SeqUI(master);
  
  make_window();
  #ifdef OS_WINDOWS
  masterwindow->icon((char *)LoadIcon(GetModuleHandle(NULL), "zynaddsubfx_icon"));
  #endif
  presetsui=new PresetsUI();
  setfilelabel(NULL);
  swapefftype=0;
  simplerefresh();
}

MasterUI::~MasterUI() {
  masterwindow->hide();
  delete masterwindow;
  simplemasterwindow->hide();
  delete simplemasterwindow;
  aboutwindow->hide();
  delete aboutwindow;
  syseffsendwindow->hide();
  delete syseffsendwindow;
  
  delete virkeyboard;
  delete microtonalui;
  delete bankui;
  delete configui;
  delete sequi;
  
  delete presetsui;
  delete panelwindow;
  delete selectuiwindow;
}

void MasterUI::showUI() {
  switch (config.cfg.UserInterfaceMode){
  	case 0:selectuiwindow->show();
  	break;
  	case 1:masterwindow->show();
  	break;
  	case 2:simplemasterwindow->show();
  	break;
  };
}

void MasterUI::simplerefresh() {
  partenabled->value(master->part[npart]->Penabled);
  if (master->part[npart]->Penabled!=0) simplelistitemgroup->activate();
       else simplelistitemgroup->deactivate();
  
  partvolume->value(master->part[npart]->Pvolume);
  partpanning->value(master->part[npart]->Ppanning);
  partrcv->value(master->part[npart]->Prcvchn);
  
  if (master->part[npart]->Pname[0]!=0) partname->label((char *)master->part[npart]->Pname);
  	else partname->label("Click here to load a instrument");
  
  simplelistitemgroup->redraw();
  simplepartportamento->value(master->part[npart]->ctl.portamento.portamento);
  simpleminkcounter->value(master->part[npart]->Pminkey);
  simplemaxkcounter->value(master->part[npart]->Pmaxkey);
  
  simplepartkeyshiftcounter->value(master->part[npart]->Pkeyshift-64);
  simplesyseffsend->value(master->Psysefxvol[nsyseff][npart]);
}

void MasterUI::do_new_master() {
  if (fl_choice("Clear *ALL* the parameters ?","No","Yes",NULL)){
         delete microtonalui;
  
         pthread_mutex_lock(&master->mutex);
  	master->defaults();
         pthread_mutex_unlock(&master->mutex);
  	
         npartcounter->value(1);
         refresh_master_ui();
  
  };
  
  updatepanel();
}

void MasterUI::do_load_master(const char* file ) {
  const char *filename;
    if (file == NULL) {
      filename=fl_file_chooser("Open:","({*.xmz})",NULL,0);
      if (filename==NULL) return;
    }
    else {
      filename = file;
    }
  
  
  pthread_mutex_lock(&master->mutex);
    //clear all parameters
    master->defaults();
  
    //load the data
    int result=master->loadXML(filename);
  pthread_mutex_unlock(&master->mutex);
  master->applyparameters();
  
  npartcounter->value(1);
  refresh_master_ui();
  updatepanel();
  if (result>=0) setfilelabel(filename);
  
  
  if (result==-10) fl_alert("Error: Could not load the file\nbecause it is not a zynaddsubfx parameters file.");
        else if (result<0) fl_alert("Error: Could not load the file.");
}

void MasterUI::do_save_master(const char* file ) {
  const char *filename;
  char *tmp;
    int result=0;
    if (file == NULL) {
      tmp=fl_file_chooser("Save:","({*.xmz})",NULL,0);
      if (tmp==NULL) return;
      tmp=fl_filename_setext(tmp,".xmz");
      filename=tmp;
      result=fileexists(tmp);
      if (result) {
        result=0;
        if (!fl_choice("The file exists. Overwrite it?","No","Yes",NULL)) return;
        
      }
    }
    else {
      filename = file;
    }
  
  
  pthread_mutex_lock(&master->mutex);
  result=master->saveXML(filename);
  pthread_mutex_unlock(&master->mutex);
  
  if (result<0) fl_alert("Error: Could not save the file.");
  	else setfilelabel(filename);
  
  updatepanel();
}

void MasterUI::refresh_master_ui() {
  ninseff=0;
  nsyseff=0;
  npart=0;
  
  //the Master UI
  npartcounter->do_callback();
  syseffnocounter->do_callback();
  inseffnocounter->do_callback();
  masterkeyshiftcounter->value(master->Pkeyshift-64);
  mastervolumedial->value(master->Pvolume);    
  globalfinedetuneslider->value(master->microtonal.Pglobalfinedetune);   
  microtonalui=new MicrotonalUI(&master->microtonal);
  nrpnbutton->value(master->ctl.NRPN.receive);
  updatesendwindow();
  updatepanel();
  
  //the simle MasterUI
  simplenpartcounter->value(1);
  simplesyseffnocounter->value(1);
  simpleinseffnocounter->value(1);
  simplenpartcounter->do_callback();
  simplesyseffnocounter->do_callback();
  simpleinseffnocounter->do_callback();
  simplemasterkeyshiftcounter->value(master->Pkeyshift-64);
  simplemastervolumedial->value(master->Pvolume);    
  simpleglobalfinedetuneslider->value(master->microtonal.Pglobalfinedetune);
  virkeys->midich=master->part[npart]->Prcvchn;
  
  simplerefresh();
  bankui->hide();
}
