#
# Macro:      AX_LIB_CHECKS
# Author:     Heiko Hund <heiko@ist.eigentlich.net>
# Version:    $Revision$ $Date$
# Parameters: LIBRARY SYMBOL HEADER [EXTRA_LIBS]
# Requires:   none
# Output:     @<LIBRARY>_LDFLAGS@  - additional library search path
#             @<LIBRARY>_CPPFLAGS@ - additional library headers search path
#             @<LIBRARY>_LIBS@     - the libraries that need to be linked
# Defines:    HAVE_LIB<LIBRARY>    - set 1 if you have it installed and working
#
AC_DEFUN([AX_LIB_CHECKS],
[dnl
	_ldflags="$LDFLAGS"
	_cppflags="$CPPFLAGS"

	AC_ARG_WITH(m4_translit([$1], [_], [-]),
		[AS_HELP_STRING([--with-]m4_translit([$1], [_], [-])[=DIR],
		                [search for $1 files in DIR/lib and DIR/include])],
		[dnl
			if test -d $withval
			then
				LDFLAGS="-L$withval/lib $_ldflags"
				CPPFLAGS="-I$withval/include $_cppflags"
				AC_SUBST(m4_translit([$1], [a-z-], [A-Z_])[_LDFLAGS], [-L$withval/lib])
				AC_SUBST(m4_translit([$1], [a-z-], [A-Z_])[_CPPFLAGS], [-I$withval/include])
			else
				AC_MSG_ERROR([$withval: No such directory])
			fi
		]
	)

	AC_ARG_WITH(m4_translit([$1], [_], [-])[-lib],
		[AS_HELP_STRING([--with-]m4_translit([$1], [_], [-])[-lib=DIR],
		                [search for $1 library in DIR])],
		[dnl
			if test -d $withval
			then
				LDFLAGS="-L$withval $_ldflags"
				AC_SUBST(m4_translit([$1], [a-z-], [A-Z_])[_LDFLAGS], [-L$withval])
			else
				AC_MSG_ERROR([$withval: No such directory])
			fi
		]
	)

	AC_ARG_WITH(m4_translit([$1], [_], [-])[-includes],
		[AS_HELP_STRING([--with-]m4_translit([$1], [_], [-])[-includes=DIR],
		                [search for $1 library header files in DIR])],
		[dnl
			if test -d $withval
			then
				CPPFLAGS="-I$withval $_cppflags"
				AC_SUBST(m4_translit([$1], [a-z-], [A-Z_])[_CPPFLAGS], [-I$withval])
			else
				AC_MSG_ERROR([$withval: No such directory])
			fi
		]
	)

	AC_CHECK_LIB([$1], [$2], [true], [AC_MSG_ERROR([$1 library could not be found. You might want to
                  specify a search path using `--with-]m4_translit([$1], [_], [-])[[[-lib]]'.])], [$4])
	AC_CHECK_HEADER([$3], , [AC_MSG_ERROR([$1 library headers could not be found. You might want to
	          specify a search path using `--with-]m4_translit([$1], [_], [-])[-includes'.])])

	AC_SUBST(m4_translit([$1], [a-z-], [A-Z_])[_LIBS], [-l$1])
	AC_DEFINE([HAVE_LIB]m4_translit([$1], [a-z-], [A-Z_]), [1],
	          [Define to 1 if you have the `$1' library (-l$1).])

	CPPFLAGS="$_cppflags"
	LDFLAGS="$_ldflags"
])