------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2003-2012, AdaCore                     --
--                                                                          --
--  This library is free software;  you can redistribute it and/or modify   --
--  it under terms of the  GNU General Public License  as published by the  --
--  Free Software  Foundation;  either version 3,  or (at your  option) any --
--  later version. This library is distributed in the hope that it will be  --
--  useful, but WITHOUT ANY WARRANTY;  without even the implied warranty of --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--  You should have received a copy of the GNU General Public License and   --
--  a copy of the GCC Runtime Library Exception along with this program;    --
--  see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see   --
--  <http://www.gnu.org/licenses/>.                                         --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

package body SOAP.Dispatchers.Callback is

   -----------
   -- Clone --
   -----------

   overriding function Clone (Dispatch : Handler) return Handler is
   begin
      return (Dispatchers.Handler
              with Dispatch.HTTP_Callback, Dispatch.SOAP_Callback);
   end Clone;

   ------------
   -- Create --
   ------------

   function Create
     (HTTP_Callback : AWS.Response.Callback;
      SOAP_Callback : Dispatchers.SOAP_Callback) return Handler is
   begin
      return (Dispatchers.Handler with HTTP_Callback, SOAP_Callback);
   end Create;

   -------------------
   -- Dispatch_HTTP --
   -------------------

   overriding function Dispatch_HTTP
     (Dispatcher : Handler;
      Request    : AWS.Status.Data) return AWS.Response.Data is
   begin
      return Dispatcher.HTTP_Callback (Request);
   end Dispatch_HTTP;

   -------------------
   -- Dispatch_SOAP --
   -------------------

   overriding function Dispatch_SOAP
     (Dispatcher : Handler;
      SOAPAction : String;
      Payload    : Message.Payload.Object;
      Request    : AWS.Status.Data) return AWS.Response.Data is
   begin
      return Dispatcher.SOAP_Callback (SOAPAction, Payload, Request);
   end Dispatch_SOAP;

end SOAP.Dispatchers.Callback;
