/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployment.spi;

import java.io.Serializable;

/**
 * Encapsulation of a deployment endpoint
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class EndpointInfo implements Serializable
{
   private static final long serialVersionUID = 1;
   /** VFS relative path of the endpoints deployment */
   private String pathName;
   /** The deployment unique component name */
   private String name;
   /** The endpoint type */
   private String type;

   /**
    * @param pathName - the vfs relative path of the deployment containing the endpoint
    * @param name - the deployment local unique name of the endpoing
    * @param type - the endpoint type(ejb, message-destination, ...)
    * @see EndpointType
    */
   public EndpointInfo(String pathName, String name, String type)
   {
      super();
      this.pathName = pathName;
      this.name = name;
      this.type = type;
   }

   /**
    * @return the vfs relative path for the endpoint's deployment
    */
   public String getPathName()
   {
      return pathName;
   }
   /**
    * 
    * @return the deployment local unique name of the endpoing
    */
   public String getName()
   {
      return name;
   }
   /**
    * @return the endpoint type(ejb, message-destination, ...)
    * @see EndpointType
    */
   public String getType()
   {
      return type;
   }

   /**
    * Get the deployment unique key for the endpoint
    * @return the unique key formed from the tuple (type, vfs relative path, name):
    * type + "/" + pathName + "#" + name 
    */
   public String getComponentKey()
   {
      return type + "/" + pathName + "#" + name;
   }

   @Override
   public String toString()
   {
      StringBuilder tmp = new StringBuilder("EndpointInfo(pathName=");
      tmp.append(pathName);
      tmp.append(",name=");
      tmp.append(name);
      tmp.append(",type=");
      tmp.append(type);
      tmp.append(")");
      return tmp.toString();
   }
}
