#include "osl/oslConfig.h"
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <iostream>
#include <unistd.h>

// No need to include header files of every test classes.
// Instead, place CPPUNIT_TEST_SUITE_REGISTRATION(fooTest); in each fooTest.cc

int main(int /* argc */, char ** /* argv */)
{
  nice(20);
  osl::OslConfig::setInUnitTest(2);
  osl::OslConfig::setVerbose(false);
  osl::OslConfig::showOslHome();
  
  CppUnit::TextUi::TestRunner runner;

  CppUnit::TestFactoryRegistry &registry 
    = CppUnit::TestFactoryRegistry::getRegistry();
  runner.addTest(registry.makeTest());
  runner.setOutputter(new CppUnit::CompilerOutputter(&runner.result(), std::cout));
  runner.run("", false);

  CppUnit::TestResultCollector &result = runner.result(); 
  return result.wasSuccessful() ? 0 : 1;
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

