/*
 * Decompiled with CFR 0.152.
 */
package Display;

import Display.StatusBar;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class LanguageManager {
    private Document languageFile;
    private Element lang;
    private StatusBar statusBar;
    private URL appletCodeBase;
    private SAXBuilder builder;

    public LanguageManager(URL appletCodeBase, StatusBar statusBar) {
        this.appletCodeBase = appletCodeBase;
        this.statusBar = statusBar;
        this.builder = new SAXBuilder();
    }

    public String readLangFile(String childName) {
        Element child = null;
        if (this.lang != null) {
            child = this.lang.getChild(childName);
        }
        String text = "";
        if (child != null) {
            text = child.getText();
        } else {
            this.statusBar.println("Error: Missing data in language file");
        }
        return text;
    }

    public void loadLanguageFile(String language) {
        try {
            URL path = new URL(this.appletCodeBase + "lang/" + language + ".xml");
            this.languageFile = this.builder.build(path);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Error reading language file", "DragMath", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error reading language file", "DragMath", 0);
        }
        catch (JDOMException ex) {
            JOptionPane.showMessageDialog(null, "Error reading language file", "DragMath", 0);
        }
        if (this.languageFile != null) {
            this.lang = this.languageFile.getRootElement();
        }
    }
}

