// may exist some errors, sorry

typedef struct {
    char    *code;
    char    *question;
    char    *question_choices;
    char    *answer;
    char    *answer_choices;
} qcodes_t;

qcodes_t qcodes[] = {
    { "QAA", NULL, NULL, NULL, NULL },
    { "QAB", "May I have clearance (for...) from...(place and/or control) to...(place and/or control) at...(figures and units) height above...(datum)?", NULL, "You are cleared (or...is cleared) by... from... (place and/or control) to... (place and/or control) at...(figures and units) height above...(datum).", NULL },
    { "QAC", NULL, NULL, NULL, NULL },
    { "QAD", NULL, NULL, NULL, NULL },
    { "QAE", NULL, NULL, NULL, NULL },
    { "QAF", "Will you advice me when you are (were) at (over)...(place)?", NULL, "I am (was) at (over)...(place) (at...hours) (at...(figures and units)) height above... (datum).", NULL },
    { "QAG", NULL, NULL, "Arrange your flight in order to arrive over...(place) at...hours", NULL }, // I am arranging my flight in order to arrive over...(place) at...hours.
    { "QAH", "What is your height above... (datum)?", NULL, "I am at...(figures and units) height above...(datum).", NULL }, // Note:  An aircraft is permitted to reply to QAH IMI by using any of the answer forms of signals QBF, QBG, QBH, QBK, QBN or QBP.  In such cases the signal QAH is omitted from the reply. or Arrange your flight so as to reach...(figures and units) height above...(datum) at...(hours or place).
    { "QAI", "What is the essential traffic?", NULL, "The essential traffic is...", NULL },
    { "QAJ", NULL, NULL, NULL, NULL },
    { "QAK", "Is there any risk of collision?", NULL, "There is risk of collision.", NULL }, // Note:  This signal should be followed by appropriate Q signals or ICAO approved abbreviations giving instructions for avoiding collision.
    { "QAL", "Has aircraft...landed at...(place)?", NULL, "Aircraft...landed at...(place).", NULL },
    { "QAM", "What is the latest available meteorological observation for...(place)?", NULL, "Meteorological observation made at...(place) at...hours was as follows...", NULL }, // Note:  The information may be given in Q Code form or the AERO form of the International Meteorological Figure Code. When in Q Code, the information is to be given in the following sequence of Q signal answer (or advice) forms: QAN, QBA, QNY, QBB, QNH and/or QFE and, if necessary QMU, QNT, QBJ.  It is not normally necessary to precede the QAN, QBA, QNY, and QBB information by these Q signals but this may be done if considered desirable.  When in the AERO form of International Meteorological Figure Code the abbreviation AERO is to precede the information.
    { "QAN", "What is the surface wind direction and speed at... (place)?", NULL, "The surface wind direction and speed at...(place) at...hours is (direction)...(speed figures and units).", NULL }, // Note:  Unless otherwise indicated in the question, answer (or advise) surface wind direction is given in degrees relative to MAGNETIC North.
    { "QAO", "What is the wind direction in degrees TRUE and speed at...(position or zone/s) at each of the...(figures...(units) levels above... (datum)?", NULL, "The wind direction and speed (position or zone/s) at the following heights above... (datum is: ...(vertical distance in figures  and units) ...degrees TRUE...(speed in figures and units)", NULL },
    { "QAP", "Shall I listen for you (or for...) on...kHz (or (...MHz))?", NULL, "Listen for me (or for...) on... kHz (...MHz).", NULL },
    { "QAQ", "Am I near a prohibited area?", NULL, "You are...", "1) near 2) flying over a prohibited area" },
    { "QAR", "May I stop listening on the watch frequency for...minutes?", NULL, "You may stop listening on the watch frequency for...minutes", NULL },
    { "QAS", NULL, NULL, NULL, NULL },
    { "QAT", NULL, NULL, NULL, NULL },
    { "QAU", NULL, NULL, "I am about to jettison fuel.", NULL },
    { "QAV", NULL, NULL, NULL, NULL },
    { "QAW", NULL, NULL, "I am about to carry out overshoot procedure.", NULL },
    { "QAX", NULL, NULL, NULL, NULL },
    { "QAY", "Will you advise me when you pass (passed)...(place) bearing 090 (270) degrees relative to your heading?", NULL, "I passed...(place) bearing... degrees relative to my heading at...hours.", NULL },
    { "QAZ", "Are you experiencing communication difficulties through flying in a storm?", NULL, "I am experiencing communication difficulties through flying in a storm", NULL }, // Note:  Attention is invited to the possible supplementary use of signals QAR, QBE, QCS, QRM, QRN, QRX, QSZ or the signal CL to amplify the meaning associated with signal QAZ.
    { "QBA", "What is the horizontal visibility at...(place)?", NULL, "The horizontal visibility at... (place) at...hours is... (distance figures and units).", NULL },
    { "QBB", "What is the amount, type and height above official aerodrome elevation of the base of the cloud (at...(place)?", NULL, "The amount, type and height above official aerodrome elevation of the base of the cloud at... (place) at...hours is:  ...eighths (...type) at...(figures and units)* height above official aerodrome elevation.", NULL }, // NOTE:  The cloud amount, type (if reported) and vertical distance information is reported in sequence if several cloud layers are present, the order of reporting being from low to high levels in accordance with the following cloud layer specifications: a) the lowest individual layer of any amount; b) the next higher individual layer the amount of which is three-eighths or more (to the nearest eighth); c) the next higher individual layer the amount of which is five-eighths or more (to the nearest eighth). EXAMPLE:  = QBB CYUL 1300 2 300 FT 3 1500 FT 6 9000 FT =
    { "QBC", "Report meteorological conditions as observed from your aircraft at... (position or zone) at...hours at...(figures and units) height above...(datum).", NULL, "The meteorological conditions as observed from my aircraft at... (position or zone) at...hours at...(figures and units) height above...(datum) are..." }, // Note: The information may be given in AIREP, or Q Code form. When given in Q Code, the following sequence of Q signal QBC  answer (or advice) forms is used: QMX, QNY, QAO, QDF, QMI, QFT and QNI.", NULL },
    { "QBD", "How much fuel have you remaining (expressed as hours and/or minutes of consumption)?", NULL, "Fuel remaining is...(hours and/or minutes of consumption).", NULL },
    { "QBE", NULL, NULL, "I am about to wind in my aerial.", NULL },
    { "QBF", "Are you flying in cloud?", NULL, "I am flying in cloud at... (figures and units) height above...(datum) (and I am ascending (descending) to...(figures and units) height above that datum).", NULL },
    { "QBG", "Are you flying above cloud?", NULL, "I am flying above cloud and at...(figures and units) height above...(datum).", NULL }, // or Maintain a vertical distance of...(figures and units) above cloud, smoke, haze or fog levels.", NULL },
    { "QBH", "Are you flying below cloud?", NULL, "I am flying below cloud and at...(figures and units) height above...(datum).", NULL }, // or Maintain a vertical distance of...(figures and units) below cloud.", NULL },
    { "QBI", "Is flight under IFR compulsory at...(place) (or from...to...(place))?", NULL, "Flight under IFR is compulsory at...(place) (or from...to... (place)).", NULL },
    { "QBJ", "What is the amount, type and height above...(datum) of the top of the cloud (at... (position or zone))?", NULL, "At...hours at...(position or zone) the top of the cloud is: amount...eighths (...type) at...(figures and units) height above ...(datum).", NULL },
    { "QBK", "Are you flying with no cloud in your vicinity?", NULL, "I am flying with no cloud in my vicinity and at...(figures and units) height above ...(datum).", NULL },
    { "QBL", NULL, NULL, NULL, NULL },
    { "QBM", "Has...sent any message for me?", NULL, "Here is the message sent by...at...hours.", NULL },
    { "QBN", "Are you flying between two layers of cloud?", NULL, "I am flying between two layers of cloud and at...(figures and units) height above ...(datum).", NULL },
    { "QBO", "What is the nearest aerodrome at which flight under VFR is permissible and which would be suitable for my landing?", NULL, "Flying under VFR is permissible at...(place) which would be suitable for your landing.", NULL },
    { "QBP", "Are you flying in and out of cloud?", NULL, "I am flying in and out of cloud and at ...(figures and units) height above ...(datum).", NULL },
    { "QBQ", NULL, NULL, NULL, NULL },
    { "QBR", NULL, NULL, NULL, NULL },
    { "QBS", NULL, NULL, "Ascend (or descend) to... (figures and units) height above...(datum) before encountering instrument meteorological conditions or if visibility falls below... (figures and units of distance) and advise.", NULL },
    { "QBT", "How far, along the runway, from the approach end, can the observer at the runway threshold see the runway lights which will be in operation for my landing (at...(place))?", NULL, "At...hours, the observer at the threshold of runway number... could see the runway lights in operation for your landing (at...(place)) for a distance of...(figures and units) from the approach end." }, // Note:  If the station inquired of is not equipped to make the special observation requested, the reply to QBT IMI is given by the signal QNO.", NULL },
    { "QBU", NULL, NULL, NULL, NULL },
    { "QBV", "Have you reached the... (figures and units) height above...(datum) (or... (area or place))?", NULL, "I have reached the...(figures and units) height above...(datum) (or...(area or place)). or Report reaching the...(figures and units) height above... (datum) (or...(area or place)).", NULL },
    { "QBW", NULL, NULL, NULL, NULL },
    { "QBX", "Have you left the... (figures and units) height above...(datum) (or...(area or place))?", NULL, "I have left the... (figures and units) height above...(datum) (or...(area or place)). or Report leaving the...(figures and units) height above... (datum) (or...(area or place)).", NULL },
    { "QBY", NULL, NULL, NULL, NULL },
    { "QBZ", "Report your flying conditions in relation to clouds.", NULL, "The reply to QBZ IMI is given by the appropriate answer form of signals QBF, QBG, QBH, QBK, QBN and QBP.", NULL },
    { "QCA", "May I change from...(figures and units) to...(figures and units) height above...(datum)?", NULL, "You may change from...(figures and units) to...(figures and units) height above ...(datum). or I am changing from...(figures and units) to...(figures and units) height above...(datum).", NULL },
    { "QCB", NULL, NULL, "Delay is being caused by... %", "1) your transmitting out of turn. 2) your slowness in answering. 3) lack of your reply to my..." },
    { "QCC", NULL, NULL, NULL, NULL },
    { "QCD", NULL, NULL, NULL, NULL },
    { "QCE", "When may I expect approach clearance?", NULL, "Expect approach clearance at...hours.", NULL },
    { "QCF", NULL, NULL, "Delay indefinite. Expect approach clearance not later than...hours.", NULL },
    { "QCG", NULL, NULL, NULL, NULL },
    { "QCH", "May I taxi to...(place)?", NULL, "Cleared to taxi to...(place). (the place is given in plain language).", NULL },
    { "QCI", NULL, NULL, "Make a 360-degree turn immediately (turning to the...).", NULL },
    { "QCJ", NULL, NULL, NULL, NULL },
    { "QCK", NULL, NULL, NULL, NULL },
    { "QCL", NULL, NULL, NULL, NULL },
    { "QCM", NULL, NULL, NULL, NULL },
    { "QCN", NULL, NULL, NULL, NULL },
    { "QCO", NULL, NULL, NULL, NULL },
    { "QCP", NULL, NULL, NULL, NULL },
    { "QCQ", NULL, NULL, NULL, NULL },
    { "QCR", NULL, NULL, NULL, NULL },
    { "QCS", NULL, NULL, "My reception on...frequency has broken down.", NULL },
    { "QCT", NULL, NULL, NULL, NULL },
    { "QCU", NULL, NULL, NULL, NULL },
    { "QCV", NULL, NULL, NULL, NULL },
    { "QCW", NULL, NULL, NULL, NULL },
    { "QCX", "What is your full call sign?", NULL, "My full call sign is...", NULL },
    { "QCY", NULL, NULL, "I am working on trailing aerial.", NULL },
    { "QCZ", NULL, NULL, NULL, NULL },
    { "QDA", NULL, NULL, NULL, NULL },
    { "QDB", "Have you sent message...to...?", NULL, "I have sent message...to...", NULL },
    { "QDC", NULL, NULL, NULL, NULL },
    { "QDD", NULL, NULL, NULL, NULL },
    { "QDE", NULL, NULL, NULL, NULL },
    { "QDF", "What is your D-Value at...(position)?", /* "What is the D-Value at... (place or position) at...hours) for the...millibar level?" */ NULL, "My D-Value at...(position) at... (figures and units) height above the 1013.2 millibars datum is...(D-Value figures and units)... *(specify plus or minus)." }, // or The D-Value at...(place or position) at hours for the...millibar level is...(D-Value figures and units...*(specify plus or minus)." }, // Note:  When the true altitude (radio altitude) is greater than the pressure altitude PS (plus) is used and when it is less MS (minus) is used."
    { "QDG", NULL, NULL, NULL, NULL },
    { "QDH", NULL, NULL, NULL, NULL },
    { "QDI", NULL, NULL, NULL, NULL },
    { "QDJ", NULL, NULL, NULL, NULL },
    { "QDK", NULL, NULL, NULL, NULL },
    { "QDL", "Do you intend to ask me for a series of bearings?", NULL, "I intend to ask you for a series of bearings.", NULL },
    { "QDM", "Will you indicate the MAGNETIC heading for me to steer towards you (or...) with no wind?", NULL, "The MAGNETIC heading for you to steer to reach me (or...) with no wind was...degrees (at...hours).", NULL },
    { "QDN", NULL, NULL, NULL, NULL },
    { "QDO", NULL, NULL, NULL, NULL },
    { "QDP", "Will you accept control (or responsibility) of (for)... now (or at ...hours)?", NULL, "I will accept control (or responsibility) of (for)...now (or at...hours).", NULL },
    { "QDQ", NULL, NULL, NULL, NULL },
    { "QDR", "What is my MAGNETIC bearing from you (or from...)?", NULL, "Your MAGNETIC bearing from me (or from...) was...degrees (at... hours).", NULL },
    { "QDS", NULL, NULL, NULL, NULL },
    { "QDT", "Are you flying in visual meteorological conditions?", NULL, "I am flying in visual meteorological conditions.", NULL },
    { "QDU", NULL, NULL, "Cancel my IFR flight plan.", NULL },
    { "QDV", "Are you flying in a horizontal visibility of less than... (figures and units)?", NULL, "I am flying in a horizontal visibility of less than... (figures and units) at... (figures and units) height above...(datum).", NULL },
    { "QDW", NULL, NULL, NULL, NULL },
    { "QDX", NULL, NULL, NULL, NULL },
    { "QDY", NULL, NULL, NULL, NULL },
    { "QDZ", NULL, NULL, NULL, NULL },
    { "QEA", "May I cross the runway ahead of you?", NULL, "You may cross the runway ahead of me.", NULL },
    { "QEB", "May I turn at the intersection?", NULL, "Taxi as follows at the intersection... (straight ahead         DRT turn left                 LEFT turn right                RITE)", NULL },
    { "QEC", "May I make a 180-degree turn and return down the runway?", NULL, "You may make a 180-degree turn and return down the runway.", NULL },
    { "QED", "Shall I follow the pilot vehicle?", NULL, "Follow the pilot vehicle.", NULL },
    { "QEE", NULL, NULL, NULL, NULL },
    { "QEF", "Have I/you reached the parking area?", NULL, "You have reached your parking area.", NULL },
    { "QEG", "May I/you leave the parking area?", NULL, "You may leave the parking area.", NULL },
    { "QEH", "May I/you move to the holding position for runway number...?", NULL, "Cleared to the holding position for runway number...", NULL },
    { "QEI", NULL, NULL, NULL, NULL },
    { "QEJ", "May I/you assume position for take-off?", NULL, "Cleared to hold at take-off position for runway number... and am holding.", NULL },
    { "QEK", "Are you ready for immediate take-off?", NULL, "I am ready for immediate take-off.", NULL },
    { "QEL", "May I take-off (and make a... hand turn after take-off)?", NULL, "You are cleared to take-off (turn as follows after take-off...).", NULL },
    { "QEM", "What is the condition of the landing surface at...(place)?", NULL, "The condition of the landing surface at...(place) is..." }, // Note:  The information is given by sending appropriate NOTAM Code groups."
    { "QEN", "Shall I hold my position?", NULL, "Hold your position.", NULL },
    { "QEO", "Shall I/you clear the runway (or landing area)?", NULL, "Clear the runway (or landing area).", NULL },
    { "QEP", NULL, NULL, NULL, NULL },
    { "QEQ", NULL, NULL, NULL, NULL },
    { "QER", NULL, NULL, NULL, NULL },
    { "QES", "Is a right-hand circuit in force at...(place)?", NULL, "A right-hand circuit is in force at...(place).", NULL },
    { "QET", NULL, NULL, NULL, NULL },
    { "QEU", NULL, NULL, NULL, NULL },
    { "QEV", NULL, NULL, NULL, NULL },
    { "QEW", NULL, NULL, NULL, NULL },
    { "QEX", NULL, NULL, NULL, NULL },
    { "QEY", NULL, NULL, NULL, NULL },
    { "QEZ", NULL, NULL, NULL, NULL },
    { "QFA", "What is the meteorological forecast for...(flight, route, section of route or zone) for the period...hours until ...hours?", NULL, "The meteorological forecast for...(flight, route, section of route or zone) for the period...hours until hours.is " }, // Note:  When the forecast is given in Q Code the following sequence of Q signal answer (or advice) forms is to be given: QAO, QMX, QMI, QNY, QBA, QMW, QFT and QNI."
    { "QFB", NULL, NULL, "The... % lights are out of order.", "1)  approach 2)  runway 3)  approach and runway" },
    { "QFC", "What is the amount, the type and the height above...(datum) of the base of the cloud at...(place, position or zone)?", NULL, "At...(place, position or zone) the base of the cloud is... eighths...type at...(figures and units) height above... (datum)." }, // Note:  If several cloud layers or masses are present, the lowest is reported first."
    { "QFD", "%", "1)  Is the...visual beacon(at...(place)) in operation? 2)  Will you switch on the... visual beacon (at...(place))? 3) Will you extinguish the aerodrome visual beacon (at...(place)) until I have landed?", "%", "1)  The...visual beacon (at... (place)) is in operation. 2)  I will switch on the... visual beacon (at...(place)). 3)  I will extinguish the aerodrome visual beacon (at... (place)) until your landing is completed." },
    { "QFE", "(At...(place)) what is the present atmospheric pressure at official aerodrome elevation?", NULL, "At...(place) the atmospheric pressure at official aerodrome elevation is (or was observed at...hours to be) ...millibars.", NULL },
    { "QFF", "(At...(place)) what is the present atmospheric pressure converted to mean sea level in accordance with meteorological practice?", NULL, "At...(place) the atmospheric pressure converted to mean sea level in accordance with meteorological practice is (or was determined at...hours to be) ...millibars.", NULL },
    { "QFG", "Am I overhead?", NULL, "You are overhead.", NULL },
    { "QFH", "May I descend below the clouds?", NULL, "You may descend below the clouds.", NULL },
    { "QFI", "Are the aerodrome lights lit?", NULL, "The aerodrome lights are lit.", NULL },
    { "QFJ", NULL, NULL, NULL, NULL },
    { "QFK", NULL, NULL, NULL, NULL },
    { "QFL", NULL, NULL, NULL, NULL },
    { "QFM", "What height above..(datum)... %", "1)  should I maintain? 2)  are you maintaining? 3)  do you intend cruising at?", "%", "1)  Maintain (or fly at)... (figures and units) height above...(datum). 2)  I am maintaining...(figures and units) height above ...(datum). 3)  I intend cruising at... (figures and units) height above...(datum)." },
    { "QFN", NULL, NULL, NULL, NULL },
    { "QFO", "May I land immediately?", NULL, "You may land immediately.", NULL },
    { "QFP", "Will you give me the latest information concerning... facility (at...(place))?", NULL, "The latest information concerning...facility (at... (place)) is as follows..." }, // Note:  The information is given by sending appropriate NOTAM Code groups."
    { "QFQ", "Are the approach and runway lights lit?", NULL, "The approach and runway lights are lit.", NULL },
    { "QFR", "Does my landing gear appear damaged?", NULL, "Your landing gear appears damaged.", NULL },
    { "QFS", "Is the...radio facility at...(place) in operation?", NULL, "The...radio facility at...(place) is in operation (or will be in operation in...hours).", NULL },
    { "QFT", "Between what heights above...(datum) has ice formation been observed (at...(position or zone))?", NULL, "Ice formation has been observed at ...(position or zone) in the type of...and with an accretion rate of...between...(figures and units) and...(figures and units) heights above...(datum).", NULL },
    { "QFU", "What is the magnetic direction (or number) of the runway to be used?", NULL, "The magnetic direction (or number) of the runway to be used is..." }, // Note:  The runway number is indicated by a two-figure group and the magnetic direction by a three-figure group."
    { "QFV", "Are the floodlights switched on?", NULL, "The floodlights are switched on.", NULL },
    { "QFW", "What is the length of the runway in use in...(units)?", NULL, "The length of runway...now in use is...(figures and units).", NULL },
    { "QFX", NULL, NULL, "I am working (or am going to work) on a fixed aerial.", NULL },
    { "QFY", "Please report the present meteorological landing conditions (at...(place)).", NULL, "The present meteorological landing conditions at...(place) are..." }, // Note: When given in Q Code the information is sent in the following sequence: QAN, QBA, QNY, QBB, QNH, and/or QFE and, if necessary, QMU, QNT, QBJ.  It is not normally necessary to precede the QAN, QBA, QNY and QBB information by these Q signals but this may be done if considered desirable."
    { "QFZ", "What is the aerodrome meteorological forecast for...(place) for the period...hours until...hours?", NULL, "The aerodrome meteorological forecast for...(place) for the period...hours until...hours is..." }, // Note:  When given in Q Code the following sequence of Q signal answer (or advice) forms is to be used: QAN, QBA, QNY, QBB and, if necessary, QMU, QNT and QBJ.
    { "QGA", NULL, NULL, NULL, NULL },
    { "QGB", NULL, NULL, NULL, NULL },
    { "QGC", NULL, NULL, "There are obstructions to the... of runway...", NULL },
    { "QGD", "Are there on my track any obstructions whose elevation equals or exceeds my altitude?", NULL, "There are obstructions on your track ...(figures and units) height above...(datum).", NULL },
    { "QGE", "What is my distance to your station (or to...)?", NULL, "Your distance to my station (or to...) is...(distance figures and units)." }, // Note:  This signal is normally used in conjunction with one of the signals QDM, QDR, QTE or QUJ.
    { "QGF", NULL, NULL, NULL, NULL },
    { "QGG", NULL, NULL, NULL, NULL },
    { "QGH", "May I land using... (procedure or facility)?", NULL, "You may land using...(procedure or facility).", NULL },
    { "QGI", NULL, NULL, NULL, NULL },
    { "QGJ", NULL, NULL, NULL, NULL },
    { "QGK", "What track should I/you make good?", NULL, "Make good a track from...(place) on ...degrees ...(true or magnetic).", NULL },
    { "QGL", "May I enter the...(control area or zone) at (place)?", NULL, "You may enter the...(control area or zone) at...(place).", NULL },
    { "QGM", NULL, NULL, "Leave the...(control area or zone).", NULL },
    { "QGN", "May I be cleared to land (at...(place)?", NULL, "You are cleared to land (at... (place).", NULL },
    { "QGO", NULL, NULL, "Landing is prohibited at... (place).", NULL },
    { "QGP", "What is my number for landing?", NULL, "You are number...to land.", NULL },
    { "QGQ", "May I hold at...(place)?", NULL, "Hold at...(place) at...(figures and units) height above... (datum) and await orders.", NULL },
    { "QGR", NULL, NULL, NULL, NULL },
    { "QGS", NULL, NULL, NULL, NULL },
    { "QGT", NULL, NULL, "Fly for...minutes on a heading that will enable you to maintain a track reciprocal to your present one.", NULL },
    { "QGU", NULL, NULL, "Fly for...minutes on a magnetic heading of...degrees.", NULL },
    { "QGV", "Do you see me?", NULL, "I see you at...(cardinal or quadrantal point of direction).", NULL },
    { "QGW", "Does my landing gear appear to be down and in place?", NULL, "Your landing gear appears to be down and in place.", NULL },
    { "QGY", NULL, NULL, NULL, NULL },
    { "QGZ", NULL, NULL, "Hold on...direction of... facility.", NULL },
    { "QHA", NULL, NULL, NULL, NULL },
    { "QHB", NULL, NULL, NULL, NULL },
    { "QHC", NULL, NULL, NULL, NULL },
    { "QHD", NULL, NULL, NULL, NULL },
    { "QHE", "Will you inform me when you are on...leg of approach?", NULL, "I am on... %", "1)  cross-wind leg 2)  down-wind leg of approach. 3)  base leg 4)  final leg" },
    { "QHF", NULL, NULL, NULL, NULL },
    { "QHG", "May I enter traffic circuit at...(figures and units) height above...(datum)?", NULL, "Cleared to enter traffic circuit at...(figures and units) height above...(datum).", NULL },
    { "QHH", "Are you making an emergency landing?", NULL, "I am making an emergency landing." /* or Emergency landing being made at...(place). All aircraft below...(figures and units) height above...(datum) and within a distance of... (figures and units) leave...(place or headings)*/, NULL },
    { "QHI", "Are you (or is...)... %", "1)  waterborne? 2)  on land?", "I am (or...is)...athours %.", "1)  waterborne 2) on land" },
    { "QHJ", NULL, NULL, NULL, NULL },
    { "QHK", NULL, NULL, NULL, NULL },
    { "QHL", NULL, NULL, NULL, NULL },
    { "QHM", NULL, NULL, NULL, NULL },
    { "QHN", NULL, NULL, NULL, NULL },
    { "QHO", NULL, NULL, NULL, NULL },
    { "QHP", NULL, NULL, NULL, NULL },
    { "QHQ", "May I/you make a...approach (at...(place))?", NULL, "You may make a...approach (at... (place))", NULL },
    { "QHR", NULL, NULL, NULL, NULL },
    { "QHS", NULL, NULL, NULL, NULL },
    { "QHT", NULL, NULL, NULL, NULL },
    { "QHU", NULL, NULL, NULL, NULL },
    { "QHV", NULL, NULL, NULL, NULL },
    { "QHW", NULL, NULL, NULL, NULL },
    { "QHX", NULL, NULL, NULL, NULL },
    { "QHY", NULL, NULL, NULL, NULL },
    { "QHZ", "Shall I circle the aerodrome (or go around)?", NULL, "Circle the aerodrome (or go around).", NULL },
    { "QIA", NULL, NULL, NULL, NULL },
    { "QIB", NULL, NULL, NULL, NULL },
    { "QIC", "May I establish communication with ...radio station on...kHz. (or...MHz.) now (or at...hours)?", NULL, "Establish communication with...radio station on...kHz. (or...MHz.) now (or at...hours).", NULL },
    { "QID", NULL, NULL, NULL, NULL },
    { "QIE", NULL, NULL, NULL, NULL },
    { "QIF", "What frequency is...using?", NULL, "...is using...kHz. (or...MHz).", NULL },
    { "QIG", NULL, NULL, NULL, NULL },
    { "QIH", NULL, NULL, NULL, NULL },
    { "QII", NULL, NULL, NULL, NULL },
    { "QIJ", NULL, NULL, NULL, NULL },
    { "QIK", NULL, NULL, NULL, NULL },
    { "QIL", NULL, NULL, NULL, NULL },
    { "QIM", NULL, NULL, NULL, NULL },
    { "QIN", NULL, NULL, NULL, NULL },
    { "QIO", NULL, NULL, NULL, NULL },
    { "QIP", NULL, NULL, NULL, NULL },
    { "QIQ", NULL, NULL, NULL, NULL },
    { "QIR", NULL, NULL, NULL, NULL },
    { "QIS", NULL, NULL, NULL, NULL },
    { "QIT", NULL, NULL, NULL, NULL },
    { "QIU", NULL, NULL, NULL, NULL },
    { "QIV", NULL, NULL, NULL, NULL },
    { "QIW", NULL, NULL, NULL, NULL },
    { "QIX", NULL, NULL, NULL, NULL },
    { "QIY", NULL, NULL, NULL, NULL },
    { "QIZ", NULL, NULL, NULL, NULL },
    { "QJA", "Is my... % reversed?", "1)  tape 2)  mark and space", "Your... % is reversed.", "1)  tape 2)  mark and space" },
    { "QJB", "Will you use... %", "1)  radio? 2)  cable? 3)  telegraph? 4)  teletypewriter? 5)  telephone? 6)  receiver? 7)  transmitter? 8)  reperforator?", "I will use... %", "1)  radio. 2)  cable. 3)  telegraph. 4)  teletypewriter. 5)  telephone. 6)  receiver. 7)  transmitter. 8)  reperforator." },
    { "QJC", "Will you check your... %", "1)transmitter distributor. 2)auto-head. 3)  perforator. 4)  reperforator 5)  printer 6)  printer motor 7)  keyboard 8)  antenna system", "I will check my... %", "1)transmitter distributor. 2)auto-head. 3)  perforator. 4)  reperforator 5)  printer 6)  printer motor 7)  keyboard 8)  antenna system" },
    { "QJD", "Am I transmitting... %", "1)  in letters? 2)  in figures?", "You are transmitting... %", "1)  in letters. 2)  in figures." },
    { "QJE", "Is my frequency shift... %", "1)  too wide? 2)  too narrow? 3)  correct?", "Your frequency shift is... %", "1)  too wide. 2)  too narrow (by...Hz). 3)  correct." },
    { "QJF", NULL, NULL, "My signal as checked by monitor...is satisfactory... %", "1)  locally. 2)  as radiated." },
    { "QJG", "Shall I revert to automatic relay?", NULL, "Revert to automatic relay.", NULL },
    { "QJH", "Shall I run... %", "1)  my test tape? 2)  a test sentence?", "Run... %.", "1)  your test tape. 2)  a test sentence." },
    { "QJI", "Will you transmit a continuous... %", "1)  mark? 2)  space?", "I am transmitting a continuous... %.", "1)  mark. 2)  space." },
    { "QJJ", NULL, NULL, NULL, NULL },
    { "QJK", "Are you receiving... %", "1)  a continuous mark? 2)  a continuous space? 3)  a mark bias? 4)  a space bias?", "I am receiving... %.", "1)  a continuous mark. 2)  a continuous space. 3)  a mark bias. 4)  a space bias." },
    { "QJL", NULL, NULL, NULL, NULL },
    { "QJM", NULL, NULL, NULL, NULL },
    { "QJN", NULL, NULL, NULL, NULL },
    { "QJO", NULL, NULL, NULL, NULL },
    { "QJP", NULL, NULL, NULL, NULL },
    { "QJQ", NULL, NULL, NULL, NULL },
    { "QJR", NULL, NULL, NULL, NULL },
    { "QJS", NULL, NULL, NULL, NULL },
    { "QJT", NULL, NULL, NULL, NULL },
    { "QJU", NULL, NULL, NULL, NULL },
    { "QJV", NULL, NULL, NULL, NULL },
    { "QJW", NULL, NULL, NULL, NULL },
    { "QJX", NULL, NULL, NULL, NULL },
    { "QJY", NULL, NULL, NULL, NULL },
    { "QJZ", NULL, NULL, NULL, NULL },
    { "QKA", NULL, NULL, NULL, NULL },
    { "QKB", NULL, NULL, NULL, NULL },
    { "QKC", NULL, NULL, "The sea conditions (at...position).... %.", "1)  permit alighting but not take-off. 2)  render alighting extremely hazardous." },
    { "QKD", NULL, NULL, NULL, NULL },
    { "QKE", NULL, NULL, NULL, NULL },
    { "QKF", "May I be relieved (at... hours)?", NULL, "You may expect to be relieved at...hours by... %", "1) aircraft... (identification) (type...). 2) vessel whose call sign is... (call sign) (and/or whose name (is...(name))." },
    { "QKG", "Will relief take place when ...(identification) establishes... % contact with survivors?", "1)  visual, 2)  communications", "Relief will take place when... (identification) establishes... % contact with survivors.", "1)  visual, 2)  communications" },
    { "QKH", "In the parallel sweep (track search being (or to be) conducted, what is (are) %", "1)  the direction of sweeps 2)  the separation between 3)  the height above the datum, employed in the search pattern?", "The parallel sweep (track) search is being (or to be) conducted... %.", "1)with direction of sweeps...degrees... (true or magnetic). 2)with...(distance figures sweeps, and units) separation between sweeps. 3)at a height of... (figures) above... (datum)." },
    { "QKI", NULL, NULL, NULL, NULL },
    { "QKJ", NULL, NULL, NULL, NULL },
    { "QKK", NULL, NULL, NULL, NULL },
    { "QKL", NULL, NULL, NULL, NULL },
    { "QKM", NULL, NULL, NULL, NULL },
    { "QKN", NULL, NULL, "Aircraft plotted (believed to be you) in position...on track....degrees at...hours.", NULL },
    { "QKO", "What other units are (or will be) taking part in the operation (...(identification of operation))?", NULL, "In the operation (...(identification)) the following units are (or will be) taking part...(name of units). or ...(name) unit is taking part in operation (... (identification)) (with effect from... hours).", NULL },
    { "QKP", "Which pattern of search is being followed?", NULL, "The search pattern is... %.", "1)parallel sweep. 2)square search. 3)creeping line ahead. 4)track crawl. 5)contour search. 6) combined search by aircraft and ship. 7)...(specify)." },
    { "QKQ", NULL, NULL, NULL, NULL },
    { "QKR", NULL, NULL, NULL, NULL },
    { "QKS", NULL, NULL, NULL, NULL },
    { "QKT", NULL, NULL, NULL, NULL },
    { "QKU", NULL, NULL, NULL, NULL },
    { "QKV", NULL, NULL, NULL, NULL },
    { "QKW", NULL, NULL, NULL, NULL },
    { "QKX", NULL, NULL, NULL, NULL },
    { "QKY", NULL, NULL, NULL, NULL },
    { "QKZ", NULL, NULL, NULL, NULL },
    { "QLA", NULL, NULL, NULL, NULL },
    { "QLB", "Will you monitor...station and report regarding range, quality, etc.?", NULL, "I have monitored...station and report (briefly) as follows...", NULL },
    { "QLC", NULL, NULL, NULL, NULL },
    { "QLD", NULL, NULL, NULL, NULL },
    { "QLE", NULL, NULL, NULL, NULL },
    { "QLF", NULL, NULL, NULL, NULL },
    { "QLG", NULL, NULL, NULL, NULL },
    { "QLH", "Will you use simultaneous keying on...frequency and...frequency?", NULL, "I will now key simultaneously on...frequency and...frequency.", NULL },
    { "QLI", NULL, NULL, NULL, NULL },
    { "QLJ", NULL, NULL, NULL, NULL },
    { "QLK", NULL, NULL, NULL, NULL },
    { "QLL", NULL, NULL, NULL, NULL },
    { "QLM", NULL, NULL, NULL, NULL },
    { "QLN", NULL, NULL, NULL, NULL },
    { "QLO", NULL, NULL, NULL, NULL },
    { "QLP", NULL, NULL, NULL, NULL },
    { "QLQ", NULL, NULL, NULL, NULL },
    { "QLR", NULL, NULL, NULL, NULL },
    { "QLS", NULL, NULL, NULL, NULL },
    { "QLT", NULL, NULL, NULL, NULL },
    { "QLU", NULL, NULL, NULL, NULL },
    { "QLV", "Is the...radio facility still required?", NULL, "The...radio facility is still required.", NULL },
    { "QLW", NULL, NULL, NULL, NULL },
    { "QLX", NULL, NULL, NULL, NULL },
    { "QLY", NULL, NULL, NULL, NULL },
    { "QLZ", NULL, NULL, NULL, NULL },
    { "QMA", NULL, NULL, NULL, NULL },
    { "QMB", NULL, NULL, NULL, NULL },
    { "QMC", NULL, NULL, NULL, NULL },
    { "QMD", NULL, NULL, NULL, NULL },
    { "QME", NULL, NULL, NULL, NULL },
    { "QMF", NULL, NULL, NULL, NULL },
    { "QMG", NULL, NULL, NULL, NULL },
    { "QMH", NULL, NULL, "Shift to transmit and receive on ...kHz (or MHz); if communication is not established within 5 minutes, revert to present frequency.", NULL },
    { "QMI", "Report the vertical distribution of cloud (at ...(position or zone)) as observed from your aircraft.", NULL, "The vertical distribution of cloud as observed from my aircraft at...hours at... (position or zone) is: lowest layer Observed *...eighths (...type) with base of...(figures and units) and tops of...(figures and units) (*and similarly in sequence for each of the layers observed.) height above...(datum).", NULL }, //  Example: = QMI 1400 11 2 CU 1000 FT 2500 FT 6 SC 6000 FT 10000 FT 5 AC 13000 FT 14000 FT ALT =
    { "QMJ", NULL, NULL, NULL, NULL },
    { "QMK", NULL, NULL, NULL, NULL },
    { "QML", NULL, NULL, NULL, NULL },
    { "QMM", NULL, NULL, NULL, NULL },
    { "QMN", NULL, NULL, NULL, NULL },
    { "QMO", NULL, NULL, NULL, NULL },
    { "QMP", NULL, NULL, NULL, NULL },
    { "QMQ", NULL, NULL, NULL, NULL },
    { "QMR", NULL, NULL, NULL, NULL },
    { "QMS", NULL, NULL, NULL, NULL },
    { "QMT", NULL, NULL, NULL, NULL },
    { "QMU", "What is the surface temperature at...(place) and what is the dew point temperature at that place?", NULL, "The surface temperature at...(place) at ... hours is...degrees and the dew point temperature at that time and place is...degrees.", NULL },
    { "QMV", NULL, NULL, NULL, NULL },
    { "QMW", "At...(position or zone) what is (are) the height(s) above...(datum) of the zero Celsius isotherm(s)?", NULL, "At...(position or zone) the zero Celsius isotherm(s) is (are) at...(figures and units) height(s) above ...(datum).", NULL },
    { "QMX", "What is the air temperature (at... (position or zone)) (at...hours) at the... (figures and units) height above... (datum)?", NULL, "At...(position or zone) at... hours the air temperature is...(degrees and units) at... (figures and units) height above...(datum)." }, // Note:  Aircraft reporting QMX information will transmit the temperature figures as corrected for airspeed.
    { "QMY", NULL, NULL, NULL, NULL },
    { "QMZ", "Have you any amendments to the flight forecast in respect of section of route yet to be traversed?", NULL, "The following amendment(s) should be made to the flight forecast... (If no amendments, signal QMZ NIL.)", NULL },
    { "QNA", NULL, NULL, NULL, NULL },
    { "QNB", NULL, NULL, NULL, NULL },
    { "QNC", NULL, NULL, NULL, NULL },
    { "QND", NULL, NULL, NULL, NULL },
    { "QNE", "What indication will my altimeter give on landing at...(place) at...hours, my sub-scale being set to1013.2 millibars (29.925 inches)?", NULL, "On landing at...(place) at... hours, with your sub-scale being set to 1013.2 millibars (29.92 inches), your altimeter will indicate...(figures and units).", NULL },
    { "QNF", NULL, NULL, NULL, NULL },
    { "QNG", NULL, NULL, NULL, NULL },
    { "QNH", "What should I set on the sub-scale of my altimeter so that the instrument would indicate my elevation if I were on the ground at your station?", NULL, "If you set the sub-scale of your altimeter to read...millibars (or hundredths of a inch*), the instrument would indicate your elevation if you were on the ground at my station at...hours.", NULL }, // Note:  When the setting is given in hundredths of an inch the abbreviation "INS" is used to identify the units.", NULL },
    { "QNI", "Between what heights above...(datum) has turbulence been observed at...(position or zone)?", NULL, "Turbulence has been observed at...(position or zone) with an intensity of...between ...(figures and units) and...(figures and units) heights above...(datum).", NULL },
    { "QNJ", NULL, NULL, NULL, NULL },
    { "QNK", NULL, NULL, NULL, NULL },
    { "QNL", NULL, NULL, NULL, NULL },
    { "QNM", NULL, NULL, NULL, NULL },
    { "QNN", NULL, NULL, NULL, NULL },
    { "QNO", NULL, NULL, "I am not equipped to give the information (or provide the facility) requested.", NULL },
    { "QNP", NULL, NULL, NULL, NULL },
    { "QNQ", NULL, NULL, NULL, NULL },
    { "QNR", NULL, NULL, "I am approaching my point of no return.", NULL },
    { "QNS", NULL, NULL, NULL, NULL },
    { "QNT", "What is the maximum gust speed of the surface wind at...(place)?", NULL, "The maximum gust speed of the surface wind at...(place) at... hours is...(speed figures and units).", NULL },
    { "QNU", NULL, NULL, NULL, NULL },
    { "QNV", NULL, NULL, NULL, NULL },
    { "QNW", NULL, NULL, NULL, NULL },
    { "QNX", NULL, NULL, NULL, NULL },
    { "QNY", "What is the present weather and the intensity thereof at...(place, position or zone)?", NULL, "The present weather and intensity thereof at...(place, position or zone) at...hours is..." }, // (See Notes a) and b)). Notes: a) When present weather information is transmitted by a ground station, the information shall be selected from the present weather table (Table III) in PANSMET (Doc 7605- MET/526).  If none of these conditions prevail the reply shall be QNY NIL.
    { "QNZ", NULL, NULL, NULL, NULL },
    { "QOA", "Can you communicate by radiotelegraphy (500 kHz)?", NULL, "I can communicate by radiotelegraphy (500 kHz)." /*(MARITIME USE ONLY)*/, NULL },
    { "QOB", "Can you communicate by radiotelephony (2182 kHz)?", NULL, "I can communicate by radiotelephony (2182 kHz)." /*(MARITIME USE ONLY)*/, NULL },
    { "QOC", "Can you communicate by radiotelephony(channel 16 - frequency 156.80 MHz)?", NULL, "I can communicate by radiotelephony (channel 16 - frequency 156.80 MHz)." /*(MARITIME USE ONLY)*/, NULL },
    { "QOD", "Can you communicate with me in... %?", "0.  Dutch 1.  English 2.  French 3.  German 4.  Greek 5.  Italian 6.  Japanese 7.  Norwegian 8.  Russian 9.  Spanish?", "I can communicate with you in... %.", "0.  Dutch 1.  English 2.  French 3.  German 4.  Greek 5.  Italian 6.  Japanese 7.  Norwegian 8.  Russian 9.  Spanish?" },
    { "QOE", "Have you received the safety signal sent by...(name and/or call sign)?", NULL, "I have received the safety signal sent by...(name and/or call sign)." /*(MARITIME USE ONLY)*/, NULL },
    { "QOF", "What is the commercial quality of my signals?", NULL, "The quality of your signals is... %", "1)  not commercial 2)  marginally commercial 3)  commercial " /*(MARITIME USE ONLY)*/ },
    { "QOG", "How many tapes have you to send?", NULL, "I have...tapes to send." /*(MARITIME USE ONLY)*/, NULL },
    { "QOH", "Shall I send a phasing signal for...seconds?", NULL, "Send a phasing signal for...seconds." /*(MARITIME USE ONLY)*/, NULL },
    { "QOI", "Shall I send my tape?", NULL, "Send your tape." /*(MARITIME USE ONLY)*/, NULL },
    { "QOJ", "Will you listen on... kHz (or MHz) for signals of emergency position- indicating radio beacon?", NULL, "I am listening on...kHz (or MHz) for signals of emergency position-indicating radio beacon." /*(MARITIME USE ONLY)*/, NULL },
    { "QOK", "Have you received the signals of an emergency position-indicating radio beacon on...kHz(or MHz)?", NULL, "I have received the signals of an emergency position- indicating radio beacon on ...kHz (or MHz)." /*(MARITIME USE ONLY)*/, NULL },
    { "QOL", "Is your vessel fitted for reception of selective calls?  If so, what is your selective call number or signal?", NULL, "My vessel is fitted for the reception of selective calls. My selective call number or signal is..." /*(MARITIME USE ONLY)*/, NULL },
    { "QOM", "On what frequencies can your vessel be reached by a selective call?", NULL, "My vessel can be reached by a selective call on the following Frequency(ies)... (periods of time to be added is necessary)." /*  (MARITIME USE ONLY) QON to*/, NULL },
    //{ "QON -> QOS", NULL, NULL, "The series QON to QOS inclusive is reserved for the Maritime Services.", NULL },
    { "QOT", "Do you hear my call; what is the approximate delay in minutes before we may exchange traffic?", NULL, "I hear your call; the approximate delay is ... minutes."/*  (MARITIME USE ONLY) */, NULL },
    //{ "QOU -> QQZ", "The series QOU to QQZ inclusive is reserved for the Maritime Services", NULL },
    { "QRA", "What is the name of your station?", NULL, "The name of my station is...", NULL },
    { "QRB", "How far approximately are you from my station?", NULL, "The approximate distance between our stations is...nautical miles (or...kilometers).", NULL },
    { "QRC", "By what private enterprise (or State administration) are accounts for charges for your station settled?", NULL, "The accounts for charges of my station are settled by the private enterprise...(or State administration).", NULL },
    { "QRD", "Where are you bound and where are you from?", NULL, "I am bound for...from...", NULL },
    { "QRE", "What is your estimated time of arrival at... (or over...) (place)?", NULL, "My estimated time of arrival at...(or over...) (place) is...hours.", NULL },
    { "QRF", "Are you returning to... (place)?", NULL, "I am returning to...(place).", NULL },
    { "QRG", "Will you tell me my exact frequency (or that of...)?", NULL, "Your exact frequency (or that of...) is...kHz (or MHz).", NULL },
    { "QRH", "Does my frequency vary?", NULL, "Your frequency varies.", NULL },
    { "QRI", "How is the tone of my transmission?", NULL, "The tone of your transmission is... %.", "1) good. 2) variable. 3) bad." },
    { "QRJ", "How many radiotelephone calls have you to book?", NULL, "I have...radiotelephone calls to book.", NULL },
    { "QRK", "What is the intelligibility of my signals (or those of...)?", NULL, "The intelligibility of your signals is... %.", "1) bad. 2) poor. 3) fair. 4) good. 5) excellent." },
    { "QRL", "Are you busy?", NULL, "I am busy (or I am busy with...).", NULL },
    { "QRM", "Are you being interfered with?", NULL, "I am being interfered with %.", "1)  nil 2)  slightly 3)  moderately 4)  severely 5)  extremely." },
    { "QRN", "Are you troubled by static?", NULL, "I am troubled by static %.", "1)  nil 2)  slightly 3)  moderately 4)  severely 5)  extremely." },
    { "QRO", "Shall I increase transmitter power?", NULL, "Increase transmitter power.", NULL },
    { "QRP", "Shall I decrease transmitter power?", NULL, "Decrease transmitter power.", NULL },
    { "QRQ", "Shall I send faster?", NULL, "Send faster (...words per minute).", NULL },
    { "QRR", "Are you ready for automatic operation?", NULL, "I am ready for automatic operation. Send at...words per minute.", NULL },
    { "QRS", "Shall I send more slowly?", NULL, "Send more slowly (...words per minute).", NULL },
    { "QRT", "Shall I stop sending?", NULL, "Stop sending.", NULL },
    { "QRU", "Have you anything for me?", NULL, "I have nothing for you.", NULL },
    { "QRV", "Are you ready?", NULL, "I am ready.", NULL },
    { "QRW", "Shall I inform...that you are calling him on...kHz(or MHz).", NULL, "Please inform...that I am calling him on...kHz (or MHz).", NULL },
    { "QRX", "When will you call me again?", NULL, "I will call you again at...hours (on...kHz (or MHz).", NULL },
    { "QRY", "What is my turn?", NULL, "Your turn is number...", NULL },
    { "QRZ", "Who is calling me?", NULL, "You are being called by...(on... kHz (or MHz).", NULL },
    { "QSA", "What is the strength of my signals (or those of...)?", NULL, "The strength of your signals (or those of...) is... %.", "1)  scarcely perceptible. 2)  weak. 3)  fairly good. 4)  good. 5)  very good." },
    { "QSB", "Are my signals fading?", NULL, "Your signals are fading.", NULL },
    { "QSC", "Are you a cargo vessel?", NULL, "I am a cargo vessel.", NULL },
    { "QSD", "Is my keying defective?", NULL, "Your keying is defective.", NULL },
    { "QSE", "What is the estimated drift of the survival craft?", NULL, "The estimated drift of the survival craft is...(figures and units).", NULL },
    { "QSF", "Have you effected rescue?", NULL, "I have effected rescue and am proceeding to...base (with... persons injured requiring ambulance).", NULL },
    { "QSG", "Shall I send...telegrams at a time?", NULL, "Send...telegrams at a time.", NULL },
    { "QSH", "Are you able to home on your D/F equipment?", NULL, "I am able to home on my D/F equipment (on station...).", NULL },
    { "QSI", NULL, NULL, "I have been unable to break in on your transmission.or Will you inform...(call sign) that I have been unable to break in on his transmission (on...kHz. (or...MHz)).", NULL },
    { "QSJ", "What is the charge to be collected to...including your internal telegraph charge?", NULL, "The charge to be collected to... including my internal telegraph charge is...francs.", NULL },
    { "QSK", "Can you hear me between your signals and if so can I break in on your transmission?", NULL, "I can hear you between my signals; break in on my transmission.", NULL },
    { "QSL", "Can you acknowledge receipt?", NULL, "I am acknowledging receipt", NULL },
    { "QSM", "Shall I repeat the last telegram which I sent you(or some previous telegram)?", NULL, "Repeat the last telegram which you sent me (or telegram(s) number(s)...).", NULL },
    { "QSN", "Did you hear me (or... (call sign)) on... kHz (or MHz)?", NULL, "I did hear you (or...(call sign)) on...kHz (or MHz).", NULL },
    { "QSO", "Can you communicate with... direct or by relay?", NULL, "I can communicate with...direct(or by relay through...).", NULL },
    { "QSP", "Will you relay to...free of charge?", NULL, "I will relay to...free of charge.", NULL },
    { "QSQ", "Have you a doctor on board (or is...(name of person) on board)?", NULL, "I have a doctor on board (or... (name of person) is on board).", NULL },
    { "QSR", "Shall I repeat the call on the calling frequency?", NULL, "Repeat your call on the calling frequency; did not hear you (or have interference).", NULL },
    { "QSS", "What working frequency will you use?", NULL, "I will use the working frequency...kHz (normally only the last three figures of the frequency need be given).", NULL },
    { "QST", NULL, NULL, NULL, NULL },
    { "QSU", "Shall I send or reply on this frequency (or on... kHz (or MHz)) (with emissions of class...)?", NULL, "Send or reply on this frequency(or on...kHz (or MHz)) (with emissions of class...).", NULL },
    { "QSV", "Shall I send a series of V's on this frequency (or...kHz (or MHz))?", NULL, "Send a series of V's on this frequency (or on...kHz (or MHz)).", NULL },
    { "QSW", "Will you send on this frequency (or on...kHz (or MHz)) (with emissions of class...)?", NULL, "I am going to send on this frequency (or on...kHz (or MHz)) (with emissions of class...).", NULL },
    { "QSX", "Will you listen to...(call sign(s)) on...kHz (or MHz)?", NULL, "I am listening to...(call sign(s)) on...kHz (or MHz).", NULL },
    { "QSY", "Shall I change to transmission on another frequency?", NULL, "Change to transmission on another frequency (or on...kHz (or MHz)).", NULL },
    { "QSZ", "Shall I send each word or group more than once?", NULL, "Send each word or group twice(or...times).", NULL },
    { "QTA", "Shall I cancel telegram number...?", NULL, "Cancel telegram number...", NULL },
    { "QTB", "Do you agree with my counting of words?", NULL, "I do not agree with your counting of words; I will repeat the first letter or digit of each word or group.", NULL },
    { "QTC", "How many telegrams have you to send?", NULL, "I have...telegrams for you (or for...).", NULL },
    { "QTD", "What has the rescue vessel or rescue aircraft recovered?", NULL, "...(identification) has recovered %.", "1) ...(number) survivors. 2) ...wreckage. 3) ...(number) bodies." },
    { "QTE", "What is the TRUE bearing of...(call sign) from...(call sign)?", NULL, "The TRUE bearing of...(call sign) from...(call sign) was...degrees at...hours.", NULL },
    { "QTF", "Will you give me the position of my station according to the bearings taken by the D/F stations which you control?", NULL, "The position of your station according to the bearings taken by the D/F stations which I control was... latitude... longitude (or other indication of position), class...at...hours.", NULL },
    { "QTG", "Will you send two dashes of ten seconds each followed by your call sign (repeated...times) (on...kHz (or MHz))?", NULL, "I am going to send two dashes of ten seconds each followed by my call sign (repeated ...times) (on...kHz (or MHz)).", NULL },
    { "QTH", "What is your position in latitude and longitude (or... according to any other indication)?", NULL, "My position is...latitude longitude (or according to any other indication).", NULL },
    { "QTI", "What is your TRUE track?", NULL, "My TRUE track is...degrees.", NULL },
    { "QTJ", "What is your speed?", NULL, "My speed is...knots (or... kilometers or...statute miles per hour).", NULL },
    { "QTK", "What is the speed of your aircraft in relation to the surface of the earth?", NULL, "The speed of my aircraft in relation to the surface of the earth is...knots (or...kilometers or...statute miles per hour).", NULL },
    { "QTL", "What is your TRUE heading?", NULL, "My TRUE heading is...degrees.", NULL },
    { "QTM", "What is your MAGNETIC heading?", NULL, "My MAGNETIC heading is...degrees.", NULL },
    { "QTN", "At what time did you depart from...(place)?", NULL, "I departed from...(place) at...hours.", NULL },
    { "QTO", "Are you airborne/left dock?", NULL, "I am airborne.", NULL },
    { "QTP", "Are you going to alight (or land)?", NULL, "I am going to alight (or land).", NULL },
    { "QTQ", "Can you communicate with my station by means of the international code of signals?", NULL, "I am going to communicate with your station by means of the international code of signals.", NULL },
    { "QTR", "What is the correct time?", NULL, "The correct time is...hours.", NULL },
    { "QTS", "Will you send your call sign for tuning purposes or so that your frequency can be measured now (or at...hours) on...kHz (or MHz)?", NULL, "I will send my call sign for tuning purposes or so that my frequency may be measured now (or at...hours) on...kHz (or MHz).", NULL },
    { "QTT", NULL, NULL, "The identification signal which follows is superimposed on another transmission.", NULL },
    { "QTU", "What are the hours during which your station is open?", NULL, "My station is open from... to...hours.", NULL },
    { "QTV", "Shall I stand guard for you on the frequency of...kHz(or MHz) (from...to...hours)?", NULL, "Stand guard for me on the frequency of...kHz (or MHz) (from...to...hours).", NULL },
    { "QTW", "What is the condition of survivors?", NULL, "Survivors are in...condition and urgently need...", NULL },
    { "QTX", "Will you keep your station open for further communication with me until further notice (or until...hours)?", NULL, "I will keep my station open for further communication with you until further notice (or until... hours).", NULL },
    { "QTY", "Are you proceeding to the position of incident and if so when do you expect to arrive?", NULL, "I am proceeding to the position of incident and expect to arrive at...hours (on...date).", NULL },
    { "QTZ", "Are you continuing the search?", NULL, "I am continuing the search for.. (aircraft, ship, survival craft,. survivors or wreckage).", NULL },
    { "QUA", "Have you news of... (call sign)?", NULL, "Here is news of...(call sign).", NULL },
    { "QUB", "Can you give me in the following order information concerning: the direction.... in degrees TRUE and speed of the surface wind; visibility; present weather; and amount, type and height of base of cloud above surface elevation at...(place of observation)?", NULL, "Here is the information requested (The units used for speed and distances should be indicated.)", NULL },
    { "QUC", "What is the number (or other indication) of the last message you received from me(or from...(call sign))?", NULL, "The number (or other indication) of the last message I received from you (or from... (call sign)) is...", NULL },
    { "QUD", "Have you received the urgency signal sent by... (call sign of mobile station)?", NULL, "I have received the urgency signal sent by...(call sign of mobile station) at...hours.", NULL },
    { "QUE", "Can you use telephony in... (language), with interpreter if necessary; if so, on what frequencies?", NULL, "I can use telephony in... (language) on...kHz (or MHz).", NULL },
    { "QUF", "Have you received the distress signal sent by... (call sign of mobile station)?", NULL, "I have received the distress signal sent by...(call sign of mobile station) at...hours.", NULL },
    { "QUG", "Will you be forced to alight(or land)?", NULL, "I am forced to alight (or land) immediately.", NULL },
    { "QUH", "Will you give me the present barometric pressure at sea level?", NULL, "The present barometric pressure at sea level is...(units).", NULL },
    { "QUI", "Are your navigation lights working?", NULL, "My navigation lights are working.", NULL },
    { "QUJ", "Will you indicate the TRUE track to reach you (or...)?", NULL, "The TRUE track to reach me (or...) is...degrees at...hours.", NULL },
    { "QUK", "Can you tell me the condition of the sea observed at... (place or coordinates)?", NULL, "The sea at...(place or coordinates) is...", NULL }, // Aeronautical Note:  Stations of the international aeronautical telecommunication service will complete the answer, information or advice form by the use of a numbered alternative as given hereunder, selected according to the average wave height as obtained from the larger well formed waves of the wave system being observed. If observed height coincides with one of the limits, report the lower numbered alternative, e.g. waves with a mean maximum height of 4 meters are to be reported as "5". Number Height Meters Feet (approx.) 0 Calm-glassy 0 0 1 Calm- rippled 0 - 0.1 0 - 1/3 2 Smooth Wavelets 0.1 - 0.5 1/3 - 1 2/3 3 Slight 0.5 - 1.25 1 2/3 - 4 4 Moderate 1.25 - 2.5 4 - 8 5 Rough 2.5 - 4 8 - 13 6 Very Rough 4 - 6 13 - 20 7 High 6 - 9 20 - 30 8 Very High 9 - 14 30 - 45 9 Phenomenal Over 14 Over 45", NULL },
    { "QUL", "Can you tell me the swell observed at...(place or coordinates)?", NULL, "The swell at...(place or coordinates) is...", NULL }, // Aeronautical Note:  Stations of the international aeronautical telecommunication service will complete the answer, information or advice form by the use of the following numbered alternatives: Number Length of Swell Height Number Length of Swell Height 0 - - 5 Long Moderate 1 Short or Average Low 6 Short Heavy 2 Long Low 7 Average Heavy 3 Short Moderate 8 Long Heavy 4 Average Moderate 9 Confused - Additionally, stations of the international aeronautical telecommunication service may indicate the direction of swell by the use of the appropriate cardinal or quandrantal point abbreviation N, NE, E, SE, etc. following the numbered alternate for indicating swell condition.  The descriptions in the above numbered alternatives are as follows: Length of Swell Meters Feet (Approx.) Short 0 - 100 0- 300 Average 100 - 200 300 - 600 Long Over 200 Over 600 Height of Swell Meters Feet (Approx.) Low 0 - 2 0 - 7 Moderate 2 - 4 7 - 13 Heavy Over 4 Over 13 When there is no swell, the numbered alternative "0" is used; when the swell is such that the length and height of the swell waves cannot be determined, the numbered alternative "9" is used.", NULL },
    { "QUM", "May I resume normal working?", NULL, "Normal working may be resumed.", NULL },
    { "QUN", "Will vessels in my immediate vicinity (or in the vicinity of...latitude ...longitude(or of...)) please indicate their position, TRUE course and speed?", NULL, "My position, TRUE course and speed are..." },
    { "QUO", "Shall I search for... % in the vicinity of... latitude...longitude (or according to any other indication)?", "1) aircraft, 2) ship, 3) survival craft", "Please search for... % in the vicinity of...latitude... longitude (or according to any other indication).", "1) aircraft, 2) ship, 3) survival craft" },
    { "QUP", "Will you indicate your position by... %", "1) searchlight? 2) black smoke trail? 3) pyrotechnic lights?", "My position is indicated by... %.", "1) searchlight. 2) black smoke trail. 3) pyrotechnic lights." },
    { "QUQ", "Shall I train my searchlight nearly vertical on a cloud, occulting if possible and, if your aircraft is seen or heard, deflect the beam up wind and on the water (or land) to facilitate your landing?", NULL, "Please train your searchlight on a cloud, occulting if possible and, if my aircraft is seen or heard, deflect the beam up wind and on the water (or land) to facilitate my landing.", NULL },
    { "QUR", "Have survivors... %", "1) received survival equipment? 2) been picked up by rescue vessel 3) been reached by ground rescue party?", "Survivors... %.", "1) are in possession of survival equipment dropped by... 2) have been picked up by rescue vessel. 3) have been reached by ground rescue party." },
    { "QUS", "Have you sighted survivors or wreckage? If so, in what position?", NULL, "Have sighted... %.", "1) survivors in water, 2) survivors on rafts, 3) wreckage,  in position... latitude... longitude (or according to any other indication)." },
    { "QUT", "Is position of incident marked?", NULL, "Position of incident is marked by... %.", "1) flame or smoke float. 2) sea marker. 3) sea marker dye. 4) ...(specify other marking)." },
    { "QUU", "Shall I home ship or aircraft to my position?", NULL, "Home ship or aircraft...(call sign) ... %.", "1) to your position by transmitting your call sign and long dashes on...kHz (or MHz). 2) by transmitting on...kHz (or MHz) TRUE track to reach you." },
    { "QUV", NULL, NULL, NULL, NULL },
    { "QUW", "Are you in the search area designated as...(designator or latitude and longitude)?", NULL, "I am in the...(designation) search area.", NULL },
    { "QUX", "Do you have any navigational warning or gale warnings in force?", NULL, "I have the following navigational warning(s) or gale warning(s) in force...", NULL },
    { "QUY", "Is position of survival craft marked?", NULL, "Position of survival craft was marked at...hours by... %.", "1)flame or smoke float 2)sea marker 3)sea marker dye 4)...(specify other marking)." },
    { "QUZ", "May I resume restricted working?", NULL, "Distress phase still in force; restricted working may be resumed.", NULL },
    { NULL,  NULL, NULL, NULL, NULL }
 };
