/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * ResourcesCustomizer.java
 *
 * Created on Aug 31, 2010, 5:46:57 PM
 */

package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;


/**
 *
 * @author Tomas Zezula
 */
public final class ResourcesCustomizer extends javax.swing.JPanel {
    
    private static final Icon JAR_ICON = ImageUtilities.loadImageIcon(
            "org/netbeans/modules/javawebstart/resources/jar.gif",   // NOI18N
            false);

    /** Creates new form ResourcesCustomizer */
    ResourcesCustomizer(
            final Collection<? extends File> runtimeClassPath,
            final Collection<? extends File> lazyJars) {
        initComponents();
        final TableCellRenderer renderer = new LoadRenderer();
        this.resources.setModel(createModel(createResources(runtimeClassPath, lazyJars)));
        this.resources.setDefaultRenderer(Boolean.class, renderer);        
        this.resources.setDefaultRenderer(File.class, renderer);
        this.resources.setDefaultEditor(Boolean.class, createEditor());
    }
    
    List<File> getResources() {
        final TableModel model = this.resources.getModel();
        final List<File> result = new LinkedList<File>();
        for (int i=0; i< model.getRowCount(); i++) {
            if ((Boolean)model.getValueAt(i, 1)) {
                result.add((File)model.getValueAt(i, 0));
            }
        }
        return result;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        resources = new javax.swing.JTable();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setLabelFor(resources);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(ResourcesCustomizer.class, "TXT_Resources")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 6, 12);
        add(jLabel1, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 300));

        resources.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null},
                {null, null},
                {null, null},
                {null, null}
            },
            new String [] {
                "Jar", "Load"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(resources);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 230;
        gridBagConstraints.ipady = 74;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 12, 12);
        add(jScrollPane1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable resources;
    // End of variables declaration//GEN-END:variables

    private static class LoadRenderer extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String strValue = "";   //NOI18N
            String toolTip = null;
            Icon icon = null;
            if (value instanceof Boolean) {
                strValue = NbBundle.getMessage(ResourcesCustomizer.class, value == Boolean.TRUE ? "TXT_LAZY":"TXT_EAGER");
            } else if (value instanceof File) {
                final File f = (File)value;
                strValue = f.getName();
                toolTip = f.getAbsolutePath();
                icon = JAR_ICON;
            }
            final Component c = super.getTableCellRendererComponent(
                    table,
                    strValue, //NOI18N
                    isSelected,
                    hasFocus,
                    row,
                    column);
            if (c instanceof JLabel) {
                JLabel label = (JLabel) c;
                label.setToolTipText (toolTip);
                label.setIcon(icon);
            }
            return c;
        }        
    }
    
    private static TableCellEditor createEditor() {
        final JComboBox combo = new JComboBox(new Object[] {Boolean.TRUE, Boolean.FALSE});
        combo.setRenderer(new DefaultListCellRenderer(){
            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(
                        list,
                        NbBundle.getMessage(ResourcesCustomizer.class, value == Boolean.TRUE ? "TXT_LAZY":"TXT_EAGER"),
                        index,
                        isSelected,
                        cellHasFocus);
            }            
        });
        return new DefaultCellEditor(combo);
    }
    
    private static TableModel createModel(final Map<File,Boolean> jars) {
        final Object[][] data = new Object[jars.size()][];
        final Iterator<Map.Entry<File,Boolean>> it = jars.entrySet().iterator();
        for (int i=0; it.hasNext(); i++) {
            final Map.Entry<File,Boolean> entry = it.next();
            data[i] = new Object[] {entry.getKey(),entry.getValue()};
        }
        return new DefaultTableModel(
            data,
            new String[] {
                NbBundle.getMessage(ResourcesCustomizer.class, "TXT_ArchiveFile"),
                NbBundle.getMessage(ResourcesCustomizer.class, "TXT_Load")
            }) {
            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0:
                        return File.class;
                    case 1:
                        return Boolean.class;
                    default:
                        throw new IllegalStateException();
                }
            }
            
        };
    }
    
    private static Map<File,Boolean> createResources(
            final Collection<? extends File> runtimeClassPath,
            final Collection<? extends File> lazyJars) {        
        final Map<File,Boolean> result = new LinkedHashMap<File, Boolean>();
        final Set<File> lazy = new HashSet<File>(lazyJars);                       
        for (final File p : runtimeClassPath) {
            result.put(p, lazy.contains(p));
        }
        return result;
    }    
}
