/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.profiler.selector.java.project.nodes;

import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndex.SearchScope;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.selector.java.nodes.JavaPackageNode;
import org.netbeans.modules.profiler.selector.spi.nodes.PackageNode;


/**
 *
 * @author Jaroslav Bachorik
 */
class ProjectPackages extends SelectorChildren<ContainerNode> {
    //~ Enumerations -------------------------------------------------------------------------------------------------------------

    public static enum PackageType {//~ Enumeration constant initializers ------------------------------------------------------------------------------------

        Libraries, Source;
    }

    //~ Instance fields ----------------------------------------------------------------------------------------------------------

    private final ProjectPackages.PackageType packageType;
    private final Set<SearchScope> scope = new HashSet<SearchScope>();
    private final boolean subprojects;

    //~ Constructors -------------------------------------------------------------------------------------------------------------

    public ProjectPackages(final ProjectPackages.PackageType type, final boolean includeSubprojects) {
        this.packageType = type;

        switch (type) {
            case Source:
                scope.add(SearchScope.SOURCE);

                break;
            case Libraries:
                scope.add(SearchScope.DEPENDENCIES);

                break;
        }

        this.subprojects = includeSubprojects;
    }

    //~ Methods ------------------------------------------------------------------------------------------------------------------

    protected List<SelectorNode> prepareChildren(ContainerNode parent) {
        List<SelectorNode> pkgs = new ArrayList<SelectorNode>();

        Project project = parent.getLookup().lookup(Project.class);

        ClasspathInfo cpInfo = ProjectUtilities.getClasspathInfo(project, subprojects, scope.contains(SearchScope.SOURCE),
                                                                 scope.contains(SearchScope.DEPENDENCIES));
        // #170201: A misconfigured(?) project can have no source roots defined, returning NULL as its ClasspathInfo
        // ignore such a project
        if (cpInfo != null) {
            ClassIndex index = cpInfo.getClassIndex();

            for (String pkgName : index.getPackageNames("", true, scope)) { // NOI18N
                pkgs.add(new JavaPackageNode(cpInfo, pkgName, parent, scope));
            }

            Collections.sort(pkgs, PackageNode.COMPARATOR);
        }
        return pkgs;
    }
}
