# Monitor anything with Netdata

Netdata uses collectors to help you gather metrics from your favorite applications and services and view them in
real-time, interactive charts. The following list includes all the integrations where Netdata can gather metrics from.

Learn more about [how collectors work](/src/collectors/README.md), and then learn how to [enable or configure](/src/collectors/REFERENCE.md#enable-and-disable-a-specific-collection-module) a specific collector.

> **Note**
>
> Some collectors have both Go and Python versions as we continue our effort to migrate all collectors to Go. In these cases, _Netdata always prioritizes the Go version_, and we highly recommend you use the Go versions for the best experience.

## Add your application to Netdata

If you don't see the app/service you'd like to monitor in this list:

- If your application has a Prometheus endpoint, Netdata can monitor it! Look at our [generic Prometheus collector](/src/go/plugin/go.d/modules/prometheus/README.md).

- If your application is instrumented to expose [StatsD](https://blog.netdata.cloud/introduction-to-statsd/) metrics, see our [generic StatsD collector](/src/collectors/statsd.plugin/README.md).

- If you have data in CSV, JSON, XML or other popular formats, you may be able to use our [generic structured data (Pandas) collector](/src/collectors/python.d.plugin/pandas/README.md),

- Check out our [GitHub issues](https://github.com/netdata/netdata/issues). Use the search bar to look for previous discussions about that collector—we may be looking for assistance from users such as yourself!

- If you don't see the collector there, you can make a [feature request](https://github.com/netdata/netdata/issues/new/choose) on GitHub.

- If you have basic software development skills, you can add your own plugin in [Go](/src/go/plugin/go.d/README.md#how-to-develop-a-collector) or [Python](/docs/developer-and-contributor-corner/python-collector.md)

## Available Data Collection Integrations
<!-- AUTOGENERATED PART BY integrations/gen_doc_collector_page.py SCRIPT, DO NOT EDIT MANUALLY -->
### APM

- [Alamos FE2 server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/alamos_fe2_server.md)

- [Apache Airflow](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/apache_airflow.md)

- [Apache Flink](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/apache_flink.md)

- [Audisto](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/audisto.md)

- [Dependency-Track](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dependency-track.md)

- [Go applications (EXPVAR)](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/go_expvar/integrations/go_applications_expvar.md)

- [Google Pagespeed](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/google_pagespeed.md)

- [IBM AIX systems Njmon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_aix_systems_njmon.md)

- [JMX](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/jmx.md)

- [NRPE daemon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nrpe_daemon.md)

- [Sentry](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sentry.md)

- [Sysload](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sysload.md)

- [VSCode](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/vscode.md)

- [YOURLS URL Shortener](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/yourls_url_shortener.md)

- [bpftrace variables](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bpftrace_variables.md)

- [gpsd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gpsd.md)

- [jolokia](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/jolokia.md)

- [phpDaemon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/phpdaemon/integrations/phpdaemon.md)

### Authentication and Authorization

- [Fail2ban](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/fail2ban/integrations/fail2ban.md)

- [FreeRADIUS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/freeradius/integrations/freeradius.md)

- [HashiCorp Vault secrets](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hashicorp_vault_secrets.md)

- [LDAP](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ldap.md)

- [OpenLDAP (community)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openldap_community.md)

- [OpenLDAP](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/openldap/integrations/openldap.md)

- [RADIUS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/radius.md)

- [SSH](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ssh.md)

- [TACACS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tacacs.md)

### Blockchain Servers

- [Chia](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/chia.md)

- [Crypto exchanges](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/crypto_exchanges.md)

- [Cryptowatch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cryptowatch.md)

- [Go-ethereum](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/geth/integrations/go-ethereum.md)

- [Helium miner (validator)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/helium_miner_validator.md)

- [IOTA full node](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/iota_full_node.md)

- [Sia](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sia.md)

### CICD Platforms

- [Concourse](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/concourse.md)

- [GitLab Runner](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gitlab_runner.md)

- [Jenkins](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/jenkins.md)

- [Puppet](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/puppet/integrations/puppet.md)

### Cloud Provider Managed

- [AWS EC2 Compute instances](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_ec2_compute_instances.md)

- [AWS EC2 Spot Instance](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_ec2_spot_instance.md)

- [AWS ECS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_ecs.md)

- [AWS Health events](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_health_events.md)

- [AWS Quota](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_quota.md)

- [AWS S3 buckets](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_s3_buckets.md)

- [AWS SQS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_sqs.md)

- [AWS instance health](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_instance_health.md)

- [Akamai Global Traffic Management](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/akamai_global_traffic_management.md)

- [Akami Cloudmonitor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/akami_cloudmonitor.md)

- [Alibaba Cloud](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/alibaba_cloud.md)

- [ArvanCloud CDN](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/arvancloud_cdn.md)

- [Azure AD App passwords](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_ad_app_passwords.md)

- [Azure Elastic Pool SQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_elastic_pool_sql.md)

- [Azure Resources](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_resources.md)

- [Azure SQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_sql.md)

- [Azure Service Bus](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_service_bus.md)

- [Azure application](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/azure_application.md)

- [BigQuery](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bigquery.md)

- [CloudWatch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cloudwatch.md)

- [Dell EMC ECS cluster](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dell_emc_ecs_cluster.md)

- [DigitalOcean](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/digitalocean.md)

- [GCP GCE](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gcp_gce.md)

- [GCP Quota](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gcp_quota.md)

- [Google Cloud Platform](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/google_cloud_platform.md)

- [Google Stackdriver](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/google_stackdriver.md)

- [Linode](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/linode.md)

- [Lustre metadata](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/lustre_metadata.md)

- [Nextcloud servers](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nextcloud_servers.md)

- [OpenStack](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openstack.md)

- [Zerto](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/zerto.md)

### Containers and VMs

- [Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/containers.md)

- [Docker Engine](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/docker_engine/integrations/docker_engine.md)

- [Docker Hub repository](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dockerhub/integrations/docker_hub_repository.md)

- [Docker](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/docker/integrations/docker.md)

- [LXC Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/lxc_containers.md)

- [Libvirt Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/libvirt_containers.md)

- [NSX-T](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nsx-t.md)

- [Podman](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/podman.md)

- [Proxmox Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/proxmox_containers.md)

- [Proxmox VE](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/proxmox_ve.md)

- [VMware vCenter Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/vsphere/integrations/vmware_vcenter_server.md)

- [Virtual Machines](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/virtual_machines.md)

- [Xen XCP-ng](https://github.com/netdata/netdata/blob/master/src/collectors/xenstat.plugin/integrations/xen_xcp-ng.md)

- [cAdvisor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cadvisor.md)

- [oVirt Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/ovirt_containers.md)

- [vCenter Server Appliance](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/vcsa/integrations/vcenter_server_appliance.md)

### Databases

- [4D Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/4d_server.md)

- [AWS RDS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aws_rds.md)

- [Cassandra](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/cassandra/integrations/cassandra.md)

- [ClickHouse](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/clickhouse/integrations/clickhouse.md)

- [ClusterControl CMON](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/clustercontrol_cmon.md)

- [CockroachDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/cockroachdb/integrations/cockroachdb.md)

- [CouchDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/couchdb/integrations/couchdb.md)

- [Couchbase](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/couchbase/integrations/couchbase.md)

- [HANA](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hana.md)

- [Hasura GraphQL Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hasura_graphql_server.md)

- [InfluxDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/influxdb.md)

- [Machbase](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/machbase.md)

- [MariaDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/mysql/integrations/mariadb.md)

- [Memcached (community)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/memcached_community.md)

- [Memcached](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/memcached/integrations/memcached.md)

- [MongoDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/mongodb/integrations/mongodb.md)

- [MySQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/mysql/integrations/mysql.md)

- [ODBC](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/odbc.md)

- [Oracle DB (community)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/oracle_db_community.md)

- [Oracle DB](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/oracledb/integrations/oracle_db.md)

- [Patroni](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/patroni.md)

- [Percona MySQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/mysql/integrations/percona_mysql.md)

- [PgBouncer](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/pgbouncer/integrations/pgbouncer.md)

- [Pgpool-II](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/pgpool-ii.md)

- [Pika](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/pika/integrations/pika.md)

- [PostgreSQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/postgres/integrations/postgresql.md)

- [ProxySQL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/proxysql/integrations/proxysql.md)

- [Redis](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/redis/integrations/redis.md)

- [RethinkDB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/rethinkdb/integrations/rethinkdb.md)

- [Riak KV](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/riakkv/integrations/riak_kv.md)

- [SQL Database agnostic](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sql_database_agnostic.md)

- [Vertica](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/vertica.md)

- [Warp10](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/warp10.md)

- [pgBackRest](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/pgbackrest.md)

### Distributed Computing Systems

- [BOINC](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/boinc/integrations/boinc.md)

- [Gearman](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/gearman/integrations/gearman.md)

### DNS and DHCP Servers

- [Akamai Edge DNS Traffic](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/akamai_edge_dns_traffic.md)

- [CoreDNS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/coredns/integrations/coredns.md)

- [DNS query](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dnsquery/integrations/dns_query.md)

- [DNSBL](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dnsbl.md)

- [DNSdist](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dnsdist/integrations/dnsdist.md)

- [Dnsmasq DHCP](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dnsmasq_dhcp/integrations/dnsmasq_dhcp.md)

- [Dnsmasq](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dnsmasq/integrations/dnsmasq.md)

- [ISC DHCP](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/isc_dhcpd/integrations/isc_dhcp.md)

- [NSD](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nsd/integrations/nsd.md)

- [NextDNS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nextdns.md)

- [Pi-hole](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/pihole/integrations/pi-hole.md)

- [PowerDNS Authoritative Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/powerdns/integrations/powerdns_authoritative_server.md)

- [PowerDNS Recursor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/powerdns_recursor/integrations/powerdns_recursor.md)

- [Unbound](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/unbound/integrations/unbound.md)

### eBPF

- [eBPF Cachestat](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_cachestat.md)

- [eBPF DCstat](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_dcstat.md)

- [eBPF Disk](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_disk.md)

- [eBPF Filedescriptor](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_filedescriptor.md)

- [eBPF Filesystem](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_filesystem.md)

- [eBPF Hardirq](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_hardirq.md)

- [eBPF MDflush](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_mdflush.md)

- [eBPF Mount](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_mount.md)

- [eBPF OOMkill](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_oomkill.md)

- [eBPF Process](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_process.md)

- [eBPF Processes](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_processes.md)

- [eBPF SHM](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_shm.md)

- [eBPF SWAP](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_swap.md)

- [eBPF Socket](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_socket.md)

- [eBPF SoftIRQ](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_softirq.md)

- [eBPF Sync](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_sync.md)

- [eBPF VFS](https://github.com/netdata/netdata/blob/master/src/collectors/ebpf.plugin/integrations/ebpf_vfs.md)

### FreeBSD

- [FreeBSD NFS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/freebsd_nfs.md)

- [FreeBSD RCTL-RACCT](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/freebsd_rctl-racct.md)

- [dev.cpu.0.freq](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/dev.cpu.0.freq.md)

- [dev.cpu.temperature](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/dev.cpu.temperature.md)

- [devstat](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/devstat.md)

- [getifaddrs](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/getifaddrs.md)

- [getmntinfo](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/getmntinfo.md)

- [hw.intrcnt](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/hw.intrcnt.md)

- [ipfw](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/ipfw.md)

- [kern.cp_time](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/kern.cp_time.md)

- [kern.ipc.msq](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/kern.ipc.msq.md)

- [kern.ipc.sem](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/kern.ipc.sem.md)

- [kern.ipc.shm](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/kern.ipc.shm.md)

- [net.inet.icmp.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet.icmp.stats.md)

- [net.inet.ip.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet.ip.stats.md)

- [net.inet.tcp.states](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet.tcp.states.md)

- [net.inet.tcp.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet.tcp.stats.md)

- [net.inet.udp.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet.udp.stats.md)

- [net.inet6.icmp6.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet6.icmp6.stats.md)

- [net.inet6.ip6.stats](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.inet6.ip6.stats.md)

- [net.isr](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/net.isr.md)

- [system.ram](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/system.ram.md)

- [uptime](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/uptime.md)

- [vm.loadavg](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.loadavg.md)

- [vm.stats.sys.v_intr](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.stats.sys.v_intr.md)

- [vm.stats.sys.v_soft](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.stats.sys.v_soft.md)

- [vm.stats.sys.v_swtch](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.stats.sys.v_swtch.md)

- [vm.stats.vm.v_pgfaults](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.stats.vm.v_pgfaults.md)

- [vm.stats.vm.v_swappgs](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.stats.vm.v_swappgs.md)

- [vm.swap_info](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.swap_info.md)

- [vm.vmtotal](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/vm.vmtotal.md)

- [zfs](https://github.com/netdata/netdata/blob/master/src/collectors/freebsd.plugin/integrations/zfs.md)

### FTP Servers

- [ProFTPD](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/proftpd.md)

### Gaming

- [BungeeCord](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bungeecord.md)

- [Minecraft](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/minecraft.md)

- [OpenRCT2](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openrct2.md)

- [SpigotMC](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/spigotmc/integrations/spigotmc.md)

- [Steam](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/steam.md)

### Generic Data Collection

- [Custom Exporter](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/custom_exporter.md)

- [Excel spreadsheet](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/excel_spreadsheet.md)

- [Generic Command Line Output](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/generic_command_line_output.md)

- [JetBrains Floating License Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/jetbrains_floating_license_server.md)

- [OpenWeatherMap](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openweathermap.md)

- [Pandas](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/pandas/integrations/pandas.md)

- [Prometheus endpoint](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/prometheus_endpoint.md)

- [SNMP devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/snmp/integrations/snmp_devices.md)

- [Shell command](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/shell_command.md)

- [Tankerkoenig API](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tankerkoenig_api.md)

- [TwinCAT ADS Web Service](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/twincat_ads_web_service.md)

### Hardware Devices and Sensors

- [1-Wire Sensors](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/w1sensor/integrations/1-wire_sensors.md)

- [AM2320](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/am2320/integrations/am2320.md)

- [AMD CPU & GPU](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/amd_cpu_&_gpu.md)

- [AMD GPU](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/amd_gpu.md)

- [ARM HWCPipe](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/arm_hwcpipe.md)

- [CUPS](https://github.com/netdata/netdata/blob/master/src/collectors/cups.plugin/integrations/cups.md)

- [HDD temperature](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/hddtemp/integrations/hdd_temperature.md)

- [HP iLO](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hp_ilo.md)

- [IBM CryptoExpress (CEX) cards](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_cryptoexpress_cex_cards.md)

- [IBM Z Hardware Management Console](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_z_hardware_management_console.md)

- [IPMI (By SoundCloud)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ipmi_by_soundcloud.md)

- [Intel GPU](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/intelgpu/integrations/intel_gpu.md)

- [Intelligent Platform Management Interface (IPMI)](https://github.com/netdata/netdata/blob/master/src/collectors/freeipmi.plugin/integrations/intelligent_platform_management_interface_ipmi.md)

- [Linux Sensors (lm-sensors)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/sensors/integrations/linux_sensors_lm-sensors.md)

- [Linux Sensors (sysfs)](https://github.com/netdata/netdata/blob/master/src/collectors/charts.d.plugin/sensors/integrations/linux_sensors_sysfs.md)

- [NVML](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nvml.md)

- [Nvidia GPU](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nvidia_smi/integrations/nvidia_gpu.md)

- [Raritan PDU](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/raritan_pdu.md)

- [S.M.A.R.T.](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/smartctl/integrations/s.m.a.r.t..md)

- [ServerTech](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/servertech.md)

- [Siemens S7 PLC](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/siemens_s7_plc.md)

- [T-Rex NVIDIA GPU Miner](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/t-rex_nvidia_gpu_miner.md)

### IoT Devices

- [Airthings Waveplus air sensor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/airthings_waveplus_air_sensor.md)

- [Bobcat Miner 300](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bobcat_miner_300.md)

- [Christ Elektronik CLM5IP power panel](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/christ_elektronik_clm5ip_power_panel.md)

- [CraftBeerPi](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/craftbeerpi.md)

- [Dutch Electricity Smart Meter](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dutch_electricity_smart_meter.md)

- [Elgato Key Light devices.](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/elgato_key_light_devices..md)

- [Energomera smart power meters](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/energomera_smart_power_meters.md)

- [Helium hotspot](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/helium_hotspot.md)

- [Homebridge](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/homebridge.md)

- [Homey](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/homey.md)

- [Jarvis Standing Desk](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/jarvis_standing_desk.md)

- [MP707 USB thermometer](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mp707_usb_thermometer.md)

- [Modbus protocol](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/modbus_protocol.md)

- [Monnit Sensors MQTT](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/monnit_sensors_mqtt.md)

- [Nature Remo E lite devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nature_remo_e_lite_devices.md)

- [Netatmo sensors](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/netatmo_sensors.md)

- [OpenHAB](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openhab.md)

- [Personal Weather Station](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/personal_weather_station.md)

- [Philips Hue](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/philips_hue.md)

- [Pimoroni Enviro+](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/pimoroni_enviro+.md)

- [Powerpal devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/powerpal_devices.md)

- [Radio Thermostat](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/radio_thermostat.md)

- [SMA Inverters](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sma_inverters.md)

- [Salicru EQX inverter](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/salicru_eqx_inverter.md)

- [Sense Energy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sense_energy.md)

- [Shelly humidity sensor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/shelly_humidity_sensor.md)

- [Smart meters SML](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/smart_meters_sml.md)

- [Solar logging stick](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/solar_logging_stick.md)

- [SolarEdge inverters](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/solaredge_inverters.md)

- [Solis Ginlong 5G inverters](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/solis_ginlong_5g_inverters.md)

- [Sunspec Solar Energy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sunspec_solar_energy.md)

- [TP-Link P110](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tp-link_p110.md)

- [Tado smart heating solution](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tado_smart_heating_solution.md)

- [Tesla Powerwall](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tesla_powerwall.md)

- [Tesla Wall Connector](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tesla_wall_connector.md)

- [Tesla vehicle](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/tesla_vehicle.md)

- [Xiaomi Mi Flora](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/xiaomi_mi_flora.md)

- [iqAir AirVisual air quality monitors](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/iqair_airvisual_air_quality_monitors.md)

### Kubernetes

- [Cilium Agent](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cilium_agent.md)

- [Cilium Operator](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cilium_operator.md)

- [Cilium Proxy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cilium_proxy.md)

- [Kubelet](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/k8s_kubelet/integrations/kubelet.md)

- [Kubeproxy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/k8s_kubeproxy/integrations/kubeproxy.md)

- [Kubernetes Cluster Cloud Cost](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kubernetes_cluster_cloud_cost.md)

- [Kubernetes Cluster State](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/k8s_state/integrations/kubernetes_cluster_state.md)

- [Kubernetes Containers](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/kubernetes_containers.md)

- [Rancher](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/rancher.md)

### Linux Systems

- [CPU performance](https://github.com/netdata/netdata/blob/master/src/collectors/perf.plugin/integrations/cpu_performance.md)

- [Disk space](https://github.com/netdata/netdata/blob/master/src/collectors/diskspace.plugin/integrations/disk_space.md)

- [OpenRC](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openrc.md)

#### CPU

- [Interrupts](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/interrupts.md)

- [SoftIRQ statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/softirq_statistics.md)

#### Disk

- [Disk Statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/disk_statistics.md)

- [MD RAID](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/md_raid.md)

##### BTRFS

- [BTRFS](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/btrfs.md)

##### NFS

- [NFS Client](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/nfs_client.md)

- [NFS Server](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/nfs_server.md)

##### ZFS

- [ZFS Adaptive Replacement Cache](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/zfs_adaptive_replacement_cache.md)

#### Firewall

- [Conntrack](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/conntrack.md)

- [Netfilter](https://github.com/netdata/netdata/blob/master/src/collectors/nfacct.plugin/integrations/netfilter.md)

- [Synproxy](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/synproxy.md)

- [nftables](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nftables.md)

#### IPC

- [Inter Process Communication](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/inter_process_communication.md)

#### Kernel

- [Linux kernel SLAB allocator statistics](https://github.com/netdata/netdata/blob/master/src/collectors/slabinfo.plugin/integrations/linux_kernel_slab_allocator_statistics.md)

- [Power Capping](https://github.com/netdata/netdata/blob/master/src/collectors/debugfs.plugin/integrations/power_capping.md)

#### Memory

- [Kernel Same-Page Merging](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/kernel_same-page_merging.md)

- [Linux ZSwap](https://github.com/netdata/netdata/blob/master/src/collectors/debugfs.plugin/integrations/linux_zswap.md)

- [Memory Statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/memory_statistics.md)

- [Memory Usage](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/memory_usage.md)

- [Memory modules (DIMMs)](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/memory_modules_dimms.md)

- [Non-Uniform Memory Access](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/non-uniform_memory_access.md)

- [Page types](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/page_types.md)

- [System Memory Fragmentation](https://github.com/netdata/netdata/blob/master/src/collectors/debugfs.plugin/integrations/system_memory_fragmentation.md)

- [ZRAM](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/zram.md)

#### Network

- [Access Points](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/ap/integrations/access_points.md)

- [IP Virtual Server](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/ip_virtual_server.md)

- [IPv6 Socket Statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/ipv6_socket_statistics.md)

- [InfiniBand](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/infiniband.md)

- [Network interfaces](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/network_interfaces.md)

- [Network statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/network_statistics.md)

- [SCTP Statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/sctp_statistics.md)

- [Socket statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/socket_statistics.md)

- [Softnet Statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/softnet_statistics.md)

- [Wireless network interfaces](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/wireless_network_interfaces.md)

- [tc QoS classes](https://github.com/netdata/netdata/blob/master/src/collectors/tc.plugin/integrations/tc_qos_classes.md)

#### Power Supply

- [Power Supply](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/power_supply.md)

#### Pressure

- [Pressure Stall Information](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/pressure_stall_information.md)

#### System

- [Entropy](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/entropy.md)

- [System Load Average](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/system_load_average.md)

- [System Uptime](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/system_uptime.md)

- [System statistics](https://github.com/netdata/netdata/blob/master/src/collectors/proc.plugin/integrations/system_statistics.md)

### Logs Servers

- [AuthLog](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/authlog.md)

- [Fluentd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/fluentd/integrations/fluentd.md)

- [Graylog Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/graylog_server.md)

- [Logstash](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/logstash/integrations/logstash.md)

- [journald](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/journald.md)

- [loki](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/loki.md)

- [mtail](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mtail.md)

### macOS Systems

- [Apple Time Machine](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/apple_time_machine.md)

- [macOS](https://github.com/netdata/netdata/blob/master/src/collectors/macos.plugin/integrations/macos.md)

### Mail Servers

- [DMARC](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dmarc.md)

- [Dovecot](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dovecot/integrations/dovecot.md)

- [Exim](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/exim/integrations/exim.md)

- [Halon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/halon.md)

- [Maildir](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/maildir.md)

- [Postfix](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/postfix/integrations/postfix.md)

### Media Services

- [Discourse](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/discourse.md)

- [Icecast](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/icecast/integrations/icecast.md)

- [OBS Studio](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/obs_studio.md)

- [SABnzbd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sabnzbd.md)

- [Stream](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/stream.md)

- [Twitch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/twitch.md)

- [Zulip](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/zulip.md)

### Message Brokers

- [ActiveMQ](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/activemq/integrations/activemq.md)

- [Apache Pulsar](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/pulsar/integrations/apache_pulsar.md)

- [Beanstalk](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/beanstalk/integrations/beanstalk.md)

- [IBM MQ](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_mq.md)

- [Kafka Connect](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kafka_connect.md)

- [Kafka ZooKeeper](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kafka_zookeeper.md)

- [Kafka](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kafka.md)

- [MQTT Blackbox](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mqtt_blackbox.md)

- [RabbitMQ](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/rabbitmq/integrations/rabbitmq.md)

- [Redis Queue](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/redis_queue.md)

- [VerneMQ](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/vernemq/integrations/vernemq.md)

- [XMPP Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/xmpp_server.md)

- [mosquitto](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mosquitto.md)

### Networking Stack and Network Interfaces

- [8430FT modem](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/8430ft_modem.md)

- [A10 ACOS network devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/a10_acos_network_devices.md)

- [Andrews & Arnold line status](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/andrews_&_arnold_line_status.md)

- [Aruba devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/aruba_devices.md)

- [Bird Routing Daemon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bird_routing_daemon.md)

- [Checkpoint device](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/checkpoint_device.md)

- [Cisco ACI](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cisco_aci.md)

- [Citrix NetScaler](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/citrix_netscaler.md)

- [DDWRT Routers](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ddwrt_routers.md)

- [FRRouting](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/frrouting.md)

- [Fortigate firewall](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/fortigate_firewall.md)

- [Freifunk network](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/freifunk_network.md)

- [Fritzbox network devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/fritzbox_network_devices.md)

- [Hitron CGN series CPE](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hitron_cgn_series_cpe.md)

- [Hitron CODA Cable Modem](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hitron_coda_cable_modem.md)

- [Huawei devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/huawei_devices.md)

- [Keepalived](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/keepalived.md)

- [Meraki dashboard](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/meraki_dashboard.md)

- [MikroTik devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mikrotik_devices.md)

- [Mikrotik RouterOS devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mikrotik_routeros_devices.md)

- [NetFlow](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/netflow.md)

- [NetMeter](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/netmeter.md)

- [Open vSwitch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/open_vswitch.md)

- [OpenROADM devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openroadm_devices.md)

- [RIPE Atlas](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ripe_atlas.md)

- [SONiC NOS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sonic_nos.md)

- [SmartRG 808AC Cable Modem](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/smartrg_808ac_cable_modem.md)

- [Starlink (SpaceX)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/starlink_spacex.md)

- [Traceroute](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/traceroute.md)

- [Ubiquiti UFiber OLT](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ubiquiti_ufiber_olt.md)

- [Zyxel GS1200-8](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/zyxel_gs1200-8.md)

### Incident Management

- [OTRS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/otrs.md)

- [StatusPage](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/statuspage.md)

### Observability

- [Collectd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/collectd.md)

- [Dynatrace](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dynatrace.md)

- [Grafana](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/grafana.md)

- [Hubble](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hubble.md)

- [Naemon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/naemon.md)

- [Nagios](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/nagios.md)

- [New Relic](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/new_relic.md)

### Other

- [Files and directories](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/filecheck/integrations/files_and_directories.md)

- [GitHub API rate limit](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/github_api_rate_limit.md)

- [GitHub repository](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/github_repository.md)

- [python.d zscores](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/zscores/integrations/python.d_zscores.md)

### Processes and System Services

- [Applications](https://github.com/netdata/netdata/blob/master/src/collectors/apps.plugin/integrations/applications.md)

- [Supervisor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/supervisord/integrations/supervisor.md)

- [User Groups](https://github.com/netdata/netdata/blob/master/src/collectors/apps.plugin/integrations/user_groups.md)

- [Users](https://github.com/netdata/netdata/blob/master/src/collectors/apps.plugin/integrations/users.md)

### Provisioning Systems

- [BOSH](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/bosh.md)

- [Cloud Foundry Firehose](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cloud_foundry_firehose.md)

- [Cloud Foundry](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cloud_foundry.md)

- [Spacelift](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/spacelift.md)

### Search Engines

- [Elasticsearch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/elasticsearch/integrations/elasticsearch.md)

- [Meilisearch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/meilisearch.md)

- [OpenSearch](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/elasticsearch/integrations/opensearch.md)

- [Sphinx](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/sphinx.md)

### Security Systems

- [Certificate Transparency](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/certificate_transparency.md)

- [ClamAV daemon](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/clamav_daemon.md)

- [Clamscan results](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/clamscan_results.md)

- [Crowdsec](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/crowdsec.md)

- [Honeypot](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/honeypot.md)

- [Lynis audit reports](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/lynis_audit_reports.md)

- [OpenVAS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/openvas.md)

- [Rspamd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/rspamd/integrations/rspamd.md)

- [SSL Certificate](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ssl_certificate.md)

- [Suricata](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/suricata.md)

- [Vault PKI](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/vault_pki.md)

### Service Discovery / Registry

- [Consul](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/consul/integrations/consul.md)

- [Kafka Consumer Lag](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kafka_consumer_lag.md)

- [ZooKeeper](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/zookeeper/integrations/zookeeper.md)

- [etcd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/etcd.md)

### Storage, Mount Points and Filesystems

- [Adaptec RAID](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/adaptecraid/integrations/adaptec_raid.md)

- [Altaro Backup](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/altaro_backup.md)

- [Borg backup](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/borg_backup.md)

- [CVMFS clients](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cvmfs_clients.md)

- [Ceph](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/ceph/integrations/ceph.md)

- [DMCache devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/dmcache/integrations/dmcache_devices.md)

- [Dell EMC Isilon cluster](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dell_emc_isilon_cluster.md)

- [Dell EMC ScaleIO](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/scaleio/integrations/dell_emc_scaleio.md)

- [Dell EMC XtremIO cluster](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dell_emc_xtremio_cluster.md)

- [Dell PowerMax](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/dell_powermax.md)

- [EOS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/eos.md)

- [Generic storage enclosure tool](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/generic_storage_enclosure_tool.md)

- [HDSentinel](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hdsentinel.md)

- [HPE Smart Arrays](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/hpssa/integrations/hpe_smart_arrays.md)

- [Hadoop Distributed File System (HDFS)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/hdfs/integrations/hadoop_distributed_file_system_hdfs.md)

- [IBM Spectrum Virtualize](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_spectrum_virtualize.md)

- [IBM Spectrum](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/ibm_spectrum.md)

- [IPFS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/ipfs/integrations/ipfs.md)

- [LVM logical volumes](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/lvm/integrations/lvm_logical_volumes.md)

- [Lagerist Disk latency](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/lagerist_disk_latency.md)

- [MegaCLI MegaRAID](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/megacli/integrations/megacli_megaraid.md)

- [MogileFS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mogilefs.md)

- [NVMe devices](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nvme/integrations/nvme_devices.md)

- [NetApp Solidfire](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/netapp_solidfire.md)

- [Netapp ONTAP API](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/netapp_ontap_api.md)

- [Samba](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/samba/integrations/samba.md)

- [Starwind VSAN VSphere Edition](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/starwind_vsan_vsphere_edition.md)

- [StoreCLI RAID](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/storcli/integrations/storecli_raid.md)

- [Storidge](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/storidge.md)

- [Synology ActiveBackup](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/synology_activebackup.md)

- [ZFS Pools](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/zfspool/integrations/zfs_pools.md)

### Synthetic Checks

- [Blackbox](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/blackbox.md)

- [Domain expiration date](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/whoisquery/integrations/domain_expiration_date.md)

- [HTTP Endpoints](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/httpcheck/integrations/http_endpoints.md)

- [IOPing](https://github.com/netdata/netdata/blob/master/src/collectors/ioping.plugin/integrations/ioping.md)

- [Idle OS Jitter](https://github.com/netdata/netdata/blob/master/src/collectors/idlejitter.plugin/integrations/idle_os_jitter.md)

- [Monit](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/monit/integrations/monit.md)

- [Ping](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/ping/integrations/ping.md)

- [Pingdom](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/pingdom.md)

- [Site 24x7](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/site_24x7.md)

- [TCP Endpoints](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/portcheck/integrations/tcp_endpoints.md)

- [Uptimerobot](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/uptimerobot.md)

- [X.509 certificate](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/x509check/integrations/x.509_certificate.md)

### System Clock and NTP

- [Chrony](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/chrony/integrations/chrony.md)

- [NTPd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/ntpd/integrations/ntpd.md)

- [Timex](https://github.com/netdata/netdata/blob/master/src/collectors/timex.plugin/integrations/timex.md)

### Systemd

- [Systemd Services](https://github.com/netdata/netdata/blob/master/src/collectors/cgroups.plugin/integrations/systemd_services.md)

- [Systemd Units](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/systemdunits/integrations/systemd_units.md)

- [systemd-logind users](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/logind/integrations/systemd-logind_users.md)

### Task Queues

- [Celery](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/celery.md)

- [Mesos](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/mesos.md)

- [Slurm](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/slurm.md)

### Telephony Servers

- [GTP](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gtp.md)

- [Kannel](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/kannel.md)

- [OpenSIPS](https://github.com/netdata/netdata/blob/master/src/collectors/charts.d.plugin/opensips/integrations/opensips.md)

### UPS

- [APC UPS](https://github.com/netdata/netdata/blob/master/src/collectors/charts.d.plugin/apcupsd/integrations/apc_ups.md)

- [Eaton UPS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/eaton_ups.md)

- [UPS (NUT)](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/upsd/integrations/ups_nut.md)

### VPNs

- [Fastd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/fastd.md)

- [Libreswan](https://github.com/netdata/netdata/blob/master/src/collectors/charts.d.plugin/libreswan/integrations/libreswan.md)

- [OpenVPN status log](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/openvpn_status_log/integrations/openvpn_status_log.md)

- [OpenVPN](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/openvpn/integrations/openvpn.md)

- [SoftEther VPN Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/softether_vpn_server.md)

- [Speedify CLI](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/speedify_cli.md)

- [Tor](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/tor/integrations/tor.md)

- [WireGuard](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/wireguard/integrations/wireguard.md)

- [strongSwan](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/strongswan.md)

### Web Servers and Web Proxies

- [APIcast](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/apicast.md)

- [Apache](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/apache/integrations/apache.md)

- [Clash](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/clash.md)

- [Cloudflare PCAP](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/cloudflare_pcap.md)

- [Envoy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/envoy/integrations/envoy.md)

- [Gobetween](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/gobetween.md)

- [HAProxy](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/haproxy/integrations/haproxy.md)

- [HHVM](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/prometheus/integrations/hhvm.md)

- [HTTPD](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/apache/integrations/httpd.md)

- [Lighttpd](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/lighttpd/integrations/lighttpd.md)

- [Litespeed](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/litespeed/integrations/litespeed.md)

- [NGINX Plus](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nginxplus/integrations/nginx_plus.md)

- [NGINX VTS](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nginxvts/integrations/nginx_vts.md)

- [NGINX](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/nginx/integrations/nginx.md)

- [PHP-FPM](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/phpfpm/integrations/php-fpm.md)

- [Squid log files](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/squidlog/integrations/squid_log_files.md)

- [Squid](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/squid/integrations/squid.md)

- [Tengine](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/tengine/integrations/tengine.md)

- [Tomcat](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/tomcat/integrations/tomcat.md)

- [Traefik](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/traefik/integrations/traefik.md)

- [Varnish](https://github.com/netdata/netdata/blob/master/src/collectors/python.d.plugin/varnish/integrations/varnish.md)

- [Web server log files](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/weblog/integrations/web_server_log_files.md)

- [uWSGI](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/uwsgi/integrations/uwsgi.md)

### Windows Systems

- [Active Directory](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/active_directory.md)

- [HyperV](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/hyperv.md)

- [MS Exchange](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/ms_exchange.md)

- [MS SQL Server](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/ms_sql_server.md)

- [NET Framework](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/net_framework.md)

- [Windows](https://github.com/netdata/netdata/blob/master/src/go/plugin/go.d/modules/windows/integrations/windows.md)
