(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49228,       1199]
NotebookOptionsPosition[     47714,       1168]
NotebookOutlinePosition[     48225,       1186]
CellTagsIndexPosition[     48182,       1183]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "PrintVector`"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4975401175502357`*^9, 3.497540122081654*^9}, {
   3.4975401577475357`*^9, 3.4975404433537083`*^9}, {3.497540482896634*^9, 
   3.4975405759100437`*^9}, {3.497541105993033*^9, 3.497541123798511*^9}, {
   3.497542050468046*^9, 3.497542062974934*^9}, {3.497542456642642*^9, 
   3.497542474403122*^9}, {3.497542524646307*^9, 3.497542533911161*^9}, {
   3.4975426113736467`*^9, 3.497542615636695*^9}, 3.49754300944394*^9, 
   3.497543161820746*^9, {3.4975433080968943`*^9, 3.497543333089579*^9}, {
   3.497634816866467*^9, 3.497634822396894*^9}, 3.497634889182472*^9, {
   3.4976349550362673`*^9, 3.497635002695628*^9}, {3.497635080038419*^9, 
   3.4976350905563173`*^9}, {3.497720303149754*^9, 3.497720340683272*^9}, 
   3.497720446950582*^9, {3.497720543770192*^9, 3.497720554263856*^9}, {
   3.497720624718094*^9, 3.4977206409163923`*^9}, {3.497720745653871*^9, 
   3.497720821394751*^9}, {3.497720852170191*^9, 3.497720892717999*^9}, {
   3.497720926142789*^9, 3.497720963010685*^9}, {3.49772100166604*^9, 
   3.4977210066482897`*^9}, {3.497721154131791*^9, 3.4977211732733927`*^9}, {
   3.497721253141778*^9, 3.497721260212431*^9}, {3.4977213873833313`*^9, 
   3.497721394326082*^9}, {3.4977214268766117`*^9, 3.497721450684969*^9}, 
   3.517368305980814*^9, 3.517368338946211*^9, {3.548337349389185*^9, 
   3.54833735124184*^9}},ExpressionUUID->"d08def02-380d-4a78-a040-\
650fbbaff617"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", "64"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Working", " ", 
    RowBox[{"precision", "."}]}], " ", "*)"}]}]], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.5173364544175253`*^9, 3.517336455143111*^9}, {
  3.548337583667452*^9, 
  3.548337584482711*^9}},ExpressionUUID->"e179aea0-64f1-4208-8170-\
a1b3afef541f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GenerateFilename", "[", "prefix_", "]"}], "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Length", "[", "NN", "]"}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Dimension", "."}], " ", "*)"}], "}"}], ",", 
    RowBox[{"Return", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"prefix", ",", 
        RowBox[{"\"\<nfct_\>\"", "<>", 
         RowBox[{"ToString", "[", "d", "]"}], "<>", "\"\<d_\>\"", "<>", 
         RowBox[{"StringJoin", "[", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"ToString", "[", "x", "]"}], "<>", "\"\<_\>\""}]}], 
              "]"}], ",", "NN"}], "]"}], "<>", 
           RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<.txt\>\""}], 
          "]"}]}]}], "}"}], "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GenerateFilenameAdjoint", "[", "prefix_", "]"}], "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"d", "=", 
      RowBox[{"Length", "[", "NN", "]"}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Dimension", "."}], " ", "*)"}], "}"}], ",", 
    RowBox[{"Return", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"prefix", ",", 
        RowBox[{"\"\<nfct_adjoint_\>\"", "<>", 
         RowBox[{"ToString", "[", "d", "]"}], "<>", "\"\<d_\>\"", "<>", 
         RowBox[{"StringJoin", "[", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"ToString", "[", "x", "]"}], "<>", "\"\<_\>\""}]}], 
              "]"}], ",", "NN"}], "]"}], "<>", 
           RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<.txt\>\""}], 
          "]"}]}]}], "}"}], "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Generate", "[", 
   RowBox[{"NN_", ",", "M_", ",", "FilenameGenerator_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Dimension", "."}], " ", "*)"}], "\[IndentingNewLine]", 
      "file"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"k", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"II", "[", 
       RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Outer", "[", 
         RowBox[{"List", ",", "II"}], "]"}], ",", 
        RowBox[{"d", "-", "1"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Index", " ", 
       RowBox[{"set", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"x", " ", "=", 
      RowBox[{"Transpose", "[", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", "M", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}], 
         RowBox[{"(*", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"1", "/", "4"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", "M"}], "}"}]}], "]"}], "*)"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", 
       RowBox[{"nodes", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"fhat", " ", "=", " ", 
      RowBox[{"(*", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"i", "\[Equal]", "3"}], ",", "1", ",", "0"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}], "*)"}], " ", 
      
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"Length", "[", "II", "]"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", "Fourier", " ", 
       RowBox[{"coefficients", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"fhat", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "*", 
           RowBox[{"Product", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"2", "*", "\[Pi]", "*", 
               RowBox[{
                RowBox[{"II", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], "[", 
                RowBox[{"[", "i", "]"}], "]"}], "*", 
               RowBox[{
                RowBox[{"x", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "M"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Function", " ", 
       RowBox[{"values", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"filename", "=", 
      RowBox[{"FilenameGenerator", "[", 
       RowBox[{"NN", ",", "M"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"file", " ", "=", " ", 
      RowBox[{"OpenWrite", "[", "filename", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "d", "]"}], " ", "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerVectorRaw", "[", "NN", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "M", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", 
         RowBox[{"Flatten", "[", "x", "]"}], "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "fhat", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "f", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Close", "[", "file", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", "filename", "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FileBaseName", "[", 
         RowBox[{"FileNameTake", "[", 
          RowBox[{"filename", ",", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", " ", 
        RowBox[{"FileNameTake", "[", 
         RowBox[{"filename", ",", 
          RowBox[{"-", "2"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GenerateAdjoint", "[", 
   RowBox[{"NN_", ",", "M_", ",", "FilenameGenerator_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Dimension", "."}], " ", "*)"}], "\[IndentingNewLine]", 
      "file"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"k", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "-", "1"}]}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"II", "[", 
       RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Outer", "[", 
         RowBox[{"List", ",", "II"}], "]"}], ",", 
        RowBox[{"d", "-", "1"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Index", " ", 
       RowBox[{"set", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"x", "=", 
      RowBox[{"Transpose", "[", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", "M", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", 
       RowBox[{"nodes", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"RandomReal", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "M", ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", "function", " ", 
       RowBox[{"values", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"fhat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "*", 
           RowBox[{"Product", "[", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"2", "*", "\[Pi]", "*", 
               RowBox[{
                RowBox[{"II", "[", 
                 RowBox[{"[", "k", "]"}], "]"}], "[", 
                RowBox[{"[", "i", "]"}], "]"}], "*", 
               RowBox[{
                RowBox[{"x", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "M"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", 
          RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Pseudo", " ", "Fourier", " ", 
       RowBox[{"coefficients", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"filename", "=", 
      RowBox[{"FilenameGenerator", "[", 
       RowBox[{"NN", ",", "M"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"file", " ", "=", " ", 
      RowBox[{"OpenWrite", "[", "filename", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "d", "]"}], " ", "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerVectorRaw", "[", "NN", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "M", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", 
         RowBox[{"Flatten", "[", "x", "]"}], "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "fhat", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "f", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Close", "[", "file", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", "filename", "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FileBaseName", "[", 
         RowBox[{"FileNameTake", "[", 
          RowBox[{"filename", ",", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", " ", 
        RowBox[{"FileNameTake", "[", 
         RowBox[{"filename", ",", 
          RowBox[{"-", "2"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeTestcase", "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Generate", "[", 
   RowBox[{"NN", ",", "M", ",", 
    RowBox[{"GenerateFilename", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<data\>\""}], "}"}],
       "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeTestcaseAdjoint", "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"GenerateAdjoint", "[", 
   RowBox[{"NN", ",", "M", ",", 
    RowBox[{"GenerateFilenameAdjoint", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<data\>\""}], "}"}],
       "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Formatter", "[", "x_", "]"}], ":=", 
   RowBox[{"\"\<&\>\"", "<>", "x"}]}], ";"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4975401175502357`*^9, 3.497540122081654*^9}, {
   3.4975401577475357`*^9, 3.4975404433537083`*^9}, {3.497540482896634*^9, 
   3.4975405759100437`*^9}, {3.497541105993033*^9, 3.497541123798511*^9}, {
   3.497542050468046*^9, 3.497542062974934*^9}, {3.497542456642642*^9, 
   3.497542474403122*^9}, {3.497542524646307*^9, 3.497542533911161*^9}, {
   3.4975426113736467`*^9, 3.497542615636695*^9}, 3.49754300944394*^9, 
   3.497543161820746*^9, {3.4975433080968943`*^9, 3.497543333089579*^9}, {
   3.497634816866467*^9, 3.497634822396894*^9}, 3.497634889182472*^9, {
   3.497635656084387*^9, 3.4976356567772627`*^9}, {3.4976358827461843`*^9, 
   3.497635902805756*^9}, {3.497639560178165*^9, 3.4976395887805*^9}, {
   3.497717629788444*^9, 3.497717664775313*^9}, {3.4977177954171267`*^9, 
   3.497717811441677*^9}, {3.497717946124824*^9, 3.4977179590024843`*^9}, {
   3.497718091880231*^9, 3.497718097174159*^9}, {3.4977181869580393`*^9, 
   3.4977182306418543`*^9}, {3.4977182817373667`*^9, 3.497718295439774*^9}, {
   3.4977185155717163`*^9, 3.497718516178872*^9}, {3.4977186098337307`*^9, 
   3.497718655031732*^9}, {3.497720354018293*^9, 3.497720361711935*^9}, {
   3.51646665501819*^9, 3.516466703700296*^9}, {3.516466744180666*^9, 
   3.516466850500287*^9}, {3.516466920776816*^9, 3.516466924558702*^9}, {
   3.5164671087352133`*^9, 3.516467132940102*^9}, {3.5164672595898933`*^9, 
   3.516467335735387*^9}, {3.516467446831277*^9, 3.5164675178909597`*^9}, {
   3.516467566236536*^9, 3.516467602081119*^9}, {3.516467646594492*^9, 
   3.516467693982851*^9}, {3.516467799630619*^9, 3.5164678145625057`*^9}, {
   3.516467907906891*^9, 3.516467931231696*^9}, {3.516467974227989*^9, 
   3.516468069686613*^9}, {3.5164681647268057`*^9, 3.516468322329309*^9}, {
   3.516468353208788*^9, 3.516468402515073*^9}, {3.516468569358057*^9, 
   3.5164688697654257`*^9}, {3.516469069967986*^9, 3.516469104912592*^9}, {
   3.516469281838047*^9, 3.516469282536112*^9}, {3.516469343196455*^9, 
   3.5164693448977213`*^9}, {3.516641118739716*^9, 3.51664112101792*^9}, {
   3.5170662585360413`*^9, 3.517066346582275*^9}, {3.517066422311091*^9, 
   3.517066427735291*^9}, {3.517068514164235*^9, 3.517068550246681*^9}, {
   3.517068593075931*^9, 3.5170685931933107`*^9}, {3.517068669073209*^9, 
   3.5170686693269997`*^9}, {3.517068780917268*^9, 3.5170688290906487`*^9}, {
   3.517068882706683*^9, 3.5170688831366453`*^9}, {3.517068913481579*^9, 
   3.517068922846977*^9}, {3.5170689796719627`*^9, 3.517068986237167*^9}, {
   3.517069122334919*^9, 3.517069164248382*^9}, {3.5170692558435507`*^9, 
   3.517069255983468*^9}, {3.517069318241144*^9, 3.517069318331732*^9}, {
   3.517069353096478*^9, 3.517069353285783*^9}, {3.517069394183385*^9, 
   3.51706939429727*^9}, {3.5170694669148607`*^9, 3.517069467074445*^9}, {
   3.517069521880518*^9, 3.517069561354265*^9}, {3.5170708977239847`*^9, 
   3.517070898060605*^9}, {3.517070929587063*^9, 3.517071052229973*^9}, {
   3.5170711918685713`*^9, 3.51707122081702*^9}, {3.5170712579552593`*^9, 
   3.517071258184224*^9}, {3.517073554532979*^9, 3.517073566800956*^9}, {
   3.51707363019388*^9, 3.5170736389107037`*^9}, {3.517073698959797*^9, 
   3.51707370067715*^9}, {3.5171618948918943`*^9, 3.5171619115024137`*^9}, {
   3.517250721250164*^9, 3.5172507217341347`*^9}, {3.5173346932505627`*^9, 
   3.517334838578896*^9}, {3.517334905472475*^9, 3.517334917950143*^9}, {
   3.517334957247117*^9, 3.517334978535076*^9}, {3.517335011733391*^9, 
   3.5173350406442137`*^9}, {3.5173351201064262`*^9, 3.517335137793874*^9}, {
   3.517335375660467*^9, 3.517335412963312*^9}, {3.517335455731798*^9, 
   3.517335551041175*^9}, {3.517335604376453*^9, 3.5173357376825*^9}, {
   3.517335798572322*^9, 3.51733580322344*^9}, {3.5173358514269238`*^9, 
   3.517335963393672*^9}, {3.517336003163329*^9, 3.517336058165167*^9}, {
   3.517336256363311*^9, 3.517336305265251*^9}, {3.51733636389287*^9, 
   3.517336367248146*^9}, {3.51733647413474*^9, 3.5173364746654367`*^9}, {
   3.517336559248983*^9, 3.517336561848617*^9}, {3.517367626541649*^9, 
   3.517367705336946*^9}, {3.517367791656136*^9, 3.517367810533764*^9}, {
   3.5173680054015837`*^9, 3.5173681448802223`*^9}, {3.517368202592416*^9, 
   3.517368212221806*^9}, {3.5173682793361473`*^9, 3.517368279723124*^9}, {
   3.517368363455708*^9, 3.517368401466815*^9}, {3.517368451212386*^9, 
   3.517368463409952*^9}, {3.517368495795951*^9, 3.517368510236106*^9}, {
   3.517368551091064*^9, 3.517368595286662*^9}, {3.517368631352521*^9, 
   3.5173686772721653`*^9}, {3.517383983727648*^9, 3.5173840466805964`*^9}, {
   3.517384159065975*^9, 3.517384167298918*^9}, {3.51738422514648*^9, 
   3.517384227338999*^9}, {3.518195295280732*^9, 3.518195305846961*^9}, {
   3.518195456601633*^9, 3.518195460327448*^9}, {3.518196187080405*^9, 
   3.518196205713777*^9}, 3.518196243875588*^9, {3.518197087019044*^9, 
   3.5181970888272057`*^9}, {3.548336163833386*^9, 3.548336166412342*^9}, {
   3.548336343704324*^9, 3.548336358860406*^9}, {3.5483364701780357`*^9, 
   3.548336484144067*^9}, {3.548336529883884*^9, 3.548336540969346*^9}, {
   3.548344607348515*^9, 3.548344608870598*^9}, {3.5912500481984653`*^9, 
   3.591250076895479*^9}, {3.591250218861248*^9, 3.591250226338402*^9}, {
   3.5912503577979517`*^9, 3.59125035946841*^9}, {3.591250425060781*^9, 
   3.5912504274191008`*^9}, {3.59125045807473*^9, 3.591250517668788*^9}, {
   3.5913636962940283`*^9, 3.591363696669777*^9}, {3.5913637412519007`*^9, 
   3.5913637418707523`*^9}, {3.591363784735084*^9, 3.5913637858698893`*^9}, {
   3.592188435538052*^9, 3.5921885183195467`*^9}, {3.592318134032817*^9, 
   3.592318145573595*^9}, {3.592319106996645*^9, 3.592319107070669*^9}, {
   3.5923191695725107`*^9, 3.5923191698321753`*^9}, {3.592319345047551*^9, 
   3.592319381468974*^9}, {3.592320322009972*^9, 3.5923203459587812`*^9}, {
   3.592320424194415*^9, 3.592320424408709*^9}, {3.5923204643719273`*^9, 
   3.592320464668322*^9}, {3.592320709306924*^9, 3.592320749880023*^9}, {
   3.5923221381469707`*^9, 3.5923221595925426`*^9}, 3.592322285620206*^9, {
   3.593188530743766*^9, 3.593188552283791*^9}, {3.5931886098703938`*^9, 
   3.593188613659782*^9}, {3.59318887481059*^9, 3.5931889151003733`*^9}, {
   3.593188946789352*^9, 3.593189039411675*^9}, 3.593189097027725*^9, {
   3.5931891428499613`*^9, 3.59318914310351*^9}, 
   3.593538366087583*^9},ExpressionUUID->"b2101191-5c90-41b4-9c90-\
8db0700c675a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"1", "D", " ", "Testcases", " ", "Trafo"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "10", ",", "25", ",", "50"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "25", ",", "50"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_1d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5173840443832397`*^9, 3.517384081724496*^9}, {
   3.517384180922477*^9, 3.517384425381447*^9}, {3.51767461454566*^9, 
   3.5176746284180737`*^9}, {3.517674660990048*^9, 3.517674671275931*^9}, {
   3.517674784712487*^9, 3.51767478525749*^9}, {3.517674879128593*^9, 
   3.517674881205332*^9}, {3.518114950576809*^9, 3.518114954403322*^9}, {
   3.518115098971106*^9, 3.5181151104874153`*^9}, {3.518194668914782*^9, 
   3.5181946821969357`*^9}, {3.518194734269782*^9, 3.518194735094262*^9}, {
   3.518194773462639*^9, 3.518194875034071*^9}, {3.518194949105473*^9, 
   3.518194987735242*^9}, 3.51819521869759*^9, {3.5181952521605186`*^9, 
   3.518195257942354*^9}, {3.518196034802575*^9, 3.5181960559626827`*^9}, {
   3.518196971634709*^9, 3.518197069048802*^9}, {3.5181975442351294`*^9, 
   3.518197547442575*^9}, {3.518197629827517*^9, 3.518197630432558*^9}, {
   3.5483363721060057`*^9, 3.548336382723646*^9}, {3.548336568717052*^9, 
   3.548336631597205*^9}, {3.548336745404522*^9, 3.5483368903217897`*^9}, {
   3.5483372613781643`*^9, 3.548337281078226*^9}, {3.548337760289608*^9, 
   3.548337791653308*^9}, {3.5483379559441223`*^9, 3.548337985056346*^9}, {
   3.548338045405122*^9, 3.54833809056406*^9}, {3.5483442863008347`*^9, 
   3.548344431490254*^9}, {3.548344516346612*^9, 3.54834452160181*^9}, {
   3.5483445634454823`*^9, 3.548344603589292*^9}, {3.548344673892972*^9, 
   3.548344674043014*^9}, {3.5912505876217327`*^9, 3.5912505881199083`*^9}, {
   3.591363841844906*^9, 3.5913638423075933`*^9}, {3.5915428347310057`*^9, 
   3.591542837929201*^9}, {3.592322290766035*^9, 3.59232229166604*^9}, {
   3.5931891661553383`*^9, 3.593189167918091*^9}, {3.59318930167062*^9, 
   3.593189306206168*^9}, {3.593189412013714*^9, 3.593189412511335*^9}, {
   3.59327456018216*^9, 3.5932745607433968`*^9}, {3.795609228118267*^9, 
   3.795609235329742*^9}},ExpressionUUID->"49d485e4-c4e0-4ba8-9f5d-\
106dd7a670ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"1", "D", " ", "Testcases", " ", "Adjoint"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "10", ",", "25", ",", "50"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "25", ",", "50"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_1d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.593189194755818*^9, 3.593189238850958*^9}, {
  3.593189308082303*^9, 3.593189312920251*^9}, {3.59318941509933*^9, 
  3.593189415475584*^9}, {3.59327453400912*^9, 3.593274534716311*^9}, {
  3.795609242580759*^9, 
  3.795609255351746*^9}},ExpressionUUID->"d2a5381d-472f-453f-a932-\
f7a47cd09f54"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"2", "D", " ", "Testcases", " ", "Trafo"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "25"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"25", ",", "50"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_2d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvc02e0uu2SvHjHfhW0H04oW39oNoCWG7OyA6f87u
5yB6TctFMJ1zdOI7EN3TOAdMb9z8SO1d/ivHPSVxWiCaJ2qjAYjetF3PBEQ/
NtG2BtFzVtjZguieu04q74F0wJJYVRBdnX5yddAhoL6052tA9JGNLk9BdPL7
MDBt89uALRhITznCyw6iNZIN5pw9/Mrx0Z4HYJprmvoxEF2jshZMq2yvMDsH
pN+x7bcA0beC9fxAtMPCff4gOs/4XP95ID3BeMsEEH3o97tPZUeB5j1j+Qyi
v06wZy0H0lfZfcC0yr+8gLnHgO5sywoE0av9PewWAOnJR2eA6bwPwjd73N84
LsnhuAWiAZosuqA=
  "],ExpressionUUID->"dea7cf02-1f30-4c55-913e-1d4543c63653"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"2", "D", " ", "Testcases", " ", "Adjoint"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "25"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"25", ",", "50"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_2d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.593189278068646*^9, 3.593189284894328*^9}, {
   3.593189420873682*^9, 3.593189421399495*^9}, {3.593275075595599*^9, 
   3.593275081980492*^9}, 3.593792151330961*^9, {3.593792207329873*^9, 
   3.593792219290654*^9}, {3.5937981230042877`*^9, 3.593798125037159*^9}, {
   3.79560930379634*^9, 3.795609304326085*^9}, {3.795611179882037*^9, 
   3.795611198537874*^9}},ExpressionUUID->"4c4bee33-f912-446b-8121-\
73fc9e4a3157"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"3", "D", " ", "Testcases", " ", "Trafo"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_3d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518197606681448*^9, 3.518197615153542*^9}, {
  3.5483451910722103`*^9, 3.5483452622079287`*^9}, {3.5483453352624826`*^9, 
  3.548345337453582*^9}, {3.548345370487627*^9, 3.5483453706498127`*^9}, {
  3.5483467419758577`*^9, 3.548346746749652*^9}, {3.548346925708653*^9, 
  3.5483469438417873`*^9}, {3.548347041873805*^9, 3.548347042368384*^9}, {
  3.5483471141121607`*^9, 3.54834711944681*^9}, {3.54834715646264*^9, 
  3.5483471569767027`*^9}, {3.548347414821805*^9, 3.548347416066527*^9}, {
  3.5915427341204157`*^9, 3.591542743990086*^9}, {3.591542788982143*^9, 
  3.5915427947782373`*^9}, {3.593189355304345*^9, 3.593189356127204*^9}, {
  3.593189426850175*^9, 3.5931894272246532`*^9}, {3.79561376224041*^9, 
  3.79561376955438*^9}},ExpressionUUID->"eae45701-73de-471e-a0a3-\
0b207837f8a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"3", "D", " ", "Testcases", " ", "Adjoint"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_3d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5931893517565947`*^9, 3.593189366525586*^9}, {
  3.593189429437948*^9, 3.593189429912216*^9}, {3.795613694297868*^9, 
  3.7956136952668867`*^9}, {3.7956137801241007`*^9, 
  3.795613780291707*^9}},ExpressionUUID->"21285066-2aa4-4471-8565-\
a30f9dc1c82d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"4", "D", " ", "Testcases", " ", "Trafo"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {setup_file,destroy_file,ABSPATH(\\\"\>\"", "<>", " ", 
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_4d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.548337660709242*^9, 3.5483376910598288`*^9}, {
   3.548347420747239*^9, 3.548347430447401*^9}, {3.591543705757052*^9, 
   3.591543710105554*^9}, {3.5915437905916433`*^9, 3.5915437911266193`*^9}, {
   3.591543853165766*^9, 3.591543856741955*^9}, {3.591545189200889*^9, 
   3.591545190137417*^9}, {3.593189432012995*^9, 3.593189432538142*^9}, 
   3.593274576174675*^9, {3.593538732977047*^9, 
   3.5935387337241173`*^9}},ExpressionUUID->"092b44c9-f8a7-4338-a439-\
701920cdc3df"]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1280.25, 672.75},
WindowMargins->{{6, Automatic}, {Automatic, 23.25}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.1 for Linux x86 (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b15b8f5e-681a-4dd8-8730-bce54c3c197c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1678, 28, 67, "Input",ExpressionUUID->"d08def02-380d-4a78-a040-650fbbaff617",
 InitializationCell->True,
 InitializationGroup->True],
Cell[2226, 50, 412, 12, 45, "Input",ExpressionUUID->"e179aea0-64f1-4208-8170-a1b3afef541f",
 InitializationCell->True,
 InitializationGroup->True],
Cell[2641, 64, 21782, 487, 1242, "Input",ExpressionUUID->"b2101191-5c90-41b4-9c90-8db0700c675a",
 InitializationCell->True,
 InitializationGroup->True],
Cell[24426, 553, 4628, 104, 216, "Input",ExpressionUUID->"49d485e4-c4e0-4ba8-9f5d-106dd7a670ee"],
Cell[29057, 659, 3031, 83, 216, "Input",ExpressionUUID->"d2a5381d-472f-453f-a932-f7a47cd09f54"],
Cell[32091, 744, 3105, 84, 216, "Input",ExpressionUUID->"dea7cf02-1f30-4c55-913e-1d4543c63653"],
Cell[35199, 830, 3083, 82, 216, "Input",ExpressionUUID->"4c4bee33-f912-446b-8121-73fc9e4a3157"],
Cell[38285, 914, 3437, 87, 216, "Input",ExpressionUUID->"eae45701-73de-471e-a0a3-0b207837f8a1"],
Cell[41725, 1003, 2915, 80, 216, "Input",ExpressionUUID->"21285066-2aa4-4471-8565-a30f9dc1c82d"],
Cell[44643, 1085, 3067, 81, 216, "Input",ExpressionUUID->"092b44c9-f8a7-4338-a439-701920cdc3df"]
}
]
*)

