/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_FORTUNES_GETTER_HPP_INCLUDED
#define yf_FORTUNES_GETTER_HPP_INCLUDED

#include <set>

#include <QString>

class UserProfile;

using std::set;

struct Fortune
{
	QString phrase;
	QString author;

	bool operator<(const Fortune& other) const;
};

class FortuneCatalog
{
 public:
	FortuneCatalog(const QString& path);

	void addFortune(const Fortune& fortune);
	bool wasSuchFortune(const Fortune& fortune) const;
 private:
	const QString path;
	set<Fortune> fortuneSet;
};

class FortunesGetter
{
 public:
	FortunesGetter(const UserProfile& profile);
	Fortune getFortune(const QString& pattern);
 private:
	const UserProfile& profile;
	FortuneCatalog fortuneCatalog;
};

#endif // yf_FORTUNES_GETTER_HPP_INCLUDED

