## Why use this?

JavaScript's native `Array.map()` is slow, and other popular array map libraries are focused on browser compatibility, which makes them bloated or less than idea for non-browser usage. This implementation is focused on node.js usage keeping it light and fast.


## Usage

```js
var map = require('{%= name %}');

map(['a', 'b', 'c'], function(ele) {
  return ele + ele;
});
//=> ['aa', 'bb', 'cc']

map(['a', 'b', 'c'], function(ele, i) {
  return i + ele;
});
//=> ['0a', '1b', '2c']
```
